/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.oss.service.oss;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.DownloadFileRequest;
import com.aliyun.oss.model.DownloadFileResult;
import com.aliyun.oss.model.OSSObject;
import com.zhiqim.oss.service.OssServer;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Urls;
import org.zhiqim.kernel.util.Validates;

public class OssDownloadService {
    private OssServer server = null;

    public OssDownloadService(OssServer server) {
        this.server = server;
    }

    public OssServer getServer() {
        return this.server;
    }

    public byte[] downloadByUrl(String url) throws Exception {
        if (!Validates.isUrl((String)url)) {
            throw new Exception("\u8bf7\u586b\u5199\u6b63\u786e\u7684\u4e0b\u8f7d\u5730\u5740,url=" + url);
        }
        url = url.replace("http://", "");
        url = url.replace("https://", "");
        String bucketName = Strings.substring((String)url, (int)0, (int)url.indexOf(".oss-cn"));
        String key = Strings.substring((String)url, (int)url.indexOf("/"), (int)url.length());
        key = Strings.removeStartsWith((String)key, (String)"/");
        if (Validates.isEmpty((String)bucketName) || Validates.isEmpty((String)key)) {
            throw new Exception("\u4e0b\u8f7d\u5730\u5740\u89e3\u6790\u9519\u8bef,bucketName=" + bucketName + ",key=" + key);
        }
        return this.downloadFileFlow(bucketName, key);
    }

    public void downloadBreakByUrl(String url, String filePath) throws Exception {
        if (!Validates.isUrl((String)url)) {
            throw new Exception("\u8bf7\u586b\u5199\u6b63\u786e\u7684\u4e0b\u8f7d\u5730\u5740,url=" + url);
        }
        url = url.replace("http://", "");
        url = url.replace("https://", "");
        String bucketName = Strings.substring((String)url, (int)0, (int)url.indexOf(".oss-cn"));
        String key = Strings.substring((String)url, (int)url.indexOf("/"), (int)url.length());
        key = Strings.removeStartsWith((String)key, (String)"/");
        if (Validates.isEmpty((String)bucketName) || Validates.isEmpty((String)key)) {
            throw new Exception("\u4e0b\u8f7d\u5730\u5740\u89e3\u6790\u9519\u8bef,bucketName=" + bucketName + ",key=" + key);
        }
        this.downloadFileBreak(bucketName, key, filePath);
    }

    public byte[] downloadFileFlow(String bucketName, String key) throws Exception {
        this.server.checkKey(key);
        if (this.server.isOssForward()) {
            String queryString = "bucketName=" + bucketName + "&key=" + key;
            return this.server.invokeForwardService(queryString);
        }
        OSSClient ossClient = null;
        try {
            ossClient = new OSSClient(this.server.getEndpointExternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret());
            OSSObject ossObject = ossClient.getObject(bucketName, key);
            InputStream input = ossObject.getObjectContent();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Streams.putBytes((InputStream)input, (OutputStream)output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (OSSException oe) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[OSSException]\uff1a" + oe.getErrorCode());
        }
        catch (ClientException ce) {
            throw new Exception("\u63a5\u53e3\u5f02\u5e38[ClientException]\uff1a" + ce.getErrorCode());
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }

    public byte[] downloadFileFlow(String queryString) throws Exception {
        String bucketName = Urls.get((String)queryString, (String)"bucketName");
        String key = Urls.get((String)queryString, (String)"key");
        if (Validates.isEmpty((String)bucketName) || Validates.isEmpty((String)key)) {
            throw new Exception("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0cbucketName=" + bucketName + ",key=" + key);
        }
        OSSClient ossClient = new OSSClient(this.server.getEndpointInternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret());
        OSSObject ossObject = ossClient.getObject(bucketName, key);
        InputStream input = ossObject.getObjectContent();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Streams.putBytes((InputStream)input, (OutputStream)output);
        ossClient.shutdown();
        return output.toByteArray();
    }

    public void downloadFileBreak(String bucketName, String key, String filePath) throws Exception {
        this.server.checkKey(key);
        OSSClient ossClient = null;
        try {
            try {
                ossClient = new OSSClient(this.server.getEndpointExternal(), this.server.getAccessKeyId(), this.server.getAccessKeySecret());
                DownloadFileRequest downloadFileRequest = new DownloadFileRequest(bucketName, key);
                downloadFileRequest.setDownloadFile(filePath);
                downloadFileRequest.setTaskNum(5);
                downloadFileRequest.setPartSize(0x100000L);
                downloadFileRequest.setEnableCheckpoint(true);
                try {
                    DownloadFileResult downloadFileResult = ossClient.downloadFile(downloadFileRequest);
                    downloadFileResult.getObjectMetadata();
                }
                catch (Throwable e) {
                    throw new Exception("\u6587\u4ef6" + filePath + "\u4e0b\u8f7d\u5931\u8d25", e);
                }
            }
            catch (OSSException oe) {
                throw new Exception("\u63a5\u53e3\u5f02\u5e38[OSSException]\uff1a" + oe.getErrorCode());
            }
            catch (ClientException ce) {
                throw new Exception("\u63a5\u53e3\u5f02\u5e38[ClientException]\uff1a" + ce.getErrorCode());
            }
        }
        finally {
            if (ossClient != null) {
                ossClient.shutdown();
            }
        }
    }
}

