/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.executor;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.LinkedMapSO;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.extend.MapSS;
import org.zhiqim.kernel.extend.TreeMapSO;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Sqls;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORMException;
import org.zhiqim.orm.ORMServer;
import org.zhiqim.orm.datasource.ZDBClose;
import org.zhiqim.orm.datasource.ZResultSet;
import org.zhiqim.orm.datasource.ZStatement;
import org.zhiqim.orm.dbo.CallParam;
import org.zhiqim.orm.dbo.CallResult;
import org.zhiqim.orm.dbo.Dbo;
import org.zhiqim.orm.executor.QueryExecutor;

public class CallExecutor {
    public final Log log = LogFactory.getLog(QueryExecutor.class);
    public final Log cSqlLog = LogFactory.getLog((String)"call.sql.log");

    public void execute(ORMServer server, Connection conn, String sql, List<CallParam> paramList, List<CallResult> resultList, MapSS replaceMap) throws ORMException, SQLException {
        ResultSet rst;
        CallableStatement cstmt;
        block18: {
            cstmt = null;
            rst = null;
            try {
                try {
                    CallParam param;
                    sql = Sqls.formatReplaceMap((String)sql, (MapSS)replaceMap);
                    cstmt = conn.prepareCall(sql);
                    int i = 0;
                    while (i < paramList.size()) {
                        param = paramList.get(i);
                        if (param.isInWrite()) {
                            ZStatement.setParameter(server, cstmt, i + 1, param.value());
                        } else {
                            cstmt.registerOutParameter(i + 1, param.typeSQL());
                        }
                        ++i;
                    }
                    if (server.isQuerySqlLog()) {
                        this.cSqlLog.info((Object)sql);
                    }
                    cstmt.execute();
                    i = 0;
                    while (i < paramList.size()) {
                        param = paramList.get(i);
                        if (param.isOutRead()) {
                            param.value(cstmt, i + 1);
                        }
                        ++i;
                    }
                    if (!Validates.isNotEmpty(resultList)) break block18;
                    int index = 0;
                    while ((rst = cstmt.getResultSet()) != null) {
                        CallResult callResult = resultList.get(index);
                        Class<?> resultClass = callResult.getResultClass();
                        if (server.isResultBase(resultClass)) {
                            callResult.setResultList(ZResultSet.parseToBase(rst, resultClass));
                        } else if (resultClass == Map.class || resultClass == MapSO.class || resultClass == HashMapSO.class || resultClass == LinkedMapSO.class || resultClass == TreeMapSO.class) {
                            callResult.setResultList(ZResultSet.parseToMap(rst, resultClass));
                        } else if (server.isDbo(resultClass)) {
                            Dbo resultDbo = server.getDbo(resultClass);
                            callResult.setResultList(ZResultSet.parseToDbo(rst, resultDbo));
                        } else {
                            throw new ORMException("\u8c03\u7528[\u51fd\u6570/\u5b58\u50a8\u8fc7\u7a0b]\u65f6\u4e0d\u652f\u6301\u7684\u7ed3\u679c\u96c6\u7c7b[" + resultClass + "]");
                        }
                        ZDBClose.close(rst);
                        rst = null;
                        if (cstmt.getMoreResults() && resultList.size() > ++index) continue;
                        break;
                    }
                }
                catch (SQLException e) {
                    this.log.error((Object)"CallExecutor[SQLException][%s][sql=%s]", (Throwable)e, new Object[]{e.getMessage(), sql});
                    throw e;
                }
                catch (Exception e) {
                    this.log.error((Object)"CallExecutor[Exception][%s]", (Throwable)e, new Object[]{e.getMessage()});
                    throw new ORMException(e.getMessage(), e);
                }
            }
            catch (Throwable throwable) {
                ZDBClose.close(rst, cstmt);
                throw throwable;
            }
        }
        ZDBClose.close(rst, cstmt);
    }
}

