/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.zhiqim.kernel.control.ThreadLock;
import org.zhiqim.kernel.control.Threadx;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Randoms;
import org.zhiqim.kernel.util.Threads;
import org.zhiqim.orm.datasource.ZConnection;
import org.zhiqim.orm.datasource.ZConnectionTester;

public class ZDataSource
extends Threadx
implements DataSource,
Runnable {
    private static final Log log = LogFactory.getLog((String)"database.log");
    private static final String JNDI = "jndi";
    private static final int CHK_TIME = 61000;
    private final ThreadLock lock = new ThreadLock();
    private String id = Randoms.lettersDigits((int)2);
    private List<ZConnection> connList = new ArrayList<ZConnection>(this.maxPoolSize);
    private String driver;
    private String url;
    private String user;
    private String pass;
    private int minPoolSize;
    private int maxPoolSize;
    private long maxKeepMilliTime;
    private long maxIdleMilliTime;
    private int maxCompletedCount;
    private boolean isChkConnOnTimer;
    private boolean isChkConnOnGet;
    private boolean isChkConnOnRelease;
    private int outOfConnWaitMilliTime;
    private int outOfConnRetryCount;
    private boolean isDbBreak;
    private ZConnectionTester tester;

    public ZDataSource(String driver, String url, String user, String pass, int minPoolSize, int maxPoolSize, int maxKeepTime) {
        this(driver, url, user, pass, minPoolSize, maxPoolSize, maxKeepTime, maxKeepTime, 100001, true, false, false, 5, 1);
    }

    public ZDataSource(String driver, String url, String user, String pass, int minPoolSize, int maxPoolSize, int maxKeepTime, int maxIdleTime, int maxCompletedCount, boolean isChkConnOnTimer, boolean isChkConnOnGet, boolean isChkConnOnRelease, int outOfConnWaitTime, int outOfConnRetryCount) {
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.pass = pass;
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.maxKeepMilliTime = maxKeepTime * 1000;
        this.maxIdleMilliTime = maxIdleTime * 1000;
        this.maxCompletedCount = maxCompletedCount;
        this.isChkConnOnTimer = isChkConnOnTimer;
        this.isChkConnOnGet = isChkConnOnGet;
        this.isChkConnOnRelease = isChkConnOnRelease;
        this.outOfConnWaitMilliTime = outOfConnWaitTime * 1000;
        this.outOfConnRetryCount = outOfConnRetryCount;
    }

    public String toString() {
        return "Database[" + this.url + ";" + "user:" + this.user + ";" + "min:" + this.minPoolSize + ";" + "max:" + this.maxPoolSize + ";" + "cur:" + this.getCurPoolSize() + ";" + "idle:" + this.getIdlePoolSize() + ";" + "maxKeepTime:" + this.maxKeepMilliTime / 1000L + ";" + "maxIdleTime:" + this.maxIdleMilliTime / 1000L + ";" + "maxCompletedCount:" + this.maxCompletedCount + ";" + "isChkOnTimer:" + this.isChkConnOnTimer + ";" + "isChkOnGet" + this.isChkConnOnGet + ";" + "isChkOnRelease:" + this.isChkConnOnRelease + ";" + "outOfConnWaitTime:" + this.outOfConnWaitMilliTime / 1000 + ";" + "outOfConnRetryCount:" + this.outOfConnRetryCount + "]";
    }

    protected String getThreadName() {
        return "ZDataSource-" + this.id;
    }

    protected boolean openBefore() {
        if (!this.createConnectionTester()) {
            return false;
        }
        this.deleteConnections();
        return this.createConnections();
    }

    protected void closeAfter() {
        this.deleteConnections();
        this.tester.shutdown();
        log.info((Object)"\u6570\u636e\u5e93[%s|%s]\u76d1\u89c6\u7ebf\u7a0b\u9000\u51fa", new Object[]{this.url, this.user});
    }

    protected void first() {
        Threads.sleepIgnoreException((int)61000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loop() {
        log.info((Object)this.toString());
        this.isDbBreak = this.tester.isDbBreak();
        if (this.isDbBreak) {
            this.deleteConnections();
            return;
        }
        int closeNum = 0;
        int initNum = 0;
        List<ZConnection> list = this.connList;
        synchronized (list) {
            Iterator<ZConnection> it = this.connList.iterator();
            while (it.hasNext()) {
                ZConnection conn = it.next();
                if (conn.isActive() || !conn.isClosed() && !conn.isOvertimeOrCompletedCount() && (!this.isChkConnOnTimer || conn.isConnectionAvailable())) continue;
                String connId = conn.getId();
                conn.shutdown();
                it.remove();
                conn = null;
                ++closeNum;
                log.info((Object)"\u76d1\u89c6\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5[%s][%s|%s]\u6210\u529f", new Object[]{connId, this.url, this.user});
            }
            int num = this.minPoolSize - this.connList.size();
            int i = 0;
            while (i < num) {
                ZConnection conn = this.newProxyConnection("\u8865\u8db3");
                if (conn != null) {
                    this.connList.add(conn);
                    ++initNum;
                }
                ++i;
            }
        }
        if (initNum > 0) {
            this.lock.unlock();
            log.info((Object)"DataBase[closeNum:%s;initNum:%s]", new Object[]{closeNum, initNum});
        }
        Threads.sleepIgnoreException((int)61000);
    }

    private boolean createConnectionTester() {
        block5: {
            if (this.tester != null) {
                this.tester.shutdown();
                this.tester = null;
            }
            try {
                Class cls;
                if (JNDI.equalsIgnoreCase(this.driver) || (cls = Classes.forName((String)this.driver)) != null) break block5;
                log.error((Object)"\u521d\u59cb\u5316\u6570\u636e\u5e93[%s|%s]\u8fde\u63a5\u6c60\uff0c\u672a\u627e\u5230\u9a71\u52a8\u7c7b[%s]", new Object[]{this.url, this.user, this.driver});
                return false;
            }
            catch (Exception e) {
                log.error((Object)"\u6570\u636e\u5e93[%s|%s]\u5f02\u5e38\u6216\u8bfb\u8d77\u521d\u59cb\u5316\u6570\u636e\u5f02\u5e38\uff1a%s", new Object[]{this.url, this.user, e.getMessage()});
                return false;
            }
        }
        this.tester = new ZConnectionTester(this);
        if (this.tester.isDbBreak()) {
            log.error((Object)"\u521d\u59cb\u5316\u6570\u636e\u5e93[%s|%s]\u8fde\u63a5\u6c60\uff0c\u53d1\u751f\u5f02\u5e38\uff1a\u8fde\u63a5\u88ab\u65ad\u5f00", new Object[]{this.url, this.user});
            return false;
        }
        return true;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection getConnection(int times) throws SQLException {
        List<ZConnection> list = this.connList;
        synchronized (list) {
            ZConnection conn;
            Iterator<ZConnection> it = this.connList.iterator();
            while (it.hasNext()) {
                ZConnection conn2 = it.next();
                if (conn2.isActive()) continue;
                if (conn2.isClosed() || conn2.isOvertimeOrCompletedCount() || this.isChkConnOnGet && !conn2.isConnectionAvailable()) {
                    String connId = conn2.getId();
                    conn2.shutdown();
                    it.remove();
                    conn2 = null;
                    log.info((Object)"\u83b7\u53d6\u5230\u5df2\u5173\u95ed\u6216\u8d85\u65f6\u6216\u8d85\u51fa\u8c03\u7528\u6570\u7684\u8fde\u63a5[%s][%s|%s]\u5173\u95ed\u6210\u529f", new Object[]{connId, this.url, this.user});
                    continue;
                }
                return conn2.active();
            }
            if (this.connList.size() < this.maxPoolSize && (conn = this.newProxyConnection("\u83b7\u53d6")) != null) {
                this.connList.add(conn);
                return conn.active();
            }
        }
        this.lock.lock((long)this.outOfConnWaitMilliTime);
        list = this.connList;
        synchronized (list) {
            for (ZConnection conn : this.connList) {
                if (!conn.isIdle()) continue;
                return conn.active();
            }
        }
        String fatal = "\u6570\u636e\u5e93\u8fde\u63a5[" + this.url + "|" + this.user + "]\u8fde\u63a5\u8017\u5c3d\uff0c[max:" + this.getMaxPoolSize() + ",cur:" + this.getCurPoolSize() + ",idle:" + this.getIdlePoolSize() + "]";
        if (times < this.outOfConnRetryCount) {
            log.fatal((Object)"%s[\u7b2c%s]", new Object[]{fatal, times + 1});
            return this.getConnection(times + 1);
        }
        log.fatal((Object)"%s[\u7b2c%s][\u5168\u90e8\u5931\u8d25\u629b\u51fa\u5f02\u5e38\u5230\u4e1a\u52a1\u5c42]", new Object[]{fatal, times + 1});
        throw new SQLException("\u6570\u636e\u5e93\u8fde\u63a5\u8017\u5c3d\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\u68c0\u67e5\u6570\u636e\u5e93\u662f\u5426\u6b63\u5e38\u5de5\u4f5c\u548c\u8fde\u63a5\u6c60\u914d\u7f6e\u662f\u5426\u8db3\u591f!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(ZConnection conn) {
        if (conn == null) {
            return;
        }
        if (conn.isClosed() || conn.isOvertimeOrCompletedCount() || this.isChkConnOnRelease && !conn.isConnectionAvailable()) {
            String connId = conn.getId();
            conn.shutdown();
            List<ZConnection> list = this.connList;
            synchronized (list) {
                this.connList.remove(conn);
            }
            conn = null;
            log.info((Object)"\u91ca\u653e\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5[%s][%s|%s]\u6210\u529f", new Object[]{connId, this.url, this.user});
            return;
        }
        conn.idle();
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean createConnections() {
        List<ZConnection> list = this.connList;
        synchronized (list) {
            int num = this.minPoolSize - this.connList.size();
            int i = 0;
            while (i < num) {
                ZConnection conn = this.newProxyConnection("\u521d\u59cb\u5316");
                if (conn == null) {
                    return false;
                }
                this.connList.add(conn);
                ++i;
            }
        }
        this.lock.unlock();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteConnections() {
        List<ZConnection> list = this.connList;
        synchronized (list) {
            Iterator<ZConnection> it = this.connList.iterator();
            while (it.hasNext()) {
                ZConnection conn = it.next();
                String connId = conn.getId();
                conn.shutdown();
                it.remove();
                conn = null;
                log.info((Object)"\u9500\u6bc1\u5173\u95ed\u6570\u636e\u5e93\u8fde\u63a5[%s][%s|%s]\u6210\u529f", new Object[]{connId, this.url, this.user});
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ZConnection newProxyConnection(String type) {
        try {
            Connection conn = null;
            if (JNDI.equalsIgnoreCase(this.driver)) {
                DataSource dataSource = (DataSource)new InitialContext().lookup(this.url);
                if (dataSource == null) {
                    return null;
                }
                dataSource.setLoginTimeout(10);
                conn = dataSource.getConnection();
            } else {
                DriverManager.setLoginTimeout(10);
                conn = DriverManager.getConnection(this.url, this.user, this.pass);
            }
            if (conn == null) {
                log.error((Object)"\u521b\u5efa\u6570\u636e\u5e93\u8fde\u63a5[%s|%s]\u5931\u8d25\uff0c[%s]", new Object[]{this.url, this.user, type});
                return null;
            }
            ZConnection connection = new ZConnection(this, conn);
            log.info((Object)"\u521b\u5efa\u6570\u636e\u5e93\u8fde\u63a5[%s][%s|%s]\u6210\u529f\uff0c[%s]", new Object[]{connection.getId(), this.url, this.user, type});
            return connection;
        }
        catch (SQLException e) {
            log.error((Object)"\u521b\u5efa\u6570\u636e\u5e93\u8fde\u63a5[%s|%s]\u65f6\uff0c\u53d1\u751f\u5f02\u5e38\uff1a[%s]", new Object[]{this.url, this.user, e.getMessage()});
            return null;
        }
        catch (Exception e) {
            log.error((Object)"\u521b\u5efa\u6570\u636e\u5e93\u8fde\u63a5[%s|%s]\u65f6\uff0c\u53d1\u751f\u5f02\u5e38\uff1a[%s]", new Object[]{this.url, this.user, e.getMessage()});
            return null;
        }
    }

    public boolean isDbBreak() {
        return this.tester.isDbBreak();
    }

    public String getId() {
        return this.id;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getCurPoolSize() {
        return this.connList.size();
    }

    public int getIdlePoolSize() {
        int size = 0;
        for (ZConnection conn : this.connList) {
            if (!conn.isIdle()) continue;
            ++size;
        }
        return size;
    }

    public int getMaxCompletedCount() {
        return this.maxCompletedCount;
    }

    public long getMaxKeepMilliTime() {
        return this.maxKeepMilliTime;
    }

    public long getMaxIdleMilliTime() {
        return this.maxIdleMilliTime;
    }

    public boolean isTestConnOnTimer() {
        return this.isChkConnOnTimer;
    }

    public boolean isTestConnOnGet() {
        return this.isChkConnOnGet;
    }

    public boolean isTestConnOnFree() {
        return this.isChkConnOnRelease;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setMaxKeepTime(long maxKeepTime) {
        this.maxKeepMilliTime = maxKeepTime * 1000L;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this.maxIdleMilliTime = maxIdleTime * 1000L;
    }

    public void setMaxCompletedCount(int maxCompletedCount) {
        this.maxCompletedCount = maxCompletedCount;
    }

    public void setTestConnOnTimer(boolean isTestConnOnTimer) {
        this.isChkConnOnTimer = isTestConnOnTimer;
    }

    public void setTestConnOnGet(boolean isTestConnOnGet) {
        this.isChkConnOnGet = isTestConnOnGet;
    }

    public void setTestConnOnFree(boolean isTestConnOnFree) {
        this.isChkConnOnRelease = isTestConnOnFree;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException("\u4e0d\u652f\u6301\u4f20\u5165\u7528\u6237\u540d\u548c\u5bc6\u7801\u83b7\u53d6\u8fde\u63a5");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return DriverManager.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        DriverManager.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        DriverManager.setLoginTimeout(seconds);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

