/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm.datasource;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.zhiqim.kernel.util.seqs.Sequence;
import org.zhiqim.orm.datasource.ZDBClose;
import org.zhiqim.orm.datasource.ZDataSource;

public class ZConnection
implements Connection {
    private static final Sequence sequence = new Sequence(6);
    private String connId = sequence.nextString();
    private ZDataSource dataSource;
    private Connection conn;
    private volatile boolean autoCommit;
    private volatile boolean closed;
    private volatile boolean isIdle;
    private volatile long idleMilliTime;
    private long keepMilliTime;
    private AtomicInteger completedCount;

    public ZConnection(ZDataSource dataSource, Connection conn) {
        this.dataSource = dataSource;
        this.conn = conn;
        try {
            this.autoCommit = conn.getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.autoCommit = true;
        }
        this.isIdle = true;
        this.keepMilliTime = this.idleMilliTime = System.currentTimeMillis();
        this.completedCount = new AtomicInteger();
    }

    public String getId() {
        return this.connId;
    }

    public boolean isIdle() {
        return !this.closed && this.isIdle;
    }

    public boolean isActive() {
        return !this.isIdle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZConnection active() {
        ZConnection zConnection = this;
        synchronized (zConnection) {
            this.isIdle = false;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void idle() {
        this.completedCount.incrementAndGet();
        ZConnection zConnection = this;
        synchronized (zConnection) {
            this.isIdle = true;
            this.idleMilliTime = System.currentTimeMillis();
        }
    }

    public boolean isOvertimeOrCompletedCount() {
        if (System.currentTimeMillis() - this.keepMilliTime > this.dataSource.getMaxKeepMilliTime()) {
            return true;
        }
        if (System.currentTimeMillis() - this.idleMilliTime > this.dataSource.getMaxIdleMilliTime()) {
            return true;
        }
        return this.completedCount.get() > this.dataSource.getMaxCompletedCount();
    }

    public boolean isConnectionAvailable() {
        if (this.conn == null) {
            return false;
        }
        ResultSet rst = null;
        try {
            DatabaseMetaData metaData = this.conn.getMetaData();
            rst = metaData.getTables(null, null, "PROBABLYNOT", new String[]{"TABLE"});
            ZDBClose.close(rst);
            return true;
        }
        catch (SQLException sQLException) {
            return false;
        }
        finally {
            ZDBClose.close(rst);
        }
    }

    public void setAutoCommit() {
        try {
            this.conn.setAutoCommit(this.autoCommit);
        }
        catch (SQLException sQLException) {}
    }

    void shutdown() {
        this.closed = true;
        try {
            if (!this.conn.isClosed()) {
                this.conn.close();
            }
        }
        catch (SQLException sQLException) {}
    }

    @Override
    public void close() throws SQLException {
        try {
            this.conn.clearWarnings();
        }
        catch (Exception exception) {}
        this.dataSource.releaseConnection(this);
    }

    public int getCompletedCount() {
        return this.completedCount.get();
    }

    public long getIdleMilliTime() {
        return this.idleMilliTime;
    }

    public long getKeepMilliTime() {
        return this.keepMilliTime;
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.conn.getHoldability();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.conn.getTransactionIsolation();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.conn.clearWarnings();
    }

    @Override
    public void commit() throws SQLException {
        this.conn.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    @Override
    public boolean isClosed() {
        if (this.closed) {
            return true;
        }
        try {
            return this.conn.isClosed();
        }
        catch (SQLException sQLException) {
            return true;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.conn.isReadOnly();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.conn.setHoldability(holdability);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.conn.setTransactionIsolation(level);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.autoCommit = autoCommit;
        this.conn.setAutoCommit(autoCommit);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.conn.setReadOnly(readOnly);
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.conn.getCatalog();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.conn.setCatalog(catalog);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn.getMetaData();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.conn.getWarnings();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.conn.setSavepoint();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.conn.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.conn.rollback(savepoint);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.conn.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.conn.getTypeMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.conn.setTypeMap(map);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.conn.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.conn.prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.conn.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.conn.prepareStatement(sql, autoGeneratedKeys);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.conn.prepareStatement(sql, columnIndexes);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.conn.setSavepoint(name);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.conn.prepareStatement(sql, columnNames);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.conn.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.conn.isWrapperFor(iface);
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.conn.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.conn.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.conn.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.conn.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.conn.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.conn.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.conn.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.conn.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.conn.getClientInfo();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.conn.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.conn.createStruct(typeName, attributes);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }
}

