/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.orm;

import java.io.File;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.config.Group;
import org.zhiqim.kernel.config.Item;
import org.zhiqim.kernel.extend.HashMapSS;
import org.zhiqim.kernel.extend.HashMapSV;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Resources;
import org.zhiqim.kernel.util.Systems;
import org.zhiqim.kernel.util.codes.Base64;
import org.zhiqim.kernel.util.codes.HEX;
import org.zhiqim.orm.ORMConstants;
import org.zhiqim.orm.ORMServer;
import org.zhiqim.orm.ORMType;
import org.zhiqim.orm.datasource.ZDataSource;

public class ORMParameter
implements ORMConstants {
    private String dbType;
    private String driver;
    private String url;
    private String user;
    private String pass;
    private int minPoolSize = 2;
    private int maxPoolSize = 10;
    private int maxKeepTime = 7001;
    private int maxIdleTime = 7001;
    private int maxCompletedCount = 100001;
    private String passType = null;
    private boolean isChkConnOnTimer = false;
    private boolean isChkConnOnGet = false;
    private boolean isChkConnOnRelease = false;
    private int outOfConnWaitTime = 5;
    private int outOfConnRetryCount = 1;
    private boolean isUpdateSqlLog = false;
    private boolean isQuerySqlLog = false;
    private HashMapSV<Integer> sqlMap = new HashMapSV();
    private HashMapSS cacheMap = new HashMapSS();

    public ORMParameter() {
    }

    public ORMParameter(Group group) {
        this.dbType = group.getString("dbType");
        this.driver = group.getString("driver");
        this.url = group.getString("url");
        this.user = group.getString("user");
        this.pass = group.getString("pass");
        this.passType = group.getString("passType");
        this.minPoolSize = group.getInt("minPoolSize", 2);
        this.maxPoolSize = group.getInt("maxPoolSize", 10);
        this.maxKeepTime = group.getInt("maxKeepTime", 7001);
        this.maxIdleTime = group.getInt("maxIdleTime", this.maxKeepTime);
        this.maxCompletedCount = group.getInt("maxCompletedCount", 100001);
        this.isChkConnOnTimer = group.isTrue("isChkConnOnTimer", false);
        this.isChkConnOnGet = group.isTrue("isChkConnOnGet", false);
        this.isChkConnOnRelease = group.isTrue("isChkConnOnRelease", false);
        this.outOfConnWaitTime = group.getInt("outOfConnWaitTime", 5);
        this.outOfConnRetryCount = group.getInt("outOfConnRetryCount", 1);
        this.isUpdateSqlLog = group.isTrue("isUpdateSqlLog", false);
        this.isQuerySqlLog = group.isTrue("isQuerySqlLog", false);
        Group grp = Global.getGroup((String)(String.valueOf(group.getId()) + ".sql"));
        if (grp != null) {
            for (Item item : grp.list()) {
                this.addSqlConfig(item.getKey(), item.getString());
            }
        }
        if ((grp = Global.getGroup((String)(String.valueOf(group.getId()) + ".cache"))) != null) {
            for (Item item : grp.list()) {
                this.addCacheConfig(item.getKey(), item.getString());
            }
        }
    }

    public ZDataSource newDatabase() {
        if ("HEX".equalsIgnoreCase(this.passType)) {
            this.pass = HEX.decrypt((String)this.pass);
        } else if ("Base64".equalsIgnoreCase(this.passType)) {
            this.pass = Base64.decodeUTF8((String)this.pass);
        }
        return new ZDataSource(this.driver, this.url, this.user, this.pass, this.minPoolSize, this.maxPoolSize, this.maxKeepTime, this.maxIdleTime, this.maxCompletedCount, this.isChkConnOnTimer, this.isChkConnOnGet, this.isChkConnOnRelease, this.outOfConnWaitTime, this.outOfConnRetryCount);
    }

    public int getDatabaseType() {
        return ORMType.getDatabaseType(this.dbType).value();
    }

    public boolean isOracle() {
        return this.getDatabaseType() == Z_ORM_ORACLE.value();
    }

    public boolean isMssql() {
        return this.getDatabaseType() == Z_ORM_MSSQL.value();
    }

    public boolean isSqlite() {
        return this.getDatabaseType() == Z_ORM_SQLITE.value();
    }

    public boolean isHsql() {
        return this.getDatabaseType() == Z_ORM_HSQL.value();
    }

    public boolean isMysql() {
        return this.getDatabaseType() == Z_ORM_MYSQL.value();
    }

    public String getDbName() {
        if (this.isMysql()) {
            if ("jndi".equalsIgnoreCase(this.driver)) {
                return this.user;
            }
            String dbUrl = this.url;
            int ind = dbUrl.indexOf("?");
            if (ind != -1) {
                dbUrl = dbUrl.substring(0, ind);
            }
            int ind2 = dbUrl.lastIndexOf("/");
            return dbUrl.substring(ind2 + 1);
        }
        return null;
    }

    public HashMapSV<Integer> getSqlConfig() {
        return this.sqlMap;
    }

    public void addSqlConfig(String key, String value) {
        int type = "file".equals(value) ? 0 : ("folder".equals(value) ? 1 : ("classpath".equals(value) ? 2 : ("package".equals(value) ? 3 : -1)));
        this.addSqlConfig(key, type);
    }

    public void addSqlConfig(String key, int type) {
        Asserts.notNull((Object)key, (String)"key");
        Asserts.as(type >= 0 && type <= 3 ? null : "\u589e\u52a0ORM\u7684SQL\u914d\u7f6e[" + key + "]\u7684\u7c7b\u578b\u4e0d\u6b63\u786e");
        switch (type) {
            case 0: {
                Asserts.as(key.endsWith(".sql.xml") ? null : "\u589e\u52a0ORM\u7684SQL\u914d\u7f6e[" + key + "]\u5fc5\u987b\u4ee5[.sql.xml]\u7ed3\u5c3e\u7684SQL\u914d\u7f6e\u6587\u4ef6\u540d");
                File file = new File(key);
                Asserts.as(file.isFile() && file.canRead() ? null : "\u589e\u52a0ORM\u7684SQL\u914d\u7f6e[" + key + "]\u5fc5\u987b\u662f\u6587\u4ef6\u5e76\u53ef\u8bfb");
                break;
            }
            case 1: {
                File folder = new File(key);
                Asserts.as(folder.isDirectory() && folder.canRead() ? null : "\u589e\u52a0ORM\u7684SQL\u914d\u7f6e[" + key + "]\u5fc5\u987b\u662f\u6587\u4ef6\u5939\u5e76\u53ef\u8bfb");
                break;
            }
            case 2: {
                Asserts.as(key.endsWith(".sql.xml") ? null : "\u589e\u52a0ORM\u7684SQL\u914d\u7f6e[" + key + "]\u5fc5\u987b\u4ee5[.sql.xml]\u7ed3\u5c3e\u7684SQL\u914d\u7f6e\u6587\u4ef6\u540d");
                Asserts.as(Resources.exists(ORMServer.class, (String)key) ? null : "\u589e\u52a0ORM\u7684SQL\u914d\u7f6e[" + key + "]\u5fc5\u987b\u662f\u6587\u4ef6\u5e76\u53ef\u8bfb");
                break;
            }
            case 3: {
                Asserts.as(Resources.exists(ORMServer.class, (String)key) ? null : "\u589e\u52a0ORM\u7684SQL\u914d\u7f6e[" + key + "]\u5fc5\u987b\u662f\u5b58\u5728");
            }
        }
        key = Systems.replacePropertyPath((String)key);
        this.sqlMap.put(key, (Object)type);
    }

    public void addCacheConfig(String key, String value) {
        this.cacheMap.put(key, value);
    }

    public HashMapSS getCacheConfig() {
        return this.cacheMap;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public boolean isUpdateSqlLog() {
        return this.isUpdateSqlLog;
    }

    public void setUpdateSqlLog(boolean isUpdateSqlLog) {
        this.isUpdateSqlLog = isUpdateSqlLog;
    }

    public boolean isQuerySqlLog() {
        return this.isQuerySqlLog;
    }

    public void setQuerySqlLog(boolean isQuerySqlLog) {
        this.isQuerySqlLog = isQuerySqlLog;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public String getPassType() {
        return this.passType;
    }

    public void setPassType(String passType) {
        this.passType = passType;
    }

    public int getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public int getMaxKeepTime() {
        return this.maxKeepTime;
    }

    public void setMaxKeepTime(int maxKeepTime) {
        this.maxKeepTime = maxKeepTime;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public int getMaxCompletedCount() {
        return this.maxCompletedCount;
    }

    public void setMaxCompletedCount(int maxCompletedCount) {
        this.maxCompletedCount = maxCompletedCount;
    }

    public boolean isChkConnOnTimer() {
        return this.isChkConnOnTimer;
    }

    public void setChkConnOnTimer(boolean isChkConnOnTimer) {
        this.isChkConnOnTimer = isChkConnOnTimer;
    }

    public boolean isChkConnOnGet() {
        return this.isChkConnOnGet;
    }

    public void setChkConnOnGet(boolean isChkConnOnGet) {
        this.isChkConnOnGet = isChkConnOnGet;
    }

    public boolean isChkConnOnRelease() {
        return this.isChkConnOnRelease;
    }

    public void setChkConnOnRelease(boolean isChkConnOnRelease) {
        this.isChkConnOnRelease = isChkConnOnRelease;
    }

    public int getOutOfConnWaitTime() {
        return this.outOfConnWaitTime;
    }

    public void setOutOfConnWaitTime(int outOfConnWaitTime) {
        this.outOfConnWaitTime = outOfConnWaitTime;
    }

    public int getOutOfConnRetryCount() {
        return this.outOfConnRetryCount;
    }

    public void setOutOfConnRetryCount(int outOfConnRetryCount) {
        this.outOfConnRetryCount = outOfConnRetryCount;
    }
}

