
/********************************************
*************** 素材操作 *********************
********************************************/
/** 创建svg素材 **/
function createSvgMaterial(svgCode, type)
{
    var mid_pos = media.getBgMaterialList(media.curPage).length;
    var $svg = Z(svgCode);
    var w = $svg[0].width.baseVal;
    var h = $svg[0].height.baseVal;
    try {
        w = w.value;
        h = h.value;
    } catch (error){
        return Z.alert('该素材代码有误，请修改后尝试！');
    }
    if (!w || !h) {
        return Z.alert('该素材代码有误，请修改后尝试！');
    }
    var oldw = w;
    var oldh = h;
    var oldRatio = oldw / oldh;
    //太大时，缩小素材；最大边为画布1/2
    if (w > media.getCurBg().width/2 || h > media.getCurBg().height/2){
        if (oldRatio > 1) {
            w = media.getCurBg().width/2;
            h = w / oldRatio;
        } else {
            h = media.getCurBg().height/2;
            w = h * oldRatio;
        }
    }
    //太小时，放大素材；最大边为画布1/4
    if (w < media.getCurBg().width/4 && h < media.getCurBg().height/4){
        if (oldRatio > 1) {
            w = media.getCurBg().width/4;
            h = w / oldRatio;
        } else {
            h = media.getCurBg().height/4;
            w = h * oldRatio;
        }
    }
    if (oldw !== w || oldh !== h){
        $svg.attr("width").baseVal.value = w;
        $svg.attr("height").baseVal.value = h;
        svgCode = $svg.htmls();
    }

    return new Z.Material(
    {
        $media: media,
        mediaId: media.canvas.mediaId,
        bid: media.curPage,
        mid: mid_pos,
        pos: mid_pos,
        type: type,
        status: 0,
        source: svgCode,
        fileId: null,
        paramKey: null,
        paramName: null,
        selected: true
    });
}
/** 新建媒体素材，指定素材属性 **/
function newMediaMaterial(material)
{
    var mid_pos = media.getBgMaterialList(media.curPage).length;
    return new Z.Material(
    {
        $media: media,
        mediaId: media.canvas.mediaId,
        bid: media.curPage,
        mid: mid_pos,
        pos: mid_pos,
        type: material.type,
        isTable: material.isTable || 0,
        source: material.source,
        fileId: material.fileId || null,
        angle: material.angle || 0,
        reversal: material.reversal || "1 1",
        transparency: material.transparency || 100,
        groupId: "",
        
        color: material.color || "#000000",
        fontSize: material.fontSize || 0,
        fontFamily: material.fontFamily || "微软雅黑",
        fontItalic: material.fontItalic || 0,
        text: material.text || "",
        textY: material.textY || (material.fontSize?(material.fontSize * .830512523651123):(0)),
        textDecoration: material.textDecoration || 0,
        underlineOffset: material.underlineOffset || 0,
        underlineThickness: material.underlineThickness || 0,
        letterSpacing: material.letterSpacing || 0,
        lineHeight: material.lineHeight || 0,
        mathHeight: material.mathHeight || 0,
        singleHeight: material.singleHeight || 0,
        fontWeight: material.fontWeight || 0,
        textZoom: material.textZoom || "1 1",
        wordsList: Z.clone(material.wordsList) || null,
        textVertical: material.textVertical || 'normal',
        textAlign: material.textAlign || 'left',
        textSpecial: material.textSpecial || "normal",
        textSpecialColor: material.textSpecialColor || "#000000",
        textSpecialSize: material.textSpecialSize || -1,

        imgRadius: material.imgRadius || 0,
    });
}
/** 新增svg代码：系统素材 **/
function addSvgCode(svgId)
{
    // 处理返回数据
    function analysisOfResponse(responseText)
    {
        // 添加通常 svg
        function addSvgNormal()
        {
            var materialType;
            switch (mediaSvg.catCode)
            {
                case 'image' : materialType = 0; break;
                case 'qcode' : materialType = 2; break;
                case 'text' : materialType = 1; break;
                case 'container' : materialType = 4; break;
                default : materialType = 3;
            }
            var svgMaterial = createSvgMaterial(svgCode, materialType);
            var $target = media.tool.createSvgCodeElement(svgMaterial);
            media.addMaterial(svgMaterial);
            selectTheElement(svgMaterial, $target);
        }
        // 选中新增素材
        function selectTheNew()
        {
            // 1：选择框
            selectTheElement_group();

            // 2：多个素材编组
            if (media.selectedList.length > 1) {
                doGroupCreate();
            }
        }

        // 1：定义变量
        var mediaSvg = Z.J.toObject(responseText);
        var svgCode = mediaSvg.svgCode;

        // 2：添加素材
        addSvgNormal();

        // 3：选中新增素材
        selectTheNew();

        // 4：保存历史
        saveHistory();
    }

    // 主方法，ajax 调用
    var ajax = new Z.Ajax();
    ajax.setClassName("MediaPresenter");
    ajax.setMethodName("getMediaSvg");
    ajax.addParam(svgId);
    ajax.setFailure(function(){Z.failure(this.responseText);});
    ajax.setSuccess(function(){analysisOfResponse(this.responseText);});
    ajax.execute();
}
/** 新增svg代码：自定义素材 **/
function addSvgCodeFromMine(svgId, doUseUserMaterial)
{
    if(typeof doUseUserMaterial === "function")
        doUseUserMaterial(svgId);
}
// 处理自定义返回数据
function analysisOfResponseMine(responseText)
{
    // 添加自定义类型 svg
    function addSvgSpecial()
    {
        // 添加 image
        function addSvgImage()
        {
            // 1：添加新素材
            addThisMaterial();
            // 2：重定义素材属性
            var $clipRect = $curElem.querySelector('clipPath[id^="radius_svgElementSon_"] > rect');
            var imgRadius = 0;
            if ($clipRect){
                imgRadius = parseFloat($clipRect.getAttribute('rx'));
            }
            material.type = 0;
            material.imgRadius = imgRadius;
        }
        // 添加 text
        function addSvgText()
        {
            // 1：添加新素材
            addThisMaterial();
            // 2：重定义素材属性
            material.type = 1;
            material.letterSpacing = parseFloat($curElem.getAttribute('data-letterspacing'));
            material.mathHeight = parseFloat($curElem.getAttribute('data-mathheight'));
            material.singleHeight = parseFloat($curElem.getAttribute('data-singleheight'));
            material.lineHeight = parseFloat($curElem.getAttribute('data-lineheight'));
            material.fontWeight = parseFloat($curElem.getAttribute('data-fontweight'));
            material.fontItalic = parseFloat($curElem.getAttribute('data-fontitalic'));
            material.underlineOffset = parseFloat($curElem.getAttribute('data-underlineoffset'));
            material.underlineThickness = parseFloat($curElem.getAttribute('data-underlinethickness'));
            material.textY = parseFloat($curElem.getAttribute('data-texty'));
            material.transparency = parseFloat($curElem.getAttribute('fill-opacity')) * 100;
            material.fontFamily = $curElem.getAttribute('data-fontfamily');
            material.fontSize = parseFloat($curElem.getAttribute('data-fontsize'));
            material.text = $curElem.getAttribute('data-text').replace(/-%6-%-%0-/g, '<');
            material.textAlign = $curElem.getAttribute('data-textalign');
            material.textZoom = $curElem.getAttribute('data-textzoom');
            material.textVertical = $curElem.getAttribute('data-textvertical');
            material.textSpecial = $curElem.getAttribute('data-textspecial');
            material.textSpecialColor = $curElem.getAttribute('data-textspecialcolor');
            material.textSpecialSize = $curElem.getAttribute('data-textspecialsize');
            var textDecoration;
            if ($curElem.querySelectorAll('.font-path line').length === $curElem.querySelectorAll('.font-path').length)
                textDecoration = 1;
            else
                textDecoration = 0;
            material.textDecoration = textDecoration;
            material.color = $curElem.querySelector('.font-path path').getAttribute('fill');
            var svgStroke = $svg.getAttribute('stroke');
            var svgStrokeWidth = $svg.getAttribute('stroke-width');
            if (svgStroke && svgStrokeWidth)
                material.stroke = svgStroke + ' ' + svgStrokeWidth;
            var $$gPath = $svg.querySelectorAll(".font-path");
            var textStr = material.text.replace(/(-%5-%-%5-)|\n/g, "");
            var pathLength = $$gPath.length;
            var textLength = textStr.length;
            var initWordsList = textLength !== pathLength;
            var j, $gPath, $path, pathW, pathI, pathD, pathT;
            material.wordsList = [];
            if (initWordsList)
            {
                for (j = 0;j < textLength;j++) {
                    material.wordsList.push({
                        'color': material.color,
                        'fontFamily': material.fontFamily,
                        'fontSize': material.fontSize,
                        'fontWeight': material.fontWeight,
                        'fontItalic': material.fontItalic,
                        'textDecoration': material.textDecoration,
                        'text': textStr[j],
                        'index': j,
                    });
                }
            }
            else
            {
                for (j = 0;j < pathLength;j++) {
                    $gPath = $$gPath[j];
                    $path = $gPath.querySelector('path');
                    pathW = $gPath.getAttribute("data-fontweight");
                    pathI = $gPath.getAttribute("data-fontitalic");
                    pathD = $gPath.getAttribute("data-textdecoration");
                    pathT = $gPath.getAttribute('data-text');
                    pathT = pathT && pathT.replace('-%6-%-%0-', '<');
                    material.wordsList.push({
                        'color': $path.getAttribute('fill'),
                        'fontFamily': $gPath.getAttribute("data-fontfamily"),
                        'fontSize': material.fontSize,
                        'fontWeight': pathW === null ? material.fontWeight : ((!/^\d$/.test(pathW)) ? 0 : (eval(pathW) ? 1 : 0)),
                        'fontItalic': pathI === null ? material.fontItalic : ((!/^\d$/.test(pathI)) ? 0 : (eval(pathI) ? 1 : 0)),
                        'textDecoration': pathD === null ? material.textDecoration : ((!/^\d$/.test(pathD)) ? 0 : (eval(pathD) ? 1 : 0)),
                        'text': pathT,
                        'index': j,
                    });
                }
            }
        }
        // 添加 container
        function addSvgContainer()
        {
            // 1：添加新素材
            addThisMaterial();
            // 2：重定义素材属性
            material.type = 4;
        }
        // 添加 shape
        function addSvgShape()
        {
            // 1：添加新素材
            addThisMaterial();
            // 2：重定义素材属性
            material.type = 5;
        }
        // 添加 pen
        function addSvgPen()
        {
            // 1：添加新素材
            addThisMaterial();
            // 2：重定义素材属性
            material.type = 5;
        }
        // 添加 svg
        function addSvgSvg()
        {
            // 1：添加新素材
            addThisMaterial();
            // 2：重定义素材属性
            material.type = 3;
        }
        // 添加 group
        function addSvgGroup()
        {
            // 1：判断是否是纯图片
            function isImage()
            {
                var $$g = $svg.children;
                var childrenLength = $$g.length;
                if (childrenLength < 1 || childrenLength > 2)
                    return false;
                var $g;
                if (childrenLength === 1) {
                    $g = $$g[0];
                    if ($g.tagName.toLowerCase() !== 'g')
                        return false;
                } else {
                    var $defs = $$g[0];
                    if ($defs.tagName.toLowerCase() !== 'defs')
                        return false;
                    if ($defs.children.length !== 1)
                        return false;
                    var $clipPath = $defs.children[0];
                    if ($clipPath.tagName.toLowerCase() !== 'clipPath' ||
                        !$clipPath.id || !/^radius_svgElementSon_/.test($clipPath.id))
                        return false;
                    $g = $$g[1];
                }
                var $$image = $g.children;
                if ($$image.length !== 1)
                    return false;
                if ($$image[0].tagName.toLowerCase() !== 'image')
                    return false;
                return true;
            }
            // 2：判断是否是文字
            function isText()
            {
                return $curElem.getAttribute('data-text');
            }
            // 3：判断是否是容器
            function isContainer()
            {
                return svgType && svgType === 'container';
            }
            // 4：判断是否是形状
            function isShape()
            {
                if (!svgType)
                    return false;
                var allShape = ['shape-line', 'shape-rect', 'shape-rectStroke', 'shape-ellipse'];
                return allShape.indexOf(svgType) > -1;
            }
            // 5：判断是否是钢笔
            function isPen()
            {
                return svgType && svgType === 'shape-pen';
            }

            doGroup = true;
            for(i = 0;i < childrenLength;i++)
            {
                $curElem = $$curElem[0];
                $svg = [...$curElem.querySelector('g').children].pop();
                svgType = $svg.getAttribute('data-type');

                // 1：纯图片
                if (isImage()) addSvgImage();
                // 2：文字
                else if (isText()) addSvgText();
                // 3：容器
                else if (isContainer()) addSvgContainer();
                // 4：形状
                else if (isShape()) addSvgShape();
                // 5：钢笔
                else if (isPen()) addSvgPen();
                // 5：通用
                else addSvgSvg();
            }
        }
        // 插入新素材
        function addThisMaterial()
        {
            // 计算素材偏移量
            function countCenterLocation()
            {
                var mx, my;
                if (doGroup)
                {
                    var wrapView = $thisSvg[0].viewBox.baseVal;
                    var canvasView = $canvasSvg.viewBox.baseVal;
                    var wrapMx = (canvasView.width - wrapView.width) / 2;
                    var wrapMy = (canvasView.height - wrapView.height) / 2;
                    var transVal = $curElem.transform.baseVal[0].matrix;
                    mx = transVal.e - wrapView.x + wrapMx;
                    my = transVal.f - wrapView.y + wrapMy;
                }
                else
                {
                    var canvasRect = $canvasSvg.getBoundingClientRect();
                    var elemRect = $curElem.getBoundingClientRect();
                    mx = (canvasRect.width - elemRect.width) / 2;
                    my = (canvasRect.height - elemRect.height) / 2;
                    mx /= showRatio;
                    my /= showRatio;
                }
                elemLoc = {'x' : mx, 'y' : my};
                elemTrans = elemTrans.replace(/translate\([^)]+\)/, 'translate(' + elemLoc.x + ' ' + elemLoc.y +')');
            }

            // 1：插入节点到画布
            var elemTrans = $curElem.getAttribute('transform');
            var $canvasSvg = media.tool.$canvasSvg;
            var $canvasMaterial = media.tool.$canvasMaterial;
            $canvasMaterial.appendChild($curElem);
            $gChild = $curElem.querySelector('g');
            $svg = [...$gChild.children].pop();
            svgViewBox = $svg.viewBox.baseVal;
            // 2：插入rect矩形
            $curElem.insertAdjacentHTML("afterbegin",'<rect fill="rgba(0,0,0,0)" width="0" height="0"></rect>');
            var $rect = $curElem.querySelector('rect');
            $rect.setAttribute('width', $svg.getAttribute('width'));
            $rect.setAttribute('height', $svg.getAttribute('height'));
            // 3：居中位置
            countCenterLocation();
            // 4：旋转
            rotate = $curElem.transform.baseVal[1].angle;
            // 5：翻转
            reversal = /scale\(([^)]+)\)/.exec($gChild.getAttribute('transform'));
            reversal = reversal && reversal[1] || '1 1';
            // 6：添加新素材
            material = newMediaMaterial({
                'width': svgViewBox.width,
                'height': svgViewBox.height,
                'x': elemLoc.x,
                'y': elemLoc.y,
                'angle': rotate,
                'reversal': reversal,
            });
            $curElem.setAttribute('transform', elemTrans);
            $curElem.setAttribute('id', 'svgElementSon_' + material.mid);
            $curElem.setAttribute('data-mid', material.mid);
            $curElem.setAttribute('data-pos', material.mid);
            updateMaterialSource(material, $curElem);
            media.addMaterial(material);
            // 7：添加素材操作事件
            media.tool.addEleEvents($curElem);
            // 8：选中列表
            media.selectedList.push(material.mid);
        }

        // 1：添加素材到画布
        var showRatio = media.tool.showRatio;
        var $$curElem = $thisSvg[0].children;
        var childrenLength = $$curElem.length;
        var $curElem = $$curElem[0];
        var doGroup = false;
        var $gChild, $svg, svgType, i, material,
            svgViewBox, elemLoc, rotate, reversal;
        media.selectedList = [];
        switch(thisType)
        {
            case 'image': addSvgImage();break;
            case 'text': addSvgText();break;
            case 'container': addSvgContainer();break;
            case 'shape-line':
            case 'shape-rect':
            case 'shape-rectStroke':
            case 'shape-ellipse': addSvgShape();break;
            case 'shape-pen': addSvgPen();break;
            case 'shape-table': console.log("添加表格类型素材！");break;
            case 'svg': addSvgSvg();break;
            case 'group': addSvgGroup();break;
            default: addSvgCode();
        }
    }
    // 选中新增素材
    function selectTheNew()
    {
        // 1：选择框
        media.tool.setTempCurrent();
        selectTheElement_group();
        // 2：多个素材编组
        if (media.selectedList.length > 1) {
            doGroupCreate();
        }
    }

    // 1：定义变量
    var mediaSvg = Z.J.toObject(responseText);
    var svgCode = mediaSvg.svgCode;
    var $thisSvg = Z(svgCode);
    var thisType = $thisSvg.attr('data-type');

    // 2：添加素材
    addSvgSpecial();

    // 3：选中新增素材
    selectTheNew();

    // 4：保存历史
    saveHistory();
}

/** 新增表格素材 **/
function addShapeTable()
{

}

/** 开始形状绘制 **/
function shapeDrawTrigger(elem)
{
    // 1：先判断是否存在钢笔编辑对象
    if (Z('#penEditorCover').hasClass('readyEdit')) {
        mediaEvent.penEditToolDone();
    }
    // 2：默认清空操作
    mediaEvent.frameBgDragClear();
    mediaEvent.cutImageToolHide();
    // 3：标识形状类型
    mediaEvent.shapeType = Z(elem).attr("data-type");
    // 4：分情况处理：开始还是结束
    if (Z(elem).hasClass("active"))
        shapeDrawStop();
    else
        shapeDrawReady(elem);
}
function shapeDrawStop()
{
    // 1：钢笔工具编辑中，完成编辑
    if (Z('#penEditorCover.readyEdit')[0]) {
        mediaEvent.penEditToolDone();
    }
    Z("#penTangentTool").removeClass("editPath").html('');

    // 2：通用的形状绘制，结束处理
    Z(".readyDrawing").removeClass("readyDrawing");
    Z("#side_shape .side_containerList li.active").removeClass("active");
    Z("#shapeContentMenu").hide();
    // 移除临时元素
    Z("#tempShape").remove();
}
function shapeDrawReady(elem)
{
    // 按钮样式、画布样式修改
    function setActiveStyle()
    {
        if (!elem) {
            return;
        }
        var drawCoverId = 'shapeEditorCover';
        var drawType = parseInt(elem.getAttribute('data-type'));
        Z("#side_shape .side_containerList li").removeClass("active");
        Z('.readyDrawing').removeClass('readyDrawing');
        Z(elem).addClass("active");

        if ([11, 12].indexOf(drawType) > -1){
            drawCoverId = 'penEditorCover';
        }
        Z.D.id(drawCoverId).className = 'readyDrawing';
    }

    // 1：样式设置
    setActiveStyle();
    Z("#tempShape").remove();

    // 2：插入临时节点
    var $gItem = media.tool.createNewSvgElement();
    var $svg = $gItem.querySelector("svg");
    var $gInner = $svg.querySelector("g");
    var $elemInner;
    var setView = "0 0 0 0";
    $gItem.setAttribute("id","tempShape");
    $svg.setAttribute("width","0");
    $svg.setAttribute("height","0");
    switch (mediaEvent.shapeType)
    {
        case "1":
            $elemInner = '<line stroke="#28a3ef" stroke-width="2" x1="0" y1="1" x2="0" y2="1" stroke-linecap="butt" stroke-dasharray="0 0"></line>';
            break;
        case "2":
            setView = "0 0 100 100";
            $elemInner = '<path class="shape-rect-path nw" fill="#28a3ef" d="M50,0 h-50 a0,0,0,0,1,0,0 v50 h50 v-50 Z" data-radius="0" data-type="0"></path>';
            $elemInner += '<rect class="shape-rect-path n" x="50" y="0" fill="#28a3ef" stroke="#28a3ef" stroke-width="0" width="0" height="50"></rect>';
            $elemInner += '<path class="shape-rect-path ne" fill="#28a3ef" d="M100,50 v-50 a0,0,0,0,1,0,0 h-50 v50 h50 Z" data-radius="0" data-type="0"></path>';
            $elemInner += '<rect class="shape-rect-path e" x="50" y="50" fill="#28a3ef" stroke="#28a3ef" stroke-width="0" width="50" height="0"></rect>';
            $elemInner += '<path class="shape-rect-path se" fill="#28a3ef" d="M50,100 h50 a0,0,0,0,1,0,0 v-50 h-50 v50 Z" data-radius="0" data-type="0"></path>';
            $elemInner += '<rect class="shape-rect-path s" x="50" y="50" fill="#28a3ef" stroke="#28a3ef" stroke-width="0" width="0" height="50"></rect>';
            $elemInner += '<path class="shape-rect-path sw" fill="#28a3ef" d="M0,50 v50 a0,0,0,0,1,0,0 h50 v-50 h-50 Z" data-radius="0" data-type="0"></path>';
            $elemInner += '<rect class="shape-rect-path w" x="0" y="50" fill="#28a3ef" stroke="#28a3ef" stroke-width="0" width="50" height="0"></rect>';
            $elemInner += '<rect class="shape-rect-path c" x="50" y="50" fill="#28a3ef" stroke="#28a3ef" stroke-width="2" width="0" height="0"></rect>';
            break;
        case "3":
            setView = "0 0 100 100";
            $elemInner = '<path class="shape-rect-path nw" fill="#28a3ef" d="M0,50 h5 v-45 h45 v-5 h-50 v50 Z" data-radius="0" data-type="0"></path>';
            $elemInner += '<path class="shape-rect-path ne" fill="#28a3ef" d="M50,0 v5 h45 v45 h5 v-50 h-50 Z" data-radius="0" data-type="0"></path>';
            $elemInner += '<path class="shape-rect-path se" fill="#28a3ef" d="M100,50 h-5 v45 h-45 v5 h50 v-50 Z" data-radius="0" data-type="0"></path>';
            $elemInner += '<path class="shape-rect-path sw" fill="#28a3ef" d="M50,100 v-5 h-45 v-45 h-5 v50 h50 Z" data-radius="0" data-type="0"></path>';
            break;
        case "4":
            $elemInner = '<ellipse fill="#28a3ef" fill-opacity="1" stroke-opacity="1" stroke="#28a3ef" stroke-width="0" cx="0" cy="0" rx="0" ry="0" stroke-dasharray="none"></ellipse>';
            break;
        case "11":
            $elemInner = '<path fill="#ffffff" stroke="#28a3ef" stroke-width="1" d="M0,0"></path>';
            break;
        case "12":
            break;
    }
    $svg.setAttribute("viewBox",setView);
    $gInner.insertAdjacentHTML("beforeend",$elemInner);
    media.tool.$canvasMaterial.appendChild($gItem);
}
/** 形状绘制右键菜单 **/
function shapeContextMenu(event)
{
    createContextMenu({
        "event": event,
        "elemId": "shapeContentMenu",
        "editItem": [
            ["退出绘制","shapeDrawStop"],
        ],
    });
}
/** 钢笔绘制右键菜单 **/
function penContextMenu(event)
{
    createContextMenu({
        "event": event,
        "elemId": "penContentMenu",
        "editItem": [
            ["完成绘制","mediaEvent.penDrawDone"],
            ["取消绘制","mediaEvent.penDrawCancel"],
        ],
    });
}

/** 新增指定属性的图片素材/二维码 **/
function newImage(imgMaterial, notSaveNew, fun)
{//新增图片，默认保存
    var mid_pos = media.getBgMaterialList(media.curPage).length;
    var image = new Z.Material({
        $media: media,
        mediaId: media.canvas.mediaId,
        bid: media.curPage,
        mid: imgMaterial.mid || mid_pos,
        pos: imgMaterial.mid || mid_pos,
        type: imgMaterial.type || 0,
        editorable: imgMaterial.editorable || 1, 
        status: 0,
        source: imgMaterial.source || "",
        fileId: imgMaterial.fileId,
        paramKey: null,
        paramName: null,
        selected: true
    });
    
    media.tool.createImgSvgElement(image, notSaveNew, fun);
}

/** 添加二维码 **/
function addQrcode(imageUrl)
{
    newImage({source: imageUrl, type: 2});
}
/** 新增容器 **/
function createSvgFrame($curElem)
{
    var svgCode = Z($curElem).html();
    svgCode = svgCode.replace(/\n/g,"");
    svgCode = Z.S.trim(svgCode);
    var svgMaterial = createSvgMaterial(svgCode, 4);         //容器
    var targ = media.tool.createSvgCodeElement(svgMaterial);
    media.addMaterial(svgMaterial);
    
    selectTheElement(svgMaterial, targ);
    saveHistory();
}

/************************************
********** 工具条的显示和隐藏 ********
*************************************/
/** 显示编辑工具 **/
function showEditToolbar ()
{
    // 显示图片编辑工具
    function showImageToolbar()
    {
        // 显示预设按钮
        showDefaultTools('image');

        // 锁定按钮状态
        resetLockToolBtn();
    }
    // 显示文字编辑工具
    function showTextToolbar()
    {
        // 文字编辑显示/取值
        function textAttributeBtn()
        {
            var material = media.tool.tempMaterial || media.getCurMaterial();
            if (!material)
                return;

            material.textVertical = material.textVertical || 'normal';
            material.textAlign = material.textAlign || 'left';

            // 加粗
            if (material.fontWeight) Z("#tool_fontWeight").addClass("active");
            else Z("#tool_fontWeight").removeClass("active");
            // 斜体
            if (material.fontItalic) Z("#tool_fontStyle").addClass("active");
            else Z("#tool_fontStyle").removeClass("active");
            // 下划线
            if (material.textDecoration) Z("#tool_fontDecoration").addClass("active");
            else Z("#tool_fontDecoration").removeClass("active");
            // 对齐
            Z('#tool_fontAlign .textAlign-btn')[0].className = 'textAlign-btn ' + material.textAlign;
            if (material.textVertical !== 'normal')
                Z('#tool_fontAlign').addClass('eventDisable');
            else
                Z('#tool_fontAlign').removeClass('eventDisable');
        }

        // 显示预设按钮
        showDefaultTools('text');
        // 字体状态按钮状态
        textAttributeBtn();
        // 侧边栏文字输入框
        Z("#sideTextEditor").addClass('active');

        // 颜色按钮状态
        resetColorToolBtn();

        // 文字类型、大小按钮状态
        resetFontToolBtn();

        // 锁定按钮状态
        resetLockToolBtn();
    }
    // 显示普通素材编辑工具
    function showSvgToolbar()
    {
        // 显示预设按钮
        showDefaultTools('svg');
        // 插入颜色工具
        insertColorBtn();

        // 颜色按钮状态
        resetColorToolBtn();

        // 锁定按钮状态
        resetLockToolBtn();
    }
    // 显示容器编辑工具
    function showFrameToolbar()
    {
        function setCutImage()
        {// 显示图片的裁剪功能，存在图片时可用
            var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
            var $image = $curElem.querySelector(".svgFrame-img image");
            var imageHref = $image ? $image.getAttribute("xlink:href") : "";
            if (/inc\/img\/container_default\.png$/.test(imageHref)) {
                Z("#tool_svgCut").hide();
            } else {
                Z("#tool_svgCut").show();
            }
        }
        // 显示预设按钮
        showDefaultTools('frame');
        // 裁剪按钮
        setCutImage();

        // 锁定按钮状态
        resetLockToolBtn();
    }
    // 显示形状编辑工具
    function showShapeToolbar()
    {
        // 获取子分类：line、rect、rectStroke、ellipse
        function setChildType()
        {
            var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
            var $svg = $curElem.querySelector("svg");
            childType = $svg.getAttribute("data-type");
        }
        // 插入表格类型，背景颜色按钮
        function insertTableBtn()
        {
            function getBtnStr(idMark, color, type, text)
            {
                return '<div id="tool_svgColor_' + idMark + '" style="background-color:' + color + ';" ' +
                    'class="tool-item tool-colorPicker' + (color.toLowerCase()==='none'?' bgNone':'') + '" ' +
                    'data-type="' + type + '" data-text="' + text + '" onmousedown="Z.E.forbidden(event);" onclick="showColorPickerBox(event);"></div>';
            }

            if (childType !== "shape-table")
                return;

            var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
            var $svg = $curElem.querySelector("svg");
            var textColor = rgb2hex(Z($svg).find("path").attr("fill") || "#000000");
            var bdColor = rgb2hex(Z($svg).find("line").attr("stroke") || "#000000");
            var bgColor = rgb2hex(Z($svg).find("rect").attr("fill") || "#ffffff");

            var $insertWrap = Z('#tool_insertAttr').html("");
            var $textColor = Z(getBtnStr("tableText", textColor, "tableText", "颜色"));
            var $bdColor = Z(getBtnStr("tableStroke", bdColor, "tableStroke", "边框"));
            var $bgColor = Z(getBtnStr("tableFill", bgColor, "tableFill", "背景"));
            var $bdSize = Z('<div id="tool_svgColor_tableBorder" class="tool-item" onclick="showShapeStrokeBox(event);" data-text="边框">边框</div>');
            $insertWrap.append($textColor).append($bdColor).append($bgColor).append($bdSize);
        }
        // 表格字体类型
        function resetTableFontToolBtn()
        {
            if (Z('#tool_fontFamily').isHide() || Z('#tool_fontSize').isHide())
                return;

            setFontSelectVal($firstTd.getAttribute("data-fontfamily"), 'tool_fontFamily');
            setFontSelectVal($firstTd.getAttribute("data-fontsize"), 'tool_fontSize');
        }
        // 表格字体样式设置
        function resetTableTextAttrBtn()
        {
            var fontWeight = parseFloat($firstTd.getAttribute("data-fontweight") || 0);
            var fontItalic = parseFloat($firstTd.getAttribute("data-fontitalic") || 0);
            var textDecoration = parseFloat($firstTd.getAttribute("data-textdecoration") || 0);
            var textAlign = $firstTd.getAttribute("data-textalign");

            // 加粗
            if (fontWeight) Z("#tool_fontWeight").addClass("active");
            else Z("#tool_fontWeight").removeClass("active");
            // 斜体
            if (fontItalic) Z("#tool_fontStyle").addClass("active");
            else Z("#tool_fontStyle").removeClass("active");
            // 下划线
            if (textDecoration) Z("#tool_fontDecoration").addClass("active");
            else Z("#tool_fontDecoration").removeClass("active");
            // 对齐
            Z('#tool_fontAlign .textAlign-btn')[0].className = 'textAlign-btn ' + textAlign;
            Z("#textAlign_box > .justify").addClass('zi-hide');
        }

        var childType = 'shape-line';
        // 显示预设按钮
        setChildType();
        showDefaultTools('shape', childType);

        // 插入表格属性按钮
        insertTableBtn();

        // 文字属性
        if (childType === "shape-table")
        {
            var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
            var $svg = $curElem.querySelector("svg");
            var $firstTd = $svg.querySelector("g[data-rowspan]");
            resetTableFontToolBtn();
            resetTableTextAttrBtn();
        }

        // 颜色按钮状态
        resetColorToolBtn();
        // 锁定按钮状态
        resetLockToolBtn();
    }
    // 显示群组编辑工具
    function showGroupToolbar()
    {
        // 1：编组按钮，2：颜色按钮，3：字体按钮显示，4：透明度，5：文字属性值
        function resetGroupToolBtn()
        {
            var equalNum = 0, firstMaterial = media.getCurMaterial(0);
            var groupId = (firstMaterial.groupId && firstMaterial.groupId.trim()) || '0';
            var isColor = true;                               // 颜色按钮标识
            var isText = true;                                // 字体按钮标识
            var textBold = firstMaterial.fontWeight;           // 粗体默认值
            var textItalic = firstMaterial.fontItalic;         // 斜体默认值
            var textUnderline = firstMaterial.textDecoration;  // 下划线默认值
            var textAlign = firstMaterial.textAlign;           // 对齐默认值
            var i, material;
            for (i = 0;i < media.selectedList.length;i++)
            {
                material = media.getCurMaterial(i);
                // 1：编组判断
                if (groupId === material.groupId) equalNum ++;

                // 2：颜色判断
                material.type = parseFloat(material.type);
                if (isColor && (material.type === 0 || material.type === 2 || material.type === 4)) isColor = false;

                // 3：字体判断 + 4：透明判断
                if (isText && material.type !== 1) isText = false;

                // 几个文字按钮状态判断
                if (firstMaterial.fontWeight !== material.fontWeight) textBold = 0;
                if (firstMaterial.fontItalic !== material.fontItalic) textItalic = 0;
                if (firstMaterial.textDecoration !== material.textDecoration) textUnderline = 0;
                if (firstMaterial.textAlign !== material.textAlign) textAlign = 'left';
            }
            // 1：编组设置
            if (equalNum === media.selectedList.length) {//显示取消按钮
                Z("#tool_groupSet").hide();
                Z("#tool_groupBreak").show();
            } else{    //显示编组按钮
                Z("#tool_groupSet").show();
                Z("#tool_groupBreak").hide();
            }

            // 2 ：颜色设置
            if (isColor) Z('#tool_svgColor').show();
            else  Z('#tool_svgColor').hide();

            // 3 + 4 + 5 ：字体设置、透明设置、文字属性值
            if (isText)
            {
                Z('.tool-textList.tool-groupList').show();
                // Z('#tool_opacity').show();

                // 加粗
                if (textBold) Z("#tool_fontWeight").addClass("active");
                else Z("#tool_fontWeight").removeClass("active");
                // 斜体
                if (textItalic) Z("#tool_fontStyle").addClass("active");
                else Z("#tool_fontStyle").removeClass("active");
                // 下划线
                if (textUnderline) Z("#tool_fontDecoration").addClass("active");
                else Z("#tool_fontDecoration").removeClass("active");
                // 对齐
                Z('#tool_fontAlign .textAlign-btn')[0].className = 'textAlign-btn ' + textAlign;
            } else {
                Z('.tool-textList.tool-groupList').hide();
                // Z('#tool_opacity').hide();
            }
        }

        // 显示预设按钮
        showDefaultTools('group');
        // 编组情况，依类型显示隐藏
        resetGroupToolBtn();

        // 颜色按钮状态
        resetColorToolBtn();

        // 文字类型、大小按钮状态
        resetFontToolBtn();

        // 锁定按钮状态
        resetLockToolBtn();
    }
    // 遍历所有按钮，显示预设的显示按钮
    function showDefaultTools(typeName, childType)
    {
        var $$tools = document.querySelectorAll('#toolbar_tollsWrap>.toolsWrap>div');
        var listClass = 'tool-' + typeName + 'List';
        var toolsList = toolBarObjList[typeName];
        var $itemTool, i, $$children, j, $child;
        childType = childType || '';
        toolsList = childType ? toolsList[childType]: toolsList;

        // 循环每一个按钮
        for (i = 0;i < $$tools.length;i++)
        {
            $itemTool = $$tools[i];
            if (Z($itemTool).hasClass(listClass) || toolsList.indexOf($itemTool.id) > -1) {
                Z($itemTool).show();
            } else {
                Z($itemTool).hide();
            }
        }

        // 插入类型到 toolbar_tollsWrap
        $toolsWrap.attr('data-type',typeName).attr('data-second',childType);
    }
    // 属性状态--颜色按钮
    function resetColorToolBtn()
    {
        // 设置颜色设置的对象类型
        function setColorType()
        {
            var dataType;
            if (media.selectedList.length > 1)
            {
                dataType = 'groupColor';
            }
            else
            {
                if (materialType === 1){
                    dataType = 'textFill';
                }
                else if (materialType === 5)
                {
                    switch (secondType)
                    {
                        case 'shape-line': dataType = 'lineFill'; break;
                        case 'shape-rect': dataType = 'rectFill'; break;
                        case 'shape-rectStroke': dataType = 'rectStrokeFill'; break;
                        case 'shape-ellipse': dataType = 'ellipseFill'; break;
                        case 'shape-pen': dataType = 'penFill'; break;
                        case 'shape-table': dataType = 'tableText'; break;
                    }
                }
            }
            $colorBtn.attr('data-type', dataType);
        }
        // 取得第一个素材的颜色属性
        function getFirstColor()
        {
            if (secondType === 'shape-line'){
                pathColor = $firstElem.querySelector('line').getAttribute('stroke');
            }
            else
            {
                for (i = 0;i < $$fill.length;i++)
                {
                    $path = $$fill[i];
                    if ($path.hasAttribute('opacity') && $path.getAttribute('opacity') !== '1'){
                        continue;
                    }
                    pathColor = $path.getAttribute('fill');
                    if (pathColor !== "rgba(0,0,0,0)"){
                        break;
                    }
                }
            }
            if (!pathColor){
                $colorBtn.hide();
            } else if (pathColor.toLowerCase() === 'none'){
                $colorBtn.addClass('bgNone').show();
            } else {
                $colorBtn.css('backgroundColor', pathColor).removeClass("bgNone").show();
            }
        }

        // 主方法
        var $colorBtn = Z('#tool_svgColor');
        if ($colorBtn.isHide() || media.selectedList.length === 0){
            return;
        }
        var firstMaterial = media.getCurMaterial(0);
        var $firstElem = media.tool.getSvgElementByMid(firstMaterial.mid);
        var $$svg = Z($firstElem.querySelector('g')).children('svg');
        var $svg = $$svg[$$svg.length - 1];
        var $$fill = $svg.querySelectorAll('[fill]');
        var materialType = parseFloat(firstMaterial.type);
        var secondType = $toolsWrap.attr('data-second');
        var i, pathColor, $path;

        // 1：循环遍历存在颜色属性的节点 [fill]
        getFirstColor();

        // 2：添加 data-type 属性，指定颜色对应素材类型
        setColorType();
    }
    // 属性状态--文字类型/文字大小状态
    function resetFontToolBtn()
    {
        if (Z('#tool_fontFamily').isHide() || Z('#tool_fontSize').isHide())
            return;

        var firstMaterial = media.getCurMaterial(0);
        setFontSelectVal(firstMaterial.fontFamily, 'tool_fontFamily');
        setFontSelectVal(firstMaterial.fontSize, 'tool_fontSize');
    }
    // 属性状态--锁定按钮
    function resetLockToolBtn()
    {
        if (Z('#tool_lock').isHide()){
            return;
        }
        var $lockBtn = Z('#tool_lock');
        var $iconFont = $lockBtn.find('.iconfont');
        var locked = true, i, material;

        // 查看所有素材状态
        for (i = 0;i < selectedLength;i++)
        {
            material = media.getCurMaterial(i);
            if (material.status !== 3){
                locked = false;
                break;
            }
        }

        // 依状态显示按钮
        if (locked) {
            $toolsWrapLeft.addClass("eventDisable");
            $lockBtn.removeClass("eventDisable").siblings().addClass("eventDisable");
            $iconFont.removeClass('icon-unlock').addClass('icon-lock').addClass('z-text-orange');
        } else {
            $toolsWrapLeft.removeClass("eventDisable");
            $lockBtn.parent().find('.tool-item').removeClass("eventDisable");
            $iconFont.removeClass('icon-lock').removeClass('z-text-orange').addClass('icon-unlock');
        }
    }
    // 工具条的展示，特殊按钮的复原
    function resetToolStyle()
    {
        // 展示整体
        $toolbar.addClass('active');
        // 侧边栏文字输入框
        Z("#sideTextEditor").removeClass('active');
        // 富文本编辑隐藏按钮
        Z(richTextHideId).show();
        // 右侧通用编辑工具
        $toolsWrapRight.removeClass('zi-hide');
        // 两端对齐按钮
        Z("#textAlign_box > .justify").removeClass('zi-hide');
    }

    // 主方法，定义变量
    var selectedLength = media.selectedList.length;
    var curMaterial;
    if (selectedLength <= 0) {
        return;
    }
    // 1：通用的显示隐藏
    resetToolStyle();

    // 2：依类型显示
    if (selectedLength === 1)
    {
        curMaterial = media.tool.tempMaterial || media.getCurMaterial();
        curMaterial.type = parseFloat(curMaterial.type);
        switch (curMaterial.type){
            case 1: showTextToolbar(); break;
            case 0:
            case 2: showImageToolbar(); break;
            case 3: showSvgToolbar(); break;
            case 4: showFrameToolbar(); break;
            case 5: showShapeToolbar(); break;
        }
    }
    else
    {
        showGroupToolbar();
    }
}
// 获取 svg 内可设置的颜色属性，插入颜色替换按钮
function insertColorBtn(maxLength)
{
    function getBtnStr(index, color, text)
    {
        return '<div id="tool_svgColor_' + index + '" style="background-color:' + color + ';" class="tool-item tool-colorPicker" ' +
            'data-type="svgFill" data-text="'+ text +'" onclick="showColorPickerBox(event);"></div>';
    }
    function insertPicker(pickerIndex, bgColor)
    {
        var indexArr = ('' + pickerIndex).split('_');
        var indexLength = indexArr.length;
        if (indexLength > 1 && indexLength > maxLength)
        {
            var startIndex = parseInt(pickerIndex);
            var endIndex = /_\d+$/.exec(pickerIndex)[0];
            pickerIndex = startIndex + endIndex;
            $btn = getBtnStr(pickerIndex, bgColor, '颜色');
            $insertWrap.append(Z($btn));
        }
        else
        {
            var i = 0;
            for (i;i < indexLength;i++)
            {
                $btn = getBtnStr(indexArr[i], bgColor, '颜色');
                $insertWrap.append(Z($btn));
            }
        }
    }

    maxLength = Math.abs(Z.T.isNumber(maxLength) ? maxLength : 8);
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    var $insertWrap = Z('#tool_insertAttr');
    var $$colorBtn = Z('#tool_insertAttr > [id^="tool_svgColor_"]');
    var listLength = $$colorBtn.length;
    var $$colorPath = $curElem.querySelectorAll("[fill]");
    var i, pathColor, baseColor, iStr, $btn, firstColor;
    for (i = 0;i < listLength;i++)
        $insertWrap[0].removeChild($$colorBtn[i]);
    listLength = $$colorPath.length;
    for (i = 0;i < listLength;i++)
    {
        if ($$colorPath[i].hasAttribute('opacity') && $$colorPath[i].getAttribute('opacity') !== '1')
            continue;
        pathColor = $$colorPath[i].getAttribute("fill").toLowerCase();
        if (pathColor === "rgba(0,0,0,0)" || pathColor === "none" || pathColor === "transparent")
            continue;
        if (!firstColor)
            firstColor = pathColor;
        if (!baseColor)
        {
            baseColor = pathColor;
            iStr = i;
            if (i === listLength - 1)
                insertPicker(iStr, baseColor);
            continue;
        }
        // 相邻、相同颜色，合并
        if (baseColor === pathColor)
        {
            iStr += '_' + i;
            if (i === listLength - 1)
                insertPicker(iStr, baseColor);
            continue;
        }
        insertPicker(iStr, baseColor);

        if (i === listLength - 1) {
            insertPicker(i, pathColor);
        } else {
            baseColor = pathColor;
            iStr = i;
        }
    }

    // 判断所有按钮
    var $$picker = $insertWrap.find('[id^=tool_svgColor_]');
    if ($$picker.length > 1)
    {
        $btn = getBtnStr('all', firstColor, '全部') +
            '<div id="tool_svgColor_space" class="z-float-left z-h30 z-mg-t8 z-mg-l3 z-mg-r5 z-bg-gray-deep z-event-none" style="width:2px;"></div>';
        $btn += '<div id="tool_svgColor_switch" class="z-float-left z-mg-t6 z-mg-r3">' +
            '   <a class="z-show-b z-lh16 z-px12" href="javascript:;" onclick="insertColorBtn(0);">合并</a>' +
            '   <a class="z-show-b z-lh16 z-px12" href="javascript:;" onclick="insertColorBtn(10000);">全显</a>' +
            '</div>' +
            '<div id="tool_svgColor_space2" class="z-float-left z-h30 z-mg-t8 z-mg-l3 z-mg-r5 z-bg-gray-deep z-event-none" style="width:2px;"></div>';
        $insertWrap[0].insertAdjacentHTML('afterbegin', $btn);
    }
}

/** 隐藏选中 **/
function hideEditSelected(isClear)
{
    if (isClear){
        media.clearSelected();
    }
    selectionAll_hide(true);
    hideToolbar();
}
/** 隐藏工具 **/
function hideToolbar()
{
    $toolbar.removeClass('active');

    // tempCurrent 重置为空
    media.tool.setTempCurrent();
}

/******************************************
 *********** 全局的按钮方法 **************
 ****************************************/
/** 1：全选 **/
function doGlobalSelect()
{
    media.doSelectedAll();
    selectTheElement_group();
}
/** 2：全部锁定 **/
function doGlobalLock()
{
    // 1：取消选中，清空选择列表
    hideEditSelected(true);

    // 2：循环锁定
    var i, material;
    for (i = 0;i < media.materialList.length;i++)
    {
        material = media.materialList[i];
        if (material.status !== 0)
            continue;
        material.status = 3;
    }

    // 3：提示
    Z.tips({text:'全部素材已锁定！',width:161});

    // 4：保存历史
    saveHistory();
}
/** 3：全部解锁 **/
function doGlobalUnlock()
{
    // 1：取消选中，清空选择列表
    hideEditSelected(true);

    // 2：循环解锁
    var i, material, $curElem;
    for (i = 0;i < media.materialList.length;i++)
    {
        material = media.materialList[i];
        if (material.status !== 3)
            continue;
        material.status = 0;

        // 背景属性去除
        if (material.bgMaterial)
        {
            material.bgMaterial = false;
            $curElem = media.tool.getSvgElementByMid(material.mid);
            $curElem.removeAttribute('data-bgmaterial');
        }
    }

    // 3：提示
    Z.tips({text:'全部素材已解锁！',width:161});

    // 4：刷新图层列表
    loadLayerList();

    // 5：保存历史
    saveHistory();
}
/** 4：清空画布 **/
function doGlobalClear()
{
    hideEditSelected(true);
    media.materialList = [];
    media.tool.$canvasMaterial.innerHTML = "";
    saveHistory();
}


/******************************************
 ********** 工具条的按钮方法 *************
 ****************************************/
/** 1：素材组编组 **/
function doGroupCreate()
{
    //创建唯一的 groupId
    var groupId = "group_" + new Date().getTime();

    //处理每个已选中素材
    var i, theMaterial, $theElem;
    for (i = 0;i < media.selectedList.length;i++){
        theMaterial = media.getCurMaterial(i);
        $theElem = media.tool.getCurSvgElement(i);
        theMaterial.groupId = groupId;
        $theElem.setAttribute("data-groupid", groupId);

        //刷新数据保存
        updateMaterialSource(theMaterial, $theElem);
    }

    //显示打散按钮
    Z('#tool_groupSet').hide();
    Z('#tool_groupBreak').show();

    //保存历史记录
    saveHistory();
}

/** 2：素材组打散 **/
function doGroupBreak()
{
    //处理每个已选中素材
    var i, theMaterial, $theElem;
    for (i = 0;i < media.selectedList.length;i++){
        theMaterial = media.getCurMaterial(i);
        $theElem = media.tool.getCurSvgElement(i);
        theMaterial.groupId = null;
        $theElem.removeAttribute("data-groupid");

        //刷新数据保存
        updateMaterialSource(theMaterial, $theElem);
    }

    //显示群组按钮
    Z('#tool_groupSet').show();
    Z('#tool_groupBreak').hide();

    //保存历史记录
    saveHistory();
}

/** 3：显示位置设置框 **/
function showMaterialPosBox(event)
{
    // 主方法
    // 1：定位输入框
    showMiniPopupBox(event, Z.D.id("material_pos_box"));

    // 2：设置输入框的值
    setPoxBoxValueInput();

    // 3：判断是否是特殊位置
    setPoxBoxSpecialBtn();

    // 4：针对素材组特殊处理
    saveGroupElemData();
}
// 填写位置输入框
function setPoxBoxValueInput(x, y)
{
    function getLeftTop()
    {// 取最左边、最上边的位置
        var leftArr = [], topArr= [];
        var canvasRect = media.tool.$canvasBg.getBoundingClientRect();
        var i, j, $curElem, transformList, elemRect, tempLeft, tempTop;
        for (i = 0;i < selectedLength;i++)
        {
            $curElem = media.tool.getCurSvgElement(i);
            if (selectedLength === 1)
            {
                transformList = $curElem.transform.baseVal;
                for (j = 0;j < transformList.length;j++){
                    if (transformList[j].type === 2){
                        tempLeft = transformList[j].matrix.e;
                        tempTop = transformList[j].matrix.f;
                        break;
                    }
                }
            } else {
                elemRect = $curElem.getBoundingClientRect();
                tempLeft = (elemRect.left - canvasRect.left) / showRatio;
                tempTop = (elemRect.top - canvasRect.top) / showRatio;
            }
            leftArr.push(tempLeft);
            topArr.push(tempTop);
        }
        x = getMinNum(leftArr);
        y = getMinNum(topArr);
    }

    // 主方法
    var selectedLength = media.selectedList.length;
    var showRatio = media.tool.showRatio;
    media.canvas.createMode = parseFloat(media.canvas.createMode);

    // 1：取值 x，y
    if (!x || !y)
    {
        getLeftTop();
        if(media.canvas.createMode === 0) {
            x = px2mm(x, media.canvas.dpi);
            y = px2mm(y, media.canvas.dpi);
        }
    }
    x = parseFloat(x.toFixed(4));
    y = parseFloat(y.toFixed(4));

    // 2：赋值
    Z("#material_x").val(x);
    Z("#material_y").val(y);
}
// 显示特殊位置按钮
function setPoxBoxSpecialBtn ()
{
    function setSpecialBtn()
    {// 设置特殊按钮样式，添加 active
        // 先取消所有
        $xBtns.removeClass('active');
        $yBtns.removeClass('active');

        // 赋值特定按钮
        if (xIndex > -1) {
            Z($xBtns[xIndex]).addClass("active");
        }
        if (yIndex > -1) {
            Z($yBtns[yIndex]).addClass("active");
        }
    }
    function getBtnIndex()
    {// 取得按钮索引
        function isActive (a, b){
            return Math.abs(a - b) < deviation;
        }
        var deviation = 2;
        if (isActive(canvasRect.left, targetRect.left)){
            xIndex = 0;
        }
        if (isActive(canvasRect.left + canvasRect.width / 2, targetRect.left + targetRect.width / 2)){
            xIndex = 1;
        }
        if (isActive(canvasRect.right, targetRect.right)){
            xIndex = 2;
        }
        if (isActive(canvasRect.top, targetRect.top)){
            yIndex = 0;
        }
        if (isActive(canvasRect.top + canvasRect.height / 2, targetRect.top + targetRect.height / 2)){
            yIndex = 1;
        }
        if (isActive(canvasRect.top + canvasRect.height, targetRect.top + targetRect.height)){
            yIndex = 2;
        }
    }

    // 主方法
    var $xBtns = Z("#material_pos_box > .sizeeditor:nth-child(1) > .setLocAlign>span");
    var $yBtns = Z("#material_pos_box > .sizeeditor:nth-child(2) > .setLocAlign>span");
    var canvasRect = media.tool.$canvasBg.getBoundingClientRect();
    var targetRect;
    var xIndex = -1 , yIndex = -1, i = 0;

    // 1：取得所有素材，设置 targetRect 对象
    targetRect = getSelectedElemRect();

    // 2：依据 rect 获取 xIndex，yIndex
    getBtnIndex();

    // 3：赋值特定按钮
    setSpecialBtn();
}
// 素材组的情况，保存数据
function saveGroupElemData()
{
    var dataArr = [];
    var i, j, mid, $elem, elemRect, transformList, e, f;
    for (i = 0;i < media.selectedList.length;i++)
    {
        mid = media.selectedList[i];
        $elem = media.tool.getCurSvgElement(i);
        elemRect = $elem.getBoundingClientRect();
        transformList = $elem.transform.baseVal;
        for (j = 0;j < transformList.length;j++){
            if (transformList[j].type === 2){
                e = transformList[j].matrix.e;
                f = transformList[j].matrix.f;
                break;
            }
        }
        //保存数据
        dataArr.push({
            "index": i,
            "mid": mid,
            "left": e,
            "top": f,
        });
    }
    mediaEvent.startData.elemsData = dataArr;

    var x = Z('#material_x').val();
    var y = Z('#material_y').val();
    if(media.canvas.createMode === 0)
    {//毫米
        x = mm2px(x, media.canvas.dpi);
        y = mm2px(y, media.canvas.dpi);
    }
    x = parseFloat(x.toFixed(4));
    y = parseFloat(y.toFixed(4));
    mediaEvent.startData.targData = {
        "x": x,
        "y": y,
    }
}
// 获取素材的 rect 对象：包含 width、height、left、top
function getSelectedElemRect()
{
    var topArr= [], rightArr= [], bottomArr= [], leftArr = [];
    var i, material, $curElem, $rect, elemRect;
    for (i = 0;i < media.selectedList.length;i++)
    {
        material = media.getCurMaterial(i);
        $curElem = media.tool.getSvgElementByMid(material.mid);
        $rect = $curElem.querySelector('rect');
        elemRect = $rect.getBoundingClientRect();
        topArr.push(elemRect.top);
        rightArr.push(elemRect.right);
        bottomArr.push(elemRect.bottom);
        leftArr.push(elemRect.left);
    }
    return {
        'left' : getMinNum(leftArr),
        'top' : getMinNum(topArr),
        'width' : getMaxNum(rightArr) - getMinNum(leftArr),
        'height' : getMaxNum(bottomArr) - getMinNum(topArr),
    }
}
/** 3.1：位置设置---输入框变化 **/
function doChangeMaterialPos()
{
    function changeGroupPos()
    {// 修改素材组的位置
        var targetData = mediaEvent.startData.targData;
        var elemDataArr = mediaEvent.startData.elemsData;
        var mx = x - targetData.x;
        var my = y - targetData.y;
        var i = 0, material, $curElem,trans;
        for (i;i < elemDataArr.length;i++)
        {
            material = media.getCurMaterial(i);
            $curElem = media.tool.getCurSvgElement(i);

            material.x += mx;
            material.y += my;

            trans = $curElem.getAttribute("transform");
            trans = trans.replace(/translate\([^)]+\)/,"translate(" + material.x + " " + material.y + ")");
            $curElem.setAttribute("transform",trans);
            updateMaterialSource(material, $curElem);
        }
        saveGroupElemData();
        // 刷新选中框
        selectionToolsShow_group();
    }

    // 主方法
    var selectedLength = media.selectedList.length;

    // 1：取得 x，y 的像数值
    var x = Z("#material_x").val();
    var y = Z("#material_y").val();
    if(media.canvas.createMode === 0)
    {//毫米
        x = mm2px(x, media.canvas.dpi);
        y = mm2px(y, media.canvas.dpi);
    }
    x = parseFloat(x.toFixed(4));
    y = parseFloat(y.toFixed(4));

    // 2：分情况赋值
    if (selectedLength === 1) {
        updateMaterialPos(x, y);
    } else if (selectedLength > 1) {
        changeGroupPos();
    }

    // 3：校验特殊按钮
    setPoxBoxSpecialBtn();

    // 4：保存
    saveHistory();
}
/** 3.2：位置设置---特殊位置设置（上、下、左、右、中） **/
function doSetMaterialPos(type)
{
    // 设置每个素材的偏移
    function setEachElem()
    {
        var i, j, elemTransList, elemMatrix, trans;
        for(i = 0;i < media.selectedList.length;i++)
        {
            material = media.getCurMaterial(i);
            $curElem = media.tool.getCurSvgElement(i);
            elemTransList = $curElem.transform.baseVal;
            for(j = 0;j < elemTransList.length;j++)
            {
                if (elemTransList[j].type === 2){
                    elemMatrix = elemTransList[j].matrix;
                    break;
                }
            }
            material.x = elemMatrix.e + move_x;
            material.y = elemMatrix.f + move_y;
            trans = $curElem.getAttribute('transform');
            trans = trans.replace(/translate\s?\([^)]+\)/, 'translate(' + material.x + ' ' + material.y + ')');
            $curElem.setAttribute('transform', trans);

            // 刷新source
            updateMaterialSource(material, $curElem);
        }
    }

    // 主方法
    var material, $curElem;
    var canvasRect = media.tool.$canvasBg.getBoundingClientRect();
    var showRatio = media.tool.showRatio;
    var targetRect;

    // 1：获取素材的 targetRect 参数
    targetRect = getSelectedElemRect();

    // 2：获取理论偏移量
    var move_x = 0, move_y = 0;
    var x = targetRect.left - canvasRect.left;
    var y = targetRect.top - canvasRect.top;
    switch (type)
    {
        case "left":
            x = 0;
            move_x = canvasRect.left - targetRect.left;
            break;
        case "center":
            x = (canvasRect.width - targetRect.width) / 2;
            move_x = x + canvasRect.left - targetRect.left;
            break;
        case "right":
            x = (canvasRect.width - targetRect.width);
            move_x = x + canvasRect.left - targetRect.left;
            break;
        case "top":
            y = 0;
            move_y = canvasRect.top - targetRect.top;
            break;
        case "middle":
            y = (canvasRect.height - targetRect.height) / 2;
            move_y = y + canvasRect.top - targetRect.top;
            break;
        case "bottom":
            y = canvasRect.height - targetRect.height;
            move_y = y + canvasRect.top - targetRect.top;
            break;
    }
    x /= showRatio;
    y /= showRatio;
    move_x /= showRatio;
    move_y /= showRatio;
    if(media.canvas.createMode === 0) {
        x = px2mm(x, media.canvas.dpi);
        y = px2mm(y, media.canvas.dpi);
    }

    // 3：处理每个素材的偏移
    setEachElem();

    // 4：更新选中框、输入框的值
    selectionToolsShow_group();
    setPoxBoxValueInput(x, y);

    // 5：保存历史
    saveHistory();
}

/** 4：显示素材尺寸设置 **/
function showItemSizeBox(event)
{
    // 设置弹出框的显示名称
    function setSizeSetBoxName()
    {
        var typeObj = svgTypeToName[materialType];

        // 标题
        if (secondType){
            typeObj = typeObj[secondType];
        }
        boxTitle = typeObj.name || boxTitle;
        boxTitle += '设置';

        // 输入框名称
        widthName = typeObj.width || widthName;
        heightName = typeObj.height || heightName;

        // 设置
        $posBox.find('.sizeSet-title').html(boxTitle);
        $posBox.find('.sizeSet-width > .sizeSet-name').html(widthName);
        $posBox.find('.sizeSet-height > .sizeSet-name').html(heightName);
    }
    // 赋值输入框
    function setSizeSetBoxValueInput()
    {
        svgWidth = $svg.width.baseVal.value;
        svgHeight = $svg.height.baseVal.value;

        if (secondType === 'shape-line') {
            var $line = $curElem.querySelector("svg>g>line");
            svgWidth = $line.getAttribute("x2");
            svgHeight = $line.getAttribute("stroke-width");
        }

        if(media.canvas.createMode === 0)
        {//像素转毫米
            svgWidth = px2mm(svgWidth, media.canvas.dpi);
            svgHeight = px2mm(svgHeight, media.canvas.dpi);
        }
        Z('#svgSize_width').val(svgWidth);
        Z('#svgSize_height').val(svgHeight);
    }
    // 锁定宽高属性，写入锁定比
    function setLockScale()
    {
        $lockWrap.attr('data-scale', svgWidth / svgHeight + '');
        if (secondType === "shape-table")
            $lockWrap.addClass("active eventNone");
        else
            $lockWrap.removeClass("eventNone");
    }

    // 主方法
    media.canvas.createMode = parseFloat(media.canvas.createMode);
    var $posBox = Z('#svg_sizeSet_box');
    var $lockWrap = $posBox.find('.scaleLockWrap');
    var materialType = $toolsWrap.attr('data-type');
    var secondType = $toolsWrap.attr('data-second');
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    var $gWrap = $curElem.querySelector('g');
    var $svg = [...$gWrap.children].pop();
    var boxTitle = '素材', widthName = '宽度', heightName = '高度';
    var svgWidth, svgHeight;

    // 1：定位输入框
    showMiniPopupBox(event, $posBox[0]);

    // 2：修改弹窗显示的值
    setSizeSetBoxName();

    // 3：赋值输入框
    setSizeSetBoxValueInput();

    // 4：锁定缩放更新
    setLockScale();

}

/** 5：显示（切换）颜色设置框 **/
function showColorPickerBox(event)
{
    // 显示颜色选择器，赋值当前颜色
    function showPicker ()
    {
        // 先隐藏文字列表
        hideTextDropList();
        
        // 定义位置
        var oldColor = rgb2hex($colorBtn.css("backgroundColor"));
        if (!hasClassParent($colorBtn[0], "minipopup")) {
            docPopupHideExPicker();
        }
        pickerLeft = $colorBtn.offsetLeftBody() + $colorBtn.offsetWidth() / 2 - 20;
        pickerTop = $colorBtn.offsetTopBody() + $colorBtn.offsetHeight();

        // 判断选择器位置，未变化时，则隐藏
        var theLeft = parseFloat($colorPicker.style.left || 0);
        var theTop = parseFloat($colorPicker.style.top || 0);
        if (pickerLeft === theLeft && pickerTop === theTop){
            Z($colorPicker).removeAttr('style');
            return false;
        }

        // 定位选择框
        Z($colorPicker).css({"left":pickerLeft,"top":pickerTop});

        // 已选颜色
        setColorSelected(oldColor);

        // 如果显示调色板，则赋值光标位置
        if (!Z(".fte-colorPicker-toning").isHide())
            setToningCursor();
        return true;
    }

    // 主方法
    Z.E.forbidden(event);
    var $colorBtn = Z(Z.E.target(event));
    var materialType = $colorBtn.attr('data-type');
    var $colorPicker = Z(".fte-colorPicker")[0];
    var pickerLeft, pickerTop;
    if (!materialType) return;

    // 1：切换颜色选择器
    if (showPicker())
    {
        // 2：设置基本属性
        $colorPicker.colorPickerData.colorType = materialType;
        $colorPicker.colorPickerData.colorId = $colorBtn.attr('id');
    }
}
/** 5.1：修改选中颜色 **/
function setSvgSelected(setColor)
{
    // 更新，文本，填充颜色
    function updateTextMaterialColor()
    {
        // 富文本的颜色修改
        function updateTextColorRich()
        {
            var sl = window.getSelection();
            var selectAll = isSelectAll();
            // 非全选、选区操作
            if (!sl.isCollapsed && !selectAll)
            {
                //设置选取索引
                setSlIndex(material);
                //定义素材颜色，取第一个字的颜色
                var firstWord = material.wordsList[0];
                material.color = firstWord.color;
            }
            // 全选操作
            else
            {
                material.color = setColor;
                var activeEle = document.activeElement;
                Z(activeEle).focus();
                document.execCommand("selectAll");
            }
            var setRichColor;
            if (setColor === 'none'){
                setRichColor = 'rgba(0,0,0,0)';
            } else {
                setRichColor = setColor;
            }
            document.execCommand("foreColor", false, setRichColor);
        }
        // 主方法
        var activeEle = document.activeElement;
        if (activeEle.tagName.toLowerCase() === "texter"){
            updateTextColorRich();
        } else {
            updateTextColor(material, $curElem, setColor);
        }
    }
    // 更新，Svg素材，颜色
    function updateSvgColor(id)
    {
        // 1：定义变量
        var items = $curElem.querySelectorAll("[fill]");
        var listLength = items.length;
        var indexStr = id.replace("tool_svgColor_","");
        var indexArr = [];
        var i = 0, $item, itemFill;

        // 2：定义有效索引数组
        if (indexStr === 'all')
        {
            indexArr.length = listLength;
            for (i;i < listLength;i++){
                indexArr[i] = i + 1;
            }
        }
        else
        {
            var tempArr = indexStr.split('_');
            tempArr = tempArr.map(parseFloat);
            for (i = tempArr[0];i <= tempArr[tempArr.length - 1];i++)
                indexArr[i] = i;
        }

        // 3：循环赋值
        for(i = 0;i < listLength;i++)
        {
            if (indexArr.indexOf(i) === -1)
                continue;

            $item = items[i];
            if ($item.hasAttribute('opacity') && $item.getAttribute('opacity') !== '1'){
                continue;
            }
            itemFill = $item.getAttribute("fill").toLowerCase();
            if (itemFill === "rgba(0,0,0,0)" || itemFill === "none" || itemFill === "transparent")
                continue;
            $item.setAttribute('fill', setColor);
        }

        // 4：按钮颜色
        if (indexStr === 'all')
        {
            var $$btn = Z('#tool_insertAttr').find('.tool-colorPicker:not(#tool_svgColor_all)');
            $$btn.css('background-color', setColor);
        }
        else
        {
            var $btn = Z('#' + id);
            $btn.css('background-color', setColor);
            var $space = $btn[0].previousElementSibling;
            // 如果是第一个按钮，则同步改变“全部”按钮
            if ($space && $space.id === 'tool_svgColor_space')
                Z('#tool_svgColor_all').css('background-color', setColor);
        }
    }
    // 更新，素材组，颜色
    function updateGroupColor()
    {
        if (selectedLength < 2) {
            hideEditSelected();
            media.tool.setTempCurrent();
            return;
        }
        var i, j, tempMaterial, $tempElem, items, itemFill, $tempSvg, tempType;
        for (i = 0;i < selectedLength;i++)
        {
            tempMaterial = media.getCurMaterial(i);
            $tempElem = media.tool.getCurSvgElement(i);
            tempMaterial.type = parseFloat(tempMaterial.type);
            // 文字处理
            if (tempMaterial.type === 1) updateTextColor(tempMaterial, $tempElem, setColor);
            // 普通素材
            else if (tempMaterial.type === 3)
            {
                items = $tempElem.querySelectorAll("[fill]");
                for (j = 0;j < items.length;j++)
                {
                    itemFill = Z(items[j]).attr("fill").toLowerCase();
                    if (itemFill === "rgba(0,0,0,0)" || itemFill === "none" || itemFill === "transparent")
                        continue;
                    Z(items[j]).attr("fill", setColor);
                }
                updateMaterialSource(tempMaterial, $tempElem);
            }
            // 形状素材
            else if (tempMaterial.type === 5)
            {
                $tempSvg = $tempElem.querySelector("svg");
                tempType = Z($tempSvg).attr("data-type");
                switch (tempType)
                {
                    case "shape-line": updateShapeLineStroke($tempElem);break;
                    case "shape-rect":
                    case "shape-rectStroke": updateShapeRectFill($tempElem);break;
                    case "shape-ellipse": updateShapeEllipseFill($tempElem);break;
                    case "shape-table": updateShapeTableTextFill($tempElem);break;
                }
            }
            updateMaterialSource(tempMaterial, $tempElem);
        }
    }
    // 更新，线条，颜色
    function updateShapeLineStroke($tempElem)
    {
        $tempElem = $tempElem || $curElem;
        var $line = $tempElem.querySelector("line");
        if (!$line){
            return;
        }
        $line.setAttribute("stroke",setColor);
    }
    // 更新，矩形，填充色
    function updateShapeRectFill($tempElem)
    {
        $tempElem = $tempElem || $curElem;
        $tempElem.querySelector('svg').querySelectorAll(".shape-rect-path").forEach(function($elem){
            if ($elem.hasAttribute("fill")) $elem.setAttribute("fill",setColor);
            if ($elem.hasAttribute("stroke")) $elem.setAttribute("stroke",setColor);
        })
    }
    // 更新形状，圆形，填充色
    function updateShapeEllipseFill($tempElem)
    {
        $tempElem = $tempElem || $curElem;
        $tempElem.querySelector('svg').querySelector("ellipse").setAttribute("fill",setColor);
    }
    // 更新形状，圆形，边框色
    function updateShapeEllipseStroke()
    {
        $curElem.querySelector("svg").querySelector("ellipse").setAttribute("stroke",setColor);
    }
    // 更新形状，钢笔，填充色
    function updateShapePenFill()
    {
        $curElem.querySelector("path").setAttribute("fill",setColor);
    }
    // 更新形状，钢笔，边框色
    function updateShapePenStroke()
    {
        $curElem.querySelector("path").setAttribute("stroke",setColor);
    }
    // 更新形状，表格，文字填充色
    function updateShapeTableTextFill()
    {
        var $activeElem = document.activeElement;
        if ($activeElem.className.includes("tableText-editArea"))
        {
            $activeElem.style.color = setColor.toLowerCase() === "none" ? "transparent" : setColor;
        }
        else
        {
            var $$path = $svg.parentElement.querySelectorAll("svg path");
            [].forEach.call($$path, function($path)
            {
                $path.setAttribute("fill",setColor);
            });
        }
    }
    // 更新形状，表格，边框色
    function updateShapeTableStroke()
    {
        var $gWrap = $curElem.querySelector("g");
        var $$svg = $gWrap.children;
        while ($$svg.length > 1)
            $gWrap.removeChild($$svg[1]);
        $svg = $$svg[0];
        var $$tdLine = $svg.querySelectorAll("line");
        [].forEach.call($$tdLine, function($tdLine)
        {
            $tdLine.setAttribute("stroke",setColor);
        });
        // 校准边框样式，复制一个svg
        var $svgClone = $svg.cloneNode(true);
        $svgClone.querySelectorAll("g[data-row]").forEach(function($dTd)
        {
            $dTd.removeChild($dTd.querySelector("rect"));
            if (($dTd.querySelector("g[transform]")))
                $dTd.removeChild($dTd.querySelector("g[transform]"));
        });
        $gWrap.appendChild($svgClone);
    }
    // 更新形状，表格，背景填充色
    function updateShapeTableFill()
    {
        var $gWrap = $curElem.querySelector("g");
        var $$svg = $gWrap.children;
        while ($$svg.length > 1)
            $gWrap.removeChild($$svg[1]);
        $svg = $$svg[0];
        var $activeElem = document.activeElement;
        if ($activeElem.className.includes("tableText-editArea"))
        {
            if (setColor.toLowerCase() === "none")
                $activeElem.parentElement.className = "bgNone";
            else
                Z($activeElem.parentElement).removeClass('bgNone').css("backgroundColor", setColor);
        }
        else
        {
            var $$tdRect = $svg.querySelectorAll("rect");
            [].forEach.call($$tdRect, function($tdRect)
            {
                $tdRect.setAttribute("fill",setColor);
            });
        }
        // 复制一个svg
        var $svgClone = $svg.cloneNode(true);
        $svgClone.querySelectorAll("g[data-row]").forEach(function($dTd)
        {
            $dTd.removeChild($dTd.querySelector("rect"));
            if (($dTd.querySelector("g[transform]")))
                $dTd.removeChild($dTd.querySelector("g[transform]"));
        });
        $gWrap.appendChild($svgClone);
    }
    // 文字特效：描边1、描边2
    function updateTextSpecialStroke1()
    {
        var $$svgStroke = $curElem.querySelectorAll('[data-textspecialcolor]');
        var listLength = $$svgStroke.length;
        if (listLength === 0)
            return;
        var i, $svgStroke;
        for (i = 0;i < listLength;i++)
        {
            $svgStroke = $$svgStroke[i];
            $svgStroke.setAttribute('stroke', setColor);
            $svgStroke.setAttribute('data-textspecialcolor', setColor);
        }
        material.textSpecialColor = setColor;
        $curElem.setAttribute('data-textspecialcolor', material.textSpecialColor);
    }
    // 文字特效：描边3
    function updateTextSpecialStroke3()
    {
        var $$svgStroke = $curElem.querySelectorAll('[data-textspecialcolor]');
        var idIndex = parseFloat(colorId.replace(/[^\d]/g, ''));
        var $svgStroke = $$svgStroke[idIndex];
        $svgStroke.setAttribute('stroke', setColor);
        $svgStroke.setAttribute('data-textspecialcolor', setColor);
        var i = 0, textSpecialColor = '';
        for (i;i < $$svgStroke.length;i++)
        {
            if (i > 0) textSpecialColor += ',';
            textSpecialColor += $$svgStroke[i].getAttribute('stroke');
        }
        $curElem.setAttribute('data-textspecialcolor', textSpecialColor);
        material.textSpecialColor = textSpecialColor;

    }
    // 文字特效：描边5
    function updateTextSpecialStroke5()
    {
        var $gInner = $curElem.querySelector('g');
        var $$svgStroke = Z($gInner).children('svg');
        var listLength = $$svgStroke.length;
        var i = 0;
        for (i;i < listLength - 1;i++) {
            Z($$svgStroke[i]).find('.font-path>path').attr('fill', setColor);
        }
        $curElem.querySelector('[data-textspecialcolor]').setAttribute('data-textspecialcolor', setColor);
        $curElem.setAttribute('data-textspecialcolor', setColor);
        material.textSpecialColor = setColor;
    }
    // 文字特效：渐变2
    function updateTextSpecialGradient2()
    {
        var $gInner = $curElem.querySelector('g');
        var $svgGradient = Z($gInner).find('svg[data-textspecialcolor]');
        $svgGradient.find('.font-path>path').attr('fill', setColor);
        $svgGradient.attr('data-textspecialcolor', setColor);
        material.textSpecialColor = setColor;
    }
    // 文字特效：渐变3
    function updateTextSpecialGradient3()
    {
        var $gInner = $curElem.querySelector('g');
        var pickerIndex = /_(\d+)$/.exec(colorId);
        pickerIndex = pickerIndex && pickerIndex[1];
        if (!pickerIndex)
            return;
        var $$svgGradient = Z($gInner).find('svg[data-textspecialcolor]');
        if (!pickerIndex)
            return;
        var $svgGradient = Z($$svgGradient[pickerIndex]);
        $svgGradient.find('.font-path>path').attr('fill', setColor);
        $svgGradient.attr('data-textspecialcolor', setColor);

        //定义material.textSpecialColor
        var textSpecialColor = '';
        var i = 0;
        for (i;i < $$svgGradient.length;i++) {
            textSpecialColor += $$svgGradient[i].getAttribute('data-textspecialcolor');
            if (i !== $$svgGradient.length - 1) textSpecialColor += ',';
        }
        material.textSpecialColor = textSpecialColor;
    }

    // 主方法，基本参数
    var selectedLength = media.selectedList.length;
    var pickerData = Z(".fte-colorPicker")[0].colorPickerData;
    var colorType = pickerData.colorType;
    var colorId = pickerData.colorId;
    if (selectedLength === 0 && colorType !== 'bgFill') {
        return;
    }
    var material, $curElem, $svg;
    if (selectedLength === 1){
        material = media.tool.tempMaterial || media.getCurMaterial();
        $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
        $svg = [...$curElem.querySelector('g').children].pop();
    }

    switch (colorType)
    {
        case "bgFill": media.tool.setFillColor(setColor); break;
        case "textFill": updateTextMaterialColor(); break;
        case "svgFill": updateSvgColor(colorId); break;
        case "groupColor": updateGroupColor(); break;
        case "lineFill": updateShapeLineStroke(); break;
        case "rectFill": updateShapeRectFill(); break;
        case "rectStrokeFill": updateShapeRectFill(); break;
        case "ellipseFill": updateShapeEllipseFill(); break;
        case "ellipseStroke": updateShapeEllipseStroke(); break;
        case "penFill": updateShapePenFill(); break;
        case "penStroke": updateShapePenStroke(); break;
        case "tableText": updateShapeTableTextFill(); break;
        case "tableStroke": updateShapeTableStroke(); break;
        case "tableFill": updateShapeTableFill(); break;
        case 'stroke-1':
        case 'stroke-2':updateTextSpecialStroke1(); break;
        case 'stroke-3': updateTextSpecialStroke3(); break;
        case 'stroke-5': updateTextSpecialStroke5(); break;
        case 'gradient-2':
        case 'gradient-4': updateTextSpecialGradient2(); break;
        case 'gradient-3': updateTextSpecialGradient3(); break;
    }

    // 颜色选择器，已选颜色
    if (setColor === 'none')
    {
        Z("#"+ colorId).addClass('bgNone');
    } else {
        Z("#"+ colorId).removeClass('bgNone').css("background", setColor);
    }
    setColorSelected(setColor);

    // 更新保存
    if (selectedLength === 1) {
        updateMaterialSource(material, $curElem);
    }
    saveHistory();
}
// 5.1：更新，单个文字，填充颜色
function updateTextColor(material, $curElem, setColor)
{
   
    material.color = setColor
    // 更新到画布
    var $gInner = $curElem.querySelector('g');
    var $$svgInner = Z($gInner).children('svg');
    var $svg = $$svgInner[$$svgInner.length - 1];
    Z($svg).find("g.font-path>path").attr("fill", setColor);
    // 下划线
    if (material.textDecoration) {
        var $$line = $svg.querySelectorAll(".font-path>line");
        [].forEach.call($$line, function($line) {
            $line.setAttribute("stroke", setColor);
        });
    }
    // wordsList
    for (var i = 0;i < material.wordsList.length;i++) {
        material.wordsList[i].color = material.color;
    }
    // 判断是否是特殊文字
    setTextMaterialData(material, $curElem);
}

/** 6：修改字体类型 **/
function changeMaterialFontFamily(fontFamily)
{
    // 展示方法
    function setValShow()
    {
        setFontSelectVal(fontFamily, 'tool_fontFamily');
        Z("#tool_fontFamily .fontFamily-value").attr("value", fontFamily);
        Z("#tool_fontFamily .fontFamily_inputWrap > .z-input").addClass("invisible").blur();
    }

    // 分情况调用
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var activeEle = document.activeElement;
    var activeTag = activeEle.tagName.toLowerCase();
    if (material.type === 1)
    {
        if (activeTag !== "texter")
            return changeTextMaterialFontSet(fontFamily, 'fontFamily', null, setValShow);
        var doTexterEditorChange = function (material)
        {
            var sl = window.getSelection();
            var selectAll = isSelectAll();
            if (!sl.isCollapsed && !selectAll) {
                //设置选取索引
                setSlIndex(material);
                var slStart = media.tool.tempSelStart;
                var slEnd = media.tool.tempSelEnd;
                var i;
                //修改选区素材
                for (i = 0; i < material.wordsList.length; i++) {
                    if (slStart <= i && i < slEnd) {
                        material.wordsList[i].fontFamily = fontFamily;
                    }
                }
                //定义素材字体
                var firstWord = material.wordsList[0];
                material.fontFamily = firstWord.fontFamily;
            }
            else {
                //定义素材字体
                material.fontFamily = fontFamily;
                for (i = 0; i < material.wordsList.length; i++) {
                    material.wordsList[i].fontFamily = fontFamily;
                }
                Z(activeEle).focus();
                document.execCommand("selectAll");
            }
            document.execCommand("fontName", false, fontFamily);
        }
        changeTextMaterialFontSet(fontFamily, 'fontFamily', doTexterEditorChange, setValShow);
    }
    else if (material.type === 5)
    {
        var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
        var dataType =  $curElem.querySelector("svg").getAttribute("data-type");
        if (dataType === "shape-table")
        {
            var setEditor = null
            if (activeEle.className.includes("tableText-editArea"))
                setEditor = function ()
                {
                    var activeEle = document.activeElement;
                    if (activeEle.className.includes("tableText-editArea"))
                        activeEle.style.fontFamily = fontFamily;
                };
            changeTableMaterialFontSet(fontFamily, 'fontFamily', setEditor, setValShow);
        }
    }
}
// 设置文字类型：字体、大小方法
function changeTextMaterialFontSet(setValue, setType, doEditorChange, valShowFun)
{
    // 文字素材的修改
    function doMaterialChange()
    {
        // 检测是否所有文字绘制完成
        function doneCheck(tempMaterial, $tempElem)
        {
            finishedNum++;
            allTextPathDoneCheck(tempMaterial, $tempElem, finishedNum, updateFontSet_loader);
        }

        // 主方法
        var i, updateFontSet_loader, finishedNum = 0;

        // 1：显示加载框
        if (selectedLength > 2)
        {
            updateFontSet_loader = Z.loading({
                shadow: true,
                text:"正在加载..."
            });
        }

        // 2：循环处理
        for (i = 0;i < selectedLength;i++)
        {
            material = media.getCurMaterial(i);
            $curElem = media.tool.getCurSvgElement(i);
            updateFontSet(material, $curElem, doneCheck);
        }
    }
    // 更新文字素材字体设置
    function updateFontSet(tempMaterial, $tempElem, doneCheck)
    {
        tempMaterial = tempMaterial || material;
        $tempElem = $tempElem || $curElem;

        // 1：验证是否有修改
        var validate = (tempMaterial[setType] + '') === (setValue + '');
        var i;
        if (tempMaterial.wordsList)
        {
            for (i = 0;i < tempMaterial.wordsList.length;i++)
            {
                if (tempMaterial.wordsList[i][setType] + '' !== setValue + ''){
                    validate = false;
                    break;
                }
            }
        }
        if (validate)
            return doneCheck();

        // 2：为素材赋值新的 setValue
        tempMaterial[setType] = setValue;
        if (tempMaterial.wordsList)
        {
            for (i = 0;i < tempMaterial.wordsList.length;i++)
                tempMaterial.wordsList[i][setType] = setValue;
        }

        // 3：绘制文字
        getPathAjax (tempMaterial, $tempElem, 1, 1, doneCheck);
    }

    // 1：主方法，定义变量
    var selectedLength = media.selectedList.length;
    if (selectedLength === 0)
        return;
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    if (material.type !== 1)
        return;

    // 2：执行选中，输入框隐藏
    Z.T.isFunction(valShowFun) && valShowFun();

    // 2：分情况处理
    var activeEle = document.activeElement;
    if (activeEle.tagName.toLowerCase() === "texter")
        Z.T.isFunction(doEditorChange) && doEditorChange(material);
    else
        doMaterialChange();
}
// 设置表格类型：字体路径重生成方法
function changeTableMaterialFontSet(setValue, setType, doEditorChange, valShowFun)
{
    // 表格素材的修改
    function doMaterialChange()
    {
        // 1：定义和判断
        var $svgMain = $curElem.querySelector("g").querySelector("svg");
        var $$gTd = $svgMain.querySelectorAll("g[data-rowspan]");
        var listLength = $$gTd.length;
        var textTdNum = 0;
        var textTdIndexArr = [];
        var textTdStrArr = [];
        var i = 0, $gTd = null, textStr = "";
        for (i;i<listLength;i++)
        {
            $gTd = $$gTd[i];
            textStr = $gTd.getAttribute("data-text");
            textStr = textStr && textStr.trim();
            if (textStr)
            {
                textTdIndexArr.push(i);
                textTdStrArr.push(textStr);
                textTdNum++;
            }
        }
        if (textTdNum === 0)
            return;

        // 2：生成svg代码
        var arrIndex = 0;
        for (i = 0;i <textTdIndexArr.length;i++)
        {
            arrIndex = textTdIndexArr[i];
            $gTd = $$gTd[arrIndex];
            textStr = textTdStrArr[i];

            // 清除老数据
            var $gTextWrap = $gTd.querySelector("g");
            var $gText = $gTextWrap.querySelector("g");
            var $svgText = $gText.querySelector("svg");
            var textDecoration = $svgText.querySelector("line") ? 1 : 0;
            var fontColor = $svgText.querySelector("path").getAttribute("fill");
            $gText.removeChild($svgText);

            // 生成新数据
            var textObj =
            {
                fontSize: $gTd.getAttribute("data-fontsize") + "pt",
                fontFamily: $gTd.getAttribute("data-fontfamily"),
                fontWeight: parseFloat($gTd.getAttribute("data-fontweight")),
                textDecoration: textDecoration,
                fontColor: fontColor,
                mathHeight: parseFloat($gTd.getAttribute("data-mathheight")),
                letterSpacing: parseFloat($gTd.getAttribute("data-letterspacing")),
            };
            textObj[setType] = (setType === "fontSize") ? setValue + "pt" : setValue;
            $svgText = getPathSvgFromText(textStr,textObj);
            $gText.appendChild($svgText);

            // 设置属性
            $gTd.setAttribute("data-" + setType.toLowerCase(), setValue);
            material[setType] = setValue;

            // 单元格大小/偏移校验
            resetTdTextSizeTrans($gTd);
        }

        // 3：更新保存
        updateMaterialSource(material, $curElem);
        saveHistory();
    }

    // 1：主方法，定义变量
    var selectedLength = media.selectedList.length;
    if (selectedLength !== 1) {
        return;
    }
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    if (material.type !== 5)
        return;
    var $svg = $curElem.querySelector("svg");
    var dataType = $svg.getAttribute("data-type");
    if (dataType !== "shape-table")
        return;

    // 2：执行选中，输入框隐藏
    if (typeof valShowFun === 'function')
        valShowFun();

    // 3：分情况处理
    if (typeof doEditorChange === 'function')
        doEditorChange(material);
    else
        doMaterialChange();
}
// 校验表格单元格文字内容的大小和偏移
function resetTdTextSizeTrans($gTd)
{
    if (!$gTd.getAttribute("data-text"))
        return;
    
    var $rectText = $gTd.querySelector("rect");
    var $gTextWrap = $gTd.querySelector("g");
    var $svgText = $gTextWrap.querySelector("svg");
    var tdWidth = parseFloat($rectText.getAttribute("width"));
    var tdHeight = parseFloat($rectText.getAttribute("height"));

    // 1：校准大小
    $svgText.removeAttribute("width");
    $svgText.removeAttribute("height");
    $svgText.removeAttribute("viewBox");
    var svgBox = $svgText.getBBox();
    var svgWidth = svgBox.width;
    var svgHeight = svgBox.height;
    if (svgWidth > tdWidth)
    {
        svgWidth = tdWidth;
        svgHeight = svgWidth * svgBox.height / svgBox.width;
    }
    if (svgHeight > tdHeight)
    {
        svgHeight = tdHeight;
        svgWidth = svgHeight * svgBox.width / svgBox.height;
    }
    $svgText.setAttribute("width", svgWidth + "");
    $svgText.setAttribute("height", svgHeight + "");
    $svgText.setAttribute("viewBox", svgBox.x + " " + svgBox.y + " " + svgBox.width + " " + svgBox.height);

    // 2：校准偏移
    var textBox = $gTextWrap.getBBox();
    var setX = tdWidth - svgWidth;
    switch ($gTd.getAttribute("data-textalign")){
        case "left": setX =  -textBox.x; break;
        case "center": setX = (setX - textBox.x)/2;break;
    }
    $gTextWrap.setAttribute("transform", "translate(" + setX + " " + ((tdHeight - textBox.height) / 2) + ")");
}
// 检查是否所有文字处理完成
function allTextPathDoneCheck(tempMaterial, $tempElem, finishedNum, updateFontSet_loader)
{
    editOverSet ($tempElem);
    updateMaterialSource(tempMaterial, $tempElem);
    if (finishedNum === media.selectedList.length)
    {
        setTimeout(function()
        {
            if (updateFontSet_loader && updateFontSet_loader.close) {
                updateFontSet_loader.close();
                updateFontSet_loader = null;
            }
        },800);

        // 选择框定位，保存历史
        selectTheElement_group();
        saveHistory();
    }
}

/** 7：修改字体大小 **/
function changeMaterialFontSize(fontSize)
{
    // 展示方法
    function setValShow()
    {
        setFontSelectVal(fontSize, 'tool_fontSize');
        Z("#tool_fontSize .fontSet_inputWrap > .z-input").val(fontSize).blur();
    }

    // 分情况调用
    var material = media.tool.tempMaterial || media.getCurMaterial();
    if (material.type === 1)
    {
        changeTextMaterialFontSet(fontSize, 'fontSize', null, setValShow);
    }
    else if (material.type === 5)
    {
        var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
        var dataType =  $curElem.querySelector("svg").getAttribute("data-type");
        if (dataType === "shape-table")
        {
            var setEditor = null;
            if (document.activeElement.className.includes("tableText-editArea"))
                setEditor = function ()
                {
                    var activeEle = document.activeElement;
                    var fontSizePx = pt2px(fontSize);
                    if (activeEle.className.includes("tableText-editArea"))
                        activeEle.style.fontSize = fontSizePx + "px";
                };
            changeTableMaterialFontSet(fontSize, 'fontSize', setEditor, setValShow);
        }
    }
}

/** 8：切换文字加粗 **/
function changeMaterialWeight()
{
    // 富文本编辑器的加粗
    function changeTexterEditorWeight()
    {
        var sl = window.getSelection();
        var selectAll = isSelectAll();
        var material = media.tool.tempMaterial || media.getCurMaterial();
        if (!sl.isCollapsed && !selectAll)
        {
            // 设置选取索引
            setSlIndex(material);
        }
        else
        {
            if (isActive)
                material.fontWeight = 0;
            else
                material.fontWeight = 1;
            // 修改预览
            Z(activeEle).focus();
            document.execCommand("selectAll");
        }
        document.execCommand("bold", false);
    }
    // 本文素材的加粗
    function changeTextMaterialWeight()
    {
        // 检测是否所有文字绘制完成
        function doneCheck(tempMaterial, $tempElem)
        {
            finishedNum++;
            allTextPathDoneCheck(tempMaterial, $tempElem, finishedNum, updateFontSet_loader);
        }

        // 主方法，定义变量
        var i, j, updateFontSet_loader, finishedNum = 0;

        // 1：显示加载框
        if (selectedLength > 2){
            updateFontSet_loader = Z.loading({
                shadow: true,
                text:"正在加载..."
            });
        }

        // 2：循环处理
        for (i = 0;i < selectedLength;i++)
        {
            material = media.getCurMaterial(i);
            $curElem = media.tool.getCurSvgElement(i);

            // 取消加粗状态
            if (isActive)
            {
                material.fontWeight = 0;
                $curElem.setAttribute("data-fontweight",0);
            }
            // 添加加粗状态
            else
            {
                material.fontWeight = 1;
                $curElem.setAttribute("data-fontweight",1);
            }

            // 如果存在wordsList
            if (material.wordsList) {
                for (j = 0;j < material.wordsList.length;j++) {
                    material.wordsList[j].fontWeight = material.fontWeight;
                }
                //判断是否是特殊文字
                setTextMaterialData(material, $curElem);
            }
            // 绘制文字
            getPathAjax(material, $curElem, 1, 1, doneCheck);
        }
    }
    // textarea 文本加粗
    function changeTextAreaEditorWeight()
    {
        if (isActive)
            activeEle.style.fontWeight = "normal";
        else
            activeEle.style.fontWeight = "bold";
    }

    // 主方法，定义变量
    var $btn = Z.D.id('tool_fontWeight');
    var selectedLength = media.selectedList.length;
    if (selectedLength === 0) {
        return;
    }
    var isActive = Z($btn).hasClass('active');
    Z($btn).toggleClass('active');
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();

    // 1：判断是否是编辑器操作
    var activeEle = document.activeElement;
    var activeTag = activeEle.tagName.toLowerCase();
    if (material.type === 1)
    {
        if (activeTag === "texter")
            changeTexterEditorWeight();
        else
            changeTextMaterialWeight();
    }
    else if (material.type === 5)
    {
        var $svg = $curElem.querySelector("svg");
        var dataType = $svg.getAttribute("data-type");
        if (dataType !== "shape-table")
            return;
        if (activeEle.className.includes("tableText-editArea"))
            changeTextAreaEditorWeight();
        else
            changeTableMaterialFontSet(isActive ? 0 : 1, "fontWeight");
    }
}

/** 9：切换文字斜体 **/
function changeMaterialItalic()
{
    // 修改富文本文字斜体
    function changeTexterEditorItalic()
    {
        material = media.tool.tempMaterial || media.getCurMaterial();
        var sl = window.getSelection();
        var selectAll = isSelectAll();
        // 局部选中处理
        if (!sl.isCollapsed && !selectAll)
        {
            // 设置选取索引
            setSlIndex(material);
        }
        // 全选处理
        else
        {
            if (isActive)
                material.fontItalic = 0;
            else
                material.fontItalic = 1;
            //修改预览
            Z(activeEle).focus();
            document.execCommand("selectAll");
        }
        document.execCommand("italic", false);
    }
    // 修改文字素材斜体
    function changeTextMaterialItalic()
    {
        // 1：循环处理
        for (var i = 0;i < selectedLength;i++)
        {
            material = media.getCurMaterial(i);
            $curElem = media.tool.getCurSvgElement(i);
            if (isActive) {
                cancelTextItalic(material, $curElem);
            } else {
                setTextItalic(material, $curElem);
            }
            // 刷新 source
            updateMaterialSource(material, $curElem);
        }
        // 2：选择框定位，保存
        selectTheElement_group();
        saveHistory();
    }
    // textarea 文本斜体
    function changeTextAreaEditorItalic()
    {
        if (isActive)
            activeEle.style.fontStyle = "normal";
        else
            activeEle.style.fontStyle = "italic";
    }
    // 表格素材斜体
    function changeTableMaterialItalic()
    {
        var $svgMain = $curElem.querySelector("g").querySelector("svg");
        var $$gTd = $svgMain.querySelectorAll("g[data-rowspan]");
        var $gTd = null, $gText = null;
        var i = 0, setItalic = null;
        for (i;i < $$gTd.length;i++)
        {
            $gTd = $$gTd[i];
            $gText = $gTd.querySelector("g").querySelector("g");
            if (isActive) {
                $gText.removeAttribute("transform");
                setItalic = 0;
            } else {
                $gText.setAttribute("transform", "skewX(-18)");
                setItalic = 1;
            }
            $gTd.setAttribute("data-fontitalic", setItalic);
            // 单元格大小/偏移校验
            resetTdTextSizeTrans($gTd);
        }
    }

    // 主方法，定义变量
    var $btn = Z.D.id('tool_fontStyle');
    var selectedLength = media.selectedList.length;
    if (selectedLength === 0) {
        return;
    }
    var isActive = Z($btn).hasClass('active');
    Z($btn).toggleClass('active');
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();

    // 1：判断是否是编辑器操作
    var activeEle = document.activeElement;
    var activeTag = activeEle.tagName.toLowerCase();
    if (material.type === 1)
    {
        if (activeTag === "texter")
            changeTexterEditorItalic();
        else
            changeTextMaterialItalic();
    }
    else if (material.type === 5)
    {
        var $svg = $curElem.querySelector("svg");
        var dataType = $svg.getAttribute("data-type");
        if (dataType !== "shape-table")
            return;

        if (activeEle.className.includes("tableText-editArea"))
            changeTextAreaEditorItalic();
        else
            changeTableMaterialItalic();
    }
}

/** 10：切换文字下划线 **/
function changeMaterialUnderline()
{
    // 富文本文字下划线
    function changeTexterEditorTextDecoration()
    {
        material = media.tool.tempMaterial || media.getCurMaterial();
        var sl = window.getSelection();
        var selectAll = isSelectAll();
        // 局部选中操作
        if (!sl.isCollapsed && !selectAll)
        {
            // 设置选取索引
            setSlIndex(material);
        }
        else
        {//全选操作
            if (isActive)
                material.textDecoration = 0;
            else
                material.textDecoration = 1;
            //修改预览
            Z(activeEle).focus();
            document.execCommand("selectAll");
        }
        document.execCommand("underline", false);
    }
    // 文字素材下划线
    function changeTextMaterialTextDecoration()
    {
        // 1：循环处理
        for (var i = 0;i < selectedLength;i++)
        {
            material = media.getCurMaterial(i);
            $curElem = media.tool.getCurSvgElement(i);
            if (isActive) {
                cancelTextDecoration(material, $curElem);
            } else {
                setTextDecoration(material, $curElem);
            }
            // 刷新 source
            updateMaterialSource(material, $curElem);
        }
        // 2：选择框定位，保存
        selectTheElement_group();
        saveHistory();
    }
    // textarea 文本下划线
    function changeTextAreaEditorTextDecoration()
    {
        if (isActive)
            activeEle.style.textDecoration = "none";
        else
            activeEle.style.textDecoration = "underline";
    }
    // 表格素材下划线
    function changeTableMaterialTextDecoration()
    {
        var $svgMain = $curElem.querySelector("g").querySelector("svg");
        var $$gTd = $svgMain.querySelectorAll("g[data-rowspan]");
        var $gTd = null, $svgText = null, $textPath = null, $$gLine = null, $gLine = null;
        var underlineOffset = 0, underlineThickness = 0;
        var i = 0, j = 0, tdColor = "", lineBox = "";
        var $line = null;
        for (i;i < $$gTd.length;i++)
        {
            $gTd = $$gTd[i];
            $svgText = $gTd.querySelector("svg");
            $textPath = $svgText.querySelector("path");
            if (!$textPath)
                continue;
            tdColor = $textPath.getAttribute("fill");
            underlineOffset = $svgText.getAttribute("data-underlineoffset");
            underlineThickness = $svgText.getAttribute("data-underlinethickness");
            $$gLine = $svgText.children;
            for (j = 0;j < $$gLine.length;j++)
            {
                $gLine = $$gLine[j];
                if ($gLine.tagName.toLowerCase() !== "g")
                    continue;

                $line = $gLine.querySelector("line");
                $gTd.setAttribute("data-textdecoration", "1");
                if ($line)
                {
                    if (isActive){
                        $gTd.setAttribute("data-textdecoration", "0");
                        $gLine.removeChild($line);
                    }
                    continue;
                }

                lineBox = $gLine.getBBox();
                $line = document.createElementNS(xmlns, "line");
                $line.setAttribute("x1", lineBox.x);
                $line.setAttribute("y1", underlineOffset);
                $line.setAttribute("x2", lineBox.x + lineBox.width);
                $line.setAttribute("y2", underlineOffset);
                $line.setAttribute("stroke", tdColor);
                $line.setAttribute("stroke-width", underlineThickness);
                $gLine.appendChild($line);
            }
            // 单元格大小/偏移校验
            resetTdTextSizeTrans($gTd);
        }
    }

    // 主方法，定义变量
    var $btn = Z.D.id('tool_fontDecoration');
    var selectedLength = media.selectedList.length;
    if (selectedLength === 0) {
        return;
    }
    var isActive = Z($btn).hasClass('active');
    Z($btn).toggleClass('active');
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();

    // 1：判断是否是编辑器操作
    var activeEle = document.activeElement;
    var activeTag = activeEle.tagName.toLowerCase();
    if (material.type === 1)
    {
        if (activeTag === "texter")
            changeTexterEditorTextDecoration();
        else
            changeTextMaterialTextDecoration();
    }
    else if (material.type === 5)
    {
        var $svg = $curElem.querySelector("svg");
        var dataType = $svg.getAttribute("data-type");
        if (dataType !== "shape-table")
            return;

        if (activeEle.className.includes("tableText-editArea"))
            changeTextAreaEditorTextDecoration();
        else
            changeTableMaterialTextDecoration();
    }
}

/** 11：显示文字对齐选择框 **/
function showTextAlignBox(event)
{
    // 主方法
    var $txtAlignBox = Z.D.id('textAlign_box');

    // 1：定位对齐按钮选择框
    showMiniPopupBox(event, $txtAlignBox);

    // 2：设置当前的对齐方式为选中
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var textAlign = (material && material.textAlign) || "left";
    if (material.type === 5)
    {
        var $activeElem = document.activeElement;
        if ($activeElem.className.includes("tableText-editArea"))
            textAlign = $activeElem.style.textAlign;
    }
    Z($txtAlignBox).children("."+ textAlign).addClass("active").siblings(".textAlign_box_btn").removeClass("active");
}
// 点击设置文本对齐
function switchTextAlign(event)
{
    // 编辑器内的对齐操作
    function doEditorTextAlign(){
        Z("#textEditor").css("text-align",alignType);
    }
    // 素材的对齐操作
    function doMaterialTextAlign(){
        // 1：循环处理
        for (i = 0;i < selectedLength;i++)
        {
            material = media.getCurMaterial(i);
            $curElem = media.tool.getCurSvgElement(i);
            if (material.textAlign === alignType){
                continue;
            }
            // 执行对齐操作
            setElementAlign(alignType, material, $curElem);
            // 更新文本，保存历史
            updateMaterialSource(material, $curElem);
        }

        // 2：选择框定位，保存
        selectTheElement_group();
        saveHistory();
    }
    // textarea 文本对齐
    function doTextAreaTextAlign(){
        $activeElem.style.textAlign = alignType;
    }
    // 表格文字的对齐操作
    function doTableTextAlign()
    {
        if (material.textAlign === alignType)
            return;
        material.textAlign = alignType;
        $curElem.setAttribute("data-textalign", alignType);
        // 1：循环执行
        var $$td = $svg.querySelectorAll("g[data-rowspan]");
        var $td = null, $gText = null;
        var textTrans = null, setTrans = "", tdWidth = 0, textWidth = 0;
        var $$line = null, lineNum = 0, $svgLine = null, $line= null;
        var j = 0, svgLineWidth = 0, lineBoxWidth = 0, lineTransX = null, lineTransY = 0, setLineTrans = "";
        for (i = 0;i < $$td.length;i++)
        {
            $td = $$td[i];
            $td.setAttribute("data-textalign", alignType);
            $gText = $td.querySelector("g[transform]");
            $$line = $gText.querySelectorAll("svg>g");
            lineNum = $$line.length;
            if (lineNum <= 0)
                continue;
            textTrans = $gText.transform.baseVal[0].matrix;
            tdWidth = $td.getBBox().width;
            textWidth = $gText.getBBox().width;
            switch(alignType)
            {
                case "left":
                    setTrans = 0;
                    break;
                case "center":
                    setTrans = (tdWidth - textWidth)/2;
                    break;
                case "right":
                    setTrans = tdWidth - textWidth;
                    break;
            }
            setTrans = "translate(" + setTrans + " " + textTrans.f + ")";
            $gText.setAttribute("transform", setTrans);
            // 多行处理
            $svgLine = $gText.querySelector("svg");
            $$line = $svgLine.children;
            if (lineNum <= 1) {
                continue;
            }
            svgLineWidth = $svgLine.getBBox().width;
            for (j = 0;j < lineNum;j++)
            {
                $line = $$line[j];
                lineBoxWidth = $line.getBBox().width;
                switch(alignType)
                {
                    case "left":
                        lineTransX = 0;
                        break;
                    case "center":
                        lineTransX = (svgLineWidth - lineBoxWidth)/2;
                        break;
                    case "right":
                        lineTransX = svgLineWidth - lineBoxWidth;
                        break;
                }
                lineTransY = $line.transform.baseVal[0].matrix.f;
                setLineTrans = "translate(" + lineTransX + " " + lineTransY +")";
                $line.setAttribute("transform", setLineTrans);
            }
            // 位置较准
            resetTdTextSizeTrans($td);
        }

        // 2：选中
        selectTheElement(material, $curElem);

        // 3：更新保存
        updateMaterialSource();
        saveHistory();
    }

    // 主方法，定义变量
    var selectedLength = media.selectedList.length;
    if (selectedLength === 0)
        return;

    var $btn = Z.E.current(event);
    var $toolBtn = Z('#tool_fontAlign .textAlign-btn');
    var alignType = $btn.getAttribute('data-type');
    var $activeElem = document.activeElement;
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    var i = 0;

    // 1：展示状态修改
    Z($btn).addClass("active").siblings(".textAlign_box_btn").removeClass("active");
    $toolBtn[0].className = "textAlign-btn " + alignType;
    Z("#sideTextEditor").css("text-align", alignType);     // 侧边文字编辑器修改样式

    // 2：分情况处理
    if (material.type === 1)
    {
        if ($activeElem === Z.D.id("textEditor"))
            doEditorTextAlign();
        else
            doMaterialTextAlign();
    }
    else if (material.type === 5)
    {
        var $svg = $curElem.querySelector("svg");
        var dataType = $svg.getAttribute("data-type");
        if (dataType !== "shape-table")
            return;
        if ($activeElem.className.includes("tableText-editArea"))
            doTextAreaTextAlign();
        else
            doTableTextAlign();
    }
}

/** 12：显示文字竖版编辑框 **/
function showTextVerticalBox(event)
{
    // 主方法，定义变量
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    if (!material || !$curElem){
        return;
    }
    var $verticalBox = Z.D.id('textVertical_box');

    // 1：定位编辑框
    showMiniPopupBox(event, $verticalBox);
}

/** 13：显示文字字距编辑框 **/
function showTextSpacingBox(event)
{
    // 计算字间距的最小值，rangeMin
    function getRangeLimit()
    {
        var wordsWidth = [];
        var itemWidth = 0;
        for (var i = 0;i < $$paths.length;i++)
        {
            itemWidth = parseFloat($$paths[i].getAttribute("data-width") || 0);
            if (itemWidth < 0) {
                continue;
            }
            wordsWidth.push(itemWidth);
        }
        var textFont = material.fontSize;
        if (parseFloat(media.canvas.createMode) === 0) { textFont = pt2px(textFont)}
        wordsWidth.push(textFont);
        rangeMin = getMinNum(wordsWidth);
    }
    // 计算字间距的偏移，spacingRange
    function getRangeLeft()
    {
        if (spacingRange <= 0) {
            spacingRange = (rangeMin + spacingRange) / (rangeMin * 2) * 100;
        } else {
            spacingRange = 50 + spacingRange / 4;
        }
        spacingRange += "%";
    }
    // 对弹出窗赋值
    function setInputValue()
    {
        Z($letterSpacing).find('.num>input').val(material.letterSpacing);
        Z($letterSpacing).find('.range>i').css("left", spacingRange);
        Z($lineHeight).find('.num>input').val(material.lineHeight);
        Z($lineHeight).find('.range>i').css("left", material.lineHeight / 10  + "%");

        // 两端对齐的情况，字间距不能设置
        if (Boolean(parseFloat($firstLine.getAttribute('data-justify')))){
            Z('#textLetterSpacing').addClass('eventDisable');
        } else {
            Z('#textLetterSpacing').removeClass('eventDisable');
        }
    }

    // 主方法，定义变量
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    if (!material || !$curElem){
        return;
    }
    var $spacingBox = Z.D.id('textSpacing_box');
    var $letterSpacing = Z.D.id("textLetterSpacing");
    var $lineHeight = Z.D.id("textLineHeight");
    var $svg = [...$curElem.querySelector('g').children].pop();
    if ($svg.getAttribute("data-type") === "shape-table")
        $svg = $curElem.querySelector("svg:first-child");
    var $firstLine = $svg.children[0];
    var $$paths = $svg.querySelectorAll("g.font-path");
    var spacingRange = parseFloat(material.letterSpacing);
    var rangeMin = 0;

    // 1：定位编辑框
    showMiniPopupBox(event, $spacingBox);

    // 2：计算字间距的极值
    getRangeLimit();

    // 3：绑定属性
    $spacingBox.targMaterial = material;
    $spacingBox.targElement = $curElem;
    $letterSpacing.rangeLimitWidth = rangeMin;

    // 4：得到字间距，滑块偏移量
    getRangeLeft();

    // 5：赋值
    setInputValue();
}

/** 14：显示文字特效编辑框 **/
function showTextSpecialBox(event)
{
    // 1：定义变量
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    if (!material || !$curElem){
        return;
    }
    var $strokeBox = Z.D.id('textSpecial_box');

    // 2：定位编辑框
    showMiniPopupBox(event, $strokeBox);

    // 3：显示颜色选择器
    showSpecialColorPicker(material.textSpecial, material.mid);

    // 4：显示大小滑块
    showTextSpecialSize(material.textSpecial, material.mid);
}
// 14.1:文字特效颜色
function showSpecialColorPicker(textSpecial, mid)
{
    var $firstElem = media.tool.getSvgElementByMid(mid);
    var $specialColor = $firstElem.querySelectorAll('[data-textspecialcolor]');
    var $textSpecialColor = Z('#textSpecial_box .textSpecialMore-item.item-pickerList');
    var $pickerList = Z('#textSpecial_pickerList').html('');
    var colorLength = $specialColor.length;
    if (colorLength > 0)
    {
        var pickerStr = '<div class="tool-colorPicker" data-type="' + textSpecial + '" onclick="showColorPickerBox(event);"></div>';
        $textSpecialColor.addClass('active');
        var i = 0, $picker;
        for (i;i < colorLength;i++)
        {
            $picker = Z(pickerStr);
            $pickerList.append($picker);
            $picker.attr('id', 'textSpecialColorPicker_' + i);
            $picker.css('background-color', $specialColor[i].getAttribute('data-textspecialcolor'));
        }
    }
    else {
        $textSpecialColor.removeClass('active');
    }
   
    var textSpecialpickerList=null
    Z("#textSpecialColorPicker_0").click(function(){
     if(!textSpecialpickerList){
      textSpecialpickerList=1
      sessionStorage.setItem("num", textSpecialpickerList)
     }else{
       return
     }
       
     })
     Z("#textSpecialColorPicker_1").click(function(){
        if(!textSpecialpickerList){
        textSpecialpickerList=1
        sessionStorage.setItem("num", textSpecialpickerList)
      }else{
       return
     }
     })
     
}
// 14.2:文字特效大小
function showTextSpecialSize(textSpecial, mid)
{
    // 文字特效：描边1
    function setLeftByStroke1 ()
    {
        if (listLength !== 2)
            return;
        var strokeWidth = parseFloat($$svg[0].getAttribute('stroke-width'));
        var fontSize = material.fontSize;
        if (parseFloat(media.canvas.createMode) === 1)
            fontSize = px2pt(fontSize);

        var sysStroke = 30/20 * fontSize;
        setLeft = strokeWidth / sysStroke * 100 + '%';
    }

    var $textSpecialSize = Z('#textSpecial_box .textSpecialMore-item.item-sizeRange');
    var $range = Z.D.id('textSpecial_sizeRange');
    var $btn = Z($range).find('.z-pointer');
    $range.textSpecial = textSpecial;
    $textSpecialSize.addClass('active');

    var $curElem = media.tool.getSvgElementByMid(mid);
    var material = media.getMaterialByMid(mid);
    var $$svg = Z($curElem).children('g').children('svg');
    var listLength = $$svg.length;
    var $svg = $$svg[listLength - 1];
    var setLeft = 0;
    switch (textSpecial)
    {
        case 'stroke-1':
            setLeftByStroke1();
            break;
        default:
            $textSpecialSize.removeClass('active');
            $btn.css('left', 0);
            return;
    }
    $btn.css('left', setLeft);
}

/** 15：素材组的左对齐 **/
function groupAlignLeft()
{
    if (media.selectedList.length <= 1) {
        return;
    }
    alignLocation('left');
}
// 上下左右，单一方向对齐
function alignLocation(attrType)
{
    // 计算，得到所有素材数据
    function getAllData()
    {
        for (i = 0;i < midList.length;i++)
        {
            tMid = midList[i];
            if (removeList.indexOf(tMid) >= 0) {                               //编组成员，跳过
                continue;
            }
            $curElem = media.tool.getSvgElementByMid(tMid);
            groupId = $curElem.getAttribute("data-groupid");

            // 存在编组
            if (!!groupId)
            {
                $$groupElems = Z("g[id^=\"svgElementSon_\"][data-groupid=\"" + groupId + "\"]");
                groupData = [];

                //遍历所有的编组成员
                for (j = 0;j < $$groupElems.length;j++)
                {
                    $groupItem = $$groupElems[j];
                    itemData = getEleClientRect($groupItem);
                    itemMid = parseInt($groupItem.getAttribute("data-mid"));
                    //需要排除的编组对象 mid
                    removeList.push(itemMid);
                    //所有编组对象的位置数据
                    groupData.push(itemData[attrType]);
                }
                if (attrType === "left" || attrType === "top") {
                    group_loc = getMinNum(groupData);
                } else {
                    group_loc = getMaxNum(groupData);
                }
                group_index = groupData.indexOf(group_loc);
                group_mid = parseInt($$groupElems[group_index].getAttribute("data-mid"));
                array_loc.push(group_loc / media.tool.showRatio);
                workList.push(group_mid);
            } else {
                elemData = getEleClientRect($curElem);
                array_loc.push(elemData[attrType] / media.tool.showRatio);
                workList.push(tMid);
            }
        }
    }
    // 循环设置每个素材的偏移
    function setEachTrans()
    {
        for (i = 0;i < array_loc.length;i++)
        {
            d = Math.round(base_loc - array_loc[i]);
            if (d === 0) {
                continue;
            }
            workMid = workList[i];
            setEachAlignLoc(workMid, attrType, d);
        }
    }

    // 主方法，定义变量
    var array_loc = [];                                                    //需要对齐的对象，距离的集合
    var workList = [];                                                     //用于计算排列的对象 mid
    var midList = Z.clone(media.selectedList);                             //选中列表的复制对象
    var removeList = [];                                                   //属于编组对象的 mid 集合，排除的 mid
    var i,j,tMid,$curElem,groupId,$$groupElems,groupData,$groupItem,itemData,
        itemMid,group_loc,group_index,group_mid,elemData,base_loc,d,workMid;

    // 1：得到素材数据
    getAllData();
    if (array_loc.length <= 1) {
        array_loc = workList = midList = removeList = null;
        return;
    }

    // 2：计算得到计算基数 base_loc
    if (attrType === "left" || attrType === "top") {           //取最小值
        base_loc = getMinNum(array_loc);
    } else {                                                 //取最大值
        base_loc = getMaxNum(array_loc);
    }

    // 3：处理每个素材的偏移
    setEachTrans();

    // 4：保存历史
    saveHistory();
    selectionToolsShow_group();
}
// 轴对齐、分布，获取有效列表 **/
function alignMultiActiveList (removeList, array_loc, workList, attrType, tMid)
{
    // 获取群组的参照位置
    function getGroupLoc()
    {
        var $$groupElems = Z("g[id^=\"svgElementSon_\"][data-groupid=\"" + groupId + "\"]");
        var groupMinList = [];
        var groupMaxList = [];

        //遍历所有的编组成员
        for (var j = 0;j < $$groupElems.length;j++)
        {
            var $groupItem = $$groupElems[j];
            var itemData = getEleClientRect($groupItem);
            var itemMid = parseInt($groupItem.getAttribute("data-mid"));
            //需要排除的编组对象 mid
            removeList.push(itemMid);
            //所有编组对象的位置数据
            if (attrType === "center" || attrType === "level") {
                groupMinList.push(itemData.left);
                groupMaxList.push(itemData.left_right);
            } else if (attrType === "middle" || attrType === "vertical") {
                groupMinList.push(itemData.top);
                groupMaxList.push(itemData.top_bottom);
            }
        }
        resultMin = getMinNum(groupMinList) / media.tool.showRatio;
        resultMax = getMaxNum(groupMaxList) / media.tool.showRatio;
    }
    // 获取单个的参照位置
    function getElemLoc()
    {
        var elemData = getEleClientRect($curElem);
        if (attrType === "center" || attrType === "level") {
            resultMin = elemData.left;
            resultMax = elemData.left_right;
        } else if (attrType === "middle" || attrType === "vertical") {
            resultMin = elemData.top;
            resultMax = elemData.top_bottom;
        }
        resultMin /= media.tool.showRatio;
        resultMax /= media.tool.showRatio;
    }

    // 主方法
    var $curElem = media.tool.getSvgElementByMid(tMid);
    var groupId = $curElem.getAttribute("data-groupid");
    var resultMin = 0;
    var resultMax = 0;
    if (!!groupId) {
        getGroupLoc();
    } else {
        getElemLoc();
    }

    // 添加结果到 array_loc 数组
    if (attrType === "center" || attrType === "middle") {
        var elemLoc = (resultMin + resultMax) / 2;
        array_loc.push(elemLoc);
    } else if (attrType === "level" || attrType === "vertical") {
        array_loc.push({
            'min' : resultMin,
            'max' : resultMax,
            'rect' : resultMax - resultMin,
        });
    }
    workList.push(tMid);
}
// 对齐每个数据
function setEachAlignLoc(workMid, attrType, d)
{
    function getElemAlignLoc ($curElem, attrType, d)
    {// 对齐的位置计算
        var x = $curElem.transform.baseVal[0].matrix.e;
        var y = $curElem.transform.baseVal[0].matrix.f;
        switch (attrType){
            case "left": x = x - Math.abs(d); break;
            case "top": y = y - Math.abs(d); break;
            case "left_right": x = x + Math.abs(d); break;
            case "top_bottom": y = y + Math.abs(d); break;
            case "center":
            case "level": x = x + d; break;
            case "middle":
            case "vertical": y = y + d; break;
        }
        return {"x": x,"y":y}
    }
    function setElemTransform(material, $elem)
    {// 给 elem 设置偏移
        alignLoc = getElemAlignLoc($elem, attrType, d);
        trans = $elem.getAttribute("transform");
        trans = trans.replace(/translate\s?\([^)]+\)/, "translate(" + alignLoc.x + " " + alignLoc.y + ")");
        $elem.setAttribute("transform",trans);
        //保存素材
        updateMaterialSource(material, $elem);
    }

    // 主方法
    var material = media.getMaterialByMid(workMid);
    var alignLoc, trans;
    if (!!material.groupId) {
        var $$groupElems = Z("g[id^=\"svgElementSon_\"][data-groupid=\"" + material.groupId + "\"]");
        var j, $groupItem, itemMid, itemMaterial;
        // 遍历所有的编组成员
        for (j = 0;j < $$groupElems.length;j++)
        {
            $groupItem = $$groupElems[j];
            itemMid = parseInt($groupItem.getAttribute("data-mid"));
            itemMaterial = media.getMaterialByMid(itemMid);
            setElemTransform(itemMaterial, $groupItem);
        }
    } else {
        setElemTransform(material, media.tool.getSvgElementByMid(workMid));
    }
}

/** 16：素材组的水平居中对齐 **/
function groupAlignCenter()
{
    if (media.selectedList.length <= 1) {
        return;
    }
    alignByaxis("center")
}
// 垂直、水平对齐
function alignByaxis(attrType)
{
    // 分情况计算得到计算基数
    function getBaseLocation()
    {
        var groupToolRect = getEleClientRect(Z("#selection_tool")[0]);
        if (attrType === "center") {
            base_loc = (groupToolRect.left + groupToolRect.left_right) / (2 * media.tool.showRatio);
        } else if (attrType === "middle") {
            base_loc = (groupToolRect.top + groupToolRect.top_bottom) / (2 * media.tool.showRatio);
        }
    }
    // 循环每个素材，设置偏移
    function setEachTrans()
    {
        for (i = 0;i < array_loc.length;i++)
        {
            var d = Math.round(base_loc - array_loc[i]);
            if (d === 0) {
                continue;
            }
            var workMid = workList[i];
            setEachAlignLoc(workMid, attrType, d);
        }
    }

    // 主方法，定义变量
    var array_loc = [];                                  //需要对齐的对象，距离的集合
    var workList = [];                                   //用于计算排列的对象 mid
    var midList = Z.clone(media.selectedList);           //选中列表的复制对象
    var removeList = [];                                 //属于编组对象的 mid 集合，排除的 mid
    var i, tMid, base_loc;

    // 1：得到所有素材的数据
    for (i = 0;i < midList.length;i++)
    {
        tMid = midList[i];
        if (removeList.indexOf(tMid) >= 0) {              //编组成员，跳过
            continue;
        }
        alignMultiActiveList (removeList, array_loc, workList, attrType, tMid);
    }

    // 2：计算得到基数 base_loc
    if (array_loc.length <= 1) {
        array_loc = workList = midList = removeList = null;
        return;
    }
    getBaseLocation();

    // 3：循环处理每个偏移
    setEachTrans();

    // 4：保存历史
    saveHistory();
    selectionToolsShow_group();
}

/** 17：素材组的右对齐 **/
function groupAlignRight()
{
    if (media.selectedList.length <= 1) {
        return;
    }
    alignLocation('left_right');
}

/** 18：素材组的顶对齐 **/
function groupAlignTop()
{
    if (media.selectedList.length <= 1) {
        return;
    }
    alignLocation('top');
}

/** 19：素材组的垂直居中对齐 **/
function groupAlignMiddle()
{
    if (media.selectedList.length <= 1) {
        return;
    }
    alignByaxis("middle");
}

/** 20：素材组的底对齐 **/
function groupAlignBottom()
{
    if (media.selectedList.length <= 1) {
        return;
    }
    alignLocation('top_bottom');
}

/** 21：素材组的垂直等间距分布 **/
function groupDistributionVertical()
{
    if (media.selectedList.length <= 1) {
        return;
    }
    groupDistribution('vertical');
}
// 等间隔分布
function groupDistribution(attrType)
{
    // 按大小重新排序，重新选中列表排序
    function reSortList()
    {
        var j, preItem, theItem, preMid, theMid;
        for (i = 0;i < array_loc.length - 1;i++)
        {
            for(j = i + 1;j < array_loc.length;j++)
            {
                preItem = Z.clone(array_loc[i]);
                theItem = Z.clone(array_loc[j]);

                if(preItem.min > theItem.min)
                {// 前者大于后者，进行替换
                    array_loc[j] = preItem;
                    array_loc[i] = theItem;

                    //workList
                    preMid = workList[i];
                    theMid = workList[j];
                    workList[j] = preMid;
                    workList[i] = theMid;
                }
            }
        }
    }
    // 位置偏移设置
    // 获取计算的必须值
    function setElemLoc()
    {
        var rectArr = [];
        var locLength = array_loc.length;
        var minLoc = array_loc[0].min;
        var conRect = 0;
        var wrapRect, space;
        for (i = 0; i < locLength; i++) {
            rectArr.push(array_loc[i].max);
            conRect += array_loc[i].rect;
        }
        wrapRect = getMaxNum(rectArr) - minLoc;
        space = (wrapRect - conRect) / (locLength - 1);

        var d, tempRect = 0;
        for (i = 0;i < workList.length;i++)
        {
            d = Math.round(minLoc + tempRect - array_loc[i].min);
            tempRect += array_loc[i].rect + space;
            if (d === 0) {
                continue;
            }
            setEachAlignLoc(workList[i], attrType, d);
        }
    }

    // 获得位置、id 数组
    var array_loc = [];                                                    //需要对齐的对象，距离的集合
    var workList = [];                                                     //用于计算排列的对象 mid
    var midList = Z.clone(media.selectedList);                             //选中列表的复制对象
    var removeList = [];
    var i, tMid;

    // 1：得到素材数据
    for (i = 0; i < midList.length; i++) {
        tMid = midList[i];
        if (removeList.indexOf(tMid) >= 0) {                               //编组成员，跳过
            continue;
        }
        alignMultiActiveList (removeList, array_loc, workList, attrType, tMid);
    }
    if (array_loc.length <= 2) {
        array_loc = workList = midList = removeList = null;
        return;
    }

    // 2：重排序数组
    reSortList();

    // 3：按新数组排序，设置每个素材
    setElemLoc();

    // 4：保存历史
    saveHistory();
    selectionToolsShow_group();
}

/** 22：素材组的水平等间距分布 **/
function groupDistributionLevel()
{
    if (media.selectedList.length <= 1) {
        return;
    }
    groupDistribution('level');
}

/** 23：图片的换图操作 **/
// 素材替换图片，完整方法：initUploaderImage2
function imageMaterialReplace(fileId,fileUrl)
{
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    var $image = $curElem.querySelector("svg image");
    material.fileId = fileId;

    $image.setAttribute("xlink:href",fileUrl);
    $image.setAttribute("href",fileUrl);

    // 保存
    updateMaterialSource(material, $curElem);
    saveHistory();
}

/** 24：容器的换图操作 **/
// 容器图片换图，完整方法：initUploaderFrameImg
function frameImageReplace(fileId,fileUrl)
{
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    var $frameImage = $curElem.querySelector(".svgFrame-img image");
    var $frameRect = $curElem.querySelector(".svgFrame-img rect");
    var rect_width = $frameRect.width.baseVal.value;
    var rect_height = $frameRect.height.baseVal.value;
    var rect_x = $frameRect.x.baseVal.value;
    var rect_y = $frameRect.y.baseVal.value;
    var rectRatio = rect_width / rect_height;

    // 计算宽高
    var thumbRect = Z("#imgUploadProgress .img")[0].getBoundingClientRect();
    var thumbRatio = thumbRect.width / thumbRect.height;
    var image_width , image_height;
    if (thumbRatio > rectRatio)
    {
        image_height = rect_height;
        image_width = image_height * thumbRatio;
    }
    else
    {
        image_width = rect_width;
        image_height = image_width / thumbRatio;
    }

    var trans_x = (rect_width - image_width) / 2 + rect_x;
    var trans_y = (rect_height - image_height) / 2 + rect_y;
    var image_trans = "translate("+ trans_x +" "+ trans_y +")";

    // 写入参数
    material.fileId = fileId;
    $frameImage.setAttribute("xlink:href",fileUrl);
    $frameImage.setAttribute("href",fileUrl);
    $frameImage.setAttribute("width",image_width);
    $frameImage.setAttribute("height",image_height);
    $frameImage.setAttribute("transform",image_trans);
    // 保存
    updateMaterialSource(material, $curElem);
    saveHistory();
}

/** 25：形状线条的端点形状修改 **/
function switchLineCap(capStyle)
{
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    var $svg = $curElem.querySelector("svg");
    var svgType = $svg.getAttribute("data-type");
    var $line = $curElem.querySelector("line");
    if (material.type !== 5 || svgType !== "shape-line" || !$line){
        return;
    }
    $line.setAttribute("stroke-linecap",capStyle);
    var lineWidth = $svg.viewBox.baseVal.width;
    var setX1, setX2;
    switch (capStyle)
    {
        // 方角
        case "butt": setX1 = 0; setX2 = lineWidth; break;
        // 圆角
        case "round": setX1 = parseFloat($line.getAttribute("y1")); setX2 = lineWidth - setX1; break;
    }
    $line.setAttribute("x1",setX1);
    $line.setAttribute("x2",setX2);
}

/** 26：显示线条的虚线编辑框 **/
function showLineDashBox(event)
{
    // 主方法，定义变量
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    if (!material || !$curElem){
        return;
    }
    var $lineDashBox = Z.D.id('shapeLine_dash_box');
    var $line = $curElem.querySelector("svg>g>line");
    var dashArray = $line.getAttribute("stroke-dasharray").split(" ");
    var dashVal1 = dashArray[0] || 1;
    var dashVal2 = dashArray[1] || 0;

    // 1：定位编辑框
    showMiniPopupBox(event, $lineDashBox);

    // 2：赋值
    Z("#shapeLine_dasharray1>.range>i").css("left", dashVal1/2 + "%");
    Z("#shapeLine_dasharray1>.num>input").val(dashVal1);
    Z("#shapeLine_dasharray2>.range>i").css("left", dashVal2/2 + "%");
    Z("#shapeLine_dasharray2>.num>input").val(dashVal2);
}

/** 27：显示形状的边框设置 **/
function showShapeStrokeBox(event)
{
    // 依类型显示输入框
    function showTheShapeBox()
    {
        showMiniPopupBox(event, $shapeStrokeBox);
        Z('#shape_stroke_box .shapeStrokeBox-item').hide();
        if (shapeType === 'shape-rectStroke' || shapeType === 'shape-table') {
            Z('#shape_stroke_box .item-strokeSize').show();
        } else if (shapeType === 'shape-ellipse'){
            Z('#shape_stroke_box .item-strokeColor,#shape_stroke_box .item-strokeRange').show();
        } else if (shapeType === 'shape-pen') {
            Z('#shape_stroke_box .item-strokeSize,#shape_stroke_box .item-strokeColor').show();
        }
    }
    // 对编辑框赋值、颜色按钮类型赋值
    function setTheShapeBox()
    {
        var strokeWidth = 0;
        var strokeColor = '#ffffff';
        var strokeRangeNum = 0;
        var strokeRange = 0;
        var colorType = 'ellipseStroke';
        switch (shapeType)
        {
            case 'shape-rectStroke':
                strokeWidth = parseFloat($svg.getAttribute("data-rectstroke"));
                break;
            case 'shape-ellipse':
                var $ellipse = $curElem.querySelector("ellipse");
                strokeColor = $ellipse.getAttribute("stroke");
                var viewWidth = $svg.viewBox.baseVal.width;
                var viewHeight = $svg.viewBox.baseVal.height;
                var viewR = getMinNum([viewWidth,viewHeight])/2;
                strokeRangeNum = parseFloat($ellipse.getAttribute("stroke-width"));
                strokeRangeNum = strokeRangeNum / viewR * 100;
                strokeRange = strokeRangeNum + "%";
                break;
            case 'shape-pen':
                var $path = $curElem.querySelector("path");
                strokeWidth = $path.getAttribute("stroke-width");
                strokeColor = $path.getAttribute("stroke");
                colorType = 'penStroke';
                break;
            case 'shape-table':
                var $line = $curElem.querySelector("line");
                strokeWidth = Math.round(parseFloat($line.getAttribute("stroke-width") || 0) * 100)/100;
                break;
        }
        Z("#shapeStroke_strokeSize").val(strokeWidth);
        Z("#shapeStroke_strokeColor").css("backgroundColor",strokeColor);
        Z("#shapeStroke_strokeRange>.num>input").val(strokeRangeNum);
        Z("#shapeStroke_strokeRange>.range>i").css("left", strokeRange);
        Z("#shapeStroke_strokeColor").attr('data-type', colorType);
    }

    // 主方法，定义变量
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    if (!material || !$curElem){
        return;
    }
    var $shapeStrokeBox = Z.D.id('shape_stroke_box');
    var $svg = $curElem.querySelector("svg");
    var shapeType = $svg.getAttribute('data-type');
    // 1：定位编辑框
    showTheShapeBox();
    // 2：赋值
    setTheShapeBox();
}

/** 28：图片/容器的裁剪 **/
function imageCutStart()
{
    // 主方法，定义变量
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    if (!material || !$curElem){
        return;
    }

    // 1：显示剪切工具
    if (material.type === 0 || material.type === 2){
        mediaEvent.showCutImage(material, $curElem);
    } else if (material.type === 4){
        mediaEvent.showTrimFrameImg();
    }
}

/** 29：显示图片/形状圆角设置 **/
function showCurElemRadiusBox()
{
    // 显示圆角编辑框
    function showRadiusBox()
    {
        var $rectMore = Z('.radiusRange-shapeBox');
        showMiniPopupBox(event, $radiusBox);
        if (material.type === 5){
            $rectMore.show();
        } else {
            $rectMore.hide();
        }
    }
    // 为圆角编辑框赋值
    function setRadiusBox()
    {
        // 赋值矩形圆角值
        function setRectRadius()
        {
            $mainRadius.attr('id', 'shapeRectRadius');
            showRectRadiusValue();
        }
        // 赋值图片圆角值
        function setImageRadius()
        {
            $mainRadius.attr('id', 'imageRadius');
            var $clipRect = Z($svg).find("defs>clipPath>rect")[0];
            var radius = ($clipRect) ? (parseInt($clipRect.getAttribute("rx"))) : (0);
            $mainRadius.find('.range>i').css("left", radius * 2 + "%");
            $mainRadius.find('.num>input').val(radius);
        }

        // 主方法
        $radiusBox.targMaterial = material;
        $radiusBox.targElement = $curElem;

        var $mainRadius = Z($radiusBox).children('.itemWrap');
        if (material.type === 5)
            setRectRadius();
        else
            setImageRadius();
    }

    // 主方法，定义变量
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    if (!material || !$curElem){
        return;
    }
    var $radiusBox = Z.D.id('radiusRange_box');
    var $svg = $curElem.querySelector("svg");
    var shapeType = $svg.getAttribute('data-type');
    if (material.type !== 0 && material.type !== 2 && material.type !== 5)
        return;

    if (material.type === 5)
        if (shapeType !== 'shape-rect' && shapeType !== 'shape-rectStroke' && shapeType !== 'shape-table')
            return;

    // 1：定位编辑框
    showRadiusBox();

    // 2：编辑框赋值
    setRadiusBox();
}
// 赋值矩形的圆角编辑框
function showRectRadiusValue(onlyMore)
{
    var $radiusBox = Z.D.id('radiusRange_box');
    var $mainRadius = Z($radiusBox).children('.itemWrap');
    // 显示素材属性
    var $curElem = $radiusBox.targElement || media.tool.getCurSvgElement();
    var $svg = $curElem.querySelector("svg");
    var absX = Math.abs($svg.viewBox.baseVal.width);
    var absY = Math.abs($svg.viewBox.baseVal.height);
    var nw_r = $svg.querySelector("path.nw").getAttribute("data-radius");
    var ne_r = $svg.querySelector("path.ne").getAttribute("data-radius");
    var sw_r = $svg.querySelector("path.sw").getAttribute("data-radius");
    var se_r = $svg.querySelector("path.se").getAttribute("data-radius");
    var mL = getMinNum([absX,absY])/2;
    //滑块位置、输入值
    var nw_per = Math.round(nw_r/mL * 100);
    var ne_per = Math.round(ne_r/mL * 100);
    var sw_per = Math.round(sw_r/mL * 100);
    var se_per = Math.round(se_r/mL * 100);
    if (!onlyMore){
        $mainRadius.find('.range>i').css("left", nw_per + "%");
        $mainRadius.find('.num>input').val(nw_per);
    }
    Z("#shapeRectRadius_nw>.range>i").css("left", nw_per + "%");
    Z("#shapeRectRadius_nw>.num>input").val(nw_per);
    Z("#shapeRectRadius_ne>.range>i").css("left", ne_per + "%");
    Z("#shapeRectRadius_ne>.num>input").val(ne_per);
    Z("#shapeRectRadius_sw>.range>i").css("left", sw_per + "%");
    Z("#shapeRectRadius_sw>.num>input").val(sw_per);
    Z("#shapeRectRadius_se>.range>i").css("left", se_per + "%");
    Z("#shapeRectRadius_se>.num>input").val(se_per);
}

/** 30：复制素材 **/
function copyMaterial(idObjArr)
{
    // 复制指定素材属性，返回新素材
    function copyAttributeToNew(material)
    {
        var newMaterial = {};
        var j, $g0, transExp, trans, transX, transY;
        for (j in material)
        {
            if (j === "source")
            {
                $g0 = Z(material[j])[0];
                trans = $g0.getAttribute("transform");
                transExp = /-?\d+(.\d+)?(\s|,)-?\d+(.\d+)?/.exec(trans)[0];
                transExp = transExp.split(/[^-\d.]/);
                transX = parseFloat(transExp[0]) + 10;
                transY = parseFloat(transExp[1]) + 10;
                trans = trans.replace(/translate\([^)]+\)/,"translate(" + transX + " " + transY + ")");
                $g0.setAttribute("transform", trans);
                newMaterial[j] = $g0.outerHTML;
                continue;
            }
            if (j === 'wordsList') {
                newMaterial[j] = Z.clone(material[j]);
                continue;
            }
            newMaterial[j] = material[j];
        }
        return newMaterial;
    }

    // 1：获取mid、bid列表
    setIdArr(idObjArr);
    var midLength = midArr.length;
    if (midLength === 0)
        return;

    // 复制操作，循环处理
    var materialLength;
    var newMaterial = {};
    var groupIdArr = [];
    var groupIdNewArr = [];
    var i;
    media.clearSelected();
    for (i = 0;i < midLength;i++)
    {
        newMaterial = copyAttributeToNew(media.getMaterialByMid(midArr[i], bidArr[i]));
        materialLength = media.getBgMaterialList(media.curPage).length;
        addMediaMaterial(newMaterial, groupIdArr, groupIdNewArr);
    }
    media.tool.setTempCurrent();
    // 存储历史
    selectTheElement_group();
    saveHistory();
}
// 新增素材到媒体media，重定义 groupId
function addMediaMaterial(newMaterial, groupIdArr, groupIdNewArr)
{
    var groupId = newMaterial.groupId;
    var tempMaterial = newMediaMaterial(newMaterial);
    media.tool.createSvgGElement(tempMaterial);
    tempMaterial.groupId = groupId;
    media.addMaterial(tempMaterial);
    tempMaterial.doMutliSelected();
    // 重定义 groupId
    if (!groupId)
        return;
    var newTime, newGroupId, idIndex;
    idIndex = groupIdArr.indexOf(groupId);
    if (idIndex === -1) {
        newTime = new Date().getTime();
        newGroupId = "group_" + newTime;
        while (groupIdNewArr.indexOf(newGroupId) !== -1){
            newTime++;
            newGroupId = "group_" + newTime;
        }
        groupIdArr.push(groupId);
        groupIdNewArr[groupIdArr.length - 1] = newGroupId;
        tempMaterial.groupId = newGroupId;
    } else {
        tempMaterial.groupId = groupIdNewArr[idIndex];
    }
    media.tool.getSvgElementByMid(tempMaterial.mid).setAttribute('data-groupid', tempMaterial.groupId);
}

/** 31：切换素材锁定状态 **/
function switchMaterialLock(event)
{
    // 主方法，定义变量
    var selectedLength = media.selectedList.length;
    if (selectedLength === 0) {
        return;
    }
    var $lockBtn = Z('#tool_lock');
    var type = 'doLock';
    var i, material, $curElem;
    if ($lockBtn.find('.icon-lock')[0]){
        type = 'unLock';
    }

    // 1：执行操作，循环处理
    for (i = 0;i < selectedLength;i++)
    {
        material = media.getCurMaterial(i);
        // 执行解锁
        if (type === 'unLock')
            unlockMaterial(event, material, media.tool.getCurSvgElement(i));
        // 执行锁定
        else
            doLockMaterial(event, material);
    }

    // 2：更新保存
    saveHistory();
}

/** 32：显示翻转编辑框 **/
function showReversalBox(event)
{
    // 主方法，定义变量
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    if (!material || !$curElem){
        return;
    }
    var $reversalBox = Z.D.id('setReversal_box');

    // 1：定位编辑框
    showMiniPopupBox(event, $reversalBox);
}

/** 33：显示排序编辑框 **/
function showSortBox()
{
    // 主方法，定义变量
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    if (!material || !$curElem){
        return;
    }
    var $reversalBox = Z.D.id('sort_box');

    // 1：定位编辑框
    showMiniPopupBox(event, $reversalBox);
}

/** 34：显示透明度编辑框 **/
function showOpacityRange()
{
    // 主方法，定义变量
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    if (!material || !$curElem){
        return;
    }
    var $reversalBox = Z.D.id('opacityRange');
    var $itemWrap = Z($reversalBox).children('.itemWrap');

    // 1：定位编辑框
    showMiniPopupBox(event, $reversalBox);

    // 2：属性绑定
    $reversalBox.targMaterial = material;
    $reversalBox.targElement = $curElem;

    // 3：赋值
    var opacity = 100;
    var transArr = [];
    var i, showOpacity;
    for (i = 0;i < media.selectedList.length;i++)
    {
        $curElem = media.tool.getCurSvgElement(i);
        showOpacity = parseFloat($curElem.getAttribute("fill-opacity")) || 1;
        transArr.push(Math.round(showOpacity * 100));
    }
    // 只有一个数据，或者都相等，则取其值
    if (transArr.length === 1 || getMaxNum(transArr) === getMinNum(transArr))
        opacity = transArr[0];
    // 显示当前素材透明比
    $itemWrap.find('.range>i').css("left", opacity + "%");
    $itemWrap.find('.num>input').val(opacity);
}

/** 35：显示透明度编辑框 **/
function showRotateBox(event)
{
    // 主方法，定义变量
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    if (!material || !$curElem){
        return;
    }
    var rotate = $curElem.transform.baseVal[1].angle;
    var $rotateBox = Z.D.id('rotateRange');
    var $input = Z($rotateBox).find('.num>input');

    // 1：定位编辑框
    showMiniPopupBox(event, $rotateBox);

    // 2：属性绑定
    $rotateBox.targMaterial = material;
    $rotateBox.targElement = $curElem;

    // 3：赋值
    $input.val(rotate);
}

/** 36：删除素材 **/
function deleteMaterial(noSave)
{
    var selectedLength = media.selectedList.length;
    // 不存在选中素材，返回
    if (selectedLength === 0) {
        return;
    }
    // 循环删除所有
    while (media.selectedList.length > 0)
    {
        var material = media.getCurMaterial(0);
        var $curElem = media.tool.getSvgElementByMid(material.mid);

        // 有设置参数，则取消已设置的参数列表
        if (!!material.paramKey && !!material.paramName)
        {
            var $paramLi = Z("#paramList li[data-param=\"" + material.paramKey + "," + material.paramName + "\"]");
            //页面呈现
            Z($paramLi).removeAttr("data-mid");
            Z($paramLi).removeAttr("data-bid");
            Z($paramLi).find(".paramList-status").removeClass("setted");
        }

        // 删除素材、元素
        material.doDelete();
        Z($curElem).remove();
    }

    media.clearSelected();

    // 保存
    if (!noSave) saveHistory();
    hideEditSelected(true);
}

/************************************
************ 素材属性更新 ***********
*************************************/
/** 位置更新 **/
function updateMaterialPos(x, y, index)
{
    var material = media.getCurMaterial(index);
    var $curElem = media.tool.getCurSvgElement(index);
    if (!material || !$curElem) {
        return;
    }

    updateSvgLocation(x, y, index);
    updateMaterialSource(material, $curElem);
    if (media.selectedList.length === 1) {
        setToolStaticLoc();
    }
}

/************************************
********** 编辑框的显示和隐藏 ********
*************************************/
/** 弹窗显示通用方法 **/
function showMiniPopupBox(event, $popup)
{
    docPopupReset(event);
    var $thisBtn = Z(Z.E.current(event));
    var setLeft = $thisBtn.offsetLeft() - 2;
    var setTop = $thisBtn.offsetTop() + $thisBtn.offsetHeight() + 9;

    // 计算和工具条的位置偏移，不超出工具条两端
    var toolBarRect = Z.D.id('toolbar').getBoundingClientRect();
    var popupRect = $popup.getBoundingClientRect();
    var maxLeft = setLeft + popupRect.width - toolBarRect.width;
    if (maxLeft > 0){
        setLeft -= maxLeft;
    }
    setLeft = setLeft > 0 ? setLeft : 0;

    // 设置位置
    Z($popup).css({"left": setLeft,"top": setTop});
}

/** 显示更多圆角设置 **/
function shapeRectRadiusMoreShow(){
    Z("#radiusRange_box").addClass("showMore");
}
/** 隐藏更多圆角设置 **/
function shapeRectRadiusMoreHide(){
    Z("#radiusRange_box").removeClass("showMore");
}

/************************************
 ********** 选择框的操作事件 ********
 *************************************/
function selectionToolContextMenu(event)
{
    var selectLength = media.selectedList.length;
    if (selectLength === 0)
        return;
    var material = media.getCurMaterial();
    if (material.status === 3) {
        createContextMenu({
            "event": event,
            "elemId": "selectionToolUnlockMenu",
            "editItem": [
                ["解锁","unlockMaterial"],
            ],
        });
        return;
    }
    createContextMenu({
        "event": event,
        "elemId": "selectionToolMenu",
        "editItem": [
            ["复制","contextMenuCopy"],
            ["锁定","doLockMaterial"],
            ["删除","deleteMaterial"],
            [],
            ["上移一层","downMaterial"],
            ["下移一层","upMaterial"],
            ["置顶图层","bottomMaterial"],
            ["置底图层","topMaterial"],
            [],
            ['添加到"我的素材"',"addToCollectionList"],
        ],
    });
}

/*************************************
************** 素材操作 **************
*************************************/
/*** 选中素材 ***/
function selectTheElement(material, $curElem)
{
    $curElem = $curElem || media.tool.tempElement || media.tool.getCurSvgElement();
    if (!$curElem) {
        return;
    }
    if (!material) {
        material = media.getMaterialByMid(Z($curElem).attr("data-mid"));
    }
    // 去除编辑工具
    mediaEvent.removeAllEditTool();

    // 通常单个素材选中
    material.doSelected();

    // 记录对象数据
    mediaEvent.startData.targData = media.tool.getEleData($curElem);

    //设置tempCurrent
    media.tool.setTempCurrent(material,$curElem);
    
    //显示缩放框，并绑定拖动事件
    if (material.status === 0) {
        selectionTool_show();
    } else if (material.status === 3) {
        selectionLock_show();
    }

    // 显示编辑工具条
    showEditToolbar();

    // 文字类型，额外处理
    if (material.type === 1)
    {
        // 插入内容到文本编辑器
        mediaEvent.insertToSideEditor(material);
        // 侧边栏对齐样式
        Z("#sideTextEditor").css("text-align",material.textAlign);
    }

    if (Z.T.isFunction(getXY))
    {// 显示坐标值
        var suffix = media.canvas.createMode === 1 ? "px" : "mm";
        Z("#xy_site").text("");
        Z("#wh_site").text("");
        var xy = getXY($curElem);
        Z("#xy_site").text("位置，X：" + xy[0] + suffix + "   Y：" + xy[1] + suffix);
        var wh = getWH($curElem);
        Z("#wh_site").text("尺寸，W：" + wh[0] + suffix + "   H：" + wh[1] + suffix);
    }

    // 选中图层
    var layerItem = Z(media.tool.$layerList).find("li[data-mid='" + material.mid + "']");
    if (layerItem.length !== 0) {
        layerItem.addClass("active").siblings("li").removeClass("active");
    } else {
        Z(media.tool.$layerList).children("li").removeClass("active");
    }
}
function selectTheElement_group()
{//多素材，选中
    if (media.selectedList.length === 0)
        return;

    // 单素材
    if (media.selectedList.length === 1)
        return selectTheElement();

    // 显示工具栏
    selectionToolsShow_group();
}

/** 复制素材，仅保存数据 **/
function copyMaterialData()
{
    if (media.selectedList.length <= 0)
        return;
    media.tool.tempMetabolic = [];
    var bid = media.curPage;
    for (var i = 0;i < media.selectedList.length;i++) {
        media.tool.tempMetabolic.push({"bid": bid, "mid": media.selectedList[i]});
    }
}
/** 复制素材，跨版面复制 **/
function copyOverPage()
{
    //剪切板，重新赋值
    var materialList = [];
    var i, j, material, newMaterial;
    for (i = 0;i < media.selectedList.length;i++)
    {
        material = media.getCurMaterial(i);
        newMaterial = {};
        for (j in material)
        {
            if (j === "$media"||j === "bid"||j === "fileId"||j === "immediate"||j === "mediaId"||j === "mid"||j === "paramKey"||
                j === "paramName"||j === "pos"||j === "selected"||j === "status"||j === "defaults") {
                continue;
            }
            if (Z.T.isFunction(material[j])){
                continue;
            }
            if (j === 'wordsList') {
                newMaterial[j] = Z.clone(material[j]);
                continue;
            }
            newMaterial[j] = material[j];
        }
        materialList.push(newMaterial);
    }
    var materialListStr = Z.J.toString(materialList);
    localStorage.setItem("materialListStr",materialListStr);
}
/** 粘贴素材，跨版面粘贴 **/
function pasteOverPage()
{
    // 关闭加载框
    function closeLoading()
    {
        setTimeout(function(){
            pasteLoading.close();
        },500)
    }

    // 1：显示在加框
    var pasteLoading = Z.loading({
        shadow: true,
        text:"正在加载..."
    });
    // 2：判断数据
    var materialListStr = localStorage.getItem("materialListStr");
    if (!materialListStr) {
        return closeLoading();
    }
    // 3：循环新建/粘贴素材
    var materialList = Z.J.toObject(materialListStr);
    var i, material, groupId;
    var groupIdArr = [];
    var groupIdNewArr = [];
    media.clearSelected();
    for (i = 0;i < materialList.length;i++)
    {
        groupId = materialList[i].groupId;
        material = newMediaMaterial(materialList[i]);
        material.groupId = groupId;
        addMediaMaterial(material, groupIdArr, groupIdNewArr);
    }
    // 4：选中新素材
    selectTheElement_group();
    // 5：保存历史
    saveHistory();
    // 6：关闭加载框
    closeLoading();
}

/** 执行素材锁定 */
function doLockMaterial(event, material)
{
    // 定义变量
    material = material || media.tool.tempMaterial || media.getCurMaterial();
    if (!material) {
        return;
    }

    // 1：素材锁定
    material.doLock();

    // 2：编辑条样式修改
    var $lockBtn = Z('#tool_lock');
    var $iconFont = $lockBtn.find('.iconfont');
    $toolsWrapLeft.addClass("eventDisable");
    $lockBtn.removeClass("eventDisable").siblings().addClass("eventDisable");
    $iconFont.removeClass('icon-unlock').addClass('icon-lock').addClass('z-text-orange');

    // 3：画布内样式修改
    selectionTool_hide();
    if (media.selectedList.length === 1) {
        selectionToolsShow("#selection_lock", media.tool.getSvgElementByMid(material.mid));
    }
}
/** 执行素材解锁 **/
function unlockMaterial(event, material, $curElem)
{
    // 定义变量
    material = material || media.tool.tempMaterial || media.getCurMaterial();
    $curElem = $curElem || media.tool.tempElement || media.tool.getCurSvgElement();
    if (!material) {
        return;
    }

    // 1：素材解锁
    material.unLock();

    // 2：背景属性去除
    if (material.bgMaterial)
    {
        material.bgMaterial = false;
        $curElem.removeAttribute('data-bgmaterial');
    }

    // 3：编辑条样式修改
    var $lockBtn = Z('#tool_lock');
    var $iconFont = $lockBtn.find('.iconfont');
    $toolsWrapLeft.removeClass("eventDisable");
    $lockBtn.parent().find('.tool-item').removeClass("eventDisable");
    $iconFont.removeClass('icon-lock').removeClass('z-text-orange').addClass('icon-unlock');

    // 4：画布内样式修改
    selectionLock_hide();
    if (media.selectedList.length === 1) {
        selectTheElement(material, media.tool.getSvgElementByMid(material.mid));
    }

    // 5：刷新图层列表
    loadLayerList();
}

/** 上移素材 */
function upMaterial()
{
    if (media.selectedList.length == 0)
    {// 不存在选中素材，返回
        return;
    }
    // 正序循环
    var i, material, preMaterial, $curElem, $preElem;
    for (i = 0;i < media.selectedList.length;i++)
    {
        material = media.getCurMaterial(i);
        if (i === 0 && material.pos === 0)
        {// 第一个素材为置顶，则不处理
            return;
        }

        // 页面节点
        $curElem = media.tool.getCurSvgElement(i);
        $preElem = $curElem.previousElementSibling;
        if (!!$preElem && /^svgElementSon_/.test($preElem.id))
        {
            preMaterial = media.getMaterialByMid(Z($preElem).attr("data-mid"));
            if (preMaterial.bgMaterial)
                continue;
            media.tool.$canvasMaterial.insertBefore($curElem, $preElem);
        } else {
            continue;
        }

        // 检查上一个素材是否删除状态，如果是则上移，否则跳出循环
        preMaterial = media.getMaterial(material.bid, material.pos - 1);
        while (preMaterial && preMaterial.status === 1)
        {
            material.doUp();
            preMaterial = media.getMaterial(material.bid, material.pos - 1);
        }
        // 执行上移操作
        material.doUp();
    }
    saveHistory();
}
/** 下移素材 */
function downMaterial()
{
    if (media.selectedList.length === 0)
    {//不存在选中素材，返回
        return;
    }
    //倒序循环
    var i, material, preMaterial, $curElem, $nextElem;
    for (i = media.selectedList.length - 1;i > -1;i--)
    {
        material = media.getCurMaterial(i);
        if (i === media.selectedList.length - 1 && material.pos === media.getBgMaterialList(media.curPage).length - 1)
        {// 最后一个素材为置底，则不处理
            return;
        }

        // 页面节点
        $curElem = media.tool.getCurSvgElement(i);
        $nextElem = $curElem.nextElementSibling;
        if (!!$nextElem && /^svgElementSon_/.test($nextElem.id)) {
            media.tool.$canvasMaterial.insertBefore($nextElem, $curElem);
        } else {
            continue;
        }

        // 检查上一个素材是否删除状态，如果是则上移，否则跳出循环
        preMaterial = media.getMaterial(material.bid, material.pos-1);
        while (preMaterial && preMaterial.status === 1)
        {
            material.doDown();
            preMaterial = media.getMaterial(material.bid, material.pos-1);
        }
        // 执行下移操作
        material.doDown();
    }
    saveHistory();
}
/** 置顶素材 */
function topMaterial()
{
    if (media.selectedList.length === 0)
    {//不存在选中素材，返回
        return;
    }
    //倒序循环
    var i, material, $curElem;
    var $canvasMaterial = media.tool.$canvasMaterial;
    var $firstElem = $canvasMaterial.querySelector('g[id^="svgElementSon_"]:not([data-bgmaterial])');
    var firstMaterial = media.getMaterialByMid($firstElem.getAttribute('data-mid'));
    for (i = media.selectedList.length - 1;i > -1;i--)
    {
        material = media.getCurMaterial(i);
        while (material.pos > firstMaterial.pos){
            material.doUp();
        }
        // 更新画布
        $curElem = media.tool.getCurSvgElement(i);
        $canvasMaterial.insertBefore($curElem, $firstElem);
    }
    saveHistory();
}
/** 置底素材 */
function bottomMaterial()
{
    if (media.selectedList.length === 0)
    {//不存在选中素材，返回
        return;
    }
    var length = media.getBgMaterialList(media.curPage).length-1;
    //正序循环
    var i, material, $curElem;
    var $canvasMaterial = media.tool.$canvasMaterial;
    var $lastElem = $canvasMaterial.querySelector('g[id^="svgElementSon_"]:not([data-bgmaterial]):last-child');
    for (i = 0;i < media.selectedList.length;i++)
    {
        material = media.getCurMaterial(i);
        $curElem = media.tool.getCurSvgElement(i);
        if ($curElem === $lastElem)
            continue;

        while (material.pos < length){
            material.doDown();
        }
        // 更新画布
        $canvasMaterial.insertBefore($curElem, $lastElem);
        $canvasMaterial.insertBefore($lastElem, $curElem);
    }
    saveHistory();
}

/** 将素材设置为“背景” */
function setBeBgMaterial(event, material, $curElem)
{
    // 1：变量定义
    material = material || media.tool.tempMaterial || media.getCurMaterial();
    $curElem = $curElem || media.tool.tempElement || media.tool.getCurSvgElement();
    if (!material || !$curElem)
        return;

    // 2：删除当前“背景”
    var $canvasMaterial = media.tool.$canvasMaterial;
    var $bgWrap = media.tool.$canvasBg;
    if ($bgWrap.querySelector("svg")) {
        $bgWrap.removeChild($bgWrap.querySelector("svg"));
    }
    // 1.1：纯背景
    Z('#bg_color').addClass('bgNone');
    var $bgFillSvg = media.tool.createBgSvgElement();
    var bgObj = media.getBg(media.curPage);
    bgObj.bgUrl = null;
    bgObj.bgMinUrl = null;
    bgObj.fileId = null;
    bgObj.source = $bgFillSvg.outerHTML;
    // 1.2：图层背景
    var $firstElem = $canvasMaterial.querySelector('g[id^="svgElementSon_"][data-bgmaterial]');
    if ($firstElem)
    {
        var firstMaterial = media.getMaterialByMid($firstElem.getAttribute('data-mid'));
        if (firstMaterial.bgMaterial)
        {
            firstMaterial.doDelete();
            Z($firstElem).remove();
        }
        else
        {
            $firstElem.removeAttribute('data-bgmaterial');
        }
    }

    // 3：节点属性设置[data-bgmaterial]
    $curElem.setAttribute('data-bgmaterial', 'bgmaterial');
    updateMaterialSource(material, $curElem);

    // 4：属性设置，执行“置底”
    material.status = 3;
    material.bgMaterial = true;
    while (material.pos > 0) {
        material.doUp();
    }

    // 5：素材节点位置“置底”
    $canvasMaterial.insertBefore($curElem, media.tool.$canvasSvg.querySelector('g[id^="svgElementSon_"]'));

    // 6：选中当前素材
    selectTheElement(material, $curElem);

    // 7：保存历史
    saveHistory();
}

/** 素材翻转，水平、垂直翻转 **/
function doReversal(a, d)
{
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    if (!material || !$curElem) {
        return;
    }
    var $gSvg = $curElem.querySelector("g");
    if (!$gSvg) {
        return;
    }

    var rA = a, rD = d;
    var gVal = $gSvg.transform.baseVal;
    var rMatrix = {"a":1, "d":1};
    for (var i = 0;i < gVal.length;i++){
        if (gVal[i].type === 3) {
            rMatrix = gVal[i].matrix;
        }
    }

    material.reversal = rA ? (rMatrix.a === 1 ? -1 : 1) + " " + rMatrix.d
        : rMatrix.a + " " + (rMatrix.d === 1 ? -1 : 1);

    setReversal(material, $curElem);

    updateMaterialSource(material, $curElem);
    saveHistory();
}


/*************************************
 ************** 更新操作 **************
 *************************************/
/** 尺寸设置---输入框变化 **/
function doChangeSvgSize(event)
{
    // 线条的尺寸设置
    function setShapeLineSize()
    {
        var $line = $curElem.querySelector("line");
        $line.setAttribute("x2", setWidth);
        $line.setAttribute("stroke-width", setHeight);
        $line.setAttribute("y1", setHeight / 2 + '');
        $line.setAttribute("y2", setHeight / 2 + '');

        // rect、svg 宽高
        $svg.setAttribute("viewBox", "0 0 " + setWidth + " " + setHeight);
        setRectSize();
    }
    // 矩形的尺寸设置
    function setShapeRectSize(funName)
    {
        viewWidth = viewRatio * setWidth;
        viewHeight = viewRatio * setHeight;

        if (funName === 'drawRectStrokeResize')
        {// 空心矩形，矩形框特殊设置
            var mL = getMinNum([viewWidth, viewHeight]) / 2;
            var stroke_width = parseFloat($svg.getAttribute("data-rectstroke") || 5);
            stroke_width = stroke_width > mL ? mL : stroke_width;
            $svg.setAttribute("data-rectstroke", stroke_width + "");
        }

        // 绘制矩形
        if (mediaEvent[funName]($svg, viewWidth, viewHeight)){
            $svg.setAttribute("viewBox","0 0 " + viewWidth + " " + viewHeight);
            setRectSize();
        } else {
            Z.alert("输入有误！");
            if(media.canvas.createMode === 0) {
                svgWidth = px2mm(svgWidth, media.canvas.dpi);
                svgHeight = px2mm(svgHeight, media.canvas.dpi);
            }
            $widthInput.value = svgWidth;
            $heightInput.value = svgHeight;
        }
    }
    // 圆形的尺寸设置
    function setShapeEllipseSize()
    {
        var $ellipse = $curElem.querySelector("ellipse");
        var stroke = parseFloat($ellipse.getAttribute("stroke-width"));
        viewWidth = viewRatio * setWidth;
        viewHeight = viewRatio * setHeight;

        $ellipse.setAttribute("cx", viewWidth / 2 - stroke + '');
        $ellipse.setAttribute("cy", viewHeight / 2 - stroke + '');
        $ellipse.setAttribute("rx", viewWidth / 2 - stroke * 2 + '');
        $ellipse.setAttribute("ry", viewHeight / 2 - stroke * 2 + '');

        // rect、svg 宽高
        $svg.setAttribute("viewBox","0 0 " + viewWidth + " " + viewHeight);
        setRectSize();
    }
    // 表格的尺寸设置
    function setShapeTableSize()
    {
        $rect.setAttribute("width", setWidth);
        $rect.setAttribute("height", setHeight);
        var $$svgTable = $curElem.querySelector("g").children;
        [].forEach.call($$svgTable, $svg => {
            if ($svg.tagName.toLowerCase() !== "svg")
                return;
            $svg.setAttribute("width", setWidth);
            $svg.setAttribute("height", setHeight);
        })
    }
    // 设置 rect、svg 的宽高
    function setRectSize()
    {
        var textZoom = material.textZoom.split(" ");
        material.width = setWidth / parseFloat(textZoom[0]);
        material.height = setHeight / parseFloat(textZoom[1]);

        $svg.setAttribute("width", setWidth);
        $svg.setAttribute("height", setHeight);
        $rect.setAttribute("width", setWidth);
        $rect.setAttribute("height", setHeight);
    }
    // 设置素材的宽高属性
    function setSvgSize()
    {
        var materialType = $toolsWrap.attr('data-type');
        var secondType = $toolsWrap.attr('data-second');

        // 形状分类
        if (materialType === 'shape' && secondType)
        {
            switch (secondType)
            {
                case 'shape-line': setShapeLineSize(); break;
                case 'shape-rect': setShapeRectSize('drawRectResize'); break;
                case 'shape-rectStroke': setShapeRectSize('drawRectStrokeResize'); break;
                case 'shape-ellipse': setShapeEllipseSize(); break;
                case 'shape-table': setShapeTableSize(); break;
            }
        }
        // 基本素材分类
        else
        {
            switch (materialType)
            {
                case 'text': break;
                default : setRectSize(); break;
            }
        }
    }
    // 判断是否存在锁定宽高，重新计算宽高值
    function isLockScale()
    {
        if (!Z($lockWrap).hasClass('active'))
            return;
        if (!sizeScale) {
            Z($lockWrap).removeClass('active');
            return;
        }
        if ($targetInput === $widthInput) {
            setHeight = parseFloat((setWidth / sizeScale).toFixed(4));
            $heightInput.value = setHeight;
        } else {
            setWidth = parseFloat((setHeight * sizeScale).toFixed(4));
            $widthInput.value = setWidth;
        }
    }

    // 主方法
    var $targetInput = Z.E.target(event);
    var $lockWrap = $targetInput.parentElement.parentElement.querySelector('.scaleLockWrap');
    var $widthInput = Z.D.id('svgSize_width');
    var $heightInput = Z.D.id('svgSize_height');
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    var $rect = $curElem.querySelector("rect");
    var $svg = $curElem.querySelector("svg");

    // 1：常量获取
    if (material.status !== 0){
        return;
    }
    var setWidth = $widthInput.value;
    var setHeight = $heightInput.value;
    var viewWidth = $svg.viewBox.baseVal.width;
    var viewHeight = $svg.viewBox.baseVal.height;
    var svgWidth = $svg.width.baseVal.value;
    var svgHeight = $svg.height.baseVal.value;
    var viewRatio = (viewWidth / svgWidth + viewHeight / svgHeight) / 2;
    var sizeScale = parseFloat(Z($lockWrap).attr('data-scale') || 0);

    // 2：判断是否存在锁定宽高
    isLockScale();

    // 3：单位转换
    if (parseFloat(media.canvas.createMode) === 0) {
        setWidth = mm2px(setWidth, media.canvas.dpi);
        setHeight = mm2px(setHeight, media.canvas.dpi);
    }

    // 4：赋值素材
    setSvgSize();

    // 5：刷新选中框，保存
    updateMaterialSource(material, $curElem);
    selectionTool_show();
    saveHistory();
}

/** 更新线条虚线间隔 **/
function updateShapeLineDasharray(val1,val2)
{
    val1 = parseFloat(val1); val2 = parseFloat(val2);
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    var svgType = $curElem.querySelector("svg").getAttribute("data-type");
    var $line = $curElem.querySelector("line");
    if (material.type !== 5 || svgType !== "shape-line" || !$line){
        return;
    }
    var oldDash = $line.getAttribute("stroke-dasharray").split(" ");
    if (val1 !== 0)
        val1 = val1 || oldDash[0];
    if (val2 !== 0)
        val2 = val2 || oldDash[1];
    $line.setAttribute("stroke-dasharray",val1 + " " + val2);
}

/** 更新形状圆角角度,矩形框圆角 **/
function updateShapeRectRadius(nw_r,ne_r,sw_r,se_r)
{
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    var $svg = $curElem.querySelector("svg");
    var svgType = $svg.getAttribute("data-type");
    if (material.type !== 5 || (svgType !== "shape-rect" && svgType !== "shape-rectStroke")) {
        return;
    }
    var absX = Math.abs($svg.viewBox.baseVal.width);
    var absY = Math.abs($svg.viewBox.baseVal.height);
    var mL = getMinNum([absX,absY])/200;
    if (nw_r != null) $svg.querySelector("path.nw").setAttribute("data-radius",nw_r * mL);
    if (ne_r != null) $svg.querySelector("path.ne").setAttribute("data-radius",ne_r * mL);
    if (sw_r != null) $svg.querySelector("path.sw").setAttribute("data-radius",sw_r * mL);
    if (se_r != null) $svg.querySelector("path.se").setAttribute("data-radius",se_r * mL);

    if (svgType === "shape-rect") {
        mediaEvent.drawRectResize($svg,absX,absY);
    } else if (svgType === "shape-rectStroke") {
        mediaEvent.drawRectStrokeResize($svg,absX,absY);
    }
    //同步展示
    var onlyMore = [nw_r,ne_r,sw_r,se_r].indexOf(null) > -1;
    showRectRadiusValue(onlyMore);
    // 更新并保存
    updateMaterialSource(material, $curElem);
    setToolStaticLoc();
    saveHistory();
}

/** 更新形状，边框尺寸大小 **/
function updateStrokeStrokeSize(val, _this)
{
    // 更新矩形框，边框大小
    function updateStrokeRectStroke()
    {
        var absX = $svg.viewBox.baseVal.width;
        var absY = $svg.viewBox.baseVal.height;
        var maxVal = getMinNum([absX,absY]) / 2;
        if (val > maxVal) {
            val = maxVal.toFixed(4);
        }
        if (_this.tagName.toLowerCase() === 'input' && _this.type === 'text'){
            _this.value = val;
        }
        $svg.setAttribute("data-rectstroke", val);
        // 更新并保存
        if (mediaEvent.drawRectStrokeResize($svg,absX,absY)) {
            updateMaterialSource(material, $curElem);
            setToolStaticLoc();
            saveHistory();
        }
    }
    // 更新圆形，边框大小
    function updateEllipseStroke()
    {
        var $ellipse = $curElem.querySelector("ellipse");
        var viewWidth = $svg.viewBox.baseVal.width;
        var viewHeight = $svg.viewBox.baseVal.height;
        var viewR = getMinNum([viewWidth,viewHeight])/2;
        val = viewR * val/100;
        var setRx = viewWidth/2 - val/2;
        var setRy = viewHeight/2 - val/2;
        $ellipse.setAttribute("stroke-width",val);
        $ellipse.setAttribute("rx",setRx);
        $ellipse.setAttribute("ry",setRy);
        // 更新并保存
        updateMaterialSource(material, $curElem);
        setToolStaticLoc();
        saveHistory();
    }
    // 更新钢笔路径，边框大小
    function updateShapePenStroke()
    {
        if (_this.tagName.toLowerCase() === 'input' && _this.type === 'text'){
            _this.value = val;
        }
        var $path = $svg.querySelector('path');
        $path.setAttribute("stroke-width", val);
        // 更新并保存
        updateMaterialSource(material, $curElem);
        setToolStaticLoc();
        saveHistory();
    }
    // 更新表格边框大小
    function updateShapeTableStroke()
    {
        if (_this.tagName.toLowerCase() === 'input' && _this.type === 'text'){
            _this.value = val;
        }
        val = parseFloat(val);
        // 去除多余的svg
        var $svgWrap = $svg.parentElement;
        var $$svg = $svgWrap.children;
        while ($$svg[1])
            $svgWrap.removeChild($$svg[1]);
        // 取得设置前的边框大小
        var strokeWidth_before = parseFloat($svg.querySelector('line').getAttribute("stroke-width"));
        // 设置“单元格”
        var $$gTr = $svg.children;
        var i = 0,j = 0, $gTr = null, $$gTd = null, $gTd = null, $$line = null,
            $rect = null, rectWidth = 0, rectHeight = 0, firstRow = null;
        for (i = 0;i < $$gTr.length;i++)
        {
            firstRow = i === 0;
            $gTr = $$gTr[i];
            // 单元格处理
            $$gTd = $gTr.children;
            for (j = 0;j < $$gTd.length;j++)
            {
                $gTd = $$gTd[j];
                $$line = $gTd.querySelectorAll('line');
                // rect大小设置
                $rect = $gTd.querySelector("rect");
                rectWidth = $rect.width.baseVal.value + (val - strokeWidth_before) / 2;
                rectHeight = $rect.height.baseVal.value + (val - strokeWidth_before) / 2;
                $rect.setAttribute("width", rectWidth + "");
                $rect.setAttribute("height", rectHeight + "");
                // 边框设置
                $$line.forEach($line =>
                {
                    $line.setAttribute("stroke-width", val);
                    switch ($line.getAttribute("data-type"))
                    {
                        case "left":
                            firstRow && $line.setAttribute("y1", - val / 2 + "");
                            $line.setAttribute("y2", rectHeight + "");
                            break;
                        case "top":
                            $line.setAttribute("x2", rectWidth + "");
                            break;
                        case "right":
                            $line.setAttribute("y1", rectHeight + "");
                            break;
                        case "bottom":
                            $line.setAttribute("x1", rectWidth + "");
                            break;
                    }
                });
                // 单元格偏移
                var matrix = $gTd.transform.baseVal[0].matrix;
                var setTrans = "translate(" + (matrix.e + (val - strokeWidth_before) / 2) + " "
                    + (matrix.f + (val - strokeWidth_before) / 2) + ")";
                $gTd.setAttribute("transform", setTrans);
            }
        }
        // 重设素材大小
        $rect = $curElem.querySelector("rect");
        $rect.setAttribute("width", "1");
        $rect.setAttribute("height", "1");
        $svg.removeAttribute("viewBox");
        $svg.removeAttribute("width");
        $svg.removeAttribute("height");
        var elemRect = $curElem.getBBox();
        var setWidth = elemRect.width + "";
        var setHeight = elemRect.height + "";
        $rect.setAttribute("width", setWidth);
        $rect.setAttribute("height", setHeight);
        $svg.setAttribute("width", setWidth);
        $svg.setAttribute("height", setHeight);
        $svg.setAttribute("viewBox", "0 0 " +  setWidth + " " + setHeight);

        // 校准边框样式，复制一个svg
        var $svgClone = $svg.cloneNode(true);
        $svgClone.querySelectorAll("g[data-row]").forEach(function($dTd)
        {
            $dTd.removeChild($dTd.querySelector("rect"));
            if (($dTd.querySelector("g[transform]")))
                $dTd.removeChild($dTd.querySelector("g[transform]"));
        });
        $svg.parentElement.appendChild($svgClone);

        // 更新并保存
        updateMaterialSource(material, $curElem);
        setToolStaticLoc();
        saveHistory();
    }

    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();

    var $svg = $curElem.querySelector("svg");
    if (material.type !== 5) {
        return;
    }
    var svgType = $svg.getAttribute("data-type");

    // 分情况处理
    switch (svgType)
    {
        case 'shape-rectStroke': updateStrokeRectStroke();break;
        case 'shape-ellipse': updateEllipseStroke();break;
        case 'shape-pen': updateShapePenStroke();break;
        case 'shape-table': updateShapeTableStroke();break;
    }
}

/** 更新展示坐标 **/
function updateSvgLocation(x, y, index)
{
    var material = media.getCurMaterial(index);
    var $curElem = media.tool.getCurSvgElement(index);
    if (!material || !$curElem){
        return;
    }
    material.x = x;
    material.y = y;

    var trans = $curElem.getAttribute("transform");
    trans = trans.replace(/translate\([^)]+\)/,"translate(" + x + " " + y + ")");
    $curElem.setAttribute("transform",trans);
}

/** 更新透明度 **/
function updateSvgTransparency(transparency)
{
    if (media.selectedList.length === 0)
    {//不存在选中素材，返回
        return;
    }
    transparency /= 100;
    for (var i = 0;i < media.selectedList.length;i++)
    {
        var svgElement = media.tool.getCurSvgElement(i);
        var material = media.getCurMaterial(i);
        svgElement.removeAttribute("opacity");
        if (material.type === 1 || material.type === 5){
            svgElement.setAttribute("fill-opacity",transparency);
            svgElement.setAttribute("stroke-opacity",transparency);
        }
    }
}

/** 更新旋转度 **/
function updateSvgRotate(angle)
{
    if (media.selectedList.length === 0)
    {//不存在选中素材，返回
        return;
    }
    var material = media.tool.tempMaterial || media.getCurMaterial();
    material.angle = angle;

    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    var trans = $curElem.getAttribute('transform');
    trans = trans.replace(/rotate\s*\(\s*\d+(\.\d+)?/, 'rotate(' + angle);
    $curElem.setAttribute("transform",trans);

    //更新缩放框位置
    setToolStaticLoc();
}

/** 更新素材source */
function updateMaterialSource(material, $curElem)
{
    material = material || media.tool.tempMaterial || media.getCurMaterial();
    $curElem = $curElem || media.tool.tempElement || media.tool.getCurSvgElement();
    if (!material || !$curElem)
        return;
    // 移除所有半透明效果
    Z("g[id^=svgElementSon_]").removeAttr("opacity");
    var $gSvg = $curElem.querySelector("g");
    var $g = document.createElementNS(xmlns, "g");
    var attrs = $curElem.attributes;
    for (var i = 0; i < attrs.length; i++) {
        if (attrs[i].name === "id" || attrs[i].name === "data-mid" || attrs[i].name === "data-pos")
            continue;
        $g.setAttribute(attrs[i].name, attrs[i].value);
    }
    $g.innerHTML = $gSvg.outerHTML;
    material.source = $g.outerHTML;
    $g = null;
}