/********************************************
************* 初始化、整体加载流程 **********
********************************************/
/** 初始化历史记录列表 **/
function initMediaHistory()
{
    // 初始化载入、刷新
    function initRefresh()
    {
        // 刷新画布
        refresh();
        // 刷新缩略画布
        setZoomArea();
    }
    // 初始化历史纪录列表
    function initMediaToLocalCache(doInit)
    {
        // 特殊尺寸处理，新模板新建删除区域
        function doSpecialCard()
        {
            var spaceWidth = Math.abs(media.canvas.fullWidthMm - media.canvas.widthMm);
            var spaceHeight = Math.abs(media.canvas.fullHeightMm - media.canvas.heightMm);
            if (spaceWidth <= deviationSizeMm && spaceHeight <= deviationSizeMm)
                return;
            if (media.coverMaterialList.length > 0)
                return;
            media.coverMaterialList.length = 0;
            var i, bgObj;
            for (i=0;i<media.bgList.length;i++)
            {
                bgObj = media.bgList[i];
                setCoverMaterial(bgObj, bgObj.widthMm, bgObj.heightMm);
            }
        }

        // 特殊尺寸判断
        doSpecialCard();
        // 历史记录初始化
        mediaHistory.index = 0;
        mediaHistory.savedIndex = 0;
        media.canvas.editTime = new Date().getTime() + '';
        mediaHistory.list = [media.toString()];
        // 保存缓存
        saveMediaToLocalCache(doInit);
        // 初始化画布
        initRefresh();
    }
    // 重设本地缓存
    function resetMediaToLocalCache(obj)
    {
        // 读取缓存中的保存数据
        function reloadSavedFromLocal()
        {
            // 1: 刷新本地数据为已保存数据
            mediaHistory.list[mediaHistory.index] = thisMediaString;
            // 2：刷新画布素材
            initRefresh();
            // 3：添加"转到最新的操作"按钮
            if (mediaHistory.index === indexMax)
                return;
            var $tipsBtn = $historyTips.find('.historyTips-btn');
            var tipsText = '本地缓存存在更新的操作历史';
            var btnText = '恢复到最新的操作';
            $historyTips.addClass('active');
            $historyTips.find('.historyTips-text').html(tipsText);
            $tipsBtn.html(btnText).on('click', function()
            {
                $historyTips.removeClass('active');
                mediaHistory.index = indexMax;
                refresh();
            });
        }
        // 读取服务器数据
        function reloadSavedFromService()
        {
            // 1：更新历史纪录
            mediaHistory.list.push(thisMediaString);
            mediaHistory.savedIndex = indexMax + 1;
            mediaHistory.index = mediaHistory.savedIndex;
            saveMediaToLocalCache();
            // 2：刷新画布素材
            initRefresh();
        }
        // 判断是否相等
        function isEqual()
        {
            var localObject = Z.J.toObject(mediaHistory.list[mediaHistory.index]);
            var mediaET = media.canvas.editTime + '';
            var localET = localObject.canvas.editTime + '';
            if (mediaET === localET)
                return true;
            var localString = new Z.Media({canvas: localObject.canvas, bgList:localObject.bgList, materialList: localObject.materialList, coverMaterialList: localObject.coverMaterialList, curPage: localObject.curPage}).toString();
            if (thisMediaString.replace(/editTime\D+\d+/,'') === localString.replace(/editTime\D+\d+/,''))
            {
                if (mediaET !== localET) {
                    localObject.canvas.editTime = mediaET;
                    mediaHistory.list[mediaHistory.index] = Z.O.toJSONString(localObject);
                }
                return true;
            }
            return false;
        }
        // saveIndex < 0 的情况，重置
        function resetHistoryIndex()
        {
            history.savedIndex = 0;
            history.list.shift();
            history.list.unshift(thisMediaString);
        }

        // 1：数据有误，初始化缓存
        var history = obj.value;
        if (!history || !/^\d+$/.test(history.index) ||
            !/^-?\d+$/.test(history.savedIndex) || !Array.isArray(history.list))
            return initMediaToLocalCache();
        var thisMediaString = media.toString();
        if (/^-\d+$/.test(history.savedIndex))
            resetHistoryIndex();

        // 2：读取本地存储记录
        mediaHistory = history;
        mediaHistory.index = mediaHistory.savedIndex;
        var indexMax = mediaHistory.list.length - 1;

        // 3：比较本地数据和保存数据
        if (isEqual())
            reloadSavedFromLocal();
        else
            reloadSavedFromService();
    }

    // 定义变量
    mediaId = media.canvas.mediaId + '';
    media_historyMax = 50; // 历史列表最大长度
    media_beforeMax = 20; // 手动保存后，保留的历史记录长度
    media_autoSaveIndex = 0; // 自动保存索引标识
    media_autoSaveMax = 30; // 自动保存最大索引
    media_historyKey = 'mediaHistory_' + mediaId; // 当前模板历史 key
    if (typeof localcache === "object")
    {
        localcache.load(mediaId);
        localcache.getValue(media_historyKey, function (err, result)
        {
            if (result){
                resetMediaToLocalCache(result);
            } else {
                initMediaToLocalCache(true);
            }
        });
    }
    else {
        initMediaToLocalCache();
    }
}
/** 隐藏缓存历史提示标语 **/
function historyTipsHide()
{
    $historyTips.removeClass('active');
}
/** 刷新画布素材列表 **/
function refresh (noResize)
{
    var mediaJson = Z.J.toObject(mediaHistory.list[mediaHistory.index]);
    media = new Z.Media(
        {
            canvas: mediaJson.canvas,
            bgList:mediaJson.bgList,
            materialList: mediaJson.materialList,
            coverMaterialList: mediaJson.coverMaterialList,
            curPage: mediaJson.curPage
        });

    //设置当前 media.tool.showRatio
    media.tool.setThisShowRatio();
    loadCanvas(noResize);
    // 刷新版面
    refreshPageList();
    // 刷新图层
    loadLayerList();
    // 隐藏工具栏
    hideToolbar();
}

/** 切换画布：设计/打印（完整）显示 **/
function switchCanvasFull(checked)
{
    // 定义完整显示标识
    media.canvas.fullShow = checked ? 1 : 0;
    // 重新加载画布
    media.tool.createSvgCanvas();
    // 选择框定位
    selectTheElement_group();
}

/** 加载media到画布 **/
function loadCanvas(noResize)
{
    // 查看参数信息，如果存在设置参数
    function setParam(material)
    {
        var $targLi;
        // 存在设置属性，显示已设置
        if (!!material.paramKey && !!material.paramName)
        {
            var dataParam = material.paramKey + "," + material.paramName;
            $targLi = Z('#paramList > li[data-param="' + dataParam + '"]');
            $targLi.attr("data-mid", material.mid);
            $targLi.attr("data-bid", material.bid);
            $targLi.find(".paramList-status").addClass("setted");
        }
        // 不存在设置属性，重设状态
        else
        {
            $targLi = Z('#paramList > li[data-mid="' + material.mid + '"][data-bid="' + material.bid + '"]');
            if ($targLi[0])
            {
                $targLi.removeAttr("data-mid");
                $targLi.removeAttr("data-bid");
                $targLi.find(".paramList-status").removeClass("setted");
            }
        }
    }
    // 设置属性值
    function setMaterial(material, $curElem)
    {
        // 设置容器特殊属性
        function setFrameAttribute()
        {
            var $default = $curElem.querySelector('.svgFrame-default');
            var $image = $curElem.querySelector('.svgFrame-img > image');
            var imgUrl = $image.getAttribute('xlink:href');

            if (imgUrl === frameDefaultUrl) {
                if ($default.hasAttribute('style')){
                    $default.removeAttribute('style');
                    hasChangeSource = true;
                }
            } else {
                if (!$default.hasAttribute('style')){
                    $default.setAttribute('style', 'display:none');
                    hasChangeSource = true;
                }
            }
        }
        // 设置文字属性值
        function setTextMaterial()
        {
            var $$gLine = $svg.children;
            var $$gPath = $svg.querySelectorAll(".font-path");
            var pathLength = $$gPath.length;
            var $firstPath = $$gPath[0];
            if ($$gLine.length === 0 || pathLength === 0 || !$firstPath){
                material.doDelete();
                hasChangeSource = false;
                return;
            }

            var isItalic = -1;
            var k, fontSize, fontTrueSize, transValueList, $gPath, $path, thisItalic, pathTransX,
                textStr, textLength, initWordsList, pathStr, pathT, pathW, pathI, pathD;

            // 1：加粗
            material.fontWeight = parseInt($curElem.getAttribute("data-fontweight"));
            // 2：文本类型
            material.fontFamily = $curElem.getAttribute("data-fontfamily") || "微软雅黑";
            // 3：文本对齐
            material.textAlign = $curElem.getAttribute("data-textalign") || "left";
            // 4：文本字体
            // 5：下划线偏移
            material.underlineOffset = $curElem.getAttribute("data-underlineoffset");
            // 6：下划线大小
            material.underlineThickness = $curElem.getAttribute("data-underlinethickness");
            // 7：字间距
            material.letterSpacing = $curElem.getAttribute("data-letterspacing");
            // 8：行间距
            material.lineHeight = $curElem.getAttribute("data-lineheight");
            // 9：行间距计算
            material.mathHeight = $curElem.getAttribute("data-mathheight");
            // 10：单行高度
            material.singleHeight = $curElem.getAttribute("data-singleheight");
            // 11：文本缩放，宽度、高度变化比例
            material.textZoom = $curElem.getAttribute("data-textzoom");
            if (!material.textZoom || !/^\d+(.\d+)?\s\d+(.\d+)?$/.test(material.textZoom))
                material.textZoom = '1 1';
            // 12：svg 默认横坐标偏移
            material.svgboxx = $curElem.getAttribute("data-svgboxx") || 0;
            // 13：竖排对齐方式
            material.textVertical = $curElem.getAttribute("data-textvertical") || 'normal';
            // 14：文字特效
            material.textSpecial = $curElem.getAttribute("data-textspecial") || 'normal';
            material.textSpecialColor = $curElem.getAttribute("data-textspecialcolor") || '#000000';
            material.textSpecialSize = parseFloat($curElem.getAttribute("data-textspecialsize") || -1);
            // 15：下划线
            if (pathLength === $svg.querySelectorAll(".font-path line").length){
                material.textDecoration = 1;
            } else {
                material.textDecoration = 0;
            }
            // 16：文本大小
            fontSize = $curElem.getAttribute("data-fontsize");
            if (fontSize.indexOf("p") === -1)
            {// 如果没有单位，表示存储值为px，需要转换单位
                fontSize = parseFloat(fontSize);
                if (media.canvas.createMode === 0) {
                    fontSize = px2pt(fontSize);
                    $curElem.setAttribute("data-fontsize", fontSize + 'pt');
                } else {
                    $curElem.setAttribute("data-fontsize", fontSize + 'px');
                }
                hasChangeSource = true;
            }
            material.fontSize = parseFloat(fontSize);
            // 17：文本偏移；之前版本，没有保存“data-texty”，用近似计算
            if (!$curElem.hasAttribute("data-texty")) {
                if (media.canvas.createMode === 0) { fontTrueSize = pt2px(material.fontSize)}
                else {fontTrueSize = parseInt(material.fontSize)}
                material.textY = fontTrueSize * .830512523651123;
            } else {
                material.textY = parseFloat($curElem.getAttribute("data-texty"));
            }
            // 18：文本内容，剔除特殊字符
            textStr = $curElem.getAttribute("data-text").replace(/-%6-%-%0-/g, '<');
            textStr = getHtmlText(textStr);
            material.text = textStr;
            // 19：颜色
            material.color = $firstPath.querySelector('path').getAttribute('fill') || "#000000";
            // 21：斜体 + 22：设置data-x + 23：wordsList
            textStr = textStr.replace(/(-%5-%-%5-)|\n/g, "");
            textLength = textStr.length;
            initWordsList = textLength !== pathLength;
            material.wordsList = [];
            for (j = 0;j < pathLength;j++)
            {
                // 斜体校对
                $gPath = $$gPath[j];
                $path = $gPath.querySelector('path');
                if ($gPath.hasAttribute('data-heihgt')){
                    $gPath.setAttribute('data-height' , $gPath.getAttribute('data-heihgt'));
                    $gPath.removeAttribute('data-heihgt');
                    hasChangeSource = true;
                }
                transValueList = $gPath.transform.baseVal;
                for (k = 0; k < transValueList.length; k++)
                {
                    if (transValueList[k].type === 2) {
                        pathTransX = transValueList[k].matrix.e;
                        if ($gPath.hasAttribute('data-x'))
                            continue;
                        if (j === 0)
                            $gPath.setAttribute('data-x', '0');
                        else
                            $gPath.setAttribute('data-x', pathTransX - material.letterSpacing);
                    } else if (transValueList[k].type !== 5) {
                        continue;
                    }
                    thisItalic = transValueList[k].angle === -18 ? 1 : 0;
                    if (isItalic === -1) {
                        isItalic = thisItalic;
                    } else {
                        if (isItalic !== thisItalic) {
                            isItalic = 0;
                            break;
                        }
                    }
                }
                // wordsList 设置
                if (initWordsList)
                {
                    $path.setAttribute('fill', material.color);
                    continue;
                }
                pathStr = textStr[j];
                pathT = $gPath.getAttribute("data-text");
                pathT = pathT && pathT.replace(/-%6-%-%0-/g, '<');
                if (pathT !== pathStr) {
                    $gPath.setAttribute("data-text", pathStr.replace(/</g, '-%6-%-%0-'));
                    pathT = pathStr;
                }
                pathW = $gPath.getAttribute("data-fontweight");
                pathI = $gPath.getAttribute("data-fontitalic");
                pathD = $gPath.getAttribute("data-textdecoration");
                material.wordsList.push({
                    'color': $path.getAttribute('fill') || material.color,
                    'fontFamily': $gPath.getAttribute("data-fontfamily") || material.fontFamily,
                    'fontSize': material.fontSize,
                    'fontWeight': pathW === null ? material.fontWeight : ((!/^\d$/.test(pathW)) ? 0 : (eval(pathW) ? 1 : 0)),
                    'fontItalic': pathI === null ? (isItalic === -1 ? 0 : isItalic) : ((!/^\d$/.test(pathI)) ? 0 : (eval(pathI) ? 1 : 0)),
                    'textDecoration': pathD === null ? material.textDecoration : ((!/^\d$/.test(pathD)) ? 0 : (eval(pathD) ? 1 : 0)),
                    'text': pathT,
                    'index': j,
                });
            }
            material.fontItalic = (isItalic === -1) ? 0 : isItalic;
            // 23：初始化 wordsList
            if (initWordsList)
            {
                for (j = 0;j < textLength;j++)
                {
                    material.wordsList.push({
                        'color': material.color,
                        'fontFamily': material.fontFamily,
                        'fontSize': material.fontSize,
                        'fontWeight': material.fontWeight,
                        'fontItalic': material.fontItalic,
                        'textDecoration': material.textDecoration,
                        'text': textStr[j],
                        'index': j,
                    });
                }
            }
        }
        // 设置表格属性值
        function setTableAttribute()
        {
            var $$gTd = $svg.querySelectorAll("g[data-rowspan]");
            var listLength = $$gTd.length;
            if (listLength === 0)
                return;
            // 给表格添加第二属性
            material.isTable = 1;
            tableMaterialTextSet($curElem, material);
        }

        // 主方法，定义变量
        var elemTransform, transValueList, $clipPath, $rect, numReg, fillOpacity, strokeOpacity, hasChangeSource;
        // 取得当前版面素材的参数值
        $g = $curElem.querySelector("g");
        $svg = [...$g.children].pop();
        var dataType = $svg.getAttribute("data-type");

        // 1：分组编号
        material.groupId = $curElem.getAttribute("data-groupid") || "";

        // 2：翻转状态
        elemTransform = $g.getAttribute("transform");
        if (elemTransform && elemTransform.indexOf("scale") > -1) {
            material.reversal = elemTransform.replace(/(.*scale\()([^)]+)(\).*)/,"$2");
        } else {
            material.reversal = "1 1";
        }

        // 3：圆角
        $clipPath = Z($curElem).find("clipPath[id^=\"radius_svgElementSon_\"]")[0];
        if ($clipPath) {
            $rect = $clipPath.querySelector("rect");
            if ($rect && $rect.hasAttribute("rx")) {
                material.imgRadius = parseInt($rect.getAttribute("rx"));
            }
        }

        // 4：大小
        material.width = $svg.viewBox.baseVal.width;
        material.height = $svg.viewBox.baseVal.height;

        // 5：偏移
        transValueList = $curElem.transform.baseVal;
        for (j = 0;j < transValueList.length;j++){
            if (transValueList[j].type === 2){
                material.x = transValueList[j].matrix.e;
                material.y = transValueList[j].matrix.f;
            } else if (transValueList[j].type === 4) {
                material.angle = transValueList[j].angle;
            }
        }
        material.x = material.x || 0;
        material.y = material.y || 0;
        material.angle = material.angle || 0;

        // 6：透明度
        if ($curElem.hasAttribute('fill-opacity') && $curElem.hasAttribute('stroke-opacity'))
        {
            numReg = /0|1|(0?.\d+)/;
            fillOpacity = $curElem.getAttribute('fill-opacity');
            strokeOpacity = $curElem.getAttribute('stroke-opacity');
            if (numReg.test(fillOpacity) && numReg.test(strokeOpacity) && fillOpacity === strokeOpacity) {
                material.transparency = Math.round(parseFloat(fillOpacity) * 100);
            } else {
                $curElem.setAttribute('fill-opacity', material.transparency / 100);
                $curElem.setAttribute('stroke-opacity', material.transparency / 100);
                material.transparency = 100;
                hasChangeSource = true;
            }
        } else {
            material.transparency = 100;
        }

        // 7：文字属性
        if (material.type === 1)
            setTextMaterial();
        // 8：容器属性
        if (material.type === 4)
        {
            if(!$curElem.querySelector('.svgFrame-img > image'))
                material.type = 3;
            else
                setFrameAttribute();
        }
        // 9：形状属性
        if (material.type === 5)
        {
            if(dataType === "shape-table")
                setTableAttribute();
        }
        // 10：背景图层
        material.bgMaterial = $curElem.hasAttribute("data-bgmaterial");

        // End：修改了 svg 源码，则刷新素材 resource
        if (hasChangeSource){
            updateMaterialSource(material, $curElem);
        }
    }
    // 循环插入素材
    function insertMaterial()
    {
        for (i = 0;i < media.materialList.length;i++)
        {
            material = media.materialList[i];
            // source 为空的错误素材，删除并略过
            if (!material.source || material.source.trim() === '') {
                material.doDelete();
                continue;
            }
            // 非当前版面的素材、删除的素材、隐藏的素材；略过
            if (material.bid !== media.curPage || material.status === 1 || material.status === 2)
                continue;
            $curElem = media.tool.createSvgGElement(material);
            // 返回 null ，则删除该素材
            if (!$curElem) {
                material.doDelete();
                continue;
            }

            // 1：初始化素材 material 属性值
            setMaterial(material, $curElem);

            // 2：判断是否有参数设置
            setParam(material);
        }
    }
    // 先重置画布素材、画布大小、选中框、背景
    function resetCanvas()
    {
        $canvasMaterial.innerHTML = '';
        selectionAll_hide();
        // 画布大小调整
        media.tool.createSvgCanvas(noResize);
        // 初始化背景
        media.tool.initBg();
        // 显示当前 media 的版面
        Z("#pageItem_" + media.curPage).addClass("active").siblings("li").removeClass("active");
    }
    // 其他画布因素样式修改
    function setOtherStyle()
    {
        var $rect = Z("#svg_canvas_bg>svg>rect");
        var bgColor = ($rect.attr("fill") || 'none').toLowerCase();
        if (bgColor === 'none')
            Z("#bg_color").addClass('bgNone');
        else
            Z("#bg_color").removeClass('bgNone').css("backgroundColor", bgColor);
    }

    // 主方法，定义变量
    var $canvasMaterial = media.tool.$canvasMaterial;
    var i, j, material, $curElem, $g, $svg;

    // 1：重置画布
    resetCanvas();

    // 2：加载素材
    insertMaterial();

    // 3：加载遮罩素材
    insertCoverMaterial();

    // 4：其他样式修改
    setOtherStyle();

    // 5：更新出血线
    setBleedTool();
}
function tableMaterialTextSet($curElem, material){
    var $firstTd = $curElem.querySelector("g[data-rowspan]");
    var $firstPath = $firstTd.querySelector("g.font-path>path");
    material.color = ($firstPath && $firstPath.getAttribute("fill")) || "#000000";
    material.fontFamily = $firstTd.getAttribute("data-fontfamily") || "微软雅黑";
    material.textAlign = $firstTd.getAttribute("data-textalign") || "center";
    material.fontSize = $firstTd.getAttribute("data-fontsize") || px2pt(16/media.tool.showRatio);
    material.fontWeight = parseFloat($firstTd.getAttribute("data-fontweight") || 0);
    material.fontItalic = parseFloat($firstTd.getAttribute("data-fontitalic") || 0);
    material.letterSpacing = parseFloat($firstTd.getAttribute("data-letterspacing") || 0);
    material.lineHeight = parseFloat($firstTd.getAttribute("data-lineheight") || 0);
    material.mathHeight = parseFloat($firstTd.getAttribute("data-mathheight") || 0);
}
function insertCoverMaterial()
{
    media.tool.$canvasCover.innerHTML = '';
    var i, coverMaterial, $gSource, gAttr, j, $gNew,
        $textSvg, svgBox, setSvgView;
    for (i = 0;i < media.coverMaterialList.length;i++)
    {
        coverMaterial = media.coverMaterialList[i];

        // 略过非当前版面的素材
        if (coverMaterial.bid !== media.curPage)
            continue;
        $gSource = Z(coverMaterial.source)[0];
        gAttr = $gSource.attributes;
        $gNew = document.createElementNS(xmlns, 'g');
        for (j = 0;j < gAttr.length;j++)
            $gNew.setAttribute(gAttr[j].name, gAttr[j].value);
        $gNew.innerHTML = $gSource.innerHTML;

        // 插入素材
        media.tool.$canvasCover.appendChild($gNew);

        // 调整合适宽高，以防超出
        $textSvg = $gNew.querySelector('svg');
        svgBox = $textSvg.getBBox();
        if (svgBox.x >= 0 && svgBox.y >= 0)
            continue;

        setSvgView = (svgBox.x < 0 ? svgBox.x : 0) + ' ';
        setSvgView += (svgBox.y < 0 ? svgBox.y : 0) + ' ';
        setSvgView += (svgBox.x < 0 ? svgBox.width : $textSvg.getAttribute('width')) + ' ';
        setSvgView += (svgBox.y < 0 ? svgBox.height : $textSvg.getAttribute('height'));
        $textSvg.setAttribute('viewBox', setSvgView);

        // 更新列表属性
        coverMaterial.source = $gNew.outerHTML;
    }
}

/** 创建svg版面略缩图 */
function refreshSvgThumbnail(curPage)
{
    // 1：定义变量
    curPage = parseInt(curPage || media.curPage);
    var curPageObj = media.getBg(curPage);
    var h = 90;
    var w = h * curPageObj.width / curPageObj.height;
    if (w > 120) {
        w = 120;
        h = w * curPageObj.height / curPageObj.width;
    }
    var $svg_canvas = Z('<svg viewBox="0 0 ' +curPageObj.width+' ' +curPageObj.height+'" width="'+w+'" height="'+h+'" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" preserveAspectRatio="none"></svg>');

    // 2：添加背景
    var $gSvg = document.createElementNS(xmlns,"g");
    var $svg = Z(media.getBg(curPage).source);
    $svg[0].setAttribute("width", curPageObj.width);
    $svg[0].setAttribute("height", curPageObj.height);
    $gSvg.appendChild($svg[0]);
    $svg_canvas[0].appendChild($gSvg);

    // 2.1：判断当前版面，做缩略图创建，并添加标识
    if (curPage === media.curPage)
    {
        var doZoomThumb = 1;
        var $zoomAreaThumb = Z("#zoomAreaThumb");
        var $zoomAreaSvg = $zoomAreaThumb.find("svg").html("");
        $zoomAreaSvg[0].appendChild($gSvg.cloneNode(true));
    }
    
    // 3：添加素材
    var $tempDiv = Z('<div style="position:absolute;left:-9999px;"></div>').appendTo(Z('body'));
    var i, material, $subG, $gInner;
    for (i=0; i<media.materialList.length; i++)
    {
        material = media.materialList[i];
        if (material.bid === curPage && material.status !== 1)
        {
            if (material.source === "")
            {
                material.doDelete();
                continue;
            }
            $tempDiv.html(material.source);
            $subG = $tempDiv.children('g');
            if (!$subG[0])
            {
                material.doDelete();
                continue;
            }
            $gInner = document.createElementNS(xmlns,"g");
            $gInner.setAttribute("transform", $subG.attr("transform"));
            if ($subG.attr("fill-opacity"))
                $gInner.setAttribute("fill-opacity", $subG.attr("fill-opacity"));
            if ($subG.attr("stroke-opacity"))
                $gInner.setAttribute("stroke-opacity", $subG.attr("stroke-opacity"));
            $gInner.innerHTML = $subG.html();
            $svg_canvas[0].appendChild($gInner);

            // 缩放缩略图添加素材
            if (doZoomThumb)
                $zoomAreaSvg[0].appendChild($gInner.cloneNode(true));
        }
    }
    $tempDiv.remove();

    // 4：保证id不重合，把 svg 内嵌到 iframe 显示
    var svgCode = $svg_canvas[0].outerHTML;
    // 4.1：创建iframe
    var ifr  = document.createElement("iframe");
    ifr.style.width = w + "px";
    ifr.style.height = h + "px";
    // 4.2：创建通用css
    var insertCss = document.createElement("link");
    insertCss.setAttribute("rel","stylesheet");
    insertCss.setAttribute("type","text/css");
    insertCss.setAttribute("href", zhiqimUICss);
    // 4.3：添加到版面
    var $thisItem = Z("#pageItem_" + curPage);
    $thisItem.children("svg").remove();
    $thisItem.children("iframe").remove();
    $thisItem.append(ifr);
    var ifrdoc = ifr.contentWindow.document;
    setTimeout(function(){
        ifrdoc.querySelector("html").setAttribute('style','overflow:hidden');
        ifrdoc.querySelector("head").appendChild(insertCss);
        ifrdoc.body.insertAdjacentHTML("beforeend",svgCode);
        ifr = insertCss = ifrdoc = null;
    },0);
}
/**  设置版面列表大小 **/
function setSvgThumbList()
{
    // 检测单吗是否存在某些错误
    function checkChildCode ()
    {
        var $$children = $itemSvg.children;
        var delArr = [];
        [].forEach.call($$children, function ($item)
        {
            if ($item.tagName.toLowerCase() !== "g"){
                return;
            }
            var attr = $item.attributes;
            var attrLength = attr.length;
            var j;
            for ( j = 0;j < attrLength;j++){
                if (attr[j].name === "transform"){
                    if (!transformReg.test(attr[j].value)) {
                        delArr.push($item);
                        return;
                    }
                }
            }
        });
        delArr.forEach(function($g){
            $g.parentNode.removeChild($g);
        });
    }

    // 1：定义变量
    var bgList = media.bgList;
    var $$liList = Z("#pageList>li");
    var i, bg, h, w, $thisItem, $ifr, ifrDoc, $itemSvg, svgCode;

    // 2：循环处理
    for (i = 0;i < bgList.length;i++)
    {
        // 赋值宽高
        bg = bgList[i];
        h = 90;
        w = h * bg.width / bg.height;
        if (w > 120) {
            w = 120;
            h = w * bg.height / bg.width;
        }
        // 定义对象变量
        $thisItem = $$liList[i];
        $ifr = $thisItem.querySelector("iframe");
        ifrDoc = $ifr.contentWindow.document;
        $itemSvg = $ifr.previousElementSibling.children[0];
        svgCode = $itemSvg.outerHTML;
        // 测试 svg 中是否存在错误数据
        checkChildCode();
        // 插入代码到 iframe
        $ifr.style.width = w + "px";
        $ifr.style.height = h + "px";
        // 创建通用css
        var insertCss = document.createElement("link");
        insertCss.setAttribute("rel","stylesheet");
        insertCss.setAttribute("type","text/css");
        insertCss.setAttribute("href", zhiqimUICss);
        // 添加到版面
        ifrDoc.querySelector("html").setAttribute('style', 'overflow:hidden');
        ifrDoc.querySelector("head").appendChild(insertCss);
        ifrDoc.body.insertAdjacentHTML("beforeend",svgCode);
        // 重设 svg 宽高
        var $svg = ifrDoc.body.querySelector("svg");
        $svg.setAttribute("width",w);
        $svg.setAttribute("height",h);
    }
}
/** 设置出血辅助线 **/
function setBleedTool()
{
    //media.canvas.bleedSize = 2;
    var bgRect = media.tool.$canvasBg.getBoundingClientRect();
    var canvasRect = media.tool.$canvasSvg.getBoundingClientRect();
    var bleedSize = mm2px(media.canvas.bleedSize) * media.tool.showRatio;
    Z("#bleed_guide").css({
        "width": bgRect.width - 2 * bleedSize,
        "height": bgRect.height - 2 * bleedSize,
        "left": bgRect.left - canvasRect.left + bleedSize,
        "top": bgRect.top - canvasRect.top + bleedSize,
    });
}
/** 设置编辑区缩略图样式 */
function setZoomArea()
{
    /**** 设置缩略图 ****/
    // 画布参数
    var canvasRect = media.tool.$canvasBg.getBoundingClientRect();
    var canvasRatio = canvasRect.width / canvasRect.height;
    // 节点对象
    var $zoomAreaThumb = Z("#zoomAreaThumb");
    var $zoomAreaSvg = $zoomAreaThumb.find("svg");
    // 计算svg的宽高
    var maxNum = 120;
    var svgWidth = (canvasRatio > 1)?(maxNum):(0);
    var svgHeight = (svgWidth > 0)?(svgWidth / canvasRatio):(maxNum);
    svgWidth = (svgWidth > 0)?(svgWidth):(svgHeight * canvasRatio);
    
    // 赋值
    $zoomAreaSvg[0].setAttribute("width",svgWidth);
    $zoomAreaSvg[0].setAttribute("height",svgHeight);
    $zoomAreaSvg[0].setAttribute("viewBox","0 0 " + media.getCurBg().width + " " + media.getCurBg().height);
    // 全局参数，缩略图比例
    zoomAreaParams.xratio = svgWidth / (svgWidth + 40);                        //缩略图，宽度和父级宽度的比例
    zoomAreaParams.yratio = svgHeight / (svgHeight + 40);                      //缩略图，高度和父级高度的比例
    zoomAreaParams.width = svgWidth;                                                        //缩略图的宽度
    zoomAreaParams.height = svgHeight;                                                      //缩略图的高度
    
    // 定位选择框
    zoomAreaJudge();
    
    /**** 刷新缩略图 ****/
    var $gSvg = document.createElementNS(xmlns,"g");
    var $svg = Z(media.getBg(media.curPage).source);
    $svg[0].setAttribute("width", media.getCurBg().width);
    $svg[0].setAttribute("height", media.getCurBg().height);
    $gSvg.appendChild($svg[0]);
    $zoomAreaSvg.html("");
    $zoomAreaSvg[0].appendChild($gSvg);
    // 添加素材
    var i, material, subG, gInner;
    for (i=0; i<media.materialList.length; i++)
    {
        material = media.materialList[i];
        if (material.bid === media.curPage && material.status !== 1) {
            subG = Z(material.source);
            gInner = document.createElementNS(xmlns,"g");
            gInner.setAttribute("transform", subG.attr("transform"));
            if (subG.attr("fill-opacity"))
                gInner.setAttribute("fill-opacity", subG.attr("fill-opacity"));
            if (subG.attr("stroke-opacity"))
                gInner.setAttribute("stroke-opacity", subG.attr("stroke-opacity"));
            gInner.innerHTML = subG.html();
            $zoomAreaSvg[0].appendChild(gInner);
        }
    }
}
/** 判断当前画布是否需要显示缩略 **/
function zoomAreaJudge()
{
    var $wrap = media.tool.$designStage;
    var $canvas = media.tool.$stageCanvas;
    var canvasXratio = $canvas.offsetWidth / $wrap.offsetWidth;
    var canvasYratio = $canvas.offsetHeight / $wrap.offsetHeight;
    if (canvasXratio > 1 || canvasYratio > 1) {
        Z("#zoomAreaThumb").addClass("active");
        //刷新位置
        refreshZoomArea();
    } else {
        Z("#zoomAreaThumb").removeClass("active");
    }
}
/** 刷新画布缩略图位置 **/changeCanvas
function refreshZoomArea()
{
    if (!Z("#zoomAreaThumb").hasClass("active"))
        return;
    var wrapRect = media.tool.$designStage.getBoundingClientRect();
    var canvasRect = media.tool.$canvasBg.getBoundingClientRect();
    var xRatio = canvasRect.width / wrapRect.width;
    var yRatio = canvasRect.height / wrapRect.height;
    // 选中框的宽高
    var setWidth = zoomAreaParams.width / xRatio;
    var setHeight = zoomAreaParams.height / yRatio;
    // 选中框的坐标
    var $thumbCanvas = Z("#zoomAreaThumb > .canvasWrap");
    var zoomRatio = canvasRect.width / zoomAreaParams.width;
    var setX = $thumbCanvas.offsetLeft() - (canvasRect.left - wrapRect.left) / zoomRatio;
    var setY = $thumbCanvas.offsetTop() - (canvasRect.top - wrapRect.top) / zoomRatio;
    Z("#zoomAreaThumb > .selector").css(
    {
        "width": setWidth,
        "height": setHeight,
        "left": setX,
        "top": setY,
    });
}
/** 加载图层列表 */
function loadLayerList(curPage)
{
    curPage = curPage || media.curPage;
    // 先清除
    var layerList = media.tool.$layerList;
    layerList.innerHTML = "";

    // 后添加
    var $canvasSvg = media.tool.$canvasSvg;
    var canvasWidth = $canvasSvg.viewBox.baseVal.width;
    var canvasHeight = $canvasSvg.viewBox.baseVal.height;
    var listLength = media.materialList.length;
    var i, material, divStr, typeName, $wrap, $$children, childrenLength, $source, $svg, width, height, item;
    for (i=0; i<listLength; i++)
    {
        material = media.materialList[i];
        if (parseFloat(media.tool.layerType) === 1 && Z.V.isEmpty(material.paramKey)) {
            continue;
        }

        // source 为空的意外情况
        if (material.source === "") {
            material.doDelete();
            continue;
        }

        divStr = "";
        // 判断是不是背景
        if (material.bgMaterial)
            typeName = '背景';
        // 其他类型
        else if (material.type === 0 || material.type === 2)
            typeName = '图片';
        else if (material.type === 1)
            typeName = '文字: ' +  '<span class="z-small z-color-gray">' + material.text + '</span>';
        else if (material.type === 3)
            typeName = '素材';
        else if (material.type === 4)
            typeName = '容器';
        else if (material.type === 5){
            typeName = '形状';
            var shapeType = /<svg\s[^>]+data-type\s?=\s?"([^"]+)"/.exec(material.source)[1];
            if (shapeType && /shape-\w+/.test(shapeType))
            {
                var typeShapeName = '';
                switch(shapeType)
                {
                    case 'shape-line': typeShapeName = '线条';break;
                    case 'shape-rect': typeShapeName = '矩形';break;
                    case 'shape-rectStroke': typeShapeName = '矩形框';break;
                    case 'shape-ellipse': typeShapeName = '圆形';break;
                    case 'shape-pen': typeShapeName = '钢笔';break;
                    case 'shape-table': typeShapeName = '表格';break;
                }
                if (typeName)
                    typeName += ': <span class="z-small z-color-gray">' + typeShapeName + '</span>';
            }
        }
        if (!Z.V.isEmpty(material.paramKey)) {
            divStr = '<div class="z-absolute z-pd3 z-bg-black z-w100p z-l0 z-b0" style="opacity: 0.5;filter:alpha(opacity=50);">'
                + '<span class="z-px12 z-color-white">' + material.paramName + '</span>'
                + '</div>';
        }
        divStr += '<div class="z-absolute z-bg-blue z-text-blue z-lh30 z-pd-lr10 z-l0 z-t0 z-text-ellipsis" style="max-width: 100%;">' + typeName + '</div>';

        if (material.bid === curPage && material.status !== 1)
        {
            if ($wrap = Z(material.source)[0]) {
                $$children = $wrap.children;
                childrenLength = $$children.length;
                if (childrenLength < 1)
                    continue;
                $source = $$children[childrenLength - 1];
            }
            if (!$source || !$source.tagName){
                material.doDelete();
                continue;
            }
            if ($source.tagName.toLowerCase() === "svg"){
                $svg = $source;
            } else if ($source.tagName.toLowerCase() === "g") {
                $svg = $source.querySelector("svg");
            }

            width = $svg.getAttribute('width');
            if (/%$/.test(width)){
                width = parseFloat(width) / 100 * canvasWidth;
            }
            width = parseFloat(width);
            height = $svg.getAttribute('height');
            if (/%$/.test(height)){
                height = parseFloat(height) / 100 * canvasHeight;
            }
            height = parseFloat(height);
            if (height > 80 || width > 80) {
                if (height > width) {
                    $svg.setAttribute("height", 80);
                    $svg.setAttribute("width", width * 80 / height);
                } else {
                    $svg.setAttribute("width", 80);
                    $svg.setAttribute("height", height * 80 / width);
                }
            }
            item = Z('<li class="z-relative" onclick="layerSelect(event,this);" data-mid="' + material.mid + '">' + $source.outerHTML + divStr +'</li>');
            layerList.insertBefore(item[0], layerList.children[0] || null);
        }
    }

    // 是否有选中
    if (media.selectedList.length === 0) {
        return;
    }
    listLength = media.selectedList.length;
    var j, theMid, layerItem;
    for (j = 0;j < listLength;j++)
    {
        theMid = media.getCurMaterial(j).mid;
        layerItem = Z(media.tool.$layerList).find("li[data-mid='" + theMid + "']");
        layerItem.addClass("active");
    }
}
/** 选择素材图层 */
function layerSelect(event, ele)
{
    //清空选中
    window.getSelection().removeAllRanges();
    //获取当前点击对象数据
    var mid = Z(ele).attr("data-mid");
    var material = media.getMaterialByMid(mid);
    var $curElem = media.tool.$canvasMaterial.querySelector("#svgElementSon_" + mid);

    //保险判断，如果存在隐藏文本，则显示
    if(Z(".hiddenDoing")[0]){
        showHiddenElement(Z(".hiddenDoing")[0]);
    }

    if (event.shiftKey && media.selectedList.length >= 1)
    {//多选模式
        //执行选中
        material.doMutliSelected();
        selectionToolsShow_group();
        return;
    }
    //单选模式
    selectTheElement(material, $curElem);
    return;
}
/** 显示图层列表 */
function showLayerList(type)
{
    media.tool.layerType = type;
    loadLayerList();
}

/********************************************
 *************** 画布缩略图操作 *************
 ********************************************/
/** 缩略图内按下操作 **/
function zoomAreaMouseDown(event)
{
    if (event.button !== 0) return;
    var canvasRect = media.tool.$canvasBg.getBoundingClientRect();
    zoomAreaParams.zoomRatio = canvasRect.width / zoomAreaParams.width;
    var $selector = Z(Z.E.current(event));
    //保存全局初始数值
    zoomAreaParams.mouseX = event.pageX;
    zoomAreaParams.mouseY = event.pageY;
    zoomAreaParams.left = $selector.offsetLeft();
    zoomAreaParams.top = $selector.offsetTop();
    $selector.on("mousemove",zoomAreaMouseMove).on("mouseup mouseleave",zoomAreaMouseUp);
}
/** 缩略图内移动操作 **/
function zoomAreaMouseMove(event)
{
    var $selector = Z(Z.E.current(event));
    var changeX = event.pageX - zoomAreaParams.mouseX;
    var changeY = event.pageY - zoomAreaParams.mouseY;
    $selector.css("left", zoomAreaParams.left + changeX);
    $selector.css("top", zoomAreaParams.top + changeY);
    // 执行换算，画布的位移
    zoomAreaDone();
    // 选择框定位
    selectionToolsShow_group();
}
/** 缩略图内释放操作 **/
function zoomAreaMouseUp(event)
{
    var $selector = Z(Z.E.current(event));
    $selector.off("mousemove",zoomAreaMouseMove).off("mouseup mouseleave",zoomAreaMouseUp);
}
/** 同步设置画布的偏移 **/
function zoomAreaDone()
{
    var $selector = Z("#zoomAreaThumb .selector")[0];
    var $canvasThumb = Z("#zoomAreaThumb .canvasWrap")[0];
    var stageRect = media.tool.$stageCanvas.getBoundingClientRect();
    var canvasRect = media.tool.$canvasBg.getBoundingClientRect();
    Z(media.tool.$stageCanvas).css({
        "left": (stageRect.left - canvasRect.left) + ($canvasThumb.offsetLeft - $selector.offsetLeft) * zoomAreaParams.zoomRatio,
        "top": (stageRect.top - canvasRect.top) + ($canvasThumb.offsetTop - $selector.offsetTop) * zoomAreaParams.zoomRatio,
    });
}

/*****************************************
*********** 媒体、版面、下载 *************
******************************************/
/** 保存操作历史 **/
function saveHistory (thisMediaString)
{
    if (!thisMediaString) {
        media.canvas.editTime = new Date().getTime() + '';
        thisMediaString = media.toString();
    }
    // 1：判断是否需要保存
    var listLength = mediaHistory.list.length;
    var thisDataString = thisMediaString.replace(/editTime\D+\d+/,'');
    var listDataString = mediaHistory.list[mediaHistory.index].replace(/editTime\D+\d+/,'');
    if (thisDataString === listDataString)
        return;
    // 2：撤销状态，删除当前位置之后的所有数据
    var revokeStep = listLength - 1 - mediaHistory.index;
    if (revokeStep > 0)
    {
        mediaHistory.list.splice(mediaHistory.index + 1, revokeStep);
        if (mediaHistory.savedIndex > mediaHistory.index)
            mediaHistory.savedIndex = -1;
    }

    // 3：执行保存
    mediaHistory.list.push(thisMediaString);
    mediaHistory.index = mediaHistory.list.length - 1;

    // 4：检查列表最大值
    while (mediaHistory.list.length > media_historyMax) {
        mediaHistory.list.shift();
        mediaHistory.index--;
        mediaHistory.savedIndex--;
    }
    // 5：刷新版面缩略图
    refreshSvgThumbnail();
    // 6：刷新图层缩略图
    loadLayerList();
    // 7：判断自动保存
    media_autoSaveIndex++;
    if (isAutoSave && media_autoSaveIndex >= media_autoSaveMax) {
        media_autoSaveIndex = 0;
        doAutoSaveMedia(null,null,false);
    }
    // 8：保存至本地缓存
    saveMediaToLocalCache();
    // 9：缓存历史提示条
    historyTipsHide();
}
// 保存历史记录到本地缓存
function saveMediaToLocalCache(doInit)
{
    if (typeof localcache !== "object")
        return;
    var setFun = doInit ? 'setValue' : 'updateValue';
    localcache[setFun](media_historyKey, mediaHistory, function (err){
        if (err) console.error(err);
    });
}

/** 撤销操作 **/
function revoke ()
{
    // mediaEvent 对象的撤销
    function eventRevoke()
    {
        if (!mediaEvent.penEditHistory.list[mediaEvent.penEditHistory.index - 1])
        {
            if (mediaEvent.penEditHistory.revokeSkip){
                return mediaRevoke();
            } else{
                mediaEvent.penEditHistory.revokeSkip = true;
                if (mediaEvent.penEditHistory.index < mediaEvent.penEditHistory.list.length - 1)
                    mediaEvent.penEditHistory.redoSkip = false;
                return Z.tips({text: '继续“撤销”将跳出钢笔编辑！', width: 250, timeout: 3000});
            }
        }
        mediaEvent.penEditHistory.index--;
        mediaEvent.loadPenEditHistory();
    }
    // media 对象的撤销
    function mediaRevoke()
    {
        //去除编辑工具
        mediaEvent.removeAllEditTool();
        if (mediaHistory.index <= 0)
            return Z.tips({text: '不能再撤销了！', width: 155});
        mediaHistory.index --;
        refresh(true);
    }

    if(mediaEvent.penEditHistory)
        eventRevoke();
    else
        mediaRevoke();
}

/** 重做操作 **/
function redo ()
{
    // mediaEvent 对象的重做
    function eventRedo()
    {
        if (!mediaEvent.penEditHistory.list[mediaEvent.penEditHistory.index + 1])
        {
            if (mediaEvent.penEditHistory.redoSkip){
                return mediaRedo();
            } else{
                mediaEvent.penEditHistory.redoSkip = true;
                if (mediaEvent.penEditHistory.index > 0)
                    mediaEvent.penEditHistory.revokeSkip = false;
                return Z.tips({text: '继续“重做”将跳出钢笔编辑！', width: 250, timeout: 3000});
            }
        }
        mediaEvent.penEditHistory.index++;
        mediaEvent.loadPenEditHistory();
    }
    // media 对象的重做
    function mediaRedo()
    {
        //去除编辑工具
        mediaEvent.removeAllEditTool();
        if (mediaHistory.index >= mediaHistory.list.length - 1)
            return Z.tips({text: '不能再重做了！', width: 155});
        mediaHistory.index ++;
        refresh(true);
    }

    if(mediaEvent.penEditHistory)
        eventRedo();
    else
        mediaRedo();
}

/** 显示尺寸设置框 */
function showSizeSetBox(event)
{
    // 1：显示编辑框
    var $thisBtn = Z(Z.E.current(event));
    mediaEvent.removeAllEditTool();
    docPopupReset(event);
    Z("#canvas_size_box").css({
        "left" : $thisBtn.offsetLeftBody() - 2,
        "top" : $thisBtn.offsetTopBody() + $thisBtn.offsetHeight() + 2
    });
    // 2：赋值输入框
    var curBg = media.getCurBg();
    var bleedSize = media.canvas.bleedSize || 0;
    var widthValue = curBg.widthMm - bleedSize;
    var heightValue = curBg.heightMm - bleedSize;
    if (media.canvas.createMode === 1)
    {
        widthValue = curBg.width - mm2px(bleedSize);
        heightValue = curBg.height - mm2px(bleedSize);
    }
    Z("#canvas_width").val(widthValue);
    Z("#canvas_height").val(heightValue);

    // 3：赋值锁定倍数
    Z('#canvas_size_box .scaleLockWrap').attr('data-scale', widthValue / heightValue);
}

/** 改变画布尺寸 */
function changeCanvas(createMode)
{
    // 重设 canvas width、height、fullWidth、fullHeight
    function resetCanvasSize()
    {
        function getAreaTimes(widthMm, heightMm)
        {
            var fullWidthMm = Math.ceil(widthMm / cardBaseData.baseWidthMm);
            var fullHeightMm = Math.ceil(heightMm / cardBaseData.baseHeightMm);
            return fullWidthMm * fullHeightMm;
        }

        // 补出血长度
        newWidthMm += bleedSize;
        newHeightMm += bleedSize;
        newWidth = mm2px(newWidthMm);
        newHeight = mm2px(newHeightMm);

        // 切换横竖版，减少用纸单位
        if (getAreaTimes(newHeightMm, newWidthMm) < getAreaTimes(newWidthMm, newHeightMm))
        {
            // width、height 对调
            var setWidth = newWidth;
            newWidth = newHeight;
            newHeight = setWidth;
            var setWidthMm = newWidthMm;
            newWidthMm = newHeightMm;
            newHeightMm = setWidthMm;

            // 修改输入框内容
            var widthInput = Z("#canvas_width").val();
            Z("#canvas_width").val(Z("#canvas_height").val());
            Z("#canvas_height").val(widthInput);
        }

        media.canvas.widthMm = newWidthMm;
        media.canvas.heightMm = newHeightMm;
        media.canvas.width = newWidth;
        media.canvas.height = newHeight;
        media.canvas.fullWidthMm = cardBaseData.baseWidthMm * Math.ceil(newWidthMm / cardBaseData.baseWidthMm);
        media.canvas.fullHeightMm = cardBaseData.baseHeightMm * Math.ceil(newHeightMm / cardBaseData.baseHeightMm);
        media.canvas.fullWidth = mm2px(media.canvas.fullWidthMm);
        media.canvas.fullHeight = mm2px(media.canvas.fullHeightMm);

        for(var i = 0;i < media.bgList.length;i++)
        {
            media.initBgSize(media.bgList[i]);
            media.tool.updateBgSize(media.bgList[i].bid);
        }
    }
    // 设置“背景素材”
    function setBgMaterial()
    {
        var bgObj = media.getCurBg();
        var $bgElem = media.tool.$canvasMaterial.querySelector('g[id^="svgElementSon_"][data-bgmaterial]');
        if ($bgElem)
        {
            var bgMaterial = media.getMaterialByMid($bgElem.getAttribute('data-mid'));
            if (bgMaterial.bgMaterial)
            {
                var $svg = $bgElem.querySelector('svg');
                $svg.setAttribute('width', bgObj.width);
                $svg.setAttribute('height', bgObj.height);
                updateMaterialSource(bgMaterial, $bgElem);
            }
        }
    }
    // 设置“遮罩素材”
    function setCanvasCover()
    {
        var widthSpace = Math.abs(media.canvas.fullWidthMm - media.canvas.widthMm);
        var heightSpace = Math.abs(media.canvas.fullHeightMm - media.canvas.heightMm);
        media.coverMaterialList.length = 0;
        if (widthSpace <= deviationSizeMm && heightSpace <= deviationSizeMm)
        {
            media.tool.$canvasCover.innerHTML = '';
            return;
        }
        var i, bgObj;
        for (i = 0;i < media.bgList.length;i++)
        {
            bgObj = media.bgList[i];
            setCoverMaterial(bgObj, newWidthMm, newHeightMm);
        }
    }

    // 1：定义变量
    var bleedSize = media.canvas.bleedSize || 0;
    var newWidth = parseFloat(Z("#canvas_width").val());
    var newHeight = parseFloat(Z("#canvas_height").val());
    var newWidthMm = newWidth;
    var newHeightMm = newHeight;
    if(createMode ===  0)
    {
        newWidth = mm2px(newWidthMm);
        newHeight = mm2px(newHeightMm);
    }
    else
    {
        newWidthMm = px2mm(newWidthMm);
        newHeightMm = px2mm(newHeightMm);
    }
    if (newWidthMm <= 2 || newHeightMm <= 2)
        return Z.failure('尺寸大小输入有误，请重新输入！');

    // 2：隐藏尺寸框
    Z("#canvas_size_box").removeAttr("style");

    // 3：根据设置大小，重设画布宽高属性
    resetCanvasSize();

    // 4：设置 cover 素材，并加载
    setBgMaterial();
    setCanvasCover();
    insertCoverMaterial();

    // 4：刷新版面
    refreshPageList();
    media.tool.updateCurBgSize();
    media.tool.createSvgCanvas();

    // 5：cover 素材加载
    insertCoverMaterial();

    // 6：添加到历史记录
    saveHistory();

    // 7：隐藏所有框
    selectionAll_hide();
}
/** 切换排版类型 **/
function doChangeOddEven(bid)
{
    // 设置 canvas 属性
    function setCanvasOddEven()
    {
        var mediaOddEven = 0;
        var i = 0;
        for(i;i < media.bgList.length;i++)
        {
            if(media.bgList[i].oddEven === 1)
            {
                mediaOddEven = 1;
                break;
            }
        }
        media.canvas.oddEven = mediaOddEven;
    }
    // 设置“背景素材”
    function setBgMaterial()
    {
        var material, $curElem, $svg;
        for(i = 0;i < media.materialList.length;i++)
        {
            material = media.materialList[i];
            if (!material.bgMaterial)
                continue;
            if (material.bid !== bgObj.bid)
                continue;
            $curElem = Z(material.source)[0];
            $svg = $curElem.querySelector('svg');
            $svg.setAttribute('width', bgObj.width);
            $svg.setAttribute('height', bgObj.height);
            material.source = $curElem.outerHTML;
            break;
        }
    }
    // 移除当前版面的“遮罩素材”
    function resetCoverList()
    {
        var coverList = Z.clone(media.coverMaterialList);
        media.coverMaterialList = null;
        var newCoverList = [];
        var coverMaterial;
        for(i = 0;i < coverList.length;i++)
        {
            coverMaterial = coverList[i];
            if (coverMaterial.bid !== bgObj.bid)
                newCoverList.push(coverMaterial);
        }
        coverList = null;
        media.coverMaterialList = newCoverList;
    }

    // 1：去除编辑工具
    mediaEvent.removeAllEditTool();

    // 2：重新定义 oddEven
    var bgObj = media.getBg(bid);
    if(bgObj.oddEven === 0) bgObj.oddEven = 1;
    else bgObj.oddEven = 0;

    // 3：定义 canvas 的 oddEven 属性
    setCanvasOddEven();

    // 4：初始化背景属性
    media.initBgSize(bgObj);
    media.tool.updateBgSize(bid);

    // 5：修改背景素材
    setBgMaterial();

    // 6：重构“遮罩素材列表”
    resetCoverList();
    setCoverMaterial(bgObj, bgObj.widthMm, bgObj.heightMm);
}

/** 设置 cover 素材列表 */
function setCoverMaterial(bgObj, newWidthMm, newHeightMm)
{
    function pushCoverElement(width, height, left, top, mid, textRotate)
    {
        var $gCover = document.createElementNS(xmlns, 'g');
        $gCover.innerHTML = '<rect fill="#FFFBC6" stroke="#E50065" stroke-width="1" width="200" height="100"></rect>' +
            '<g>' +
            '<line stroke-linecap="square" stroke="#E50065" stroke-width="5" x1="0" y1="0" x2="200" y2="100"></line>' +
            '<line stroke-linecap="square" stroke="#E50065" stroke-width="5" x1="0" y1="100" x2="200" y2="0"></line>' +
            '</g><g></g>';
        var $rectBg = $gCover.querySelector('rect');
        var $$crossLine = $gCover.querySelectorAll('line');
        var $$g = $gCover.querySelectorAll('g');
        var $textWrap = $$g[1];

        var bleedSize = media.canvas.bleedSize;
        var textStr = '完成尺寸：' + (newWidthMm - bleedSize) + ' x ' + (newHeightMm - bleedSize) + 'mm，模位：' +
            Math.ceil(media.canvas.widthMm / cardBaseData.baseWidthMm) * Math.ceil(media.canvas.heightMm / cardBaseData.baseHeightMm);
        $textWrap.appendChild(getPathSvgFromText(textStr, {fontFamily:"宋体", fontSize:"35px", fontWeight:0, fontColor: "#000000"}));
        var $textSvg = $textWrap.querySelector("svg");
        var $gText = $textSvg.querySelector("g");

        // 容器属性设置
        $gCover.setAttribute('transform', 'translate(' + left + ' ' + top + ')');
        // 背景属性设置
        $rectBg.setAttribute('width', width);
        $rectBg.setAttribute('height', height);
        // 打叉属性设置
        $$crossLine[0].setAttribute('x2', width);
        $$crossLine[0].setAttribute('y2', height);
        $$crossLine[1].setAttribute('y1', height);
        $$crossLine[1].setAttribute('x2', width);

        // 文字属性设置
        $textSvg.setAttribute('width', width);
        $textSvg.setAttribute('height', height);
        $textSvg.setAttribute('viewBox', '0 0 ' + width + ' ' + height);

        // 插入页面，计算大小
        var $bodySvg = document.createElementNS(xmlns, 'svg');
        $bodySvg.setAttribute('viewBox', '0 0 ' + media.canvas.fullWidth + ' ' + media.canvas.fullHeight);
        $bodySvg.setAttribute('width', media.canvas.fullWidth);
        $bodySvg.setAttribute('height', media.canvas.fullHeight);
        $bodySvg.setAttribute('style', 'position:absolute;z-index:-9999;pointer-events:none;opacity:0;');
        $bodySvg.appendChild($gCover);
        document.documentElement.appendChild($bodySvg);

        var svgBox = $textSvg.getBBox();
        var textTrans = $gText.getAttribute("transform") || "";

        // 偏移校准
        var translateStr = "translate(" + (width - svgBox.width) / 2 +
            " " + ((height - svgBox.height) / 2 + 29) + ")";
        if (textTrans.indexOf("translate") > -1)
            textTrans = textTrans.replace(/translate[^)]+\)/, translateStr);
        else
            textTrans = (textTrans.trim() + " " + translateStr).trim();
        // 旋转校准
        if (textRotate)
        {
            var rotateStr = 'rotate(' + textRotate + ' ' +  svgBox.width/2 + ' ' + (svgBox.height/2 - 29) + ')';
            if (textTrans.indexOf("rotate") > -1)
                textTrans = textTrans.replace(/rotate[^)]+\)/, rotateStr);
            else
                textTrans = (textTrans.trim() + " " + rotateStr).trim();
        }
        $gText.setAttribute('transform', textTrans);
        svgBox = $textSvg.getBBox();

        if (svgBox.x < 0 || svgBox.y < 0)
        {
            var setSvgView = (svgBox.x < 0 ? svgBox.x : 0) + ' ';
            setSvgView += (svgBox.y < 0 ? svgBox.y : 0) + ' ';
            setSvgView += (svgBox.x < 0 ? svgBox.width : width) + ' ';
            setSvgView += (svgBox.y < 0 ? svgBox.height : height);
            $textSvg.setAttribute('viewBox', setSvgView);
        }

        // 插入对象
        var html = $gCover.outerHTML;
        media.coverMaterialList.push(new Z.CoverMaterial(
            {
                mediaId: media.canvas.mediaId,               // 1.媒体编号
                bid: bgObj.bid,                              // 2.背景编号
                mid: mid,                                    // 3.素材编号
                source: html,                                // 4.素材内容
            }));

        // 移除辅助对象
        document.documentElement.removeChild($bodySvg);

        // 插入数组
        newList.push(html);
    }

    var widthSpace = media.canvas.fullWidth - media.canvas.width;
    var heightSpace = media.canvas.fullHeight - media.canvas.height;
    var bgIndex = media.bgList.indexOf(bgObj);

    var newList = [];
    if (Math.abs(widthSpace) > deviationSizePx)
    {
        // 位置偏移：偶序版面
        if (bgIndex%2 === 0)
        {
            // 横板
            if (bgObj.oddEven === 0)
                pushCoverElement(widthSpace, media.canvas.height, media.canvas.width, 0, 0, 90);
            // 竖板
            else
                pushCoverElement(media.canvas.height, widthSpace, 0, -widthSpace, 0);
        }
        // 位置偏移：奇序版面
        else
        {
            // 横板
            if (bgObj.oddEven === 0)
                pushCoverElement(widthSpace, media.canvas.height, -widthSpace, 0, 0, 90);
            // 竖板
            else
                pushCoverElement(media.canvas.height, widthSpace, 0, -widthSpace, 0, 180);
        }
    }
    // 高度裁切
    if (Math.abs(heightSpace) > deviationSizePx)
    {
        // 位置偏移：偶序版面
        if (bgIndex%2 === 0)
        {
            // 横板
            if (bgObj.oddEven === 0)
                pushCoverElement(media.canvas.fullWidth, heightSpace, 0, media.canvas.height, 1);
            // 竖板
            else
                pushCoverElement(heightSpace, media.canvas.fullWidth, media.canvas.height, -widthSpace, 1, 270);
        }
        // 位置偏移：奇序版面
        else
        {
            // 横板
            if (bgObj.oddEven === 0)
                pushCoverElement(media.canvas.fullWidth, heightSpace, -widthSpace, media.canvas.height, 1);
            // 竖板
            else
                pushCoverElement(heightSpace, media.canvas.fullWidth, -heightSpace, -widthSpace, 1, 90);
        }
    }
    // 返回该版面所有coverMaterial;
    return newList;
}
/** 显示保存类型列表 */
function showMediaSaveList(event)
{
    showTypeSelectList(event, "mediaSave_box");
}
/** 显示下载类型列表 */
function showDownloadList(event)
{
    showTypeSelectList(event, "imageDownload_box");
}
/** 显示类型列表 */
function showTypeSelectList(event, id)
{
    //去除编辑工具
    mediaEvent.removeAllEditTool();

    docPopupReset(event);
    var $thisBtn = Z(Z.E.current(event));
    var $download_box = Z("#" + id);
    var left = $thisBtn.offsetLeftBody() - 2;
    var top = $thisBtn.offsetTopBody() + $thisBtn.offsetHeight() + 2;

    if (document.documentElement.offsetWidth - left < $download_box.offsetWidth()) {
        left = document.documentElement.offsetWidth - $download_box.offsetWidth();
    }
    //设置显示框位置
    $download_box.css({"left":left,"top":top});
}
/** 选择svg背景 */
function selBgSvgCode(svgId)
{
    var ajax = new Z.Ajax();
    ajax.setClassName("MediaPresenter");
    ajax.setMethodName("getMediaSvg");
    ajax.addParam(svgId);
    ajax.setFailure(function(){Z.failure(this.responseText);});
    ajax.setSuccess(function(){
        var mediaSvg = Z.J.toObject(this.responseText);
        media.tool.setBgSvgCode(mediaSvg.svgCode);
        saveHistory();
    });
    ajax.execute();
}
/** 切换版面 */
function doChangePage(ele, curPage)
{
    // 去除编辑工具
    mediaEvent.removeAllEditTool();
    // 隐藏弹窗、工具栏
    hideEditSelected(true);

    // 定义新版面
    media.curPage = curPage;
    Z(ele).addClass("active").siblings("li").removeClass("active");

    // 加载画布
    loadCanvas(true);
    // 保存
    saveHistory();

    // 取消参数选中效果
    if (Z("#paramList .active")[0]){
        Z("#paramList .active").removeClass("active");
    }

    // 居中画布
    media.tool.setRatioCanvas();
    media.tool.locationTrueCanvas();

    // 重定义缩略图画布
    setZoomArea();
}

/** 保存媒体 */
function designSave()
{
    if (!checkParamList()) 
    {
        Z.confirm('您有部分参数未设置，确定保存吗？', function()
              {
                doSaveMedia();
              }, 
              {
                  hasBackground:true
              }
            );
    } 
    else 
    {
        doSaveMedia();
    }
}
/** 保存设计media数据+更新缩略图 **/
function doSaveMedia()
{
    // 执行AJAX保存，生成效果图
    function doAjaxSave()
    {
        var ajax = new Z.Ajax();
        ajax.setClassName("MediaPresenter");
        ajax.setMethodName("doSaveMedia");
        ajax.addParam("mediaJson", media.toString());
        ajax.addParam("paramJson", paramJson);
        ajax.addParam("mediaId", media.canvas.mediaId);
        ajax.setFailure(function()
        {
            Z.failure(this.responseText, function()
            {
                if (typeof(doSave_ajaxLoading) !== "undefined" && doSave_ajaxLoading && doSave_ajaxLoading.close)
                {
                    window.doSave_ajaxLoading.close();
                }
            });
        });
        ajax.setSuccess(function()
        {
            var obj = Z.J.toObject(this.responseText);
            if (!obj || !obj.saveHandelId || obj.saveHandelId <= 0)
            {
                console.error("设计media数据保存失败:" + obj)
                Z.failure("保存时失败", function()
                {
                    if (typeof(doSave_ajaxLoading) !== "undefined" && doSave_ajaxLoading && doSave_ajaxLoading.close)
                    {
                        window.doSave_ajaxLoading.close();
                    }
                });
                
                return;
            }
            
            media.saveHandelId = obj.saveHandelId;
            doSaveQueryTimer(function()
            {
                window.doSave_ajaxLoading.close();
                window.doSave_ajaxLoading = null;
                var tmpAjax = new Z.Ajax();
            	tmpAjax.setClassName("TemplatePresenter");
            	tmpAjax.setMethodName("doTemplateUpdate");
            	tmpAjax.addParam("mediaId", media.canvas.mediaId);
            	tmpAjax.execute();
                Z.success("保存成功!", function(){
                    var url = window.location.pathname;
                    var isTemplateEdit = window.location.search.indexOf("isTemplateEdit=true");
                    var orderIsCardType = window.location.search.indexOf("orderIsCardType=true");
                    
                    // 如果是智能名片，地址栏刷新时拼接名片id和设计id参数
                    var dzmpCardIdParam= "";
                    var dzmpCardDesignIdParam= "";
                    if (orderIsCardType > -1)
                	{
                    	dzmpCardIdParam = "&cardId=" + top.window.tmpDzmpCardId;
                    	dzmpCardDesignIdParam = "&designId=" + top.window.tmpDzmpCardDesignId;
                	}
                    
                    url += "?mediaId=" + media.canvas.mediaId + "&paramJson=" + paramJson;
                    url += (isTemplateEdit > -1 ? "&isTemplateEdit=true" : "") + (orderIsCardType > -1 ? "&orderIsCardType=true" : "");
                    url += dzmpCardIdParam;
                    url += dzmpCardDesignIdParam;
                    Z.l.href = url;
                });
            }, 
            function(errorMsg)
            {
                window.doSave_ajaxLoading.close();
                window.doSave_ajaxLoading = null;
                Z.failure(errorMsg);
            });
        });
        ajax.execute();
    }
    
    
    function doSave()
    {
         // 1：定义加载框
        window.doSave_ajaxLoading = Z.loading({text:'正在保存...', width:160, shadow: true});
        
        // 2：去除编辑工具
        mediaEvent.removeAllEditTool();
        
        // 3：保存缓存
        media.canvas.editTime = new Date().getTime() + '';
        saveHistory(media.toString());
        
        // 4：执行保存-分类处理
        if (hasSvg2pdfAPI)
        {
            // 本地存储，更新缩略图
            doUpdateImageLocalSave(doSave_ajaxLoading, function ()
            {
                Z.success("保存成功!", function(){
                    window.doSave_ajaxLoading.close();
                    window.doSave_ajaxLoading = null;
                    var url = window.location.pathname;
                    Z.l.href = url + "?mediaId=" + media.canvas.mediaId + "&paramJson=" + paramJson;
                });
            });
        } else {
            doAjaxSave();
        }
    }
    
    //检查设计稿是否保存中或者生成pdf中...
    mediaIsSaveingOrTopdf(doSave);
}

//检查设计稿是否保存中或者生成pdf中
function mediaIsSaveingOrTopdf(callback, param1, param2, param3)
{
    var ajax = new Z.Ajax();
    ajax.setClassName("MediaPresenter");
    ajax.setMethodName("doIsSaveingOrTopdf");
    ajax.addParam("mediaId", media.canvas.mediaId);
    ajax.setFailure(function()
    {
        Z.failure(this.responseText, function()
        {
            if (typeof(doSave_ajaxLoading) !== "undefined" && doSave_ajaxLoading && doSave_ajaxLoading.close)
            {
                 window.doSave_ajaxLoading.close();
            }
            
            Z.Dialog.close();//关闭其他窗口
        });
    });
    ajax.setSuccess(function()
    {
        var obj = Z.J.toObject(this.responseText);
        console.log("check_saveing:" + obj.isSaveing);
        console.log("check_topdf:" + obj.isHandelTopdf);
        if (obj.isSaveing)
        {
            if (typeof(doSave_ajaxLoading) !== "undefined" && doSave_ajaxLoading && doSave_ajaxLoading.close)
            {
                 window.doSave_ajaxLoading.close();
            }
            
            Z.confirm("模板数据正在保存中，是否覆盖上一次操作？", function()
            {
                 callback(param1, param2, param3);
            });
        }
        else if (obj.isHandelTopdf)
        {
            if (typeof(doSave_ajaxLoading) !== "undefined" && doSave_ajaxLoading && doSave_ajaxLoading.close)
            {
                 window.doSave_ajaxLoading.close();
            }
        
            Z.confirm("模板正在生成PDF文件中，重复操作可能会影响最终PDF内容生成！是否继续？", function(){callback(param1, param2, param3);})
        }
        else
        {
            if (Z.T.isFunction(callback))
            {
                callback(param1, param2, param3);
            }
        }
    });
    ajax.execute();
}

/** 仅保存设计media数据 **/
function doSaveDataOnly()
{
    // 执行AJAX保存，生成效果图
    function doAjaxSave()
    {
        var ajax = new Z.Ajax();
        ajax.setClassName("MediaPresenter");
        ajax.setMethodName("doSaveMediaData");
        ajax.addParam("mediaJson", media.toString());
        ajax.addParam("mediaId", media.canvas.mediaId);
        ajax.setFailure(function()
        {
            Z.failure(this.responseText, function()
            {
                if (doSave_ajaxLoading && doSave_ajaxLoading.close)
                    window.doSave_ajaxLoading.close();
            });
            doClearErrorLocalSave(this.responseText);
        });
        ajax.setSuccess(function()
        {
            if (doSave_ajaxLoading && doSave_ajaxLoading.close)
            {
                window.doSave_ajaxLoading.close();
            }       
            var tmpAjax = new Z.Ajax();
        	tmpAjax.setClassName("TemplatePresenter");
        	tmpAjax.setMethodName("doTemplateUpdate");
        	tmpAjax.addParam("mediaId", media.canvas.mediaId);
        	tmpAjax.execute();
            Z.success("保存成功!", function(){
                var url = window.location.pathname;
                var isTemplateEdit = window.location.search.indexOf("isTemplateEdit=true");
                var orderIsCardType = window.location.search.indexOf("orderIsCardType=true");
                
                // 如果是智能名片，地址栏刷新时拼接名片id和设计id参数
                var dzmpCardIdParam= "";
                var dzmpCardDesignIdParam= "";
                if (orderIsCardType > -1)
            	{
                	dzmpCardIdParam = "&cardId=" + top.window.tmpDzmpCardId;
                	dzmpCardDesignIdParam = "&designId=" + top.window.tmpDzmpCardDesignId;
            	}
                
                url += "?mediaId=" + media.canvas.mediaId + "&paramJson=" + paramJson;
                url += (isTemplateEdit > -1 ? "&isTemplateEdit=true" : "") + (orderIsCardType > -1 ? "&orderIsCardType=true" : "");
                url += dzmpCardIdParam;
                url += dzmpCardDesignIdParam;
                Z.l.href = url;
            });
        });
        ajax.execute();
    }

    // 1：定义加载框
    window.doSave_ajaxLoading = Z.loading({text:'正在保存...', width:160, shadow: true});

    // 2：去除编辑工具
    mediaEvent.removeAllEditTool();

    // 3：保存缓存
    media.canvas.editTime = new Date().getTime() + '';
    var mediaString = media.toString();
    saveHistory(mediaString);

    //检查设计稿是否保存中或者生成pdf中...
    mediaIsSaveingOrTopdf(doAjaxSave);
}

//自动保存素材 
function doAutoSaveMedia(callback, bid, isDoImg)
{
    //检测后回到保存
    function doSave()
    {
        var ajax = new Z.Ajax();
        ajax.setClassName("MediaPresenter");
        ajax.setMethodName("doAutoSaveMedia");
        ajax.addParam("mediaJson", media.toString());
        ajax.addParam("paramJson", paramJson);
        ajax.addParam("mediaId", media.canvas.mediaId);
        ajax.addParam("isDoImg", isDoImg);
        ajax.setFailure(function(){Z.failure(this.responseText);});
        ajax.setSuccess(function()
        {
            var obj = Z.J.toObject(this.responseText);
            if (!obj || !obj.saveHandelId || obj.saveHandelId <= 0)
            {
                console.log("自动保存素材失败:" + obj);
                Z.failure("保存时失败", function()
                {
                    if (typeof(doSave_ajaxLoading) !== "undefined" && doSave_ajaxLoading && doSave_ajaxLoading.close)
                    {
                        window.doSave_ajaxLoading.close();
                    }
                });
                
                return;
            }
            
            media.saveHandelId = obj.saveHandelId;
            doSaveQueryTimer(function()
            {
                Z.T.isFunction(callback) && callback(bid);
            });
        });
        ajax.execute();
    }
    
    //检查设计稿是否保存中或者生成pdf中...
    mediaIsSaveingOrTopdf(doSave)
}

//定时查询订单模板保存结果
function doSaveQueryTimer(callback, failureFun)
{
    var ajax = new Z.Ajax();
    ajax.setClassName("MediaPresenter");
    ajax.setMethodName("doQuerySaveMediaStatus");
    ajax.addParam("mediaId", media.canvas.mediaId);
    ajax.addParam("saveHandelId", media.saveHandelId);
    ajax.setFailure(function(){Z.failure(this.responseText);});
    ajax.setSuccess(function()
    {
        var responseObj = Z.J.toObject(this.responseText);
        if (!responseObj)
        {
            Z.Dialog.close();
            Z.failure('保存出错，请稍后尝试!');
            return;
        }

        switch(responseObj.handleStatus)
        {
            case 0: // 待处理
            case 1: // 处理中
                setTimeout(doSaveQueryTimer, 2000, callback, failureFun);
                break;
            case 2: // 处理完成
                Z.T.isFunction(callback) && callback();
                break;
            case 3: // 处理失败
                var errorMsg = responseObj.errorMsg || '保存出错，请稍后尝试!';
                if (Z.T.isFunction(failureFun))
                {
                    failureFun(errorMsg);
                }
                else
                {
                    Z.Dialog.close();
                    Z.failure(errorMsg);
                }
                break;
        }
    });
    ajax.execute();
}

/** 预览 **/
function doPriview(cardId)
{
	// 智能名片预览二维码弹窗
	if (!Z.V.isEmpty(cardId))
	{
		beforeShowDzmpQrcode("preview");
		return;
	}
	
	
    //去除编辑工具
    mediaEvent.removeAllEditTool();
    
    var dialogWidth = Math.round(media.tool.$designStage.offsetWidth-100);
    var dialogHeight = Math.round(media.tool.$designStage.offsetHeight-100);
    dialogWidth = (dialogWidth > 800)?(dialogWidth):(800);
    dialogHeight = (dialogHeight > 600)?(dialogHeight):(600);
        
    var dialog = new Z.Dialog();
    dialog.title = "效果预览";
    dialog.url = "mediaPreview.htm";
    dialog.width = dialogWidth;
    dialog.height = dialogHeight;
    dialog.fixed = true;
    dialog.execute();
}
/** 新建版面 **/
function doNewPage()
{
    // 保存后的回调方法
    function callbackAfterSave()
    {
        // 新建 coverMaterial，字符串传参
        var lastBgObj = media.bgList[media.bgList.length - 1];
        var newBid = lastBgObj.bid + 1;
        var bgObj = new Z.Bg();
        bgObj.bid = newBid;
        media.bgList.push(bgObj);
        var newCMList = setCoverMaterial(bgObj, media.canvas.widthMm, media.canvas.heightMm);

        // ajax 执行数据库插入
        var ajax = new Z.Ajax();
        ajax.setClassName("MediaPresenter");
        ajax.setMethodName("doNewPage");
        ajax.addParam("mediaId", media.canvas.mediaId);
        ajax.addParam("bid", bgObj.bid);
        ajax.addParam("coverMaterialList", Z.AR.toString(newCMList));
        ajax.setFailure(function()
        {
            media.bgList.pop();
            if (doNewPage_ajax_loading && doNewPage_ajax_loading.close)
                doNewPage_ajax_loading.close();
        });
        ajax.setSuccess(function()
        {
            // 定义 media
            var newMedia = Z.J.toObject(this.responseText);
            media = new Z.Media({canvas: newMedia.canvas, bgList: newMedia.bgList, materialList: newMedia.materialList, coverMaterialList: newMedia.coverMaterialList});
            media.curPage = media.bgList[media.bgList.length - 1].bid;
            // 刷新画布
            loadCanvas();
            // 刷新版面
            refreshPageList();
            // 清除加载框
            if (doNewPage_ajax_loading && doNewPage_ajax_loading.close)
                doNewPage_ajax_loading.close();
        });
        ajax.execute();
    }

    // 去除编辑工具
    mediaEvent.removeAllEditTool();
    window.doNewPage_ajax_loading =  Z.loading({text:"处理中···",shadow:true});
    doAutoSaveMedia(callbackAfterSave, null, false);
}
/** 复制版面 **/
function doCopyPage(bid,event)
{
    // 保存后的回调方法
    function callbackAfterSave(bid)
    {
        var ajax = new Z.Ajax();
        ajax.setClassName("MediaPresenter");
        ajax.setMethodName("doCopyPage");
        ajax.addParam("mediaId", media.canvas.mediaId);
        ajax.addParam("bid", bid);
        ajax.setFailure(function()
        {
            Z.failure(this.responseText,function()
            {
                if (doCopyPage_ajax_loading && doCopyPage_ajax_loading.close)
                    doCopyPage_ajax_loading.close();
            });
        });
        ajax.setSuccess(function()
        {
            // 定义 media
            var newMedia = Z.J.toObject(this.responseText);
            media = new Z.Media({canvas: newMedia.canvas, bgList: newMedia.bgList, materialList: newMedia.materialList, coverMaterialList: newMedia.coverMaterialList});
            media.curPage = media.bgList[media.bgList.length - 1].bid;
            // 刷新画布
            loadCanvas();
            // 刷新版面
            refreshPageList();
            // 清除加载框
            if (doCopyPage_ajax_loading && doCopyPage_ajax_loading.close)
                doCopyPage_ajax_loading.close();
        });
        ajax.execute();
    }

    Z.E.forbidden(event);
    //去除编辑工具
    mediaEvent.removeAllEditTool();

    window.doCopyPage_ajax_loading =  Z.loading({text:"处理中···",shadow:true});
    doAutoSaveMedia(callbackAfterSave, bid, false);
}
/** 删除版面 **/
function doDelPage(bid,event)
{
    // 保存后的回调方法
    function callbackAfterSave(bid)
    {
        var ajax = new Z.Ajax();
        ajax.setClassName("MediaPresenter");
        ajax.setMethodName("doDelPage");
        ajax.addParam("mediaId", media.canvas.mediaId);
        ajax.addParam("bid", bid);
        ajax.setFailure(function()
        {
            Z.failure(this.responseText, function()
            {
                if (doDelPage_ajax_loading && doDelPage_ajax_loading.close)
                    doDelPage_ajax_loading.close();
            });
        });
        ajax.setSuccess(function()
        {
            // 定义 media
            var newMedia = Z.J.toObject(this.responseText);
            media = new Z.Media({canvas: newMedia.canvas, bgList: newMedia.bgList, materialList: newMedia.materialList, coverMaterialList: newMedia.coverMaterialList});
            media.curPage = isDelCurPage;
            // 刷新画布
            loadCanvas();
            // 刷新版面
            refreshPageList();
            // 清除加载框
            if (doDelPage_ajax_loading && doDelPage_ajax_loading.close)
                doDelPage_ajax_loading.close();
        });
        ajax.execute();
    }

    Z.E.forbidden(event);
    //去除编辑工具
    mediaEvent.removeAllEditTool();
    bid = parseFloat(bid);
    var isDelCurPage = (bid === media.curPage) ? 0 : media.curPage;

    Z.confirm("请确定是否删除该版面，删除后不可恢复", function()
    {
        window.doDelPage_ajax_loading =  Z.loading({text:"处理中···",shadow:true});
        doAutoSaveMedia(callbackAfterSave, bid, false);
    });
}

/** 刷新版面列表 **/
function refreshPageList()
{
    var lists = media.bgList;
    var i, curPage, itemStr;
    Z("#pageList").html("");
    for (i = 0;i < lists.length;i++)
    {
        curPage = lists[i].bid;
        itemStr = '<li id="pageItem_' + curPage + '" onclick="doChangePage(this, ' + curPage + ');">';
        itemStr += '<span  class="btn_locTop"><a onclick="doCopyPage(' + curPage + ',event);">复制</a><a onclick="doDelPage(' + curPage + ',event);">删除</a></span>';
        itemStr += '<span  class="btn_locBottom"><a onclick="doChangeOddEven(' + curPage + ');">切换</a></span></li>';
        Z.D.id("pageList").insertAdjacentHTML("beforeend",itemStr);
        curPage = "" + curPage;
        refreshSvgThumbnail(curPage);
    }
    Z("#pageItem_" + media.curPage).addClass("active");
}

/** 下载文件 0：jpg、1：png、2：pdf、3：svg **/
function doDownloadFile(fileType)
{
    // 保存后的回调方法
    function callbackAfterSave()
    {
        var ajax = new Z.Ajax();
        ajax.setClassName("MediaPresenter");
        ajax.setMethodName("doDownloadFile");
        ajax.addParam("mediaId", media.canvas.mediaId);
        ajax.addParam("fileType", fileType);
        ajax.setFailure(function()
        {
            Z.failure(this.responseText, function()
            {
                if (doDownloadFile_ajax_loading && doDownloadFile_ajax_loading.close)
                    doDownloadFile_ajax_loading.close();
            });
        });
        ajax.setSuccess(function()
        {
            var suffix = ".zip";
            if(fileType === 2 || fileType === 5)
                suffix = ".pdf";
            else if(fileType === 3)
                suffix = ".svg";
            
            var fileName = media.canvas.mediaId + suffix;
            
            function downloadFile(url, fileName)
            {
                var element1 = document.createElement("a");
                element1.href = url;
                element1.setAttribute("download", fileName);
                element1.click();
    
                Z("#imageDownload_box").removeAttr("style");
                // 清除加载框
                if (doDownloadFile_ajax_loading && doDownloadFile_ajax_loading.close)
                    doDownloadFile_ajax_loading.close();
            }
            
            function queryHandlePdfprocessing(pdfHandelId, callback)
            {//查询异步处理pdf 进度
                var _ajax = new Z.Ajax();
                _ajax.setClassName("MediaPresenter");
                _ajax.setMethodName("doQueryHandelPdfStatus");
                _ajax.addParam("pdfHandelId", pdfHandelId);
                _ajax.setFailure(function()
                {
                    Z.failure(this.responseText, function()
                    {
                        Z("#imageDownload_box").removeAttr("style");
                        // 清除加载框
                        if (doDownloadFile_ajax_loading && doDownloadFile_ajax_loading.close)
                            doDownloadFile_ajax_loading.close();
                    });
                });
                _ajax.setSuccess(function()
                {
                    var responseObj = Z.J.toObject(_ajax.responseText);
                    if (!responseObj)
                    {
                         Z("#imageDownload_box").removeAttr("style");
                        // 清除加载框
                        if (doDownloadFile_ajax_loading && doDownloadFile_ajax_loading.close)
                            doDownloadFile_ajax_loading.close();
                            
                        Z.failure('生成pdf文件出错!');
                        return;
                    }
            
                    switch(responseObj.handleStatus)
                    {
                        case 0: // 待处理
                        case 1: // 处理中
                            setTimeout(queryHandlePdfprocessing, 2000, pdfHandelId, callback);
                            break;
                        case 2: // 处理完成
                            Z.T.isFunction(callback) && callback(responseObj.downloadUrl, fileName);
                            break;
                        case 3: // 处理失败
                            var errorMsg = responseObj.errorMsg || '生成pdf文件出错';
                            Z.failure(errorMsg);
                            break;
                    }
                });
                _ajax.execute();
                
            }
            
            var obj = Z.J.toObject(this.responseText)
            if (Z.V.isNotEmptyBlank(obj.downloadUrl))
            {//有url 则下载
                downloadFile(obj.downloadUrl, fileName);
            }
            else if (suffix == ".pdf" && obj.pdfHandelId > 0)
            {//异步生成pdf
                
                media.pdfHandelId = obj.pdfHandelId;
                setTimeout(queryHandlePdfprocessing, 2000, media.pdfHandelId, downloadFile);
            }
            else
            {
                downloadFile(obj.downloadUrl, fileName);
            }
            
        });
        ajax.execute();
    }

    window.doDownloadFile_ajax_loading =  Z.loading({text:"处理中···",shadow:true});
    fileType = parseFloat(fileType);
    if (hasSvg2pdfAPI)
        doDownloadFileLocalSave(doDownloadFile_ajax_loading, fileType);
    else
    {
        doAutoSaveMedia(callbackAfterSave, null, false);
    }
    
}

/** 检测所有参数是否存在，是返回true，否则返回false */
function checkParamList()
{
    if (Z.V.isEmpty(paramList)) {
        return true;
    }
    
    for (var j=0; j<media.materialList.length; j++) {
        var m = media.materialList[j];
        if (m.status !== 1 && Z.V.isEmpty(m.paramKey)) {
            return false;
        }
    }
    
    return true;
}

/** 媒体重命名*/
function rename(event)
{
    var $thisTitle = Z(Z.E.target(event));
    var $input = $thisTitle.hide().siblings().show().find('input');
    var oldVal = $input.val();
    $thisTitle.parent().addClass('texting');
    if (/^未命名$/.test(oldVal.trim()))
        $input.val('');
    $input.focus();
}
/** 媒体重命名完成*/
function renameDone(event)
{
    if (event.keyCode && event.keyCode !== 13) {
        return;
    }
    var $thisInput = Z(Z.E.target(event));
    var val = $thisInput.val();
    if (/^\s*$/.test(val)){
        val = '未命名';
        $thisInput.val(val);
    }
    $thisInput.parent().parent().removeClass('texting');
    $thisInput.parent().hide().siblings().show().html(val);
    media.canvas.mediaName = val;
}

/***************************************
**********  侧边栏工具、功能 **********
***************************************/
// 素材翻页对象
var fMaterial = {"typeCode":"bg", "catCode":"", "page":1, "pageSize":27, "totalPages":1, "q":"", "couldLoad": false};
/** 切换左边选项 **/
function doChangeSidebar(ele, sidebarType)
{
    Z(ele).addClass("active").siblings("li").removeClass("active");
    var thisId = "#side_" + sidebarType;
    var $$otherSide = Z(".sidebar-child div[id^='side_']:not(" + thisId + ")");
    var $thisSide = Z(thisId);
    $$otherSide.addClass("z-hide");
    $thisSide.removeClass("z-hide");
    
    // 切换到【智能名片】时默认展示【关联信息tab】
    if (sidebarType == "card")
	{
    	Z("#leftTab li:nth-child(1)").click();
	}

    // 计算展示高度
    resetResultListHeight($thisSide);
    
    fMaterial.typeCode = sidebarType;
    fMaterial.catCode = "";
    fMaterial.page = 1;
    fMaterial.pageSize = 27;
    fMaterial.q = "";

    shapeDrawStop();
}
// 重新计算列表容器高度
function resetResultListHeight($thisSide)
{
    $thisSide = Z.$elem($thisSide);
    var $$materialList = $thisSide.find(".materialListShow");
    var outerWrapRect = Z("#sidebar>.sidebar-child")[0].getBoundingClientRect();
    var i, $materialList, thisListRect, setHeight;
    for (i = 0;i < $$materialList.length;i++)
    {
        $materialList = $$materialList[i];
        thisListRect = $materialList.getBoundingClientRect();
        if(thisListRect.width === 0 && thisListRect.height === 0 && thisListRect.left === 0 &&
            thisListRect.top === 0 && thisListRect.left === 0 &&  thisListRect.right === 0)
            continue;
        setHeight = outerWrapRect.height - (thisListRect.top - outerWrapRect.top) - 15;
        Z($materialList).css("height", setHeight);
        break;
    }
}

/** 清空搜索素材 **/
function doClearQueryMaterial()
{
    Z("#search_result>.result-ul").html("");
    Z("#search_result>.result-tips").hide();
}
/** 搜索素材 **/
function doQueryMaterial()
{
    if (Z("#side_search").hasClass("z-hide")) {         //未显示搜索列表，执行点击方法模拟切换
        doChangeSidebar(Z(".sidebar-top>li:first-child"), "search");
    }
    var wrapHeight = parseInt(Z("#search_result").offsetHeight());
    var liItemHeight = 90;
    var liNum = Math.round(wrapHeight / liItemHeight) * 3 + 6;
    fMaterial.pageSize = liNum;
    
    var q = Z("#q").val();
    if (q != fMaterial.q) {                            //改变类目，页数置零
        fMaterial.q = q;
        fMaterial.page = 1;
        Z("#search_result>.result-ul").html("");
        Z("#search_result>.result-tips").hide();
    }
    
    var ajax = new Z.Ajax();
    ajax.setClassName("MediaPresenter");
    ajax.setMethodName("doQueryMaterial");
    ajax.addParam("typeCode", fMaterial.typeCode);
    ajax.addParam("catCode", "");
    ajax.addParam("q", Z("#q").val());
    ajax.addParam("page", fMaterial.page);
    ajax.addParam("pageSize", fMaterial.pageSize);
    //ajax.setCallback("search_result");
    ajax.setSuccess(function()
    {
        //fMaterial.totalPages = 
        var obj = Z.J.toObject(this.responseText);
        var typeCode = obj.typeCode;
        var list = obj.result.records;
        var ulHtml = "<ul>";
        for(var i=0;i<list.length;i++)
        {
            var data = list[i];
            ulHtml += '<li onclick="addSvgCode(' + data.svgId + ');" oncontextmenu=\'tagMenuShow(event,' + data.svgId + ');\'><img src="' + data.svgThumbnail + '"></li>';
        }
        ulHtml += "</ul>";
        Z("#search_result>.result-ul").append(Z(ulHtml));
        
        fMaterial.totalPages = obj.result.totalPages;
        //Z("#image_result").html(this.responseText);
        
        fMaterial.couldLoad = true;                               //定义可加载列表
        if (fMaterial.page >= fMaterial.totalPages)               //最后一页
        {
            Z("#search_result>.result-tips").show();
            fMaterial.couldLoad = false;                          //定义不可加载列表
        }
        // 显示页数
        var clientRect = Z("#search_result")[0].getBoundingClientRect();
        var setWidth = Z("#search_result").parent().offsetWidth();
        Z("#search_result>.result-page").css("width",setWidth).css("top",clientRect.top).css("left",clientRect.left)
            .children("span").html("1/" + fMaterial.totalPages);
    });
    ajax.setLoading("search_result");
    ajax.execute();
}

/** 选择素材分类 **/
function doQueryCatMaterial(catCode, resultType, clickStr, menuStr)
{
    var $wrap = Z("#" + resultType + "_result");
    var $resultUl = $wrap.find(".result-ul");
    var $resultTip = $wrap.find(".result-tips");
    var $resultPage = $wrap.find(".result-page");

    var wrapHeight = parseInt($wrap.offsetHeight());
    var liItemHeight = 84;
    fMaterial.pageSize = Math.round(wrapHeight / liItemHeight) * 3 + 6;
    
    if (catCode !== fMaterial.catCode)
    {
        fMaterial.catCode = catCode;
        fMaterial.page = 1;
        fMaterial.q = "";
        $resultUl.html("");
        $resultTip.hide();
    }
    
    var ajax = new Z.Ajax();
    ajax.setClassName("MediaPresenter");
    ajax.setMethodName("doQueryMaterial");
    ajax.addParam("typeCode", fMaterial.typeCode);
    ajax.addParam("catCode", catCode);
    ajax.addParam("q", fMaterial.q);
    ajax.addParam("page", fMaterial.page);
    ajax.addParam("pageSize", fMaterial.pageSize);
    ajax.setSuccess(function()
    {
        var obj = Z.J.toObject(this.responseText);
        var list = obj.result.records;
        var ulHtml = "<ul>";
        var i, data, clientRect, setWidth;
        for(i=0;i<list.length;i++)
        {
            data = list[i];
            ulHtml += '<li onclick="' + clickStr + '(' + data.svgId + ');"';
            if (menuStr)
                ulHtml += ' oncontextmenu="' + menuStr + '(event,' + data.svgId + ');"';
            ulHtml += '><img src="' + data.svgThumbnail + '"></li>';
        }
        ulHtml += "</ul>";
        $resultUl.append(Z(ulHtml));
        
        fMaterial.totalPages = obj.result.totalPages;
        
        fMaterial.couldLoad = true;                               // 定义可加载列表
        if (fMaterial.page >= fMaterial.totalPages)               // 最后一页
        {
            $resultTip.show();
            fMaterial.couldLoad = false;                          // 定义不可加载列表
        }
        // 显示页数
        clientRect = Z("#image_result")[0].getBoundingClientRect();
        setWidth = Z("#image_result").parent().offsetWidth();
        if (fMaterial.page === 1) {
            $resultPage.css("width",setWidth).css("top",clientRect.top).css("left",clientRect.left)
                .children("span").html("1/" + fMaterial.totalPages);
        }
        // 去除加载框
        window.doQueryCatMaterialLoading.$dialog.remove();
        window.doQueryCatMaterialLoading.$shadow.remove();
        window.doQueryCatMaterialLoading = null;
    });
    ajax.setLoading(function(){
        window.doQueryCatMaterialLoading = Z.loading({target: $wrap.parent()[0], shadow: true});
        window.doQueryCatMaterialLoading.$shadow.css("left", 0).css("top", 0);
    });
    ajax.execute();
}

/** 上传图片转base64 **/
function doTransforImage(data)
{
    if (data.files && data.files[0]) 
    {//4.判断input标签的file是否存在
        var reader = new FileReader();//5.实例化一个FileReader()接口
        reader.readAsDataURL(data.files[0]);//6.通过readAsDataURL()方法读取文件，将图片内嵌在网页之中
         reader.onload = function(evt) 
         {//7.调用FileReader()的onload事件，当文件读取成功时，执行8
            Z("#qrcodeData").val(evt.target.result); 
        }
    }
}

/** 表格素材，切换列表显示 **/
function switchInsertTableType(index)
{
    Z("#tableInsertList > li:nth-child("+(index + 1)+")").show().siblings("li").hide();
}

/** 生成二维码 **/
function doCreateQrcode(form)
{
    var ajax = new Z.Ajax();
    ajax.setClassName("MediaPresenter");
    ajax.setMethodName("doCreateQrcode");
    ajax.addParam("qrcodeText", Z("#qrcodeText").val());
    ajax.addParam("showLogo", Z("#showLogo").val());
    ajax.addParam("qrcodeData", Z("#qrcodeData").val());
    ajax.setSuccess(function(){
        //var html = '<li onclick="addSvgCode("'+this.responseText+'");"><img src="'+this.responseText+'"></li>';
        //Z("#create_result ul").append(html);
        
        var obj = Z.J.toObject(this.responseText);
        var fileUrl = obj.fileUrl;
        var fileId = obj.fileId;
        
        newImage({source:fileUrl, type: 2, fileId: fileId});
        doRecordUpload('${mediaId}', fileId, 1);
    });
    ajax.setFailure(function(){Z.failure(this.responseText);});
    ajax.setLoading(document);
    ajax.execute();
}
/** 自动识别二维码 **/
function doAutoQrcode(data)
{
    if (data.files && data.files[0]) 
    {//4.判断input标签的file是否存在
        var reader = new FileReader();//5.实例化一个FileReader()接口
        reader.readAsDataURL(data.files[0]);//6.通过readAsDataURL()方法读取文件，将图片内嵌在网页之中
         reader.onload = function(evt) 
         {//7.调用FileReader()的onload事件，当文件读取成功时，执行8
            var ajax = new Z.Ajax();
            ajax.setClassName("MediaPresenter");
            ajax.setMethodName("doAutoQrcode");
            ajax.addParam("showLogo", data.value);
            ajax.addParam("qrcodeData", evt.target.result);
            ajax.setSuccess(function(){
                Z("#qrcodeText").val(this.responseText)
            });
            ajax.setFailure(function(){Z.failure(this.responseText);});
            ajax.setLoading(document);
            ajax.execute();
        }
    }
}

/** 标签右键菜单 **/
function tagMenuShow(event, svgId)
{
    Z.E.forbidden(event);
    var ajax = new Z.Ajax();
    ajax.setClassName("MediaPresenter");
    ajax.setMethodName("getMediaSvg");
    ajax.addParam(svgId);
    ajax.setFailure(function(){Z.failure(this.responseText);});
    ajax.setSuccess(function(){
        var mediaSvg = Z.J.toObject(this.responseText);
        var keywords = mediaSvg.keywords;
        createContextMenu({
            "event": event,
            "elemId": "tagEditMenu",
            "editItem": [
                ["修改标签","editTagStart(this)"],
            ],
            "showItem": [
                keywords,
            ],
        });
        Z("#tagEditMenu ul:nth-child(1)>li:first-child").attr("data-id",svgId);
        Z("#tagEditMenu ul:nth-child(1)>li:first-child").attr("data-keyword",keywords);
        Z("#tagEditMenu ul:nth-child(2)>li:first-child").html(keywords);
    });
    ajax.execute();
}

/***** 右键菜单操作事件 *********/
/** 右键-标签修改 **/
function editTagStart(elem)
{
    Z("#tagContentMenu").hide();
    var svgId = Z(elem).attr("data-id");
    var keywords = Z(elem).attr("data-keyword");
    Z.prompt("修改标签", keywords, function(value) {
        var ajax = new Z.Ajax();
        ajax.setClassName("MediaPresenter");
        ajax.setMethodName("doAddMaterialKeywords");
        ajax.addParam("svgId", svgId);
        ajax.addParam("keywords", value);
        ajax.execute();
    });
}
/** 右键-素材复制 **/
function contextMenuCopy()
{
    var ev = new Event("copy");
    document.dispatchEvent(ev);
}
/** 右键-素材粘贴 **/
function contextMenuPaste()
{
    var ev = new Event("paste");
    document.dispatchEvent(ev);
}

/** 切换工具栏 **/
function doChangeToolbar(ele, sidebarType)
{
    Z(ele).addClass("active").siblings("li").removeClass("active");
}

/*** 表格的右键菜单 ***/
// 顶部插入行
function insertTableRowTop()
{
    insertTableRow("top");
}
// 底部插入行
function insertTableRowBottom()
{
    insertTableRow("bottom");
}
// 表格操作：插入行操作
function insertTableRow(insertType)
{
    // 1：基础变量定义
    var $activeElm = document.activeElement;
    if (!$activeElm.className.includes("tableText-editArea"))
        return;
    if (insertType !== "top" && insertType !== "bottom")
        return;
    var $editor = Z("#tableEditor");
    var $table = $editor.find("table");
    var selData = $editor[0].selectionTdData;
       
    var $tdActive = $activeElm.parentElement;
    var rowMin = 0, rowMax = 0, tdRowNum = 1;
    if (Z($tdActive).hasClass("selected") && !!selData){
        rowMin = selData.rowMin;
        rowMax = selData.rowMax;
        tdRowNum = selData.tdRowNum;
    } else {
        rowMin = parseFloat($tdActive.getAttribute("data-row"));
        rowMax = rowMin;
    }

    // 2：表格样式调整
    var $trNew = document.createElement("tr");
    var baseRow = insertType === "top" ? rowMin : rowMax;
    var $trBase = $table.find('td[data-row="'+ baseRow +'"]').parent()[0];
    $table.find("td.selected").removeClass("selected");
    var tableHeight = parseFloat($table.css("height"));
    tableHeight += $trBase.offsetHeight * tdRowNum;
    $table.css("height", tableHeight);

    // 3：得到新节点：$trNew
    var $trClone = $trBase.cloneNode(true);
    var $tdLast = $trClone.querySelector("td:last-child");
    var tdColMax = parseFloat($tdLast.getAttribute("data-col")) + $tdLast.colSpan - 1;
    var queryStr = "", $tdNew = null, $trBasePrev = null, $tdBase = null;
    for (var i = 1; i <= tdColMax; i++)
    {
        queryStr = 'td[data-col="' + i + '"]';
        $tdNew = $trClone.querySelector(queryStr);
        if (!$tdNew)
        {
            $trBasePrev = $trBase.previousElementSibling;
            $tdBase = $trBasePrev.querySelector(queryStr);
            while (!$tdBase)
            {
                $trBasePrev = $trBasePrev.previousElementSibling;
                $tdBase = $trBasePrev.querySelector(queryStr);
            }
            $tdBase.rowSpan += tdRowNum;
            continue;
        }

        // 插入$tdNew
        $tdNew.rowSpan = 1;
        $tdNew.querySelector("div").innerHTML = "";
        $trNew.appendChild($tdNew);

        // 下一个 td 索引
        i += $tdNew.colSpan - 1;
    }

    // 4：插入tr节点
    var $trNewClone = null, $divFocus = null;
    var rowFix = 1, tdRowNumFix = tdRowNum;
    while(tdRowNumFix > 0)
    {
        $trNewClone = $trNew.cloneNode(true);
        $trNewClone.querySelector("div.tableText-showArea").innerHTML = "";
        $trNewClone.querySelector("div.tableText-editArea").innerHTML = "";
        if (insertType === "top")
        {
            // 校准 $trNewClone 属性 data-row
            $trNewClone.querySelectorAll("td").forEach(function($tdItem) {
                $tdItem.setAttribute("data-row", baseRow + rowFix - 1);
            });
            // 插入节点
            $trBase.insertAdjacentElement("beforebegin", $trNewClone);
            // 新焦点单元格
            if (rowFix === 1)
                $divFocus = $trNewClone.querySelector("div.tableText-editArea");
        }
        else
        {
            // 校准 $trNewClone 属性 data-row
            $trNewClone.querySelectorAll("td").forEach(function($tdItem) {
                $tdItem.setAttribute("data-row", baseRow + tdRowNumFix);
            });
            // 插入节点
            $trBase.insertAdjacentElement("afterend", $trNewClone);
            // 新焦点单元格
            if (tdRowNumFix === 1)
                $divFocus = $trNewClone.querySelector("div.tableText-editArea");
        }
        // 事件绑定
        $trNewClone.querySelectorAll("td").forEach(mediaEvent.tableTextAreaEventAdd);
        rowFix++;
        tdRowNumFix--;
    }

    // 5：校准所有单元格属性 data-row
    var $trRow = $trNewClone.nextElementSibling;
    while ($trRow)
    {
        $trRow.querySelectorAll("td").forEach(function($td){
            $td.setAttribute("data-row", tdRowNum + parseFloat($td.getAttribute("data-row")));
        });
        $trRow = $trRow.nextElementSibling;
    }

    // 6：获取焦点
    $divFocus && $divFocus.focus();
}
// 左侧插入列
function insertTableColLeft()
{
    insertTableCol("left");
}
// 右侧插入列
function insertTableColRight()
{
    insertTableCol("right");
}
// 表格操作：插入列操作
function insertTableCol(insertType)
{
    // 1：基础变量定义
    var $activeElm = document.activeElement;
    if (!$activeElm.className.includes("tableText-editArea"))
        return;
    if (insertType !== "left" && insertType !== "right")
        return;
    var $editor = Z("#tableEditor");
    var $table = $editor.find("table");
    var $$trAll = $table[0].querySelectorAll("tr");
    var selData = $editor[0].selectionTdData;
    var $tdActive = $activeElm.parentElement;
    var colMin = 0, colMax = 0, tdColNum = 1;
    if (Z($tdActive).hasClass("selected") && !!selData)
    {
        colMin = selData.colMin;
        colMax = selData.colMax;
        tdColNum = selData.tdColNum;
    }
    else
    {
        colMin = parseFloat($tdActive.getAttribute("data-col"));
        colMax = colMin;
    }

    // 2：表格样式调整
    var baseCol = insertType === "left" ? colMin : colMax;
    var $tdBase = $table.find('td[data-row="'+ baseCol +'"]')[0];
    var tableWidth = parseFloat($table.css("width")) + parseFloat($tdBase.style.width);
    $table.css("width", tableWidth);
    $table.find("td.selected").removeClass("selected");

    var tdWidthMin = 0;
    $$trAll.forEach(function($trItem)
    {
        var findCol = baseCol;
        var $tdBase = $trItem.querySelector('td[data-col="' + findCol + '"]');

        // 1：属于合并的单元格，不需要插入
        if (!$tdBase)
        {
            findCol--;
            while (!$tdBase && findCol > 0)
                $tdBase = $trItem.querySelector('td[data-col="' + findCol-- + '"]');
            $tdBase.colSpan += tdColNum;
            return;
        }

        // 2：指定位置插入 td
        var tdColNumFix = tdColNum;
        while(tdColNumFix > 0)
        {
            var $tdNew = $tdBase.cloneNode(true);
            $tdNew.colSpan = 1;
            $tdNew.querySelector("div.tableText-showArea").innerHTML = "";
            $tdNew.querySelector("div.tableText-editArea").innerHTML = "";
            if (insertType === "left")
            {
                // 校准 data-col
                $tdNew.setAttribute("data-col", findCol + tdColNumFix - 1);
                // 执行插入
                $tdBase.insertAdjacentElement("beforebegin", $tdNew);
            }
            else
            {
                // 校准 data-col
                $tdNew.setAttribute("data-col", findCol + tdColNumFix);
                // 执行插入
                $tdBase.insertAdjacentElement("afterend", $tdNew);
            }
            var tdNewWidth = $tdBase.offsetWidth;
            if (!tdWidthMin)
                tdWidthMin = tdNewWidth;
            tdWidthMin = getMinNum([tdWidthMin, tdNewWidth]);

            // 3：校准 data-col
            if (insertType === "left")
                $tdNew.setAttribute("data-col", findCol);
            findCol++;
            $tdBase.setAttribute("data-col", findCol);
            var $tdNext = $tdBase.nextElementSibling;
            while($tdNext)
            {
                findCol++;
                $tdNext.setAttribute("data-col", findCol);
                $tdNext = $tdNext.nextElementSibling;
            }
            tdColNumFix--;
        }
        // 事件绑定
        mediaEvent.tableTextAreaEventAdd($tdNew);
    });
}
// 合并单元格
function mergeTableTd()
{
    // 1：基础变量定义
    var $activeElm = document.activeElement;
    if (!$activeElm.className.includes("tableText-editArea"))
        return;
    var $editor = Z("#tableEditor");
    var selData = $editor[0].selectionTdData;
    
    var $tdActive = $activeElm.parentElement;
   
    if (!$tdActive.className.includes("selected") || !selData)//includes() 方法用来判断一个数组是否包含一个指定的值，如果是返回 true，否则false
        return;
    var tdSelectedList = selData.tdList;
    var i = 0, $td = null, $tr = null, $editDiv = null, $tdMerged = null, tdText = "",
        tdRow = 1, tdCol = 1, baseRow = 1, baseCol = 1, setWidth = 0, setHeight = 0;
    for (i;i < tdSelectedList.length;i++)
    {
        $td = tdSelectedList[i];
        tdRow = $td.getAttribute("data-row");
        tdCol = $td.getAttribute("data-col");
        $editDiv = $td.querySelector(".tableText-editArea");
        tdText += $td.querySelector(".tableText-showArea").innerText;
        if (i !== 0)
        {
            if (tdRow === baseRow)
                setWidth += parseFloat($editDiv.style.width) + parseFloat($td.style.borderLeftWidth);
            if (tdCol === baseCol)
                setHeight += parseFloat($editDiv.style.height) + parseFloat($td.style.borderTopWidth);
              $tr = $td.parentElement;//返回父级元素tr
              
              $tr.removeChild($td);//移除td
              //if(!$tr.querySelector("td")){//此处注释掉是因为合并单元格的合并上浮的问题                    tr下的单元格取反 为假 ' ' 
               
              // $tr.parentElement.removeChild($tr); //tr的父级    table
                
            // }
            
                             
            continue;
        } 
       
        $tdMerged = $td;
        baseRow = tdRow;
        baseCol = tdCol;
        setWidth += parseFloat($editDiv.style.width);
        setHeight += parseFloat($editDiv.style.height);
    }
    var $divShow = $tdMerged.querySelector(".tableText-showArea");
    var $divEdit = $tdMerged.querySelector(".tableText-editArea");
    $tdMerged.rowSpan = selData.rowSpanNum;
    $tdMerged.colSpan = selData.colSpanNum;
    $divEdit.style.width = setWidth + "px";
    $divEdit.style.height = setHeight + "px";
    tdText = tdText.split("\n").join("<br>");
    
    $divShow.innerHTML = tdText;
    $divEdit.innerHTML = tdText; 
}
// 取消合并单元格
function unMergeTableTd()
{
    var doResolveTd = function ($td)
    {
        var getNewTd = function (mxRow, mxCol)
        {
            if (!splitHeight[mxRow] || !splitWidth[mxCol])
                return null;
            // 克隆节点
            var $tdClone = $td.cloneNode(true);
            $tdClone.rowSpan = 1;
            $tdClone.colSpan = 1;
            $tdClone.setAttribute("data-row", $tdClone.getAttribute("data-row")*1 + mxRow);
            $tdClone.setAttribute("data-col", $tdClone.getAttribute("data-col")*1 + mxCol);
            var $editDiv = $tdClone.querySelector(".tableText-editArea");
            $editDiv.style.height = splitHeight[mxRow] + "px";
            $editDiv.style.width = splitWidth[mxCol] + "px";
            $editDiv.innerHTML = "";
            $tdClone.querySelector(".tableText-showArea").innerHTML = "";
            return $tdClone;
        };
        var $tr = $td.parentElement;
        var tdRowSpan = $td.rowSpan;
        var tdColSpan = $td.colSpan;
        var tdRow = parseFloat($td.getAttribute("data-row"));
        var tdCol = parseFloat($td.getAttribute("data-col"));
        var $editDiv = $td.querySelector(".tableText-editArea");
        var fullWidth = parseFloat($editDiv.style.width);
        var fullHeight = parseFloat($editDiv.style.height);

        var $$tdNewList = [], widthNew = 0, heightNew = 0;
        var $tdNextCol = null, $editDivNextCol = null, $tdNextRow = null, $editDivNextRow = null,
            $trNextRow = null, $tdNextRowCol = null, $tdCloneTemp = null;

        // 计算每列宽度
        var splitWidth = [];
        var prevLeft = $td.offsetLeft;
        var numOverCol = 1, numOverCol2 = 1, setWidth = 0;
        for (i = 1;i <= tdColSpan;i++)
        {
            $tdNextCol = $table.querySelector('td[data-col="' + (tdCol + i) + '"]');
            numOverCol2 = 1;
            if (!$tdNextCol)
            {
                if (i === tdColSpan)
                {
                    setWidth = 0;
                    splitWidth.forEach(width => setWidth += width + borderWidth);
                    setWidth = (fullWidth - setWidth) / numOverCol;
                    numOverCol2 = numOverCol + 1;
                }
                numOverCol++;
            }
            else
            {
                setWidth = ($tdNextCol.offsetLeft - prevLeft - numOverCol * borderWidth) / numOverCol;
                numOverCol2 = numOverCol + 1;
                prevLeft = $tdNextCol.offsetLeft;
            }
            while (numOverCol2 > 1)
            {
                numOverCol2--;
                splitWidth.push(setWidth);
            }
        }

        // 计算每行高度
        var splitHeight = [];
        var prevTop = $td.offsetTop;
        var numOverRow = 1, numOverRow2 = 1, setHeight = 0;
        for (i = 1;i <= tdRowSpan;i++)
        {
            $tdNextRow = $table.querySelector('td[data-row="' + (tdRow + i) + '"]');
            numOverRow2 = 1;
            if (!$tdNextRow)
            {
                if (i === tdRowSpan)
                {
                    setHeight = 0;
                    splitHeight.forEach(height => setHeight += height + borderWidth);
                    setHeight = (fullHeight - setHeight + borderWidth) / numOverRow;
                    numOverRow2 = numOverRow + 1;
                }
                numOverRow++;
            }
            else
            {
                setHeight = ($tdNextRow.offsetTop - prevTop - numOverRow * borderWidth) / numOverRow;
                numOverRow2 = numOverRow + 1;
                prevTop = $tdNextRow.offsetTop;
            }
            while (numOverRow2 > 1)
            {
                numOverRow2--;
                splitHeight.push(setHeight);
            }
        }

        // 当前的单元格设置
        $td.rowSpan = 1;
        $td.colSpan = 1;
        Z($td).find(".tableText-editArea").css({
            "width": splitWidth[0],
            "height": splitHeight[0]
        });

        // 插入新单元格
        var j = 0, $tempTd = $td, $tempTr = $tr, tdCol2 = tdCol, $tdClone = null;
        for (i = 0; i < tdRowSpan;i++)
        {
            // 克隆节点
            $tdClone = getNewTd(i, 0);
            // 查找并插入该行的第一个单元格
            $tdNextRow = $table.querySelector('td[data-row="' + (tdRow + i) + '"]');
            if ($tdNextRow)
            {
                $trNextRow = $tdNextRow.parentElement;
                $tempTd = $trNextRow.querySelector('td[data-col="' + tdCol + '"]');
                if (!$tempTd)
                {
                    tdCol2 = tdCol;
                    // 查找兄弟节点，并插入节点
                    while (!$tempTd && tdCol2 > 0)
                    {
                        tdCol2--;
                        $tempTd = $trNextRow.querySelector('td[data-col="' + tdCol2 + '"]');
                    }
                    if (!$tempTd)
                    {
                        tdCol2 = tdCol;
                        while (!$tempTd && tdCol2 < colMax)
                        {
                            tdCol2++;
                            $tempTd = $trNextRow.querySelector('td[data-col="' + tdCol2 + '"]');
                        }
                        $tempTd.insertAdjacentElement("beforebegin", $tdClone);
                    }
                    else
                    {
                        $tempTd.insertAdjacentElement("afterend", $tdClone);
                    }
                    $tempTd = $tdClone;
                    mediaEvent.tableTextAreaEventAdd($tempTd);
                }
            }
            else
            {
                $trNextRow = document.createElement("tr");
                $trNextRow.appendChild($tdClone);
                $tempTr.insertAdjacentElement("afterend", $trNextRow);
                $tempTd = $tdClone;
                mediaEvent.tableTextAreaEventAdd($tempTd);
            }
            $tempTr = $tempTd.parentElement;
            // 该行的合并单元格
            for (j = 1;j <= tdColSpan;j++)
            {
                // 克隆节点
                $tdClone = getNewTd(i, j);
                if (!$tdClone)
                    continue;
                // 插入单元格
                $tempTd.insertAdjacentElement("afterend", $tdClone);//方法将一个给定的元素节点插入到相对于被调用的元素的给定的
                $tempTd = $tdClone;
                mediaEvent.tableTextAreaEventAdd($tempTd);
            }
        }
    };

    // 1：基础变量定义
    var $activeElm = document.activeElement;
    if (!$activeElm.className.includes("tableText-editArea"))
        return;
    var $tdActive = $activeElm.parentElement;
    var $editor = Z.D.id("tableEditor");
    var $table = $editor.querySelector("table");
    var selData = $editor.selectionTdData || {};
    var tdSelectedList = selData.tdList || [$tdActive];
    var $tdLast = $table.querySelector("tr:last-child>td:last-child");
    var borderWidth = parseFloat($tdLast.style.borderLeftWidth);
    var rowMax = parseFloat($tdLast.getAttribute("data-row")) + $tdLast.rowSpan - 1;
    var colMax = parseFloat($tdLast.getAttribute("data-col")) + $tdLast.colSpan - 1;

    var i = 0, $td = null;
    for (i;i < tdSelectedList.length;i++)
    {
        $td = tdSelectedList[i];
        if ($td.rowSpan === 1 && $td.colSpan === 1)
            continue;
        // 执行拆分单元格
        doResolveTd($td);
    }
}
// 删除行
function deleteTableRow()
{
    // 计算跨行高度
    var getHeightCrossRow = function(rowFindStart, rowFindEnd)
    {
        var heightCross = 0, $$tdTemp = null, tdRowLength = 0, i = 0, $tdItem = null, rowStartTemp = 1;
        while (!heightCross && rowFindStart <= rowFindEnd)
        {
            $$tdTemp = $table.find('td[data-row="' + rowFindStart + '"]');
            tdRowLength = $$tdTemp.length;
            var findDone = false;
            for (i;i < tdRowLength;i++)
            {
                $tdItem = $$tdTemp[i];
                rowStartTemp = rowFindStart + $tdItem.rowSpan - 1;
                if (rowStartTemp > rowFindEnd)
                    continue;
                heightCross += $tdItem.offsetHeight;
                if (rowStartTemp === rowFindEnd){
                    findDone = true;
                    break;
                }
                heightCross += getHeightCrossRow(rowStartTemp, rowFindEnd);
            }
            heightCross = findDone && heightCross || 0;
            rowFindStart++;
        }
        return heightCross;
    };
    var setTdHeight = function(rowEnd, tdRowPass)
    {
        // 获取高度
        var setHeight = getHeightCrossRow(rowEnd, tdRowPass);
        setHeight = $td[0].offsetHeight - setHeight
            - parseFloat($td[0].style.borderTopWidth || 0) - parseFloat($td[0].style.borderBottomWidth || 0);
        // 设置高度
        Z($td).children(".tableText-editArea").css("minHeight", setHeight);
        var viewHeight = Z($td).children(".tableText-showArea").offsetHeight;
        if (viewHeight > setHeight)
            Z($td).children(".tableText-editArea").css("minHeight", viewHeight);
    };

    // 1：基础变量定义
    var $activeElm = document.activeElement;
    if (!$activeElm.className.includes("tableText-editArea"))
        return;
    var $editor = Z("#tableEditor");
    var $table = $editor.find("table");
    var selData = $editor[0].selectionTdData || {};
    var $tdActive = $activeElm.parentElement;
    var tdSelectedList = selData.tdList || [$tdActive],
        rowSpanNum = selData.rowSpanNum || $tdActive.rowSpan;
    var rowStart = parseFloat(tdSelectedList[0].getAttribute("data-row"));
    var rowEnd = rowStart + rowSpanNum - 1;
    var $tdLast = $editor.find("tr:last-child>td:last-child");
    var rowLast = $tdLast.attr("data-row") * 1 + $tdLast[0].rowSpan - 1;
    var colLast = $tdLast.attr("data-col") * 1 + $tdLast[0].colSpan - 1;

    // 2：计算删除后，获取焦点的td：$tdFocus
    var $tdFocus = null, rowFind = rowStart;
    if (rowFind > 1)
    {
        while (!$tdFocus && rowFind > 0)
        {
            rowFind--;
            $tdFocus = $table.find('td[data-row="' + rowFind + '"]');
        }
    }
    if (!$tdFocus || !$tdFocus[0])
    {
        rowFind = rowEnd;
        while (!$tdFocus && rowFind <= rowLast)
        {
            rowFind++;
            $tdFocus = $table.find('td[data-row="' + rowFind + '"]');
        }
    }
    if (!$tdFocus || !$tdFocus[0])
    {// 删除表格、素材
        mediaEvent.tableSelectionHide(true);
        mediaEvent.cancelTableElemEdit();
        deleteMaterial();
        return;
    } else
        $tdFocus[0].querySelector("div.tableText-editArea").focus();

    var i = 1, j = 1, $tr = null, $td = null, $tdNextRowCol = null, $trNextRowCol = null, $tdTemp = null,
        tdRow = 1, tdCol = 1, tdRowSpan = 1, tdColSpan = 1, tdColTemp = 1,tdRowPass = 1, tdColPass = 1, heightCross = 0;
    for (i;i <= rowLast;i++)
    {
        $td = $table.find('td[data-row="' + i + '"]');
        $tr = $td[0] && $td.parent() || null;
        if (!$tr)
            continue;
        for (j = 1;j <= colLast;j++)
        {
            $td = $tr.find('td[data-col="' + j + '"]');
            if (!$td[0])
                continue;
            tdRow = $td.attr("data-row")*1;
            tdCol = $td.attr("data-col")*1;
            tdRowSpan = $td[0].rowSpan;
            tdColSpan = $td[0].colSpan;
            tdRowPass = tdRow + tdRowSpan - 1;
            tdColPass = tdCol + tdColSpan - 1;
            if (tdRowPass < rowStart || tdRow > rowEnd)
                continue;
            if (tdRow >= rowStart && tdRowPass <= rowEnd)
                continue;
            if (tdRow < rowStart && tdRowPass <= rowEnd)
            {
                // 高度设置：offsetHeight - (rowStart 到 tdRowPass 的高度)
                setTdHeight(rowStart, tdRowPass);
                $td[0].rowSpan = rowStart - tdRow;
            }
            if (tdRow < rowStart && tdRowPass > rowEnd)
            {
                // 高度设置：offsetHeight - (rowStart 到 rowEnd 的高度)
                setTdHeight(rowStart, rowEnd);
                $td[0].rowSpan = tdRowSpan - rowSpanNum;
            }
            if (tdRow >= rowStart && tdRowPass > rowEnd)
            {
                // 高度设置：offsetHeight - (tdRow 到 tdRowPass 的高度)
                setTdHeight(tdRow, rowEnd);
                // 克隆新单元格
                $tdTemp = $td[0].cloneNode(true);
                $tdTemp.rowSpan = tdRowPass - rowEnd;
                $tdTemp.setAttribute("data-row", rowEnd + 1);
                $tdTemp.querySelector(".tableText-editArea").innerHTML = "";
                $tdTemp.querySelector(".tableText-showArea").innerHTML = "";
                // 查找同行单元格，执行插入
                tdColTemp = tdCol;
                $trNextRowCol = $table.find('td[data-row="' + (rowEnd + 1) + '"]').parent();
                $tdNextRowCol = $trNextRowCol.find('td[data-col="' + (tdColTemp + 1) + '"]');
                if ($tdNextRowCol[0])
                    $tdNextRowCol[0].insertAdjacentElement("beforebegin", $tdTemp);
                else
                {
                    while (!$tdNextRowCol[0] && tdColTemp > 1)
                    {
                        tdColTemp--;
                        $tdNextRowCol = $trNextRowCol.find('td[data-col="' + tdColTemp + '"]');
                    }
                    $tdNextRowCol[0].insertAdjacentElement("afterend", $tdTemp);
                }
            }
        }
        if (i >= rowStart && i <= rowEnd)
            $tr.remove();
    }

    // 3：校准 data-row
    var $trActive = $tdFocus.parent();
    var $trNext = $trActive[0];
    if ($tdFocus.attr("data-row")*1 === rowStart - 1)
        $trNext = $trNext.nextElementSibling;
    while($trNext)
    {
        $trNext.querySelectorAll("td").forEach(function($tdItem){
            Z($tdItem).attr("data-row", Z($tdItem).attr("data-row") - (rowEnd - rowStart + 1));
        });
        $trNext = $trNext.nextElementSibling;
    }
}
// 删除列
function deleteTableCol()
{
    // 计算跨列宽度
    var getWidthCrossCol = function(colFindStart, colFindEnd)
    {
        var widthCross = 0, $$tdTemp = null, tdColLength = 0, i = 0, $tdItem = null, rowStartTemp = 1;
        while (!widthCross && colFindStart <= colFindEnd)
        {
            $$tdTemp = $table.find('td[data-col="' + colFindStart + '"]');
            tdColLength = $$tdTemp.length;
            var findDone = false;
            for (i;i < tdColLength;i++)
            {
                $tdItem = $$tdTemp[i];
                rowStartTemp = colFindStart + $tdItem.colSpan - 1;
                if (rowStartTemp > colFindEnd)
                    continue;
                widthCross += $tdItem.offsetWidth;
                if (rowStartTemp === colFindEnd){
                    findDone = true;
                    break;
                }
                widthCross += getWidthCrossCol(rowStartTemp, colFindEnd);
            }
            widthCross = findDone && widthCross || 0;
            colFindStart++;
        }
        return widthCross;
    };
    var setTdWidth = function(colFindStart, colFindEnd)
    {
        // 取得宽度
        var setWidth = getWidthCrossCol(colFindStart, colFindEnd);
        setWidth = $td[0].offsetWidth - setWidth
        - parseFloat($td[0].style.borderLeftWidth || 0) - parseFloat($td[0].style.borderRightWidth || 0);
        // 设置宽度
        Z($td).children().css("width", setWidth);
        var viewWidth = Z($td).children(".tableText-showArea").offsetWidth;
        if (viewWidth > setWidth)
            Z($td).children("div").css("width", viewWidth);
    };

    // 1：基础变量定义
    var $activeElm = document.activeElement;
    if (!$activeElm.className.includes("tableText-editArea"))
        return;
    var $editor = Z("#tableEditor");
    var $table = $editor.find("table");
    var selData = $editor[0].selectionTdData || {};
    var $tdActive = $activeElm.parentElement;
    var colSpanNum = selData.colSpanNum || $tdActive.colSpan;
    var colStart = parseFloat($tdActive.getAttribute("data-col"));
    var colEnd = colStart + colSpanNum - 1;
    var $tdLast = $editor.find("tr:last-child>td:last-child");
    var rowLast = $tdLast.attr("data-row") * 1 + $tdLast[0].rowSpan - 1;
    var colLast = $tdLast.attr("data-col") * 1 + $tdLast[0].colSpan - 1;

    // 2：计算删除后，获取焦点的td：$tdFocus
    var $tdFocus = null, colFind = colStart;
    if (colFind > 1)
    {
        while (!$tdFocus && colFind > 0)
        {
            colFind--;
            $tdFocus = $table.find('td[data-col="' + colFind + '"]');
        }
    }
    if (!$tdFocus || !$tdFocus[0])
    {
        colFind = colEnd;
        while (!$tdFocus && colFind <= colLast)
        {
            colFind++;
            $tdFocus = $table.find('td[data-col="' + colFind + '"]');
        }
    }
    if (!$tdFocus || !$tdFocus[0])
    {// 删除表格、素材
        mediaEvent.tableSelectionHide(true);
        mediaEvent.cancelTableElemEdit();
        deleteMaterial();
        return;
    } else
        $tdFocus[0].querySelector("div.tableText-editArea").focus();

    var i = 1, j = 1, $tr = null, $td = null, $tdTemp = null, tdRow = 1, tdCol = 1,
        tdRowSpan = 1, tdColSpan = 1, tdColTemp = 1, tdRowPass = 1, tdColPass = 1, widthCross = 0;
    for (i;i <= rowLast;i++)
    {
        $td = $table.find('td[data-row="' + i + '"]');
        $tr = $td[0] && $td.parent() || null;
        if (!$tr)
            continue;
        for (j = 1;j <= colLast;j++)
        {
            $td = $tr.find('td[data-col="' + j + '"]');
            if (!$td[0])
                continue;
            tdRow = $td.attr("data-row")*1;
            tdCol = $td.attr("data-col")*1;
            tdRowSpan = $td[0].rowSpan;
            tdColSpan = $td[0].colSpan;
            tdRowPass = tdRow + tdRowSpan - 1;
            tdColPass = tdCol + tdColSpan - 1;
            if (tdColPass < colStart || tdCol > colEnd)
                continue;
            if (tdCol < colStart && tdColPass <= colEnd)
            {
                // 宽度设置：获取 colStart 到 tdColPass 的宽度
                setTdWidth(colStart, tdColPass);
                $td[0].colSpan = colStart - tdCol;
            }
            if (tdCol < colStart && tdColPass > colEnd)
            {
                // 宽度设置：获取 colStart 到 colEnd 的宽度
                setTdWidth(colStart, colEnd);
                $td[0].colSpan = tdColSpan - colSpanNum;
            }
            if (tdCol >= colStart && tdColPass > colEnd)
            {
                // 宽度设置：获取 tdCol 到 colEnd 的宽度
                setTdWidth(tdCol, colEnd);
                // 克隆新单元格
                $tdTemp = $td[0].cloneNode(true);
                $tdTemp.colSpan = tdColPass - colEnd;
                // $tdTemp.setAttribute("data-col", colEnd + 1);
                $tdTemp.querySelector(".tableText-editArea").innerHTML = "";
                $tdTemp.querySelector(".tableText-showArea").innerHTML = "";
                tdColTemp = tdCol;
                // 查找同行单元格，执行插入
                $td[0].insertAdjacentElement("afterend", $tdTemp);
            }
            if (tdCol >= colStart && tdCol <= colEnd)
                $td.remove();
        }
    }

    // 校准 data-col
    while (colEnd <= colLast)
    {
        $tdTemp = $table.find('td[data-col="' + colEnd + '"]');
        if ($tdTemp[0])
            $tdTemp.each(function($tdItem){
                Z($tdItem).attr("data-col", Z($tdItem).attr("data-col")*1 - colSpanNum);
            });
        colEnd++;
    }
}

/********** 收藏列表 *********/
/** 切换列表 **/
function doChangeCollectionList(typeId)
{
    var ajax = new Z.Ajax();
    ajax.setClassName("");
    ajax.setMethodName("");
    ajax.setSuccess();
    ajax.setLoading("image_result");
    // ajax.execute();
}
/** 添加至我的素材 **/
function addToCollectionList()
{
    // 显示输入弹窗
    function showInputDialog()
    {
        var dialogTitle = '添加至我的素材';
        var dialogId = 'dialog_' + Z.Ids.uuid();
        var htmlStr = '<div id="' + dialogId + '" class="z-pd15 z-text-center" data-typeCode="' + typeCode + '" data-catCode="' + catCode + '">' +
            '<div class="z-mg-t15 z-mg-b10"><span class="z-show-ib z-w80 z-text-left">关键字：</span><input class="z-input z-w200 input-keyword" type="text" value="" placeholder="填入素材关键字"></div>';
        if (doSelect)
        {
            htmlStr += '<' + 'div class="z-mg-t15 z-mg-b10"><span class="z-show-ib z-w80 z-text-left">素材分类：</span><select class="z-select z-w200 select-catCode">';
            var theCatLength = theCatList.length;
            var i, theCat;
            for (i = 0;i < theCatLength;i++)
            {
                theCat = theCatList[i];
                htmlStr += '<option value="' + theCat.catCode + '"';
                if (i === 0) htmlStr += ' selected';
                htmlStr += '>' + theCat.catName + '</option>';
            }
            htmlStr += '</select></div>';
        }
        htmlStr += '<div class="z-pd-t10 z-text-right">' +
            '<div class="z-button zi-px14 zi-pd0 zi-w80 zi-h35 zi-lh35 z-blue z-mg-r15" onclick="doAddCollectionList(\'' + dialogId + '\');">确定</div>' +
            '<div class="z-button zi-px14 zi-pd0 zi-w80 zi-h35 zi-lh35" onclick="Z.Dialog.close();">取消</div>' +
            '</div></div>';
        Z.dialog({ title: dialogTitle, text: htmlStr, width: 460, height: doSelect ? 177 : 132});

        // 赋值到dialog
        var $dialog = Z.D.id(dialogId);
        $dialog.svgCodeString = svgCode;
    }
    // 获取类型和分类：typeCode、catCode
    function getTypeCode()
    {
        if (selectedLength === 1)
        {
            // 图片、二维码
            if (material.type === 0 || material.type === 2)
            {
                if (material.type === 0){
                    typeCode = 'qcode';
                    catCode = 'qcode';
                }
                if (material.type === 1){
                    typeCode = 'image';
                    catCode = 'image';
                }
                svgType = 'image';
            }
            // 文字
            if (material.type === 1)
            {
                typeCode = 'text';
                catCode = 'text';
                svgType = 'text';
            }
            // 通常 svg
            if (material.type === 3)
            {
                typeCode = 'image';
                doSelect = true;
                svgType = 'svg';
            }
            // 容器
            if (material.type === 4)
            {
                typeCode = 'image';
                catCode = 'container';
                svgType = 'container';
            }
            // 形状
            if (material.type === 5)
            {
                typeCode = 'image';
                catCode = 'shape';
                svgType = media.tool.getCurSvgElement().querySelector('svg').getAttribute('data-type');
            }
        }
        else
        {
            typeCode = 'image';
            doSelect = true;
            svgType = 'group';
        }

        if (!doSelect)
            return;
        // 获取对应类型下，所有的分类
        var allLength = allMaterialCatList.length;
        var i, theObj;
        for(i=0;i < allLength;i++)
        {
            theObj = allMaterialCatList[i];
            if(theObj.typeCode !== typeCode)
                continue;
            theCatList.push({
                'catName': theObj.catName,
                'catCode': theObj.catCode,
            });
        }
    }
    // 获取计算素材的源码
    function getSvgCode()
    {
        // 1：定义变量，新增$svg
        var canvasRect = media.tool.$canvasSvg.getBoundingClientRect();
        var $svg = document.createElementNS(xmlns, "svg");
        var showRatio = media.tool.showRatio;
        var svgString = '';
        var i, $curElem, targetRect, setViewBox, viewLeft, viewTop, viewWidth, viewHeight;
        $svg.setAttribute("xmlns", xmlns);
        $svg.setAttribute("preserveAspectRatio", "none");
        $svg.setAttribute("data-type", svgType);

        // 2：获取 targetRect、svgString
        if (selectedLength === 1) {
            $curElem = media.tool.getCurSvgElement();
            targetRect = $curElem.getBoundingClientRect();
        }
        else {
            targetRect = Z.D.id('selection_tool').getBoundingClientRect();
        }
        for (i = 0;i < selectedLength;i++)
        {
            $curElem = media.tool.getCurSvgElement(i);
            svgString += $curElem.outerHTML.replace(/data\-groupid\s?=\s?"[^"]+"/, '');
        }

        // 3：设置 $svg 属性
        viewLeft = (targetRect.left - canvasRect.left) / showRatio;
        viewTop = (targetRect.top - canvasRect.top) / showRatio;
        viewWidth = targetRect.width / showRatio;
        viewHeight = targetRect.height / showRatio;
        setViewBox = viewLeft + ' ' + viewTop + ' ' + viewWidth + ' ' + viewHeight;
        $svg.setAttribute('viewBox', setViewBox);
        $svg.setAttribute('width', viewWidth);
        $svg.setAttribute('height', viewHeight);

        // 4：取得 svgCode
        $svg.innerHTML = svgString;
        var $$gInner = $svg.children;
        var $gInner;
        for (i = 0;i < $$gInner.length;i++){
            $gInner = $$gInner[i];
            $gInner.removeChild($gInner.querySelector('rect'));
        }
        svgCode = $svg.outerHTML;
        svgCode = svgCode.replace(/\n/g,'').replace(/\s\s/g,' ');
    }

    // 1：定义变量
    var selectedLength = media.selectedList.length;
    if (selectedLength === 0)
        return;
    var typeCode, svgCode, svgType;
    var catCode = '';
    var doSelect = false;
    var material = media.getCurMaterial();
    var theCatList = [];

    // 2：获取类型和分类
    getTypeCode();

    // 3：获取素材源码
    getSvgCode();

    // 4：显示输入弹窗
    showInputDialog();
}
// 实现添加
function doAddCollectionList(dialogId)
{
    // 1：定义变量
    var $dialog = Z.D.id(dialogId);
    var typeCode = $dialog.getAttribute('data-typeCode');
    var catCode = $dialog.getAttribute('data-catCode');
    var $catCodeSelect = $dialog.querySelector('.select-catCode');
    if ($catCodeSelect)
        catCode = $catCodeSelect.value;
    var keyword = $dialog.querySelector('.input-keyword').value;
    var svgCode = $dialog.svgCodeString;
    
    if(typeof doAddUserMaterial === "function")
    {
        doAddUserMaterial(typeCode, catCode, keyword, svgCode);
    }
    
    // 2：关闭弹窗
    Z.Dialog.close();
}

/********** 背景设置样式修改 *********/
function switchBgSetType($input)
{
    bgSetType = $input.checked;
}

/********************************************
 **************  参数修改部分 ***************
 ********************************************/
/** 参数显示、设置方法 **/
function paramStatusShow(ele)
{
    var hasActive = Z(ele).hasClass("active");
    var thisMid = Z(ele).attr("data-mid");
    var thisBid = Z(ele).attr("data-bid");
    
    //存在已设置素材，显示该素材
    if (thisMid != null && thisBid != null)
    {
        thisMid = parseInt(thisMid);
        thisBid = parseInt(thisBid);
        if (thisBid !== media.curPage) {
            doChangePage(Z.D.id("pageItem_" + thisBid), thisBid);
        }
        var targMaterial = media.getMaterialByMid(thisMid, thisBid);
        var $curElem = media.tool.getSvgElementByMid(thisMid);
        
        var isMatch = materialMatchType(targMaterial, ele);
        if (isMatch)
        {
            //素材选中
            selectTheElement(null, $curElem);
        }
        else
        {
            //隐藏编辑框
            hideEditSelected(true);
            //清除当前设置
            var $undoBtn = Z(ele).find(".paramList-btns>span:last-child")[0];
            undoPparamSetted($undoBtn);
        }
    }
    else
    {
        // 隐藏编辑框
        hideEditSelected(true);
    }
    
    //最后添加样式
    Z(ele).addClass("active").siblings("li").removeClass("active");
}
function materialMatchType(material, $li)
{
    var liType = Z($li).attr("data-type");
    if (!material || !liType) {
        return false;
    }
    var mType = parseInt(material.type);
    var isMatch;
    
    switch (mType){
    case 0:            //图片
        if (liType == 1) isMatch = true;
        break;
    case 1:            //文字
        if (liType == 0) isMatch = true;
        break;
    case 2:            //二维码
        if (liType == 2) isMatch = true;
        break;
    default:
        isMatch = false;
        break;
    }
    return isMatch;
}
/** 设置参数 **/
function doPparamSetted(elem, event)
{
    Z.E.forbidden(event);
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    if (!$curElem || !material) {
        Z.alert("请先选择需要设置的素材！")
        return;
    }
    if (media.selectedList.length > 1) {
        Z.alert("选中了多个素材！")
        return;
    }
    //新增
    var typeName=Z(elem).attr("data-name");
	var textId=material.$media.tool.tempElement.id;
	Z('#'+textId).attr('data-cardtype',typeName);
	
    var $thisLi = Z(elem).parent().parent();
    var thisType = parseInt(Z($thisLi).attr("data-type"));
    var mSpecial = parseInt(Z($curElem).attr("data-special"));
    if (mSpecial) {
        Z.confirm("此素材为特殊文字，确定设置参数？",function(){
            setSpecialParam(material, $curElem, $thisLi);
        });
        return;
    }
    else if (material.type === 3) {
        Z.alert("组合素材不支持设置参数！");
        return;
    }
    else if (material.type === 2 || material.type === 0) {
        if (thisType === 0) {
            Z.alert("图片素材不支持设置文字参数！");
            return;
        }
        if (thisType === 2 && material.type === 0) {
            Z.alert("二维码需用二维码添加方式添加！");
            return;
        }
    }
    else
    {
        if (thisType === 1) {
            Z.alert("文字素材不支持设置图片参数！");
            return;
        }
    }
    
    var $activLi = Z("#paramList>li.active");
    //当前素材是否存在已设置参数，
    if ($activLi[0]) {
        //且不为当前正要设置的参数；则移除；否则直接返回
        if ($activLi[0] != $thisLi[0]) {
            Z($activLi).removeAttr("data-mid").removeAttr("data-bid").removeClass("active");
            Z($activLi).find(".paramList-status").removeClass("setted");
        } else {
            return;
        }
    }
    
    var thisMid = Z($thisLi).attr("data-mid");
    var thisBid = Z($thisLi).attr("data-bid");
    //当前参数是否存在已设置素材；已有则清空指定素材的参数
    if (thisMid != null && thisBid != null) {
        thisMid = parseInt(thisMid);
        thisBid = parseInt(thisBid);
        var doneMaterial = media.getMaterialByMid(thisMid, thisBid);
        doneMaterial.paramKey = doneMaterial.paramName = null;
    }
    
    //设置当前素材参数为当前参数
    var paramArr = Z($thisLi).attr("data-param").split(",");
    material.paramKey = paramArr[0];
    material.paramName = paramArr[1];
    Z($thisLi).attr("data-mid", material.mid);
    Z($thisLi).attr("data-bid", material.bid);
    
    //状态展示
    Z($thisLi).addClass("active");
    Z($thisLi).find(".paramList-status").addClass("setted");
}
/** 清除参数 **/
function undoPparamSetted(elem, event)
{
    if (!!event){
        Z.E.forbidden(event);
    }
    var $thisLi = Z(elem).parent().parent();
    var thisMid = Z($thisLi).attr("data-mid");
    var thisBid = Z($thisLi).attr("data-bid");
    
    if (thisMid != null && thisBid != null) {
        thisMid = parseInt(thisMid);
        thisBid = parseInt(thisBid);
        var doneMaterial = media.getMaterialByMid(thisMid, thisBid);
        doneMaterial.paramKey = doneMaterial.paramName = null;
        //页面呈现
        Z($thisLi).removeAttr("data-mid");
        Z($thisLi).removeAttr("data-bid");
        Z($thisLi).find(".paramList-status").removeClass("setted");
        
        //清除选中
        if (media.selectedList.length == 1 && media.selectedList[0] == doneMaterial) {
            hideEditSelected(true);
        }
    }
}
/** 特殊文字的参数设置 **/
function setSpecialParam(material, $curElem, $thisLi)
{
    var $gWrap = $curElem.querySelector('g');
    var $svg = [...$gWrap.children].pop();
    // 加载提示
    var loading = Z.loading({text:"处理中···",shadow:true});
    // 取消特殊标识
    $curElem.removeAttribute("data-special");
    // 初始化 wordsList
    initWordsListFromMaterial(material);
    // 保存对象数据
    mediaEvent.startData.targData = media.tool.getEleData($curElem);
    // 确保宽高不变
    material.width = $svg.viewBox.baseVal.width;
    material.height = $svg.viewBox.baseVal.height;
    getPathAjax(material, $curElem, 0, 1, function(m)
    {
        // 设置参数
        var thisMid = Z($thisLi).attr("data-mid");
        var thisBid = Z($thisLi).attr("data-bid");
        //当前参数是否存在已设置素材；已有则清空指定素材的参数
        if (thisMid != null && thisBid != null) {
            thisMid = parseInt(thisMid);
            thisBid = parseInt(thisBid);
            var doneMaterial = media.getMaterialByMid(thisMid, thisBid);
            doneMaterial.paramKey = doneMaterial.paramName = null;
        }
        
        // 设置当前素材参数为当前参数
        var paramArr = Z($thisLi).attr("data-param").split(",");
        m.paramKey = paramArr[0];
        m.paramName = paramArr[1];
        Z($thisLi).attr("data-mid", m.mid);
        Z($thisLi).attr("data-bid", m.bid);
        
        //状态展示
        Z($thisLi).addClass("active");
        Z($thisLi).find(".paramList-status").addClass("setted");

        //取消加载窗口
        setTimeout(function(){
            loading.close();
        },400);
    });
}

/********************************************
 ***********  弹窗、属性设置部分 ************
 ********************************************/
/** 滑块输入框数值变化 **/
function rangeInputChange ($input, keyCode)
{
    var $wrap = $input.parentNode.parentNode;
    var $btn = $wrap.querySelector(".range>i");
    var val = ($input.value)?(parseInt($input.value)):(0);
    var setLeft;
    //输入框数值变化
    if (keyCode === 38) {                             //上 键
        val++;
    } else if (keyCode === 40) {                      //下 键
        val--;
    }
    //依据父级不同的ID，来执行不同的方法
    switch ($wrap.id) {
    case "imageRadius":                             // 图片圆角
        val = (val > 0)?val:0;
        val = (val <= 50)?val:50;
        setImageEffectRadius(val);
        setLeft = val * 2;
        break;
    case "textLetterSpacing":                        // 字间距
        var rangeLimitWidth = Z.D.id("textLetterSpacing").rangeLimitWidth || 0;
        val = (val > -rangeLimitWidth) ? val : -rangeLimitWidth;
        val = (val <= 200) ? val : 200;
        updateFontLetterSpacing(val);
        setLeft = (val + 200) / 4;
        break;
    case "textLineHeight":                           // 行间距
        val = (val > 0)?val:0;
        val = (val <= 1000)?val:1000;
        updateFontLineHeight(val);
        setLeft = val / 10;
        break;
    case "materialOpacity":                          // 透明度
        val = (val > 0)?val:0;
        val = (val <= 100)?val:100;
        updateSvgTransparency(val / 100);
        setLeft = val;
        break;
    case "materialRotate":                           // 旋转度
        val = (val >= 0)?val:359;
        val = (val <= 360)?val:1;
        updateSvgRotate(val);
        break;
    case "shapeLine_dasharray1":                      // 线条虚线大小
        val = (val >= 0)?val:0;
        val = (val <= 200)?val:200;
        updateShapeLineDasharray(val,null);
        setLeft = val / 2;
        break;
    case "shapeLine_dasharray2":                      // 线条虚线间隔
        val = (val >= 0)?val:0;
        val = (val <= 200)?val:200;
        updateShapeLineDasharray(null,val);
        setLeft = val / 2;
        break;
    case "shapeRectRadius":                          // 矩形圆角
        val = (val >= 0)?val:0;
        val = (val <= 100)?val:100;
        updateShapeRectRadius(val,val,val,val);
        setLeft = val;
        break;
    case "shapeRectRadius_nw":                       // 矩形圆角——nw
        val = (val >= 0)?val:0;
        val = (val <= 100)?val:100;
        updateShapeRectRadius(val,null,null,null);
        setLeft = val;
        break;
    case "shapeRectRadius_ne":                       // 矩形圆角——ne
        val = (val >= 0)?val:0;
        val = (val <= 100)?val:100;
        updateShapeRectRadius(null,val,null,null);
        setLeft = val;
        break;
    case "shapeRectRadius_sw":                       //矩形圆角——sw
        val = (val >= 0)?val:0;
        val = (val <= 100)?val:100;
        updateShapeRectRadius(null,null,val,null);
        setLeft = val;
        break;
    case "shapeRectRadius_se":                       // 矩形圆角——se
        val = (val >= 0)?val:0;
        val = (val <= 100)?val:100;
        updateShapeRectRadius(null,null,null,val);
        setLeft = val;
        break;
    case "shapeStroke_strokeRange":                  // 形状边框大小
        val = (val >= 0)?val:0;
        val = (val <= 100)?val:100;
        updateStrokeStrokeSize(val);
        setLeft = val;
        break;
    }
    $input.value = val;
    if ($btn && setLeft !== undefined){
        Z($btn).css("left", setLeft + "%");
    }
}

/*** 页面所有弹窗，重置隐藏 ***/
function docPopupReset(event)
{
    Z.E.forbidden(event);
    docPopupHide();
    //如果存在编辑的文本，则隐藏
    textEditHide();
}
// 所有弹窗隐藏
function docPopupHide()
{
    // 颜色选择器、透明度滑块、弹窗隐藏
    Z(".fte-colorPicker,.rangeWrap,.minipopup").removeAttr("style");
    Z(".fte-colorPicker-dropperCover").removeClass("fte-active");
    docPopupHideExPicker();
}
// 除颜色选择器以外的所有弹窗隐藏
function docPopupHideExPicker()
{
    Z(".rangeWrap").each(function($wrap){
        $wrap.isCanRange = $wrap.eleOldLeft = $wrap.mouseOldLocationt = null;
    });
    // 输入框失去焦点
    var activeEle = document.activeElement;
    if (activeEle.className.indexOf("fontSet_input") > -1){
        activeEle.blur();
    }
    // 右键菜单
    Z(".newContentmenu").hide();
}
/** 隐藏编辑弹出窗：透明度、位置、字距、颜色 **/
function miniPopupHide()
{
    Z(".minipopup,.fte-colorPicker").removeAttr("style");
    Z(".z-dropdown .z-list").hide();
}
/** 如果存在隐藏文本，则显示 **/
function textEditHide()
{
    if (!!Z("#textEditorWrap").attr("style"))
        return;

    var $$hiddenDoing = Z(".hiddenDoing");
    Z.each($$hiddenDoing, function($editing)
    {
        var cn = Z($editing).attr("class");
        if (cn.indexOf("hiddenDoing") > -1){
            showHiddenElement(cn);
        }
    });
}

/** 文字列表的弹框隐藏事件 **/
function hideTextDropList($list)
{
    // 1：颜色选择器
    if ($list) {
        var $colorPicker = Z('.fte-colorPicker')[0];
        if ($colorPicker.hasAttribute('style')){
            $colorPicker.removeAttribute('style');
        }
    }

    // 2：文字下拉列表隐藏
    var $ffDropDown = Z('#tool_fontFamily .z-dropdown .z-list');
    var $fsDropDown = Z('#tool_fontSize .z-dropdown .z-list');
    if ($list && !Z($list).isHide()){
        return;
    }
    if (!$ffDropDown.isHide() || !$fsDropDown.isHide()) {
        var evClick = new Event("click", {"bubbles":false, "cancelable":true});
        document.dispatchEvent(evClick);
    }
}
/** 素材宽高比列锁定 **/
function switchSizeScaleLock(event)
{
    var $lockWrap = Z(Z.E.target(event)).parent();
    var $sizeSet = $lockWrap.parent();
    var $widthInput = $sizeSet.find('.sizeSet-width .z-input');
    var $heightInput = $sizeSet.find('.sizeSet-height .z-input');
    if ($lockWrap.hasClass('active')){
        $lockWrap.removeClass('active');
        $lockWrap.removeAttr('data-scale');
    } else {
        $lockWrap.addClass('active');
        $lockWrap.attr('data-scale',parseFloat($widthInput.val()) / parseFloat($heightInput.val()));
    }
}

/********************************************
 ***********  修改 zhiqimUI 部分 ************
 ********************************************/
/** 取消输入框的 click 事件绑定 **/
var zInputInit = Z.Input.prototype.init;
Z.Input.prototype.init = function ()
{
    zInputInit();
    if (!this.elem || !this.options)
        return;
    this.$elem = Z(this.elem);
    this.$elem.offclick(this.onClick, this);
};

/********************************************
 ******  加载完成后的元素、对象定义 *********
 ********************************************/
function onLoadSetVar()
{
    // 1：节点
    $toolbar = Z('#toolbar');
    $toolsWrap = Z('#toolbar_tollsWrap');
    $toolsWrapLeft = Z('#toolbar_tollsWrap > .toolsWrap-left');
    $toolsWrapRight = Z('#toolbar_tollsWrap > .toolsWrap-right');
    $historyTips = Z('#toolbar_historyTips');
    bgSetType = Z('#bgSetType')[0].checked;

    // 2：对象
    // 2.1：名片尺寸基准
    cardBaseData =
    {
        baseWidthMm: parseFloat(Z.D.id("order_designWidth").value),
        baseHeightMm: parseFloat(Z.D.id("order_designHeight").value),
    };
    cardBaseData.baseWidth = mm2px(cardBaseData.baseWidthMm, media.canvas.dpi, 4);
    cardBaseData.baseHeight = mm2px(cardBaseData.baseHeightMm, media.canvas.dpi, 4);

    // Z：media.canvas校验
    // Z.a：baseWidthMm、baseHeightMm
    var baseWidthMm = media.canvas.baseWidthMm;
    var baseHeightMm = media.canvas.baseHeightMm;
    if (baseWidthMm !== cardBaseData.baseWidthMm)
        media.canvas.baseWidthMm = cardBaseData.baseWidthMm;
    if (baseHeightMm !== cardBaseData.baseHeightMm)
        media.canvas.baseHeightMm = cardBaseData.baseHeightMm;
    // Z.b：fullWidth、fullHeight
    if (baseWidthMm !== media.canvas.baseWidthMm || baseHeightMm !== media.canvas.baseHeightMm)
    {
        baseWidthMm = media.canvas.baseWidthMm;
        baseHeightMm = media.canvas.baseHeightMm;
        media.canvas.fullWidthMm = baseWidthMm * Math.ceil(media.canvas.widthMm / baseWidthMm);
        media.canvas.fullHeightMm = baseHeightMm * Math.ceil(media.canvas.heightMm / baseHeightMm);
        media.canvas.fullWidth = mm2px(media.canvas.fullWidthMm);
        media.canvas.fullHeight = mm2px(media.canvas.fullHeightMm);
    }
}
/********************************************
 *********  加载完成后的事件绑定 ************
 ********************************************/
/** 事件 **/
// 1：画布尺寸-输入框修改-等比变化
function canvasSizeInput(event)
{
    Z.E.forbidden(event);
    var radio = 4;
    var powRadio = Math.pow(10, radio);
    // 重定义输入值
    inputNumberFixed(event, radio);

    var $targetInput = Z.E.target(event);
    var $lockWrap = $targetInput.parentElement.parentElement.querySelector('.scaleLockWrap');
    var $widthInput = Z.D.id('canvas_width');
    var $heightInput = Z.D.id('canvas_height');

    var setWidth = $widthInput.value;
    var setHeight = $heightInput.value;
    var sizeScale = parseFloat(Z($lockWrap).attr('data-scale') || 0);

    // 判断是否存在锁定宽高s
    if (!Z($lockWrap).hasClass('active'))
        return;
    if (!sizeScale) {
        Z($lockWrap).removeClass('active');
        return;
    }
    if ($targetInput === $widthInput) {
        setHeight = Math.floor((setWidth / sizeScale) * powRadio) / powRadio;
        $heightInput.value = setHeight;
    } else {
        setWidth = Math.floor((setHeight * sizeScale) * powRadio) / powRadio;
        $widthInput.value = setWidth;
    }
}
// 1.1：输入框（尺寸大小）内容限制
function inputNumberFixed(event, radio)
{
    Z.E.forbidden(event);
    var $input = Z(Z.E.target(event));
    var val = $input.val();
    radio = parseInt(radio || 4);

    val = val.replace(/[^\d+-.]/g,'');

    // 去除多余+
    if (/\+/.test(val) && !/^\+/.test(val))
        val = val.replace(/\+/g,'');
    // 去除多余-
    if (/\-/.test(val) && !/^\-/.test(val))
        val = val.replace(/\-/g,'');
    // 前置0
    if (/^\./.test(val))
        val = '0' + val;
    // 去除多余.
    if (/\.[^.]*\./.test(val))
        val = /^[^.]+\.[^.]*/.exec(val)[0];
    // 保留有效位
    var radioReg = new RegExp('^[^.]+\\.[^.]{'+ (radio + 1)+'}');
    var radioReg2 = new RegExp('^[^.]+\\.[^.]{'+ (radio)+'}');
    if (radioReg.test(val))
        val = radioReg2.exec(val)[0];

    // 定义新值
    $input.val(val);
}

// 2：素材列表滚动加载
function resultScrollLoad()
{
    var thisId = Z(this).attr("id");
    var $ulWrap = Z(this).children(".result-ul");
    if (!$ulWrap[0])
        return;
    var thisHeight = this.getBoundingClientRect().height;
    var wrapHeight = $ulWrap[0].getBoundingClientRect().height;
    var loadHeight = wrapHeight - thisHeight;
    if (this.scrollTop > loadHeight && fMaterial.couldLoad)
    {
        fMaterial.couldLoad = false;
        fMaterial.page++;
        var btnWrap = null, catCode = "";
        switch (thisId)
        {
            case 'image_result':
                btnWrap = this.parentElement.previousElementSibling;
                catCode = btnWrap.querySelector(".side-btnSelect.active").getAttribute("data-catCode");
                doQueryCatMaterial(catCode, "image", "addSvgCode", "tagMenuShow");
                break;
            case 'search_result':
                doQueryMaterial();
                break;
            case 'text_result':break;
            case 'bg_result':
                btnWrap = this.parentElement;
                catCode = btnWrap.querySelector(".side-btnSelect.active").getAttribute("data-catCode");
                doQueryCatMaterial(catCode, "bg", "selBgSvgCode");
                break;
        }
    }
    // 显示页数
    var $$ul = $ulWrap.children("ul");
    if (!$$ul[0])
        return;
    var ulHeight = $$ul[0].getBoundingClientRect().height;
    var scrollTop = this.scrollTop;
    var page = Math.ceil(scrollTop / ulHeight);
    page = page ? page : 1;
    if (scrollTop + this.offsetHeight >= wrapHeight)
        page = $$ul.length;
    Z(this).find(".result-page>span").html(page + "/" + fMaterial.totalPages);
}
// 3：素材指定/特殊位置点设置
function materialSpecialLocation (event)
{
    var $targ = Z.E.current(event);
    var type = Z($targ).attr("data-type");
    Z($targ).addClass('active').siblings('span').removeClass('active');
    doSetMaterialPos(type);
}
// 6：表格边框大小设置
function updateStrokeTableStrokeSize(ev)
{
    var $input = Z.E.current(ev);
    var val = $input.value.trim();
    val = val === "" ? 0 : val;
    $input.value = val;
    updateStrokeStrokeSize(val, $input);
}
// 7：侧边编辑框显示/隐藏
function toolFontFamilyClickForbidden (event)
{
    Z.E.forbidden(event);
    hideTextDropList(this.querySelector('ul.z-list'));
}
// 9：侧边编辑框显示/隐藏
function sideStageSwitchShow(event)
{
    var $mainBody = Z(".mainbody-design");
    var $thisBtn = Z(Z.E.current(event));
    var $parent = $thisBtn.parent();
    var type = $thisBtn.attr("data-type");
    var pWidth = $parent.offsetWidth();
    var pLeft = parseInt($parent.css("left"));
    var pRight = parseInt($parent.css("right"));

    //变化前，画布的相对偏移：left相对整体宽度的比例
    var designRect = media.tool.$designStage.getBoundingClientRect();
    var stageRect = media.tool.$stageCanvas.getBoundingClientRect();
    var stageLeft = stageRect.left - designRect.left;
    var stageRight = designRect.right - stageRect.right;
    var beRatio = stageRight / stageLeft;

    if (type === "left"){
        if (pLeft === 0){
            $thisBtn.addClass("active");
            $parent.css("left","-" + pWidth);
            $mainBody.css("left",0);
        }
        else if (pLeft < 0){
            $thisBtn.removeClass("active");
            $parent.css("left",0);
            $mainBody.css("left",pWidth);
        }
    }
    if (type === "right"){
        if (pRight === 0){
            $thisBtn.addClass("active");
            $parent.css("right","-" + pWidth);
            $mainBody.css("right",0);
        }
        else if (pRight < 0){
            $thisBtn.removeClass("active");
            $parent.css("right",0);
            $mainBody.css("right",pWidth);
        }
    }
    //编辑区画布，left坐标适应
    var beLeft;
    if (beRatio >= 0){
        designRect = media.tool.$designStage.getBoundingClientRect();
        stageRect = media.tool.$stageCanvas.getBoundingClientRect();
        var beWidth = designRect.width - stageRect.width;
        beLeft = beWidth / (1 + beRatio);
        //设置位置
        media.tool.$stageCanvas.style.left = beLeft + "px";
    } else if (stageRight < 0) {
        var oldWidth = designRect.width;
        var oldLeft = stageRect.left - designRect.left;
        designRect = media.tool.$designStage.getBoundingClientRect();
        beLeft = designRect.width - oldWidth + oldLeft;
        media.tool.$stageCanvas.style.left = beLeft + "px";
    }
    // 缩略图重新定位
    zoomAreaJudge();
}
// 10：缩放缩略图切换显示
function zoomAreaSwitchShow (event)
{
    var $this = Z(Z.E.current(event));
    var $area = $this.parent();
    $area.toggleClass("active");
    if ($area.hasClass("active")) refreshZoomArea();
}
// 12：画布缩放操作按钮事件
function canvasShowSizeZoomSet (event)
{
    //去除编辑工具
    mediaEvent.removeAllEditTool();

    var maxRatio = 500;                      //最大显示比例
    var $this = Z(Z.E.current(event));
    var $zoomText = $this.parent().children(".zoom-text");
    var nowRatio = parseInt($zoomText.text());
    var setRatio = nowRatio;
    var type = $this.attr("data-type").toLowerCase();
    if (type === "up")
    {//放大
        if (nowRatio >= 0 && nowRatio < maxRatio){
            setRatio = Math.round(nowRatio / 10) * 10;
            setRatio = (setRatio <= nowRatio)?(setRatio + 5):(setRatio);
        } else{
            setRatio = maxRatio;
        }
    }
    if (type === "down")
    {//缩小
        if (nowRatio > 5 && nowRatio <= maxRatio){
            setRatio = Math.ceil(nowRatio/10)*10 - 5;
            setRatio = (setRatio >= nowRatio)?(setRatio - 5):(setRatio);
        } else{
            setRatio = maxRatio;
        }
    }
    if (type === "switch")
    {//自适应切换
        if (!$this.hasClass("active")){
            $this.addClass("active");
            media.tool.setRatioCanvas();
            setRatio = media.tool.showRatio * 100;
        }
        else{
            $this.removeClass("active");
            setRatio = 100;
        }
    }
    if (type === "bleed")
    {//显示出血
        if ($this[0].hasAttribute("data-active"))
        {//隐藏出血
            $this.removeAttr("data-active");
            Z("#bleed_guide").hide();
        }
        else
        {//显示出血
            $this.attr("data-active","active");
            setBleedTool();
            Z("#bleed_guide").show();
        }
        return;
    }
    //执行缩放操作
    media.tool.setRatioCanvas(setRatio/100, true);
    media.tool.locationTrueCanvas();   //画布局中
    zoomAreaJudge();

    // 选择框定位
    setAllToolLoc();
}
// 13：滑块操作
function rangeWrapMouseDown (event)
{
    if (event.button !== 0) return;
    Z.E.forbidden(event);
    var $itemWrap = Z.E.current(event).parentNode.parentNode;
    $itemWrap.isCanRange = true;
    $itemWrap.eleOldLeft = Z(this).offsetLeft();
    $itemWrap.mouseOldLocationt = getMouseLocation(event);
    Z(this).addClass("active");
}
function rangeWrapMouseMove (event)
{
    Z.E.forbidden(event);
    var itemWraps = Z.E.current(event).querySelectorAll(".itemWrap");
    var i, $itemWrap, changeLeft, oldLeft, wrapWidth, leftPercent, showValue, rangeLimitWidth;
    for (i = 0;i < itemWraps.length;i++)
    {
        $itemWrap = itemWraps[i];
        if (!$itemWrap.isCanRange) {
            continue;
        }
        changeLeft = getMouseLocation(event).x - $itemWrap.mouseOldLocationt.x;
        oldLeft = $itemWrap.eleOldLeft;
        wrapWidth = $itemWrap.querySelector(".range").offsetWidth;

        // 计算滑块偏移距离
        leftPercent = Math.round((oldLeft + changeLeft) / wrapWidth * 100) ;
        if (leftPercent <= 0) leftPercent = 0;
        if (leftPercent >= 100) leftPercent = 100;
        $itemWrap.querySelector(".range>i").style.left = leftPercent + "%";

        // 依据滑块类型（id），执行方法
        showValue = leftPercent;
        switch ($itemWrap.id)
        {
            case "imageRadius": // 图片圆角
                showValue = Math.round(leftPercent / 2);
                setImageEffectRadius(showValue);
                break;
            case "materialOpacity": // 透明度
                updateSvgTransparency(showValue);
                break;
            case "textLetterSpacing": // 字间距
                rangeLimitWidth = Z.D.id("textLetterSpacing").rangeLimitWidth || 0;
                if (leftPercent <= 50) {
                    showValue = rangeLimitWidth * leftPercent / 50 - rangeLimitWidth;
                } else {
                    showValue = leftPercent * 4 - 200;
                }
                updateFontLetterSpacing(showValue);
                break;
            case "textLineHeight": // 行间距
                showValue = leftPercent * 10;
                updateFontLineHeight(showValue);
                break;
            case "shapeLine_dasharray1": // 线条虚线大小
                showValue = leftPercent * 2;
                updateShapeLineDasharray(showValue, null);
                break;
            case "shapeLine_dasharray2": // 线条虚线间隔
                showValue = leftPercent * 2;
                updateShapeLineDasharray(null,showValue);
                break;
            case "shapeRectRadius": // 矩形圆角
                updateShapeRectRadius(showValue,showValue,showValue,showValue);
                break;
            case "shapeRectRadius_nw": // 矩形圆角——nw
                updateShapeRectRadius(showValue,null,null,null);
                break;
            case "shapeRectRadius_ne": // 矩形圆角——ne
                updateShapeRectRadius(null,showValue,null,null);
                break;
            case "shapeRectRadius_sw": // 矩形圆角——sw
                updateShapeRectRadius(null,null,showValue,null);
                break;
            case "shapeRectRadius_se": // 矩形圆角——se
                updateShapeRectRadius(null,null,null,showValue);
                break;
            case "shapeStroke_strokeRange": // 形状边框大小
                updateStrokeStrokeSize(showValue);
                break;
        }
        $itemWrap.querySelector(".num>input").value = showValue;
    }
}
function rangeWrapMouseLeave (event)
{// 滑块范围内松开
    Z.E.forbidden(event);
    var itemWraps = Z.E.current(event).querySelectorAll(".itemWrap");
    for (var i = 0;i < itemWraps.length;i++)
    {//循环所有滑块条
        var $itemWrap = itemWraps[i];
        if ($itemWrap.isCanRange)
        {// 滑动过的滑块
            updateMaterialSource();
            saveHistory();
        }
        Z($itemWrap).find(".range>i").removeClass("active");
        $itemWrap.isCanRange = $itemWrap.eleOldLeft = $itemWrap.mouseOldLocationt = null;
    }
}
// 14：数值输入框，键盘增减、input、blur
function numberInputKeyControl (event)
{
    Z.E.stop(event);
    var keyCode = event.keyCode;
    if (keyCode !== 38 && keyCode !== 40 && keyCode !== 13) {
        return;
    }
    Z.E.cancel(event);
    var $input = Z.E.current(event);
    if (keyCode === 13) {
        $input.blur();
        updateMaterialSource();
        saveHistory();
        return;
    }
    rangeInputChange($input, keyCode);
}
function numberInputEventInput (event)
{
    Z.E.cancel(event);
    var $input = Z.E.current(event);
    rangeInputChange($input, event.keyCode);
}
function numberInputEventBlur (event)
{
    var $input = Z.E.current(event);
    var $wrapPopup = closetParentByClass($input,"minipopup");
    if (!$wrapPopup) {
        return;
    }
    var material = $wrapPopup.targMaterial;
    var $curElem = $wrapPopup.targElement;
    if (!material || !$curElem) {
        return;
    }
    updateMaterialSource(material,$curElem);
    saveHistory();
}
// 15：画布内素材解锁按钮
function unlockMaterialInCanvas (event)
{
    Z.E.forbidden(event);
    if (media.selectedList.length === 0) {
        return;
    }
    var i, material;
    // 多选列表，循环处理，执行解锁
    for (i = 0;i < media.selectedList.length;i++) {
        material = media.getCurMaterial(i);
        if (material.status === 3) {
            unlockMaterial(event, material);
        }
    }
    saveHistory();
}
// 18：点击事件，隐藏弹窗
function clickClearHide ()
{
    docPopupHide();
    textEditHide();
}
// 19：窗口缩放画布
function windowResizeCanvas()
{
    media.tool.setRatioCanvas();
    media.tool.locationTrueCanvas();
    setAllToolLoc();
}
// 20：侧边栏按钮组切换
function sideSelectBtnSwitch ()
{
    var $$list = this.parentElement.children;
    var listLength = $$list.length;
    var i, $btn;
    Z(this).addClass('active');
    for (i = 0;i < listLength;i++) {
        $btn = $$list[i];
        if ($btn !== this) Z($btn).removeClass('active');
    }
}
// 21：多素材选中状态，双击编辑
function dblClickEditGroup(event)
{
    return;
    var selectedLength = media.selectedList.length;
    if (selectedLength < 2)
        return;
    var $selectionTool = Z(this);
    if (!$selectionTool.hasClass('groupTool'))
        return;

    Z.E.forbidden(event);
    // 1：隐藏编辑框
    selectionAll_hide();
    hideToolbar();

    // 2：选中素材可编辑
    var i, $curElem, elemClass;
    for(i = 0;i < selectedLength;i++)
    {
        1
    }
}
// 24：文字特效“大小”滑块
function textSpecialSizeMouseDown(event)
{
    var $btn = event.currentTarget;
    var $range = Z.D.id('textSpecial_sizeRange');
    $range.startLoc = {
        'x': event.pageX,
        'left': $btn.offsetLeft,
        'all': $range.offsetWidth,
    };
}
function textSpecialSizeMouseMove(event)
{
    var $range = Z.D.id('textSpecial_sizeRange');
    if (!$range.startLoc)
        return;
    var baseLoc = $range.startLoc;
    var newLeft = event.pageX - baseLoc.x + baseLoc.left;
    if (newLeft < 0 )
        newLeft = 0;
    if (newLeft > baseLoc.all )
        newLeft = baseLoc.all;
    Z('#textSpecial_sizeRange>.z-pointer').css('left', newLeft);

    setTextSpecialSize(newLeft / baseLoc.all);
}
function textSpecialSizeMouseUp()
{
    Z.D.id('textSpecial_sizeRange').startLoc = null;
}
// 25：表格操作
function tableInsertBoxHover(event)
{
    var $tableBox = event.currentTarget;
    var boxRect = $tableBox.getBoundingClientRect();
    var mouseRect = getMouseLocation(event);
    var mx = mouseRect.x - boxRect.x;
    var my = mouseRect.y - boxRect.y;
    if (mx <= 0 || my <= 0)
        return;
    var xNum = Math.ceil(mx / 18);
    var yNum = Math.ceil(my / 18);
    var hoverWidth = xNum * 18;
    var hoverHeight = yNum * 18;
    Z("#tableInsertList .tDB-tableHover").css("width", hoverWidth).css("height", hoverHeight);
    $tableBox.nextElementSibling.innerHTML = yNum + " x " + xNum;

    // 赋值
    Z("#tableRowInserted").val(yNum);
    Z("#tableColInserted").val(xNum);
}
function tableInsertBoxLeave(event)
{
    var $tableBox = event.currentTarget;
    Z("#tableInsertList .tDB-tableHover").css("width", 18).css("height", 18);
    $tableBox.nextElementSibling.innerHTML = "1 x 1";
}
function doTableMaterialInsert(event)
{
    // 1：表格（html）行列
    var showRatio = media.tool.showRatio;
    var $target = Z.E.target(event);
    var rowNum = Z("#tableRowInserted").val(), colNum = Z("#tableColInserted").val();
    if ($target.tagName.toLowerCase() === "button")
    {
        var doInsertByInput = true;
        rowNum = Z("#tableInsertList .tableRowInserted").val();
        colNum = Z("#tableInsertList .tableColInserted").val();
        if (!rowNum > 0 || !colNum > 0)
            return Z.failure("请输入有效的表格行列数！");
    }
    rowNum = parseFloat(rowNum), colNum = parseFloat(colNum);
    var borderWidthPx = 1;

    // 1.1：表格（html）字体大小、行高
    var fontSizePx = Math.round(minFontSizePx / showRatio);
    var fontSizePt = px2pt(fontSizePx) + "pt";
    var svgLineHeight = Math.round(fontSizePx * fS2LHRatio);
    var tdHeight = svgLineHeight * showRatio + tableTextAreaPdTop + tableTextAreaPdBottom;

    // 1.2：表格（html）宽高
    var tableWidth = parseFloat(Z(".tableDimensionBox .tableWidthInserted").val() || 0);
    var tableHeight =  parseFloat(Z(".tableDimensionBox .tableHeightInserted").val() || 0);
    if (tableWidth)
        tableWidth = mm2px(tableWidth) * showRatio;
    if (tableHeight)
    {
        tableHeight = mm2px(tableHeight) * showRatio;
        if (tableHeight <= tdHeight * rowNum){
            tableHeight = tdHeight * rowNum + borderWidthPx;
            doInsertByInput && Z(".tableDimensionBox .tableHeightInserted").val(px2mm(tableHeight/showRatio));
        } else
            tdHeight = (tableHeight - borderWidthPx) / rowNum;
    }
    if (!tableWidth || !tableHeight)
    {
        var stageRect = media.tool.$designStage.getBoundingClientRect();
        var bgRect = media.tool.$canvasBg.getBoundingClientRect();
        if (!tableWidth)
        {
            if (bgRect.width <= stageRect.width)
                tableWidth = Math.round(bgRect.width * .8);
            else
                tableWidth = Math.round(stageRect.width * .8);
        }
        if (!tableHeight)
        {
            tableHeight = tdHeight * rowNum + borderWidthPx;
            var baseTableHeight =  Math.round((bgRect.height <= stageRect.height ? bgRect.height : stageRect.height));
            if (tableHeight > baseTableHeight)
            {
                tableHeight = baseTableHeight * .8;
                tdHeight = (tableHeight - borderWidthPx) / rowNum;
                svgLineHeight = Math.round(tdHeight / showRatio);
                fontSizePx = Math.round(svgLineHeight / fS2LHRatio);
                fontSizePt = px2pt(fontSizePx) + "pt";
            }
        }
    }
    var tdWidth = (tableWidth - borderWidthPx) / colNum;

    // 1.3：表格（svg）宽高
    var borderWidth = borderWidthPx / showRatio;
    var setWidth = tableWidth / showRatio;
    var setHeight = tableHeight / showRatio;
    var gTdWidth = tdWidth / showRatio;
    var gTdHeight = tdHeight / showRatio;

    // 2：获取素材源码
    var $svg = document.createElementNS(xmlns, "svg");
    $svg.setAttribute("preserveAspectRatio", "none");
    $svg.setAttribute("data-type", "shape-table");
    $svg.setAttribute("width", setWidth + "");
    $svg.setAttribute("height", setHeight + "");
    $svg.setAttribute("viewBox", "0 0 " + setWidth + " " + setHeight);

    var fillColor = "#ffffff", borderColor = "#000000", transX = 0, transY = 0, trans = "";
    var i = 0, j = 0, firstRow = null, firstCol = null, lastRow = null, lastCol = null;
    var $gTr = null, $gTd = null, $rectFill = null,
        $lineLeft = null, $lineTop = null, $lineRight = null, $lineBottom = null,
        $gTextWrap = null, $gText = null;
    var mx = borderWidth / 2, my = borderWidth / 2;
    for(i;i < rowNum;i++)
    {
        lastRow = i === rowNum - 1;
        $gTr = document.createElementNS(xmlns, "g");
        transY = i * gTdHeight + borderWidth / 2;
        trans = "translate(0 " + transY + ")";
        $gTr.setAttribute("transform", trans);
        $gTr.setAttribute("data-y", transY);

        // 遍历单元格
        for (j = 0;j < colNum;j++)
        {
            firstRow = i === 0;
            firstCol = j === 0;
            lastCol = j === colNum - 1;

            $gTd = document.createElementNS(xmlns, "g");
            $rectFill = document.createElementNS(xmlns, "rect");
            $rectFill.setAttribute("width", gTdWidth);
            $rectFill.setAttribute("height", gTdHeight);
            $rectFill.setAttribute("fill", fillColor);
            $gTd.appendChild($rectFill);

            // 4.2：单元格偏移
            transX = j * gTdWidth + borderWidth / 2;
            trans = "translate(" + transX + " 0)";
            $gTd.setAttribute("transform", trans);
            $gTd.setAttribute("data-x", transX);

            // 4.3.1：单元格边框：左
            $lineLeft = document.createElementNS(xmlns, "line");
            $lineLeft.setAttribute("stroke", borderColor);
            $lineLeft.setAttribute("stroke-width", borderWidth);
            $lineLeft.setAttribute("stroke-linecap", "butt");
            $lineLeft.setAttribute("x1", 0);
            $lineLeft.setAttribute("y1", 0);
            firstRow && $lineLeft.setAttribute("y1", - my);
            $lineLeft.setAttribute("x2", 0);
            $lineLeft.setAttribute("y2", gTdHeight);
            $lineLeft.setAttribute("data-type", "left");
            $gTd.appendChild($lineLeft);

            // 4.3.2：单元格边框：上
            $lineTop = $lineLeft.cloneNode(true);
            $lineTop.setAttribute("y1", 0);
            $lineTop.setAttribute("x2", gTdWidth);
            $lineTop.setAttribute("y2", 0);
            $lineTop.setAttribute("data-type", "top");
            $gTd.appendChild($lineTop);

            // 4.3.3：单元格边框：下
            if (lastRow)
            {
                $lineBottom = $lineLeft.cloneNode(true);
                $lineBottom.setAttribute("x1", gTdWidth);
                $lineBottom.setAttribute("y1", gTdHeight - my);
                $lineBottom.setAttribute("y2", gTdHeight - my);
                $lineBottom.setAttribute("data-type", "bottom");
                $gTd.appendChild($lineBottom);
            }

            // 4.3.4：单元格边框：右
            if (lastCol)
            {
                $lineRight = $lineTop.cloneNode(true);
                $lineRight.setAttribute("x1", gTdWidth - mx);//设置 input 元素的 type 属性：
                $lineRight.setAttribute("y1", gTdHeight);
                $lineRight.setAttribute("x2", gTdWidth - mx);
                $lineRight.setAttribute("data-type", "right");
                $gTd.appendChild($lineRight);
            }
            // 4.5：生成文字路径
            var $textPathSvg = document.createElementNS(xmlns, "svg");
            $textPathSvg.setAttribute("preserveAspectRatio", "none");
            $textPathSvg.setAttribute("version", "1.1");
            $textPathSvg.setAttribute("xmlns", xmlns);
            $textPathSvg.setAttribute("data-lineheight", svgLineHeight);
            $textPathSvg.setAttribute("data-singleheight", svgLineHeight);
            $textPathSvg.setAttribute("data-mathheight", "0");
            $gText = document.createElementNS(xmlns, "g");
            $gText.appendChild($textPathSvg);
            $gTextWrap = document.createElementNS(xmlns, "g");
            $gTextWrap.appendChild($gText);
            $gTd.appendChild($gTextWrap);

            // 5.5：单元格属性
            $gTd.setAttribute("data-row", i + 1);
            $gTd.setAttribute("data-col", j + 1);
            $gTd.setAttribute("data-rowspan", "1");
            $gTd.setAttribute("data-colspan", "1");
            $gTd.setAttribute("data-fontfamily", "微软雅黑");
            $gTd.setAttribute("data-fontweight", "0");
            $gTd.setAttribute("data-fontitalic", "0");
            $gTd.setAttribute("data-textdecoration", "0");
            $gTd.setAttribute("data-fontsize", fontSizePt);
            $gTd.setAttribute("data-text", "");
            $gTd.setAttribute("data-lineheight", svgLineHeight);
            $gTd.setAttribute("data-mathheight", "0");
            $gTd.setAttribute("data-letterspacing", "0");
            $gTd.setAttribute("data-textalign", "center");
            // 插入单元格
            $gTr.appendChild($gTd);
        }
        $svg.appendChild($gTr);
    }

    // 3：素材对象定义：material
    var material = newMediaMaterial(
        {
            type: 5,
            source: $svg,
            textAlign: "center",
            fontSize: fontSizePt,
            isTable: 1,
        });

    // 4：添加表格素材：svg
    var $curElem = media.tool.createSvgCodeElement(material);
    media.addMaterial(material);
    selectTheElement(material, $curElem);
    saveHistory();
}

/** 绑定 **/
function onLoadSetOn()
{
    /** 1：画布尺寸-输入框编辑 **/
    Z('#canvas_width, #canvas_height').on('input', canvasSizeInput);
    /** 2：素材内容列表滑动触发加载 **/
    Z("#image_result, #search_result, #text_result, #bg_result").on("scroll", resultScrollLoad);
    /** 3：素材位置设置 **/
    Z("#material_pos_box .setLocAlign>span").on("click", materialSpecialLocation);
    /** 4：素材位置修改 **/
    Z("#material_pos_box input").on("input",doChangeMaterialPos);
    /** 5：素材尺寸修改 **/
    Z("#svg_sizeSet_box input").on("input",doChangeSvgSize);
    /** 6：边框尺寸修改 **/
    Z("#shapeStroke_strokeSize").on("input", updateStrokeTableStrokeSize);
    /** 7：文字编辑器取消默认事件 **/
    Z("#tool_fontFamily").on("mousedown click", toolFontFamilyClickForbidden);
    Z(".tool-textList").on("mousedown", Z.E.cancel);
    /** 8：颜色拾取展示 **/
    Z(".tool-colorPicker").on("mousedown", showColorPickerBox).on('click', Z.E.forbidden);
    /** 9：侧边隐藏按钮事件 **/
    Z(".closebtn").on("click", sideStageSwitchShow);
    /** 10：缩放缩略图切换显示 **/
    Z("#zoomAreaThumb .switchBtn").on("click", zoomAreaSwitchShow);
    /** 11：缩放缩略图拖动 **/
    Z("#zoomAreaThumb .selector").on("mousedown",zoomAreaMouseDown);
    /** 12：画布缩放操作按钮事件 **/
    Z(".zoombtn>.zoom").on("click", canvasShowSizeZoomSet);
    /** 13：滑块操作 **/
    Z(".rangeWrap").on('click', Z.E.forbidden);
    Z(".rangeWrap .itemWrap>.range>i").on('mousedown', rangeWrapMouseDown);
    Z(".rangeWrap").on('mousemove', rangeWrapMouseMove).on("mouseup mouseleave", rangeWrapMouseLeave);
    /** 14：数值输入框编辑 **/
    Z(".rangeWrap .itemWrap>.num>input").on("keydown", numberInputKeyControl).on("input", numberInputEventInput).on("blur", numberInputEventBlur);
    /** 15：画布内素材解锁按钮 **/
    Z('#selection_lock > i.z-lock').on('mousedown', unlockMaterialInCanvas);
    /** 16：参考图编辑绑定 **/
    Z('#stage_reference .wrap_reference').on('mousedown', editImgReferenceStart);
    Z('#stage_reference .ctrBtn').on('mousedown', editImgReferenceStart);
    /** 17：文字对齐绑定事件 **/
    Z("#textAlign_box .textAlign_box_btn").on("mousedown click",Z.E.forbidden).on("click", switchTextAlign);
    /** 18：隐藏弹窗，事件绑定 **/
    Z(".topnav,#sidebar,#toolbar_tollsWrap,#stage_design,.rightpanel").on("click", clickClearHide);
    /** 19：窗口缩放画布适应 **/
    Z(window).on('resize', windowResizeCanvas);
    /** 20：侧边栏按钮组切换 **/
    Z('#sidebar .side-btnSelect').on('click', sideSelectBtnSwitch);
    /** 21：侧边栏素材列表切换 **/
    Z('#side_image .z-tabnav>nav>ul>li').on('click', function(){resetResultListHeight('side_image')});
    Z('#side_text .z-tabnav>nav>ul>li').on('click', function(){resetResultListHeight('side_text')});
    /** 22：多素材双击编辑 **/
    Z('#selection_tool').on('dblclick', dblClickEditGroup);
    /** 23：文字特效按钮绑定 **/
    Z('#textSpecial_list>li').on('click', doTextSpecialSetClick);
    /** 24：文字特效“大小”滑块 **/
    Z("#textSpecial_sizeRange>.z-pointer").on('mousedown', textSpecialSizeMouseDown);
    Z('.textSpecialMore-item.item-sizeRange').on('mousemove', textSpecialSizeMouseMove).on('mouseup mouseleave', textSpecialSizeMouseUp);
    /** 25：表格工具事件 **/
    Z("#tableInsertList .tDB-table").on("mousemove", tableInsertBoxHover).on("mouseout mouseleave", tableInsertBoxLeave);
    Z("#tableInsertList .tDB-table,#tableInsertList .tableDimensionBox-input button").on("click", doTableMaterialInsert);
}


/** 电子名片编辑器相关代码 **/
//关联信息、个人简介、相册切换事件
function changeLeftTab(ele, tabType)
{
	Z(ele).addClass("tabActive").siblings("li").removeClass("tabActive");
	Z("#linkInfoTab").hide();
	Z("#personalIntroductionTab").hide();
	Z("#personalAlbumTab").hide();

	if (tabType == "linkInfo")
	{
		Z("#linkInfoTab").show();
	}
	
	if (tabType == "personalIntroduction")
	{
		Z("#personalIntroductionTab").show();
	}
	
	if (tabType == "personalAlbum")
	{
		Z("#personalAlbumTab").show();
	}
}
