(function(Z)
{
//BEGIN

/********************************************
********* 媒体事件操作类 Z.MediaEvent ********
********************************************/
Z.MediaEvent = Z.Class.newInstance();
Z.MediaEvent.prototype = {

init: function()
{
    this.startData = {};             //事件操作开始时的数据
    this.doingData = {};             //拖动操作进行时的数据

    //文字编辑过程
    this.textMaterial = null;           //文字编辑过程，临时素材对象
    this.textElement = null;            //文字编辑过程，临时节点元素

    //拖拽过程
    this.dragMaterial = null;           //拖拽事件时，拖拽的对象
    this.dragFrameImg = null;           //拖拽事件时，存储临时的容器图片对象

    //形状类型
    this.shapeType = null;              //形状编辑工具类型；1：线条，2：矩形，3:矩形框， 4：圆形，11：钢笔

    //编辑工具临时对象
    this.elemEditToolData = {};              //钢笔编辑过程，数据存储

    //历史记录
    this.penEditHistory = null;           //历史纪录对象
},

/********************************************
 ************ 一: mousedown判断 *************
 ********************************************/

// 画布的mousedown操作；（左键）判断操作类型
canvasMouseDown: function(event)
{
    if (event.button !== 0) return;
    if (this.isInTextEditor(event)) {
        return true;
    }
    Z.E.stop(event);
    var $targ = Z.E.target(event);
    miniPopupHide();

    var selectLength;
    // 1: 框选素材
    if ($targ === media.tool.$designStage || $targ === media.tool.$canvasSvg) {
        this.stageDefault();                                        // 1：框选素材
        this.boxSelectStart(event);
    // 2：画布拖动
    } else if ($targ === media.tool.$svgCover) {
        this.canvasDragStart(event);                                // 2：移动画布
    // 3：素材拖动
    } else if ($targ.id === "selection_tool") {
        selectLength = media.selectedList.length;
        if (selectLength === 1) {
            this.singleDragStart(event);                           // 3.1：单素材拖动
        } else if (selectLength > 1) {
            this.groupDragStart(event);                            // 3.2：素材组拖动
        }
    // 4：缩放操作
    } else if ($targ.tagName.toLowerCase() === "div" && $targ.className.indexOf("point") > -1) {
        var pNode = $targ.parentNode;
        if (pNode.id === "selection_tool"){
            selectLength = media.selectedList.length;
            // 4.1:素材缩放操作
            if (selectLength === 1) {
                this.singleZoomStart(event);                        // 4.1.1：单素材缩放
            } else if (selectLength > 1) {
                this.groupZoomStart(event);                         // 4.1.2：素材组缩放
            }
        } else if (pNode.id === "textEditorPoint") {
            // 4.2:文字编辑框缩放操作
            this.editorResizeStart(event);                          // 4.2：文本输入框缩放
        }
    // 5：绘制形状
    } else if ($targ.id === "shapeEditorCover") {
        this.drawShapeStart(event);                                 // 5：形状绘制
    // 5：钢笔工具
    } else if ($targ.id === "penEditorCover") {
        this.penDrawStart(event);                                  // 6：钢笔工具
    }
},

// 素材的mousedown操作，选中操作
eleMouseDown: function(event)
{
    Z.E.stop(event);
    // 隐藏弹窗
    miniPopupHide();
    // 去除编辑工具
    this.removeAllEditTool();

    // 文字编辑
    if (Z.D.id("textEditorWrap").getAttribute("style"))
        return;

    // 图片容器编辑
    if (!Z("#imgFrameEditor")[0].hasAttribute("style"))
        media.tool.setTempCurrent();

    // 背景图层校验
    var $curElem = event.currentTarget;
    var material = media.getMaterialByMid($curElem.getAttribute('data-mid'));
    if (!material.bgMaterial)
    {
        if ($curElem.getAttribute('data-bgmaterial')){
            $curElem.removeAttribute('data-bgmaterial');
        }
    }

    // 是否按下了shift键，且已存在选中，执行多选
    if (event.shiftKey) {                          //多选模式
        this.multipleSelectStart(event);
    } else {                                      //单选模式
        this.singleSelectStart(event);
    }
},

/********************************************
 ********** 二: mousedown事件处理 ************
 ********************************************/

/********************************************
 /********* 2.1：画布的mousedown事件 ********
 ********************************************/

/** 1.1.1:隐藏选框 **/
stageDefault: function()
{
    // 去除编辑工具
    this.removeAllEditTool();
    // 选中隐藏
    hideEditSelected(true);
    // 刷新图层列表
    loadLayerList();
},

/** 1.1.2:框选素材 **/
// 素材框选开始
boxSelectStart: function(event)
{
    this.startData.boxSelectLoc = getMouseLocation(event);
    //储存素材数据
    guideGetInfo(true);
    Z(media.tool.$designStage).on("mousemove",this.boxSelectDoing,this);
    Z(media.tool.$designStage).on("mouseup mouseleave",this.boxSelectDone,this);
},
// 素材框选过程
boxSelectDoing: function(event)
{
    Z.E.cancel(event);
    var nowMouseLoc = getMouseLocation(event);
    var width = nowMouseLoc.x - this.startData.boxSelectLoc.x;
    var height = nowMouseLoc.y - this.startData.boxSelectLoc.y;
    if (width === 0 && height === 0) {
        return;
    }

    var clientRect = media.tool.$stageCanvas.getBoundingClientRect();
    var left = this.startData.boxSelectLoc.x - clientRect.left;
    var top = this.startData.boxSelectLoc.y - clientRect.top;
    if (width < 0){
        width = Math.abs(width);
        left -= width;
    }
    if (height < 0){
        height = Math.abs(height);
        top -= height;
    }
    Z('#selection_group').css({
        "width": width, "height": height, "left": left, "top": top,
    });
},
// 素材框选结束
boxSelectDone: function()
{
    Z(media.tool.$designStage).off("mousemove",this.boxSelectDoing,this);
    Z(media.tool.$designStage).off("mouseup mouseleave",this.boxSelectDone,this);
    //执行多选结果，显示缩放框
    getSvgElementGroup();
    Z('#selection_group').removeAttr("style");
},

/** 1.2:移动画布 **/
// 画布拖拽开始
canvasDragStart: function(event)
{
    this.startData.mouseLoc = getMouseLocation(event);
    this.startData.stageX = media.tool.$stageCanvas.offsetLeft;
    this.startData.stageY = media.tool.$stageCanvas.offsetTop;

    // 事件绑定
    Z(media.tool.$designStage).on("mousemove",this.canvasDragDoing,this);
    Z(media.tool.$designStage).on("mouseup mouseleave",this.canvasDragDone,this);
},
// 画布拖拽过程
canvasDragDoing: function(event)
{
    Z.E.cancel(event);
    var nowMouseLoc = getMouseLocation(event);
    var mouseMetabolic = {
        "x": nowMouseLoc.x - this.startData.mouseLoc.x,
        "y": nowMouseLoc.y - this.startData.mouseLoc.y,
    }
    if (mouseMetabolic.x === 0 && mouseMetabolic.y === 0) {
        return;
    }

    // 赋值画布的坐标样式
    Z(media.tool.$stageCanvas).css({
        "left": this.startData.stageX + mouseMetabolic.x,
        "top": this.startData.stageY + mouseMetabolic.y,
    });
    // 设置缩略图位置
    refreshZoomArea();
    // 选择框定位
    selectionToolsShow_group();
},
// 画布拖拽结束
canvasDragDone: function()
{
    Z(media.tool.$designStage).off("mousemove",this.canvasDragDoing,this);
    Z(media.tool.$designStage).off("mouseup mouseleave",this.canvasDragDone,this);
},

/** 1.3.1：单素材拖动 **/
// 单素材拖拽开始
singleDragStart: function(event)
{
    // 判断，如果
    var $target = media.tool.tempElement || media.tool.getCurSvgElement();
    this.startData.targData = media.tool.getEleData($target);
    this.startData.mouseLoc = getMouseLocation(event);

    // 显示半透明效果
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    var material = media.tool.tempMaterial || media.getCurMaterial();
    if (!$curElem || !material) {
        return;
    }

    $curElem.setAttribute("opacity", ".7");

    // 辅助线
    guideGetInfo();
    // 事件绑定
    Z(media.tool.$designStage).on("mousemove",this.singleDragDoing,this);
    Z(media.tool.$designStage).on("mouseup mouseleave",this.singleDragDone,this);

    //设置当前拖拽对象
    this.dragMaterial = material;
},
// 单素材拖拽过程
singleDragDoing: function(event)
{
    Z.E.cancel(event);

    var material = this.dragMaterial || media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.getSvgElementByMid(material.mid);
    if (!this.startData.mouseLoc)
    {
        Z("g[id^=svgElementSon_]").removeAttr("opacity");
        Z(media.tool.$designStage).off("mousemove",this.singleDragDoing,this);
        Z(media.tool.$designStage).off("mouseup mouseleave",this.singleDragDone,this);
        this.dragMaterial = null;
        return;
    }

    var nowMouseLoc = getMouseLocation(event);
    this.doingData = {
        "x": (nowMouseLoc.x - this.startData.mouseLoc.x) / media.tool.showRatio,
        "y": (nowMouseLoc.y - this.startData.mouseLoc.y) / media.tool.showRatio,
    }
    if (this.doingData.x === 0 && this.doingData.y === 0) {
        return;
    }

    material.type = parseFloat(material.type);
    // 图片素材，特殊处理；为拖动至容器做准备，pointer-events：none
    if (material.type === 0 || material.type === 2) {
        var curElemClass = $curElem.getAttribute("class") || "";
        if (curElemClass && curElemClass.indexOf("imgDragging") === -1) {
            curElemClass = Z.S.trim(curElemClass) + " imgDragging";
            $curElem.setAttribute("class",curElemClass);
        } else if (!curElemClass) {
            $curElem.setAttribute("class","imgDragging");
        }
    }

    //transform，相关参数
    var x = this.startData.targData.x + this.doingData.x;
    var y = this.startData.targData.y + this.doingData.y;

    //更新素材坐标
    updateSvgLocation(x, y);

    //更新辅助线
    guideSetInfo();
    setToolStaticLoc();
},
// 单素材拖拽结束
singleDragDone: function()
{
    // 清除对齐辅助线
    Z(".guide-line").remove();

    // 去除半透明效果
    Z("g[id^=svgElementSon_]").removeAttr("opacity");

    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    var material = media.tool.tempMaterial || media.getCurMaterial();
    if (!$curElem || !material)
        return;

    // 图片素材，复原事件
    this.removeImgDraging(material, $curElem);

    // 更新素材存储
    updateMaterialSource();
    // 保存历史
    saveHistory();

    // 清除事件
    Z(media.tool.$designStage).off("mousemove",this.singleDragDoing,this);
    Z(media.tool.$designStage).off("mouseup mouseleave",this.singleDragDone,this);

    // 清空保存数据
    this.dragMaterial = null;
},

/** 1.3.2：素材组拖动 **/
// 素材组拖拽结束
groupDragStart: function(event)
{
    this.startData.mouseLoc = getMouseLocation(event);
    this.startData.targData =
    {
        "x": Z('#selection_tool').offsetLeft() / media.tool.showRatio,
        "y": Z('#selection_tool').offsetTop() / media.tool.showRatio,
    };
    this.startData.elemsData = (function()
    {
        var arr = [];
        var i, j, mid, $elem, transformList, x, y;
        for (i = 0;i < media.selectedList.length;i++){
            mid = media.selectedList[i];
            $elem = media.tool.getCurSvgElement(i);
            transformList = $elem.transform.baseVal;
            for (j = 0;j < transformList.length;j++){
                if (transformList[j].type === 2){
                    x = transformList[j].matrix.e;
                    y = transformList[j].matrix.f;
                    break;
                }
            }
            //显示半透明效果
            $elem.setAttribute("opacity", ".7");
            //保存数据
            arr.push({
                "index": i,
                "mid": mid,
                "left": x,
                "top": y,
            });
        }
        return arr;
    })();

    // 辅助线
    guideGetInfo();
    // 事件绑定
    Z(media.tool.$designStage).on("mousemove",this.groupDragDoing,this);
    Z(media.tool.$designStage).on("mouseup mouseleave",this.groupDragDone,this);
},
// 素材组拖拽过程
groupDragDoing: function(event)
{
    Z.E.cancel(event);
    var nowMouseLoc = getMouseLocation(event);
    this.doingData = {
        "x": (nowMouseLoc.x - this.startData.mouseLoc.x) / media.tool.showRatio,
        "y": (nowMouseLoc.y - this.startData.mouseLoc.y) / media.tool.showRatio,
    }
    if (this.doingData.x === 0 && this.doingData.y === 0) {
        return;
    }

    //辅助框展示
    var toolX = (this.startData.targData.x + this.doingData.x) * media.tool.showRatio;
    var toolY = (this.startData.targData.y + this.doingData.y) * media.tool.showRatio;
    Z("#selection_tool").css("left",toolX).css("top",toolY);

    var i, material, elemData, mLeft, mTop, $elem, trans;
    for (i = 0;i < this.startData.elemsData.length;i++)
    {
        elemData = this.startData.elemsData[i];
        mLeft = elemData.left + this.doingData.x;
        mTop = elemData.top + this.doingData.y;

        material = media.getCurMaterial(elemData.index);
        $elem = media.tool.getCurSvgElement(elemData.index);

        material.x = mLeft;
        material.y = mTop;
        //画布展示
        trans = $elem.getAttribute("transform");
        trans = trans.replace(/translate\([^)]+\)/,"translate(" + mLeft + " " + mTop + ")");
        $elem.setAttribute("transform",trans);
    }

    //拖动辅助线，对比信息，设置辅助线
    guideSetInfo();
},
// 素材组拖拽结束
groupDragDone: function()
{
    // 清除事件
    Z(media.tool.$designStage).off("mousemove",this.groupDragDoing,this);
    Z(media.tool.$designStage).off("mouseup mouseleave",this.groupDragDone,this);

    // 清除对齐辅助线
    Z(".guide-line").remove();
    var i, elemData, material, $elem;
    for (i = 0;i < this.startData.elemsData.length;i++)
    {// 拖动操作仅改变位移，直接更新source
        elemData = this.startData.elemsData[i];
        material = media.getCurMaterial(elemData.index);
        $elem = media.tool.getCurSvgElement(elemData.index);
        updateMaterialSource(material, $elem);
    }
    // 去除半透明效果
    Z("g[id^=svgElementSon_]").removeAttr("opacity");
    //保存历史
    saveHistory();
},

/** 1.4.1.1：单素材缩放 **/
// 单素材的缩放开始
singleZoomStart: function(event)
{
    var $targ = Z.E.target(event);
    if (!$targ.hasAttribute("data-type")) {
        return;
    }

    // 定义 this.startData
    var type = Z($targ).attr("data-type");
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    var $gWrap = $curElem.querySelector('g');
    var $svg = [...$gWrap.children].pop();
    if ($svg.innerHTML === ''){
        return;
    }

    var svgType = $svg.getAttribute("data-type");
    var elemData = media.tool.getEleData($curElem);
    this.startData.mouseLoc = getMouseLocation(event);
    this.startData.targData = Z.clone(elemData);
    this.startData.rectRatio = parseFloat(elemData.width) / parseFloat(elemData.height);
    this.startData.angle = $curElem.transform.baseVal[1].angle;
    this.startData.type = type;
    this.startData.axis = Z($targ).attr("data-axis");

    // 其他类型处理
    if (type === "r")
    {
        // 显示表格素材
        var className = $curElem.getAttribute("class") || "";
        if (svgType === "shape-table" && className.indexOf("hiddenDoing") > -1)
        {
            this.resetTableSvgElement();
            this.hideTableEditTool();
            this.showTableSvgElement();

            // 重定义数据
            elemData = media.tool.getEleData($curElem);
            this.startData.targData = Z.clone(elemData);
            this.startData.rectRatio = parseFloat(elemData.width) / parseFloat(elemData.height);
        }

        Z("#selection_tool>.rotate>span").html(Math.floor($curElem.transform.baseVal[1].angle) + "°");
        // 取得中心点坐标
        var transVal = $curElem.transform.baseVal;
        var px = this.startData.targData.x + this.startData.targData.width / 2;
        var py = this.startData.targData.y + this.startData.targData.height / 2;
        if (svgType === "shape-line"){
            px = this.startData.targData.x;
            py = this.startData.targData.y;
        }
        // 存在翻转
        if (transVal[2] && transVal[2].matrix){
            var a = transVal[2].matrix.a;
            var d = transVal[2].matrix.d;
            if (a === -1){
                px -= this.startData.targData.width;
            }
            if (d === -1){
                py -= this.startData.targData.height;
            }
        }
        this.startData.targData.px = px * media.tool.showRatio;
        this.startData.targData.py = py * media.tool.showRatio;
    }
    else
    {
        // 执行表格缩放
        if (svgType === "shape-table")
        {
            if (["e", "s", "w", "n"].includes(type))
                return this.tableZoomStart(event);
        }

        $curElem.querySelector("rect").setAttribute("width","1");
        $curElem.querySelector("rect").setAttribute("height","1");
    }
    // 事件绑定
    Z(media.tool.$designStage).on("mousemove",this.singleZoomDoing,this);
    Z(media.tool.$designStage).on("mouseup mouseleave",this.singleZoomDone,this);
},
// 单素材的缩放过程
singleZoomDoing: function (event)
{
    Z.E.cancel(event);
    // 判断鼠标左键是否按下状态（考虑特殊情况）
    if (event.button !== 0 || event.buttons === 0)
        return this.singleZoomDone();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();

    // 旋转的相对偏移量
    var mouseMetabolic = this.getTrueZoomMetabolic(event);
    if (mouseMetabolic.x === 0 && mouseMetabolic.y === 0) {
        return;
    }
    mouseMetabolic.x /= media.tool.showRatio;
    mouseMetabolic.y /= media.tool.showRatio;
    // 缩放变形
    switch (this.startData.type)
    {
        //东方向，右
        case "e": this.singleZoomCoordinateXY ($curElem, mouseMetabolic , "east"); break;
        //东南方向，右下
        case "se": this.singleZoomHypotenuse ($curElem, mouseMetabolic , "southEast"); break;
        //南方向，下
        case "s": this.singleZoomCoordinateXY ($curElem, mouseMetabolic , "south"); break;
        //西南南方向，左下
        case "sw": this.singleZoomHypotenuse($curElem, mouseMetabolic , "southWest"); break;
        //西方向，左
        case "w": this.singleZoomCoordinateXY ($curElem, mouseMetabolic , "west"); break;
        //西北方向，左上
        case "nw": this.singleZoomHypotenuse ($curElem, mouseMetabolic , "northWest"); break;
        //北方向，上
        case "n": this.singleZoomCoordinateXY ($curElem, mouseMetabolic , "north"); break;
        //东北方向，右上
        case "ne": this.singleZoomHypotenuse ($curElem, mouseMetabolic , "northEast"); break;
        //旋转角度
        case "r": this.singleZoomRotate ($curElem, getMouseLocation(event)); break;
    }
    // 更新缩放框位置
    setToolStaticLoc();
},
// 单素材的缩放结束
singleZoomDone: function ()
{
    // 重设文字素材，重新绘制
    function rePathText()
    {
        // 重新设置，校准偏移
        function resetTrans()
        {
            material.width = oldW / widthZoom;
            material.height = oldH / heightZoom;
            if(mediaEvent.startData.axis === "x") {                               //宽度修改
                widthZoom = setWidth / material.width;
            } else if(mediaEvent.startData.axis === "y") {                       //高度修改
                heightZoom = setHeight / material.height;
            }
            material.textZoom = widthZoom + " " + heightZoom;
            Z($curElem).attr("data-textzoom", material.textZoom);

            // 校准偏移
            editOverSet($curElem);
            // 更新数据
            updateMaterialSource();
            // 保存历史
            saveHistory();
        }
        // 调用AJAX插入最新的文字
        function resetPath()
        {
            var trueHeight = setHeight * mediaEvent.startData.targData.heightRatio;
            var fontSize = parseFloat((trueHeight * mediaEvent.startData.targData.sizeRatio).toFixed(2));
            var changeRatio = fontSize / mediaEvent.startData.targData.fontSize;

            // 素材参数
            material.width = setWidth / widthZoom;
            material.height = setHeight / heightZoom;
            material.fontSize = fontSize;
            material.letterSpacing *= changeRatio;
            material.singleHeight *= changeRatio;
            material.lineHeight *= changeRatio;
            material.mathHeight *= changeRatio;
            material.textY = 1000;
            for (var i = 0;i < material.wordsList.length;i++)
                material.wordsList[i].fontSize = fontSize;

            // 设置 data 属性
            setDataInSvg(material, $curElem);
            // 写入最新文字大小
            setFontSelectVal(fontSize, 'tool_fontSize');

            // 校准偏移
            editOverSet($curElem);
            // 重新绘制
            getPathAjax(material, $curElem);
        }

        // 1：文字缩放比，数组形式
        var textZoom = material.textZoom.split(" ");
        var widthZoom = parseFloat(textZoom[0]);
        var heightZoom = parseFloat(textZoom[1]);
        if (mediaEvent.startData.axis === "xy") {// 等比缩放操作
            resetPath();
        } else {
            resetTrans();
        }
    }
    // 重设素材的大小
    function resetElemSize()
    {
        // 设置辅助矩形大小
        $rect.setAttribute("width", setWidth + "");
        $rect.setAttribute("height", setHeight + "");

        // 文字素材类型，重新绘制
        if (material.type === 1)
        {
            rePathText();
        }
        // 表格单独处理
        // else if (material.isTable)
        //     mediaEvent.tableZoomDoneEqual();
        // 其他素材类型，直接保存
        else
        {
            if (svgType !== "shape-line")
                editOverSet($curElem);
            // 更新素材
            updateMaterialSource();
            saveHistory();
        }
    }

    // 1：清除事件
    Z(media.tool.$designStage).off("mousemove",this.singleZoomDoing,this);
    Z(media.tool.$designStage).off("mouseup mouseleave",this.singleZoomDone,this);

    // 2：取得素材对象
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    if (!material || !$curElem)
        return;

    // 3：角度旋转操作
    if (this.startData.type === "r")
    {
        //清空角度显示
        Z("#selection_tool>.rotate>span").html("");
        updateMaterialSource();
        //保存历史
        saveHistory();
    }

    // 4：重设素材大小
    var oldW = this.startData.targData.width;
    var oldH = this.startData.targData.height;
    var $rect = $curElem.querySelector("rect");
    var $gWrap = $curElem.querySelector('g');
    var $svg = [...$gWrap.children].pop();
    var svgType = $svg.getAttribute("data-type");
    var setWidth = $svg.width.baseVal.value;
    var setHeight = $svg.height.baseVal.value;
    resetElemSize();
},
// 表格缩放开始
tableZoomStart: function (event)
{
    Z.E.forbidden(event);
    var $curElem = media.tool.getCurSvgElement();
    var className = $curElem.getAttribute("class") || "";
    var tableTool = true;

    // 显示表格，隐藏素材
    var $tableEditor = Z("#tableEditor");
    if (className.indexOf("hiddenDoing") === -1)
    {
        tableTool = false;
        this.showTableEditTool();
        Z("#tableEditor").find("td").each(function($td)
        {
            var $div = $td.querySelector(".tableText-editArea");
            Z($td).attr("data-width", $div.offsetWidth);
            Z($td).attr("data-height", $div.offsetHeight);
        });
    }
    var $table = $tableEditor.find("table");

    this.startData.showTableTool = tableTool;
    this.startData.zoomed = false;
    this.startData.tableData =
    {
        left: $tableEditor[0].offsetLeft,
        top: $tableEditor[0].offsetTop,
        width: $table[0].offsetWidth,
        height: $table[0].offsetHeight,
    };
    var $selTool = Z.D.id("selection_tool");
    this.startData.selToolData =
    {
        left: $selTool.offsetLeft,
        top: $selTool.offsetTop,
        width: $selTool.offsetWidth,
        height: $selTool.offsetHeight,
    };

    // 事件绑定
    Z(media.tool.$designStage).on("mousemove",this.tableZoomDoing,this);
    Z(media.tool.$designStage).on("mouseup mouseleave",this.tableZoomDone,this);
},
// 表格缩放过程
tableZoomDoing: function ()
{
    Z.E.cancel(event);
    // 判断鼠标左键是否按下状态（考虑特殊情况）
    if (event.button !== 0 || event.buttons === 0)
        return this.tableZoomDone();

    // 旋转的相对偏移量
    var nowMouseLoc = getMouseLocation(event);
    var mouseMetabolic = {
        "x": (nowMouseLoc.x - this.startData.mouseLoc.x),
        "y": (nowMouseLoc.y - this.startData.mouseLoc.y),
    }
    if (mouseMetabolic.x === 0 && mouseMetabolic.y === 0) {
        return;
    }

    // 开始执行表格缩放
    this.startData.zoomed = true;
    var $tableEditor = Z("#tableEditor");
    var $table = $tableEditor.find("table");
    var type = this.startData.type;
    var angle = this.startData.angle * Math.PI / 180;
    var cosMath = Math.cos(angle);
    var sinMath = Math.sin(angle);
    var table_width = this.startData.tableData.width;
    var table_height = this.startData.tableData.height;
    var start_width = table_width;
    var start_height = table_height;
    var table_left = this.startData.tableData.left;
    var table_top = this.startData.tableData.top;
    var mx = 0, my = 0;

    // 计算尺寸
    if (type.indexOf("e") > -1)
        mx = cosMath * mouseMetabolic.x + sinMath * mouseMetabolic.y;
    if (type.indexOf("s") > -1)
        my = -sinMath * mouseMetabolic.x + cosMath * mouseMetabolic.y;
    if (type.indexOf("w") > -1)
        mx = - (cosMath * mouseMetabolic.x + sinMath * mouseMetabolic.y);
    if (type.indexOf("n") > -1)
        my = sinMath * mouseMetabolic.x - cosMath * mouseMetabolic.y;

    table_width += mx;
    table_height += my;

    // 计算偏移
    mx /= 2;
    my /= 2;
    var x1 = -mx, y1 = -my;
    if (type.indexOf("e") > -1)
    {
        x1 += mx * cosMath;
        y1 += mx * sinMath;
    }
    if (type.indexOf("s") > -1)
    {
        x1 -= my * sinMath;
        y1 += my * cosMath;
    }
    if (type.indexOf("w") > -1)
    {
        x1 -= mx * cosMath;
        y1 -= mx * sinMath;
    }
    if (type.indexOf("n") > -1)
    {
        x1 += my * sinMath;
        y1 -= my * cosMath;
    }

    table_left += x1;
    table_top += y1;

    // 定义属性
    $table.css("width", table_width).css("height", table_height);
    $tableEditor.css("left", table_left).css("top", table_top);

    // 选择框大小更新
    Z("#selection_tool").css({
        width: table_width + 2,
        height: table_height + 2,
        left: this.startData.selToolData.left + x1,
        top: this.startData.selToolData.top + y1,
    });
    // 缩放执行
    var mxHeight = (table_height - start_height) / start_height;
    var mxWidth = (table_width - start_width) / start_width;
    $table.find("td").each($td => {
        var tdHeight = parseFloat(Z($td).attr("data-height"));
        var tdWidth = parseFloat(Z($td).attr("data-width"));
        Z($td).find(".tableText-editArea").css("height", tdHeight + tdHeight * mxHeight)
            .css("width", tdWidth + tdWidth * mxWidth);
    });
},
// 表格缩放完成
tableZoomDone: function ()
{
    // 1：事件解除
    Z(media.tool.$designStage).off("mousemove",this.tableZoomDoing,this);
    Z(media.tool.$designStage).off("mouseup mouseleave",this.tableZoomDone,this);

    // 2：显示表格工具，直接返回
    if (this.startData.showTableTool)
        return;

    // 2：重新生成素材
    if (this.startData.zoomed)
        this.resetTableSvgElement();

    // 3：隐藏表格工具
    this.hideTableEditTool();

    // 4：显示素材
    this.showTableSvgElement();

    // 5：更新选择框
    selectTheElement();

    // 6：更新数据，保存历史
    updateMaterialSource();
    saveHistory();
},

/** 1.4.1.2：素材组缩放 **/
// 素材组的缩放开始
groupZoomStart: function(event)
{
    var $targ = Z.E.target(event);
    if (!$targ.hasAttribute("data-type") || Z($targ).attr("data-axis") !== "xy") {
        return;
    }
    if (!Z("#selection_tool").hasClass("groupTool")) {
        return;
    }
    var $tool = Z.D.id('selection_tool');
    var toolRect = $tool.getBoundingClientRect();
    var canvasRect = media.tool.$canvasBg.getBoundingClientRect();
    this.startData.mouseLoc = getMouseLocation(event);
    this.startData.type = Z($targ).attr("data-type");
    this.startData.rectRatio = $tool.offsetWidth / $tool.offsetHeight;
    this.startData.targData =
    {
        "width": toolRect.width,
        "height": toolRect.height,
        "x": $tool.offsetLeft,
        "y": $tool.offsetTop,
        "xSp": toolRect.left - canvasRect.left,
        "ySp": toolRect.top - canvasRect.top,
    };
    this.startData.elemsData = (function(obj)
    {
        var showRatio = media.tool.showRatio;
        var dataArr = [];
        var textElemNum = 0;
        var i, mid, $gElem, material, $svgElem, trueHeight, elemData;
        for (i = 0;i < media.selectedList.length;i++)
        {
            mid = media.selectedList[i];
            $gElem = media.tool.getSvgElementByMid(mid);
            material = media.getMaterialByMid(mid);
            $svgElem = $gElem.querySelector("svg");
            trueHeight = $svgElem.getBBox().height;
            elemData = {
                "mid": mid,
                "index": i,
                "x": $gElem.transform.baseVal[0].matrix.e - obj.startData.targData.xSp / showRatio,
                "y": $gElem.transform.baseVal[0].matrix.f - obj.startData.targData.ySp / showRatio,
                "width": $svgElem.width.baseVal.value,
                "height": $svgElem.height.baseVal.value,
            };
            if (parseFloat(material.type) === 1)
            {//如果是文字素材，存储字体大小
                textElemNum++;
                elemData.fontSize = parseFloat(material.fontSize);
                elemData.heightRatio = trueHeight / obj.startData.targData.height * showRatio;
                elemData.sizeRatio = elemData.fontSize / trueHeight;
            }
            dataArr.push(elemData);
        }
        obj.startData.textElemNum = textElemNum;
        return dataArr;
    })(this);

    // 事件绑定
    Z(media.tool.$designStage).on("mousemove",this.groupZoomDoing,this);
    Z(media.tool.$designStage).on("mouseup mouseleave",this.groupZoomDone,this);
},
// 素材组的缩放过程
groupZoomDoing: function(event)
{
    Z.E.cancel(event);
    var nowMouseLoc = getMouseLocation(event);
    var mouseMetabolic = {
        "x": nowMouseLoc.x - this.startData.mouseLoc.x,
        "y": nowMouseLoc.y - this.startData.mouseLoc.y
    };
    if (mouseMetabolic.x === 0 && mouseMetabolic.y === 0) {
        return;
    }

    var mw, mh;
    var mx = this.startData.targData.x;
    var my = this.startData.targData.y;
    var zoomType = this.startData.type;
    if (this.startData.rectRatio > 1)
    {
        if (zoomType === "se" || zoomType === "ne") {
            mw = this.startData.targData.width + mouseMetabolic.x;
        } else if (zoomType === "sw" || zoomType === "nw") {
            mw = this.startData.targData.width - mouseMetabolic.x;
        }
        mh = mw / this.startData.rectRatio;
    }
    else
    {
        if (zoomType === "se" || zoomType === "sw") {
            mh = this.startData.targData.height + mouseMetabolic.y;
        } else {
            mh = this.startData.targData.height - mouseMetabolic.y;
        }
        mw = mh * this.startData.rectRatio;
    }
    var changeRatio = (mw / this.startData.targData.width + mh / this.startData.targData.height) / 2;
    changeRatio = (changeRatio > 0)?(changeRatio):(0);

    if (zoomType === "sw" || zoomType === "nw") {
        mx += this.startData.targData.width - mw;
    }
    if (zoomType === "ne" || zoomType === "nw") {
        my += this.startData.targData.height - mh;
    }
    Z("#selection_tool").css(
    {
        "width": mw,
        "height": mh,
        "left": mx,
        "top": my
    });

    // 处理素材数据
    this.groupZoomCoordinateXY(changeRatio, zoomType);
},
// 素材组的缩放结束
groupZoomDone: function()
{
    // 清除事件
    Z(media.tool.$designStage).off("mousemove",this.groupZoomDoing,this);
    Z(media.tool.$designStage).off("mouseup mouseleave",this.groupZoomDone,this);

    // 执行保存操作
    var groupTextNum = this.startData.textElemNum;
    var groupTextDoneNum = 0;
    var groupRect = Z.D.id('selection_tool').getBoundingClientRect();
    var i = 0, elemData = null, material = null, $curElem = null, $svg = null, changeRatio = 1;

    // 循环，更新处理每个素材
    for (i = 0;i < this.startData.elemsData.length;i++)
    {
        elemData = this.startData.elemsData[i];
        material = media.getCurMaterial(elemData.index);
        $curElem = media.tool.getCurSvgElement(elemData.index);
        material.type = parseFloat(material.type);

        // 文字缩放，改变字体大小
        if (material.type === 1)
		{
		    var textZoom = "", trueHeight = 0, fontSize = 0, dataFontsize = "";
            var $gWrap = $curElem.querySelector('g');
            $svg = [...$gWrap.children].pop();
            textZoom = material.textZoom.split(" ");
            trueHeight = (groupRect.height / media.tool.showRatio) * elemData.heightRatio;
            fontSize = parseFloat((trueHeight * elemData.sizeRatio).toFixed(2));
            changeRatio = fontSize / elemData.fontSize;

            // 页面呈现，字体大小
            material.width = $svg.width.baseVal.value / parseFloat(textZoom[0]);
            material.height = $svg.height.baseVal.value / parseFloat(textZoom[1]);
            material.fontSize = fontSize;
            material.letterSpacing *= changeRatio;
            material.singleHeight *= changeRatio;
            material.lineHeight *= changeRatio;
            material.mathHeight *= changeRatio;
            material.textY = fontSize * .830512523651123;
            dataFontsize = material.fontSize;
            media.canvas.createMode = parseFloat(media.canvas.createMode);
            if (media.canvas.createMode === 0) {
                dataFontsize += "pt";
            } else {
                dataFontsize += "px";
            }
            $curElem.setAttribute("data-fontsize", dataFontsize);
            $curElem.setAttribute("data-letterspacing", material.letterSpacing);
            $curElem.setAttribute("data-singleheight", material.singleHeight);
            $curElem.setAttribute("data-mathheight", material.mathHeight);
            $curElem.setAttribute("data-lineheight", material.lineHeight);
            getPathAjax(material, $curElem, 1, 1, function(material, $curElem)
            {
                groupTextDoneNum++;
                updateMaterialSource(material, $curElem);
                if (groupTextDoneNum === groupTextNum)
                {
                    // 重新选中框定位
                    selectionToolsShow_group();
                    saveHistory();
                }
            });
        }
        // 表格缩放
        // else if (material.isTable)
        //     this.tableZoomDoneEqual(material, $curElem);
        // 其他
        else
            updateMaterialSource(material, $curElem);
    }
},

/** 1.4.2：文本编辑框缩放 **/
// 文本编辑框缩放开始
editorResizeStart: function (event)
{
    Z.E.forbidden(event);
    var $editor = Z.D.id("textEditorWrap");
    var editorStyle = window.getComputedStyle($editor, null);
    var angle = 0;
    var trans;
    if (trans = $editor.style.transform){
        if (/.*rotate\([^)]+\).*/.test(trans)) {
            angle = parseFloat(trans.replace(/.*rotate\(([^)]+)\).*/, "$1"));
        }
    }
    this.startData.mouseLoc = getMouseLocation(event);
    this.startData.type = event.target.getAttribute("data-type");
    this.startData.angle = angle;
    this.startData.targData = {
        "width" : parseFloat(0 + editorStyle.width) ? parseFloat(0 + editorStyle.width) : $editor.offsetWidth,
        "left" : parseFloat(0 + editorStyle.left) ? parseFloat(0 + editorStyle.left) : $editor.offsetLeft,
        "top" : parseFloat(0 + editorStyle.top) ? parseFloat(0 + editorStyle.top) : $editor.offsetTop,
    };

    // 事件绑定
    Z(media.tool.$designStage).on("mousemove",this.editorResizeDoing,this);
    Z(media.tool.$designStage).on("mouseup mouseleave",this.editorResizeDone,this);
},
// 文本编辑框缩放过程
editorResizeDoing: function (event)
{
    var nowMouseLoc = getMouseLocation(event);
    var mouseMetabolic = {
        "x": nowMouseLoc.x - this.startData.mouseLoc.x,
        "y": nowMouseLoc.y - this.startData.mouseLoc.y
    };
    if (mouseMetabolic.x === 0 && mouseMetabolic.y === 0) {
        return;
    }

    var material = this.textMaterial || media.getCurMaterial();
    var textZoomArr = material.textZoom.split(" ");
    var mx = mouseMetabolic.x / parseFloat(textZoomArr[0]);

    var setWidth = this.startData.targData.width;
    var setLeft = this.startData.targData.left;
    var setTop = this.startData.targData.top;
    switch (this.startData.type){
        case "e":
            setWidth += mx;
            break;
        case "w":
            var angle = this.startData.angle * Math.PI / 180;
            setWidth -= mx;
            setLeft += mx * Math.cos(angle);
            setTop += mx * Math.sin(angle);
            break;
    }
    setWidth += "px";
    Z("#textEditor").css({
        "width": setWidth,
    });
    Z("#textEditorWrap").css({
        "left": setLeft,
        "top": setTop,
    });
},
// 文本编辑框缩放结束
editorResizeDone: function ()
{
    // 清除事件
    Z(media.tool.$designStage).off("mousemove",this.editorResizeDoing,this);
    Z(media.tool.$designStage).off("mouseup mouseleave",this.editorResizeDone,this);
},

/** 1.5：形状绘制 **/
// 形状绘制开始
drawShapeStart: function(event)
{
    this.startData.mouseLoc = getMouseLocation(event);
    this.doingData = {
        "mouseLoc": {"x": 0, "y": 0},
    };
    var canvasRect = media.tool.$canvasBg.getBoundingClientRect();
    var setX = (this.startData.mouseLoc.x - canvasRect.left) / media.tool.showRatio;
    var setY = (this.startData.mouseLoc.y - canvasRect.top) / media.tool.showRatio;
    this.startData.targData = {
        "x": setX,
        "y": setY,
    }
    if (!Z.D.id("tempShape")) {
        shapeDrawReady();
    }
    Z.D.id("tempShape").setAttribute("transform","translate(" + setX + " " + setY + ") rotate(0 0 0)");
    // 事件绑定
    Z(media.tool.$designStage).on("mousemove",this.drawShapeDoing,this);
    Z(media.tool.$designStage).on("mouseup mouseleave",this.drawShapeDone,this);
},
// 形状绘制过程
drawShapeDoing: function(event)
{
    Z.E.forbidden(event);
    var nowMouseLoc = getMouseLocation(event);
    this.doingData.mouseLoc.x = (nowMouseLoc.x - this.startData.mouseLoc.x) / media.tool.showRatio;
    this.doingData.mouseLoc.y = (nowMouseLoc.y - this.startData.mouseLoc.y) / media.tool.showRatio;
    switch (this.shapeType) {
        case "1":
            this.drawingLine(event);
            break;
        case "2":
        case "3":
            this.drawingRect(event);
            break;
        case "4":
            this.drawingEllipse(event);
            break;
    }
},
// 形状绘制结束
drawShapeDone: function()
{
    // 清除事件
    Z(media.tool.$designStage).off("mousemove",this.drawShapeDoing,this);
    Z(media.tool.$designStage).off("mouseup mouseleave",this.drawShapeDone,this);
    if (this.shapeType === '1') {
        if (this.doingData.mouseLoc.x === 0 && this.doingData.mouseLoc.y === 0) {
            Z("#tempShape").remove();
        }
    } else {
        if (this.doingData.mouseLoc.x === 0 || this.doingData.mouseLoc.y === 0) {
            Z("#tempShape").remove();
        }
    }
    if (!Z.D.id("tempShape")) {
        return;
    }
    // 添加素材
    var $curElem = Z.D.id("tempShape");
    $curElem.removeAttribute("id");
    var $gSvg = $curElem.querySelector("g");
    var $svg = $gSvg.querySelector("svg");
    var dataType;
    switch(this.shapeType)
    {
        case "1": dataType = "shape-line";break;
        case "2": dataType = "shape-rect";break;
        case "3":
            dataType = "shape-rectStroke";
            $svg.setAttribute("data-rectstroke","5");
            break;
        case "4": dataType = "shape-ellipse";break;
    }
    $svg.setAttribute("data-type",dataType);
    var svgCode = $curElem.outerHTML;

    var setWidth = $svg.getAttribute("width");
    var setHeight = $svg.getAttribute("height");
    var $rect = document.createElementNS(xmlns, "rect");
    $rect.setAttribute("fill","rgba(0,0,0,0)");
    $rect.setAttribute("width",setWidth);
    $rect.setAttribute("height",setHeight);
    $curElem.insertBefore($rect,$gSvg);
    var tempMaterial = {
        "type": 5,
        "source": svgCode,
        "color": "#000000",
    }
    var material = newMediaMaterial(tempMaterial);
    media.addMaterial(material);
    $curElem.setAttribute("id","svgElementSon_" + material.mid);
    $curElem.setAttribute("data-mid",material.mid);
    $curElem.setAttribute("data-pos",material.mid);
    var tempTrans = $curElem.getAttribute("transform");
    if (this.shapeType !== '1'){
        tempTrans = tempTrans.replace(/rotate(\s*)?\(([^)]+)\)/,"rotate(0 "+ setWidth/2 +" "+ setHeight/2 +")")
    }
    $curElem.removeAttribute("transform");
    $curElem.setAttribute("transform",tempTrans);
    // 事件绑定
    media.tool.addEleEvents($curElem);
    // 选中该素材
    selectTheElement(material, $curElem);
    saveHistory();
    // 结束绘制
    shapeDrawStop();
},

/** 1.6：钢笔工具的绘制 **/
// 钢笔工具，绘制开始；判断绘制类型
penDrawStart: function (event)
{
    // 初始化新切线
    function initNewTangent()
    {
        var wrapRect = $tangentWrap.getBoundingClientRect();
        var transX = nowLoc.x - wrapRect.left;
        var transY = nowLoc.y - wrapRect.top;

        // 隐藏所有切线
        Z($tangentWrap).find('.penTangent-item').removeClass('active');
        // 添加新切线
        $newTangent = Z(newTangentString);
        Z($tangentWrap).append($newTangent);
        $newTangent.attr('data-index', tangentLength);

        $newTangent.css({
            'left' : transX * 100 / wrapRect.width + '%',
            'top' : transY * 100 / wrapRect.height + '%',
        });

        var canvasRect = media.tool.$canvasBg.getBoundingClientRect();
        var pointX = nowLoc.x - canvasRect.left;
        var pointY = nowLoc.y - canvasRect.top;
        var newPoint = pointX / showRatio + ',' + pointY / showRatio;
        // 初始化新曲线
        if (firstStart) {
            setD = 'M' + newPoint;
        }
        setD += ' C' + newPoint + ' ' + newPoint + ' ' + newPoint;
        $tempPath.setAttribute('d', setD);
    }
    // 第一次绘制，添加样式
    function firstStartStyle()
    {
        if (setD !== 'M0,0') {
            return firstStart = false;
        }
        Z($tangentWrap).addClass('active');
        var $canvas = media.tool.$canvasSvg;
        var canvasViewBox = $canvas.viewBox.baseVal;
        var canvasWidth = canvasViewBox.width;
        var canvasHeight = canvasViewBox.height;
        $tempSvg.setAttribute('viewBox', '0 0 ' + canvasWidth + ' ' + canvasHeight);
        $tempSvg.setAttribute('width', canvasWidth + '');
        $tempSvg.setAttribute('height', canvasHeight + '');

        // 定义 $tempPath
        mediaEvent.startData.$tempPath = $tempPath;
    }

    // 0：判断是否执行绘制
    // 按钮状态
    var $liActive = Z('.side_containerList > .active');
    if (!$liActive[0]){
        return;
    } else if ($liActive.attr('data-type') !== '11')
        return;
    // 两次点击间隔
    if (this.startData.timeStamp)
    {
        var mStamp = event.timeStamp - this.startData.timeStamp;
        if (mStamp <= 300){
            return this.startData.timeStamp = event.timeStamp;
        }
    }

    // 1：主方法，定义变量
    var nowLoc = getMouseLocation(event);
    var showRatio = media.tool.showRatio;
    var $tangentWrap = Z.D.id('penTangentTool');
    var $tempShape = Z.D.id('tempShape');
    var $$tangentItem = $tangentWrap.querySelectorAll('.penTangent-item');
    var tangentLength = $$tangentItem.length;
    var $tempSvg = $tempShape.querySelector('svg');
    var $tempPath = $tempSvg.querySelector('path');
    var setD = $tempPath.getAttribute('d');
    var firstStart = true;
    var $newTangent = null;

    // 2：判断第一次绘制
    firstStartStyle();

    // 3：初始化新切线
    initNewTangent();

    // 4：保存数据 startData
    this.startData.mouseLoc = nowLoc;
    this.startData.timeStamp = event.timeStamp;
    this.startData.allTangent = $tangentWrap.querySelectorAll('.penTangent-item');
    this.startData.tangentIndex = tangentLength;

    // 5：绘制曲线
    if (!firstStart)
        return;

    // 6：事件绑定
    this.initPenEditHistory();
    Z('#penEditorCover').on("mouseup",this.penDrawTangentDone,this)
        .on("mousemove",this.penDrawDoing,this)
        .on("dblclick",this.penDrawDone,this);
    Z(media.tool.$designStage).on("mouseleave",this.penDrawDone,this);
    $newTangent.addClass('item-drawDone').on('mousedown', this.penDrawDone, this);
},
// 钢笔工具，绘制过程
penDrawDoing: function (event)
{
    // 1：分情况处理
    if (event.buttons === 1) {
        this.penDrawTangentDoing(event);
    } else if (event.buttons === 0) {
        this.penDrawCurveDoing(event);
    }
},
// 钢笔工具，绘制切线过程
penDrawTangentDoing: function (event)
{
    // 计算切线的偏移
    function setTangent()
    {
        var setHypotenuse = Math.sqrt(Math.pow(mouseMetabolic.x, 2) + Math.pow(mouseMetabolic.y, 2));
        var transAngle = Math.atan(mouseMetabolic.y / mouseMetabolic.x) * 180 / Math.PI;
        if (mouseMetabolic.x < 0)
            transAngle += 180;
        var setRotate = 'rotate('+ transAngle +'deg)';
        if (!Z($tangentItem).hasClass('active')){
            Z($tangentItem).addClass('active');
        }
        // 旋转角度
        Z($prevItem).css({
            'transform': 'translate(calc(-100% + 5.5px), 0) ' + setRotate,
        });
        Z($nextItem).css({
            'transform': 'translate(5.5px, 0) ' + setRotate,
        });
        // 切线长度
        Z($prevItem).css({
            'width': setHypotenuse,
        });
        Z($nextItem).css({
            'width': setHypotenuse,
        });
    }
    // 切线大小，改变前一个贝塞尔曲线的弧度
    function  setPreBezier()
    {
        if (mediaEvent.startData.allTangent.length === 1){
            return;
        }
        var $tempPath = mediaEvent.startData.$tempPath;
        var setD = $tempPath.getAttribute('d');
        var lastBezier = setD.match(/C([^C]+)(\sC[^C]+)$/);
        var getBezier = lastBezier[1].split(' ');
        var getPoint = getBezier[2].split(',');
        var setPointX = parseFloat(getPoint[0]) - mouseMetabolic.x / showRatio;
        var setPointY = parseFloat(getPoint[1]) - mouseMetabolic.y / showRatio;
        var setPoint = setPointX + ',' + setPointY;
        setD = setD.replace(/[^C]+\sC[^C]+$/, '');
        setD += getBezier[0] + ' ' + setPoint + ' ' + getBezier[2] +
            lastBezier[2];
        $tempPath.setAttribute('d', setD);
    }

    // 主方法，定义变量
    var nowMouseLoc = getMouseLocation(event);
    var showRatio = media.tool.showRatio;
    var mouseMetabolic = {
        "x": nowMouseLoc.x - this.startData.mouseLoc.x,
        "y": nowMouseLoc.y - this.startData.mouseLoc.y,
    };
    var itemIndex = this.startData.tangentIndex;
    var $tangentItem = this.startData.allTangent[itemIndex];
    var $prevItem = $tangentItem.querySelector('.penTangent-item-prev');
    var $nextItem = $tangentItem.querySelector('.penTangent-item-next');

    // 1：切线偏移
    setTangent();

    // 2：调整贝塞尔曲线
    setPreBezier();
},
// 钢笔工具，绘制切线结束
penDrawTangentDone: function (event)
{
    // 1：定义变量
    var showRatio = media.tool.showRatio;
    var nowMouseLoc = getMouseLocation(event);
    var toolRect = media.tool.$canvasBg.getBoundingClientRect();
    var mouseMetabolic = {
        "x": (nowMouseLoc.x - toolRect.left) / showRatio,
        "y": (nowMouseLoc.y - toolRect.top) / showRatio,
    };

    // 2：切线节点
    var $tempPath = this.startData.$tempPath;
    var setD = $tempPath.getAttribute('d');
    var fromPoint = mouseMetabolic.x + ',' + mouseMetabolic.y;
    setD = setD.replace(/[^C]+$/, '');
    setD += fromPoint + ' ' + fromPoint + ' ' + fromPoint;
    $tempPath.setAttribute('d', setD);

    // 3：保存历史记录
    this.savePenEditHistory();
},
// 钢笔工具，绘制曲线过程
penDrawCurveDoing: function (event)
{
    // 主方法，定义变量
    var showRatio = media.tool.showRatio;
    var $current = Z.E.target(event);
    var nowMouseLoc = getMouseLocation(event);
    var canvasRect = media.tool.$canvasBg.getBoundingClientRect();
    var mouseMetabolic = {
        "x": (nowMouseLoc.x - canvasRect.left) / showRatio,
        "y": (nowMouseLoc.y - canvasRect.top) / showRatio,
    };

    // 1：设置曲线
    var $tempPath = Z('#tempShape path')[0];
    var setD = $tempPath.getAttribute('d');
    var $doneBtn = Z('.item-drawDone .penTangent-item-this .penTangent-item-btn')[0];
    if ($current === $doneBtn)
    {
        var startPoint = /M([^C\s]+)/.exec(setD)[1];
        var startPointArr = startPoint.split(',');
        var startPointX = parseFloat(startPointArr[0]);
        var startPointY = parseFloat(startPointArr[1]);

        var firstBezier = /C([^C]+)/.exec(setD);
        var firstTangent = firstBezier[1].split(' ')[0];
        var firstTangentArr = firstTangent.split(',');
        var firstTangentX = parseFloat(firstTangentArr[0]);
        var firstTangentY = parseFloat(firstTangentArr[1]);
        var pointX = startPointX * 2 - firstTangentX;
        var pointY = startPointY * 2 - firstTangentY;

        setD = setD.replace(/[^C\s]+\s[^C\s]+(\sZ)?$/, '');
        setD += pointX + ',' + pointY + ' ' + startPoint + ' Z';
    } else {
        var toPoint = mouseMetabolic.x + ',' + mouseMetabolic.y;
        setD = setD.replace(/[^C\s]+\s[^C\s]+(\sZ)?$/, '');
        setD += toPoint + ' ' + toPoint;
    }
    $tempPath.setAttribute('d', setD);
},
// 钢笔绘制完成
penDrawDone: function (event)
{
    // 分情况处理，设置最终的临时素材路径
    function setTheTempPath()
    {
        var startPoint = /M([^C\s]+)/.exec(setD)[1];
        var startPointArr = startPoint.split(',');
        var startPointX = parseFloat(startPointArr[0]);
        var startPointY = parseFloat(startPointArr[1]);
        var firstBezier = /C([^C]+)/.exec(setD);
        if (!firstBezier || !firstBezier[1])
            return false;
        var firstTangent = firstBezier[1].split(' ')[0];
        var firstTangentArr = firstTangent.split(',');
        var firstTangentX = parseFloat(firstTangentArr[0]);
        var firstTangentY = parseFloat(firstTangentArr[1]);
        pointX = startPointX * 2 - firstTangentX;
        pointY = startPointY * 2 - firstTangentY;

        if (eventType === 'mousedown')
        {
            if (/\sZ$/.test(setD))
            {
                setD = setD.replace(/[^C\s]+\s[^C\s]+\sZ$/, '');
                setD += pointX + ',' + pointY + ' ' + startPoint;
            }
        }
        else
        {
            setD = setD.replace(/\sC[^C]+$/, '');
            var lastBezier = /C([^C]+)\s?Z?$/.exec(setD);
            if (!lastBezier || !lastBezier[1])
                return false;
            var lastPoint = lastBezier[1].split(' ')[2];
            setD += ' C' + lastPoint + ' ' + startPoint + ' ' + startPoint;
        }
        if (!/\sZ$/.test(setD))
            setD += ' Z';
        $tempPath.setAttribute('d', setD);
        return true;
    }
    // 检测触发 mouseleave 是否合法
    function checkMouseleave()
    {
        if (eventType !== 'mouseleave')
            return true;
        var mouseLoc = getMouseLocation(event);
        var stageRect = media.tool.$designStage.getBoundingClientRect();
        if (mouseLoc.x > stageRect.left && mouseLoc.x < stageRect.left + stageRect.width)
            return false;
        return true;
    }

    // 主方法，定义变量
    Z.E.forbidden(event);
    var eventType = event.type;
    var $tempPath = Z('#tempShape path')[0];
    var setD = $tempPath.getAttribute('d');
    var pointX, pointY;

    // 1：如果是 mouseleave 判断鼠标是否真的离开编辑区域
    if (!checkMouseleave())
        return;

    // 2：设置最终的临时素材路径
    if (!setTheTempPath())
        return mediaEvent.penDrawCancel();

    // 3：添加进素材列表
    mediaEvent.tempToPenMaterial();

    // 4：结束绘制
    mediaEvent.penDrawCancel();

    // 5：选中该素材，并保存
    selectTheElement(this.elemEditToolData.material, this.elemEditToolData.$curElem);
    saveHistory();

    // 6：清空数据
    this.clearPenEditHistory();
    this.elemEditToolData = {};
},
// 钢笔绘制取消
penDrawCancel: function()
{
    // 1：结束绘制
    shapeDrawStop();

    // 2：清除临时对象
    mediaEvent.startData.mouseLoc = null;
    mediaEvent.startData.targData = null;
    mediaEvent.startData.allTangent = null;
    mediaEvent.startData.$tempPath = null;
    mediaEvent.clearPenEditHistory();

    // 3：清除事件
    Z('#penEditorCover').off("mouseup",mediaEvent.penDrawTangentDone,mediaEvent)
        .off("mousemove",mediaEvent.penDrawDoing,mediaEvent)
        .off("dblclick",mediaEvent.penDrawDone,mediaEvent);
    Z(media.tool.$designStage).off("mouseleave",mediaEvent.penDrawDone,mediaEvent);
},

/*********************************************
 ************* 2.1.1: 缩放细节 ***************
 ********************************************/
/** 单个缩放 XY 坐标方向 **/
singleZoomCoordinateXY: function ($curElem, mouseMetabolic, type)
{
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $gSvg = $curElem.querySelector("g");
    var $$svg = $gSvg.children;
    var svgLength = $$svg.length;
    var $svg = $$svg[svgLength - 1];
    var svgType = $svg.getAttribute("data-type");

    // 计算素材 宽高 属性
    var setWidth = this.startData.targData.width;
    var setHeight = this.startData.targData.height;
    if (type === "east" || type === "west")
    {
        switch (type) {
            case "east": setWidth = this.startData.targData.width + mouseMetabolic.x; break;
            case "west": setWidth = this.startData.targData.width - mouseMetabolic.x; break;
        }
        setWidth = setWidth > 0 ? setWidth : 1;
        material.width = setWidth;
    }
    else
    {
        switch (type) {
            case "south": setHeight = this.startData.targData.height + mouseMetabolic.y; break;
            case "north": setHeight = this.startData.targData.height - mouseMetabolic.y; break;
        }
        setHeight = setHeight > 0 ? setHeight : 1;
        material.height = setHeight;
    }

    // 设置素材 宽高 属性
    if (svgType === "shape-line")
    {
        $svg.setAttribute("viewBox","0 0 " + setWidth + " " + setHeight);
        var $line = $svg.querySelector("line");
        var lineCap = $line.getAttribute("stroke-linecap");
        var setX1, setX2;
        switch (lineCap) {
            case "butt": // 方角
                setX1 = 0;
                setX2 = setWidth;
                break;
            case "round": // 圆角
                setX1 = setHeight / 2;
                setX2 = setWidth - setHeight / 2;
                break;
        }
        $line.setAttribute("x1",setX1);
        $line.setAttribute("x2",setX2);
        $line.setAttribute("y1",setHeight/2 + "");
        $line.setAttribute("y2",setHeight/2 + "");
        $line.setAttribute("stroke-width",setHeight);
    }
    else if (svgType === "shape-rect" || svgType === "shape-rectStroke" || svgType === "shape-ellipse")
    {
        var viewWidth = $svg.viewBox.baseVal.width;
        var viewHeight = $svg.viewBox.baseVal.height;
        var viewRatio;
        if (type === "east" || type === "west") {
            viewRatio = viewHeight / this.startData.targData.height;
            viewWidth = viewRatio * setWidth;
        } else {
            viewRatio = viewWidth / this.startData.targData.width;
            viewHeight = viewRatio * setHeight;
        }
        var drawDone;
        if (svgType === "shape-rect")
        {
            drawDone = this.drawRectResize($svg,viewWidth,viewHeight);
            if(!drawDone){
                setWidth = parseFloat($svg.getAttribute("width"));
                setHeight = parseFloat($svg.getAttribute("height"));
            } else {
                $svg.setAttribute("viewBox","0 0 " + viewWidth + " " + viewHeight);
            }
        }
        else if (svgType === "shape-rectStroke")
        {
            drawDone = this.drawRectStrokeResize($svg,viewWidth,viewHeight);
            if(!drawDone){
                setWidth = parseFloat($svg.getAttribute("width"));
                setHeight = parseFloat($svg.getAttribute("height"));
            } else {
                $svg.setAttribute("viewBox","0 0 " + viewWidth + " " + viewHeight);
            }
        }
        else if (svgType === "shape-ellipse")
        {
            $svg.setAttribute("viewBox","0 0 " + viewWidth + " " + viewHeight);
            var $ellipse = $svg.querySelector("ellipse");
            var stroke = parseFloat($ellipse.getAttribute("stroke-width"));
            $ellipse.setAttribute("cy",viewHeight/2 + "");
            $ellipse.setAttribute("cx", viewWidth/2 + "");
            $ellipse.setAttribute("ry",viewHeight/2 - stroke/2 + "");
            $ellipse.setAttribute("rx", (viewWidth/2 - stroke/2) + "");
        }
    }
    var $svgElem, i;
    for (i = 0;i < svgLength;i++) {
        $svgElem = $$svg[i];
        $svgElem.setAttribute("width", setWidth + '');
        $svgElem.setAttribute("height", setHeight + '');
    }

    // 设置素材 偏移 属性
    if (type === "west" || type === "north")
    {
        var angle = (this.startData.angle || $curElem.transform.baseVal[1].angle || 0 ) * Math.PI / 180;
        var mx = setWidth - this.startData.targData.width;
        var my = setHeight - this.startData.targData.height;
        var setTrans = $curElem.getAttribute("transform");
        var tx, ty;
        if (type === "west") {
            tx = this.startData.targData.x - Math.cos(angle) * mx;
            ty = this.startData.targData.y - Math.sin(angle) * mx;
        } else {
            tx = this.startData.targData.x + Math.sin(angle) * my;
            ty = this.startData.targData.y - Math.cos(angle) * my;
        }
        // 设置属性
        setTrans = setTrans.replace(/translate\([^)]+\)/, "translate("+ tx + " " + ty + ")");
        $curElem.setAttribute("transform", setTrans);
    }

    // 判断翻转
    if (material.reversal !== "1 1")
    {
        var reversalArr = material.reversal.split(" ");
        var transX = 0, transY = 0;
        var trans = $gSvg.getAttribute("transform");
        if (reversalArr[0] === "-1"){
            transX = setWidth;
        }
        if (reversalArr[1] === "-1"){
            transY = setHeight;
        }
        trans = trans.replace(/translate\([^)]+\)/, "translate(" + transX + " " + transY + ")");
        $gSvg.setAttribute("transform", trans);
    }
},
/** 单个缩放 斜边 对角方向 **/
singleZoomHypotenuse: function ($curElem, mouseMetabolic, type)
{
    var $gSvg = $curElem.querySelector("g");
    var $$svg = $gSvg.children;
    var svgLength = $$svg.length;

    // 计算等比缩放大小
    var setWidth, setHeight;
    if (this.startData.rectRatio >= 1)
    {
        if (type.indexOf("East") > -1) {
            setWidth = this.startData.targData.width + mouseMetabolic.x;
        } else {
            setWidth = this.startData.targData.width - mouseMetabolic.x;
        }
        setWidth = setWidth > 1 ? setWidth : 1;
        setHeight = setWidth / this.startData.rectRatio;
    }
    else
    {
        if (type.indexOf("south") > -1) {
            setHeight = this.startData.targData.height + mouseMetabolic.y;
        } else {
            setHeight = this.startData.targData.height - mouseMetabolic.y;
        }
        setHeight = setHeight > 1 ? setHeight : 1;
        setWidth = setHeight * this.startData.rectRatio;
    }

    // 计算偏移属性
    var transVal = $curElem.transform.baseVal;
    var angle = (this.startData.angle || transVal[1].angle || 0 ) * Math.PI / 180;
    var mx = setWidth - this.startData.targData.width;
    var my = setHeight - this.startData.targData.height;
    var tx, ty, setTrans = $curElem.getAttribute("transform");
    switch (type)
    {
        case "southWest":
            tx = this.startData.targData.x - Math.cos(angle) * mx;
            ty = this.startData.targData.y - Math.sin(angle) * mx;
            break;
        case "northWest":
            var hypotenuse = Math.sqrt(Math.pow(mx, 2) + Math.pow(my, 2));
            var tempAngle = Math.atan(Math.abs(my / mx));
            tempAngle = 2 * Math.PI - angle - tempAngle;
            tx = this.startData.targData.x - (mx>=0?1:-1) * Math.cos(tempAngle) * hypotenuse;
            ty = this.startData.targData.y + (mx>=0?1:-1) * Math.sin(tempAngle) * hypotenuse;
            break;
        case "northEast":
            tx = this.startData.targData.x + Math.sin(angle) * my;
            ty = this.startData.targData.y - Math.cos(angle) * my;
            break;
    }

    // 设置属性
    if (tx && ty) {
        setTrans = setTrans.replace(/translate\([^)]+\)/, "translate("+ tx + " " + ty + ")");
        $curElem.setAttribute("transform",setTrans);
    }
    var $svg, i;
    for (i = 0;i < svgLength;i++) {
        $svg = $$svg[i];
        $svg.setAttribute("width", setWidth + '');
        $svg.setAttribute("height", setHeight + '');
    }

    // 判断翻转
    var material = media.tool.tempMaterial || media.getCurMaterial();
    if (material.reversal !== "1 1")
    {
        var reversalArr = material.reversal.split(" ");
        var transX = 0, transY = 0;
        var trans = $gSvg.getAttribute("transform");
        if (reversalArr[0] === "-1"){
            transX = setWidth;
        }
        if (reversalArr[1] === "-1"){
            transY = setHeight;
        }
        trans = trans.replace(/translate\([^)]+\)/, "translate(" + transX + " " + transY + ")");
        $gSvg.setAttribute("transform", trans);
    }
},
/** 单个旋转 **/
singleZoomRotate: function ($curElem, nowMouseLoc)
{
    var $gWrap = $curElem.querySelector('g');
    var $svg = [...$gWrap.children].pop();
    var svgType = $svg.getAttribute("data-type");

    var px = this.startData.targData.px; //元素对象中心 x 坐标
    var py = this.startData.targData.py; //元素对象中心 y 坐标

    // 鼠标相对中心的位移
    var canvasRect = media.tool.$canvasBg.getBoundingClientRect();
    var mx = nowMouseLoc.x - canvasRect.left;
    var my = nowMouseLoc.y - canvasRect.top;
    //求角度值
    var x = Math.abs(px-mx), y = Math.abs(py-my), z = Math.sqrt(Math.pow(x,2)+Math.pow(y,2)),
        angle = Math.acos(y/z) * 180 / Math.PI;                        //将弧度转换成角度

    //鼠标在第四象限
    if (mx > px && my > py) { angle = 180 - angle;}
    //鼠标在y轴负方向上
    if (mx === px && my > py) { angle = 180;}
    //鼠标在x轴正方向上
    if (mx > px && my === py) { angle = 90;}
    //鼠标在第三象限
    if (mx < px && my > py) { angle = 180+angle;}
    //鼠标在x轴负方向
    if (mx <px && my === py) { angle = 270;}
    //鼠标在第二象限
    if (mx < px && my < py){ angle = 360 - angle;}

    //特殊角度的处理：0、45、90···
    if (angle > 356 || angle < 4){ angle = 0 }
    if (angle > 41 && angle < 49){ angle = 45 }
    if (angle > 86 && angle < 94){ angle = 90 }
    if (angle > 131 && angle < 139){ angle = 135 }
    if (angle > 176 && angle < 184){ angle = 180 }
    if (angle > 221 && angle < 229){ angle = 225 }
    if (angle > 266 && angle < 274){ angle = 270 }
    if (angle > 311 && angle < 319){ angle = 315 }

    //偏移值：transform
    if (svgType === "shape-line"){
        angle-=90;
    }
    var trans = $curElem.getAttribute("transform");
    trans = trans.replace(/rotate\([^,\s]+[,\s]/, "rotate(" + angle + " ");

    var material = media.getMaterialByMid($curElem.getAttribute("data-mid"));
    material.angle = angle;

    //素材旋转
    $curElem.setAttribute("transform",trans);
    Z(".selection-tool .point.rotate>span").html(Math.floor(angle) + '°');
},
/** 素材组缩放 斜边 对角方向 **/
groupZoomCoordinateXY: function (changeRatio, zoomType)
{
    // 循环处理所有选中的素材
    var showRatio = media.tool.showRatio;
    var dataWidth = this.startData.targData.width;
    var dataHeight = this.startData.targData.height;
    var dataXSp = this.startData.targData.xSp;
    var dataYSp = this.startData.targData.ySp;
    var i, elemData, $curElem, $rect, $svg, svgType, setWidth, setHeight, trans, transX, transY, r, rx, ry;
    for (i = 0;i < this.startData.elemsData.length;i++)
    {
        elemData = this.startData.elemsData[i];
        $curElem = media.tool.getCurSvgElement(elemData.index);
        $rect = $curElem.querySelector("rect");
        $svg = $curElem.querySelector("svg");
        svgType = $svg.getAttribute("data-type");

        setWidth = elemData.width * changeRatio;
        setWidth = (setWidth > 0)?(setWidth):(1);
        setHeight = elemData.height * changeRatio;
        setHeight = (setHeight > 0)?(setHeight):(1);

        // 矩形、svg的宽高设置
        $rect.setAttribute("width", setWidth);
        $rect.setAttribute("height", setHeight);
        $svg.setAttribute("width", setWidth);
        $svg.setAttribute("height", setHeight);

        // 不同情况的偏移处理
        switch (zoomType)
        {
            case "se":
                transX = elemData.x * changeRatio + dataXSp / showRatio;
                transY = elemData.y * changeRatio + dataYSp / showRatio;
                break;
            case "sw":
                transX = elemData.x * changeRatio + (dataWidth * (1 - changeRatio) + dataXSp) / showRatio;
                transY = elemData.y * changeRatio + dataYSp / showRatio;
                break;
            case "nw":
                transX = elemData.x * changeRatio + (dataWidth * (1 - changeRatio) + dataXSp) / showRatio;
                transY = elemData.y * changeRatio + (dataHeight * (1 - changeRatio) + dataYSp) / showRatio;
                break;
            case "ne":
                transX = elemData.x * changeRatio + dataXSp / showRatio;
                transY = elemData.y * changeRatio + (dataHeight * (1 - changeRatio) + dataYSp) / showRatio;
                break;
        }

        // 组装transform
        r = ($curElem.transform.baseVal[1])?($curElem.transform.baseVal[1].angle):(0);
        rx = $curElem.getBBox().width / 2;
        ry = $curElem.getBBox().height / 2;
        if (svgType === "shape-line"){
            rx = 0; ry = 0;
        }
        trans = "translate(" + transX + " " + transY + ") rotate(" + r + "," + rx + "," + ry + ")";
        $curElem.setAttribute("transform",trans);
    }
},

/***********************************************
 /********* 2.2：素材mousedown\contextMenu ******
 /***********************************************/

// 2.1：素材多选-- mousedown
multipleSelectStart: function(event)
{
    // 判断是否存在已选，不存在则跳转到单选模式
    var targ = Z.E.current(event);
    var selectLength = media.selectedList.length;
    if (selectLength === 0) {
        return this.singleSelectStart(event);
    }
    // 判断是否已选当前素材
    var material = media.getMaterialByMid(targ.getAttribute("data-mid"));
    var lastMid = media.selectedList[media.selectedList.length - 1];
    var lastMaterial = media.getMaterialByMid(lastMid);

    // 素材存在表格，取消操作
    // if (material.isTable || lastMaterial.isTable)
    //     return;

    // 点击素材与已选素材状态不同，取消操作
    if (material.status !== lastMaterial.status)
        return;

    if (material.selected){
        if (!this.unSelectGroup(material))
            material.unSelected();
    } else {
        if (!this.selectGroup(material))
            material.doMutliSelected();
    }

    // 隐藏虚线框
    this.eleMouseLeave(event);

    // 执行多选结果，显示选中框
    selectionToolsShow_group();

    // 事件绑定，素材组的拖动事件
    if (lastMaterial.status == 0)
        this.groupDragStart(event);
},
// 2.2：素材单选-- mousedown
singleSelectStart: function(event)
{
    Z.E.stop(event);
    var $target = Z.E.current(event);
    var material = media.getMaterialByMid($target.getAttribute("data-mid"));
    media.clearSelected();

    // 判断是否存在群组（实则为多选）
    if (this.selectGroup(material))
    {
        // 显示素材组选中框
        selectionToolsShow_group();

        // 绑定素材组拖动事件
        if (material.status === 0)
            return this.groupDragStart(event);
        return;
    }
    var $curElem = media.tool.getSvgElementByMid(material.mid);

    // 执行选中
    selectTheElement(material, $curElem);

    // 判断素材状态
    if (material.status === 0) {
        this.singleDragStart(event);                    // 正常状态，绑定单素材拖动事件
    } else if (material.status === 3) {
        this.boxSelectStart(event);                     // 锁定状态，绑定框选操作
    }
},

// 2.3 画布的菜单--contextMenu
canvasContextMenu: function(event)
{
    createContextMenu({
        "event": event,
        "elemId": "canvasMenu",
        "editItem": [
            ["粘贴","contextMenuPaste"],
        ],
    });
},
// 2.4 素材的右键菜单--contextMenu
materialContextMenu: function(event)
{
    var $curElem = Z.E.current(event);
    var material = media.getMaterialByMid($curElem.getAttribute('data-mid'));
    if (material.status === 3) {
        createContextMenu({
            "event": event,
            "elemId": "materialLockMenu",
            "editItem": [
                ["解锁","unlockMaterial"],
            ],
        });
        return;
    }
    createContextMenu({
        "event": event,
        "elemId": "materialMenu",
        "editItem": [
            ["复制","contextMenuCopy"],
            ["锁定","doLockMaterial"],
            ["删除","deleteMaterial"],
            [],
            ["上移一层","downMaterial"],
            ["下移一层","upMaterial"],
            ["置顶图层","bottomMaterial"],
            ["置底图层","topMaterial"],
            [],
            ['设置为"背景"',"setBeBgMaterial"],
            // [
            //     ['设置为"背景"'],
            //     ['背景填充',"setBeBgMaterial"],
            //     ['背景适应',"setBeBgMaterial"],
            //     ['背景拉伸',"setBeBgMaterial"],
            //     ['背景平铺',"setBeBgMaterial"],
            //     ['背景居中',"setBeBgMaterial"],
            // ],
            ['添加到"我的素材"',"addToCollectionList"],
        ],
    });
},

/********************************************
 *************** 三：素材双击事件 *************
 ********************************************/
dblEventStart: function(event)
{
    if (media.selectedList.length !== 1) {
        return;
    }
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();
    if (!material || material.status !== 0) {
        return;
    }
    material.type = parseFloat(material.type);
    // 文字类型,正常状态
    if (material.type === 1)
    {
        Z.E.forbidden(event);
        docPopupHide(event);
        this.showTextEditor(material, $curElem);
    }
    // 图片类型，执行图片裁剪
    else if (material.type === 0)
    {
        Z.E.forbidden(event);
        docPopupHide(event);
        this.showCutImage(material, $curElem);
    }
    // 容器类型
    else if (material.type === 4)
    {
        var $image = $curElem.querySelector(".svgFrame-img image");
        if (!$image) {
            return;
        }
        var linkHref = $image.getAttribute("xlink:href");
        if (!linkHref || linkHref.indexOf("container_default.png") > -1) {
            return;
        }
        // 容器图片裁剪
        this.showTrimFrameImg();
    }
    // 形状类型
    else if (material.type === 5)
    {
        var $svg = $curElem.querySelector('svg');
        var dataType = $svg.getAttribute('data-type');

        // 钢笔路径编辑
        if (dataType === 'shape-pen')
            this.showPenEditTool(material, $curElem);
        // 表格内容编辑
        else if (dataType === 'shape-table')
            this.showTableToolByDbl();
    }
},

/********************************************
 ************ 四：素材移入、移出事件 ***********
 ********************************************/
// 进入元素，显示虚线框
eleMouseEnter: function(event)
{
    Z.E.stop(event);
    var $target = Z.E.current(event);
    var material = media.getMaterialByMid($target.getAttribute("data-mid"));
    var isSelected = (function(mid){
        for (var i = 0;i < media.selectedList.length;i++){
            if (media.selectedList[i] == mid)
                return true;
        }
        return false;
    })(material.mid);
    if (material.status === 0 && !isSelected) {
        selectionHover_show($target);
        Z("#selection_hover")[0].$targ = $target;
    }
},
// 离开元素，取消虚线框
eleMouseLeave: function(event)
{
    Z.E.stop(event);
    selectionHover_hide();
    Z("#selection_hover")[0].$targ = null;
},

/********************************************
 ***************** 五：画布drop事件 ***********
 ********************************************/
wrapFilesDrop: function(event)
{
    Z.E.forbidden(event);
    var dt = event.dataTransfer;
    var files = dt.files;
    if(files.length === 0)
        return;
    Z.loading({
        shadow: true,
        text:"正在加载..."
    });
    //清空选中列表
    media.clearSelected();
    //第一次循环，得到所有文本文档、图片
    var newFiles = [];
    var i, thisFile, thisType;
    for (i = 0;i < files.length;i++) {
        thisFile = files[i];
        thisType = thisFile.type;
        if (thisType.indexOf("text") > -1 || thisType.indexOf("image") > -1)
            newFiles.push(thisFile);
    }
    //得到所有即将进行AJAX的素材
    var preLength = media.getBgMaterialList(media.curPage).length;
    media.tool.ajaxLoadedLength = preLength + newFiles.length;
    var file, reader;
    for (i = 0;i < newFiles.length;i++)
    {
        file = newFiles[i];
        reader = new FileReader();
        if (file.type.indexOf("text") > -1) {                      //文本读取方式
            reader.readAsText(file, "gb2312");
            reader.newType = "text";
        } else if (file.type.indexOf("image") > -1) {             //图片读取方式
            reader.readAsDataURL(file);
            reader.newType = "imgage";
        } else {
            media.tool.ajaxLoadedLength--;
            continue;
        }
        //传递一些必要参数
        reader.newMid = preLength + i;
        reader.onload = function() {
            if (this.newType === "text") {                         //执行文字素材添加
                addNewTextOther(this.result, this.newMid);
            } else {                                              //执行图片素材添加
                uploadFileRequest(this.result, this.newMid, true);
            }
        };
    }
},

/********************************************
 **************** 六：文本编辑器 **************
 ********************************************/
//侧边栏编辑器聚焦，赋值
textSideFocusPath: function ()
{
    var material = media.tool.tempMaterial || media.getCurMaterial();
    var $curElem = media.tool.tempElement || media.tool.getCurSvgElement();

    //定义编辑素材和节点对象
    this.textElement = $curElem;
    this.textMaterial = material;

    var blockWidth = this.getSideBlockWidth($curElem, material);
    Z("#sideTextEditor").attr("data-blockWidth", blockWidth);
},
// 计算侧边栏宽度，用于过渡计算
getSideBlockWidth: function ($curElem, material)
{
    var $gWrap = $curElem.querySelector('g');
    var $svg = [...$gWrap.children].pop();
    var elemWidth = $svg.width.baseVal.value;
    elemWidth = Math.ceil(elemWidth / parseFloat(material.textZoom.split(' ')[0]));
    var fontSize = material.fontSize;
    if (media.canvas.createMode === 0) {
        fontSize = pt2px(fontSize);
    }
    return Math.ceil(elemWidth * 14 / fontSize);
},

//文本编辑器，粘贴事件
textPastePath: function(event)
{
    Z.E.forbidden(event);
    // 判断是不是侧边栏的操作
    var material = this.textMaterial;
    var $target = event.target;
    var isInSideTextor = hasClassParent($target, "sideTextEditor");
    var editorId = "#textEditor";
    if (isInSideTextor) {
        editorId = "#sideTextEditor";
    }

    //插入原格式粘贴内容，//去除空白行
    var content = event.clipboardData.getData("Text");
     content = reBlankLine(content);
    
    //获取字体类型和颜色
    var sl = window.getSelection();
    var anchorNode = sl.anchorNode.parentNode;
    var newFamily = this.getNodeFamily(anchorNode, material);
    var newColor = this.getNodeColor(anchorNode, material);
    var insetHtml=""
    var i, newText;
    for (i = 0;i < content.length;i++) {
        newText = content[i];//把每一次写的内容赋值
        if (i === 0) {
          insetHtml = "<titem" + ">";
        }
        if (/\n/.test(newText)) {    
        //回车换行 把每个字符换行
           insetHtml += '</titem><titem><span style="font-family: \'' + newFamily + '\'; color:' + newColor + ';"></span>';
           continue;
        } else if (/\s/.test(newText)){         //空白字符
           newText = "&nbsp;";
        } 
        else if (/\</.test(newText)){         //左尖括号：<
           newText = "&lt;";
        }
           insetHtml += '<span style="font-family:\'' + newFamily + '\'; color:' + newColor + ';">' + newText + '</span>';
        if (i === content.length - 1){
          insetHtml += "</titem>";
        } 
    }   
    document.execCommand("insertHTML", false, insetHtml);
    if (isInSideTextor) {
        return;
    }
          
    //定义material
    material.text = Z(editorId).text();
},

// 文本编辑器，blur 失去焦点
textBlurPath: function(event)
{
    // 路径生成，完成处理；textEditor,计算修改后的偏移；仅在存在旋转角度时，需要计算 translate
    function editorPathDone (material, $curElem)
    {
        var angle = elemData.rotate * Math.PI / 180;
        var newData = media.tool.getEleData($curElem);
        var mx = newData.width / 2 - elemData.width / 2;
        var my = newData.height / 2 - elemData.height / 2;
        var transX = newData.x - mx;
        var transY = newData.y - my;
        var setTrans;
        transX += mx * Math.cos(angle) - my * Math.sin(angle);
        transY += mx * Math.sin(angle) + my * Math.cos(angle);
        transX += editorMl.mx;
        transY += editorMl.my;

        setTrans = $curElem.getAttribute("transform");
        setTrans = setTrans.replace(/translate\([^/)]+\)/, "translate(" + transX + " " + transY + ")");
        setTrans = setTrans.replace(/rotate\([^/)]+\)/, "rotate(" + newData.rotate + " " + newData.width / 2 + " " + newData.height / 2 + ")");
        $curElem.setAttribute("transform", setTrans);

        // 设置文字特殊属性
        setTextMaterialData(material, $curElem);

        // 显示素材
        showTextElement($curElem);

        // 显示选中框
        var $ele = media.tool.tempElement || media.tool.getCurSvgElement();
        if ($ele && $ele === mediaEvent.textElement) selectionTool_show($ele);

        mediaEvent.textMaterial = mediaEvent.textElement = null;
        // 更新素材存储
        updateMaterialSource(material, $curElem);
        // 保存历史
        saveHistory();
    }
    // 显示通用文本编辑工具
    function showEditorTool()
    {
        // 添加“不可编辑”样式
        Z("#textEditorWrap").addClass('z-event-none');
        // 富文本编辑隐藏按钮
        Z(richTextHideId).show();
        // 右侧通用编辑工具
        $toolsWrapRight.removeClass('zi-hide');
        // 两端对齐按钮
        Z("#textAlign_box > .justify").removeClass('zi-hide');
    }
    // 删除空白素材
    function delEmptyDone()
    {
        if (Z.S.trim(text) !== "")
            return false;
        var emptyFont = '<titem><span style="font-family:\'' + material.fontFamily + '\'; color:' + material.color + '">'+text+'<br/></span></titem>';
        Z("#textEditor").html(emptyFont);
        Z("#svg>g>svg").html("");
        material.doSelected();
        deleteMaterial();
        return true;
    }
    // 重设文字属性（wordList、加粗、斜体、下划线）
    function resetMaterialList()
    {
        // 获取属性值、替换标识
        function setMaterialMark()
        {
            if (!markWeight && !markItalic && !markDecoration)
                return;
            if (markWeight && fontWeight !== newWord.fontWeight){
                markWeight = false;
                fontWeight = 0;
            }
            if (markItalic && fontItalic !== newWord.fontItalic){
                markItalic = false;
                fontItalic = 0;
            }
            if (markDecoration && textDecoration !== newWord.textDecoration){
                markDecoration = false;
                textDecoration = 0;
            }
        }
        // 判断是否需要特殊处理
        function decideToDo()
        {
            if (!mWord)
                return;
            if (!isTextEqual && toDoColor && toDoItalic && toDoDecoration)
                return;
            newTex = newWord.text.replace(/\s/, '');
            mText = mWord.text.replace(/\s/, '');
            if (newTex !== mText || newWord.fontFamily !== mWord.fontFamily || newWord.fontWeight !== mWord.fontWeight)
                isTextEqual = false;
            if (newWord.color !== mWord.color) {
                toDoColor = 1;
            }
            if (newWord.fontItalic !== mWord.fontItalic) {
                toDoItalic = 1;
            }
            if (newWord.textDecoration !== mWord.textDecoration) {
                toDoDecoration = 1;
            }
        }

        var isTextEqual = material.text === text;
        var newWordsList = mediaEvent.setWordsListFromEditor(Z("#textEditor"));
        var newLength = newWordsList.length;

        // 标识 加粗、斜体、下划线
        var firstWord = newWordsList[0];
        var fontWeight = firstWord.fontWeight;
        var markWeight = true;
        var fontItalic = firstWord.fontItalic;
        var markItalic = true;
        var textDecoration = firstWord.textDecoration;
        var markDecoration = true;
        var i, newWord, newTex, mWord, mText;
        for (i = 0;i < newLength;i++)
        {
            newWord = newWordsList[i];
            // 获取属性值
            setMaterialMark();
            // 判断是否需要特殊处理
            mWord = material.wordsList[i];
            decideToDo();
        }
        if (isTextEqual)
            toDoPathAjax = false;

        // 素材属性赋值
        material.text = text;
        material.textAlign = textAlign;
        material.fontWeight = fontWeight;
        material.fontItalic = fontItalic;
        material.textDecoration = textDecoration;
        material.wordsList = Z.clone(newWordsList);
        newWordsList = null;
    }
    // 获取最终的文字路径
    function getTheTextElem()
    {
        // 计算编辑器偏移
        function setEditorM1()
        {
            var editorLeft = 0;
            var editorTop = 0;
            if (!$editorWrap.getAttribute('style'))
            {
                var elemTrans = $curElem.transform.baseVal[0];
                editorLeft = elemTrans.matrix.e;
                editorTop = elemTrans.matrix.f;
            }
            else
            {
                editorLeft = parseFloat(Z($editorWrap).css("left")) / showRatio;
                editorTop = parseFloat(Z($editorWrap).css("top")) / showRatio;
            }
            editorMl.mx = editorLeft - editorSetLoc.x / showRatio;
            editorMl.my = editorTop - editorSetLoc.y / showRatio;
            $editorWrap.editorSetLoc = null;
        }
        // 逐个路径处理文字特效 toDo：[颜色、斜体、下划线]
        function resetTheElementEffect(toDo)
        {
            // 颜色操作
            function setColor()
            {
                $path.setAttribute('fill', word.color);
            }
            // 斜体操作
            function setItalic()
            {
                pathTrans = $gPath.getAttribute('transform');
                if (word.fontItalic)
                {
                    if(material.textVertical === 'normal')
                        skewString = 'skewX(-18)';
                    else
                        skewString = 'skewY(18)';
                    if (/skew/.test(pathTrans))
                        pathTrans = pathTrans.replace(/skew[^)]+\)/, skewString);
                    else
                        pathTrans += ' ' + skewString;
                }
                else {
                    pathTrans = pathTrans.replace(/skew[^)]+\)/, '').replace(/\s\s/g, ' ');
                }
                $gPath.setAttribute('transform', pathTrans);
            }
            // 下划线操作
            function setDecoration()
            {
                $line = $gPath.querySelector('line');
                if (word.textDecoration && !$line)
                {
                    $line = document.createElementNS(xmlns, "line");
                    setX2 = parseFloat($gPath.getAttribute("data-width")) + parseFloat(material.letterSpacing);
                    $line.setAttribute("x1", '0');
                    $line.setAttribute("y1", material.underlineOffset);
                    $line.setAttribute("x2", setX2);
                    $line.setAttribute("y2", material.underlineOffset);
                    $line.setAttribute("stroke", word.color);
                    $line.setAttribute("stroke-width", material.underlineThickness);
                    $gPath.appendChild($line);
                }
                if (!word.textDecoration && $line) {
                    $gPath.removeChild($line);
                }
            }

            // 主方法
            if (toDo.indexOf(1) === -1)
                return;
            var $$path = $curElem.querySelectorAll('.font-path');
            var wordsLength = material.wordsList.length;
            var i, word, $gPath, $path, $line, pathTrans, skewString, setX2;
            for (i = 0;i < wordsLength;i++)
            {
                word = material.wordsList[i];
                $gPath = $$path[i];
                $path = $gPath.querySelector('path');
                // 1：修改颜色
                if (toDo[0]) setColor();
                // 2：斜体操作
                if (toDo[1]) setItalic();
                // 3：下划线操作
                if (toDo[2]) setDecoration();
            }
        }

        // 1：计算偏移位置
        setEditorM1();
        // 2：重新绘制文字
        if (toDoPathAjax) return getPathAjax(material, $curElem, 1, 1, editorPathDone);
        // 3：对齐操作
        if (toDoAlign) setElementAlign(textAlign, material, $curElem);
        // 3.1：修改颜色、斜体、下划线
        resetTheElementEffect([toDoColor , toDoItalic, toDoDecoration]);
        // 4：显示素材
        showTextElement($curElem);
        // 5：选中素材
        selectTheElement(material, $curElem);
        // 6：保存
        updateMaterialSource(material, $curElem);
        saveHistory();
    }

    // 1：定义可用变量
    var material = this.textMaterial;
    var $curElem = this.textElement;
    var showRatio = media.tool.showRatio;
    var $target = event ? Z.E.target(event) : Z.D.id('textEditor');
    var text = this.getTextStrFromEditor($target);
    var $editorWrap = Z.D.id("textEditorWrap");
    var editorSetLoc = $editorWrap.editorSetLoc;
    var elemData = media.tool.getEleData($curElem);
    var textAlign = Z("#textEditor").css("text-align");

    // 2：隐藏文本编辑工具
    showEditorTool();

    // 3：判断是否需要删除
    if (delEmptyDone())
        return hideTextEditor();

    // 5：判断计算参数是否有效
    if (!editorSetLoc)
        return showTextElement($curElem);

    // 6：判断、重新赋值文字属性
    var toDoAlign = material.textAlign !== textAlign;
    var toDoPathAjax = true, toDoColor = 0, toDoItalic = 0, toDoDecoration = 0;
    resetMaterialList();

    // 7：插入结果文字到侧边栏编辑器
    Z("#sideTextEditor").css("text-align", textAlign);
    this.insertToSideEditor(material);

    // 8：计算绘制数据并绘制
    var editorMl = {};
    getTheTextElem();
},

// 侧边栏编辑器，input 改变
textSideInputPath: function(event)
{
    // 路径生成，完成处理；textEditor
    function sideEditorPathDone (material, $curElem)
    {
        var listLength = mediaEvent.sideEditorList.length;
        if (listLength > 0){
            mediaEvent.sideEditorState = 1;
            var lastM = mediaEvent.sideEditorList[listLength - 1];
            material.text = lastM.text;
            material.wordsList = Z.clone(lastM.wordsList);
            mediaEvent.sideEditorList.splice(0,listLength);
            getPathAjax(material, $curElem, 1, 0, sideEditorPathDone);
        }
        mediaEvent.sideEditorState = null;

        // 修正偏移
        editOverSet($curElem);
        updateMaterialSource(material, $curElem);

        //设置属性
        setTextMaterialData(material, $curElem);

        //显示选中框
        var $ele = media.tool.tempElement || media.tool.getCurSvgElement();
        if ($ele) selectionTool_show($ele);
    }

    var material = this.textMaterial;
    var $curElem = this.textElement;
    if (!material || !$curElem) {
        return;
    }
    var $gSvg = $curElem.querySelector("g");
    var $$svg = $gSvg.children;
    while ($$svg.length > 1)
        $gSvg.removeChild($$svg[0]);
    var $svg = $$svg[0];
    var $editor = Z.D.id("sideTextEditor") || Z.E.current(event);

    // 获取文字内容，包含自动换行标识
    var blockWidth = parseFloat($editor.getAttribute("data-blockWidth") || this.getSideBlockWidth($curElem, material));
    var text = this.getTextStrFromEditor($editor, blockWidth);

    if (Z.S.trim(text) === "") {
        material.text = text;
        var emptyFont = '<titem><span style="font-family:\''+material.fontFamily+'\'; color:'+material.color+';">'+text+'<br/></span></titem>';
        Z("#sideTextEditor").html(emptyFont);
        var $rect = $curElem.querySelector("rect");
        $rect.setAttribute("width",1);
        $rect.setAttribute("height",1);
        $svg.innerHTML = "";
        $svg.setAttribute("width",1);
        $svg.setAttribute("height",1);
        $svg.setAttribute("viewBox","0 0 1 1");
        selectionTool_show();
        return;
    }

    // 获取 wordsList
    var wordsList = this.setWordsListFromEditor($editor, material);

    if (this.sideEditorState === 1)
    {//正在处理，队列添加
        this.sideEditorList.push({
            "text": material.text,
            "wordsList": Z.clone(material.wordsList),
        });
        return;
    }
    material.text = text;
    material.wordsList = wordsList;

    // 初始化队列
    if (!this.sideEditorList)
        this.sideEditorList = [];
    this.sideEditorState = 1;

    // 绘制
    getPathAjax(material, $curElem, 1, 0, sideEditorPathDone);
},

// 侧边栏编辑器，blur 失去焦点 保存历史，刷新版面
textSideBlur: function(event)
{
    var $thisEditor = Z.E.current(event);
    var text = $thisEditor.innerText;
    this.textMaterial = this.textElement = null;

    if (Z.S.trim(text) === "") {
        deleteMaterial();
    }
},

/*******文本编辑器方法 **********/
// 显示文本编辑框
showTextEditor: function(material, $curElem)
{
    var $svgElem = $curElem.querySelector("svg");
    var baseVal_0 = $curElem.transform.baseVal[0];
    var baseVal_1 = $curElem.transform.baseVal[1];
    var textAlign = material.textAlign;
    var showRatio = media.tool.showRatio;

    // 设置tempCurrent
    media.tool.setTempCurrent(material,$curElem);

    // 定义编辑素材和节点对象
    this.textMaterial = material;
    this.textElement = $curElem;

    // 隐藏当前素材
    hideHiddenElement($curElem);

    // 隐藏编辑过程不需要的元素
    selectionAll_hide();
    // 富文本编辑隐藏按钮
    Z(richTextHideId).hide();
    // 右侧通用编辑工具
    $toolsWrapRight.addClass('zi-hide');
    // 两端对齐按钮
    Z("#textAlign_box > .justify").addClass('zi-hide');

    // 计算编辑框的样式
    var stageRect = media.tool.$stageCanvas.getBoundingClientRect();
    var bgRect = media.tool.$canvasBg.getBoundingClientRect();
    var setLeft = bgRect.left - stageRect.left;
    setLeft += baseVal_0.matrix.e * showRatio - 1;
    var setTop = bgRect.top - stageRect.top;
    setTop += baseVal_0.matrix.f * showRatio - 1;
    var textZoom = material.textZoom || "1 1";
    var zoomData = textZoom.split(" ");
    var setWidth = $svgElem.viewBox.baseVal.width * showRatio;

    var trueWidth = $svgElem.width.baseVal.value * showRatio;
    var trueHeight = $svgElem.height.baseVal.value * showRatio;
    // 定位编辑框
    Z("#textEditorWrap").css({
        "left": setLeft,
        "top": setTop,
        "transform": "rotate(" + baseVal_1.angle + "deg)",
        "transform-origin": trueWidth / 2 + "px " + trueHeight / 2 + "px 0",
    });
    Z("#textEditorPoint").css({
        "width" : parseFloat(zoomData[0]) * 100 + "%",
        "height" : parseFloat(zoomData[1]) * 100 + "%",
    });
    Z("#textEditor").css({
        "font-family": '"' + material.fontFamily + '"',
        "width": setWidth + "px",
        "transform": "scale(" + zoomData[0] + "," + zoomData[1] + ")",
        "transform-origin": "left top",
        "text-align": textAlign,
    }).focus();

    // 绑定当前编辑素材
    Z.D.id("textEditorWrap").editorSetLoc = {
        'x' : setLeft,
        'y' : setTop,
        'r' : showRatio,
    };

    // 插入文字代码
    this.insertToCanvasEditor(material);
    this.insertToSideEditor(material);
},
// 插入到画布编辑器
insertToCanvasEditor: function(material)
{
    this.insertTextToEditor(material, Z("#textEditor"));
},
// 插入到侧边栏编辑器
insertToSideEditor: function(material)
{
    var $activeElem = document.activeElement;
    if ($activeElem.id === "sideTextEditor"){
        return;
    }
    this.insertTextToEditor(material, Z("#sideTextEditor"));
},
// 插入文字到文字编辑器
insertTextToEditor: function(textAttrObj, $texter)
{
    // 按行插入每行文字
    function insertTextByLine()
    {
        function lineForEach ()
        {
            listIndex ++;
            $word = textAttrObj.wordsList[listIndex];
            if (!$word)
                return;
            text = $word.text.replace(/-%6-%-%0-/g, '<');
            if (text === " ") {
                text = "&nbsp;";
            }
            $textStr = '<span style="font-family:\'' + $word.fontFamily + '\';';

            if ($word.color.toLowerCase() === 'none')
                $textStr = '<font color="rgba(0,0,0,0)" >' + $textStr + '">' + text + '</span>' + '</font>';
            else
                $textStr += 'color:' + $word.color + ';">' + text + '</span>';

            if ($word.textDecoration)
                $textStr = '<u style="color: ' + $word.color + ';">' + $textStr + '</u>';
            if ($word.fontItalic)
                $textStr = '<i>' + $textStr + '</i>';
            if ($word.fontWeight)
                $textStr = '<b>' + $textStr + '</b>';
            $titem.insertAdjacentHTML("beforeend", $textStr);
        }

        // 插入字符文字
        $texter.html("");
        var listIndex = -1;
        var words, $titem, $textStr, $word, text, $g, dx;
        for (i = 0;i < lineArr.length;i++)
        {
            // 换行标识标记
            words = lineArr[i];
            markArr[i] = [];
            while(words.indexOf('-%5-%-%5-') > -1){
                markArr[i].push(words.indexOf('-%5-%-%5-'));
                words = words.replace(/-%5-%-%5-/, "");
            }

            // 开始创建文字盒子
            $titem = document.createElement("titem");
            if (words === "") $titem.insertAdjacentHTML("beforeend", '<span>&nbsp;</span>');

            // 遍历每一行的文字
            for (j = 0;j < words.length;j++) {
                lineForEach ();
            }
            $texter.append($titem);

            if (textElemDoing)
            {
                $g = $$gInner[i];
                // 赋值，缩进
                if (!$g || $g.innerHTML === '')
                    dx = 0;
                else {
                    dx = parseFloat($g.getAttribute("data-dx") || 0);
                    dx = dx > 0 ? dx : 0;
                    dx *= showRatio;
                }
                Z($titem).css("text-indent", dx + "px");
            }
        }
    }
    // 编辑器字体大小、字间距、行间距、行高
    function setWrapStyle()
    {
        var fontSize = textAttrObj.fontSize;
        if (parseFloat(media.canvas.createMode) === 0) {
            fontSize = pt2px(fontSize);
        }
        fontSize *=  showRatio;
        $texter.css({
            "fontSize" : fontSize,
            "letterSpacing": Math.round(parseFloat(textAttrObj.letterSpacing) * showRatio) + "px",
            "lineHeight": Math.round(parseFloat(textAttrObj.lineHeight) * showRatio) + "px",
        });
        $texter.attr("data-mathheight", textAttrObj.mathHeight).attr("data-fontsize", fontSize);
    }
    // 校验编辑器宽度，防止宽度不够造成的自动换行
    function resetWrapWidth()
    {
        if (!textElemDoing)
            return;
        // 先取消旋转，计算完，再添加
        Z('#textEditorWrap').addClass('rotateNone');
        var wrapWidth = Math.ceil($texter[0].getBoundingClientRect().width);
        var $$titem = Z($texter).children('titem');
        var maxWidthArr = [wrapWidth];
        var wordsWidth, $$span;
        for (i = 0;i < $$titem.length;i++)
        {
            wordsWidth = 0;
            $$span = $$titem[i].querySelectorAll('span');
            for (j = 0;j < $$span.length;j++)
            {
                if (markArr[i].indexOf(j) > -1) {
                    wordsWidth = Math.ceil(wordsWidth);
                    if (wordsWidth > wrapWidth) maxWidthArr.push(wordsWidth);
                    wordsWidth = 0;
                }
                wordsWidth += Math.ceil($$span[j].getBoundingClientRect().width);
            }
            if (wordsWidth > wrapWidth) maxWidthArr.push(wordsWidth);
        }
        // 恢复旋转
        Z('#textEditorWrap').removeClass('rotateNone');
        Z($texter).css('width', Math.ceil(getMaxNum(maxWidthArr)) / parseFloat(textAttrObj.textZoom.split(' ')[0] || 1));
    }

    // 主方法，定义变量
    var lineArr = textAttrObj.text.split("\n");
    var showRatio = media.tool.showRatio;
    var textElemDoing = $texter[0].id === "textEditor";
    var markArr = [], i, j;
    if (textElemDoing)
    {
        var $curElem = media.tool.getSvgElementByMid(textAttrObj.mid);
        var $$gInner = $curElem.querySelectorAll("svg > g");
    }

    // 1：插入字符
    insertTextByLine();

    // 2：编辑器样式
    setWrapStyle();

    // 3：校准宽度
    resetWrapWidth();
},
// 是否是文本编辑器
isInTextEditor: function(event)
{
    var $node = Z.E.target(event);
    while ($node !== media.tool.$designStage) {
        if ($node.id === "textEditor") {
            return true;
        }
        $node = $node.parentNode;
    }
    return false;
},
// 获取素材 text ；包含自动换行标识
getTextStrFromEditor: function ($editor, blockWidth)
{
    // 获取单文字宽度
    function getNewFontWidth($node, text)
    {
        var nodeStyle = window.getComputedStyle($node, null);
        var $newFont = Z('<span style="z-index: -999;opacity: 0;">' + text + '</span>');
        $newFont.appendTo(document.documentElement);
        $newFont.css({
            'fontFamily' : nodeStyle.fontFamily,
            'fontSize' : nodeStyle.fontSize,
            'fontStyle' : nodeStyle.fontStyle,
            'lineHeight' : nodeStyle.lineHeight,
            'letterSpacing' : nodeStyle.letterSpacing,
        });
        var fontWidth = $newFont[0].getBoundingClientRect().width;
        $newFont.remove();
        return fontWidth;
    }
    // 遍历多文字节点
    function doEditorNodeText ($node)
    {
        var $$childNodes = $node.childNodes;
        var i, j, $childNode, nodeText, $nodeParent, textWidth;
        for (i = 0;i < $$childNodes.length;i++)
        {
            $childNode = $$childNodes[i];
            if ($childNode.nodeType !== 3){
                doEditorNodeText($childNode);
            } else {
                nodeText = $childNode.textContent;
                $nodeParent = $childNode.parentNode;
                for (j = 0;j < nodeText.length;j++)
                {
                    textWidth = getNewFontWidth($nodeParent, nodeText[j]);
                    wordsWidth += textWidth;
                    if (wordsWidth > blockWidth) {
                        textArr.push(textStr);
                        textArr.push("-%5-%-%5-");
                        // 重置参数
                        wordsWidth = textWidth;
                        textStr = "";
                    }
                    textStr += nodeText[j];
                }
            }
        }
    }
    // 遍历单个块容器 titem
    function getTextStrFromBlock ($block, textArr)
    {
        blockWidth = blockWidth || $block.offsetWidth;
        var i, $child, childText;

        for (i = 0;i < $block.children.length;i++)
        {
            $child = $block.children[i];
            if ($child.tagName.toLowerCase() === "titem") {
                getTextStrFromBlock($child, textArr);
            } else {
                childText = $child.innerText;
                if (childText.length === 1)
                {// 单文字节点，直接计算
                    wordsWidth += $child.offsetWidth;
                    if (wordsWidth > blockWidth) {
                        textArr.push(textStr);
                        textArr.push("-%5-%-%5-");
                        // 重置参数
                        wordsWidth = $child.offsetWidth;
                        textStr = "";
                    }
                    textStr += childText;
                }
                else if (childText.length > 1)
                {// 多个文字节点，循环处理
                    doEditorNodeText($child);
                }
            }
        }
        if (textStr !== '')
        {
            textStr = cutDoubleSpaceEnd(textStr);
            textArr.push(textStr);
            textArr.push("\n");
            wordsWidth = 0;
            textStr = '';
        }
        return textArr;
    }

    // 主方法
    var textArr = [];
    var $$children = $editor.children;
    var text , i, $child, wordsWidth, textStr;
    for (i = 0;i < $$children.length;i++) {
        $child = $$children[i];
        // 处理块容器 titem 数据
        if ($child.tagName.toLowerCase() !== "titem"){
            continue;
        }
        wordsWidth = 0;
        textStr = "";
        textArr = getTextStrFromBlock($child, textArr);
    }
    text = reBlankLine(textArr.join(""));
    return text;
},

// 重新设置新的 wordsList
setWordsListFromEditor: function($elem)
{
    function addWordsListFromEditor ($node)
    {// 遍历一行中的文字，添加 word
        if ($node.nodeType !== 3) {
            var $$children = $node.childNodes;
            for (var i = 0;i < $$children.length;i++) {
                if($$children[i].nodeName.toLowerCase() === "titem") {
                    continue;
                }
                addWordsListFromEditor($$children[i]);
            }
            return;
        }

        var text = $node.textContent;
        var arrIndex = newList.length;
        var $pNode = $node.parentNode;
        var j, fontSize;

        //获取基础属性
        fontSize = parseFloat(Z($elem).attr("data-fontsize"));  //获取准确的 px 值
        fontSize /= media.tool.showRatio;
        if (media.canvas.createMode === 0) {
            fontSize = px2pt(fontSize);
        }
        for (j = 0;j < text.length;j++) {
            newList.push({
                "color": mediaEvent.getNodeColor($pNode),
                "fontFamily": mediaEvent.getNodeFamily($pNode),
                "fontSize": fontSize,
                "fontWeight": getClosestParent($pNode, "b", "texter") ? (1) : (0),
                "fontItalic": getClosestParent($pNode, "i", "texter") ? (1) : (0),
                "textDecoration": getClosestParent($pNode, "u", "texter") ? (1) : (0),
                "text": text[j],
                "index": arrIndex + j,
            })
        }
    }

    // 主方法
    var newList = [];
    Z($elem).find("titem").each(function($titem)
    {// 遍历每一行
        addWordsListFromEditor($titem);
    });
    return newList;
},
// 获取当前的字体
getNodeFamily: function (node)
{
    var fontFamily = Z(node).css('fontFamily');
    if (fontFamily.indexOf(',') > -1){
        fontFamily = fontFamily.split(',')[0];
    }
    if (/^'|".+/.test(fontFamily)){
        fontFamily = fontFamily.substring(1);
    }
    if (/.+'|"$/.test(fontFamily)){
        fontFamily = fontFamily.substring(0, fontFamily.length - 1);
    }
    return fontFamily;
},
// 获取当前的颜色
getNodeColor: function (node)
{
    // 检测文字是否是透明色处理
    function isFontTransparent()
    {
        var $tempNode = node;
        while ($tempNode.tagName.toLowerCase() !== 'texter') {
            if ($tempNode.hasAttribute('color'))
                break;
            $tempNode = $tempNode.parentNode;
        }
        var attrColor = $tempNode.getAttribute('color');
        if (attrColor && attrColor.toLowerCase().replace(/\s/g, '') === 'rgba(0,0,0,0)')
            color = 'none';
    }

    var color = Z(node).css('color');
    if (/^rgb/.test(color))
    {
        // 特殊颜色，可能是透明颜色
        if (color.toLowerCase().replace(/\s/g,'') === 'rgb(186,0,0)')
            isFontTransparent();
        else
            color = rgb2hex(color);
    }
    return color;
},

/********************************************
 *************** 七：图片容器处理 **************
 ********************************************/
/** 容器图片裁剪，显示裁剪框 **/
showTrimFrameImg: function ($curElem, material)
{
    $curElem = $curElem || media.tool.tempElement || media.tool.getCurSvgElement();
    material = material || media.tool.tempMaterial || media.getCurMaterial();
    var $gSvg = $curElem.querySelector("g");
    var $svg = $gSvg.querySelector("svg");
    var $frameImage = $curElem.querySelector(".svgFrame-img image");
    var $frameRect = $curElem.querySelector(".svgFrame-img rect");

    // 计算
    var svgRatio = $svg.width.baseVal.value / $svg.viewBox.baseVal.width;
    var showRatio = media.tool.showRatio;
    var wrap_width = $svg.width.baseVal.value;
    var wrap_height = $svg.height.baseVal.value;
    var old_width = $frameImage.width.baseVal.value;
    var old_height = $frameImage.height.baseVal.value;
    var old_trans = $frameImage.getAttribute("transform");
    var rect_width = $frameRect.width.baseVal.value;
    var rect_height = $frameRect.height.baseVal.value;
    var rect_x = $frameRect.x.baseVal.value;
    var rect_y = $frameRect.y.baseVal.value;
    var bg_width = old_width * svgRatio;
    var bg_height = old_height * svgRatio;
    // 偏移
    var elemMatrix = $curElem.transform.baseVal[0].matrix;
    var imgMatrix = $frameImage.transform.baseVal[0].matrix;
    var bg_left = imgMatrix.e * svgRatio;
    var bg_top = imgMatrix.f * svgRatio;
    var wrap_left = elemMatrix.e;
    var wrap_top = elemMatrix.f;
    // 旋转
    var wrap_trans = $curElem.transform.baseVal[1].angle;
    wrap_trans = "rotate(" + wrap_trans + "deg)";
    // 翻转
    var reversal;
    if ($gSvg.hasAttribute("transform")) {
        reversal = $gSvg.getAttribute("transform").replace(/.*scale\(([^)]+)\).*/, "$1");
        reversal = reversal ? reversal : "1 1";
    } else {
        reversal = "1 1";
    }
    material.reversal = reversal;
    var reversalArr = reversal.split(" ");
    if (reversalArr[0] === "-1"){
        bg_left = wrap_width - bg_width - bg_left;
    }
    if (reversalArr[1] === "-1"){
        bg_top = wrap_height - bg_height - bg_top;
    }

    // 赋值
    var stageRect = media.tool.$stageCanvas.getBoundingClientRect();
    var canvasRect = media.tool.$canvasBg.getBoundingClientRect();
    var mLeft = canvasRect.left - stageRect.left;
    var mTop = canvasRect.top - stageRect.top;

    wrap_width *= showRatio;
    wrap_height *= showRatio;
    wrap_left *= showRatio;
    wrap_top *= showRatio;

    wrap_left += mLeft;
    wrap_top += mTop;

    bg_width *= showRatio;
    bg_height *= showRatio;
    bg_left *= showRatio;
    bg_top *= showRatio;

    var $frameEditor = Z.D.id("imgFrameEditor");
    var $frameImgBg = Z.D.id("frameImgBg");
    var $bgImg = $frameImgBg.querySelector("img");
    var $frameImgCon = Z.D.id("frameImgCon");
    Z($frameEditor).css({
        "width": wrap_width,
        "height": wrap_height,
        "left": wrap_left,
        "top": wrap_top,
        "transform": wrap_trans,
    });
    Z($frameImgBg).css({
        "width": bg_width,
        "height": bg_height,
        "left": bg_left,
        "top": bg_top,
    });
    Z($frameImgCon).css({
        "width": bg_width,
        "height": bg_height,
        "left": bg_left,
        "top": bg_top,
    });
    Z($bgImg).attr("src",$frameImage.getAttribute("xlink:href"));
    Z($bgImg).css({
        "transform": "scale(" + reversalArr.join(",") + ")",
    });


    // 保存当前数据到frame
    var limitWidth = (rect_width + rect_x) * svgRatio * showRatio;
    var limitHeight = (rect_height + rect_y) * svgRatio * showRatio;
    $frameEditor.oldFrameData = {
        "eWidth": limitWidth,
        "eHeight": limitHeight,
        "width": old_width,
        "height": old_height,
        "trans": old_trans,
    }

    // 隐藏所有
    hideEditSelected();
    media.tool.setTempCurrent(material,$curElem);

    // 事件绑定
    Z($frameEditor).on("click",Z.E.forbidden);
    Z("#frameImgBg>img").on("mousedown",mediaEvent.frameBgDragStart,mediaEvent);
    Z("#framePoint>.point").on("mousedown",mediaEvent.frameBgResizeStart,mediaEvent);
    Z("#frameBtn>.frameBtn-sure").on("click",mediaEvent.frameBgDragSure,mediaEvent);
    Z("#frameBtn>.frameBtn-cancel").on("click",mediaEvent.frameBgDragCancel,mediaEvent);
},
// 容器背景拖动事件
frameBgDragStart: function(event)
{
    Z.E.stop(event);
    var $frameEditor = Z.D.id("imgFrameEditor");
    var $frameImgBg = Z.D.id("frameImgBg");
    var $curElem = media.tool.tempElement;
    if (!$curElem) {
        return;
    }
    var $image = $curElem.querySelector(".svgFrame-img image");
    var imageMatrix = $image.transform.baseVal[0].matrix;
    this.startData.angle = $curElem.transform.baseVal[1].angle;
    this.startData.mouseLoc = getMouseLocation(event);
    this.startData.targData = {
        "wrap_width": $frameEditor.offsetWidth,
        "wrap_height": $frameEditor.offsetHeight,
        "bg_width": $frameImgBg.offsetWidth,
        "bg_height": $frameImgBg.offsetHeight,
        "x": $frameImgBg.offsetLeft,
        "y": $frameImgBg.offsetTop,
    };
    this.startData.imgData = {
        "x": imageMatrix.e,
        "y": imageMatrix.f,
    };
    // 事件绑定
    Z(media.tool.$designStage).on("mousemove",this.frameBgDragDoing,this);
    Z(media.tool.$designStage).on("mouseup mouseleave",this.frameBgDragDone,this);
},
frameBgDragDoing: function(event)
{
    Z.E.cancel(event);
    var nowMouseLoc = getMouseLocation(event);
    var mouseMetabolic = {
        "x": nowMouseLoc.x - this.startData.mouseLoc.x,
        "y": nowMouseLoc.y - this.startData.mouseLoc.y,
    };
    if (mouseMetabolic.x === 0 && mouseMetabolic.y === 0){
        return;
    }
    var $frameEditor = Z.D.id("imgFrameEditor");
    var $frameImgBg = Z.D.id("frameImgBg");
    var $curElem = media.tool.tempElement;
    var $svg = $curElem.querySelector("svg");
    var $frameImage = $curElem.querySelector(".svgFrame-img image");
    var $imageRect = $curElem.querySelector(".svgFrame-img rect");
    var svgRatio = $svg.width.baseVal.value / $svg.viewBox.baseVal.width;
    var showRatio = media.tool.showRatio;
    var angle = this.startData.angle * Math.PI/180;

    //计算偏移
    var mouseAngle;
    var l = Math.sqrt(Math.pow(mouseMetabolic.x, 2) + Math.pow(mouseMetabolic.y, 2));
    var absAngle = Math.atan(Math.abs(mouseMetabolic.y) / Math.abs(mouseMetabolic.x));
    var rectAngle = 90 * Math.PI / 180;
    if (mouseMetabolic.x > 0 && mouseMetabolic.y === 0){           //x正轴
        mouseAngle = 0;
    } else if (mouseMetabolic.x > 0 && mouseMetabolic.y > 0){    //第一象限
        mouseAngle = absAngle;
    } else if (mouseMetabolic.x === 0 && mouseMetabolic.y > 0){   //y正轴
        mouseAngle = rectAngle;
    } else if (mouseMetabolic.x < 0 && mouseMetabolic.y > 0){    //第二象限
        mouseAngle = 2 * rectAngle - absAngle;
    } else if (mouseMetabolic.x < 0 && mouseMetabolic.y === 0){   //x负轴
        mouseAngle = 2 * rectAngle;
    } else if (mouseMetabolic.x < 0 && mouseMetabolic.y < 0){    //第三象限
        mouseAngle = 2 * rectAngle + absAngle;
    } else if (mouseMetabolic.x === 0 && mouseMetabolic.y < 0){   //y负轴
        mouseAngle = 3 * rectAngle;
    } else if (mouseMetabolic.x > 0 && mouseMetabolic.y < 0){    //第四象限
        mouseAngle = 4 * rectAngle - absAngle;
    }
    var bg_left = l * Math.cos(mouseAngle - angle) + this.startData.targData.x;
    var bg_top = l * Math.sin(mouseAngle - angle) + this.startData.targData.y;

    //判断边界、临界点
    var wrap_width = this.startData.targData.wrap_width;
    var wrap_height = this.startData.targData.wrap_height;
    var bg_width = this.startData.targData.bg_width;
    var bg_height = this.startData.targData.bg_height;
    var limit_left = $imageRect.x.baseVal.value * svgRatio * showRatio;
    var limit_top = $imageRect.y.baseVal.value * svgRatio * showRatio;

    bg_left = (bg_left < limit_left)?(bg_left):(limit_left);
    bg_top = (bg_top < limit_top)?(bg_top):(limit_top);

    if (bg_left + bg_width < $frameEditor.oldFrameData.eWidth) {
        bg_left = $frameEditor.oldFrameData.eWidth - bg_width;
    }
    if (bg_top + bg_height < $frameEditor.oldFrameData.eHeight) {
        bg_top = $frameEditor.oldFrameData.eHeight - bg_height;
    }

    Z($frameImgBg).css({
        "left": bg_left,
        "top": bg_top,
    });

    //对应素材的图片位移
    var material = media.getMaterialByMid($curElem.getAttribute("data-mid"));
    var reversalArr = material.reversal.split(" ");
    var image_x = bg_left;
    var image_y = bg_top;
    if (reversalArr[0] !== "1"){
        image_x = wrap_width - bg_width - image_x;
    }
    if (reversalArr[1] !== "1"){
        image_y = wrap_height - bg_height - image_y;
    }
    image_x /= svgRatio * showRatio;
    image_y /= svgRatio * showRatio;
    $frameImage.setAttribute("transform","translate(" + image_x + " " + image_y + ")");
},
frameBgDragDone: function()
{
    //事件清除
    Z(media.tool.$designStage).off("mousemove",this.frameBgDragDoing,this);
    Z(media.tool.$designStage).off("mouseup mouseleave",this.frameBgDragDone,this);
},
// 容器背景缩放事件
frameBgResizeStart: function(event)
{
    Z.E.stop(event);
    var $target = Z.E.current(event);
    var $frameEditor = Z.D.id("imgFrameEditor");
    var $frameImgBg = Z.D.id("frameImgBg");
    var $curElem = media.tool.tempElement;
    if (!$curElem) {
        return;
    }
    var $image = $curElem.querySelector(".svgFrame-img image");
    var imageMatrix = $image.transform.baseVal[0].matrix;
    this.startData.angle = $curElem.transform.baseVal[1].angle;
    this.startData.mouseLoc = getMouseLocation(event);
    this.startData.type = Z($target).attr("data-type");
    this.startData.targData = {
        "width": $frameImgBg.offsetWidth,
        "height": $frameImgBg.offsetHeight,
        "left": $frameImgBg.offsetLeft,
        "top": $frameImgBg.offsetTop,
        "bgRect": $frameImgBg.getBoundingClientRect(),
        "editorRect": $frameEditor.getBoundingClientRect(),
        "rectRatio": $frameImgBg.offsetWidth / $frameImgBg.offsetHeight,
    };
    this.startData.imgData = {
        "width": $image.width.baseVal.value,
        "height": $image.height.baseVal.value,
        "x": imageMatrix.e,
        "y": imageMatrix.f,
    };
    // 事件绑定
    Z(media.tool.$designStage).on("mousemove",this.frameBgResizeDoing,this);
    Z(media.tool.$designStage).on("mouseup mouseleave",this.frameBgResizeDone,this);
},
frameBgResizeDoing: function(event)
{
    Z.E.cancel(event);
    var mouseMetabolic = this.getTrueZoomMetabolic(event);
    var $frameEditor = Z("#imgFrameEditor")[0];
    var $frameImgBg = Z("#frameImgBg")[0];
    var $curElem = media.tool.tempElement;
    var $svg = $curElem.querySelector("svg");
    var $frameImage = $curElem.querySelector(".svgFrame-img image");
    var svgRatio = $svg.width.baseVal.value / $svg.viewBox.baseVal.width;

    var type = this.startData.type;
    var rectRatio = this.startData.targData.rectRatio;
    var bg_width, bg_height;

    // 计算 bg 宽高
    if (rectRatio >= 1) {
        if (type === "se" || type === "ne") {
            bg_width = this.startData.targData.width + mouseMetabolic.x;
        } else {
            bg_width = this.startData.targData.width - mouseMetabolic.x;
        }
        bg_width = (bg_width > 1)?(bg_width):1;
        bg_height = bg_width / rectRatio;
    } else {
        if (type === "se" || type === "sw") {
            bg_height = this.startData.targData.height + mouseMetabolic.y;
        } else {
            bg_height = this.startData.targData.height - mouseMetabolic.y;
        }
        bg_height = bg_height > 1 ? bg_height : 1;
        bg_width = bg_height * rectRatio;
    }

    // 计算 bg 偏移
    var bgRect = this.startData.targData.bgRect;
    var editorRect = this.startData.targData.editorRect;
    var bg_left = this.startData.targData.left;
    var bg_top = this.startData.targData.top;
    var target_ew, target_eh;

    switch (type) {
        case "se":
            if (bg_left + bg_width < $frameEditor.oldFrameData.eWidth) {
                bg_width = $frameEditor.oldFrameData.eWidth - bg_left;
                bg_height = bg_width / rectRatio;
            }
            if (bg_top + bg_height < $frameEditor.oldFrameData.eHeight) {
                bg_height = $frameEditor.oldFrameData.eHeight - bg_top;
                bg_width = bg_height * rectRatio;
            }
            break;
        case "sw":
            target_ew = this.startData.targData.width + this.startData.targData.left;
            if (bg_height + bgRect.top < editorRect.bottom) {
                bg_height = editorRect.bottom - bgRect.top;
                bg_width = bg_height * rectRatio;
            }
            bg_left = target_ew - bg_width ;
            bg_left = bg_left < 0?bg_left:0;
            if (bg_left >= 0) {
                bg_left = 0;
                bg_width = target_ew - bg_left;
                bg_height = bg_width / rectRatio;
            }
            break;
        case "nw":
            target_ew = this.startData.targData.width + this.startData.targData.left;
            target_eh = this.startData.targData.height + this.startData.targData.top;
            if (bg_width + editorRect.left < bgRect.right) {
                bg_width = bgRect.right - editorRect.left;
                bg_height = bg_width / rectRatio;
            }
            if (bg_height + editorRect.top < bgRect.bottom) {
                bg_height = bgRect.bottom - editorRect.top;
                bg_width = bg_height * rectRatio;
            }
            bg_left = target_ew - bg_width ;
            bg_top = target_eh - bg_height;
            break;
        case "ne":
            target_eh = this.startData.targData.height + this.startData.targData.top;
            if (bg_width + bgRect.left < editorRect.right) {
                bg_width = editorRect.right - bgRect.left;
                bg_height = bg_width / rectRatio;
                
            }
            bg_top = target_eh - bg_height;
            if (bg_top >= 0) {
                bg_top = 0;
                bg_height = target_eh - bg_top;
                bg_width = bg_height * rectRatio;
            }
            break;
    }

    // 计算 image 素材 宽高
    var image_width = bg_width / media.tool.showRatio / svgRatio;
    var image_height = bg_height / media.tool.showRatio / svgRatio;

    // 赋值
    Z($frameImgBg).css({
        "width": bg_width,
        "height": bg_height,
        "left": bg_left,
        "top": bg_top,
    });
    $frameImage.setAttribute("width", image_width + "");
    $frameImage.setAttribute("height", image_height + "");
    // 对应素材的图片位移
    var image_x = bg_left / media.tool.showRatio / svgRatio;
    var image_y = bg_top / media.tool.showRatio / svgRatio;
    $frameImage.setAttribute("transform","translate(" + image_x + " " + image_y + ")");
},
frameBgResizeDone: function() {
    // 事件绑定
    Z(media.tool.$designStage).off("mousemove",this.frameBgResizeDoing,this);
    Z(media.tool.$designStage).off("mouseup mouseleave",this.frameBgResizeDone,this);
},
//清除容器裁剪工具
frameBgDragSure: function(){
    //保存历史记录
    updateMaterialSource();
    saveHistory();
    //清除剪切工具
    this.frameBgDragClear();
},
frameBgDragCancel: function(){
    var $curElem = media.tool.tempElement;
    var $frameImage = $curElem.querySelector(".svgFrame-img image");
    var oldFrameData = Z("#imgFrameEditor")[0].oldFrameData;
    $frameImage.setAttribute("width",oldFrameData.width);
    $frameImage.setAttribute("height",oldFrameData.height);
    $frameImage.setAttribute("transform",oldFrameData.trans);
    //清除剪切工具
    this.frameBgDragClear();
},
frameBgDragClear: function(event) {
    if (!Z("#imgFrameEditor")[0].hasAttribute("style")){
        return;
    }
    media.tool.setTempCurrent();
    Z("#imgFrameEditor").removeAttr("style");
},

// 图片容器，进入素材，替换图片
svgFrameMouseEnter: function (event)
{
    this.dragFrameImg = null;
    if (!this.dragMaterial) {
        return;
    }
    // 拖动的素材
    var tMaterial = this.dragMaterial;
    if (tMaterial.type !== 0 && tMaterial.type !== 2) {         //如果不是图片、二维码
        return;
    }

    // 容器对象
    var $frameGelem = Z.E.current(event);
    var $frameImage = $frameGelem.querySelector("image");
    var $thisNode = $frameGelem;
    var $default = $thisNode.previousElementSibling;
    while(!$default || $default.getAttribute('class') !== 'svgFrame-default') {
        $thisNode = $thisNode.parentNode;
        $default = $thisNode.previousElementSibling;
    }

    // 隐藏默认背景
    $default.setAttribute('style', 'display:none;');

    // 获取拖动图片的链接地址
    var $tElem = media.tool.getSvgElementByMid(tMaterial.mid);
    if (!$tElem) {
        return;
    }
    var $tSvg = $tElem.querySelector("svg");
    var $tImage = $tElem.querySelector("image");
    if (!$tSvg || !$tImage) {
        return;
    }
    var imgHref = $tImage.getAttribute("xlink:href");
    var frameHref = $frameImage.getAttribute("xlink:href");
    if (!imgHref) {
        return;
    }
    // 设置容器中的图片链接地址
    $frameImage.setAttribute("xlink:href", imgHref);
    $frameImage.setAttribute("href", imgHref);

    // 保存原始数据
    var old_trans = $frameImage.getAttribute("transform");
    var $img_rect = $frameImage.nextElementSibling;
    var old_width = parseFloat($frameImage.getAttribute("width"));
    var old_height = parseFloat($frameImage.getAttribute("height"));
    this.dragFrameImg = {
        "$default" : $default,
        "width": old_width,
        "height": old_height,
        "trans": old_trans,
        "url": frameHref || "",
    };
    // 设置图片大小
    var rect_width = $img_rect.width.baseVal.value;
    var rect_height = $img_rect.height.baseVal.value;
    var rect_x = $img_rect.x.baseVal.value;
    var rect_y = $img_rect.y.baseVal.value;
    var rect_ratio = rect_width / rect_height;
    var img_width = $tSvg.viewBox.baseVal.width;
    var img_height = $tSvg.viewBox.baseVal.height;
    var img_ratio = img_width / img_height;
    var set_width = rect_width;
    var set_height = rect_height;
    if (rect_ratio > img_ratio) {
        set_height = set_width / img_ratio;
    } else {
        set_width = set_height * img_ratio;
    }
    $frameImage.setAttribute("width",set_width);
    $frameImage.setAttribute("height",set_height);
    // 设置偏移
    var set_x = (rect_width - set_width)/2 + rect_x;
    var set_y = (rect_height - set_height)/2 + rect_y;
    var set_trans = "translate(" + set_x + " " + set_y + ")";
    $frameImage.setAttribute("transform",set_trans);
},
// 图片容器，离开素材，替换图片
svgFrameMouseLeave: function (event)
{
    if (!this.dragMaterial) {
        return;
    }
    // 拖动的素材
    var tMaterial = this.dragMaterial;
    if (tMaterial.type !== 0 && tMaterial.type !== 2) {         //如果不是图片、二维码
        return;
    }
    // 容器对象
    var $frameGelem = Z.E.current(event);
    var $frameImage = $frameGelem.querySelector("image");
    // 获取拖动图片的链接地址
    var $tElem = media.tool.getSvgElementByMid(tMaterial.mid);
    if (!$tElem) {
        return;
    }
    var $tSvg = $tElem.querySelector("svg");
    var $tImage = $tElem.querySelector("image");
    if (!$tSvg || !$tImage) {
        return;
    }
    // 判断是否为同一张图片
    var imgHref = $tImage.getAttribute("xlink:href");
    var frameHref = $frameImage.getAttribute("xlink:href");
    if (!imgHref || !frameHref || frameHref !== imgHref) {
        return;
    }
    if (!this.dragFrameImg) {
        return;
    }

    // 显示默认背景
    if (this.dragFrameImg.url === frameDefaultUrl){
        this.dragFrameImg.$default.removeAttribute('style');
    }
    $frameImage.setAttribute("xlink:href",this.dragFrameImg.url);
    $frameImage.setAttribute("href",this.dragFrameImg.url);
    $frameImage.setAttribute("width",this.dragFrameImg.width);
    $frameImage.setAttribute("height",this.dragFrameImg.height);
    $frameImage.setAttribute("transform",this.dragFrameImg.trans);
    this.dragFrameImg = null;
},
// 图片容器，松开替换
svgFrameMouseUp: function(event){
    if (!this.dragFrameImg) return;
    var $frameImage = Z.E.current(event).querySelector("image");
    var $$gElem = Z("[id^=svgElementSon_]");
    var i, $elem, $image, $curElem, material;
    for(i = 0;i < $$gElem.length;i++){
        $elem = $$gElem[i];
        $image = $elem.querySelector(".svgFrame-img image");
        if ($image === $frameImage){
            $curElem = $elem;
            material = media.getMaterialByMid($curElem.getAttribute("data-mid"));
            break;
        }
    }
    // 清除对齐辅助线
    Z(".guide-line").remove();
    // 清除事件
    Z(media.tool.$designStage).off("mousemove",this.singleDragDoing,this);
    Z(media.tool.$designStage).off("mouseup mouseleave",this.singleDragDone,this);
    // 清空保存数据
    this.dragMaterial = null;
    this.dragFrameImg = null;
    // 赋值fileId，删除
    material.fileId = media.getCurMaterial().fileId;
    deleteMaterial(true);
    // 保存
    updateMaterialSource(material, $curElem);
    saveHistory();
},

/********************************************
 ***************** 八：图片裁剪 ***************
 ********************************************/
// 显示图片剪切、裁剪辅助框
showCutImage: function (material, $curElem)
{
    var showRatio = media.tool.showRatio;
    var $svg = $curElem.querySelector("svg");
    var $image = $curElem.querySelector("image");
    var svgViewBox = $svg.viewBox.baseVal;
    var source_src = $image.getAttribute("xlink:href") || $image.getAttribute("href");

    var $imageTool = Z.D.id("cutImageTool");
    var $imageRect = Z.D.id("cutToolRect");
    var $imageCut = Z.D.id("cutToolImg");
    var $bgImg = $imageTool.querySelector("img");
    var $cutImg = $imageCut.querySelector("img");

    // 宽高
    var source_width = $image.width.baseVal.valueAsString;
    var source_height = $image.height.baseVal.valueAsString;
    // 兼容处理（image 宽高设置为 100% 的素材）
    if (svgViewBox.x === 0 && svgViewBox.y === 0 && source_width === "100%" && source_height === "100%"){
        source_width = svgViewBox.width;
        source_height = svgViewBox.height;
        $image.setAttribute("width", source_width);
        $image.setAttribute("height", source_height);
    }
    var rect_width = $svg.width.baseVal.value;
    var rect_height = $svg.height.baseVal.value;
    var svgRatio = rect_width / svgViewBox.width;

    // 保存必要数据
    $curElem.svgRatio = svgRatio;

    var wrap_width = source_width * svgRatio;
    var wrap_height = source_height * svgRatio;
    // 偏移
    var elemMatrix = $curElem.transform.baseVal[0].matrix;
    var rect_left = svgViewBox.x * svgRatio;
    var rect_top = svgViewBox.y * svgRatio;

    // 判断是否有翻转，重新计算 rect_left、rect_top
    if (material.reversal !== "1 1"){
        var reversalArr = material.reversal.split(" ");
        if (reversalArr[0] === "-1"){
            rect_left = wrap_width - rect_width - rect_left;
        }
        if (reversalArr[1] === "-1"){
            rect_top = wrap_height - rect_height - rect_top;
        }
        Z($bgImg).css({
            "transform": "scale(" + reversalArr.join(",") + ")",
        });
        Z($cutImg).css({
            "transform": "scale(" + reversalArr.join(",") + ")",
        });
    }

    var wrap_r = $curElem.transform.baseVal[1].angle;
    var wrap_trans = "rotate(" + wrap_r + "deg)";
    wrap_r *= Math.PI / 180;
    var wrap_left = elemMatrix.e - (rect_left * Math.cos(wrap_r) - rect_top * Math.sin(wrap_r));
    var wrap_top = elemMatrix.f - (rect_left * Math.sin(wrap_r) + rect_top * Math.cos(wrap_r));
    wrap_left -= (wrap_width / 2 - rect_width / 2);
    wrap_top -= (wrap_height / 2 - rect_height / 2);
    wrap_left +=  (wrap_width / 2 - rect_width / 2) * Math.cos(wrap_r) - (wrap_height / 2 - rect_height / 2) * Math.sin(wrap_r);
    wrap_top += (wrap_width / 2 - rect_width / 2) * Math.sin(wrap_r) + (wrap_height / 2 - rect_height / 2) * Math.cos(wrap_r);

    // 判断首次裁剪，裁剪框定位；2 为误差范围
    if (Math.abs(wrap_width - rect_width) < 2 && Math.abs(wrap_height - rect_height) < 2)
    {
        rect_width = wrap_width * 2 / 3;
        rect_height = wrap_height * 2 / 3;
        rect_left = wrap_width / 6;
        rect_top = wrap_height / 6;
    }

    // 展示裁剪工具
    var stageRect = media.tool.$stageCanvas.getBoundingClientRect();
    var canvasRect = media.tool.$canvasBg.getBoundingClientRect();
    var mLeft = canvasRect.left - stageRect.left;
    var mTop = canvasRect.top - stageRect.top;

    wrap_width *= showRatio;
    wrap_height *= showRatio;
    wrap_left *= showRatio;
    wrap_top *= showRatio;

    // 偏移计算，添加特殊尺寸删减部分
    wrap_left += mLeft;
    wrap_top += mTop;

    Z($imageTool).css({
        "width": wrap_width,
        "height": wrap_height,
        "left": wrap_left,
        "top": wrap_top,
        "transform": wrap_trans,
    });

    rect_width *= showRatio;
    rect_height *= showRatio;
    rect_left *= showRatio;
    rect_top *= showRatio;

    Z($imageRect).css({
        "width": rect_width,
        "height": rect_height,
        "left": rect_left,
        "top": rect_top,
    });
    $bgImg.setAttribute("src",source_src);
    $cutImg.setAttribute("src",source_src);
    Z($cutImg).css({
        "width": wrap_width,
        "height": wrap_height,
        "left": "-" + rect_left + "px",
        "top": "-" + rect_top + "px",
    });

    // 隐藏所有
    hideEditSelected();
    media.tool.setTempCurrent(material,$curElem);

    // 定义 stargData
    this.startData.targData = media.tool.getEleData($curElem);

    // 事件绑定
    Z($imageTool).on("click",Z.E.forbidden);
    Z("#cutToolRect").on("mousedown", mediaEvent.cutImageDragStart, mediaEvent);
    Z("#cutToolPoint>.point").on("mousedown", mediaEvent.cutImageZoomStart, mediaEvent);
    Z("#cutToolBtn .cutToolBtn-sure").on("click", mediaEvent.cutImageSure, mediaEvent);
    Z("#cutToolBtn .cutToolBtn-cancel").on("click", mediaEvent.cutImageCancel, mediaEvent);
},
// 拖动裁剪框 开始
cutImageDragStart: function(event)
{
    Z.E.forbidden(event);
    var $imageTool = Z.D.id("cutImageTool");
    var $imageRect = Z.D.id("cutToolRect");

    // 定义 startData
    this.startData.mouseLoc = getMouseLocation(event);
    this.startData.toolData = {
        "w" : parseFloat(Z($imageTool).css("width")),
        "h" : parseFloat(Z($imageTool).css("height")),
        "x" : parseFloat(Z($imageTool).css("left")),
        "y" : parseFloat(Z($imageTool).css("top"))
    };
    this.startData.rectData = {
        "w" : parseFloat(Z($imageRect).css("width")),
        "h" : parseFloat(Z($imageRect).css("height")),
        "x" : parseFloat(Z($imageRect).css("left")),
        "y" : parseFloat(Z($imageRect).css("top"))
    };

    // 事件绑定
    Z(media.tool.$designStage).on("mousemove",this.cutImageDragDoing,this);
    Z(media.tool.$designStage).on("mouseup mouseleave",this.cutImageDragDone,this);
},
// 拖动裁剪框 执行
cutImageDragDoing: function (event)
{
    Z.E.cancel(event);
    //计算鼠标偏移量
    var nowMouseLoc = getMouseLocation(event);
    var mouseMetabolic = {
        "x": nowMouseLoc.x - this.startData.mouseLoc.x,
        "y": nowMouseLoc.y - this.startData.mouseLoc.y,
    }
    if (mouseMetabolic.x == 0 && mouseMetabolic.y == 0) {
        return;
    }
    var mouseAngle;
    var l = Math.sqrt(Math.pow(mouseMetabolic.x, 2) + Math.pow(mouseMetabolic.y, 2));
    var absAngle = Math.atan(Math.abs(mouseMetabolic.y) / Math.abs(mouseMetabolic.x));
    var rectAngle = 90 * Math.PI / 180;
    if (mouseMetabolic.x > 0 && mouseMetabolic.y == 0){           //x正轴
        mouseAngle = 0;
    } else if (mouseMetabolic.x > 0 && mouseMetabolic.y > 0){    //第一象限
        mouseAngle = absAngle;
    } else if (mouseMetabolic.x == 0 && mouseMetabolic.y > 0){   //y正轴
        mouseAngle = rectAngle;
    } else if (mouseMetabolic.x < 0 && mouseMetabolic.y > 0){    //第二象限
        mouseAngle = 2 * rectAngle - absAngle;
    } else if (mouseMetabolic.x < 0 && mouseMetabolic.y == 0){   //x负轴
        mouseAngle = 2 * rectAngle;
    } else if (mouseMetabolic.x < 0 && mouseMetabolic.y < 0){    //第三象限
        mouseAngle = 2 * rectAngle + absAngle;
    } else if (mouseMetabolic.x == 0 && mouseMetabolic.y < 0){   //y负轴
        mouseAngle = 3 * rectAngle;
    } else if (mouseMetabolic.x > 0 && mouseMetabolic.y < 0){    //第四象限
        mouseAngle = 4 * rectAngle - absAngle;
    }
    var true_x = l * Math.cos(mouseAngle - this.startData.targData.rotate*Math.PI/180);
    var true_y = l * Math.sin(mouseAngle - this.startData.targData.rotate*Math.PI/180);

    //计算 rect 最大值；（最小值为 0）
    var limit_left = this.startData.toolData.w - this.startData.rectData.w;
    var limit_top = this.startData.toolData.h - this.startData.rectData.h;
    var rect_left = this.startData.rectData.x + true_x;
    var rect_top = this.startData.rectData.y + true_y;
    rect_left = rect_left > 0 ? rect_left : 0;
    rect_top = rect_top > 0 ? rect_top : 0;
    rect_left = rect_left < limit_left ? rect_left : limit_left;
    rect_top = rect_top < limit_top ? rect_top : limit_top;

    var $imageRect = Z.D.id("cutToolRect");
    var $cutImg = $imageRect.querySelector("img");
    Z($imageRect).css({
        "left" : rect_left,
        "top" : rect_top,
    });
    //判断是否有翻转

    var material = media.tool.tempMaterial;
    Z($cutImg).css({
        "left" : "-" + rect_left + "px",
        "top" : "-" +rect_top + "px",
    });
},
// 拖动裁剪框 结束
cutImageDragDone: function (event)
{
    // 取消绑定事件
    Z(media.tool.$designStage).off("mousemove",this.cutImageDragDoing,this);
    Z(media.tool.$designStage).off("mouseup mouseleave",this.cutImageDragDone,this);
},

// 缩放裁剪框 开始
cutImageZoomStart: function(event)
{
    Z.E.forbidden(event);

    var $imageTool = Z.D.id("cutImageTool");
    var $imageRect = Z.D.id("cutToolRect");

    // 定义 startData
    this.startData.zoomType = Z(Z.E.current(event)).attr("data-type");
    this.startData.mouseLoc = getMouseLocation(event);
    this.startData.toolData = {
        "w" : parseFloat(Z($imageTool).css("width")),
        "h" : parseFloat(Z($imageTool).css("height")),
        "x" : parseFloat(Z($imageTool).css("left")),
        "y" : parseFloat(Z($imageTool).css("top"))
    };
    this.startData.rectData = {
        "w" : parseFloat(Z($imageRect).css("width")),
        "h" : parseFloat(Z($imageRect).css("height")),
        "x" : parseFloat(Z($imageRect).css("left")),
        "y" : parseFloat(Z($imageRect).css("top"))
    };

    // 事件绑定
    Z(media.tool.$designStage).on("mousemove",this.cutImageZoomDoing,this);
    Z(media.tool.$designStage).on("mouseup mouseleave",this.cutImageZoomDone,this);
},
// 缩放裁剪框 缩放中
cutImageZoomDoing: function (event)
{
    Z.E.cancel(event);
    //计算鼠标偏移量
    var true_data = getElementTrueEX(getMouseLocation(event), this.startData.mouseLoc.x, this.startData.mouseLoc.y, this.startData.targData.rotate);
    var true_x = true_data.x;
    var true_y = true_data.y;
    if (true_x === 0 && true_y === 0)
        return;

    //定义 rect 定位临界值
    var limit_left = this.startData.toolData.w;
    var limit_top = this.startData.toolData.h;
    var limit_width = this.startData.toolData.w;
    var limit_height = this.startData.toolData.h;

    // rect 参数
    var rect_left = this.startData.rectData.x;
    var rect_top = this.startData.rectData.y;
    var rect_width = this.startData.rectData.w;
    var rect_height = this.startData.rectData.h;
    // tool 参数
    var tool_width = this.startData.toolData.w;
    var tool_height = this.startData.toolData.h;

    //缩放类型
    switch (this.startData.zoomType)
    {
        case "ne":
            //计算 rect 大小临界值
            limit_width = tool_width - rect_left;
            limit_height = rect_height + rect_top;

            //计算 rect 结果
            rect_top += true_y;
            rect_width += true_x;
            rect_height -= true_y;
            break;
        case "se":
            //计算 tool 大小临界值
            limit_width = tool_width - rect_left;
            limit_height = tool_height - rect_top;

            //计算 tool 结果
            rect_width += true_x;
            rect_height += true_y;
            break;
        case "sw":
            //计算 tool 大小临界值
            limit_width = rect_width + rect_left;
            limit_height = tool_height - rect_top;

            //计算 tool 结果
            rect_left += true_x;
            rect_width -= true_x;
            rect_height += true_y;
            break;
        case "nw":
            //计算 tool 大小临界值
            limit_width = rect_width + rect_left;
            limit_height = rect_height + rect_top;

            //计算 tool 结果
            rect_left += true_x;
            rect_top += true_y;
            rect_width -= true_x;
            rect_height -= true_y;
            break;
    }

    //计算 rect 结果
    rect_left = rect_left > 0 ? (rect_left < limit_left ? rect_left : limit_left) : 0;
    rect_top = rect_top > 0 ? (rect_top < limit_top ? rect_top : limit_top) : 0;
    rect_width = rect_width > 0 ? (rect_width < limit_width ? rect_width : limit_width) : 0;
    rect_height = rect_height > 0 ? (rect_height < limit_height ? rect_height : limit_height) : 0;

    //呈现
    var $imageRect = Z.D.id("cutToolRect");
    var $imageCut = Z.D.id("cutToolImg");
    var $cutImg = $imageCut.querySelector("img");
    Z($imageRect).css({
        "left" : rect_left,
        "top" : rect_top,
        "width" : rect_width,
        "height" : rect_height,
    });
    Z($cutImg).css({
        "left" : "-" + rect_left + "px",
        "top" :  "-" +rect_top + "px",
    });
},
// 缩放裁剪框 结束
cutImageZoomDone: function (event)
{
    // 取消绑定事件
    Z(media.tool.$designStage).off("mousemove",this.cutImageZoomDoing,this);
    Z(media.tool.$designStage).off("mouseup mouseleave",this.cutImageZoomDone,this);
},

// 确认完成剪切
cutImageSure: function(event)
{
    // 1：定义可以参数
    Z.E.forbidden(event);
    var material = media.tool.tempMaterial;
    var $curElem = media.tool.tempElement;
    var $gSvg = $curElem.querySelector("g");
    var $rect = $curElem.querySelector("rect");
    var $svg = $gSvg.querySelector("svg");
    var showRatio = media.tool.showRatio;
    var svgRatio = $curElem.svgRatio;

    // 2：计算 translate 偏移
    var $imageTool = Z.D.id("cutImageTool");
    var $imageRect = Z.D.id("cutToolRect");
    var svg_width = $svg.width.baseVal.value;
    var svg_height = $svg.height.baseVal.value;
    var tool_width = parseFloat(Z($imageTool).css("width"));
    var tool_height = parseFloat(Z($imageTool).css("height"));
    var rect_left = parseFloat(Z($imageRect).css("left"));
    var rect_top = parseFloat(Z($imageRect).css("top"));
    var rect_width = parseFloat(Z($imageRect).css("width"));
    var rect_height = parseFloat(Z($imageRect).css("height"));
    var curTrans = $curElem.transform.baseVal;
    var angle = curTrans[1].angle * Math.PI / 180;
    var trans_x = curTrans[0].matrix.e;
    var trans_y = curTrans[0].matrix.f;
    var svgViewBox = $svg.viewBox.baseVal;
    var view_left = svgViewBox.x;
    var view_top = svgViewBox.y;
    var reversalArr = [1,1];
    if (material.reversal !== "1 1") {
        reversalArr = material.reversal.split(" ");
        reversalArr = reversalArr.map(parseFloat);
    }

    // 3：重新计算 rect_left、rect_top
    // 设置翻转元素 g 偏移
    var gSvgX = 0, gSvgY = 0;
    if (reversalArr[0] === -1){
        rect_left = tool_width - rect_width - rect_left;
        //view_left = source_width - svgViewBox.x - svgViewBox.width;
        gSvgX = rect_width / showRatio;
    }
    if (reversalArr[1] === -1){
        rect_top = tool_height - rect_height - rect_top;
        gSvgY = rect_height / showRatio;
    }
    $gSvg.setAttribute("transform", "translate(" + gSvgX +" " + gSvgY + ") scale(" + material.reversal + ")");

    // 4：计算 $curElem 偏移
    var mLeft = reversalArr[0] * (rect_left / showRatio - view_left * svgRatio);
    var mTop = reversalArr[1] * (rect_top / showRatio - view_top * svgRatio);
    mLeft += reversalArr[0] === -1 ? (svg_width - rect_width / showRatio) : 0;
    mTop += reversalArr[1] === -1 ? (svg_height - rect_height / showRatio) : 0;
    trans_x += mLeft * Math.cos(angle) - mTop * Math.sin(angle);
    trans_y += mLeft * Math.sin(angle) + mTop * Math.cos(angle);

    var translate_str = "translate(" + trans_x + " " + trans_y + ")";
    var trans = $curElem.getAttribute("transform");
    trans = trans.replace(/translate\([^)]*\)/, translate_str);
    $curElem.setAttribute("transform",trans);

    // 5：计算 viewBox 大小
    var viewBox_x = rect_left / svgRatio;
    var viewBox_y = rect_top / svgRatio;
    var viewBox_w = rect_width / svgRatio;
    var viewBox_h = rect_height / svgRatio;

    viewBox_x /= showRatio;
    viewBox_y /= showRatio;
    viewBox_w /= showRatio;
    viewBox_h /= showRatio;
    $svg.setAttribute("viewBox", viewBox_x + " " + viewBox_y + " " + viewBox_w + " " + viewBox_h);

    // 6：赋值 svg、rect 宽高
    rect_width /= showRatio;
    rect_height /= showRatio;
    $svg.setAttribute("width", rect_width + "");
    $svg.setAttribute("height", rect_height + "");
    $rect.setAttribute("width", rect_width + "");
    $rect.setAttribute("height", rect_height + "");

    // 7：校准偏移
    editOverSet($curElem);

    // 8：更新素材
    updateMaterialSource(material, $curElem);
    saveHistory();

    // 9：取消素材选择
    media.clearSelected();

    // 10：隐藏剪切工具
    this.cutImageToolHide();

    // 11：图片圆角处理
    var $imgRadioDef = $svg.querySelector('[id^=radius_svgElementSon_]');
    if ($imgRadioDef)
    {
        var $radioRect = $imgRadioDef.querySelector('rect');
        if ($radioRect)
        {
            $radioRect.setAttribute('x', viewBox_x + '');
            $radioRect.setAttribute('y', viewBox_y + '');
            $radioRect.setAttribute('width', viewBox_w + '');
            $radioRect.setAttribute('height', viewBox_h + '');
        }
    }
},
// 取消剪切
cutImageCancel: function(event)
{
    Z.E.forbidden(event);
    // 取消素材选择
    media.clearSelected();
    this.cutImageToolHide();
},
// 剪切辅助框隐藏
cutImageToolHide: function ()
{
    if (!Z("#cutImageTool")[0].hasAttribute("style")){
        return;
    }
    // 清空临时变量
    media.tool.setTempCurrent();
    // 剪切工具复原
    Z("#cutImageTool, #cutToolRect, #cutImageTool img").removeAttr("style");
},

/********************************************
 **************** 九：钢笔工具 **************
 ********************************************/
// 钢笔路径，显示为编辑状态
showPenEditTool: function (material, $curElem)
{
    // 素材宽高缩放、旋转后，像素点的偏移
    function thePointAfterSet(pX, pY)
    {
        pX = pX * xPlus;
        pY = pY * yPlus;
        var cMX = centerPoint.x - pX;
        var cMY = centerPoint.y - pY;
        var absHypotenuse = Math.sqrt(cMX * cMX + cMY * cMY);
        var angle = (180 - elemTrans.rotate) / 2;
        angle *= Math.PI / 180;
        var absM = (absHypotenuse * Math.cos(angle)) * 2;
        angle -= Math.atan(cMY / cMX);
        if (cMX < 0)
            angle += Math.PI;
        var mx = absM * Math.cos(angle);
        var my = absM * Math.sin(angle);
        return {
            'x' : pX + mx,
            'y' : pY - my,
        }
    }
    // 钢笔编辑工具展示
    function setToolStyle()
    {
        // 重设曲线起点坐标
        function resetPathStart()
        {
            var startPoint = pathStart.replace(/M|\s$/g, '');
            startPoint = startPoint.split(',');
            var sPX = parseFloat(startPoint[0]);
            var sPY = parseFloat(startPoint[1]);
            startPoint = thePointAfterSet(sPX, sPY);
            pathStart = 'M' + (startPoint.x + elemTrans.x) + ',' + (startPoint.y + elemTrans.y) + ' ';
        }
        // 重设曲线锚点坐标
        function resetBezier()
        {
            // 主方法
            dBezier = dBezier.map(function(bezier)
            {
                bezier = bezier.substring(1);
                var points = bezier.split(' ');
                points = points.map(function(pointData)
                {
                    var pointLoc = pointData.split(',');
                    var pLocX = parseFloat(pointLoc[0]);
                    var pLocY = parseFloat(pointLoc[1]);
                    var resultLoc = thePointAfterSet(pLocX, pLocY);
                    return (resultLoc.x + elemTrans.x) + ',' + (resultLoc.y + elemTrans.y);
                });
                return 'C' + points.join(' ');
            });
        }
        // 显示锚点编辑工具
        function showToolItem()
        {
            // 计算当前切线 prev 的偏移属性
            function setPrevTangent()
            {
                var $thePrev = $theTangent.find('.penTangent-item-prev');
                var prevPoint = pointList[1].split(',');
                var prevPointX = parseFloat(prevPoint[0]);
                var prevPointY = parseFloat(prevPoint[1]);
                var pointMX = thePointX - prevPointX;
                var pointMY = thePointY - prevPointY;
                prevAngle = Math.atan(pointMY / pointMX) * 180 / Math.PI;
                if (pointMX < 0)
                    prevAngle += 180;
                prevWidth = Math.sqrt(pointMX * pointMX + pointMY * pointMY) * showRatio;
                $thePrev.css({
                    'transform': 'translate(calc(-100% + 5.5px), 0) rotate(' + prevAngle + 'deg)',
                    'width' : prevWidth + 'px'
                });
            }
            // 计算前个切线 next 偏移属性
            function setNextTangent()
            {
                var $theNext = $theTangent.find('.penTangent-item-next');
                var nextIndex = (i === dBezier.length - 1) ? 0 : (i + 1);
                var nextPointList = dBezier[nextIndex].substring(1).split(' ');
                var nextPoint = nextPointList[0].split(',');
                var nextPointX = parseFloat(nextPoint[0]);
                var nextPointY = parseFloat(nextPoint[1]);
                var pointMX = nextPointX - thePointX;
                var pointMY = nextPointY - thePointY;
                nextAngle = Math.atan(pointMY / pointMX) * 180 / Math.PI;
                if (pointMX < 0)
                    nextAngle += 180;
                nextWidth = Math.sqrt(pointMX * pointMX + pointMY * pointMY) * showRatio;
                $theNext.css({
                    'transform': 'translate(5.5px, 0) rotate(' + nextAngle + 'deg)',
                    'width' : nextWidth + 'px'
                });
            }
            // 检测“分离”属性，前后两切线的偏移是否相等（差值小于最小误差）
            function checkSeparateAttribute()
            {
                var minMWidth = .5;
                var minMAngle = .5;
                var adsMWidth = Math.abs(nextWidth - prevWidth);
                var adsMAngle = Math.abs(nextAngle - prevAngle);
                var isSeparate = false;
                if (adsMWidth > minMWidth && adsMAngle > minMAngle)
                    isSeparate = true;
                if (isSeparate)
                    $theTangent.attr('data-separate', 'separate');
            }

            // 主方法：循环处理
            Z($tangentWrap).addClass('editPath');
            var showRatio = media.tool.showRatio;
            var mLeft = canvasRect.left - coverRect.left;
            var mTop = canvasRect.top - coverRect.top;
            var coverWidth = coverRect.width;
            var coverHeight = coverRect.height;
            var i, pointList, $$allTangent, tangentLength, $theTangent, thePoint,
                thePointX, thePointY, thePX, thePY, prevWidth, prevAngle, nextWidth, nextAngle;
            for (i = 0;i < dBezier.length;i++)
            {
                // 1：当前曲线
                pointList = dBezier[i].substring(1).split(' ');
                // 2：所有已存在的切线
                $$allTangent = $tangentWrap.querySelectorAll('.penTangent-item');
                tangentLength = $$allTangent.length;
                // 3：插入新切线
                $theTangent = Z(newTangentString);
                Z($tangentWrap).append($theTangent);
                $theTangent.attr('data-index', tangentLength);
                $theTangent.addClass('active');
                // 4：切线锚点位置
                thePoint = pointList[2].split(',');
                thePointX = parseFloat(thePoint[0]);
                thePointY = parseFloat(thePoint[1]);
                thePX = (thePointX * showRatio + mLeft) / coverWidth * 100 + '%';
                thePY = (thePointY * showRatio + mTop) / coverHeight * 100 + '%';
                $theTangent.css({
                    'left': thePX,
                    'top': thePY,
                });
                // 5：当前切线的 prev ：长度、旋转
                setPrevTangent();
                // 6：当前切线的 next：长度、旋转
                setNextTangent();
                // 7：检测“分离”属性
                checkSeparateAttribute();
            }
        }

        // 1：隐藏必要工具
        hideEditSelected();

        // 2：遮罩层显示
        Z($penCover).addClass('readyDrawing readyEdit');

        // 3：定义操作类型
        mediaEvent.shapeType = '11';

        // 4：计算并显示新路径
        resetPathStart();
        resetBezier();
        setD = pathStart + dBezier.join(' ') + pathEnd;
        $path.setAttribute('d', setD);

        // 5：显示锚点工具
        showToolItem();
    }
    // 重设素材的大小、偏移
    function resetElemView()
    {
        $curElem.removeAttribute('transform');
        $svg.removeAttribute('data-oldwidth');
        $svg.removeAttribute('data-oldheight');
        $svg.setAttribute('viewBox', '0 0 ' + canvasWidth + ' ' + canvasHeight);
        $svg.setAttribute('width', canvasWidth + '');
        $svg.setAttribute('height', canvasHeight + '');
        $curElem.removeChild($rect);
    }
    // 获得素材的偏移
    function getElemTrans()
    {
        var transList = $curElem.transform.baseVal;
        var matrix = null, rotate = null;
        [].forEach.call(transList, function(obj){
            if (obj.type !== 2 && obj.type !== 4)
                return;
            if (obj.type === 2) matrix = obj.matrix;
            if (obj.type === 4) rotate = obj.angle;
        });
        return {
            'x' : matrix.e,
            'y' : matrix.f,
            'rotate' : rotate,
        };
    }

    // 主方法，定义变量
    var canvasRect = media.tool.$canvasBg.getBoundingClientRect();
    var svgView = media.tool.$canvasSvg.viewBox.baseVal;
    var canvasWidth = svgView.width;
    var canvasHeight = svgView.height;
    var $penCover = Z.D.id('penEditorCover');
    var $tangentWrap = Z.D.id('penTangentTool');
    var coverRect = media.tool.$designStage.getBoundingClientRect();
    var $rect = $curElem.querySelector("rect");
    var $svg = $curElem.querySelector("svg");
    var $path = $svg.querySelector("path");
    var viewWidth = $svg.viewBox.baseVal.width;
    var viewHeight = $svg.viewBox.baseVal.height;
    var svgWidth = $svg.width.baseVal.value;
    var svgHeight = $svg.height.baseVal.value;
    var xPlus = svgWidth / viewWidth;
    var yPlus = svgHeight / viewHeight;
    var elemTrans = getElemTrans();
    var centerPoint = {
        'x' : svgWidth / 2,
        'y' : svgHeight / 2,
    };
    var setD = $path.getAttribute('d');
    var pathStart = /^M[^C]+\s/.exec(setD);
    var dBezier = setD.match(/C[^C\s]+\s[^C\s]+\s[^C\s]+/g);
    var pathEnd = /\sZ$/.exec(setD);
    pathStart = pathStart && pathStart[0];
    pathEnd = (pathEnd && pathEnd[0]) || '';

    // 1：设置工具样式
    setToolStyle();

    // 2：设置素材的 偏移、大小
    resetElemView();

    // 3：定义临时数据，用于编辑
    this.elemEditToolData = {};
    this.elemEditToolData.pathStart = pathStart;
    this.elemEditToolData.pathBezier = dBezier;
    this.elemEditToolData.pathEnd = pathEnd;
    this.elemEditToolData.material = material;
    this.elemEditToolData.$curElem = $curElem;
    this.elemEditToolData.$path = $curElem.querySelector('path');
    this.initPenEditHistory();
    this.savePenEditHistory();

    // 4：绑定事件
    Z($penCover).on('mousedown', this.penEditToolDone, this);
    Z($tangentWrap).find('.penTangent-item-this .penTangent-item-btn').on('mousedown', this.tangentMoveStart, this);
    Z($tangentWrap).find('.penTangent-item-prev .penTangent-item-btn,.penTangent-item-next .penTangent-item-btn').on('mousedown', this.bezierEditStart, this);
},
// 切线拖动事件，开始
tangentMoveStart: function(event)
{
    // 重置切线
    function resetTangent()
    {
        // 切线长度设置为 0
        Z($item).find('.penTangent-item-prev').css('width', '0');
        Z($item).find('.penTangent-item-next').css('width', '0');
        // 曲线，去除弯曲度
        var theBezier = mediaEvent.elemEditToolData.pathBezier[bezierIndex];
        var thePointArr = theBezier.split(' ');
        var nextBezier = mediaEvent.elemEditToolData.pathBezier[nextIndex];
        var nextPointArr = nextBezier.split(' ');
        theBezier = thePointArr[0] + ' ' + thePointArr[2] + ' ' + thePointArr[2];
        nextBezier = 'C' + thePointArr[2] + ' ' + nextPointArr[1] + ' ' + nextPointArr[2];
        mediaEvent.elemEditToolData.pathBezier[bezierIndex] = theBezier;
        mediaEvent.elemEditToolData.pathBezier[nextIndex] = nextBezier;
        var setD = mediaEvent.elemEditToolData.pathStart +
            mediaEvent.elemEditToolData.pathBezier.join(' ') + mediaEvent.elemEditToolData.pathEnd;
        mediaEvent.elemEditToolData.$path.setAttribute('d', setD);
    }

    // 1：保存当前数据
    Z.E.forbidden(event);
    var $targ = Z.E.target(event);
    var $item =  $targ.parentNode.parentNode;
    var bezierIndex = parseFloat($item.getAttribute('data-index'));
    var nextIndex = (bezierIndex === this.elemEditToolData.pathBezier.length - 1) ? 0 : (bezierIndex + 1);
    var toolRect = Z.D.id('penTangentTool').getBoundingClientRect();

    this.startData.mouseLoc = getMouseLocation(event);
    this.startData.theIndex = bezierIndex;
    this.startData.nextIndex = nextIndex;
    this.startData.theItem = $item;
    this.startData.targData = {
        'x' : $item.offsetLeft,
        'y' : $item.offsetTop,
        'toolWidth' : toolRect.width,
        'toolHeight' : toolRect.height,
    };

    // 2：判断是否是 alt 按键下的，切线绘制
    var tangentTransform = event.altKey && !event.ctrlKey && !event.shiftKey;
    if (tangentTransform) {
        resetTangent();
    }

    // 3：事件绑定
    if (tangentTransform) {
        var itemRect = $item.getBoundingClientRect();
        this.startData.targData.cx = itemRect.left + itemRect.width / 2;
        this.startData.targData.cy = itemRect.top + itemRect.height / 2;
        Z(media.tool.$designStage).on("mousemove",this.tangentTransformDoing,this);
        Z(media.tool.$designStage).on("mouseup mouseleave",this.tangentTransformDone,this);
    } else {
        Z(media.tool.$designStage).on("mousemove",this.tangentMoveDoing,this);
        Z(media.tool.$designStage).on("mouseup mouseleave",this.tangentMoveDone,this);
    }
},
// 切线调整，alt 键操作下的切线绘制，过程
tangentTransformDoing: function(event)
{
    Z.E.cancel(event);
    // 1：计算鼠标偏移量
    Z.E.stop(event);
    var nowMouseLoc = getMouseLocation(event);
    var mx = nowMouseLoc.x - this.startData.targData.cx;
    var my = nowMouseLoc.y - this.startData.targData.cy;

    // 2：设置切线的长度和旋转
    var setWidth = Math.sqrt(mx * mx + my * my);
    var setAngle = Math.atan(my / mx) * 180 / Math.PI;
    if (mx < 0)
        setAngle += 180;
    var $item = this.startData.theItem;
    var $itemPrev = Z($item).find('.penTangent-item-prev');
    var $itemNext = Z($item).find('.penTangent-item-next');
    $itemPrev.css('width', setWidth).css('transform', 'translate(calc(-100% + 5.5px), 0px) rotate(' + setAngle + 'deg)');
    $itemNext.css('width', setWidth).css('transform', 'translate(5.5px, 0px) rotate(' + setAngle + 'deg)');

    // 3：计算曲线路径
    var showRatio = media.tool.showRatio;
    var canvasRect = media.tool.$stageCanvas.getBoundingClientRect();
    var theBezier = this.elemEditToolData.pathBezier[this.startData.theIndex];
    var thePointArr = theBezier.split(' ');
    var nextBezier = this.elemEditToolData.pathBezier[this.startData.nextIndex];
    var nextPointArr = nextBezier.split(' ');
    // 当前曲线切线锚点
    var thePointX = this.startData.targData.cx - canvasRect.left - mx;
    var thePointY = this.startData.targData.cy - canvasRect.top - my;
    thePointX /= showRatio;
    thePointY /= showRatio;
    var theTangentPoint = thePointX + ',' + thePointY;
    // 下一曲线切线锚点
    var nextPointX = nowMouseLoc.x - canvasRect.left;
    var nextPointY = nowMouseLoc.y - canvasRect.top;
    nextPointX /= showRatio;
    nextPointY /= showRatio;
    var nextTangentPoint = nextPointX + ',' + nextPointY;
    // 曲线路径
    theBezier = thePointArr[0] + ' ' + theTangentPoint + ' ' + thePointArr[2];
    nextBezier = 'C' + nextTangentPoint + ' ' + nextPointArr[1] + ' ' + nextPointArr[2];
    this.elemEditToolData.pathBezier[this.startData.theIndex] = theBezier;
    this.elemEditToolData.pathBezier[this.startData.nextIndex] = nextBezier;
    var setD = mediaEvent.elemEditToolData.pathStart +
        mediaEvent.elemEditToolData.pathBezier.join(' ') + mediaEvent.elemEditToolData.pathEnd;
    this.elemEditToolData.$path.setAttribute('d', setD);
},
// 切线调整，alt 键操作下的切线绘制，结束
tangentTransformDone: function()
{
    // 去除“分离”属性
    this.startData.theItem.removeAttribute('data-separate');

    // 去除数据
    this.startData = {};

    // 保存历史记录
    this.savePenEditHistory();

    // 解除事件绑定
    Z(media.tool.$designStage).off("mousemove",this.tangentTransformDoing,this);
    Z(media.tool.$designStage).off("mouseup mouseleave",this.tangentTransformDone,this);
},
// 切线拖动事件，过程
tangentMoveDoing: function(event)
{
    // 坐标点更新（xxx,xxx）
    function updatePointData(pointData)
    {
        pointData = pointData.split(',');
        var pointX = parseFloat(pointData[0]);
        var pointY = parseFloat(pointData[1]);
        pointX += mx / showRatio;
        pointY += my / showRatio;
        return pointX + ',' + pointY;
    }

    // 1：计算鼠标偏移量
    Z.E.forbidden(event);
    var showRatio = media.tool.showRatio;
    var nowMouseLoc = getMouseLocation(event);
    var mx = nowMouseLoc.x - this.startData.mouseLoc.x;
    var my = nowMouseLoc.y - this.startData.mouseLoc.y;

    // 2：计算偏移后的曲线路径
    var bezierIndex = this.startData.theIndex;
    var pathStart = this.elemEditToolData.pathStart;
    var allBezier = Z.clone(this.elemEditToolData.pathBezier);
    var pathEnd = this.elemEditToolData.pathEnd;
    // 当前曲线的，终点切线、终点坐标更新
    var thisBesier = allBezier[bezierIndex];
    var thisPointData = thisBesier.substring(1);
    thisPointData = thisPointData.split(' ');
    thisPointData[1] = updatePointData(thisPointData[1]);
    thisPointData[2] = updatePointData(thisPointData[2]);
    thisBesier = 'C' + thisPointData.join(' ');
    allBezier[bezierIndex] = thisBesier;
    // 下一条曲线的，起点切线更新
    var nextBesier = allBezier[bezierIndex + 1] || allBezier[0];
    var nextPointData = nextBesier.substring(1);
    nextPointData = nextPointData.split(' ');
    nextPointData[0] = updatePointData(nextPointData[0]);
    nextPointData = nextPointData.join(' ');
    nextBesier = 'C' + nextPointData;
    if (bezierIndex === allBezier.length - 1) {
        allBezier[0] = nextBesier;
        var startPoint = pathStart.substring(1);
        startPoint = updatePointData(startPoint);
        pathStart = 'M' + startPoint + ' ';
    } else {
        allBezier[bezierIndex + 1] = nextBesier;
    }
    // 赋值路径
    this.elemEditToolData.$path.setAttribute('d', pathStart + allBezier.join(' ') + pathEnd);

    // 3：计算编辑工具的偏移
    var toolX = this.startData.targData.x + mx;
    var toolY = this.startData.targData.y + my;
    toolX = toolX / this.startData.targData.toolWidth * 100 + '%';
    toolY = toolY / this.startData.targData.toolHeight * 100 + '%';
    Z(this.startData.theItem).css({
        'left' : toolX,
        'top' : toolY,
    })
},
// 切线拖动事件，结束
tangentMoveDone: function(event)
{
    Z.E.forbidden(event);

    var $path = this.elemEditToolData.$curElem.querySelector('path');
    var setD = $path.getAttribute('d');
    var pathStart = /^M[^C]+\s/.exec(setD);
    var dBezier = setD.match(/C[^C\s]+\s[^C\s]+\s[^C\s]+/g);
    var pathEnd = /\sZ$/.exec(setD);
    pathStart = (pathStart && pathStart[0]) || '';
    pathEnd = (pathEnd && pathEnd[0]) || '';

    this.elemEditToolData.pathStart = pathStart;
    this.elemEditToolData.pathBezier = dBezier;
    this.elemEditToolData.pathEnd = pathEnd;
    // 保存历史记录
    this.savePenEditHistory();

    // 解除事件绑定
    Z(media.tool.$designStage).off("mousemove",this.tangentMoveDoing,this);
    Z(media.tool.$designStage).off("mouseup mouseleave",this.tangentMoveDone,this);
},
// 曲线曲度拖动事件，开始
bezierEditStart: function(event)
{
    Z.E.forbidden(event);
    var $target = Z.E.target(event);
    var $btnParent = $target.parentNode;
    var $item = $btnParent.parentNode;
    var bezierIndex = parseFloat($item.getAttribute('data-index'));
    var nextIndex = (bezierIndex === this.elemEditToolData.pathBezier.length - 1) ? 0 : (bezierIndex + 1);
    var itemRect = $item.getBoundingClientRect();
    var canvasRect = media.tool.$stageCanvas.getBoundingClientRect();
    var isSeparate = (event.altKey && !event.ctrlKey && !event.shiftKey) ||
        Boolean($item.getAttribute('data-separate'));

    // 数据保存
    this.startData.mouseLoc = getMouseLocation(event);
    this.startData.theIndex = bezierIndex;
    this.startData.nextIndex = nextIndex;
    this.startData.theItem = $item;
    this.startData.theBtn = $target;
    this.startData.btnParent = $btnParent;
    this.startData.isPrevItem = Z($btnParent).hasClass('penTangent-item-prev');
    this.startData.isSeparate = isSeparate;
    var itemLeft = itemRect.left + itemRect.width / 2;
    var itemTop = itemRect.top + itemRect.height / 2;
    this.startData.targData = {
        'itemLeft' : itemLeft,
        'itemTop' : itemTop,
        'canvasLeft' : canvasRect.left,
        'canvasTop' : canvasRect.top,
        'itemX' : itemLeft - canvasRect.left,
        'itemY' : itemTop - canvasRect.top,
    };

    // 事件绑定
    Z(media.tool.$designStage).on("mousemove",this.bezierEditDoing,this);
    Z(media.tool.$designStage).on("mouseup mouseleave",this.bezierEditDone,this);
},
// 曲线曲度拖动事件，过程
bezierEditDoing: function(event)
{
    // 编辑 单个 切线、曲线的偏移
    function editSingleBezier()
    {
        // 1：切线偏移
        var setTrans = '';
        if (mediaEvent.startData.isPrevItem){
            if (mx > 0) setAngle += 180;
            setTrans = 'translate(calc(-100% + 5.5px), 0px) rotate(' + setAngle + 'deg)'
        } else {
            if (mx < 0) setAngle += 180;
            setTrans = 'translate(5.5px, 0px) rotate(' + setAngle + 'deg)'
        }
        Z($btnParent).css({
            'width' : setWidth,
            'transform' : setTrans,
        });

        // 2：曲线设置
        var setX = btnRect.left + btnRect.width / 2 - mediaEvent.startData.targData.canvasLeft;
        var setY = btnRect.top + btnRect.height / 2 - mediaEvent.startData.targData.canvasTop;
        setX /= showRatio;
        setY /= showRatio;
        var setPoint = setX + ',' + setY;
        // 分情况计算
        var dBezier = mediaEvent.elemEditToolData.pathBezier;
        var theIndex, theBezierArr, theBezier;
        if (mediaEvent.startData.isPrevItem) {
            theIndex = mediaEvent.startData.theIndex;
            theBezierArr = dBezier[theIndex].split(' ');
            theBezier = theBezierArr[0] + ' ' + setPoint + ' ' + theBezierArr[2];
        } else {
            theIndex = mediaEvent.startData.nextIndex;
            theBezierArr = dBezier[theIndex].split(' ');
            theBezier = 'C' + setPoint + ' ' + theBezierArr[1] + ' ' + theBezierArr[2];
        }
        dBezier[theIndex] = theBezier;

        // 3：添加“分离”属性
        mediaEvent.startData.theItem.setAttribute('data-separate', 'separate');
    }
    // 编辑 两个 切线、曲线的偏移
    function editDoubleBezier()
    {
        // 1：切线偏移
        if (mediaEvent.startData.isPrevItem){
            if (mx > 0) setAngle += 180;
        } else {
            if (mx < 0) setAngle += 180;
        }
        Z(mediaEvent.startData.theItem).find('.penTangent-item-prev').css({
            'width' : setWidth,
            'transform' : 'translate(calc(-100% + 5.5px), 0px) rotate(' + setAngle + 'deg)',
        });
        Z(mediaEvent.startData.theItem).find('.penTangent-item-next').css({
            'width' : setWidth,
            'transform' : 'translate(5.5px, 0px) rotate(' + setAngle + 'deg)',
        });

        // 2：曲线设置
        // 按钮坐标
        var setX = btnRect.left + btnRect.width / 2 - mediaEvent.startData.targData.canvasLeft;
        var setY = btnRect.top + btnRect.height / 2 - mediaEvent.startData.targData.canvasTop;
        var thatPointX = 2 * mediaEvent.startData.targData.itemX - setX;
        var thatPointY = 2 * mediaEvent.startData.targData.itemY - setY;
        var thePoint = (setX / showRatio) + ',' + (setY / showRatio);
        var thatPoint = (thatPointX / showRatio) + ',' + (thatPointY / showRatio);
        // 对应曲线
        var dBezier = mediaEvent.elemEditToolData.pathBezier;
        var thatIndex, thatBezierArr, thatBezier,
            theIndex, theBezierArr, theBezier;
        if (mediaEvent.startData.isPrevItem) {
            thatIndex = mediaEvent.startData.nextIndex;
            thatBezierArr = dBezier[thatIndex].split(' ');
            thatBezier = 'C' + thatPoint + ' ' + thatBezierArr[1] + ' ' + thatBezierArr[2];
            theIndex = mediaEvent.startData.theIndex;
            theBezierArr = dBezier[theIndex].split(' ');
            theBezier = theBezierArr[0] + ' ' + thePoint + ' ' + theBezierArr[2];
        } else {
            thatIndex = mediaEvent.startData.theIndex;
            thatBezierArr = dBezier[thatIndex].split(' ');
            thatBezier = thatBezierArr[0] + ' ' + thatPoint + ' ' + thatBezierArr[2];
            theIndex = mediaEvent.startData.nextIndex;
            theBezierArr = dBezier[theIndex].split(' ');
            theBezier = 'C' + thePoint + ' ' + theBezierArr[1] + ' ' + theBezierArr[2];
        }
        dBezier[thatIndex] = thatBezier;
        dBezier[theIndex] = theBezier;
    }

    // 1：主方法，定义变量
    Z.E.forbidden(event);
    var showRatio = media.tool.showRatio;
    var $btn = this.startData.theBtn;
    var btnRect = $btn.getBoundingClientRect();
    var $btnParent = this.startData.btnParent;
    var nowMouseLoc = getMouseLocation(event);
    var mx = nowMouseLoc.x - this.startData.targData.itemLeft;
    var my = nowMouseLoc.y - this.startData.targData.itemTop;
    var setWidth = Math.sqrt(mx * mx + my * my);
    var setAngle = Math.atan(my / mx) * 180 / Math.PI;

    // 2：分情况处理
    if (this.startData.isSeparate) {
        editSingleBezier();
    } else {
        editDoubleBezier();
    }
    var setD = this.elemEditToolData.pathStart + this.elemEditToolData.pathBezier.join(' ') + this.elemEditToolData.pathEnd;
    this.elemEditToolData.$path.setAttribute('d', setD);
},
// 曲线曲度拖动事件，结束
bezierEditDone: function()
{
    // 保存历史记录
    this.savePenEditHistory();

    // 解除事件绑定
    Z(media.tool.$designStage).off("mousemove",this.bezierEditDoing,this);
    Z(media.tool.$designStage).off("mouseup mouseleave",this.bezierEditDone,this);
},
// 钢笔编辑结束
penEditToolDone: function()
{
    var $penCover = Z.D.id('penEditorCover');
    var $tangentWrap = Z.D.id('penTangentTool');
    if (!Z($penCover).hasClass('readyEdit'))
        return;

    Z($penCover).removeClass('readyDrawing').removeClass('readyEdit');
    Z($tangentWrap).removeClass('editPath').html('');

    // 转变素材对象
    this.tempToPenMaterial(true);

    // 执行保存
    selectTheElement(this.elemEditToolData.material, this.elemEditToolData.$curElem);
    updateMaterialSource(this.elemEditToolData.material, this.elemEditToolData.$curElem);
    saveHistory();

    // 清空临时数据
    this.clearPenEditHistory();
    this.startData = {};
    this.elemEditToolData = {};

    // 清空历史记录
    this.clearPenEditHistory();

    // 解除事件绑定
    Z($penCover).off('mousedown', this.penEditToolDone, this);
},
// 钢笔路径，临时素材更新为标准素材
tempToPenMaterial: function (notNew)
{
    // 计算并定义新的路径
    function setNewPath()
    {
        var $path = $svg.querySelector("path");
        var setD = $path.getAttribute('d');
        var pathStart = /^M[^C]+\s/.exec(setD);
        var dBezier = setD.match(/C[^C\s]+\s[^C\s]+\s[^C\s]+/g);
        var pathEnd = /\sZ$/.exec(setD);
        pathStart = pathStart && pathStart[0];
        pathEnd = pathEnd && pathEnd[0] || '';
        if (!pathStart || !dBezier)
            return false;

        pathStart = pathStart.substring(1);
        var startPoint = pathStart.split(',');
        var startPointX = parseFloat(startPoint[0]) - transX;
        var startPointY = parseFloat(startPoint[1]) - transY;
        pathStart = 'M' + startPointX + ',' + startPointY + ' ';
        // 曲线换算
        dBezier = dBezier.map(function(bezier)
        {
            bezier = bezier.substring(1);
            var points = bezier.split(' ');
            points = points.map(function(pointData)
            {
                var pointLoc = pointData.split(',');
                var pLocX = parseFloat(pointLoc[0]) - transX;
                var pLocY = parseFloat(pointLoc[1]) - transY;
                return pLocX + ',' + pLocY;
            });
            return 'C' + points.join(' ');
        });

        setD = pathStart + dBezier.join(' ') + pathEnd;
        $path.setAttribute('d', setD);
        return true;
    }
    // 设置 svg 属性：viewBox、width、height
    function setSvgViewSize()
    {
        var dataType;
        var tempTrans = 'translate(' + transX + ' ' + transY + ') rotate(0 ' + setWidth/2 + ' ' + setHeight/2 + ')';
        $curElem.setAttribute("transform",tempTrans);
        switch(mediaEvent.shapeType)
        {
            case "11": dataType = "shape-pen";break;
        }
        $svg.setAttribute("data-type", dataType);
        $svg.setAttribute('width', setWidth + '');
        $svg.setAttribute('height', setHeight + '');
        $svg.setAttribute('viewBox', '0 0 ' + setWidth + ' ' + setHeight);
    }
    // 添加素材
    function addNewMaterial()
    {
        // 定义 rect
        var $rect = document.createElementNS(xmlns, "rect");
        $rect.setAttribute("fill", "rgba(0,0,0,0)");
        $rect.setAttribute("width", setWidth + '');
        $rect.setAttribute("height", setHeight + '');

        // 老素材插入 rect
        if (notNew) {
            return $curElem.insertBefore($rect, $g);
        }

        // 获取 source
        $curElem.removeAttribute("id");
        var svgCode = $curElem.outerHTML;
        var tempMaterial = {
            "type": 5,
            "source": svgCode,
            "color": "#000000",
        };
        material = newMediaMaterial(tempMaterial);
        media.addMaterial(material);
        $curElem.setAttribute("id","svgElementSon_" + material.mid);
        $curElem.setAttribute("data-mid",material.mid);
        $curElem.setAttribute("data-pos",material.mid);

        // 新素材插入 rect
        $curElem.insertBefore($rect, $g);

        // 事件绑定
        media.tool.addEleEvents($curElem);
    }

    // 主方法，定义变量
    var $curElem = this.elemEditToolData.$curElem || Z.D.id("tempShape");
    if (!$curElem)
        return;
    var material = this.elemEditToolData.material;
    var $g = $curElem.querySelector("g");
    var $svg = $g.querySelector("svg");
    var elemBox = $curElem.getBBox();
    var transX = elemBox.x;
    var transY = elemBox.y;
    var setWidth = elemBox.width;
    var setHeight = elemBox.height;

    // 1：设置 path 路径
    if (!setNewPath())
        return;

    // 2：设置 svg 偏移、大小
    setSvgViewSize();

    // 3：定义新素材
    addNewMaterial();

    // 4: 定义临时对象
    this.elemEditToolData.material = material;
    this.elemEditToolData.$curElem = $curElem;
},

/********************************************
 **************** 十：表格工具 **************
 ********************************************/
// 双击显示表格工具
showTableToolByDbl: function()
{
    // 显示/隐藏，表格额外的编辑工具
    function showTableEditEXTool()
    {
        //
    }

    // 1：显示表格工具
    this.showTableEditTool(true);

    // 2：显示/隐藏表格额外的编辑工具
    showTableEditEXTool();

    // 3：隐藏选中框
    selectionAll_hide();

    // 4：隐藏部分编辑按钮！
    Z("#tool_svgColor_tableStroke,#tool_svgColor_tableBorder,#tool_svgSize").hide();
},
// 显示表格工具
showTableEditTool: function (doFocus)
{
    // 生成表格HTML
    function setTableHtml()
    {
        // 定义对象
        var strokeFill = rgb2hex($firstLine.getAttribute("stroke"));
        var $$gTr = $svg.children;
        var $gTr = null, $$gTd = null, $gTd = null, $rectTd = null;
        var $tr = null, $td = null, $div = null, $divClone = null,
            $resizeTool = null, $topTool = null, $leftTool = null;
        var tdBg = "", i = 0, j = 0, tdRow = 1, tdCol = 1, lastRow = null, lastCol = null;
        var $table = document.createElement("table");
        var tdResizeToolHtml = '<div class="tableText-resizeTool">';
            tdResizeToolHtml += '<div class="tableResizeTool-item" data-type="row" data-style="top"></div>';
            tdResizeToolHtml += '<div class="tableResizeTool-item" data-type="col" data-style="left"></div>';
            tdResizeToolHtml += '</div>';
        var resizeToolSize = strokeWidth + 4 + "px";
        var resizeToolDeviation = - (strokeWidth + 2) + "px";

        // 遍历单元行
        for (i;i < $$gTr.length;i++)
        {
            lastRow = i === $$gTr.length - 1;
            $gTr = $$gTr[i];
            $$gTd = $gTr.children;
            $tr = document.createElement("tr");

            // 遍历单元格
            for (j = 0;j < $$gTd.length;j++)
            {
                lastCol = j === $$gTd.length - 1;
                $gTd = $$gTd[j];
                $rectTd = $gTd.querySelector("rect");
                $td = document.createElement("td");

                $td.style.borderColor = strokeFill;
                $td.style.borderTopWidth = strokeWidth + "px";
                $td.style.borderLeftWidth = strokeWidth + "px";
                // td 行列属性
                tdRow = $gTd.getAttribute("data-row");
                tdCol = $gTd.getAttribute("data-col");
                $td.rowSpan = $gTd.getAttribute("data-rowspan") || 1;
                $td.colSpan = $gTd.getAttribute("data-colspan") || 1;
                $td.setAttribute("data-row", tdRow);
                $td.setAttribute("data-col", tdCol);
                // 背景色设置
                tdBg = $rectTd.getAttribute("fill").toLowerCase();
                if (tdBg === "none")
                    $td.setAttribute("class", "bgNone");
                else
                    $td.style.backgroundColor = tdBg;

                // div 内容样式，data属性获取
                var textStr = $gTd.getAttribute("data-text");
                var setFFamily = $gTd.getAttribute("data-fontfamily");
                var setFSize = parseFloat($gTd.getAttribute("data-fontsize")) * showRatio;
                setFSize = pt2px(setFSize) + "px";
                var setFWeight = parseFloat($gTd.getAttribute("data-fontweight"))?"bold":"normal";
                var setLSpacing = parseFloat($gTd.getAttribute("data-letterspacing") || 0) * showRatio;
                setLSpacing = setLSpacing === 0 ? setLSpacing : setLSpacing + "px";
                var setTAlign = $gTd.getAttribute("data-textalign");
                var setLHeight = parseFloat($gTd.getAttribute("data-lineheight") || 0) * showRatio;
                setLHeight = setLHeight === 0 ? "normal" : setLHeight;
                var minHeight = setLHeight + tableTextAreaPdTop + tableTextAreaPdBottom;
                // div 内容样式，节点属性获取
                var setItalic = $gTd.querySelector("g").querySelector("g").hasAttribute("transform")?"italic":"normal";
                var setULine = $gTd.querySelector("svg>g>line")?"underline":"none";
                var setColor = $gTd.querySelector("svg path")?
                    $gTd.querySelector("svg path").getAttribute("fill"):"#000000";

                $div = document.createElement("div");
                $div.innerHTML = textStr.split("\n").join("<br>");
                $div.setAttribute("class", "tableText-showArea");

                // td 宽高、边框
                var rectWidth = $rectTd.width.baseVal.value * showRatio - strokeWidth - strokeWidth/2;
                var rectHeight = $rectTd.height.baseVal.value * showRatio - strokeWidth - strokeWidth/2;
                $div.style.width = rectWidth + "px";
                $div.style.height = rectHeight + "px";
                // 编辑框样式
                $div.style.minHeight = minHeight + "px";
                $div.style.padding = tableTextAreaPdTop + "px " + tableTextAreaPdRight
                    + "px " + tableTextAreaPdBottom + "px " + tableTextAreaPdLeft + "px";
                $div.style.fontFamily = setFFamily;
                $div.style.fontSize = setFSize;
                $div.style.fontWeight = setFWeight;
                $div.style.color = setColor;
                $div.style.fontStyle = setItalic;
                $div.style.textDecoration = setULine;
                $div.style.lineHeight = setLHeight + "px";
                $div.style.letterSpacing = setLSpacing;
                $div.style.textAlign = setTAlign;

                // 克隆div辅助显示
                $divClone = $div.cloneNode(true);
                $divClone.setAttribute("contenteditable", "true");
                $divClone.setAttribute("spellcheck", "false");
                $divClone.setAttribute("class", "tableText-editArea");
                $divClone.style.Height = rectHeight + "px";

                // 边框缩放div辅助框
                $resizeTool = Z(tdResizeToolHtml)[0];
                $topTool = $resizeTool.querySelector('[data-type=row]');
                $leftTool = $resizeTool.querySelector('[data-type=col]');
                $topTool.style.top = resizeToolDeviation;
                $topTool.style.height = resizeToolSize;
                $leftTool.style.left = resizeToolDeviation;
                $leftTool.style.width = resizeToolSize;
                if (lastRow)
                {
                    $resizeTool.insertAdjacentHTML('beforeend',
                        '<div class="tableResizeTool-item" data-type="row" data-style="bottom" '
                        + 'style="bottom: '+resizeToolDeviation+';height: '+resizeToolSize+';"></div>');
                }
                if (lastCol)
                {
                    $resizeTool.insertAdjacentHTML('beforeend',
                        '<div class="tableResizeTool-item" data-type="col" data-style="right" '
                        + 'style="right: '+resizeToolDeviation+';width: '+resizeToolSize+';"></div>');
                }

                // 插入编辑区
                $td.appendChild($div);
                $td.appendChild($divClone);
                $td.appendChild($resizeTool);
                $tr.appendChild($td);
                // 事件添加
                mediaEvent.tableTextAreaEventAdd($td);
            }
            $table.appendChild($tr);
        }

        // 定义 table 属性、内容
        var svgViewBox = $svg.viewBox.baseVal;
        var setWidth = svgViewBox.width * showRatio;
        var setHeight = svgViewBox.height * showRatio;
        $table.setAttribute("data-width", setWidth);
        $table.setAttribute("data-height", setHeight);
        $table.style.borderColor =  strokeFill;
        $table.style.borderRightWidth = strokeWidth + "px";
        $table.style.borderBottomWidth = strokeWidth + "px";
        var $oldTable = $tableEditor.querySelector("table");
        $tableEditor.insertBefore($table, $oldTable);
        $tableEditor.removeChild($oldTable);
    }
    // 显示表格编辑工具
    function setToolStyle()
    {
        // 1：遮罩层显示，位置设置
        Z($tableCover).addClass('tableEditing');
        var stageRect = media.tool.$designStage.getBoundingClientRect();
        var canvasRect = media.tool.$canvasBg.getBoundingClientRect();
        Z($tableStage).css(
        {
            left: canvasRect.left - stageRect.left,
            top: canvasRect.top - stageRect.top,
            width: canvasRect.width,
            height: canvasRect.height,
            backgroundColor: "rgba(0,0,0,.1)",
        });
        Z($tableEditor).css(
        {
            left: $elemTranslate.e * media.tool.showRatio,
            top: $elemTranslate.f * media.tool.showRatio,
            transform: "rotate(" + $$elemTrans[1].angle + "deg)",
        });
        // 2：取得第一个div焦点
        if (doFocus)
        {
            var $firstTextArea = $tableEditor.querySelector("div.tableText-editArea");
            $firstTextArea.focus();
        }
        // 3：定义操作类型
        mediaEvent.shapeType = '21';
    }

    // 1：主方法，定义变量
    var $curElem = media.tool.getCurSvgElement();
    var material = media.getCurMaterial();

    var $$elemTrans = $curElem.transform.baseVal;
    var $elemTranslate = $$elemTrans[0].matrix;
    var $svg = $curElem.querySelector("svg");
    var $firstLine = $svg.querySelector("line");
    var $tableCover = Z.D.id('tableEditorCover');
    var $tableStage = Z.D.id('tableEditorStage');
    var $tableEditor = Z.D.id('tableEditor');
    this.elemEditToolData = {};
    this.elemEditToolData.tempElement = $curElem;
    this.elemEditToolData.tempMaterial = material;

    // 2：计算显示比例
    var showRatio = media.tool.showRatio;
    var elemWidth = $svg.width.baseVal.value;
    var elemHeight = $svg.height.baseVal.value;
    var viewWidth = $svg.viewBox.baseVal.width;
    var viewHeight = $svg.viewBox.baseVal.height;
    showRatio *= (elemWidth/viewWidth + elemHeight/viewHeight)/2;
    var strokeWidth = showRatio * $firstLine.getAttribute("stroke-width");

    // 3：生成表格HTML
    setTableHtml();

    // 4：显示表格编辑工具
    setToolStyle();

    // 5：隐藏素材
    hideHiddenElement($curElem);
},
// 隐藏表格工具
hideTableEditTool: function ()
{
    var $tableCover = Z.D.id("tableEditorCover");
    var $tableStage = Z.D.id("tableEditorStage");
    var $tableEditor = Z.D.id("tableEditor");
    var $tableTool = $tableEditor.querySelector("table");
    $tableCover.removeAttribute("class");
    $tableStage.removeAttribute("style");
    $tableEditor.removeAttribute("style");
    $tableTool.removeAttribute("style");
},
// 显示表格素材
showTableSvgElement: function()
{
    var $curElem = media.tool.getCurSvgElement();
    if (!$curElem)
        return;
    var className = $curElem.getAttribute("class") || "";
    if (className.indexOf("hiddenDoing") === -1)
        return;
    className = className.replace("hiddenDoing", "").trim();
    $curElem.setAttribute("class", className);
},
// 生成表格素材
resetTableSvgElement: function()
{
    var getTextStrFromEditor = function($div, styleSheets)
    {
        var txtStr = "", textArray = $div.innerText.split("\n");

        var $newSpan = document.createElement("span");
        $newSpan.setAttribute("style", "opacity:0;z-index:-999;pointer-events:none;white-space:normal;word-break:break-all;");
        $newSpan.style.fontSize = styleSheets.fontSize;
        $newSpan.style.fontFamily = styleSheets.fontFamily;
        $newSpan.style.letterSpacing = styleSheets.letterSpacing;
        $newSpan.style.fontStyle = styleSheets.fontStyle;
        document.documentElement.appendChild($newSpan);

        var baseWidth = $div.offsetWidth - tableTextAreaPdLeft - tableTextAreaPdRight;

        return $div.innerText;
    }

    // 0：判断可行性
    var tableEditing = Z.D.id("tableEditorCover").className.indexOf("tableEditing") > -1;
    var $tableEditor = Z("#tableEditor");
    if (!tableEditing || !$tableEditor.attr("style"))
        return;

    // 1：定义变量
    var $curElem = this.elemEditToolData.tempElement;
    var $table = $tableEditor.find("table");
    var showRatio = media.tool.showRatio;
    var borderColor = rgb2hex($table.css("borderRightColor"));
    var tableBorderWidth = parseFloat($table.css("borderRightWidth"));
    var borderWidth = tableBorderWidth / showRatio;

    // 2：创建 svg 素材
    var $svg = document.createElementNS(xmlns, "svg");
    $svg.setAttribute("preserveAspectRatio", "none");
    $svg.setAttribute("data-type", "shape-table");

    // 3：创建临时对象，用于校准位置
    var $bodySvg = document.createElementNS(xmlns, 'svg');
    $bodySvg.setAttribute('viewBox', '0 0 ' + media.canvas.fullWidth + ' ' + media.canvas.fullHeight);
    $bodySvg.setAttribute('width', media.canvas.fullWidth);
    $bodySvg.setAttribute('height', media.canvas.fullHeight);
    $bodySvg.setAttribute('style', 'position:absolute;z-index:-9999;pointer-events:none;opacity:0;');
    var $svgClone = $svg.cloneNode(true);
    $bodySvg.appendChild($svgClone);
    document.documentElement.appendChild($bodySvg);

    // 4：遍历单元格
    var $$tr = $table.find("tr"), $tr = null, $$td = null, $td = null, tdRow = 1, tdCol = 1, $div = null;
    var i = 0, j = 0, firstRow = null, firstCol = null, lastRow = null, lastCol = null;
    var $gTr = null, $gTd = null, $rectFill = null, $line = null, $gTextWrap = null, $gText = null;
    var rowMax=null
    // 取得行列最大值
    var $tdLast = $$tr[$$tr.length-1 ].querySelector("td:last-child");
   // var rowMax = parseFloat($tdLast.getAttribute("data-row")) + $tdLast.rowSpan;     
  
   for(i = 0;i < $$tr.length;i++) {//原先没有   循环行 后面添加的 因为合并单元格的问题修改
      
        $trList = $$tr[i].querySelector("tr:last-child");
        if(! $trList){
            continue
        }
        rowMax = parseFloat($tdLast.getAttribute("data-row")) + $tdLast.rowSpan;//最后一个td得到他的data-row的属性名 并且合并最后一行单元格  
    }
  
    var colTrLastTd = [];
    
    for(i = 0;i < $$tr.length;i++) {
        $tdLast = $$tr[i].querySelector("td:last-child");
        
         if(!$tdLast){//这两行判断是自己添加的 目的是判断如果在合并的过程中 没有td了 就结束自动获取宽度 因为合并单元格的问题修改
            continue
       }
        colTrLastTd.push(parseFloat($tdLast.getAttribute("data-col")) + $tdLast.colSpan); 
    }
    
    var colMax = getMaxNum(colTrLastTd);
    for(i = 0;i < $$tr.length;i++)
    {
        $gTr = document.createElementNS(xmlns, "g");
        $tr = $$tr[i];
        var transX = 0;
        var transY = $tr.offsetTop / showRatio;
        var trans = "translate(" + transX + " " + transY + ")";
        $gTr.setAttribute("transform", trans);
        $gTr.setAttribute("data-y", transY);
        $$td = $tr.querySelectorAll('td');
        j = 0;
        // 4.1：遍历单元格
        for (j;j < $$td.length;j++)
        {
            $td = $$td[j];
            $div = $td.querySelector("div.tableText-editArea");
            $gTd = document.createElementNS(xmlns, "g");

            firstRow = i === 0;
            firstCol = j === 0;
            tdRow = parseFloat($td.getAttribute("data-row")) + $td.rowSpan;
            tdCol = parseFloat($td.getAttribute("data-col")) + $td.colSpan;
            lastRow = tdRow === rowMax;
            lastCol = tdCol === colMax;

            // 5.1：单元格大小，填充色
            var tdWidth = parseFloat($td.offsetWidth) / showRatio + borderWidth / 2;
            var tdHeight = parseFloat($td.offsetHeight) / showRatio + borderWidth / 2;
            var fillColor = $td.className.includes("bgNone");
            fillColor = fillColor ? "none" : Z($td).css("backgroundColor") || "none";

            $rectFill = document.createElementNS(xmlns, "rect");
            $rectFill.setAttribute("width", tdWidth);
            $rectFill.setAttribute("height", tdHeight);
            $rectFill.setAttribute("fill", fillColor);
            $gTd.appendChild($rectFill);

            // 5.2：单元格偏移
            transX = $td.offsetLeft / showRatio + borderWidth / 2;
            trans = "translate(" + transX + " " + borderWidth / 2 + ")";
            $gTd.setAttribute("transform", trans);
            $gTd.setAttribute("data-x", transX);

            var mx = borderWidth / 2, my = borderWidth / 2;
            // 5.3.1：单元格边框：左
            if (borderWidth > 0)
            {
                $line = document.createElementNS(xmlns, "line");
                $line.setAttribute("stroke", borderColor);
                $line.setAttribute("stroke-width", borderWidth);
                $line.setAttribute("stroke-linecap", "butt");
                $line.setAttribute("x1", 0);
                $line.setAttribute("y1", 0);
                firstRow && $line.setAttribute("y1", - my);
                $line.setAttribute("x2", 0);
                $line.setAttribute("y2", tdHeight);
                $line.setAttribute("data-type", "left");
                $gTd.appendChild($line);
            }

            // 5.3.2：单元格边框：上
            if ($line)
            {
                var $line2 = $line.cloneNode(true);
                $line2.setAttribute("x1", 0);
                $line2.setAttribute("y1", 0);
                $line2.setAttribute("x2", tdWidth);
                $line2.setAttribute("y2", 0);
                $line2.setAttribute("data-type", "top");
                $gTd.appendChild($line2);
            }

            // 5.3.3：单元格边框：下
            if ($line || lastRow)//原来是&& 因为合并单元格的问题修改
            {
                $rectFill.setAttribute("height", tdHeight);
                var $line3 = $line.cloneNode(true);
                $line3.setAttribute("x1", tdWidth);
                $line3.setAttribute("y1", tdHeight - my);
                $line3.setAttribute("x2", 0);
                $line3.setAttribute("y2", tdHeight - my);
                $line3.setAttribute("data-type", "bottom");
                $gTd.appendChild($line3);
            }

            // 5.3.4：单元格边框：右
            if ($line2 || lastCol)//原本是&& 因为合并单元格的问题修改
            {
                $rectFill.setAttribute("width", tdWidth);
                var $line4 = $line2.cloneNode(true);
                $line4.setAttribute("x1", tdWidth - mx);
                $line4.setAttribute("y1", tdHeight);
                $line4.setAttribute("x2", tdWidth - mx);
                $line4.setAttribute("y2", 0);
                $line4.setAttribute("data-type", "right");
                $gTd.appendChild($line4);
            }

            // 5.4：单元格文字，文字属性
            var styleSheets = window.getComputedStyle($div,null);
            var fontFamily = styleSheets.fontFamily.split(",")[0].trim();
            var fontWeight = styleSheets.fontWeight === "400" ? 0 : 1;
            var fontItalic = styleSheets.fontStyle === "italic" ? 1 : 0;
            var textDecoration = styleSheets.textDecoration.indexOf("underline") > -1 ? 1 : 0;
            var fontSize = px2pt(parseFloat(styleSheets.fontSize) / showRatio);
            var fontColor = rgb2hex(styleSheets.color);
            var letterSpacing = (parseFloat(styleSheets.letterSpacing) || 0) / showRatio;
            var textAlign = styleSheets.textAlign;
            var lineHeight = (parseFloat(styleSheets.lineHeight) || 0)/showRatio;
            var textStr = getTextStrFromEditor($div, styleSheets);

            // 5.4.1：生成文字路径
            var $textPathSvg = getPathSvgFromText(textStr,
                {
                    fontFamily: fontFamily,
                    fontSize: fontSize + "pt",
                    fontWeight: fontWeight,
                    textDecoration: textDecoration,
                    fontColor: fontColor,
                    lineHeight: lineHeight,
                    letterSpacing: letterSpacing,
                });
            $gText = document.createElementNS(xmlns, "g");
            $gText.appendChild($textPathSvg);
            if (fontItalic)
                $gText.setAttribute("transform", "skewX(-18)");
            $gTextWrap = document.createElementNS(xmlns, "g");
            $gTextWrap.appendChild($gText);

            // 5.4.2：克隆素材计算偏移
            var $gTextClone = $gTextWrap.cloneNode(true);
            $svgClone.appendChild($gTextClone);
            var svgBox = $gTextClone.getBBox();
            var svgWidth = svgBox.width;
            var svgHeight = svgBox.height;
            if (svgWidth > tdWidth)
            {
                svgWidth = tdWidth;
                svgHeight = svgWidth * svgBox.height / svgBox.width;
            }
            if (svgHeight > tdHeight)
            {
                svgHeight = tdHeight;
                svgWidth = svgHeight * svgBox.width / svgBox.height;
            }
            $textPathSvg.setAttribute("width", svgWidth);
            $textPathSvg.setAttribute("height", svgHeight);
            var textTransX = (tdWidth - svgWidth) / 2;
            var textTransY = (tdHeight - svgHeight) / 2;
            if(textAlign === "left")
                textTransX = 0;
            else if (textAlign === "right")
                textTransX = tdWidth - svgWidth;
            var textTrans = "translate(" + textTransX + " " + textTransY + ")";
            $gTextWrap.setAttribute("transform", textTrans);

            // 5.5：单元格属性
            $gTd.appendChild($gTextWrap);
            $gTd.setAttribute("data-row", parseFloat($td.getAttribute("data-row") || 1));
            $gTd.setAttribute("data-col", parseFloat($td.getAttribute("data-col") || 1));
            $gTd.setAttribute("data-rowspan", $td.rowSpan);
            $gTd.setAttribute("data-colspan", $td.colSpan);
            $gTd.setAttribute("data-text", textStr);
            $gTd.setAttribute("data-fontfamily", fontFamily);
            $gTd.setAttribute("data-fontweight", fontWeight);
            $gTd.setAttribute("data-fontitalic", fontItalic);
            $gTd.setAttribute("data-textdecoration", textDecoration);
            $gTd.setAttribute("data-textalign", textAlign);
            $gTd.setAttribute("data-fontsize", fontSize);
            $gTd.setAttribute("data-textalign", textAlign);
            $gTd.setAttribute("data-lineheight", $textPathSvg.getAttribute("data-lineheight"));
            $gTd.setAttribute("data-mathheight", $textPathSvg.getAttribute("data-mathheight"));
            $gTd.setAttribute("data-letterspacing", letterSpacing);

            // 插入单元格
            $gTr.appendChild($gTd);
        }
        $svg.appendChild($gTr);
    }
  

    // 5：移除临时对象
    document.documentElement.removeChild($bodySvg);

    // 6：更新当前素材对象
    var $rect = $curElem.querySelector("rect");
    var $gWrap = $curElem.querySelector("g");
    var $$svg = $gWrap.children;
    while ($$svg.length > 0)
        $gWrap.removeChild($$svg[0]);
    $gWrap.appendChild($svg);

    // 7：校准大小
    svgBox = $svg.getBBox();
    var setWidth = svgBox.width + svgBox.x;
    var setHeight = svgBox.height + svgBox.y;
    $svg.setAttribute("width", setWidth + "");
    $svg.setAttribute("height", setHeight + "");
    $svg.setAttribute("viewBox", "0 0 " + setWidth + " " + setHeight);
    // 校准偏移
    var setLeft = $tableEditor[0].offsetLeft / showRatio;
    var setTop = $tableEditor[0].offsetTop / showRatio;
    var setRotate = $tableEditor[0].style.transform;
    setRotate = setRotate.replace(/[^\.\d]/g, "");
    var elemTrans = $curElem.getAttribute("transform");
    elemTrans = elemTrans.replace(/translate(\s)*\([^)]+\)/, "translate(" + setLeft + " " + setTop + ")");
    $rect.setAttribute("width", setWidth + "");
    $rect.setAttribute("height", setHeight + "");
    elemTrans = elemTrans.replace(/rotate(\s)*\([^)]+\)/, "rotate(" + setRotate + " " + setWidth/2 + " " + setHeight/2 + ")");
    $curElem.setAttribute("transform", elemTrans);

    // 8：校准边框样式，复制一个svg
    $svgClone = $svg.cloneNode(true);
    $svgClone.querySelectorAll("g[data-row]").forEach(function($dTd){
        $dTd.removeChild($dTd.querySelector("rect"));
        $dTd.removeChild($dTd.querySelector("g[transform]"));
    });
    $gWrap.appendChild($svgClone);

    // 9：素材对象部分属性
    var material = this.elemEditToolData.tempMaterial;
    tableMaterialTextSet($curElem, material);
},
// 取消、终止表格编辑过程
cancelTableElemEdit: function()
{
    var $curElem = media.tool.getCurSvgElement();
    var material = media.getCurMaterial();
    if (!$curElem || !material)
        return;
    var $gWrap = $curElem.querySelector('g');
    var $svg = [...$gWrap.children].pop();
    var dataType = $svg.getAttribute("data-type");
    if (dataType !== "shape-table")
        return;
    // 隐藏表格工具
    this.hideTableEditTool();
    // 显示表格素材
    this.showTableSvgElement();
},
// 表格选择框隐藏
tableSelectionHide: function (clearDate)
{
    Z("#tableEditor td").removeClass("selected");
    if (clearDate)
        Z.D.id("tableEditor").selectionTdData = null;
},
// 事件绑定
tableTextAreaEventAdd: function ($td)
{
    Z($td.querySelector("div.tableText-editArea")).on("mousedown", mediaEvent.tableTextAreaMouseDown, mediaEvent)
        .on("mouseup", mediaEvent.tableTextAreaMouseUp, mediaEvent)
        .on("mouseenter", mediaEvent.tableTextAreaMouseEnter, mediaEvent)
        .on("mousemove", mediaEvent.tableTextAreaMouseMove, mediaEvent)
        .on("contextmenu", mediaEvent.tableTextAreaContextMenu, mediaEvent)
        .on("focus", mediaEvent.tableTextAreaFocus, mediaEvent)
        .on("blur", mediaEvent.tableTextAreaBlur, mediaEvent)
        .on("input", mediaEvent.tableTextAreaInput, mediaEvent);
    var $$tool = $td.querySelectorAll(".tableResizeTool-item");
    $$tool.forEach(function($item){
       Z($item).on("mousedown click", Z.E.forbidden);
       Z($item).on("mousedown", mediaEvent.tableResizeToolMouseDown, mediaEvent);
    });
},
// 编辑区域div，事件绑定：blur
tableTextAreaBlur: function(event)
{
    // 1：单元格内边距调整

    // 2：选择框隐藏
    this.tableSelectionHide(true);

    // 3：延迟处理，生成表格数据
    setTimeout(function()
    {
        var $activeElem = document.activeElement;
        if ($activeElem.className.includes("tableText-editArea"))
            if (document.hasFocus())
                return;

        // 生成表格素材
        mediaEvent.resetTableSvgElement();
        // 隐藏表格工具
        mediaEvent.hideTableEditTool();
        // 显示表格素材
        mediaEvent.showTableSvgElement();
        // 更新，保存
        updateMaterialSource();
        saveHistory();
        // 清空、隐藏
        mediaEvent.stageDefault();
        clickClearHide();
    },10);
},
// 编辑区域div，事件绑定：focus
tableTextAreaFocus: function(event)
{
    var $div = Z(Z.E.target(event));
    var innerText = $div.text();

    // 1：选择框隐藏
    this.tableSelectionHide(true);

    // 2：padding计算

    // 3：按钮状态判断
    // 加粗
    if ($div.css("fontWeight").toLowerCase() === "bold")
        Z("#tool_fontWeight").addClass("active");
    else
        Z("#tool_fontWeight").removeClass("active");
    // 斜体
    if ($div.css("fontStyle").toLowerCase() === "italic")
        Z("#tool_fontStyle").addClass("active");
    else
        Z("#tool_fontStyle").removeClass("active");
    // 下划线
    if ($div.css("textDecoration").toLowerCase() === "underline")
        Z("#tool_fontDecoration").addClass("active");
    else
        Z("#tool_fontDecoration").removeClass("active");
    // 文字对齐
    var textAlign = $div.css("textAlign");
    Z("#tool_fontAlign>span")[0].className = "textAlign-btn " + textAlign;
    // 文字颜色
    var textColor = $div.css("color");
    if (textColor === "transparent")
        Z("#tool_svgColor_tableText").addClass('bgNone');
    else
        Z("#tool_svgColor_tableText").removeClass('bgNone').css("backgroundColor", textColor);
    // 单元格背景
    if ($div[0].className.indexOf("bgNone") > -1)
        Z("#tool_svgColor_tableFill").addClass('bgNone');
    else
        Z("#tool_svgColor_tableFill").removeClass('bgNone')
            .css("backgroundColor", $div.css("backgroundColor"));
},
// 编辑区域div，事件绑定：input
tableTextAreaInput: function(event)
{
    var $div = Z.E.target(event);
    var $show = $div.previousElementSibling;
    var $td = $div.parentElement;
    var divHtml = $div.innerHTML;
    $show.innerHTML = divHtml;

    var showHeight = $show.offsetHeight;
    var divHeight = $div.offsetHeight;
    if (showHeight > divHeight){
        $div.style.minHeight = showHeight + "px";
        // 校准所有表格
        this.tableAdjustTdHeight();
    }
},
// 编辑区域div，事件绑定：mouseDown
tableTextAreaMouseDown: function (event)
{
    var mouseBtn = event.button;
    var $divEditArea = event.currentTarget;
    var $tdTarget = $divEditArea.parentElement;

    if (Z($tdTarget).hasClass("selected")) {
        if (mouseBtn !== 0)
            return Z.E.forbidden(event);
    } else {
    }
    this.tableSelectionHide(true);
},
// 编辑区域div，事件绑定：mouseup
tableTextAreaMouseUp: function(event)
{
    // 1：只考虑右键
    var mouseBtn = event.button;
    if (mouseBtn !== 2)
        return;
    var $divEditArea = event.currentTarget;
    var $tdTarget = $divEditArea.parentElement;

    // 2.1：右键菜单内容
    var selData = Z.D.id("tableEditor").selectionTdData;
    var tdSelectedList = null, rowMin = 0, rowMax = 0;
    if (Z($tdTarget).hasClass("selected") && !!selData)
    {
        Z.E.forbidden(event);
        tdSelectedList = selData.tdList;
    }
    else
    {
        tdSelectedList = [$tdTarget];
    }

    var i = 0, j = 0, tdSelectedLength = tdSelectedList.length;
    var $td = null, tdRow = 0, tdCol = 0, tdRowSpan = 0, tdColSpan = 0, tdColSpace = 0,
        rowDataArr = null, rowDataObjClone = null;
    var rowBase = new Map(),colBase = new Map(), tdDataMap = new Map();
    var doUnMerge = false, doMerge = false;
    for (i;i < tdSelectedLength;i++)
    {
        $td = tdSelectedList[i];
        tdRow = parseFloat($td.getAttribute("data-row"));//data-row是一行第几行
        tdCol = parseFloat($td.getAttribute("data-col"));
        tdRowSpan = $td.rowSpan;
        tdColSpan = $td.colSpan;
        tdColSpace = tdCol + tdColSpan - 1;

        // 选中单元格占行数、占列数
        rowBase.set(tdRow, tdRow);
        colBase.set(tdCol, tdCol);

        // 是否存在合并的单元格
        if(!doUnMerge && (tdRowSpan > 1 || tdColSpan > 1))
            doUnMerge = true;

        // 每行包含单元格数量
        while(tdRowSpan > 0)
        {
            rowDataArr = tdDataMap.get(tdRow) || [];
            for (j = 0;j < tdColSpan;j++)
            {
                rowDataArr.push(tdCol + j);
            }
            tdDataMap.set(tdRow, rowDataArr);
            tdRow++;
            tdRowSpan--;
        }
    }

    // 2.1：“插入”菜单
    var editItemInsert = [], editItemMerge = [], editItemDelete = [];
    var tdRowNum = rowBase.size;
    var tdColNum = colBase.size;
    if (!!selData) {
        selData.tdRowNum = tdRowNum;
        selData.tdColNum = tdColNum;
    }
    tdRowNum = tdRowNum > 1 ? tdRowNum : "";
    tdColNum = tdColNum > 1 ? tdColNum : "";
    editItemInsert.push(["在上方插入" + tdRowNum + "行", "insertTableRowTop"]);
    editItemInsert.push(["在下方插入" + tdRowNum + "行", "insertTableRowBottom"]);
    editItemInsert.push(["在左侧插入" + tdColNum + "列", "insertTableColLeft"]);
    editItemInsert.push(["在右侧插入" + tdColNum + "列", "insertTableColRight"]);

    // 2.2：“合并”菜单
    doMerge = tdRowNum > 1 || tdColNum > 1;
    if (doMerge)
  
    {
        var tdDataArr = [...tdDataMap.values()];
        tdDataArr = tdDataArr.map(function(arr){ return arr.sort(function(x,y){return x - y;})});
        var arrFirst = tdDataArr[0];
        tdDataArr = tdDataArr.map(function(arr){return arr.join(",")});
        doMerge = tdDataArr.every(function(item){return item === tdDataArr[0]});
    }
    if (doMerge)
    {
        for (i = 0;i < arrFirst.length;i++)
        {
            if (arrFirst[0] + i !== arrFirst[i])
            {
                doMerge = false;
                break;
            }
        }
        if (doMerge)
        {
            editItemMerge.push([]);
            editItemMerge.push(["合并单元格","mergeTableTd"]);
            if (!!selData) {
            
                selData.rowSpanNum = [...tdDataMap.keys()].length;
                selData.colSpanNum = arrFirst.length;
            }
        }
    }
    if (doUnMerge)
    {
        !doMerge && editItemMerge.push([]);
        editItemMerge.push(["取消合并单元格","unMergeTableTd"]);
    }

    // 2.3：“删除”菜单
    editItemDelete.push([]);
    editItemDelete.push(["删除" + tdRowNum + "行", "deleteTableRow"]);
    editItemDelete.push(["删除" + tdColNum + "列", "deleteTableCol"]);
    createContextMenu(
    {
        "event": event,
        "elemId": "tableTextAreaContextMenu",
        "editItem": editItemInsert.concat(editItemMerge.concat(editItemDelete)),
    });
},
// 编辑区域div，事件绑定：mouseenter
tableTextAreaMouseEnter: function(event)
{
    // 实现表格的框选操作，包括合并的单元格框选
    // 1：判断当前操作类型
    if (Z("#tableResizeLine .active")[0])
        return;
    if (!document.hasFocus())
        return;
    if (event.buttons !== 1)
        return;
    var $dibActive = document.activeElement;
    if (!$dibActive || !$dibActive.className.includes("tableText-editArea"))
        return;
    var $tdActive = $dibActive.parentElement;
    if (!$tdActive || $tdActive.tagName.toLowerCase() !== "td")
        return;

    // 2：获取包含的单元格行数和列数
    var $divEditArea = event.currentTarget;
    var $tdEnter = $divEditArea.parentElement;
    var rowList = [
        parseFloat($tdActive.getAttribute("data-row")),
        parseFloat($tdEnter.getAttribute("data-row")),
    ];
    var colList = [
        parseFloat($tdActive.getAttribute("data-col")),
        parseFloat($tdEnter.getAttribute("data-col")),
    ];
    var rowMin = getMinNum(rowList);
    var rowMax = getMaxNum(rowList);
    var colMin = getMinNum(colList);
    var colMax = getMaxNum(colList);

    // 3：显示选中单元格
    var $$tr = Z("#tableEditor tr");
    var i = 0, j = 0, $tr = null, $$td = null, $td = null;
    var tdRow = 1, tdCol = 1, tdSelectedList = [];
    for (i; i < $$tr.length;i++)
    {
        $tr = $$tr[i];
        $$td = $tr.querySelectorAll("td");
        for(j = 0;j < $$td.length;j++)
        {
            $td = $$td[j];
            tdRow = parseFloat($td.getAttribute("data-row"));
            tdCol = parseFloat($td.getAttribute("data-col"));
            if (tdRow < rowMin || tdRow > rowMax || tdCol < colMin  || tdCol > colMax )
                Z($td).removeClass("selected");
            else
            {
                tdSelectedList.push($td);
                Z($td).addClass("selected");
            }
        }
    }

    // 4：储存选中单元格
    Z.D.id("tableEditor").selectionTdData =
    {
        tdList: tdSelectedList,
        rowMin: rowMin,
        rowMax: rowMax,
        colMin: colMin,
        colMax: colMax,
    };
},
// 编辑区域div，事件绑定：mousemove
tableTextAreaMouseMove: function(event)
{
},
// 编辑区域div，事件绑定：contextmenu
tableTextAreaContextMenu: function (event)
{
    Z.E.forbidden(event);
},
// 表格单元格高度校准
tableAdjustTdHeight: function()
{
    var $table = Z("#tableEditor>table");
    var $$td = $table.find("td");
    $$td.each(function($td)
    {
        var $showDiv = $td.querySelector(".tableText-showArea");
        var $editDiv = $td.querySelector(".tableText-editArea");
        var showHeight = $showDiv.offsetHeight;
        var editHeight = $editDiv.offsetHeight;
        var editCssHeight = parseFloat($editDiv.style.height);
        if (editHeight < showHeight || editCssHeight > showHeight && editHeight > editCssHeight)
            $editDiv.style.minHeight = showHeight + "px";
    });
},

// 单元格缩放操作，事件绑定：mousedown
tableResizeToolMouseDown: function(event)
{
    var $curElem = media.tool.getCurSvgElement();
    if(!$curElem)
        return;

    // 添加事件，拖动操作
    Z(media.tool.$designStage).on("mousemove", this.tableResizeToolDoing, this)
        .on("mouseleave mouseup", this.tableResizeToolDone, this);

    // 计算辅助线大小
    var $svg = $curElem.querySelector("svg");
    var showRatio = media.tool.showRatio;
    showRatio *= ($svg.width.baseVal.value/$svg.viewBox.baseVal.width +
        $svg.height.baseVal.value/$svg.viewBox.baseVal.height)/2;
    var strokeWidth = showRatio * $svg.querySelector("line").getAttribute("stroke-width");

    // 计算辅助线位置
    var $targetLine = event.currentTarget;
    var lineType = $targetLine.getAttribute("data-type");
    var lineStyle = $targetLine.getAttribute("data-style");
    var setLoc = parseFloat($targetLine.style[lineStyle]);
    if (lineStyle === "right")
        setLoc += $targetLine.parentElement.offsetWidth;
    if (lineStyle === "bottom")
        setLoc += $targetLine.parentElement.offsetHeight;
    var $parent = $targetLine.parentElement;
    var $tableEditor = Z("#tableEditor")[0];
    while($parent !== $tableEditor)
    {
        setLoc += $parent[lineType === "col" ? "offsetLeft":"offsetTop"];
        $parent = $parent.offsetParent;
    }
    setLoc += strokeWidth + 2;

    // 样式修改
    var $resizeTool = Z("#tableResizeLine");
    var $resizeLine = $resizeTool.find('[data-type='+lineType+']');
    $resizeLine.css(lineType==="col"?"width":"height", strokeWidth);
    $resizeLine.css(lineType==="col"?"left":"top", setLoc);
    $resizeLine.addClass("active").siblings(".tableResizeTool-item").removeClass("active");

    // 保存当前处理起始数据
    $resizeTool[0].lineType = lineType;
    $resizeTool[0].lineStyle = $targetLine.getAttribute("data-style");
    $resizeTool[0].$tdElem = $targetLine.parentElement.parentElement;
    $resizeTool[0].mouseStartLoc = getMouseLocation(event);
    $resizeTool[0].lineStartLoc = {
        left: lineType==="col" ? setLoc : 0,
        top: lineType==="col" ? 0 : setLoc,
    };
},
// 单元格缩放操作，拖动中，mousemove
tableResizeToolDoing: function(event)
{
    var $resizeTool = Z("#tableResizeLine");
    var lineType = $resizeTool[0].lineType;
    var mouseBase = $resizeTool[0].mouseStartLoc;
    var lineBase = $resizeTool[0].lineStartLoc;
    var mouseLoc = getMouseLocation(event);
    var mx = mouseLoc.x - mouseBase.x;
    var my = mouseLoc.y - mouseBase.y;

    var $resizeLine = $resizeTool.find('[data-type='+ lineType +']');
        $resizeLine.css(lineType === "col" ? "left" : "top",
            lineType === "col" ? mx + lineBase.left : my + lineBase.top);
},
// 单元格缩放操作，完成，mouseleave、mouseup
tableResizeToolDone: function(event)
{
    // 取消事件，拖动操作
    Z(media.tool.$designStage).off("mousemove", this.tableResizeToolDoing, this)
        .off("mouseleave mouseup", this.tableResizeToolDone, this);

    // 隐藏辅助线
    var $resizeTool = Z("#tableResizeLine");
    var $line = $resizeTool.find(".active");
    $line.removeClass("active");

    // 缩放操作变化量
    var lineType = $resizeTool[0].lineType;
    var lineStartLoc = $resizeTool[0].lineStartLoc;
    var cssType = lineType === "col" ? "left" : "top";
    var metabolic = parseFloat($line.css(cssType)) - lineStartLoc[cssType];

    // 计算单元格缩放大小
    var lineStyle = $resizeTool[0].lineStyle;
    var $tdElem = $resizeTool[0].$tdElem;
    var $trElem = $tdElem.parentElement;
    var tdElemRow = parseFloat($tdElem.getAttribute("data-row"));
    var tdElemCol = parseFloat($tdElem.getAttribute("data-col"));
    var $tableElem = Z("#tableEditor>table")[0];
    var $$tdAll = $tableElem.querySelectorAll("td");
    var baseRow = tdElemRow, baseCol = tdElemCol;
    var metabolicSet = null, setEditStyle = null, setEditNextStyle = null, setNextCell = false;
    switch (lineStyle){
        case "top":
            metabolicSet= function($td, tdCountRow){
                if (tdCountRow === baseRow){
                    var $editDiv = $td.querySelector(".tableText-editArea");
                    shouldEditArr.push($editDiv);
                    var editHeight = $editDiv.offsetHeight;
                    var autoHeight = $td.querySelector(".tableText-showArea").offsetHeight;
                    if (editHeight + metabolic < autoHeight)
                        metabolic = autoHeight - editHeight;
                }
                if (baseRow === 1 && !setNextCell)
                    setNextCell = true;
            };
            setEditStyle = function($editDiv){
                $editDiv.style.height = $editDiv.offsetHeight + metabolic + "px";
            };
            setEditNextStyle = function(){
                var $$tdNextAll = $trElem.querySelectorAll("td");
                var shouldEditNextArr = [];
                [].map.call($$tdNextAll, function($tdNext){
                    var $editDiv = $tdNext.querySelector(".tableText-editArea");
                    shouldEditNextArr.push($editDiv);
                    var editHeight = $editDiv.offsetHeight;
                    var autoHeight = $tdNext.querySelector(".tableText-showArea").offsetHeight;
                    if (editHeight - metabolic < autoHeight)
                        metabolic = editHeight - autoHeight;
                });
                shouldEditNextArr.map(function($editDiv){
                    $editDiv.style.height = $editDiv.offsetHeight - metabolic + "px";
                });
            };
            break;
        case "right":
            metabolicSet= function($td){
                if ($td.getAttribute("data-col") === tdElemCol + "")
                {
                    var $editDiv = $td.querySelector(".tableText-editArea");
                    shouldEditArr.push($editDiv);
                    var editWidth = $editDiv.offsetWidth;
                    if (editWidth + metabolic < 0)
                        metabolic = 10 - editWidth;
                }
                setNextCell = false;
            };
            setEditStyle = function($editDiv){
                $editDiv.style.width = $editDiv.offsetWidth + metabolic + "px";
            };
            break;
        case "bottom":
            baseRow++;
            metabolicSet= function($td){
                if (tdCountRow === baseRow){
                    var $editDiv = $td.querySelector(".tableText-editArea");
                    shouldEditArr.push($editDiv);
                    var editHeight = $editDiv.offsetHeight;
                    var autoHeight = $td.querySelector(".tableText-showArea").offsetHeight;
                    if (editHeight + metabolic < autoHeight)
                        metabolic = autoHeight - editHeight;
                }
                setNextCell = false;
            };
            setEditStyle = function($editDiv){
                $editDiv.style.height = $editDiv.offsetHeight + metabolic + "px";
            };
            break;
        case "left":
            metabolicSet= function($td, tdCountRow, tdCountCol){
                var $editDiv = null, editWidth = 0;
                if (tdCountCol === baseCol){
                    $editDiv = $td.querySelector(".tableText-editArea");
                    shouldEditArr.push($editDiv);
                    editWidth = $editDiv.offsetWidth;
                    if (editWidth + metabolic < 0)
                        metabolic = 10 - editWidth;
                }
                if ($td.getAttribute("data-col") === tdElemCol + "")
                {
                    $editDiv = $td.querySelector(".tableText-editArea");
                    editWidth = $editDiv.offsetWidth;
                    if (editWidth - metabolic < 0)
                        metabolic = editWidth - 10;
                }
                setNextCell = true;
            };
            setEditStyle = function($editDiv){
                $editDiv.style.width = $editDiv.offsetWidth + metabolic + "px";
                var autoHeight = $editDiv.parentElement.querySelector(".tableText-showArea").offsetHeight;
                if ($editDiv.offsetHeight < autoHeight)
                    $editDiv.style.height = autoHeight + "px";
            };
            setEditNextStyle = function(){
                var $$tdNextAll = $tableElem.querySelectorAll('[data-col="' + tdElemCol + '"]');
                [].map.call($$tdNextAll, function($tdNext){
                    var $editDiv = $tdNext.querySelector(".tableText-editArea");
                    $editDiv.style.width = $editDiv.offsetWidth - metabolic + "px";
                    var editHeight = $editDiv.offsetHeight;
                    var autoHeight = $tdNext.querySelector(".tableText-showArea").offsetHeight;
                    if (editHeight < autoHeight)
                        $editDiv.style.height = autoHeight + "px";
                });
            };
            break;
    }
    var i = 0, $td = null, tdCountRow = 0, tdCountCol = 0;
    var shouldEditArr = [];
    for(i;i < $$tdAll.length;i++){
        $td = $$tdAll[i];
        tdCountRow = parseFloat($td.getAttribute("data-row")) + $td.rowSpan;
        tdCountCol = parseFloat($td.getAttribute("data-col")) + $td.rowSpan;
        metabolicSet($td, tdCountRow, tdCountCol);
    }
    shouldEditArr.map(setEditStyle);
    setNextCell && setEditNextStyle && setEditNextStyle();

    // 调整所有表格大小
    this.tableAdjustTdHeight();
},

/********************************************
 ******************* 十：方法 *****************
 ********************************************/
/** 计算旋转角度的偏移量 **/
getTrueZoomMetabolic: function(event,angle) {
    var nowMouseLoc = getMouseLocation(event);
    var mouseMetabolic = {
        "x": (nowMouseLoc.x - this.startData.mouseLoc.x),    //相对SVG中，鼠标横坐标的实际偏移量
        "y": (nowMouseLoc.y - this.startData.mouseLoc.y),    //相对SVG中，鼠标纵坐标的实际偏移量
    }
    if (mouseMetabolic.x === 0 && mouseMetabolic.y === 0) {
        return {"x": 0, "y": 0}
    }

    angle = angle || this.startData.angle;
    if (!angle) {
        return {"x": mouseMetabolic.x, "y": mouseMetabolic.y}
    }
    var transX = mouseMetabolic.x;
    var transY = mouseMetabolic.y;
    var transAngle = 0;
    if (transX !== 0) transAngle = Math.atan(transY / transX) * 180 / Math.PI;
    //按坐标象限，四个象限\四个坐标点
    if (transX > 0 && transY === 0) {transAngle = 0;}
    if (transX > 0 && transY > 0) {transAngle += 0;}
    if (transX === 0 && transY > 0) {transAngle = 90;}
    if (transX < 0 && transY > 0) {transAngle += 180}
    if (transX < 0 && transY === 0) {transAngle = 180;}
    if (transX < 0 && transY < 0) {transAngle += 180}
    if (transX === 0 && transY < 0) {transAngle = 270;}
    if (transX > 0 && transY < 0) {transAngle += 360;}
    //鼠标偏移，减去素材偏移
    transAngle -= angle;
    var hypotR = Math.sqrt(transX * transX + transY * transY);
    transAngle = transAngle * Math.PI / 180;
    var resultX = hypotR * Math.cos(transAngle);
    var resultY = hypotR * Math.sin(transAngle);
    //返回结果
    return {"x": resultX, "y": resultY}
},

/** 依据素材，选中同组的素材 **/
selectGroup: function (material) {
    var groupId = material.groupId;
    if (!groupId) {
        return false;
    }
    var midsList = media.getMaterialsByGroupId(groupId);
    var i, theMaterial;
    for (i = 0;i < midsList.length;i++){
        theMaterial = media.getMaterialByMid(midsList[i]);
        theMaterial.doMutliSelected();
    }
    return true;
},
/** 依据素材，取消同组的素材的选中 **/
unSelectGroup: function (material) {
    var groupId = material.groupId;
    if (!groupId) {
        return false;
    }
    var midsList = media.getMaterialsByGroupId(groupId);
    var i, theMaterial;
    for (i = 0;i < midsList.length;i++){
        theMaterial = media.getMaterialByMid(midsList[i]);
        theMaterial.unSelected();
    }
    return true;
},

/** 取消 图片的 拖动状态 **/
removeImgDraging: function(material, $curElem){
    if (!material || !$curElem) {
        var $$curElem = Z("g.imgDragging");
        for (var i = 0;i < $$curElem.length;i++)
        {
            $curElem = $$curElem[i];
            material = media.getMaterialByMid($curElem.getAttribute("data-mid"));
            mediaEvent.removeImgDraging(material, $curElem);
        }
    }
    else
    {
        var curElemClass = $curElem.getAttribute("class") || "";
        if (!curElemClass || curElemClass.indexOf("imgDragging") == -1)
            return;
        curElemClass = Z.S.trim(curElemClass.replace("imgDragging",""));
        $curElem.setAttribute("class",curElemClass);
    }
},

/** 形状绘制细节 **/
drawingLine: function(event){
    var isShift = event.shiftKey;
    var $curElem = Z.D.id("tempShape");
    var $svg = $curElem.querySelector("svg");
    var $line = $curElem.querySelector("line");
    var ingX = this.doingData.mouseLoc.x;
    var ingY = this.doingData.mouseLoc.y;
    var transX = this.startData.targData.x;
    var transY = this.startData.targData.y;
    var absX = Math.abs(ingX);
    var absY = Math.abs(ingY);
    var absL = Math.sqrt(Math.pow(absX,2) + Math.pow(absY,2));
    var absAngle = Math.atan(absY / absX);
    var trueAngle  = absAngle * (180 / Math.PI);
    if (ingY > 0 && ingX < 0) trueAngle = 180 - trueAngle;
    if (ingY == 0 && ingX < 0) trueAngle = 180;
    if (ingY < 0 && ingX < 0) trueAngle = 180 + trueAngle;
    if (ingY < 0 && ingX == 0) trueAngle = 270;
    if (ingY < 0 && ingX > 0) trueAngle = 360 - trueAngle;
    trueAngle = trueAngle > 0?trueAngle:0;
    if (isShift) {
        trueAngle = Math.round(trueAngle/45) * 45;
    }
    $curElem.setAttribute("transform","translate(" + transX + " " + transY + ") rotate(" + trueAngle + " 0 0)");
    $line.setAttribute("x2",absL-1);
    $svg.setAttribute("viewBox", "0 0 " + absL + " 2");
    $svg.setAttribute("width", absL);
    $svg.setAttribute("height", "2");
},
drawingRect: function(event){
    var isShift = event.shiftKey;
    var $curElem = Z.D.id("tempShape");
    var $svg = $curElem.querySelector("svg");
    var transX = this.startData.targData.x;
    var transY = this.startData.targData.y;
    var ingX = this.doingData.mouseLoc.x;
    var ingY = this.doingData.mouseLoc.y;
    var absX = Math.abs(ingX);
    var absY = Math.abs(ingY);
    if (isShift) {
        absX = absY = getMaxNum([absX,absY]);
        ingX = ingX<0?(-absX):absX;
        ingY = ingY<0?(-absY):absY;
    }
    transX = ingX < 0?transX+ingX:transX;
    transY = ingY < 0?transY+ingY:transY;
    $curElem.setAttribute("transform","translate(" + transX + " " + transY + ") rotate(0 " + absX/2 + " " + absY/2 + ")");
    $svg.setAttribute("viewBox", "0 0 " + absX + " " + absY);
    $svg.setAttribute("width", absX);
    $svg.setAttribute("height", absY);

    //计算形状矩形
    if (this.shapeType === "2") {
        this.drawRectResize($svg,absX,absY);
    } else if (this.shapeType === "3") {
        this.drawRectStrokeResize($svg,absX,absY);
    }
},
// 计算形状矩形
drawRectResize: function($svg,absX,absY)
{
    var mL = getMinNum([absX,absY])/2;
    if (mL === 0){
        return false;
    }
    var $path_nw = $svg.querySelector(".nw");
    var $path_ne = $svg.querySelector(".ne");
    var $path_se = $svg.querySelector(".se");
    var $path_sw = $svg.querySelector(".sw");
    var nw_r = parseFloat($path_nw.getAttribute("data-radius"));
    var ne_r = parseFloat($path_ne.getAttribute("data-radius"));
    var se_r = parseFloat($path_se.getAttribute("data-radius"));
    var sw_r = parseFloat($path_sw.getAttribute("data-radius"));
    var nw_t = $path_nw.getAttribute("data-type");
    var ne_t = $path_ne.getAttribute("data-type");
    var se_t = $path_se.getAttribute("data-type");
    var sw_t = $path_sw.getAttribute("data-type");

    if (Math.round(getMaxNum([nw_r,ne_r,se_r,sw_r])) > Math.round(mL)){
        return false;
    }
    // 所有 path 路径，衔接处多偏移 2 个单位
    var pML = mL + 2;
    var mML = mL - 2;
    var nw_path = "M" + pML + ",0 h-" + (((pML - nw_r) > 0) ? (pML - nw_r) : 0) +
        " a" + nw_r + "," + nw_r + ",0,0," + nw_t + ",-" + nw_r + "," + nw_r +
        " v" + (((pML - nw_r) > 0) ? (pML - nw_r) : 0) + " h" + pML + " v-" + pML + " Z";
    var ne_path = "M" + absX + "," + pML + " v-" + (((pML - ne_r) > 0) ? (pML - ne_r) : 0) +
        " a" + ne_r + "," + ne_r + ",0,0," + ne_t + ",-" + ne_r + ",-" + ne_r +
        " h-" + (((pML - ne_r) > 0) ? (pML - ne_r) : 0) +" v" + pML + " h" + pML + " Z";
    var se_path, sw_path;
    var se_path_start = "M" + mML + "," + absY;
    var sw_path_start = "M0," + mML;
    if(absX > absY) {
        se_path_start = "M" + (absX - pML) + "," + absY;
    } else if(absX < absY) {
        sw_path_start = "M0," + (absY - pML);
    }
    se_path = se_path_start + " h" + (((pML - se_r) > 0) ? (pML - se_r) : 0) +
        " a" + se_r + "," + se_r + ",0,0," + se_t + "," + se_r + ",-" + se_r +
        " v-" + (((pML - se_r) > 0) ? (pML - se_r) : 0) + " h-" + pML + " v" + pML + " Z";
    sw_path = sw_path_start + " v" + (((pML - sw_r) > 0) ? (pML - sw_r) : 0) +
        " a" + sw_r + "," + sw_r + ",0,0," + sw_t + "," + sw_r + "," + sw_r +
        " h" + (((pML - sw_r) > 0) ? (pML - sw_r) : 0) + " v-" + pML + " h-" + pML + " Z";

    $path_nw.setAttribute("d",nw_path);
    $path_ne.setAttribute("d",ne_path);
    $path_se.setAttribute("d",se_path);
    $path_sw.setAttribute("d",sw_path);
    var $rect_n = $svg.querySelector(".n");
    var $rect_c = $svg.querySelector(".c");
    var $rect_w = $svg.querySelector(".w");
    var $rect_e = $svg.querySelector(".e");
    var $rect_s = $svg.querySelector(".s");
    $rect_n.setAttribute("x", mL + '');
    $rect_n.setAttribute("width", '0');
    $rect_n.setAttribute("height", mL + '');
    if ($rect_c) {
        $rect_c.setAttribute("x", mL - 1 + '');
        $rect_c.setAttribute("y", mL - 1 + '');
        $rect_c.setAttribute("width", '2');
        $rect_c.setAttribute("height", '2');
    }
    $rect_w.setAttribute("y", mL + '');
    $rect_w.setAttribute("width", mL + '');
    $rect_w.setAttribute("height", '0');
    $rect_e.setAttribute("x", mL + '');
    $rect_e.setAttribute("y", mL + '');
    $rect_e.setAttribute("width", mL + '');
    $rect_e.setAttribute("height", '0');
    $rect_s.setAttribute("x", mL + '');
    $rect_s.setAttribute("y", mL + '');
    $rect_s.setAttribute("width", '0');
    $rect_s.setAttribute("height", mL + '');
    if(absX > absY) {
        $rect_n.setAttribute("width", absX - absY + '');
        if ($rect_c) {
            $rect_c.setAttribute("width", absX - absY + '');
        }
        $rect_e.setAttribute("x", absX - mL + '');
        $rect_s.setAttribute("width", absX - absY + '');
    } else if(absX < absY) {
        if ($rect_c) {
            $rect_c.setAttribute("height", absY - absX + '');
        }
        $rect_w.setAttribute("height", absY - absX + '');
        $rect_e.setAttribute("height", absY - absX + '');
        $rect_s.setAttribute("y", absY - mL + '');
    }
    return true;
},
// 计算矩形框,形状大小
drawRectStrokeResize: function ($svg,absX,absY)
{
    var mL = getMinNum([absX,absY]);
    if (mL === 0){
        return false;
    }
    $svg.setAttribute("data-rectmaxstroke", mL);
    mL = mL / 2;
    var $path_nw = $svg.querySelector(".nw");
    var $path_ne = $svg.querySelector(".ne");
    var $path_se = $svg.querySelector(".se");
    var $path_sw = $svg.querySelector(".sw");
    var nw_r = parseFloat($path_nw.getAttribute("data-radius"));
    var ne_r = parseFloat($path_ne.getAttribute("data-radius"));
    var se_r = parseFloat($path_se.getAttribute("data-radius"));
    var sw_r = parseFloat($path_sw.getAttribute("data-radius"));
    var stroke_width = parseFloat($svg.getAttribute("data-rectstroke") || 5);
    stroke_width = stroke_width > mL ? mL : stroke_width;
    if (Math.round(getMaxNum([nw_r,ne_r,se_r,sw_r])) > Math.round(mL)){
        return false;
    }
    var nw_path = "M0," + (absY / 2) + " h" + stroke_width + " ";
    var ne_path = "M" + (absX / 2) + ",0 v" + stroke_width + " ";
    var se_path = "M" + absX + "," + (absY /2 ) + " h-" + stroke_width + " ";
    var sw_path = "M" + (absX / 2) + "," + absY + " v-" + stroke_width + " ";
    if (nw_r === 0){
        nw_path += "v-" + (absY / 2 - stroke_width) + " ";
        nw_path += "h" + (absX / 2 - stroke_width + 2) + " v-" + stroke_width + " h-" + (absX / 2 + 2) + " ";
        nw_path += "v" + (absY / 2) + " Z";
    } else {
        var nw_x = absX / 2 - nw_r > 0 ? absX / 2 - nw_r : 0;
        var nw_y = absY / 2 - nw_r > 0 ? absY / 2 - nw_r : 0;
        var nw_r2 = nw_r - stroke_width;
        nw_path += "v-" + nw_y + " ";
        nw_path += "a" + nw_r2 + "," + nw_r2 + ",0,0,1," + nw_r2 + "," + (0 - nw_r2) + " ";
        nw_path += "h" + (nw_x + 2) + " v-" + stroke_width + " h-" + (nw_x + 2) + " ";
        nw_path += "a" + nw_r  + "," + nw_r + ",0,0,0,-" + nw_r + "," + nw_r + " ";
        nw_path += "v" + nw_y + " Z";
    }
    if (ne_r === 0){
        ne_path += "h" + (absX / 2 - stroke_width) + " ";
        ne_path += "v" + (absY / 2 - stroke_width + 2) + " h" + stroke_width + " v-" + (absY / 2 + 2) +" ";
        ne_path += "h-" + (absX / 2) + " Z";
    } else {
        var ne_x = absX / 2 - ne_r > 0 ? absX / 2 - ne_r : 0;
        var ne_y = absY / 2 - ne_r > 0 ? absY / 2 - ne_r : 0;
        var ne_r2 = ne_r - stroke_width;
        ne_path += "h" + ne_x + " ";
        ne_path += "a" + ne_r2 + "," + ne_r2 + ",0,0,1," + ne_r2 + "," + ne_r2 + " ";
        ne_path += "v" + (ne_y + 2) + " h" + stroke_width + " v-" + (ne_y + 2) + " ";
        ne_path += "a" + ne_r  + "," + ne_r + ",0,0,0,-" + ne_r + ",-" + ne_r + " ";
        ne_path += "h-" + ne_x + " Z";
    }
    if (se_r === 0){
        se_path += "v" + (absY / 2 - stroke_width) + " ";
        se_path += "h-" + (absX / 2 - stroke_width + 2) + " v" + stroke_width + " h" + (absX / 2 + 2) + " ";
        se_path += "v-" + (absY / 2) + " Z";
    } else {
        var se_x = absX / 2 - se_r > 0 ? absX / 2 - se_r : 0;
        var se_y = absY / 2 - se_r > 0 ? absY / 2 - se_r : 0;
        var se_r2 = se_r - stroke_width;
        se_path += "v" + se_y + " ";
        se_path += "a" + se_r2 + "," + se_r2 + ",0,0,1," + (0 -  se_r2) + "," + se_r2 + " ";
        se_path += "h-" + (se_x + 2) + " v" + stroke_width + " h" + (se_x + 2) + " ";
        se_path += "a" + se_r  + "," + se_r + ",0,0,0," + se_r + "," + (0 - se_r) + " ";
        se_path += "v-" + se_y + " Z";
    }
    if (sw_r === 0){
        sw_path += "h-" + (absX / 2 - stroke_width) + " ";
        sw_path += "v-" + (absY / 2 - stroke_width + 2) +" h-" + stroke_width + " v" + (absY / 2 + 2) + " ";
        sw_path += "h" + (absX / 2) + " Z";
    } else {
        var sw_x = absX / 2 - sw_r > 0 ? absX / 2 - sw_r : 0;
        var sw_y = absY / 2 - sw_r > 0 ? absY / 2 - sw_r : 0;
        var sw_r2 = sw_r - stroke_width;
        sw_path += "h-" + sw_x + " ";
        sw_path += "a" + sw_r2 + "," + sw_r2 + ",0,0,1," + (0 - sw_r2) + "," + (0 - sw_r2) + " ";
        sw_path += "v-" + (sw_y + 2) + " h-" + stroke_width + " v" + (sw_y + 2) + " ";
        sw_path += "a" + sw_r  + "," + sw_r + ",0,0,0," + sw_r + "," + sw_r + " ";
        sw_path += "h" + sw_x + " Z";
    }

    $path_nw.setAttribute("d",nw_path);
    $path_ne.setAttribute("d",ne_path);
    $path_se.setAttribute("d",se_path);
    $path_sw.setAttribute("d",sw_path);

    return true;
},
drawingEllipse: function(event){
    var isShift = event.shiftKey;
    var $curElem = Z.D.id("tempShape");
    var $svg = $curElem.querySelector("svg");
    var $ellipse = $curElem.querySelector("ellipse");
    var ingX = this.doingData.mouseLoc.x;
    var ingY = this.doingData.mouseLoc.y;
    var transX = this.startData.targData.x;
    var transY = this.startData.targData.y;
    var absX = Math.abs(ingX);
    var absY = Math.abs(ingY);
    if (isShift) {
        absX = absY = getMaxNum([absX,absY]);
        ingX = ingX<0?(-absX):absX;
        ingY = ingY<0?(-absY):absY;
    }
    var strokeWidth = parseFloat($ellipse.getAttribute("stroke-width"));
    var cx = absX/2;
    var cy = absY/2;
    var rx = (absX - 2 * strokeWidth)/2;
    var ry = (absY - 2 * strokeWidth)/2;
    transX = ingX < 0?transX+ingX:transX;
    transY = ingY < 0?transY+ingY:transY;
    $curElem.setAttribute("transform","translate(" + transX + " " + transY + ") rotate(0 " + absX/2 + " " + absY/2 + ")");
    $svg.setAttribute("viewBox", "0 0 " + absX + " " + absY);
    $svg.setAttribute("width", absX);
    $svg.setAttribute("height", absY);
    $ellipse.setAttribute("cx",cx);
    $ellipse.setAttribute("cy",cy);
    $ellipse.setAttribute("rx",rx);
    $ellipse.setAttribute("ry",ry);
},

/** 详细的操作历史记录保存 **/
// 初始化，可用状态
initPenEditHistory: function()
{
    mediaEvent.penEditHistory = {};
    mediaEvent.penEditHistory.list = [];
    mediaEvent.penEditHistory.index = 0;
    mediaEvent.penEditHistory.redoSkip = false;
    mediaEvent.penEditHistory.revokeSkip = false;

    var coverClass = Z.D.id('penEditorCover').className;
    mediaEvent.penEditHistory.type = coverClass.indexOf('readyEdit') > -1 ? 'edit' :
        (coverClass.indexOf('readyDrawing') > -1 ? 'draw' : null);
},
// 清空，不可用状态
clearPenEditHistory: function()
{
    mediaEvent.penEditHistory = null;
},
// 添加历史记录
savePenEditHistory: function()
{
    var editType = this.penEditHistory.type;
    if (!editType)
        return;

    var $path;
    switch(editType){
        case 'draw': $path = this.startData.$tempPath;break;
        case 'edit': $path = this.elemEditToolData.$path;break;
    }

    this.penEditHistory.list.splice(this.penEditHistory.index + 1,
        this.penEditHistory.list.length - 1 - this.penEditHistory.index);
    this.penEditHistory.list.push({
        'path': $path.getAttribute('d'),
    });
    this.penEditHistory.index = this.penEditHistory.list.length - 1;
},
// 加载历史纪录
loadPenEditHistory: function()
{
    //载入绘制过程的钢笔路径
    function loadDrawPath()
    {
        function insertPoint()
        {
            transX = (stageRect.left - wrapRect.left) + parseFloat(bezierStart[0]) * showRatio;
            transY = (stageRect.top - wrapRect.top) + parseFloat(bezierStart[1]) * showRatio;
            Z($tangentWrap).append($newTangent);

            tangentLength = $tangentWrap.querySelectorAll('.penTangent-item').length;

            $newTangent.attr('data-index', tangentLength);

            $newTangent.css({
                'left' : transX * 100 / wrapRect.width + '%',
                'top' : transY * 100 / wrapRect.height + '%',
            });
        }

        // 1：展示路径
        $path = mediaEvent.startData.$tempPath;
        $path.setAttribute('d', setD);

        // 2：展示切线
        var wrapRect = $tangentWrap.getBoundingClientRect();
        var stageRect = media.tool.$stageCanvas.getBoundingClientRect();
        var showRatio = media.tool.showRatio;

        var bezierStart = pathStart.replace(/^[M\s]/, '').split(',');
        var $newTangent = Z(newTangentString);
        var i, transX, transY, tangentLength;
        insertPoint();
        for (i = 0;i < dBezier.length - 1;i++)
        {
            bezierStart = dBezier[i].split(' ')[2].replace(/[^\d,.]/, '').split(',');
            $newTangent = Z(newTangentString);
            insertPoint();
        }
    }
    //载入编辑状态的钢笔路径
    function loadEditPath()
    {
        // 钢笔编辑工具展示
        function setToolStyle()
        {
            // 计算当前切线 prev 的偏移属性
            function setPrevTangent()
            {
                var $thePrev = $theTangent.find('.penTangent-item-prev');
                var prevPoint = pointList[1].split(',');
                var prevPointX = parseFloat(prevPoint[0]);
                var prevPointY = parseFloat(prevPoint[1]);
                var pointMX = thePointX - prevPointX;
                var pointMY = thePointY - prevPointY;
                prevAngle = Math.atan(pointMY / pointMX) * 180 / Math.PI;
                if (pointMX < 0)
                    prevAngle += 180;
                prevWidth = Math.sqrt(pointMX * pointMX + pointMY * pointMY) * showRatio;
                $thePrev.css({
                    'transform': 'translate(calc(-100% + 5.5px), 0) rotate(' + prevAngle + 'deg)',
                    'width' : prevWidth + 'px'
                });
            }
            // 计算前个切线 next 偏移属性
            function setNextTangent()
            {
                var $theNext = $theTangent.find('.penTangent-item-next');
                var nextIndex = (i === dBezier.length - 1) ? 0 : (i + 1);
                var nextPointList = dBezier[nextIndex].substring(1).split(' ');
                var nextPoint = nextPointList[0].split(',');
                var nextPointX = parseFloat(nextPoint[0]);
                var nextPointY = parseFloat(nextPoint[1]);
                var pointMX = nextPointX - thePointX;
                var pointMY = nextPointY - thePointY;
                nextAngle = Math.atan(pointMY / pointMX) * 180 / Math.PI;
                if (pointMX < 0)
                    nextAngle += 180;
                nextWidth = Math.sqrt(pointMX * pointMX + pointMY * pointMY) * showRatio;
                $theNext.css({
                    'transform': 'translate(5.5px, 0) rotate(' + nextAngle + 'deg)',
                    'width' : nextWidth + 'px'
                });
            }
            // 检测“分离”属性，前后两切线的偏移是否相等（差值小于最小误差）
            function checkSeparateAttribute()
            {
                var minMWidth = .5;
                var minMAngle = .5;
                var adsMWidth = Math.abs(nextWidth - prevWidth);
                var adsMAngle = Math.abs(nextAngle - prevAngle);
                var isSeparate = false;
                if (adsMWidth > minMWidth && adsMAngle > minMAngle)
                    isSeparate = true;
                if (isSeparate)
                    $theTangent.attr('data-separate', 'separate');
            }

            // 主方法：循环处理
            var showRatio = media.tool.showRatio;
            var mLeft = canvasRect.left - coverRect.left;
            var mTop = canvasRect.top - coverRect.top;
            var coverWidth = coverRect.width;
            var coverHeight = coverRect.height;
            var i, pointList, $$allTangent, tangentLength, $theTangent, thePoint,
                thePointX, thePointY, thePX, thePY, prevWidth, prevAngle, nextWidth, nextAngle;
            for (i = 0;i < dBezier.length;i++)
            {
                // 1：当前曲线
                pointList = dBezier[i].substring(1).split(' ');
                // 2：所有已存在的切线
                $$allTangent = $tangentWrap.querySelectorAll('.penTangent-item');
                tangentLength = $$allTangent.length;
                // 3：插入新切线
                $theTangent = Z(newTangentString);
                Z($tangentWrap).append($theTangent);
                $theTangent.attr('data-index', tangentLength);
                $theTangent.addClass('active');
                // 4：切线锚点位置
                thePoint = pointList[2].split(',');
                thePointX = parseFloat(thePoint[0]);
                thePointY = parseFloat(thePoint[1]);
                thePX = (thePointX * showRatio + mLeft) / coverWidth * 100 + '%';
                thePY = (thePointY * showRatio + mTop) / coverHeight * 100 + '%';
                $theTangent.css({
                    'left': thePX,
                    'top': thePY,
                });
                // 5：当前切线的 prev ：长度、旋转
                setPrevTangent();
                // 6：当前切线的 next：长度、旋转
                setNextTangent();
                // 7：检测“分离”属性
                checkSeparateAttribute();
            }
        }

        // 1：展示路径
        $path = mediaEvent.elemEditToolData.$path;
        $path.setAttribute('d', setD);

        // 2：展示切线
        var $canvasBg = media.tool.$canvasBg;
        var canvasRect = $canvasBg.getBoundingClientRect();
        var coverRect = media.tool.$designStage.getBoundingClientRect();
        // 2-1：设置工具样式
        setToolStyle();
        // 2-2：定义临时数据，用于编辑
        mediaEvent.elemEditToolData.pathStart = pathStart;
        mediaEvent.elemEditToolData.pathBezier = dBezier;
        mediaEvent.elemEditToolData.pathEnd = pathEnd;
        // 2-3：绑定事件
        Z($tangentWrap).find('.penTangent-item-this .penTangent-item-btn').on('mousedown', mediaEvent.tangentMoveStart, mediaEvent);
        Z($tangentWrap).find('.penTangent-item-prev .penTangent-item-btn,.penTangent-item-next .penTangent-item-btn').on('mousedown', mediaEvent.bezierEditStart, mediaEvent);
    }

    var editType = this.penEditHistory.type;
    var obj = this.penEditHistory.list[this.penEditHistory.index];
    var setD = obj.path;

    var $tangentWrap = Z.D.id('penTangentTool');
    var pathStart = /^M[^C]+\s/.exec(setD);
    var dBezier = setD.match(/C[^C\s]+\s[^C\s]+\s[^C\s]+/g);
    var pathEnd = /\sZ$/.exec(setD);
    pathStart = pathStart && pathStart[0];
    pathEnd = (pathEnd && pathEnd[0]) || '';
    Z($tangentWrap).html('');

    var $path;
    switch (editType)
    {
        case 'draw': loadDrawPath();break;
        case 'edit': loadEditPath();break;
    }
},

/** 隐藏/清除编辑工具，包括容器剪切、图片剪切 **/
removeAllEditTool: function() {
    // 侧边栏文字编辑
    Z("#sideTextEditor").removeClass('active');
    // 去除容器裁剪框
    mediaEvent.frameBgDragClear();
    // 图片剪切取消
    mediaEvent.cutImageToolHide();
    // 钢笔工具取消
    mediaEvent.penDrawCancel();
    // 表格工具取消
    mediaEvent.cancelTableElemEdit();
},
//END
    }
})(zhiqim);