/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.CIDFont;
import org.apache.fop.fonts.CodePointMapping;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.FontDescriptor;
import org.apache.fop.fonts.FontMetrics;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.SingleByteEncoding;
import org.apache.fop.fonts.SingleByteFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.OFFontLoader;
import org.apache.fop.fonts.truetype.OTFSubSetFile;
import org.apache.fop.fonts.truetype.TTFSubSetFile;
import org.apache.fop.fonts.type1.PFBData;
import org.apache.fop.fonts.type1.PFBParser;
import org.apache.fop.fonts.type1.Type1SubsetFile;
import org.apache.fop.pdf.AbstractPDFStream;
import org.apache.fop.pdf.PDFAction;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFCFFStream;
import org.apache.fop.pdf.PDFCFFStreamType0C;
import org.apache.fop.pdf.PDFCIDFont;
import org.apache.fop.pdf.PDFCIDFontDescriptor;
import org.apache.fop.pdf.PDFCIDSystemInfo;
import org.apache.fop.pdf.PDFCMap;
import org.apache.fop.pdf.PDFColorSpace;
import org.apache.fop.pdf.PDFDPart;
import org.apache.fop.pdf.PDFDPartRoot;
import org.apache.fop.pdf.PDFDestination;
import org.apache.fop.pdf.PDFDests;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFEmbeddedFiles;
import org.apache.fop.pdf.PDFEncoding;
import org.apache.fop.pdf.PDFFileSpec;
import org.apache.fop.pdf.PDFFont;
import org.apache.fop.pdf.PDFFontDescriptor;
import org.apache.fop.pdf.PDFFontNonBase14;
import org.apache.fop.pdf.PDFFontType0;
import org.apache.fop.pdf.PDFFunction;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.pdf.PDFGoTo;
import org.apache.fop.pdf.PDFGoToRemote;
import org.apache.fop.pdf.PDFICCBasedColorSpace;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFInfo;
import org.apache.fop.pdf.PDFInternalLink;
import org.apache.fop.pdf.PDFJavaScriptLaunchAction;
import org.apache.fop.pdf.PDFLaunch;
import org.apache.fop.pdf.PDFLayer;
import org.apache.fop.pdf.PDFLink;
import org.apache.fop.pdf.PDFMetadata;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFNameTreeNode;
import org.apache.fop.pdf.PDFNames;
import org.apache.fop.pdf.PDFNavigator;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFOutline;
import org.apache.fop.pdf.PDFOutputIntent;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFPageLabels;
import org.apache.fop.pdf.PDFPages;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFRectangle;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFRoot;
import org.apache.fop.pdf.PDFSeparationColorSpace;
import org.apache.fop.pdf.PDFSetOCGStateAction;
import org.apache.fop.pdf.PDFShading;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFT1Stream;
import org.apache.fop.pdf.PDFTTFStream;
import org.apache.fop.pdf.PDFText;
import org.apache.fop.pdf.PDFToUnicodeCMap;
import org.apache.fop.pdf.PDFTransitionAction;
import org.apache.fop.pdf.PDFUri;
import org.apache.fop.pdf.PDFWArray;
import org.apache.fop.pdf.RefPDFFont;
import org.apache.fop.pdf.Version;
import org.apache.xmlgraphics.java2d.color.NamedColorSpace;
import org.apache.xmlgraphics.xmp.Metadata;

public class PDFFactory {
    public static final int DEFAULT_PDF_RESOLUTION = 72;
    private PDFDocument document;
    private Log log = LogFactory.getLog(PDFFactory.class);
    private int subsetFontCounter = -1;
    private Map<String, PDFDPart> dparts = new HashMap<String, PDFDPart>();

    public PDFFactory(PDFDocument document) {
        this.document = document;
    }

    public final PDFDocument getDocument() {
        return this.document;
    }

    public PDFRoot makeRoot(PDFPages pages) {
        PDFRoot pdfRoot = new PDFRoot(this.document, pages);
        pdfRoot.setDocument(this.getDocument());
        this.getDocument().addTrailerObject((PDFObject)pdfRoot);
        return pdfRoot;
    }

    public PDFPages makePages() {
        PDFPages pdfPages = new PDFPages(this.getDocument());
        pdfPages.setDocument(this.getDocument());
        this.getDocument().addTrailerObject((PDFObject)pdfPages);
        return pdfPages;
    }

    public PDFResources makeResources() {
        PDFResources pdfResources = new PDFResources(this.getDocument());
        pdfResources.setDocument(this.getDocument());
        this.getDocument().addTrailerObject((PDFObject)pdfResources);
        return pdfResources;
    }

    protected PDFInfo makeInfo(String prod) {
        PDFInfo pdfInfo = new PDFInfo();
        pdfInfo.setProducer(prod);
        this.getDocument().registerObject((PDFObject)pdfInfo);
        return pdfInfo;
    }

    public PDFMetadata makeMetadata(Metadata meta, boolean readOnly) {
        PDFMetadata pdfMetadata = new PDFMetadata(meta, readOnly);
        this.getDocument().registerObject((PDFObject)pdfMetadata);
        return pdfMetadata;
    }

    public PDFOutputIntent makeOutputIntent() {
        PDFOutputIntent outputIntent = new PDFOutputIntent();
        this.getDocument().registerObject((PDFObject)outputIntent);
        return outputIntent;
    }

    public PDFPage makePage(PDFResources resources, int pageIndex, Rectangle2D mediaBox, Rectangle2D cropBox, Rectangle2D bleedBox, Rectangle2D trimBox) {
        PDFPage page = new PDFPage(resources, pageIndex, mediaBox, cropBox, bleedBox, trimBox);
        this.getDocument().assignObjectNumber((PDFObject)page);
        this.getDocument().getPages().addPage(page);
        return page;
    }

    public PDFPage makePage(PDFResources resources, float pageWidth, float pageHeight, int pageIndex) {
        Rectangle2D.Double mediaBox = new Rectangle2D.Double(0.0, 0.0, pageWidth, pageHeight);
        return this.makePage(resources, pageIndex, mediaBox, mediaBox, mediaBox, mediaBox);
    }

    public PDFPage makePage(PDFResources resources, float pageWidth, float pageHeight) {
        return this.makePage(resources, pageWidth, pageHeight, -1);
    }

    public PDFFunction makeFunction(List<Double> domain, List<Double> range, float[] cZero, float[] cOne, double interpolationExponentN) {
        PDFFunction function = new PDFFunction(domain, range, cZero, cOne, interpolationExponentN);
        function = this.registerFunction(function);
        return function;
    }

    public PDFFunction registerFunction(PDFFunction function) {
        PDFFunction oldfunc = this.getDocument().findFunction(function);
        if (oldfunc == null) {
            this.getDocument().registerObject((PDFObject)function);
        } else {
            function = oldfunc;
        }
        return function;
    }

    public PDFShading registerShading(PDFResourceContext res, PDFShading shading) {
        PDFShading oldshad = this.getDocument().findShading(shading);
        if (oldshad == null) {
            this.getDocument().registerObject((PDFObject)shading);
        } else {
            shading = oldshad;
        }
        if (res != null) {
            res.addShading(shading);
        }
        return shading;
    }

    public PDFPattern makePattern(PDFResourceContext res, int thePatternType, PDFResources theResources, int thePaintType, int theTilingType, List<?> theBBox, double theXStep, double theYStep, List<?> theMatrix, List<?> theXUID, StringBuffer thePatternDataStream) {
        PDFPattern pattern = new PDFPattern(theResources, 1, thePaintType, theTilingType, theBBox, theXStep, theYStep, theMatrix, theXUID, thePatternDataStream);
        PDFPattern oldpatt = this.getDocument().findPattern(pattern);
        if (oldpatt == null) {
            this.getDocument().registerObject((PDFObject)pattern);
        } else {
            pattern = oldpatt;
        }
        if (res != null) {
            res.addPattern(pattern);
        }
        return pattern;
    }

    public PDFPattern registerPattern(PDFResourceContext res, PDFPattern pattern) {
        PDFPattern oldpatt = this.getDocument().findPattern(pattern);
        if (oldpatt == null) {
            this.getDocument().registerObject((PDFObject)pattern);
        } else {
            pattern = oldpatt;
        }
        if (res != null) {
            res.addPattern(pattern);
        }
        return pattern;
    }

    protected PDFDestination getUniqueDestination(PDFDestination newdest) {
        PDFDestination existing = this.getDocument().findDestination(newdest);
        if (existing != null) {
            return existing;
        }
        this.getDocument().addDestination(newdest);
        return newdest;
    }

    public PDFDestination makeDestination(String idRef, Object goToRef) {
        PDFDestination destination = new PDFDestination(idRef, goToRef);
        return this.getUniqueDestination(destination);
    }

    public PDFNames makeNames() {
        PDFNames names = new PDFNames();
        this.getDocument().assignObjectNumber((PDFObject)names);
        this.getDocument().addTrailerObject((PDFObject)names);
        return names;
    }

    public PDFPageLabels makePageLabels() {
        PDFPageLabels pageLabels = new PDFPageLabels();
        this.getDocument().assignObjectNumber((PDFObject)pageLabels);
        this.getDocument().addTrailerObject((PDFObject)pageLabels);
        return pageLabels;
    }

    public PDFDests makeDests(List<?> destinationList) {
        PDFDests dests = new PDFDests();
        PDFArray kids = new PDFArray((PDFObject)dests);
        for (Object aDestinationList : destinationList) {
            PDFDestination dest = (PDFDestination)aDestinationList;
            PDFNameTreeNode node = new PDFNameTreeNode();
            this.getDocument().registerObject((PDFObject)node);
            node.setLowerLimit(dest.getIDRef());
            node.setUpperLimit(dest.getIDRef());
            node.setNames(new PDFArray((PDFObject)node));
            PDFArray names = node.getNames();
            names.add((Object)dest);
            kids.add((Object)node);
        }
        dests.setLowerLimit(((PDFNameTreeNode)kids.get(0)).getLowerLimit());
        dests.setUpperLimit(((PDFNameTreeNode)kids.get(kids.length() - 1)).getUpperLimit());
        dests.setKids(kids);
        this.getDocument().registerObject((PDFObject)dests);
        return dests;
    }

    public PDFNameTreeNode makeNameTreeNode() {
        PDFNameTreeNode node = new PDFNameTreeNode();
        this.getDocument().registerObject((PDFObject)node);
        return node;
    }

    public PDFLink makeLink(Rectangle2D rect, PDFAction pdfAction) {
        if (rect == null || pdfAction == null) {
            return null;
        }
        PDFLink link = new PDFLink(rect);
        link.setAction(pdfAction);
        this.getDocument().registerObject((PDFObject)link);
        return link;
    }

    public PDFLink makeLink(Rectangle2D rect, String page, String dest) {
        PDFLink link = new PDFLink(rect);
        this.getDocument().registerObject((PDFObject)link);
        PDFGoTo gt = new PDFGoTo(page);
        gt.setDestination(dest);
        this.getDocument().registerObject((PDFObject)gt);
        PDFInternalLink internalLink = new PDFInternalLink(gt.referencePDF());
        link.setAction((PDFAction)internalLink);
        return link;
    }

    public PDFLink makeLink(Rectangle2D rect, String destination, int linkType, float yoffset) {
        PDFLink link = new PDFLink(rect);
        if (linkType == 0) {
            link.setAction(this.getExternalAction(destination, false));
        } else {
            String goToReference = this.getGoToReference(destination, yoffset);
            PDFInternalLink internalLink = new PDFInternalLink(goToReference);
            link.setAction((PDFAction)internalLink);
        }
        PDFLink oldlink = this.getDocument().findLink(link);
        if (oldlink == null) {
            this.getDocument().registerObject((PDFObject)link);
        } else {
            link = oldlink;
        }
        return link;
    }

    public PDFAction getExternalAction(String target, boolean newWindow) {
        URI uri = this.getTargetUri(target);
        if (uri != null) {
            String scheme = uri.getScheme();
            String filename = uri.getPath();
            if (filename == null) {
                filename = uri.getSchemeSpecificPart();
            }
            if (scheme == null) {
                return new PDFUri(uri.toASCIIString());
            }
            if (scheme.equalsIgnoreCase("embedded-file")) {
                return this.getActionForEmbeddedFile(filename, newWindow);
            }
            if (scheme.equalsIgnoreCase("file")) {
                if (filename.startsWith("//")) {
                    filename = filename.replace("/", "\\");
                } else if (filename.matches("^/[A-z]:/.*")) {
                    filename = filename.substring(1);
                }
                if (filename.toLowerCase().endsWith(".pdf")) {
                    int page = -1;
                    String dest = null;
                    String fragment = uri.getFragment();
                    if (fragment != null) {
                        String fragmentLo = fragment.toLowerCase();
                        if (fragmentLo.startsWith("page=")) {
                            page = Integer.parseInt(fragmentLo.substring(5));
                        } else if (fragmentLo.startsWith("dest=")) {
                            dest = fragment.substring(5);
                        }
                    }
                    return this.getGoToPDFAction(filename, dest, page, newWindow);
                }
                if (uri.getQuery() != null || uri.getFragment() != null) {
                    return new PDFUri(uri.toASCIIString());
                }
                return this.getLaunchAction(filename, newWindow);
            }
            return new PDFUri(uri.toASCIIString());
        }
        return new PDFUri(target);
    }

    private URI getTargetUri(String target) {
        URI uri;
        try {
            uri = new URI(target);
            String scheme = uri.getScheme();
            String schemeSpecificPart = uri.getSchemeSpecificPart();
            String authority = uri.getAuthority();
            if (scheme == null && schemeSpecificPart.matches("//.*")) {
                uri = this.getFileUri(target);
            } else if (scheme == null && schemeSpecificPart.matches("/.*")) {
                uri = this.getFileUri(target);
            } else if (scheme != null && scheme.matches("[A-z]")) {
                uri = this.getFileUri(target);
            } else if (scheme != null && scheme.equalsIgnoreCase("file") && authority != null) {
                uri = this.getFileUri(target);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            uri = this.getFileUri(target);
        }
        return uri;
    }

    private URI getFileUri(String target) {
        URI uri;
        String scheme = null;
        String fragment = null;
        String filename = target;
        String targetLo = target.toLowerCase();
        int index = targetLo.indexOf(".pdf#page=");
        if (index > 0 || (index = targetLo.indexOf(".pdf#dest=")) > 0) {
            filename = target.substring(0, index + 4);
            fragment = target.substring(index + 5);
        }
        if (targetLo.startsWith("file://")) {
            scheme = "file";
            filename = filename.substring("file://".length());
        } else if (targetLo.startsWith("embedded-file:")) {
            scheme = "embedded-file";
            filename = filename.substring("embedded-file:".length());
        } else if (targetLo.startsWith("file:")) {
            scheme = "file";
            filename = filename.substring("file:".length());
        }
        try {
            filename = filename.replace("\\", "/");
            if (filename.matches("[A-z]:.*")) {
                scheme = scheme == null ? "file" : scheme;
                filename = "/" + filename;
            } else if (filename.matches("//.*")) {
                scheme = scheme == null ? "file" : scheme;
                filename = "//" + filename;
            } else if (filename.matches("/.*")) {
                scheme = scheme == null ? "file" : scheme;
            }
            uri = new URI(scheme, filename, fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        return uri;
    }

    private PDFAction getActionForEmbeddedFile(String filename, boolean newWindow) {
        PDFNames names = this.getDocument().getRoot().getNames();
        if (names == null) {
            throw new IllegalStateException("No Names dictionary present. Cannot create Launch Action for embedded file: " + filename);
        }
        PDFEmbeddedFiles embeddedFiles = names.getEmbeddedFiles();
        if (embeddedFiles == null) {
            throw new IllegalStateException("No /EmbeddedFiles name tree present. Cannot create Launch Action for embedded file: " + filename);
        }
        filename = PDFText.toPDFString((CharSequence)filename, (char)'_');
        PDFArray files = embeddedFiles.getNames();
        PDFReference embeddedFileRef = null;
        int i = 0;
        while (i < files.length()) {
            String name = (String)files.get(i);
            PDFReference ref = (PDFReference)files.get(++i);
            if (name.equals(filename)) {
                embeddedFileRef = ref;
                break;
            }
            ++i;
        }
        if (embeddedFileRef == null) {
            throw new IllegalStateException("No embedded file with name " + filename + " present.");
        }
        StringBuffer scriptBuffer = new StringBuffer();
        scriptBuffer.append("this.exportDataObject({cName:\"");
        scriptBuffer.append(filename);
        scriptBuffer.append("\", nLaunch:2});");
        PDFJavaScriptLaunchAction action = new PDFJavaScriptLaunchAction(scriptBuffer.toString());
        return action;
    }

    public String getGoToReference(String pdfPageRef, float yoffset) {
        return this.getPDFGoTo(pdfPageRef, new Point2D.Float(0.0f, yoffset)).referencePDF();
    }

    public PDFGoTo getPDFGoTo(String pdfPageRef, Point2D position) {
        this.getDocument().getProfile().verifyActionAllowed();
        PDFGoTo gt = new PDFGoTo(pdfPageRef, position);
        PDFGoTo oldgt = this.getDocument().findGoTo(gt);
        if (oldgt == null) {
            this.getDocument().assignObjectNumber((PDFObject)gt);
            this.getDocument().addTrailerObject((PDFObject)gt);
        } else {
            gt = oldgt;
        }
        return gt;
    }

    private PDFGoToRemote getGoToPDFAction(String file, String dest, int page, boolean newWindow) {
        this.getDocument().getProfile().verifyActionAllowed();
        PDFFileSpec fileSpec = new PDFFileSpec(file);
        PDFFileSpec oldspec = this.getDocument().findFileSpec(fileSpec);
        if (oldspec == null) {
            this.getDocument().registerObject((PDFObject)fileSpec);
        } else {
            fileSpec = oldspec;
        }
        PDFGoToRemote remote = dest == null && page == -1 ? new PDFGoToRemote(fileSpec, newWindow) : (dest != null ? new PDFGoToRemote(fileSpec, dest, newWindow) : new PDFGoToRemote(fileSpec, page, newWindow));
        PDFGoToRemote oldremote = this.getDocument().findGoToRemote(remote);
        if (oldremote == null) {
            this.getDocument().registerObject((PDFObject)remote);
        } else {
            remote = oldremote;
        }
        return remote;
    }

    private PDFLaunch getLaunchAction(String file, boolean newWindow) {
        this.getDocument().getProfile().verifyActionAllowed();
        PDFFileSpec fileSpec = new PDFFileSpec(file);
        PDFFileSpec oldSpec = this.getDocument().findFileSpec(fileSpec);
        if (oldSpec == null) {
            this.getDocument().registerObject((PDFObject)fileSpec);
        } else {
            fileSpec = oldSpec;
        }
        PDFLaunch launch = new PDFLaunch(fileSpec, newWindow);
        PDFLaunch oldLaunch = this.getDocument().findLaunch(launch);
        if (oldLaunch == null) {
            this.getDocument().registerObject((PDFObject)launch);
        } else {
            launch = oldLaunch;
        }
        return launch;
    }

    public PDFOutline makeOutline(PDFOutline parent, String label, PDFReference actionRef, boolean showSubItems) {
        PDFOutline pdfOutline = new PDFOutline(label, actionRef, showSubItems);
        if (parent != null) {
            parent.addOutline(pdfOutline);
        }
        this.getDocument().registerObject((PDFObject)pdfOutline);
        return pdfOutline;
    }

    public PDFOutline makeOutline(PDFOutline parent, String label, PDFAction pdfAction, boolean showSubItems) {
        return pdfAction == null ? null : this.makeOutline(parent, label, new PDFReference(pdfAction.getAction()), showSubItems);
    }

    public PDFOutline makeOutline(PDFOutline parent, String label, String destination, float yoffset, boolean showSubItems) {
        String goToRef = this.getGoToReference(destination, yoffset);
        return this.makeOutline(parent, label, new PDFReference(goToRef), showSubItems);
    }

    public PDFEncoding makeEncoding(String encodingName) {
        PDFEncoding encoding = new PDFEncoding(encodingName);
        this.getDocument().registerObject((PDFObject)encoding);
        return encoding;
    }

    /*
     * Unable to fully structure code
     */
    public PDFFont makeFont(String fontname, String basefont, String encoding, FontMetrics metrics, FontDescriptor descriptor) {
        block38: {
            block41: {
                block39: {
                    block40: {
                        block37: {
                            preRegisteredfont = this.getDocument().findFont(fontname);
                            if (preRegisteredfont != null) {
                                return preRegisteredfont;
                            }
                            forceToUnicode = true;
                            if (descriptor == null) {
                                font = new PDFFont(fontname, FontType.TYPE1, basefont, (Object)encoding);
                                this.getDocument().registerObject((PDFObject)font);
                                if (forceToUnicode && !PDFEncoding.isPredefinedEncoding((String)encoding)) {
                                    if (encoding != null) {
                                        mapping = CodePointMapping.getMapping((String)encoding);
                                    } else {
                                        tf = (Typeface)metrics;
                                        mapping = CodePointMapping.getMapping((String)tf.getEncodingName());
                                    }
                                    this.generateToUnicodeCmap(font, (SingleByteEncoding)mapping);
                                }
                                return font;
                            }
                            fonttype = metrics.getFontType();
                            fontPrefix = descriptor.isSubsetEmbedded() != false ? this.createSubsetFontPrefix() : "";
                            subsetFontName = String.valueOf(fontPrefix) + basefont;
                            pdfdesc = this.makeFontDescriptor(descriptor, fontPrefix);
                            font = null;
                            font = PDFFont.createFont((String)fontname, (FontType)fonttype, (String)subsetFontName, null);
                            if (descriptor instanceof RefPDFFont) {
                                font.setObjectNumber(((RefPDFFont)descriptor).getRef().getObjectNumber());
                                font.setDocument(this.getDocument());
                                this.getDocument().addObject((PDFObject)font);
                            } else {
                                this.getDocument().registerObject((PDFObject)font);
                            }
                            if (fonttype != FontType.TYPE0 && fonttype != FontType.CIDTYPE0) break block37;
                            font.setEncoding(encoding);
                            cidMetrics = metrics instanceof LazyFont != false ? (CIDFont)((LazyFont)metrics).getRealFont() : (CIDFont)metrics;
                            sysInfo = new PDFCIDSystemInfo(cidMetrics.getRegistry(), cidMetrics.getOrdering(), cidMetrics.getSupplement());
                            sysInfo.setDocument(this.document);
                            if (!PDFFactory.$assertionsDisabled && !(pdfdesc instanceof PDFCIDFontDescriptor)) {
                                throw new AssertionError();
                            }
                            cidFont = new PDFCIDFont(subsetFontName, cidMetrics.getCIDType(), cidMetrics.getDefaultWidth(), this.getFontWidths(cidMetrics), sysInfo, (PDFCIDFontDescriptor)pdfdesc);
                            this.getDocument().registerObject((PDFObject)cidFont);
                            if (cidMetrics instanceof MultiByteFont && ((MultiByteFont)cidMetrics).getCmapStream() != null) {
                                cmap = new PDFCMap("fop-ucs-H", null);
                                try {
                                    cmap.setData(IOUtils.toByteArray((InputStream)((MultiByteFont)cidMetrics).getCmapStream()));
                                }
                                catch (IOException e) {
                                    throw new RuntimeException(e);
                                }
                            } else {
                                cmap = new PDFToUnicodeCMap(cidMetrics.getCIDSet().getChars(), "fop-ucs-H", new PDFCIDSystemInfo("Adobe", "Identity", 0), false);
                            }
                            this.getDocument().registerObject((PDFObject)cmap);
                            if (!PDFFactory.$assertionsDisabled && !(font instanceof PDFFontType0)) {
                                throw new AssertionError();
                            }
                            ((PDFFontType0)font).setCMAP(cmap);
                            ((PDFFontType0)font).setDescendantFonts(cidFont);
                            break block38;
                        }
                        if (!PDFFactory.$assertionsDisabled && !(font instanceof PDFFontNonBase14)) {
                            throw new AssertionError();
                        }
                        nonBase14 = (PDFFontNonBase14)font;
                        nonBase14.setDescriptor(pdfdesc);
                        singleByteFont = metrics instanceof LazyFont != false ? (SingleByteFont)((LazyFont)metrics).getRealFont() : (SingleByteFont)metrics;
                        firstChar = 0;
                        lastChar = 0;
                        defaultChars = false;
                        if (singleByteFont.getEmbeddingMode() != EmbeddingMode.SUBSET) break block39;
                        usedGlyphs = singleByteFont.getUsedGlyphs();
                        if (fonttype != FontType.TYPE1 || usedGlyphs.size() <= 0) break block40;
                        keys = new TreeSet<K>(usedGlyphs.keySet());
                        keys.remove(0);
                        if (keys.size() <= 0) break block41;
                        firstChar = (Integer)keys.first();
                        lastChar = (Integer)keys.last();
                        newWidths = new int[lastChar - firstChar + 1];
                        i = firstChar;
                        while (i < lastChar + 1) {
                            if (usedGlyphs.get(i) == null) ** GOTO lbl82
                            if (i - singleByteFont.getFirstChar() < metrics.getWidths().length) {
                                newWidths[i - firstChar] = metrics.getWidths()[i - singleByteFont.getFirstChar()];
                            } else {
                                defaultChars = true;
                                break;
lbl82:
                                // 1 sources

                                newWidths[i - firstChar] = 0;
                            }
                            ++i;
                        }
                        nonBase14.setWidthMetrics(firstChar, lastChar, new PDFArray(null, newWidths));
                        break block41;
                    }
                    defaultChars = true;
                    break block41;
                }
                defaultChars = true;
            }
            if (defaultChars) {
                firstChar = singleByteFont.getFirstChar();
                lastChar = singleByteFont.getLastChar();
                nonBase14.setWidthMetrics(firstChar, lastChar, new PDFArray(null, metrics.getWidths()));
            }
            mapping = singleByteFont.getEncoding();
            if (singleByteFont.isSymbolicFont()) {
                if (forceToUnicode) {
                    this.generateToUnicodeCmap((PDFFont)nonBase14, mapping);
                }
            } else if (PDFEncoding.isPredefinedEncoding((String)mapping.getName())) {
                font.setEncoding(mapping.getName());
            } else if (mapping.getName().equals("FOPPDFEncoding")) {
                if (fonttype == FontType.TRUETYPE) {
                    font.setEncoding("WinAnsiEncoding");
                } else {
                    charNameMap = mapping.getCharNameMap();
                    intmap = mapping.getUnicodeCharMap();
                    differences = new PDFArray();
                    len = intmap.length;
                    if (charNameMap.length < len) {
                        len = charNameMap.length;
                    }
                    last = 0;
                    i = 0;
                    while (i < len) {
                        if (intmap[i] - '\u0001' != last) {
                            differences.add((double)intmap[i]);
                        }
                        last = intmap[i];
                        differences.add((Object)new PDFName(charNameMap[i]));
                        ++i;
                    }
                    pdfEncoding = new PDFEncoding(singleByteFont.getEncodingName());
                    this.getDocument().registerObject((PDFObject)pdfEncoding);
                    pdfEncoding.setDifferences(differences);
                    font.setEncoding(pdfEncoding);
                    if (mapping.getUnicodeCharMap() != null) {
                        this.generateToUnicodeCmap((PDFFont)nonBase14, mapping);
                    }
                }
            } else {
                pdfEncoding = this.createPDFEncoding(mapping, singleByteFont.getFontName());
                if (pdfEncoding instanceof PDFEncoding) {
                    font.setEncoding((PDFEncoding)pdfEncoding);
                } else {
                    font.setEncoding((String)pdfEncoding);
                }
                if (forceToUnicode) {
                    this.generateToUnicodeCmap((PDFFont)nonBase14, mapping);
                }
            }
            if (singleByteFont.hasAdditionalEncodings()) {
                i = 0;
                c = singleByteFont.getAdditionalEncodingCount();
                while (i < c) {
                    addEncoding = singleByteFont.getAdditionalEncoding(i);
                    name = String.valueOf(fontname) + "_" + (i + 1);
                    pdfenc = this.createPDFEncoding((SingleByteEncoding)addEncoding, singleByteFont.getFontName());
                    addFont = (PDFFontNonBase14)PDFFont.createFont((String)name, (FontType)fonttype, (String)basefont, (Object)pdfenc);
                    addFont.setDescriptor(pdfdesc);
                    addFont.setWidthMetrics(addEncoding.getFirstChar(), addEncoding.getLastChar(), new PDFArray(null, singleByteFont.getAdditionalWidths(i)));
                    this.getDocument().registerObject((PDFObject)addFont);
                    this.getDocument().getResources().addFont((PDFFont)addFont);
                    if (forceToUnicode) {
                        this.generateToUnicodeCmap((PDFFont)addFont, (SingleByteEncoding)addEncoding);
                    }
                    ++i;
                }
            }
        }
        return font;
    }

    private void generateToUnicodeCmap(PDFFont font, SingleByteEncoding encoding) {
        PDFToUnicodeCMap cmap = new PDFToUnicodeCMap(encoding.getUnicodeCharMap(), "fop-ucs-H", new PDFCIDSystemInfo("Adobe", "Identity", 0), true);
        this.getDocument().registerObject((PDFObject)cmap);
        font.setToUnicode((PDFCMap)cmap);
    }

    public Object createPDFEncoding(SingleByteEncoding encoding, String fontName) {
        return PDFEncoding.createPDFEncoding((SingleByteEncoding)encoding, (String)fontName);
    }

    private PDFWArray getFontWidths(CIDFont cidFont) {
        PDFWArray warray = new PDFWArray();
        if (cidFont instanceof MultiByteFont && ((MultiByteFont)cidFont).getWidthsMap() != null) {
            Map map = ((MultiByteFont)cidFont).getWidthsMap();
            for (Map.Entry cid : map.entrySet()) {
                warray.addEntry(((Integer)cid.getKey()).intValue(), new int[]{(Integer)cid.getValue()});
            }
        } else {
            int[] widths = cidFont.getCIDSet().getWidths();
            warray.addEntry(0, widths);
        }
        return warray;
    }

    private String createSubsetFontPrefix() {
        ++this.subsetFontCounter;
        DecimalFormat counterFormat = new DecimalFormat("00000");
        String counterString = counterFormat.format(this.subsetFontCounter);
        StringBuffer sb = new StringBuffer("E");
        char[] cArray = counterString.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            sb.append((char)(c + 17));
            ++n2;
        }
        sb.append("+");
        return sb.toString();
    }

    private PDFFontDescriptor makeFontDescriptor(FontDescriptor desc, String fontPrefix) {
        Object descriptor = null;
        descriptor = desc.getFontType() == FontType.TYPE0 || desc.getFontType() == FontType.CIDTYPE0 ? new PDFCIDFontDescriptor(String.valueOf(fontPrefix) + desc.getEmbedFontName(), desc.getFontBBox(), desc.getCapHeight(), desc.getFlags(), desc.getItalicAngle(), desc.getStemV(), null) : new PDFFontDescriptor(String.valueOf(fontPrefix) + desc.getEmbedFontName(), desc.getAscender(), desc.getDescender(), desc.getCapHeight(), desc.getFlags(), new PDFRectangle(desc.getFontBBox()), desc.getItalicAngle(), desc.getStemV());
        this.getDocument().registerObject((PDFObject)descriptor);
        if (desc.isEmbeddable()) {
            CustomFont font;
            AbstractPDFStream stream = this.makeFontFile(desc, fontPrefix);
            if (stream != null) {
                descriptor.setFontFile(desc.getFontType(), stream);
                this.getDocument().registerObject((PDFObject)stream);
            }
            if ((font = this.getCustomFont(desc)) instanceof CIDFont) {
                CIDFont cidFont = (CIDFont)font;
                this.buildCIDSet((PDFFontDescriptor)descriptor, cidFont);
            }
        }
        return descriptor;
    }

    private void buildCIDSet(PDFFontDescriptor descriptor, CIDFont cidFont) {
        BitSet cidSet = cidFont.getCIDSet().getGlyphIndices();
        PDFStream pdfStream = this.makeStream(null, true);
        ByteArrayOutputStream baout = new ByteArrayOutputStream(cidSet.length() / 8 + 1);
        int value = 0;
        int i = 0;
        int c = cidSet.length();
        while (i < c) {
            int shift = i % 8;
            boolean b = cidSet.get(i);
            if (b) {
                value |= 1 << 7 - shift;
            }
            if (shift == 7) {
                baout.write(value);
                value = 0;
            }
            ++i;
        }
        baout.write(value);
        try {
            try {
                pdfStream.setData(baout.toByteArray());
                descriptor.setCIDSet((AbstractPDFStream)pdfStream);
            }
            catch (IOException ioe) {
                this.log.error((Object)("Failed to write CIDSet [" + cidFont + "] " + cidFont.getEmbedFontName()), (Throwable)ioe);
                IOUtils.closeQuietly((OutputStream)baout);
            }
        }
        finally {
            IOUtils.closeQuietly((OutputStream)baout);
        }
    }

    public AbstractPDFStream makeFontFile(FontDescriptor desc, String fontPrefix) {
        if (desc.getFontType() == FontType.OTHER) {
            throw new IllegalArgumentException("Trying to embed unsupported font type: " + desc.getFontType());
        }
        CustomFont font = this.getCustomFont(desc);
        InputStream in = null;
        try {
            in = font.getInputStream();
            if (in == null) {
                return null;
            }
            AbstractPDFStream embeddedFont = null;
            if (desc.getFontType() == FontType.TYPE0) {
                byte[] fontBytes;
                MultiByteFont mbfont = (MultiByteFont)font;
                FontFileReader reader = new FontFileReader(in);
                String header = OFFontLoader.readHeader((FontFileReader)reader);
                boolean isCFF = mbfont.isOTFFile();
                if (font.getEmbeddingMode() == EmbeddingMode.FULL) {
                    fontBytes = reader.getAllBytes();
                    if (isCFF) {
                        this.document.setPDFVersion(Version.V1_6);
                    }
                } else {
                    fontBytes = this.getFontSubsetBytes(reader, mbfont, header, fontPrefix, desc, isCFF);
                }
                embeddedFont = this.getFontStream(font, fontBytes, isCFF);
            } else if (desc.getFontType() == FontType.TYPE1) {
                if (font.getEmbeddingMode() != EmbeddingMode.SUBSET) {
                    embeddedFont = this.fullyEmbedType1Font(in);
                } else {
                    assert (font instanceof SingleByteFont);
                    SingleByteFont sbfont = (SingleByteFont)font;
                    Type1SubsetFile pfbFile = new Type1SubsetFile();
                    byte[] subsetData = pfbFile.createSubset(in, sbfont);
                    ByteArrayInputStream subsetStream = new ByteArrayInputStream(subsetData);
                    PFBParser parser = new PFBParser();
                    PFBData pfb = parser.parsePFB((InputStream)subsetStream);
                    embeddedFont = new PDFT1Stream();
                    ((PDFT1Stream)embeddedFont).setData(pfb);
                }
            } else {
                if (desc.getFontType() == FontType.TYPE1C) {
                    byte[] file = IOUtils.toByteArray((InputStream)in);
                    PDFCFFStream embeddedFont2 = new PDFCFFStream("Type1C");
                    embeddedFont2.setData(file);
                    PDFCFFStream pDFCFFStream = embeddedFont2;
                    return pDFCFFStream;
                }
                if (desc.getFontType() == FontType.CIDTYPE0) {
                    byte[] file = IOUtils.toByteArray((InputStream)in);
                    PDFCFFStream embeddedFont2 = new PDFCFFStream("CIDFontType0C");
                    embeddedFont2.setData(file);
                    PDFCFFStream pDFCFFStream = embeddedFont2;
                    return pDFCFFStream;
                }
                byte[] file = IOUtils.toByteArray((InputStream)in);
                embeddedFont = new PDFTTFStream(file.length);
                ((PDFTTFStream)embeddedFont).setData(file, file.length);
            }
            AbstractPDFStream abstractPDFStream = embeddedFont;
            return abstractPDFStream;
        }
        catch (IOException ioe) {
            this.log.error((Object)("Failed to embed font [" + desc + "] " + desc.getEmbedFontName()), (Throwable)ioe);
            return null;
        }
        finally {
            if (in != null) {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    private AbstractPDFStream fullyEmbedType1Font(InputStream in) throws IOException {
        PFBParser parser = new PFBParser();
        PFBData pfb = parser.parsePFB(in);
        PDFT1Stream embeddedFont = new PDFT1Stream();
        embeddedFont.setData(pfb);
        return embeddedFont;
    }

    private byte[] getFontSubsetBytes(FontFileReader reader, MultiByteFont mbfont, String header, String fontPrefix, FontDescriptor desc, boolean isCFF) throws IOException {
        if (isCFF) {
            OTFSubSetFile otfFile = new OTFSubSetFile();
            otfFile.readFont(reader, String.valueOf(fontPrefix) + desc.getEmbedFontName(), header, mbfont);
            return otfFile.getFontSubset();
        }
        TTFSubSetFile otfFile = new TTFSubSetFile();
        otfFile.readFont(reader, mbfont.getTTCName(), header, mbfont.getUsedGlyphs());
        return otfFile.getFontSubset();
    }

    private AbstractPDFStream getFontStream(CustomFont font, byte[] fontBytes, boolean isCFF) throws IOException {
        PDFTTFStream embeddedFont;
        if (isCFF) {
            embeddedFont = new PDFCFFStreamType0C(font.getEmbeddingMode() == EmbeddingMode.FULL);
            ((PDFCFFStreamType0C)embeddedFont).setData(fontBytes, fontBytes.length);
        } else {
            embeddedFont = new PDFTTFStream(fontBytes.length);
            embeddedFont.setData(fontBytes, fontBytes.length);
        }
        return embeddedFont;
    }

    private CustomFont getCustomFont(FontDescriptor desc) {
        Typeface tempFont = desc instanceof LazyFont ? ((LazyFont)desc).getRealFont() : (Typeface)desc;
        if (!(tempFont instanceof CustomFont)) {
            throw new IllegalArgumentException("FontDescriptor must be instance of CustomFont, but is a " + desc.getClass().getName());
        }
        return (CustomFont)tempFont;
    }

    public PDFStream makeStream(String type, boolean add) {
        PDFStream obj = new PDFStream();
        obj.setDocument(this.getDocument());
        obj.getFilterList().addDefaultFilters(this.getDocument().getFilterMap(), type);
        if (add) {
            this.getDocument().registerObject((PDFObject)obj);
        }
        return obj;
    }

    public PDFICCStream makePDFICCStream() {
        PDFICCStream iccStream = new PDFICCStream();
        this.getDocument().registerObject((PDFObject)iccStream);
        return iccStream;
    }

    public PDFICCBasedColorSpace makeICCBasedColorSpace(PDFResourceContext res, String explicitName, PDFICCStream iccStream) {
        PDFICCBasedColorSpace cs = new PDFICCBasedColorSpace(explicitName, iccStream);
        this.getDocument().registerObject((PDFObject)cs);
        if (res != null) {
            res.getPDFResources().addColorSpace((PDFColorSpace)cs);
        } else {
            this.getDocument().getResources().addColorSpace((PDFColorSpace)cs);
        }
        return cs;
    }

    public PDFSeparationColorSpace makeSeparationColorSpace(PDFResourceContext res, NamedColorSpace ncs) {
        String colorName = ncs.getColorName();
        Double zero = 0.0;
        Double one = 1.0;
        List<Double> domain = Arrays.asList(zero, one);
        List<Double> range = Arrays.asList(zero, one, zero, one, zero, one);
        float[] cZero = new float[]{1.0f, 1.0f, 1.0f};
        float[] cOne = ncs.getRGBColor().getColorComponents(null);
        PDFFunction tintFunction = this.makeFunction(domain, range, cZero, cOne, 1.0);
        PDFSeparationColorSpace cs = new PDFSeparationColorSpace(colorName, tintFunction);
        this.getDocument().registerObject((PDFObject)cs);
        if (res != null) {
            res.getPDFResources().addColorSpace((PDFColorSpace)cs);
        } else {
            this.getDocument().getResources().addColorSpace((PDFColorSpace)cs);
        }
        return cs;
    }

    public PDFArray makeArray(int[] values) {
        PDFArray array = new PDFArray(null, values);
        this.getDocument().registerObject((PDFObject)array);
        return array;
    }

    public PDFGState makeGState(Map<?, ?> settings, PDFGState current) {
        PDFGState wanted = new PDFGState();
        wanted.addValues(PDFGState.DEFAULT);
        wanted.addValues(settings);
        PDFGState existing = this.getDocument().findGState(wanted, current);
        if (existing != null) {
            return existing;
        }
        PDFGState gstate = new PDFGState();
        gstate.addValues(settings);
        this.getDocument().registerObject((PDFObject)gstate);
        return gstate;
    }

    public PDFAnnotList makeAnnotList() {
        PDFAnnotList obj = new PDFAnnotList();
        this.getDocument().assignObjectNumber((PDFObject)obj);
        return obj;
    }

    public PDFLayer makeLayer(String id) {
        PDFLayer layer = new PDFLayer(id);
        this.getDocument().registerObject((PDFObject)layer);
        return layer;
    }

    public PDFSetOCGStateAction makeSetOCGStateAction(String id) {
        PDFSetOCGStateAction action = new PDFSetOCGStateAction(id);
        this.getDocument().registerObject((PDFObject)action);
        return action;
    }

    public PDFTransitionAction makeTransitionAction(String id) {
        PDFTransitionAction action = new PDFTransitionAction(id);
        this.getDocument().registerObject((PDFObject)action);
        return action;
    }

    public PDFNavigator makeNavigator(String id) {
        PDFNavigator navigator = new PDFNavigator(id);
        this.getDocument().registerObject((PDFObject)navigator);
        return navigator;
    }

    public void makeDPart(PDFPage page, String pageMasterName) {
        PDFDPart dPart;
        PDFDPartRoot root = this.getDocument().getRoot().getDPartRoot();
        if (this.dparts.containsKey(pageMasterName)) {
            dPart = this.dparts.get(pageMasterName);
        } else {
            dPart = new PDFDPart((PDFDictionary)root.dpart);
            root.add(dPart);
            this.getDocument().registerTrailerObject((PDFObject)dPart);
            this.dparts.put(pageMasterName, dPart);
        }
        dPart.addPage(page);
        page.put("DPart", (Object)dPart);
    }

    public PDFDPartRoot makeDPartRoot() {
        PDFDPartRoot pdfdPartRoot = new PDFDPartRoot(this.getDocument());
        this.getDocument().registerTrailerObject((PDFObject)pdfdPartRoot);
        return pdfdPartRoot;
    }
}

