/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.util;

import java.math.BigDecimal;

public class UnitUtil {
    public static double pixel2mm(double p, int dpi) {
        BigDecimal d = new BigDecimal(p * (double)25.4f);
        BigDecimal b = new BigDecimal(dpi);
        BigDecimal r = d.divide(b, 4, 1);
        return r.doubleValue();
    }

    public static double mm2pixel(double m, int dpi) {
        BigDecimal d = new BigDecimal(m * (double)dpi);
        BigDecimal b = new BigDecimal(25.4f);
        BigDecimal r = d.divide(b, 4, 1);
        return r.doubleValue();
    }

    public static int point2pixel(int pt, int dpi) {
        int px = pt * dpi / 72;
        return px;
    }

    public static double point2pixel(double pt, int dpi) {
        BigDecimal d = new BigDecimal(pt * (double)dpi);
        BigDecimal b = new BigDecimal(72.0);
        BigDecimal px = d.divide(b, 2, 1);
        return px.doubleValue();
    }

    public static int pixel2point(int px, int dpi) {
        int pt = px * 72 / dpi;
        return pt;
    }

    public static double pixel2point(double px, int dpi) {
        BigDecimal d = new BigDecimal(px * 72.0);
        BigDecimal b = new BigDecimal(dpi);
        BigDecimal pt = d.divide(b, 2, 1);
        return pt.doubleValue();
    }

    public static int convert(String fontSize) {
        int index = fontSize.indexOf("pt");
        if (index != -1) {
            double pt = Double.parseDouble(fontSize.substring(0, index));
            return (int)(UnitUtil.point2pixel(pt, 300) + 0.5);
        }
        index = fontSize.indexOf("px");
        if (index != -1) {
            return (int)(Double.parseDouble(fontSize.substring(0, index)) + 0.5);
        }
        return (int)(Double.parseDouble(fontSize) + 0.5);
    }
}

