/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.icepdf.core.pobjects.Document;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.codes.Base64;

public class PdfUtil {
    private static final Log log = LogFactory.getLog(PdfUtil.class);

    public static List<String> pdfToImage(String pdfPath, String savePath, String suffix) {
        return PdfUtil.pdfToImage(pdfPath, savePath, suffix, 9999);
    }

    public static List<String> pdfToImage(String pdfPath, String savePath, String suffix, int page) {
        int pageTotal;
        float rotation;
        float scale;
        Document document;
        block4: {
            document = new Document();
            document.setFile(pdfPath);
            scale = 1.0f;
            rotation = 0.0f;
            pageTotal = document.getNumberOfPages();
            if (pageTotal != 0) break block4;
            return null;
        }
        try {
            ArrayList<String> urlList = new ArrayList<String>();
            long id = Ids.longId();
            int n = 0;
            while (n < pageTotal) {
                BufferedImage image;
                String localDir = String.valueOf(savePath) + id + "-" + n + "." + suffix;
                BufferedImage rendImage = image = document.getPageImage(n, 1, 2, rotation, scale);
                File outFile = new File(localDir);
                ImageIO.write((RenderedImage)rendImage, "png", outFile);
                image.flush();
                urlList.add(localDir);
                if (n >= page - 1) break;
                ++n;
            }
            document.dispose();
            return urlList;
        }
        catch (Exception e) {
            log.error((Object)"pdf\u751f\u6210\u56fe\u7247\u5f02\u5e38", (Throwable)e, new Object[0]);
            return null;
        }
    }

    public static void pdfToImage(String pdfPath, String rootDir, String midPath, String fileName, List<String> imgList, List<String> urlList) {
        try {
            if (imgList == null || urlList == null || Validates.isEmpty((String)fileName)) {
                log.error((Object)"pdf\u751f\u6210\u7f29\u7565\u56fe\uff0c\u53c2\u6570\u9519\u8bef");
                return;
            }
            midPath = Strings.removeStartsWith((String)midPath, (String)"/");
            midPath = Strings.removeEndsWith((String)midPath, (String)"/");
            String savePath = String.valueOf(Strings.addEndsWith((String)rootDir, (String)"/")) + midPath;
            if (!Files.isDirectory((String)savePath)) {
                Files.mkDirectory((String)savePath);
            }
            Document document = new Document();
            document.setFile(pdfPath);
            float scale = 1.0f;
            float rotation = 0.0f;
            int pageTotal = document.getNumberOfPages();
            if (pageTotal == 0) {
                return;
            }
            String suffix = Files.getFileExt((String)fileName);
            String name = fileName.substring(0, fileName.lastIndexOf("."));
            int n = 0;
            while (n < pageTotal) {
                BufferedImage image;
                String tempName = String.valueOf(name) + "-" + n + "." + suffix;
                String localDir = String.valueOf(savePath) + "/" + tempName;
                String thumbUrl = "/service/upl/" + Base64.encodeFileUrlUTF8((String)midPath) + "/" + tempName;
                BufferedImage rendImage = image = document.getPageImage(n, 1, 2, rotation, scale);
                File outFile = new File(localDir);
                ImageIO.write((RenderedImage)rendImage, "png", outFile);
                image.flush();
                imgList.add(localDir);
                urlList.add(thumbUrl);
                ++n;
            }
            document.dispose();
        }
        catch (Exception e) {
            log.error((Object)"pdf\u751f\u6210\u56fe\u7247\u5f02\u5e38", (Throwable)e, new Object[0]);
        }
    }

    public static void main(String[] args) {
        PdfUtil.pdfToImage("D:\\_yangcai\\images\\cmyk_5.pdf", "D:\\_yangcai\\images\\", "jpg");
    }
}

