/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.model;

import com.zhiqim.media.dbo.MediaBg;
import com.zhiqim.media.dbo.MediaCanvas;
import com.zhiqim.media.dbo.MediaMaterial;
import com.zhiqim.media.service.dao.MediaDao;
import com.zhiqim.media.service.dao.MediaPathDao;
import com.zhiqim.media.service.util.UnitUtil;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.uploadlarge.dbo.UpllFile;

public class MediaCdrSvgModel {
    private String fileDir;
    private String svgCode;
    private Document document;
    private long mediaId;
    private int bid;
    private MediaCanvas canvas;
    private List<MediaMaterial> materialList = new ArrayList<MediaMaterial>();

    public MediaCdrSvgModel(String fileDir, long mediaId, int bid, String svgCode) {
        this.fileDir = fileDir;
        this.mediaId = mediaId;
        this.bid = bid;
        this.svgCode = svgCode;
    }

    public void init() {
        if (this.svgCode == null) {
            return;
        }
        StringReader read = new StringReader(this.svgCode);
        InputSource is = new InputSource(read);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(is);
        }
        catch (Exception exception) {}
    }

    public void parse() {
        this.init();
        Element svg = this.getChildNode(this.document, "svg");
        this.parseCanvas(svg);
        NodeList nodes = svg.getChildNodes();
        int mid = 0;
        int j = 0;
        while (j < nodes.getLength()) {
            Element ele;
            MediaMaterial m;
            Node node = nodes.item(j);
            if (node.getNodeType() == 1 && (m = this.parseMaterial(ele = (Element)node)) != null) {
                m.setMid(mid);
                this.materialList.add(m);
                ++mid;
            }
            ++j;
        }
    }

    private void parseCanvas(Element svg) {
        double width = Double.parseDouble(svg.getAttribute("width"));
        double height = Double.parseDouble(svg.getAttribute("height"));
        double widthMm = Math.round(UnitUtil.pixel2mm(width, 300));
        double heightMm = Math.round(UnitUtil.pixel2mm(height, 300));
        this.canvas = this.createMediaCanvas(width, height, widthMm, heightMm);
    }

    private MediaMaterial parseMaterial(Element ele) {
        MediaMaterial material = null;
        String source = this.toXml(ele);
        if (source.indexOf("data-text") != -1) {
            material = this.createMediaMaterial(0, 1, source, null);
        } else if (source.indexOf("<image ") != -1) {
            String imageName = MediaDao.getImageValue(source);
            String imagePath = String.valueOf(Strings.addEndsWith((String)this.fileDir, (String)"/")) + imageName;
            UpllFile upllFile = this.uploadImage(imagePath);
            source = source.replace(imageName, upllFile.getFileUrl());
            material = this.createMediaMaterial(0, 0, source, upllFile.getFileId());
        } else {
            material = this.createMediaMaterial(0, 3, source, null);
        }
        return material;
    }

    protected Element getChildNode(Node node, String nodeName) {
        NodeList nodelist = node.getChildNodes();
        int i = 0;
        while (i < nodelist.getLength()) {
            Node child = nodelist.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals(nodeName)) {
                return (Element)child;
            }
            ++i;
        }
        return null;
    }

    public Document getDocument() {
        return this.document;
    }

    public String getSvgCode() {
        return this.svgCode;
    }

    public MediaCanvas getCanvas() {
        return this.canvas;
    }

    public void setCanvas(MediaCanvas canvas) {
        this.canvas = canvas;
    }

    public List<MediaMaterial> getMaterialList() {
        return this.materialList;
    }

    public void setMaterialList(List<MediaMaterial> materialList) {
        this.materialList = materialList;
    }

    public MediaCanvas createMediaCanvas(double width, double height, double widthMm, double heightMm) {
        String time = DateTimes.getDateTimeString();
        MediaCanvas canvas = new MediaCanvas();
        canvas.setMediaId(this.mediaId);
        canvas.setMediaName("\u672a\u547d\u540d");
        canvas.setStatus(0);
        canvas.setIsEdit(0);
        canvas.setMediaUrl(null);
        canvas.setDpi(300);
        canvas.setBleedSize(2.0);
        canvas.setCreateMode(0);
        canvas.setModify(true);
        canvas.setCreateTime(time);
        canvas.setUpdateTime(time);
        canvas.setWidth(width);
        canvas.setHeight(height);
        canvas.setWidthMm(widthMm);
        canvas.setHeightMm(heightMm);
        canvas.setOddEven(0L);
        return canvas;
    }

    public MediaBg createMediaBg(double width, double height) {
        MediaBg bg = new MediaBg();
        bg.setMediaId(this.mediaId);
        bg.setBid(this.bid);
        bg.setOddEven(0L);
        bg.setFileId(null);
        bg.setBgUrl(null);
        bg.setBgMinUrl(null);
        bg.setSource("<svg width=\"" + width + "\" height=\"" + height + "\" preserveAspectRatio=\"none\" ><rect x=\"0\" y=\"0\" width=\"100%\" height=\"100%\" fill=\"#ffffff\"></rect></svg>");
        return bg;
    }

    public MediaMaterial createMediaMaterial(int mid, int type, String source, String fileId) {
        MediaMaterial m = new MediaMaterial();
        m.setMediaId(this.mediaId);
        m.setBid(this.bid);
        m.setMid(mid);
        m.setPos(mid);
        m.setType(type);
        m.setStatus(0);
        m.setFileId(null);
        m.setSource(source);
        return m;
    }

    public String toXml(Node node) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.setOutputProperty("encoding", "utf-8");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            t.transform(new DOMSource(node), new StreamResult(bos));
            String xml = bos.toString();
            return xml.substring(38);
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    private UpllFile uploadImage(String imagePath) {
        String name = Files.getFileName((String)imagePath);
        try {
            byte[] bytes = Files.read((String)imagePath);
            String curDate = DateTimes.getDateTime8String();
            String jpgFile = String.valueOf(MediaPathDao.getDesignMaterialLocalPre(curDate)) + name;
            UpllFile file = MediaPathDao.createUpllFile(bytes, jpgFile);
            return file;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

