/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.model;

import com.zhiqim.media.service.util.FontUtil;
import com.zhiqim.media.service.util.UnitUtil;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.zhiqim.kernel.util.Validates;

public class MaterialTextSvg {
    private final String svgCode;
    private Document document;
    private Node gwrap;
    private String fontFamily = "\u5fae\u8f6f\u96c5\u9ed1";
    private int fontSize = 32;
    private String text;
    private String color = "#000000";
    private boolean isBold = false;
    private boolean isUnderline = false;
    private boolean isItalic = false;
    private String underlineOffset;
    private String underlineThickness;
    private int letterSpacing = 0;

    public MaterialTextSvg(String svgCode) {
        this.svgCode = svgCode;
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws Exception {
        StringReader read = new StringReader(this.svgCode);
        InputSource is = new InputSource(read);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.parse(is);
    }

    public void parse() {
        Node line;
        Node path;
        NodeList glist = this.document.getChildNodes();
        Node g = glist.item(0);
        this.gwrap = g.cloneNode(false);
        NamedNodeMap gAttrs = g.getAttributes();
        int i = 0;
        while (i < gAttrs.getLength()) {
            String value;
            Node attr = gAttrs.item(i);
            if (attr.getNodeName().equals("data-fontfamily")) {
                this.fontFamily = attr.getNodeValue();
            } else if (attr.getNodeName().equals("data-fontsize")) {
                this.fontSize = UnitUtil.convert(attr.getNodeValue());
            } else if (attr.getNodeName().equals("data-text")) {
                value = attr.getNodeValue();
                if (Validates.isNotEmpty((String)value)) {
                    value = value.replaceAll("-%6-%-%0-", "<");
                }
                this.text = value;
            } else if (attr.getNodeName().equals("data-letterspacing")) {
                value = attr.getNodeValue();
                if (Validates.isFloat((String)value)) {
                    this.letterSpacing = (int)Math.round(Double.parseDouble(value));
                }
            } else if (attr.getNodeName().equals("data-fontweight")) {
                this.isBold = Integer.parseInt(attr.getNodeValue()) == 1;
            }
            ++i;
        }
        Node svg = this.getChildNode(g, "svg");
        Node group = this.getChildNode(svg, "g");
        Node gpath = this.getChildNode(group, "g");
        if (svg != null && group != null && gpath != null) {
            NamedNodeMap gpathAttrs = gpath.getAttributes();
            int i2 = 0;
            while (i2 < gpathAttrs.getLength()) {
                Node attr = gpathAttrs.item(i2);
                if (attr.getNodeName().equals("transform") && attr.getNodeValue().indexOf("skewX(-15)") != -1) {
                    this.isItalic = true;
                }
                ++i2;
            }
        }
        if ((path = this.getChildNode(gpath, "path")) != null) {
            NamedNodeMap pathAttrs = path.getAttributes();
            int i3 = 0;
            while (i3 < pathAttrs.getLength()) {
                Node attr = pathAttrs.item(i3);
                if (attr.getNodeName().equals("fill")) {
                    this.color = attr.getNodeValue();
                }
                ++i3;
            }
        }
        if ((line = this.getChildNode(gpath, "line")) != null) {
            this.isUnderline = true;
        }
    }

    private Node getChildNode(Node node, String nodeName) {
        if (node != null) {
            NodeList nodelist = node.getChildNodes();
            int i = 0;
            while (i < nodelist.getLength()) {
                Node child = nodelist.item(i);
                if (child.getNodeType() == 1 && child.getNodeName().equals(nodeName)) {
                    return child;
                }
                ++i;
            }
        }
        return null;
    }

    public String derive(String str) {
        if (Validates.isEmpty((String)str)) {
            return "";
        }
        str = str.trim();
        Element g = (Element)this.gwrap.cloneNode(false);
        g.setAttribute("data-text", str);
        int style = this.isBold ? 1 : 0;
        Font font = new Font(this.fontFamily, style, this.fontSize);
        LineMetrics lineMetrics = FontUtil.getLineMetrics(font, str);
        this.underlineThickness = String.valueOf(lineMetrics.getUnderlineThickness());
        this.underlineOffset = String.valueOf(lineMetrics.getUnderlineOffset());
        GlyphVector gv = font.createGlyphVector(FontUtil.frc, str);
        Rectangle2D rect = gv.getLogicalBounds();
        Element gInner = this.document.createElement("g");
        gInner.setAttribute("transform", "translate(0," + Math.abs(rect.getY()) + ")");
        double vx = 0.0;
        double width = 0.0;
        double whitespaceWidth = 0.0;
        double preEndX = 0.0;
        double x = 0.0;
        int i = 0;
        while (i < str.length()) {
            Shape shape = FontUtil.getShape(font, str, i);
            if (i == 0) {
                vx = shape.getBounds().getX();
            }
            String d = FontUtil.toPathData(shape);
            double curX = gv.getGlyphOutline(i).getBounds().getX() - shape.getBounds().getX();
            if (d.length() == 0) {
                width = whitespaceWidth;
                curX = preEndX;
            } else if (i < str.length() - 1) {
                double nextX;
                if (gv.getGlyphOutline(i + 1).getBounds().getX() == 0.0) {
                    width = 2.0 * shape.getBounds().getX() + shape.getBounds().getWidth();
                    if (whitespaceWidth == 0.0) {
                        int count = 0;
                        nextX = 0.0;
                        int j = i + 1;
                        while (j < str.length()) {
                            if (gv.getGlyphOutline(j).getBounds().getX() == 0.0) {
                                ++count;
                            } else {
                                Shape nextShape = FontUtil.getShape(font, str, j);
                                nextX = gv.getGlyphOutline(j).getBounds().getX() - nextShape.getBounds().getX();
                                break;
                            }
                            ++j;
                        }
                        whitespaceWidth = (nextX - curX - width) / (double)count;
                    }
                } else {
                    Shape nextShape = FontUtil.getShape(font, str, i + 1);
                    nextX = gv.getGlyphOutline(i + 1).getBounds().getX() - nextShape.getBounds().getX();
                    width = nextX - curX;
                }
            } else {
                width = rect.getWidth() - curX;
            }
            x = curX + (double)(this.letterSpacing * i);
            Element gpath = this.createGpath(x, width, shape.getBounds().getHeight(), d);
            gInner.appendChild(gpath);
            preEndX = curX + width;
            ++i;
        }
        vx = vx >= 0.0 ? 0.0 : vx;
        Element svg = this.createSvgElement(rect.getWidth() + Math.tan(-15.0) * rect.getHeight() / 2.0, rect.getHeight(), vx);
        g.appendChild(svg);
        svg.appendChild(gInner);
        String xml = this.toXml(g);
        return xml.substring(38);
    }

    private Element createSvgElement(double width, double height, double x) {
        Element svg = this.document.createElement("svg");
        svg.setAttribute("preserveAspectRatio", "none");
        svg.setAttribute("width", "" + width);
        svg.setAttribute("height", "" + height);
        svg.setAttribute("viewBox", String.valueOf(x) + " 0 " + width + " " + height);
        return svg;
    }

    private Element createGpath(double x, double width, double height, String data) {
        Element g = this.document.createElement("g");
        g.setAttribute("class", "font-path");
        String transform = "translate(" + x + ", 0) skewX(0)";
        if (this.isItalic) {
            transform = "translate(" + x + ", 0) skewX(-15)";
        }
        g.setAttribute("transform", transform);
        g.setAttribute("data-width", String.valueOf(width));
        g.setAttribute("data-heihgt", String.valueOf(height));
        Element path = this.document.createElement("path");
        path.setAttribute("fill", this.color);
        path.setAttribute("d", data);
        g.appendChild(path);
        if (this.isUnderline) {
            Element line = this.document.createElement("line");
            line.setAttribute("x1", "0");
            line.setAttribute("x2", "" + width);
            line.setAttribute("y1", this.underlineOffset);
            line.setAttribute("y2", this.underlineOffset);
            line.setAttribute("stroke", this.color);
            line.setAttribute("stroke-width", this.underlineThickness);
            g.appendChild(line);
        }
        return g;
    }

    public String toXml(Node node) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();
            t.setOutputProperty("encoding", "utf-8");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            t.transform(new DOMSource(node), new StreamResult(bos));
            String xml = bos.toString();
            return xml;
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public String getText() {
        return this.text;
    }
}

