/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.service.handler;

import com.zhiqim.media.dbo.MediaCanvas;
import com.zhiqim.media.service.Employee;
import com.zhiqim.media.service.dao.MediaDao;
import com.zhiqim.media.service.handler.MediaHandleModel;
import com.zhiqim.media.service.model.MediaModel;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.control.Handler;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Maths;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Updater;

public class SaveMediaCanvasHandler
implements Handler<MediaHandleModel> {
    private final Log log = LogFactory.getLog(SaveMediaCanvasHandler.class);

    public void process(MediaHandleModel module) {
        long mediaId = module.getMediaId();
        long t1 = System.currentTimeMillis();
        try {
            try {
                this.log.info((Object)("\u4fdd\u5b58\u5904\u7406\u5668\u4fdd\u5b58[" + mediaId + "]\u5f00\u59cb..."));
                if (Validates.isNotEmptyBlank((String)module.getMediaModuleJson())) {
                    MediaModel media = (MediaModel)Jsons.toObject((String)module.getMediaModuleJson(), MediaModel.class);
                    module.setModule(media);
                }
                String mediaUrl = null;
                MediaCanvas canvas = module.getModule().getCanvas();
                canvas.setIsEdit(module.getDefaultIsEdit());
                module.setHandleStatus(1);
                if (canvas.getIsEdit() != 1) {
                    canvas.setIsEdit(2);
                }
                MediaModel data = MediaDao.preSaveMedia(module.getModule());
                this.log.info((Object)("\u4fdd\u5b58\u5904\u7406\u5668\u4fdd\u5b58[" + mediaId + "]\u4fdd\u5b58\u9884\u5904\u7406\u5b8c\u6210..."));
                MediaDao.saveMedia(data);
                this.log.info((Object)("\u4fdd\u5b58\u5904\u7406\u5668\u4fdd\u5b58[" + mediaId + "]\u4fdd\u5b58\u5b8c\u6210..."));
                if (module.isCreateMediaImage()) {
                    mediaUrl = MediaDao.doCreateMediaImage(mediaId, canvas, data.getBgList(), data.getMaterialList(), data.getCoverMaterialList());
                }
                this.log.info((Object)("\u4fdd\u5b58\u5904\u7406\u5668\u4fdd\u5b58[" + mediaId + "]\u751f\u6210\u6a21\u677f\u6548\u679c\u56fe\u5b8c\u6210..."));
                data.getCanvas().setMediaUrl(mediaUrl);
                if (module.isDoImgCallback() && module.getParamJson() != null) {
                    ((Employee)Global.get(Employee.class)).excute(null, mediaId, module.getParamJson());
                }
                module.setHandleStatus(2);
                module.getModule().getCanvas().setIsEdit(0);
                module.getModule().getCanvas().setMediaUrl(mediaUrl);
                long t2 = System.currentTimeMillis();
                this.log.info((Object)("\u4fdd\u5b58\u5904\u7406\u5668\u4fdd\u5b58[" + mediaId + "]\u5b8c\u6210, \u5171\u8017\u65f6[%s]\u79d2"), new Object[]{Maths.division((long)(t2 - t1), (long)1000L, (int)3)});
            }
            catch (Exception e) {
                module.setHandleStatus(3);
                module.setErrorMsg("\u4fdd\u5b58\u5904\u7406[" + mediaId + "]\u5f02\u5e38\uff1a" + e.getMessage());
                this.log.error((Object)("\u4fdd\u5b58\u5904\u7406\u5668\u5904\u7406[" + mediaId + "]\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e, new Object[0]);
                Updater updater = new Updater();
                updater.addMust("mediaId", (Object)mediaId);
                updater.addMustNotEqual("isEdit", (Object)1);
                updater.addField("isEdit", (Object)0);
                try {
                    ((ZTable)ORM.get(ZTable.class)).update(MediaCanvas.class, updater);
                }
                catch (Exception e2) {
                    this.log.error((Object)("\u4fdd\u5b58\u5904\u7406\u5668\u6807\u8bb0\u5904\u7406\u5b8c\u6210\u5f02\u5e38:" + e2.getMessage()), (Throwable)e2, new Object[0]);
                }
            }
        }
        finally {
            Updater updater = new Updater();
            updater.addMust("mediaId", (Object)mediaId);
            updater.addMustNotEqual("isEdit", (Object)1);
            updater.addField("isEdit", (Object)0);
            try {
                ((ZTable)ORM.get(ZTable.class)).update(MediaCanvas.class, updater);
            }
            catch (Exception e) {
                this.log.error((Object)("\u4fdd\u5b58\u5904\u7406\u5668\u6807\u8bb0\u5904\u7406\u5b8c\u6210\u5f02\u5e38:" + e.getMessage()), (Throwable)e, new Object[0]);
            }
        }
    }
}

