/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.manage.action;

import com.zhiqim.media.dbo.MediaFont;
import com.zhiqim.media.service.cache.MediaFontCache;
import com.zhiqim.media.service.dao.MediaPathDao;
import com.zhiqim.media.service.util.FontUtil;
import java.awt.Font;
import java.io.FileInputStream;
import java.io.InputStream;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.httpd.validate.Validate;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.httpd.validate.onex.IsInteger;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;

@AnAlias(value={"MediaFontAction"})
public class MediaFontAction
implements Action {
    private static final Log log = LogFactory.getLog(MediaFontAction.class);

    public void execute(HttpRequest request) throws Exception {
        int pageNo = request.getParameterInt("page", 1);
        int pageSize = request.getParameterInt("page.size", 20);
        PageResult pageResult = ((ZTable)ORM.get(ZTable.class)).page(MediaFont.class, pageNo, pageSize, new Selector().addOrderbyAsc("fontIndex"));
        request.setAttribute("pageResult", (Object)pageResult);
    }

    public static void doModifyFontIndex(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsNotEmpty("fontName", "\u5b57\u4f53\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
        request.addValidate((Validate)new IsInteger("fontIndex", "\u5e8f\u53f7\u5fc5\u987b\u4e3a\u6b63\u6574\u6570"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        String fontName = request.getParameter("fontName");
        int fontIndex = request.getParameterInt("fontIndex", 100);
        Updater updater = new Updater();
        updater.addMust("fontName", (Object)fontName);
        updater.addField("fontIndex", (Object)fontIndex);
        ((ZTable)ORM.get(ZTable.class)).update(MediaFont.class, updater);
        ((MediaFontCache)Global.get(MediaFontCache.class)).doRefresh();
    }

    public static void doModifyStatus(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsNotEmpty("fontName", "\u5b57\u4f53\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
        request.addValidate((Validate)new IsNotEmpty("fontStatus", "\u5b57\u4f53\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a"));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        String fontName = request.getParameter("fontName");
        int status = request.getParameterInt("fontStatus");
        Updater updater = new Updater();
        updater.addMust("fontName", (Object)fontName);
        updater.addField("fontStatus", (Object)status);
        ((ZTable)ORM.get(ZTable.class)).update(MediaFont.class, updater);
        ((MediaFontCache)Global.get(MediaFontCache.class)).doRefresh();
    }

    public static void doCreateFont(HttpRequest request) throws Exception {
        String dir = "/opt/fonts/font";
        String copyDir = "/opt/fonts/font_exist";
        String useDir = "/opt/fonts/font_use";
        String[] fontList = Files.getDirectoryList((String)dir);
        if (fontList == null || fontList.length == 0) {
            request.setResponseError("\u5f85\u5b89\u88c5\u5b57\u4f53\u76ee\u5f55[/opt/fonts/font]\u4e3a\u7a7a");
            return;
        }
        MediaFont maxFontIndex = (MediaFont)((ZTable)ORM.get(ZTable.class)).item(MediaFont.class, new Selector().addOrderbyDesc("fontIndex"));
        int maxIndex = 0;
        if (maxFontIndex != null) {
            maxIndex = maxFontIndex.getFontIndex();
        }
        int success = 0;
        int i = 0;
        while (i < fontList.length) {
            String fileName = fontList[i];
            try {
                String path = String.valueOf(dir) + "\\" + fileName;
                FileInputStream in = new FileInputStream(path);
                Font f = Font.createFont(0, in);
                String fontName = f.getFontName();
                ((InputStream)in).close();
                if (((ZTable)ORM.get(ZTable.class)).item(MediaFont.class, new Object[]{fontName}) != null) {
                    log.info((Object)("\u5b57\u4f53[" + fontName + "]\u5df2\u5b58\u5728\uff0c\u65e0\u987b\u91cd\u65b0\u751f\u6210"));
                    Files.copyFile((String)path, (String)(String.valueOf(copyDir) + "\\" + fontList[i]));
                    Files.deleteFile((String)path);
                } else {
                    String fontSvg = FontUtil.font2Svg(fontName, 0, 22, fontName);
                    long id = Ids.longId13();
                    String filePath = String.valueOf(MediaPathDao.getSysMaterialLocalPre("font")) + "font_" + id + ".svg";
                    String urlPath = String.valueOf(MediaPathDao.getSysMaterialUrlPre("font")) + "font_" + id + ".svg";
                    if (Files.writeUTF8((String)filePath, (String)fontSvg)) {
                        MediaFont font = new MediaFont();
                        font.setFontStatus(0);
                        font.setFontIndex(++maxIndex);
                        font.setFontName(fontName);
                        font.setFileName(fileName);
                        font.setFontSvg(urlPath);
                        ((ZTable)ORM.get(ZTable.class)).replace((Object)font);
                        ++success;
                        Files.copyFile((String)path, (String)(String.valueOf(useDir) + "\\" + fontList[i]));
                        Files.deleteFile((String)path);
                        log.info((Object)("\u5b57\u4f53[" + fontName + "]\u521b\u5efa\u5165\u5e93\u5b8c\u6210"));
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("\u5b57\u4f53" + fontList[i] + "\u5904\u7406\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e, new Object[0]);
            }
            ++i;
        }
        ((MediaFontCache)Global.get(MediaFontCache.class)).doRefresh();
        log.info((Object)("\u5b57\u4f53\u751f\u6210\u5b8c\u6210\uff0c\u5171\uff1a" + fontList.length + "\u6761,\u6210\u529f\uff1a" + success + "\u6761"));
    }
}

