/*
 * Decompiled with CFR 0.152.
 */
package com.zhiqim.media.manage.action;

import com.zhiqim.media.dbo.MaterialSvg;
import com.zhiqim.media.dbo.MediaImageUse;
import com.zhiqim.media.service.constants.MaterialConstants;
import com.zhiqim.media.service.dao.MediaDao;
import com.zhiqim.media.service.dao.MediaPathDao;
import com.zhiqim.media.service.util.GraphicsMagickUtil;
import com.zhiqim.media.service.util.SanselanUtil;
import com.zhiqim.media.service.util.SvgUtil;
import java.util.Map;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpUploader;
import org.zhiqim.httpd.context.extend.StdSwitchAction;
import org.zhiqim.httpd.validate.Validate;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.kernel.annotation.AnTransaction;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ORM;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;

public class MaterialSvgAction
extends StdSwitchAction {
    protected void validateId(HttpRequest request) {
        request.addValidate((Validate)new IsNotEmpty("svgId", "\u8bf7\u9009\u62e9\u7d20\u6750"));
    }

    protected void validateForm(HttpRequest request) {
    }

    protected void list(HttpRequest request) throws Exception {
        int pageNo = request.getParameterInt("page", 1);
        int pageSize = request.getParameterInt("page.size", 20);
        String typeCode = request.getParameter("typeCode");
        long svgId = request.getParameterLong("svgId");
        String svgKeywords = request.getParameter("svgKeywords");
        String catCode = request.getParameter("catCode");
        Selector sel = new Selector();
        if (svgId != -1L) {
            sel.addMust("svgId", (Object)svgId);
        }
        sel.addMaybe("typeCode", (Object)typeCode);
        sel.addMaybe("catCode", (Object)catCode);
        sel.addMaybeLike("keywords", (Object)svgKeywords);
        sel.addOrderbyAsc("svgSeq");
        PageResult pageResult = ((ZTable)ORM.get(ZTable.class)).page(MaterialSvg.class, pageNo, pageSize, sel);
        pageResult.addConditionMap((Map)request.getParameterMap());
        request.setAttribute("pageResult", (Object)pageResult);
        request.setAttribute("catCode", (Object)catCode);
    }

    protected void add(HttpRequest request) throws Exception {
        int num = ((ZTable)ORM.get(ZTable.class)).count(MaterialSvg.class);
        request.setAttribute("num", (Object)num);
    }

    protected void modify(HttpRequest request) throws Exception {
        long svgId = request.getParameterLong("svgId");
        MaterialSvg item = (MaterialSvg)((ZTable)ORM.get(ZTable.class)).item(MaterialSvg.class, new Object[]{svgId});
        request.setAttribute("item", (Object)item);
    }

    @AnTransaction
    protected void insert(HttpRequest request) throws Exception {
        String contentType = request.getContentType();
        if (contentType.contains("multipart/form-data")) {
            HttpUploader upload = new HttpUploader();
            upload.parseHttpRequest(request, 0xA00000);
            String typeCode = upload.getParameter("typeCode");
            String catCode = upload.getParameter("catCode");
            String keywords = upload.getParameter("keywords");
            int svgSeq = Validates.isEmpty((String)upload.getParameter("svgSeq")) ? 100 : Integer.parseInt(upload.getParameter("svgSeq"));
            int isEdit = upload.getParameter("isEdit") == null ? 0 : Integer.parseInt(upload.getParameter("isEdit"));
            String fileExt = upload.getFileExt();
            long svgId = Ids.longId();
            String fileName = String.valueOf(svgId) + "." + fileExt;
            String thumbnailName = String.valueOf(svgId) + "_thumbnail.png";
            String thumbnailPath = String.valueOf(MediaPathDao.getSysMaterialLocalPre(String.valueOf(catCode) + "/thumbnail")) + thumbnailName;
            String svgThumbnail = String.valueOf(MediaPathDao.getSysMaterialUrlPre(String.valueOf(catCode) + "/thumbnail")) + thumbnailName;
            byte[] by = upload.getBytes();
            try {
                SanselanUtil.checkImageInfo(by);
            }
            catch (Exception e) {
                request.returnHistory(e.getMessage());
                return;
            }
            String filePath = String.valueOf(MediaPathDao.getSysMaterialLocalPre(catCode)) + fileName;
            String fileUrl = String.valueOf(MediaPathDao.getSysMaterialUrlPre(catCode)) + fileName;
            boolean isSuccess = Files.write((String)filePath, (byte[])by);
            if (!isSuccess) {
                request.returnHistory("\u56fe\u7247\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
                return;
            }
            int[] ret = GraphicsMagickUtil.getImageInfo(filePath);
            String svgCode = SvgUtil.buildImageSvg(fileUrl, ret[0], ret[1]);
            GraphicsMagickUtil.resizeByWidth(150, filePath, thumbnailPath, "90");
            MaterialSvg item = new MaterialSvg();
            item.setSvgId(svgId);
            item.setTypeCode(typeCode);
            item.setIsEdit(isEdit);
            item.setIsUpload(1);
            item.setCatCode(catCode);
            item.setKeywords(keywords);
            item.setSvgStatus(0);
            item.setSvgSeq(svgSeq);
            item.setSvgThumbnail(svgThumbnail);
            item.setSvgCode(svgCode);
            ((ZTable)ORM.get(ZTable.class)).insert((Object)item);
        } else {
            String typeCode = request.getParameter("typeCode");
            String catCode = request.getParameter("catCode");
            String keywords = request.getParameter("keywords");
            int svgSeq = request.getParameterInt("svgSeq");
            String svgCode = request.getParameterNoFilter("svgCode");
            int isEdit = request.getParameterInt("isEdit", 0);
            if (Validates.isEmpty((String)svgCode)) {
                request.returnHistory("svg\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
                return;
            }
            String fileId = "" + Ids.longId();
            String svgThumbnail = "";
            if (!MaterialConstants.MATERIAL_TEXT.value().equals(typeCode)) {
                String thumbnailName = String.valueOf(fileId) + "_thumbnail.png";
                String thumbnailPath = String.valueOf(MediaPathDao.getSysMaterialLocalPre(String.valueOf(catCode) + "/thumbnail")) + thumbnailName;
                svgThumbnail = String.valueOf(MediaPathDao.getSysMaterialUrlPre(String.valueOf(catCode) + "/thumbnail")) + thumbnailName;
                try {
                    SvgUtil.svg2Png(svgCode, thumbnailPath, 150, 0);
                }
                catch (Exception exception) {
                    request.returnHistory("\u975e\u6587\u5b57\u7d20\u6750\u8bf7\u8f93\u5165\u6b63\u786e\u683c\u5f0f\u7684SVG\u5185\u5bb9");
                    return;
                }
            }
            MaterialSvg item = new MaterialSvg();
            item.setSvgId(Ids.longId());
            item.setTypeCode(typeCode);
            item.setIsEdit(isEdit);
            item.setIsUpload(0);
            item.setCatCode(catCode);
            item.setKeywords(keywords);
            item.setSvgStatus(0);
            item.setSvgSeq(svgSeq);
            item.setSvgThumbnail(svgThumbnail);
            item.setSvgCode(svgCode);
            ((ZTable)ORM.get(ZTable.class)).insert((Object)item);
        }
    }

    protected void update(HttpRequest request) throws Exception {
        MaterialSvg item = (MaterialSvg)request.getParameter(MaterialSvg.class);
        Updater updater = new Updater();
        updater.addMust("svgId", (Object)item.getSvgId());
        updater.addField("isEdit", (Object)item.getIsEdit());
        updater.addField("svgStatus", (Object)item.getSvgStatus());
        updater.addField("keywords", (Object)item.getKeywords());
        updater.addField("svgSeq", (Object)item.getSvgSeq());
        if (item.getIsUpload() == 0) {
            String svgCode = item.getSvgCode();
            String catCode = item.getCatCode();
            if (Validates.isEmpty((String)catCode)) {
                catCode = item.getTypeCode();
            }
            if (!MaterialConstants.MATERIAL_TEXT.value().equals(item.getTypeCode())) {
                String thumbnailName = String.valueOf(item.getSvgId()) + "_thumbnail.png";
                String thumbnailPath = String.valueOf(MediaPathDao.getSysMaterialLocalPre(String.valueOf(catCode) + "/thumbnail")) + thumbnailName;
                String svgThumbnail = String.valueOf(MediaPathDao.getSysMaterialUrlPre(String.valueOf(catCode) + "/thumbnail")) + thumbnailName;
                try {
                    SvgUtil.svg2Png(svgCode, thumbnailPath, 150, 0);
                }
                catch (Exception exception) {
                    request.returnHistory("\u975e\u6587\u5b57\u7d20\u6750\u8bf7\u8f93\u5165\u6b63\u786e\u683c\u5f0f\u7684SVG\u5185\u5bb9");
                    return;
                }
                updater.addField("svgThumbnail", (Object)svgThumbnail);
            }
            updater.addField("svgCode", (Object)svgCode);
        }
        ((ZTable)ORM.get(ZTable.class)).update(MaterialSvg.class, updater);
    }

    @AnTransaction
    protected void delete(HttpRequest request) throws Exception {
        long svgId = request.getParameterLong("svgId");
        MaterialSvg item = (MaterialSvg)((ZTable)ORM.get(ZTable.class)).item(MaterialSvg.class, new Object[]{svgId});
        if (item.getIsUpload() == 1) {
            String url = MediaDao.getImageValue(item.getSvgCode());
            if (((ZTable)ORM.get(ZTable.class)).count(MediaImageUse.class, new Selector("url", (Object)url)) <= 0) {
                String filePath = MediaPathDao.parseUplUrl(url);
                Files.deleteFile((String)filePath);
            }
        }
        String filePath = MediaPathDao.parseUplUrl(item.getSvgThumbnail());
        Files.deleteFile((String)filePath);
        ((ZTable)ORM.get(ZTable.class)).delete(MaterialSvg.class, new Object[]{svgId});
    }
}

