/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager.presenter;

import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpCookie;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.HttpSessionUser;
import org.zhiqim.httpd.context.ZmlBootstrap;
import org.zhiqim.httpd.context.ZmlContexts;
import org.zhiqim.httpd.context.core.Context;
import org.zhiqim.httpd.util.Sessions;
import org.zhiqim.httpd.validate.Validate;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.httpd.validate.ones.IsNumericLen;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnTransaction;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Randoms;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.codes.Base64;
import org.zhiqim.kernel.util.codes.RSA;
import org.zhiqim.manager.SmsUtils;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrBootstrapApi;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.ZmrPassworder;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dao.ZmrOperatorDao;
import org.zhiqim.manager.dao.ZmrParamDao;
import org.zhiqim.manager.dbo.ZmrAvatar;
import org.zhiqim.manager.dbo.ZmrMenu;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;

@AnAlias(value={"ZmrLoginPresenter"})
public class ZmrLoginPresenter
implements ZmrConstants {
    private static final Log log = LogFactory.getLog(ZmrLoginPresenter.class);

    public static void doLogin(HttpRequest request) throws Exception {
        ZmlBootstrap bootstrap;
        List<ZmrMenu> menuList;
        String privateKey;
        ZmrOperator operator;
        String hasVerificationSms;
        HttpContext context = request.getContext();
        request.addValidate((Validate)new IsNotEmpty("operatorCode", "\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a"));
        request.addValidate((Validate)new IsNotEmpty("operatorPass", "\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        String string = hasVerificationSms = request.getSessionAttribute("hasVerificationSms") == null ? null : String.valueOf(request.getSessionAttribute("hasVerificationSms"));
        if ("true".equals(hasVerificationSms)) {
            request.addValidate((Validate)new IsNumericLen("smsCode", "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5fc5\u987b\u662f6\u4f4d\u6570\u5b57", 6, 6));
        }
        if (ZmrParamDao.hasVerificationCode(context)) {
            request.addValidate((Validate)new IsNumericLen("verificationCode", "\u9a8c\u8bc1\u7801\u5fc5\u987b\u662f4\u4f4d\u6570\u5b57", 4, 4));
        }
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        if ("true".equals(hasVerificationSms)) {
            String smsCode = request.getParameter("smsCode");
            if (smsCode.length() != 6) {
                request.setResponseError("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5fc5\u987b\u662f6\u4f4d\u6570\u5b57");
                return;
            }
            String sessionSmsCodeSession = request.getSessionAttributeString("_smscode_");
            if (!smsCode.equals(sessionSmsCodeSession)) {
                request.setResponseError("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\u6216\u5df2\u5931\u6548\uff0c\u8bf7\u65b0\u8f93\u5165\uff01");
                return;
            }
        }
        if (ZmrParamDao.hasVerificationCode(context)) {
            String verificationCode = request.getParameter("verificationCode");
            if (verificationCode.length() != 4) {
                request.setResponseError("\u9a8c\u8bc1\u7801\u5fc5\u987b\u662f4\u4f4d\u6570\u5b57");
                return;
            }
            String vcode = Sessions.getSessionVerificationCode((HttpRequest)request);
            if (!verificationCode.equals(vcode)) {
                request.setResponseError("\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\u6216\u5df2\u5931\u6548\uff0c\u8bf7\u65b0\u8f93\u5165\uff01");
                return;
            }
        }
        String operatorCode = request.getParameter("operatorCode");
        Selector selector = new Selector();
        if (Validates.isNumericLen((String)operatorCode, (int)11, (int)11)) {
            selector.addMust("operatorMobile", (Object)operatorCode);
        } else {
            selector.addMust("operatorCode", (Object)operatorCode);
        }
        String role = request.getParameter("role");
        if (Validates.isNotEmptyBlank((String)role)) {
            if ("oms".equals(role)) {
                selector.addMust("orgId", (Object)1805031820320001L);
            } else {
                selector.addMustNotEqual("orgId", (Object)1805031820320001L);
            }
        }
        if ((operator = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, selector)) == null) {
            request.setResponseError("\u7528\u6237\u540d\u4e0d\u6b63\u786e");
            return;
        }
        if (operator.getOperatorStatus() == 1) {
            request.setResponseError("\u8be5\u7528\u6237\u5df2\u505c\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return;
        }
        String operatorPass = request.getParameter("operatorPass");
        byte[] operatorPassByte = Base64.decode((String)operatorPass);
        byte[] operatorPassDecrypt = RSA.decrypt((byte[])operatorPassByte, (String)(privateKey = ZmrParamDao.getPrivateKey(context)));
        if (ZmrLoginPresenter.isValidateRememberPass(operatorPass = new String(operatorPassDecrypt, _UTF_8_C_))) {
            if (!(ZmrParamDao.hasRememberCode(context) && ZmrParamDao.hasRememberPass(context) && operatorCode.equals(request.getCookie("operatorCode")))) {
                request.setResponseError("\u7528\u6237\u5bc6\u7801\u4e0d\u6b63\u786e");
                return;
            }
            ZmrPassworder passworder = ((ZmrBootstrap)request.getContextAttribute(ZmrBootstrap.class)).getPassworder();
            String operatorPassSecr = request.getCookie("operatorPass");
            if (!passworder.secretChk(operatorCode, operatorPass, operator.getOperatorPassSalt(), operatorPassSecr)) {
                request.setResponseError("\u7528\u6237\u5bc6\u7801\u4e0d\u6b63\u786e");
                return;
            }
        } else if (!ZmrOperatorDao.validatePassword(request, operator, operatorPass)) {
            request.setResponseError("\u7528\u6237\u5bc6\u7801\u4e0d\u6b63\u786e");
            return;
        }
        if ((menuList = ZmrOperatorDao.getOperatorMenuList(request, operator)).isEmpty()) {
            request.setResponseError("\u60a8\u6682\u6ca1\u6709\u4efb\u4f55\u64cd\u4f5c\u6743\u9650\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb");
            return;
        }
        ZmrSessionUser sessionUser = new ZmrSessionUser().setOperator(operator).setMenuList(context, menuList);
        sessionUser.setSelectedOrgId(operator.getOrgId());
        request.bindSessionUser((HttpSessionUser)sessionUser);
        if (ZmrParamDao.hasRememberCode(context)) {
            boolean rememberCode = request.getParameterBoolean("rememberCode");
            boolean rememberPass = request.getParameterBoolean("rememberPass");
            int day30 = 2592000;
            HttpResponse response = request.getResponse();
            if (rememberPass) {
                ZmrPassworder passworder = ((ZmrBootstrap)request.getContextAttribute(ZmrBootstrap.class)).getPassworder();
                String operatorSecr = passworder.secret(operatorCode, operatorPass, operator.getOperatorPassSalt());
                response.addCookie(new HttpCookie("operatorCode", operatorCode, day30));
                response.addCookie(new HttpCookie("operatorPass", operatorSecr, day30));
            } else if (rememberCode) {
                response.addCookie(new HttpCookie("operatorCode", operatorCode, day30));
                response.addCookie(new HttpCookie("operatorPass", "", day30));
            } else {
                response.addCookie(new HttpCookie("operatorCode", "", day30));
                response.addCookie(new HttpCookie("operatorPass", "", day30));
            }
        }
        String mainUrl = request.getRootPath(ZmlContexts.parseZmlContent((HttpRequest)request, (String)ZmrParamDao.getMainUrl(context)));
        if (!ZmrParamDao.isThemeFrame(context)) {
            request.setResponseResult(mainUrl);
        } else {
            String defaultUrl = request.getRootPath(ZmlContexts.parseZmlContent((HttpRequest)request, (String)"/${zhiqim_manager}/main.htm"));
            String welcomeUrl = request.getRootPath(ZmlContexts.parseZmlContent((HttpRequest)request, (String)"/${zhiqim_manager}/welcome.htm"));
            sessionUser.setWelcomeUrl(welcomeUrl);
            sessionUser.setMainUrl(defaultUrl.equals(mainUrl) ? welcomeUrl : mainUrl);
            request.setResponseResult(defaultUrl);
        }
        if ("true".equals(hasVerificationSms)) {
            request.getSessionAttributeString("_smscode_", null);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("\u8d26\u53f7", operatorCode);
            map.put("\u624b\u673a\u53f7\u7801", operator.getOperatorMobile());
        }
        if ((bootstrap = ((Context)context).getBootstrap()) instanceof ZmrBootstrapApi) {
            ((ZmrBootstrapApi)bootstrap).logined(request);
        }
    }

    public static void sendSms(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsNotEmpty("operatorCode", "\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a"));
        String operatorCode = request.getParameter("operatorCode");
        ZmrOperator operator = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{operatorCode});
        if (operator == null) {
            request.setResponseError("\u7528\u6237\u540d\u4e0d\u6b63\u786e");
            return;
        }
        if (operator.getOperatorStatus() == 1) {
            request.setResponseError("\u8be5\u7528\u6237\u5df2\u505c\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return;
        }
        String mobile = operator.getOperatorMobile();
        if (Validates.isEmpty((String)mobile)) {
            request.setResponseError("\u8be5\u7528\u6237\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\u7801\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return;
        }
        SmsUtils.sendSmsCode(request, mobile, "SMS_463645918");
    }

    public static void sendSmsRestPass(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsNotEmpty("operatorMobile", "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        String operatorMobile = request.getParameter("operatorMobile");
        Selector selector = new Selector();
        selector.addMust("operatorMobile", (Object)operatorMobile);
        ZmrOperator operator = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, selector);
        if (operator == null) {
            request.setResponseError("\u624b\u673a\u53f7\u672a\u6ce8\u518c");
            return;
        }
        if (operator.getOperatorStatus() == 1) {
            request.setResponseError("\u8be5\u7528\u6237\u5df2\u505c\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return;
        }
        SmsUtils.sendSmsCode(request, operatorMobile, "SMS_463645918");
    }

    public static void sendSmsReg(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsNotEmpty("operatorMobile", "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        request.addValidate((Validate)new IsNotEmpty("operatorCode", "\u7528\u6237\u6635\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
        String operatorMobile = request.getParameter("operatorMobile");
        String operatorCode = request.getParameter("operatorCode");
        ZmrOperator operator = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{operatorCode});
        if (operator != null) {
            request.setResponseError("\u7528\u6237\u6635\u79f0\u5df2\u5b58\u5728");
            return;
        }
        Selector selector = new Selector();
        selector.addMust("operatorMobile", (Object)operatorMobile);
        ZmrOperator operatorNew = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, selector);
        if (operatorNew != null) {
            request.setResponseError("\u624b\u673a\u53f7\u5df2\u6ce8\u518c");
            return;
        }
        SmsUtils.sendSmsCode(request, operatorMobile, "SMS_463645918");
    }

    private static boolean isValidateRememberPass(String operatorPass) {
        int i = 0;
        while (i < operatorPass.length()) {
            if (operatorPass.charAt(i) != '\u25cf') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void resetPassword(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsNotEmpty("operatorMobile", "\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a"));
        request.addValidate((Validate)new IsNotEmpty("operatorPass", "\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        request.addValidate((Validate)new IsNotEmpty("smsCode", "\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        request.addValidate((Validate)new IsNumericLen("smsCode", "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5fc5\u987b\u662f6\u4f4d\u6570\u5b57", 6, 6));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        try {
            String operatorMobile = request.getParameter("operatorMobile");
            String operatorPass = request.getParameter("operatorPass");
            String operatorNewPass = request.getParameter("operatorNewPass");
            String smsCode = request.getParameter("smsCode");
            boolean isMatch = Pattern.matches("^0?(13|14|15|16|17|18|19)[0-9]{9}$", operatorMobile);
            if (!isMatch) {
                request.setResponseError("\u624b\u673a\u53f7\u4e0d\u5408\u6cd5");
                return;
            }
            if (!operatorPass.equals(operatorNewPass)) {
                request.setResponseError("\u4e8c\u6b21\u786e\u8ba4\u5bc6\u7801\u4e0d\u4e00\u6837");
                return;
            }
            String sessionSmsCodeSession = request.getSessionAttributeString("_smscode_");
            if (!smsCode.equals(sessionSmsCodeSession)) {
                request.setResponseError("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\u6216\u5df2\u5931\u6548\uff0c\u8bf7\u65b0\u8f93\u5165\uff01");
                return;
            }
            if (!Validates.isUserPass((String)operatorPass)) {
                request.setResponseError("\u5bc6\u7801\u4e0d\u5408\u8981\u6c42\uff1a\u5fc5\u987b\u5927\u5c0f\u5199\u5b57\u6bcd\u6570\u5b57\u548c\u7279\u6b8a\u5b57\u7b26\u5fc5\u987b\u56db\u9009\u4e09");
                return;
            }
            Selector selector = new Selector();
            selector.addMust("operatorMobile", (Object)operatorMobile);
            ZmrOperator operator = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, selector);
            if (operator == null) {
                request.setResponseError("\u624b\u673a\u53f7\u672a\u6ce8\u518c");
                return;
            }
            ZmrPassworder passworder = ((ZmrBootstrap)request.getContextAttribute(ZmrBootstrap.class)).getPassworder();
            String operatorPassSalt = Randoms.lettersDigitsSecure((int)64);
            operatorPass = passworder.encode(operator.getOperatorCode(), operatorPass, operatorPassSalt);
            Updater updater = new Updater();
            updater.addMust("operatorMobile", (Object)operatorMobile);
            updater.addField("operatorPass", (Object)operatorPass);
            updater.addField("operatorPassSalt", (Object)operatorPassSalt);
            ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, updater);
            request.setResponseResult("\u5bc6\u7801\u91cd\u7f6e\u6210\u529f");
        }
        catch (Exception e) {
            log.error((Object)("\u64cd\u4f5c\u5458\u5bc6\u7801\u91cd\u7f6e\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e, new Object[0]);
            request.setResponseError("\u5bc6\u7801\u91cd\u7f6e\u5f02\u5e38\uff1a" + e.getMessage());
            return;
        }
    }

    @AnTransaction
    public static void insertReg(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsNotEmpty("operatorMobile", "\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        request.addValidate((Validate)new IsNotEmpty("operatorCode", "\u7528\u6237\u6635\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
        request.addValidate((Validate)new IsNotEmpty("operatorPass", "\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        request.addValidate((Validate)new IsNotEmpty("smsCode", "\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        request.addValidate((Validate)new IsNumericLen("smsCode", "\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5fc5\u987b\u662f6\u4f4d\u6570\u5b57", 6, 6));
        if (!request.chkValidate()) {
            request.setResponseError(request.getAlertMsg());
            return;
        }
        try {
            String operatorCode = request.getParameter("operatorCode");
            String operatorPass = request.getParameter("operatorPass");
            String operatorNewPass = request.getParameter("operatorNewPass");
            String operatorMobile = request.getParameter("operatorMobile");
            String smsCode = request.getParameter("smsCode");
            if (operatorCode.length() < 2 || operatorCode.length() > 8) {
                request.setResponseError("\u7528\u6237\u6635\u79f0\u957f\u5ea6\u4e0d\u5408\u6cd5\uff0c\u7cfb\u7edf\u652f\u63012-8\u4f4d\u5b57\u6bcd\u6216\u6570\u5b57\u6216\u6c49\u5b57\u7ec4\u5408");
                return;
            }
            boolean isMatch = Pattern.matches("^0?(13|14|15|16|17|18|19)[0-9]{9}$", operatorMobile);
            if (!isMatch) {
                request.setResponseError("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7");
                return;
            }
            if (!operatorPass.equals(operatorNewPass)) {
                request.setResponseError("\u4e8c\u6b21\u786e\u8ba4\u5bc6\u7801\u4e0d\u4e00\u6837");
                return;
            }
            if (ZmrBootstrap.tableOpr(request).count(ZmrOperator.class, new Object[]{operatorCode}) > 0) {
                request.setResponseError("\u8be5\u7528\u6237\u6635\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
                return;
            }
            String sessionSmsCodeSession = request.getSessionAttributeString("_smscode_");
            if (!smsCode.equals(sessionSmsCodeSession)) {
                request.setResponseError("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e\u6216\u5df2\u5931\u6548\uff0c\u8bf7\u65b0\u8f93\u5165\uff01");
                return;
            }
            if (!Validates.isUserPass((String)operatorPass)) {
                request.setResponseError("\u5bc6\u7801\u4e0d\u5408\u8981\u6c42\uff1a\u5fc5\u987b\u5927\u5c0f\u5199\u5b57\u6bcd\u6570\u5b57\u548c\u7279\u6b8a\u5b57\u7b26\u5fc5\u987b\u56db\u9009\u4e09");
                return;
            }
            long operatorAvatar = 0L;
            PageResult result = ZmrBootstrap.table(request).page(ZmrAvatar.class, 1, 10, new Selector("avatarId", "avatarType", (Object)0));
            if (result.size() > 0) {
                int ind = new Random().nextInt(result.size());
                operatorAvatar = ((ZmrAvatar)result.list().get(ind)).getAvatarId();
            }
            ZmrPassworder passworder = ((ZmrBootstrap)request.getContextAttribute(ZmrBootstrap.class)).getPassworder();
            String operatorPassSalt = Randoms.lettersDigitsSecure((int)64);
            operatorPass = passworder.encode(operatorCode, operatorPass, operatorPassSalt);
            ZmrOperator operator = new ZmrOperator();
            operator.setOrgId(1808071102554512L);
            operator.setOperatorRole("2112411071001");
            operator.setOperatorCode(operatorCode);
            operator.setOperatorPass(operatorPass);
            operator.setOperatorPassSalt(operatorPassSalt);
            operator.setOperatorStatus(0);
            operator.setOperatorType(2);
            operator.setOperatorName(operatorCode);
            operator.setOperatorAvatar(operatorAvatar);
            operator.setOperatorMobile(operatorMobile);
            operator.setOperatorCreated(DateTimes.getDateTimeString());
            operator.setOperatorModified(DateTimes.getDateTimeString());
            operator.setOperatorParam("reg");
            ZmrBootstrap.table(request).insert((Object)operator);
            request.setResponseResult("\u6ce8\u518c\u6210\u529f");
        }
        catch (Exception e) {
            log.error((Object)("\u7528\u6237\u6ce8\u518c\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e, new Object[0]);
            request.setResponseError("\u7528\u6237\u6ce8\u518c\u5f02\u5e38\uff1a" + e.getMessage());
            return;
        }
    }
}

