/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager.action;

import java.util.List;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.StdSwitchAction;
import org.zhiqim.httpd.validate.Validate;
import org.zhiqim.httpd.validate.ones.IsLen;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.kernel.annotation.AnTransaction;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.dao.ZmrOperatorDao;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.manager.dbo.ZmrParamOperator;

public class ParamOperatorAction
extends StdSwitchAction
implements ZmrConstants {
    protected void validateId(HttpRequest request) {
        request.addValidate((Validate)new IsNotEmpty("paramKey", "\u53c2\u6570\u952e\u4e0d\u80fd\u4e3a\u7a7a"));
    }

    protected void validateForm(HttpRequest request) {
        request.addValidate((Validate)new IsLen("paramKey", "\u53c2\u6570\u952e\u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u4e0d\u8d85\u8fc732\u4e2a\u5b57\u7b26", 1, 32));
        request.addValidate((Validate)new IsLen("paramDesc", "\u53c2\u6570\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u4e0d\u8d85\u8fc7200\u4e2a\u5b57\u7b26", 1, 200));
    }

    protected void list(HttpRequest request) throws Exception {
        int page = request.getParameterInt("page");
        int pageSize = request.getContextAttributeInt("zmr_page_size", 20);
        PageResult result = ZmrBootstrap.tableOpr(request).page(ZmrParamOperator.class, page, pageSize);
        request.setAttribute("result", (Object)result);
    }

    protected void add(HttpRequest request) throws Exception {
    }

    protected void insert(HttpRequest request) throws Exception {
        String paramKey = request.getParameter("paramKey");
        String paramDesc = request.getParameter("paramDesc");
        if (ZmrBootstrap.tableOpr(request).count(ZmrParamOperator.class, new Object[]{paramKey}) > 0) {
            request.returnHistory("\u8be5\u64cd\u4f5c\u5458\u53c2\u6570\u952e\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            return;
        }
        ZmrParamOperator operatorParam = new ZmrParamOperator();
        operatorParam.setParamKey(paramKey);
        operatorParam.setParamDesc(paramDesc);
        ZmrBootstrap.table(request).insert((Object)operatorParam);
    }

    protected void modify(HttpRequest request) throws Exception {
    }

    protected void update(HttpRequest request) throws Exception {
    }

    @AnTransaction
    protected void delete(HttpRequest request) throws Exception {
        String paramKey = request.getParameter("paramKey");
        ZmrParamOperator operatorParam = (ZmrParamOperator)ZmrBootstrap.tableOpr(request).item(ZmrParamOperator.class, new Object[]{paramKey});
        if (operatorParam == null) {
            request.returnHistory("\u8be5\u64cd\u4f5c\u5458\u53c2\u6570\u4e0d\u5b58\u5728");
            return;
        }
        List operatorList = ZmrBootstrap.tableOpr(request).list(ZmrOperator.class);
        for (ZmrOperator zmrOperator : operatorList) {
            ZmrOperatorDao.deleteOperatorParam(request, zmrOperator.getOperatorCode(), paramKey);
        }
        ZmrBootstrap.table(request).delete(ZmrParamOperator.class, new Object[]{paramKey});
    }
}

