/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager.action;

import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.StdSwitchAction;
import org.zhiqim.httpd.validate.Validate;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.httpd.validate.onex.IsUserCode;
import org.zhiqim.httpd.validate.onex.IsUserPass;
import org.zhiqim.kernel.annotation.AnTransaction;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Randoms;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrConstants;
import org.zhiqim.manager.ZmrPassworder;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dao.ZmrDeptDao;
import org.zhiqim.manager.dbo.ZmrAvatar;
import org.zhiqim.manager.dbo.ZmrDept;
import org.zhiqim.manager.dbo.ZmrOperator;
import org.zhiqim.manager.dbo.ZmrOperatorLog;
import org.zhiqim.manager.dbo.ZmrOperatorRule;
import org.zhiqim.manager.dbo.ZmrRole;
import org.zhiqim.manager.presenter.WorkWechatPresenter;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;

public class OperatorAction
extends StdSwitchAction
implements ZmrConstants {
    protected void validateId(HttpRequest request) {
        request.addValidate((Validate)new IsUserCode("operatorCode", "\u64cd\u4f5c\u5458\u7f16\u7801\u75312-16\u4f4d\u5b57\u6bcd\u6570\u5b57\u6c49\u5b57\u5f00\u5934\uff0c\u5b57\u6bcd\u6c49\u5b57\u6570\u5b57\u7279\u6b8a\u7b26\u53f7\u7ec4\u6210"));
    }

    protected void validateForm(HttpRequest request) {
        request.addValidate((Validate)new IsUserCode("operatorCode", "\u64cd\u4f5c\u5458\u7f16\u7801\u75312-16\u4f4d\u5b57\u6bcd\u6570\u5b57\u6c49\u5b57\u5f00\u5934\uff0c\u5b57\u6bcd\u6c49\u5b57\u6570\u5b57\u7279\u6b8a\u7b26\u53f7\u7ec4\u6210"));
        request.addValidate((Validate)new IsNotEmpty("operatorName", "\u64cd\u4f5c\u5458\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a"));
        request.addValidate((Validate)new IsNotEmpty("operatorStatus", "\u64cd\u4f5c\u5458\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a"));
        request.addValidate((Validate)new IsNotEmpty("operatorMobile", "\u64cd\u4f5c\u5458\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
    }

    protected void list(HttpRequest request) throws Exception {
        int page = request.getParameterInt("page");
        int pageSize = request.getContextAttributeInt("zmr_page_size", 20);
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        long orgId = sessionUser.getSelectedOrgId();
        List<ZmrDept> deptList = ZmrDeptDao.getOrgDeptList(request, orgId);
        List roleList = ZmrBootstrap.table(request).list(ZmrRole.class);
        Selector selector = new Selector();
        if (sessionUser.isAdmin()) {
            selector.addMustThenG("operatorType", (Object)0);
        } else {
            selector.addMustThenG("operatorType", (Object)1);
        }
        String operatorKey = request.getParameter("operatorKey");
        if (Validates.isNotEmpty((String)operatorKey)) {
            selector.addOr((Selector)((Selector)new Selector().addMaybeLike("operatorCode", (Object)operatorKey)).addMaybeLike("operatorName", (Object)operatorKey));
        }
        selector.addMaybe("operatorStatus", (Object)request.getParameterInt("operatorStatus"));
        selector.addOrderbyAsc("operatorType");
        selector.addOrderbyAsc("operatorStatus");
        selector.addOrderbyAsc("operatorCreated");
        selector.addMust("orgId", (Object)orgId);
        PageResult result = ZmrBootstrap.tableOpr(request).page(ZmrOperator.class, page, pageSize, selector);
        result.addConditionMap((Map)request.getParameterMap());
        for (ZmrOperator operator : result.list()) {
            this.toDeptName(deptList, operator);
            this.toRoleName(roleList, operator);
        }
        request.setAttribute("result", (Object)result);
    }

    protected void add(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsUserPass("operatorPass", "\u64cd\u4f5c\u5458\u5bc6\u7801\u4e0d\u5408\u6cd5\uff0c\u8981\u6c426-16\u4f4d\uff08\u5927\u5c0f\u5199\u5b57\u6bcd\u6570\u5b57\u548c\u7279\u6b8a\u5b57\u7b26\u5fc5\u987b\u56db\u9009\u4e09\uff09"));
    }

    protected void insert(HttpRequest request) throws Exception {
        boolean isMatch;
        String dateTime = DateTimes.getDateTimeString();
        long orgId = ((ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class)).getSelectedOrgId();
        String operatorCode = request.getParameter("operatorCode");
        String operatorPass = request.getParameter("operatorPass");
        int operatorStatus = request.getParameterInt("operatorStatus");
        int operatorType = request.getParameterInt("operatorType", 2);
        String operatorName = request.getParameter("operatorName");
        String operatorMobile = request.getParameter("operatorMobile");
        String operatorWangwang = request.getParameter("operatorWangwang");
        String operatorWxcode = request.getParameter("operatorWxcode");
        if (Validates.isNotEmpty((String)operatorMobile) && !(isMatch = Pattern.matches("^0?(13|14|15|16|17|18|19)[0-9]{9}$", operatorMobile))) {
            request.setResponseError("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7");
            return;
        }
        if (ZmrBootstrap.tableOpr(request).count(ZmrOperator.class, new Object[]{operatorCode}) > 0) {
            request.returnHistory("\u8be5\u64cd\u4f5c\u5458\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            return;
        }
        if (!Validates.isUserPass((String)operatorPass)) {
            request.returnHistory("\u8bf7\u8f93\u51656-16\u4f4d\u64cd\u4f5c\u5458\u5bc6\u7801\uff08\u5927\u5c0f\u5199\u5b57\u6bcd\u6570\u5b57\u548c\u7279\u6b8a\u5b57\u7b26\u5fc5\u987b\u56db\u9009\u4e09\uff09");
            return;
        }
        if (operatorPass.toLowerCase().contains("yangcai")) {
            request.returnHistory("\u5bc6\u7801\u4e2d\u4e0d\u5141\u8bb8\u5305\u542byangcai");
            return;
        }
        if (Validates.isEmpty((String)operatorWxcode)) {
            request.returnHistory("\u8bf7\u8f93\u5165\u4e2a\u4eba\u5fae\u4fe1\u8d26\u53f7");
            return;
        }
        String accessToken = WorkWechatPresenter.doGetWorkWechatAccessToken();
        String wkwechatAccount = WorkWechatPresenter.getUserIdByPhoneNumber(accessToken, operatorMobile);
        long operatorAvatar = 0L;
        PageResult result = ZmrBootstrap.table(request).page(ZmrAvatar.class, 1, 10, new Selector("avatarId", "avatarType", (Object)0));
        if (result.size() > 0) {
            int ind = new Random().nextInt(result.size());
            operatorAvatar = ((ZmrAvatar)result.list().get(ind)).getAvatarId();
        }
        ZmrPassworder passworder = ((ZmrBootstrap)request.getContextAttribute(ZmrBootstrap.class)).getPassworder();
        String operatorPassSalt = Randoms.lettersDigitsSecure((int)64);
        operatorPass = passworder.encode(operatorCode, operatorPass, operatorPassSalt);
        ZmrOperator operator = new ZmrOperator();
        operator.setOrgId(orgId);
        operator.setOperatorCode(operatorCode);
        operator.setOperatorPass(operatorPass);
        operator.setOperatorPassSalt(operatorPassSalt);
        operator.setOperatorStatus(operatorStatus);
        operator.setOperatorType(operatorType);
        operator.setOperatorName(operatorName);
        operator.setOperatorAvatar(operatorAvatar);
        operator.setOperatorMobile(operatorMobile);
        operator.setOperatorCreated(dateTime);
        operator.setOperatorModified(dateTime);
        operator.setOperatorWangwang(operatorWangwang);
        operator.setWkwechatAccount(wkwechatAccount);
        operator.setOperatorWxcode(operatorWxcode);
        operator.setInitialPassword(operatorPass);
        ZmrBootstrap.table(request).insert((Object)operator);
        request.setAttribute("operator", (Object)operator);
    }

    protected void modify(HttpRequest request) throws Exception {
        request.addValidate((Validate)new IsUserPass("operatorPass", "\u64cd\u4f5c\u5458\u5bc6\u7801\u4e0d\u5408\u6cd5\uff0c\u8981\u6c426-16\u4f4d\uff08\u5927\u5c0f\u5199\u5b57\u6bcd\u6570\u5b57\u548c\u7279\u6b8a\u5b57\u7b26\u5fc5\u987b\u56db\u9009\u4e09\uff09", true));
        String operatorCode = request.getParameter("operatorCode");
        ZmrOperator operator = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{operatorCode});
        if (operator == null) {
            request.returnHistory("\u8be5\u64cd\u4f5c\u5458\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            return;
        }
        request.setAttribute("operator", (Object)operator);
    }

    protected void update(HttpRequest request) throws Exception {
        boolean isMatch;
        String dateTime = DateTimes.getDateTimeString();
        String operatorCode = request.getParameter("operatorCode");
        String operatorName = request.getParameter("operatorName");
        String operatorPass = request.getParameter("operatorPass");
        String operatorMobile = request.getParameter("operatorMobile");
        int operatorStatus = request.getParameterInt("operatorStatus");
        int operatorType = request.getParameterInt("operatorType");
        String operatorWangwang = request.getParameter("operatorWangwang");
        String operatorWxcode = request.getParameter("operatorWxcode");
        Updater updater = new Updater();
        updater.addMaybe("operatorCode", (Object)operatorCode);
        updater.addField("operatorName", (Object)operatorName);
        if (Validates.isNotEmpty((String)operatorPass)) {
            if (!Validates.isUserPass((String)operatorPass)) {
                request.returnHistory("\u8bf7\u8f93\u51656-16\u4f4d\u64cd\u4f5c\u5458\u5bc6\u7801\uff08\u5927\u5c0f\u5199\u5b57\u6bcd\u6570\u5b57\u548c\u7279\u6b8a\u5b57\u7b26\u5fc5\u987b\u56db\u9009\u4e09\uff09");
                return;
            }
            if (operatorPass.toLowerCase().contains("yangcai")) {
                request.returnHistory("\u5bc6\u7801\u4e2d\u4e0d\u5141\u8bb8\u5305\u542byangcai");
                return;
            }
            ZmrPassworder passworder = ((ZmrBootstrap)request.getContextAttribute(ZmrBootstrap.class)).getPassworder();
            String operatorPassSalt = Randoms.lettersDigitsSecure((int)64);
            operatorPass = passworder.encode(operatorCode, operatorPass, operatorPassSalt);
            updater.addField("operatorPass", (Object)operatorPass);
            updater.addField("operatorPassSalt", (Object)operatorPassSalt);
        }
        if (Validates.isNotEmpty((String)operatorMobile) && !(isMatch = Pattern.matches("^0?(13|14|15|16|17|18|19)[0-9]{9}$", operatorMobile))) {
            request.returnHistory("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7");
            return;
        }
        if (Validates.isEmpty((String)operatorWxcode)) {
            request.returnHistory("\u8bf7\u8f93\u5165\u4e2a\u4eba\u5fae\u4fe1\u8d26\u53f7");
            return;
        }
        String accessToken = WorkWechatPresenter.doGetWorkWechatAccessToken();
        String wkwechatAccount = WorkWechatPresenter.getUserIdByPhoneNumber(accessToken, operatorMobile);
        if (operatorStatus == 1) {
            updater.addField("operatorRole", (Object)"");
        }
        updater.addField("operatorStatus", (Object)operatorStatus);
        updater.addField("operatorMobile", (Object)operatorMobile);
        updater.addField("operatorModified", (Object)dateTime);
        updater.addField("operatorType", (Object)operatorType);
        updater.addField("operatorWangwang", (Object)operatorWangwang);
        updater.addField("wkwechatAccount", (Object)wkwechatAccount);
        updater.addField("operatorWxcode", (Object)operatorWxcode);
        ZmrBootstrap.tableOpr(request).update(ZmrOperator.class, updater);
    }

    @AnTransaction
    protected void delete(HttpRequest request) throws Exception {
        String operatorCode = request.getParameter("operatorCode");
        ZmrOperator operator = (ZmrOperator)ZmrBootstrap.tableOpr(request).item(ZmrOperator.class, new Object[]{operatorCode});
        if (operator == null) {
            request.returnHistory("\u8be5\u64cd\u4f5c\u5458\u4e0d\u5b58\u5728");
            return;
        }
        Selector selector = new Selector("operatorCode", (Object)operatorCode);
        if (ZmrBootstrap.table(request).count(ZmrOperatorLog.class, selector) > 0) {
            request.returnHistory("\u8be5\u64cd\u4f5c\u5458\u5df2\u6709\u64cd\u4f5c\u65e5\u5fd7\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff0c\u53ea\u80fd\u505c\u7528");
            return;
        }
        ZmrAvatar avatar = (ZmrAvatar)ZmrBootstrap.table(request).item(ZmrAvatar.class, new Object[]{operator.getOperatorAvatar()});
        if (avatar != null && avatar.getAvatarType() == 1) {
            ZmrBootstrap.table(request).delete(ZmrAvatar.class, new Object[]{operator.getOperatorAvatar()});
        }
        ZmrBootstrap.tableOpr(request).delete(ZmrOperator.class, new Object[]{operatorCode});
        ZmrBootstrap.table(request).delete(ZmrOperatorRule.class, selector);
    }

    private void toDeptName(List<ZmrDept> deptList, ZmrOperator operator) {
        long[] deptIds;
        operator.setOperatorCreated("");
        long[] lArray = deptIds = Arrays.toLongArray((String)operator.getOperatorDept());
        int n = deptIds.length;
        int n2 = 0;
        while (n2 < n) {
            long deptId = lArray[n2];
            for (ZmrDept dept : deptList) {
                if (dept.getDeptId() != deptId) continue;
                if (Validates.isEmpty((String)operator.getOperatorCreated())) {
                    operator.setOperatorCreated(dept.getDeptName());
                    break;
                }
                operator.setOperatorCreated(String.valueOf(operator.getOperatorCreated()) + "," + dept.getDeptName());
                break;
            }
            ++n2;
        }
    }

    private void toRoleName(List<ZmrRole> roleList, ZmrOperator operator) {
        long[] roleIds;
        operator.setOperatorPass("");
        long[] lArray = roleIds = Arrays.toLongArray((String)operator.getOperatorRole());
        int n = roleIds.length;
        int n2 = 0;
        while (n2 < n) {
            long roleId = lArray[n2];
            for (ZmrRole role : roleList) {
                if (role.getRoleId() != roleId) continue;
                if (Validates.isEmpty((String)operator.getOperatorPass())) {
                    operator.setOperatorPass(role.getRoleName());
                    break;
                }
                operator.setOperatorPass(String.valueOf(operator.getOperatorPass()) + "," + role.getRoleName());
                break;
            }
            ++n2;
        }
    }
}

