/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.manager.action;

import java.util.List;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.extend.StdSwitchAction;
import org.zhiqim.httpd.validate.Validate;
import org.zhiqim.httpd.validate.ones.IsIntegerValue;
import org.zhiqim.httpd.validate.ones.IsLen;
import org.zhiqim.httpd.validate.ones.IsNotEmpty;
import org.zhiqim.httpd.validate.onex.IsInteger;
import org.zhiqim.kernel.tree.Tree;
import org.zhiqim.kernel.tree.TreeBuilder;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.manager.ZmrBootstrap;
import org.zhiqim.manager.ZmrSessionUser;
import org.zhiqim.manager.dao.ZmrOperatorDao;
import org.zhiqim.manager.dbo.ZmrMenu;
import org.zhiqim.orm.dbo.Selector;
import org.zhiqim.orm.dbo.Updater;

public class MenuAction
extends StdSwitchAction {
    protected void validateId(HttpRequest request) {
        request.addValidate((Validate)new IsNotEmpty("menuCode", "\u8bf7\u9009\u4e2d\u4e00\u4e2a\u83dc\u5355\u7f16\u7801"));
    }

    protected void validateForm(HttpRequest request) {
        request.addValidate((Validate)new IsNotEmpty("menuCode", "\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u683c\u5f0f\u4e3aMENU_\u5f00\u5934\u7684\u6bcf3\u4e2a\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u7ec4\u6210\u7684\u5b57\u7b26\u4e32"));
        request.addValidate((Validate)new IsNotEmpty("parentCode", "\u7236\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a"));
        request.addValidate((Validate)new IsLen("menuName", "\u83dc\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u4e0d\u80fd\u8d85\u8fc732\u4e2a\u6c49\u5b57", 1, 32));
        request.addValidate((Validate)new IsIntegerValue("menuStatus", "\u83dc\u5355\u72b6\u6001\u8303\u56f4\u4e3a[0, 1]\u4e4b\u95f4", 0, 1));
        request.addValidate((Validate)new IsIntegerValue("menuType", "\u83dc\u5355\u7c7b\u578b\u8303\u56f4\u4e3a[1, 2]\u4e4b\u95f4", 1, 2));
        request.addValidate((Validate)new IsInteger("menuLevel", "\u83dc\u5355\u7ea7\u522b\u5fc5\u987b\u662f\u6574\u6570"));
    }

    protected void list(HttpRequest request) throws Exception {
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        List<ZmrMenu> list = sessionUser.getMenuList();
        Tree tree = TreeBuilder.newTree(list, (String)"parentCode", (String)"menuCode");
        request.setAttribute("menuSize", (Object)list.size());
        request.setAttribute("tree", (Object)tree);
    }

    protected void add(HttpRequest request) throws Exception {
        String menuCode = request.getParameter("menuCode");
        ZmrMenu item = (ZmrMenu)ZmrBootstrap.table(request).item(ZmrMenu.class, new Object[]{menuCode});
        if (item == null) {
            request.returnHistory("\u60a8\u9009\u62e9\u7684\u83dc\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u4e00\u4e2a\u6709\u6548\u7684\u83dc\u5355");
            return;
        }
        request.setAttribute("parent", (Object)item);
    }

    protected void insert(HttpRequest request) throws Exception {
        String parentCode;
        String menuCode = request.getParameter("menuCode");
        if (!menuCode.startsWith(String.valueOf(parentCode = request.getParameter("parentCode")) + "_")) {
            request.returnHistory("\u8be5\u83dc\u5355\u7f16\u53f7\u683c\u5f0f\u4e0d\u5bf9\uff0c\u6ca1\u6709\u4ece\u7236\u83dc\u5355\u7f16\u7801\u4e2d\u7ee7\u627f");
            return;
        }
        String code = menuCode.substring(parentCode.length() + 1);
        if (!Validates.isNumericLen((String)code, (int)3, (int)3)) {
            request.returnHistory("\u8be5\u83dc\u5355\u7f16\u53f7\u683c\u5f0f\u4e0d\u5bf9\uff0c\u5c0f\u7f16\u7801\u4e3a3\u4f4d\u6570\u5b57\u7ec4\u6210");
            return;
        }
        if (ZmrBootstrap.table(request).count(ZmrMenu.class, new Object[]{menuCode}) > 0) {
            request.returnHistory("\u8be5\u83dc\u5355\u7f16\u53f7\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u9009\u4e00\u4e2a");
            return;
        }
        ZmrMenu menu = (ZmrMenu)request.getParameter(ZmrMenu.class);
        ZmrBootstrap.table(request).insert((Object)menu);
        ZmrSessionUser sessionUser = (ZmrSessionUser)request.getSessionUser(ZmrSessionUser.class);
        List<ZmrMenu> menuList = ZmrOperatorDao.getOperatorMenuList(request, sessionUser.getOperator());
        sessionUser.setMenuList(request.getContext(), menuList);
    }

    protected void modify(HttpRequest request) throws Exception {
        String menuCode = request.getParameter("menuCode");
        ZmrMenu item = (ZmrMenu)ZmrBootstrap.table(request).item(ZmrMenu.class, new Object[]{menuCode});
        if (item == null) {
            request.returnHistory("\u60a8\u9009\u62e9\u7684\u83dc\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u4e00\u4e2a\u6709\u6548\u7684\u83dc\u5355");
            return;
        }
        if (item.getMenuLevel() == 0) {
            request.returnHistory("\u7cfb\u7edf\u529f\u80fd\u6839\u83dc\u5355\u4e0d\u652f\u6301\u4fee\u6539");
            return;
        }
        request.setAttribute("item", (Object)item);
    }

    protected void update(HttpRequest request) throws Exception {
        String menuCode = request.getParameter("menuCode");
        if (ZmrBootstrap.table(request).count(ZmrMenu.class, new Object[]{menuCode}) == 0) {
            request.returnHistory("\u4f60\u4fee\u6539\u7684\u83dc\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u6709\u6548\u7684\u83dc\u5355\u8fdb\u884c\u4fee\u6539");
            return;
        }
        String menuName = request.getParameter("menuName");
        int menuStatus = request.getParameterInt("menuStatus");
        String menuNameAbbr = request.getParameter("menuNameAbbr");
        int menuType = request.getParameterInt("menuType");
        String menuIcon = request.getParameter("menuIcon");
        String menuUrl = request.getParameter("menuUrl");
        String menuDesc = request.getParameter("menuDesc");
        Updater updater = new Updater();
        updater.addMust("menuCode", (Object)menuCode);
        updater.addField("menuName", (Object)menuName);
        updater.addField("menuNameAbbr", (Object)menuNameAbbr);
        updater.addField("menuStatus", (Object)menuStatus);
        updater.addField("menuType", (Object)menuType);
        updater.addField("menuIcon", (Object)menuIcon);
        updater.addField("menuUrl", (Object)menuUrl);
        updater.addField("menuDesc", (Object)menuDesc);
        ZmrBootstrap.table(request).update(ZmrMenu.class, updater);
        ZmrOperatorDao.refresh(request);
    }

    protected void delete(HttpRequest request) throws Exception {
        String menuCode = request.getParameter("menuCode");
        if (ZmrBootstrap.table(request).count(ZmrMenu.class, new Object[]{menuCode}) == 0) {
            request.returnHistory("\u4f60\u4fee\u6539\u7684\u83dc\u5355\u4e0d\u5b58\u5728\uff0c\u8bf7\u9009\u62e9\u6709\u6548\u7684\u83dc\u5355\u8fdb\u884c\u4fee\u6539");
            return;
        }
        if (ZmrBootstrap.table(request).count(ZmrMenu.class, new Selector("parentCode", (Object)menuCode)) > 0) {
            request.returnHistory("\u4f60\u4fee\u6539\u7684\u83dc\u5355\u6709\u5b50\u83dc\u5355\uff0c\u8bf7\u5148\u5220\u9664\u5b50\u83dc\u5355");
            return;
        }
        ZmrBootstrap.table(request).delete(ZmrMenu.class, new Object[]{menuCode});
        ZmrOperatorDao.refresh(request);
    }
}

