/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.util;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.constants.RegexpConstants;
import org.zhiqim.kernel.constants.SignConstants;

@AnAlias(value={"Scriptx"})
public class Scriptx
implements RegexpConstants,
SignConstants {
    public static String isRegexp(String function, String regexp, boolean allowEmpty) {
        if (!regexp.startsWith("/")) {
            regexp = "/" + regexp;
        }
        if (!regexp.endsWith("/")) {
            regexp = String.valueOf(regexp) + "/";
        }
        StringBuilder strb = new StringBuilder().append("function ").append(function).append("(value)").append("\r\n").append("{").append("\r\n").append("    ").append("if (value === undefined || value == '' || value.length < 1)").append("\r\n");
        if (allowEmpty) {
            strb.append("    ").append("    ").append("return true;").append("\r\n");
        } else {
            strb.append("    ").append("    ").append("return false;").append("\r\n");
        }
        strb.append("\r\n").append("    ").append("var reg = ").append(regexp).append(";").append("\r\n").append("    ").append("return reg.test(value);").append("\r\n").append("}").append("\r\n").append("\r\n");
        return strb.toString();
    }

    public static String isRegexp(String regexp, boolean allowEmpty) {
        return Scriptx.isRegexp("isRegexp", regexp, allowEmpty);
    }

    public static String isNumeric(boolean allowEmpty) {
        return Scriptx.isRegexp("isNumeric", "^\\d+$", allowEmpty);
    }

    public static String isInteger(boolean allowEmpty) {
        return Scriptx.isRegexp("isInteger", "^(0|[\\+\\-]?[1-9]\\d*)$", allowEmpty);
    }

    public static String isAlphaNumeric(boolean allowEmpty) {
        return Scriptx.isRegexp("isAlphaNumeric", "^[A-Za-z0-9]+$", allowEmpty);
    }

    public static String isAlphaNumericLenPA(boolean allowEmpty, int min, int max) {
        if (min < 1) {
            min = 1;
        }
        if (max < min) {
            max = min;
        }
        String regexp = "^[A-Za-z][A-Za-z0-9]{n,m}$".replaceFirst("n", "" + (min - 1)).replaceFirst("m", "" + (max - 1));
        return Scriptx.isRegexp("isAlphaNumericPALen", regexp, allowEmpty);
    }

    public static String isFloat(boolean allowEmpty) {
        return Scriptx.isRegexp("isFloat", "^(0|[\\+\\-]?[1-9]\\d*)(\\.\\d+)?$", allowEmpty);
    }

    public static String isAmount2R(boolean allowEmpty) {
        return Scriptx.isRegexp("isAmount2R", "^(0|[\\+\\-]?[1-9]\\d*)(\\.\\d{1,2})?$", allowEmpty);
    }

    public static String isEmail(boolean allowEmpty) {
        return Scriptx.isRegexp("isEmail", "^([\\w-_]+(?:\\.[\\w-_]+)*)@((?:[a-z0-9]+(?:-[a-zA-Z0-9]+)*)+\\.[a-z]{2,6})$", allowEmpty);
    }

    public static String isIP(boolean allowEmpty) {
        return Scriptx.isRegexp("isIP", "^((?:[01]?\\d{1,2}|2[0-4]\\d|25[0-5])\\.){3}(?:[01]?\\d{1,2}|2[0-4]\\d|25[0-5])$", allowEmpty);
    }

    public static String isMacAddress(boolean allowEmpty) {
        return Scriptx.isRegexp("isMacAddress", "^[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}:[0-9A-Fa-f]{2}$", allowEmpty);
    }

    public static String isMobile(boolean allowEmpty) {
        return Scriptx.isRegexp("isMsisdn", "^((\\+86)|(86)|)?(13[0-9]|14[5|7|9]|15[0|1|2|3|5|6|7|8|9]|17[0|1|3|5|6|7|8]|18[0-9])\\d{8}$", allowEmpty);
    }

    public static String isMobile11(boolean allowEmpty) {
        return Scriptx.isRegexp("isMsisdn11", "^(13[0-9]|14[5|7|9]|15[0|1|2|3|5|6|7|8|9]|17[0|1|3|5|6|7|8]|18[0-9])\\d{8}$", allowEmpty);
    }

    public static String isDate(boolean allowEmpty) {
        return Scriptx.isRegexp("isDate", "^(([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29)$", allowEmpty);
    }

    public static String isTime(boolean allowEmpty) {
        return Scriptx.isRegexp("isTime", "^([0-1][0-9]|[2][0-3]):([0-5][0-9]):([0-5][0-9])$", allowEmpty);
    }

    public static String isDateTime(boolean allowEmpty) {
        return Scriptx.isRegexp("isDateTime", "^((([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29))\\s(([0-1][0-9]|[2][0-3]):([0-5][0-9]):([0-5][0-9]))$", allowEmpty);
    }

    public static String isIdcard(boolean allowEmpty) {
        return Scriptx.isRegexp("isDateTime", "^((([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29))\\s(([0-1][0-9]|[2][0-3]):([0-5][0-9]):([0-5][0-9]))$", allowEmpty);
    }

    public static String isPostalCode(boolean allowEmpty) {
        return Scriptx.isRegexp("isPostalCode", "^[1-9]\\d{5}$", allowEmpty);
    }

    public static String isUserCode(boolean allowEmpty) {
        return Scriptx.isRegexp("isUserCode", "^[a-zA-Z0-9\\u4e00-\\u9fa5][._\\-`~!@#$%a-zA-Z0-9\\u4e00-\\u9fa5]{1,15}$", allowEmpty);
    }

    public static String isUserPass(boolean allowEmpty) {
        return Scriptx.isRegexp("isUserPass", "^(?:(?=.*[A-Z])(?=.*[a-z])(?=.*[0-9])|(?=.*[A-Z])(?=.*[a-z])(?=.*[._\\-`~!@#$%])|(?=.*[A-Z])(?=.*[0-9])(?=.*[._\\-`~!@#$%])|(?=.*[a-z])(?=.*[0-9])(?=.*[._\\-`~!@#$%])).{6,16}$", allowEmpty);
    }
}

