/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import org.zhiqim.httpd.HttpListener;
import org.zhiqim.httpd.HttpServer;
import org.zhiqim.httpd.nio.HttpNioConnection;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Threads;
import org.zhiqim.kernel.util.Validates;

public class HttpNioListener
extends HttpListener {
    protected ServerSocketChannel serverSocket;
    protected Selector selector;

    public HttpNioListener(HttpServer server) {
        super(server);
    }

    protected void openBeforeInner() {
    }

    protected HttpNioConnection newConnection(SocketChannel socket) throws IOException {
        InetAddress remoteAddress = ((InetSocketAddress)socket.getRemoteAddress()).getAddress();
        return new HttpNioConnection(this, socket, remoteAddress);
    }

    @Override
    protected boolean openBefore() {
        this.openBeforeInner();
        super.openBefore();
        try {
            this.selector = Selector.open();
            this.serverSocket = ServerSocketChannel.open();
            this.serverSocket.bind(Validates.isEmpty((String)this.listenerIp) ? new InetSocketAddress(this.listenerPort) : new InetSocketAddress(InetAddress.getByName(this.listenerIp), this.listenerPort));
            this.serverSocket.configureBlocking(false);
            this.serverSocket.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            this.serverSocket.register(this.selector, 16);
            return true;
        }
        catch (Exception e) {
            throw Asserts.exception((Exception)e);
        }
    }

    @Override
    protected void closeAfter() {
        if (this.serverSocket != null) {
            Threads.closeIgnoreException((AutoCloseable)this.serverSocket);
            this.serverSocket = null;
        }
        if (this.selector != null) {
            Threads.closeIgnoreException((AutoCloseable)this.selector);
            this.selector = null;
        }
        super.closeAfter();
    }

    protected void loop() {
        try {
            int keyNum = this.selector.select(this.soTimeoutMs);
            if (keyNum == 0) {
                return;
            }
            Set<SelectionKey> keys = this.selector.selectedKeys();
            Iterator<SelectionKey> it = keys.iterator();
            while (it.hasNext()) {
                SelectionKey key = it.next();
                it.remove();
                try {
                    if (!key.isValid() || key.interestOps() == 0) continue;
                    if (key.isAcceptable()) {
                        this.onAccept(key);
                        continue;
                    }
                    if (!key.isReadable()) continue;
                    this.onRead(key);
                }
                catch (CancelledKeyException cancelledKeyException) {
                }
                catch (Throwable throwable) {
                    key.cancel();
                }
            }
        }
        catch (IOException iOException) {
            this.close();
        }
    }

    protected void onAccept(SelectionKey key) {
        block3: {
            ServerSocketChannel server = (ServerSocketChannel)key.channel();
            HttpNioConnection conn = null;
            SocketChannel socket = null;
            try {
                socket = server.accept();
                socket.configureBlocking(false);
                socket.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
                socket.setOption((SocketOption)StandardSocketOptions.SO_LINGER, (Object)this.soLingerS);
                socket.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
                socket.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)this.soRecvBuf);
                socket.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)this.soSendBuf);
                conn = this.newConnection(socket);
                socket.register(this.selector, 1, this.add(conn));
            }
            catch (Throwable throwable) {
                if (conn != null) {
                    conn.close();
                }
                if (socket == null) break block3;
                Threads.closeIgnoreException((AutoCloseable)socket);
            }
        }
    }

    private void onRead(SelectionKey key) {
        HttpNioConnection conn = (HttpNioConnection)key.attachment();
        if (conn.isClosed()) {
            key.cancel();
            return;
        }
        if (!conn.tryLock()) {
            return;
        }
        this.controller.execute((Runnable)conn);
    }
}

