/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.context.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpExecutor;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.httpd.util.Responses;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Ids;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Urls;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.codes.Base64;

public class UploadService
implements HttpExecutor,
ZmlContextConstants {
    private static final Log log = LogFactory.getLog(UploadService.class);
    private static final String[] FILE_DIR_NOT_FORMAT = new String[]{".", "\\", "?", ":", "*", "'", "\"", "<", ">", "|"};
    private String uploadRootDir;

    @Override
    public boolean isMatch(String pathInContext) {
        return "/service/upload".equals(pathInContext);
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response) throws IOException {
        String sessionName = Strings.toString((Object)request.getSessionName(), (String)"guest");
        int mode = request.getHeaderInt("X-Responsed-Mode", 0);
        String fileDir = request.getHeader("X-Upload-File-Dir");
        String fileName = request.getHeader("X-Upload-File-Name");
        int contentLength = request.getContentLength();
        fileDir = Urls.decodeUTF8((String)fileDir);
        fileDir = Strings.removeStartsWith((String)fileDir, (String)"/");
        fileDir = Strings.removeEndsWith((String)fileDir, (String)"/");
        fileName = Urls.decodeUTF8((String)fileName);
        if (mode < 0 || mode > 1 || Validates.isStrContainStrArr((String)fileDir, (String[])FILE_DIR_NOT_FORMAT) || Validates.isEmptyBlank((String)fileName) || contentLength <= 0) {
            log.error((Object)"[Upload][%s][\u53c2\u6570\u4e0d\u6b63\u786e]", new Object[]{sessionName});
            response.sendError(412);
            return;
        }
        HttpContext context = request.getContext();
        String forward = (String)context.getAttribute("upload.foward");
        if (Validates.isNotEmpty((String)forward)) {
            try {
                request.forwardTo(forward);
            }
            catch (Exception exception) {
                try {
                    response.sendHeader(500);
                }
                catch (Exception exception2) {}
            }
            return;
        }
        if (this.uploadRootDir == null) {
            String rootDir = (String)context.getAttribute("upload.rootDir");
            if (Validates.isEmptyBlank((String)rootDir) || !Files.mkDirectory((String)rootDir)) {
                log.error((Object)"[Upload][%s][\u914d\u7f6e\u5904\u7406\u5668\u5904\u7406\u65f6\u5fc5\u987b\u914d\u7f6e\u4e0a\u4f20\u6839\u76ee\u5f55][%s]", new Object[]{sessionName, "upload.rootDir"});
                response.sendError(403);
                return;
            }
            this.uploadRootDir = Files.toLinuxPath((String)new File(rootDir).getCanonicalPath());
            this.uploadRootDir = Strings.addEndsWith((String)this.uploadRootDir, (String)"/");
        }
        String fileDirPath = null;
        if (Validates.isEmptyBlank((String)fileDir)) {
            fileDirPath = this.uploadRootDir;
        } else {
            fileDirPath = String.valueOf(this.uploadRootDir) + fileDir + "/";
            if (!Files.mkDirectory((String)fileDirPath)) {
                log.error((Object)"[Upload][%s][\u4e0a\u4f20\u7684\u6587\u4ef6\u76ee\u5f55\u65e0\u6cd5\u521b\u5efa][%s]", new Object[]{sessionName, request.getHeader("X-Upload-File-Dir")});
                response.sendError(403);
                return;
            }
        }
        String fileExt = Files.getFileExt((String)fileName);
        fileName = String.valueOf(Ids.uuid()) + Files.fixFileExt((String)fileExt);
        String filePath = String.valueOf(fileDirPath) + fileName;
        String fileUrl = null;
        if (Validates.isEmptyBlank((String)fileDir)) {
            fileUrl = "/service/upl/" + fileName;
        } else {
            String fileDirUrl = Base64.encodeFileUrlUTF8((String)fileDir);
            fileUrl = "/service/upl/" + fileDirUrl + "/" + fileName;
        }
        byte[] data = Streams.getBytes((InputStream)request.getInputStream(), (int)contentLength);
        Files.writeReturnSize((String)filePath, (byte[])data);
        log.info((Object)"[Upload][%s][\u4e0a\u4f20\u5b8c\u6210][%s]", new Object[]{sessionName, fileName});
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("X-Upload-File-Url", fileUrl);
        Responses.doReturnMessage(response, mode, headerMap);
    }
}

