/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.context.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpExecutor;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.constants.HttpMimeType;
import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.codes.Base64;

public class UploadAccessService
implements HttpExecutor,
ZmlContextConstants {
    private static final Log log = LogFactory.getLog(UploadAccessService.class);
    private String uploadRootDir;

    @Override
    public boolean isMatch(String pathInContext) {
        return Validates.isMatch((String)pathInContext, (String)"/service/upl/*");
    }

    @Override
    public void handle(HttpRequest request, HttpResponse response) throws IOException {
        File file;
        HttpContext context = request.getContext();
        String forward = (String)context.getAttribute("upload.foward");
        if (Validates.isNotEmpty((String)forward)) {
            try {
                request.forwardTo(forward);
            }
            catch (Exception exception) {
                response.sendHeader(500);
            }
            return;
        }
        if (this.uploadRootDir == null) {
            String rootDir = (String)context.getAttribute("upload.rootDir");
            if (Validates.isEmptyBlank((String)rootDir) || !Files.mkDirectory((String)rootDir)) {
                log.error((Object)"[UploadAccessService][\u914d\u7f6e\u5904\u7406\u5668\u5904\u7406\u65f6\u5fc5\u987b\u914d\u7f6e\u4e0a\u4f20\u6839\u76ee\u5f55][%s]", new Object[]{"upload.rootDir"});
                response.sendError(403);
                return;
            }
            this.uploadRootDir = Files.toLinuxPath((String)new File(rootDir).getCanonicalPath());
            this.uploadRootDir = Strings.addEndsWith((String)this.uploadRootDir, (String)"/");
        }
        String filePath = Strings.removeStartsWith((String)request.getPathInContext(), (String)"/service/upl/");
        String fileDir = Files.getFileDirPath((String)filePath, (String)"/");
        String fileName = Files.getFileNameLinux((String)filePath);
        if (Validates.isNotEmpty((String)fileDir)) {
            fileDir = Base64.decodeFileUrlUTF8((String)fileDir);
        }
        if (!(file = new File(filePath = Validates.isEmpty((String)fileDir) ? String.valueOf(this.uploadRootDir) + fileName : String.valueOf(this.uploadRootDir) + fileDir + "/" + fileName)).exists() || !file.isFile()) {
            response.sendError(404);
            return;
        }
        if (file.isHidden() || !file.canRead()) {
            response.sendError(403);
            return;
        }
        String fileExt = Files.getFileExt((String)fileName);
        response.setContentType(HttpMimeType.getResourceMimeType(fileExt));
        long lastModified = file.lastModified();
        String lastModifiedTime = DateTimes.getDateTimeHttp((long)lastModified);
        String ifModifiedSince = request.getHeader("If-Modified-Since");
        if (ifModifiedSince != null && ifModifiedSince.indexOf(lastModifiedTime) != -1) {
            response.sendHeader(304);
            return;
        }
        response.setHeader("Accept-Ranges", "bytes");
        response.setHeader("Last-Modified", lastModifiedTime);
        if (request.isMethodResponseContent()) {
            Throwable throwable = null;
            Object var15_15 = null;
            try (FileInputStream fis = new FileInputStream(file);){
                Streams.putBytes((InputStream)fis, (OutputStream)response.getOutputStream());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        response.commit();
    }
}

