/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.context;

import java.util.Map;
import org.zhiqim.httpd.HttpResource;
import org.zhiqim.httpd.HttpWebsocket;
import org.zhiqim.httpd.context.ZmlBootstrap;
import org.zhiqim.httpd.context.ZmlContext;
import org.zhiqim.httpd.context.ZmlContextConstants;
import org.zhiqim.httpd.context.config.ZAction;
import org.zhiqim.httpd.context.config.ZActionPackage;
import org.zhiqim.httpd.context.config.ZAttribute;
import org.zhiqim.httpd.context.config.ZComponent;
import org.zhiqim.httpd.context.config.ZComponentWapper;
import org.zhiqim.httpd.context.config.ZConfig;
import org.zhiqim.httpd.context.config.ZInterceptor;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.httpd.context.core.Context;
import org.zhiqim.httpd.context.core.Interceptor;
import org.zhiqim.httpd.context.extend.EmptyAction;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.HashMapSV;
import org.zhiqim.kernel.extend.LinkedMapSV;
import org.zhiqim.kernel.extend.MapS;
import org.zhiqim.kernel.extend.MapSO;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Classes;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.zml.Expression;
import org.zhiqim.zml.Zml;
import org.zhiqim.zml.ZmlEngine;
import org.zhiqim.zml.ZmlVarNotice;
import org.zhiqim.zml.ZmlVariable;
import org.zhiqim.zml.exception.ExpressionException;
import org.zhiqim.zml.statement._Var;

public class ZmlConfig
implements ZmlContextConstants,
ZmlVarNotice,
MapS {
    private static final Log log = LogFactory.getLog(ZmlConfig.class);
    private static final EmptyAction empty = new EmptyAction();
    private final Context context;
    private final boolean pathExactPrior;
    private final ZConfig rootConfig;
    private final ZActionPackage actionPackage;
    private LinkedMapSV<ZComponentWapper> componentMap = new LinkedMapSV();
    private HashMapSV<HashMapSO> variableMap = new HashMapSV();
    private HashMapSO attributeMap = new HashMapSO();
    private HashMapSV<Interceptor> interceptorMap = new HashMapSV();
    private HashMapSV<Action> actionMap = new HashMapSV();
    private HttpWebsocket websocket;
    private ZmlBootstrap bootstrap;

    public ZmlConfig(Context context, HttpResource resource, boolean pathExactPrior) {
        this.context = context;
        this.pathExactPrior = pathExactPrior;
        this.rootConfig = !resource.isValid() ? null : new ZConfig(this, true, resource.getResourceType(), resource.getResourcePath(), "config", "/conf/config.xml");
        this.actionPackage = this.rootConfig == null ? null : this.rootConfig.getActionPackage(this);
    }

    public Context getContext() {
        return this.context;
    }

    public ZConfig getRootConfig() {
        return this.rootConfig;
    }

    public String getActionPackage() {
        return this.actionPackage == null ? null : this.actionPackage.getActionPackage();
    }

    public ZComponentWapper getComponent(String path) {
        return (ZComponentWapper)this.componentMap.get(path);
    }

    public boolean create() throws Exception {
        if (this.rootConfig != null) {
            this.rootConfig.load();
        }
        if (this.actionPackage != null) {
            this.actionPackage.load();
        }
        if (this.rootConfig == null) {
            return true;
        }
        for (ZComponent c : this.rootConfig.getComponentList()) {
            ZComponentWapper component = new ZComponentWapper(this, c);
            this.componentMap.put(c.getPath(), (Object)component);
            component.load();
        }
        int resourceIndex = 0;
        ZmlEngine engine = this.context.getZmlEngine();
        for (ZComponentWapper component : this.componentMap.values()) {
            ZConfig rc;
            ZmlBootstrap bootstrap = component.getBootstrap();
            if (bootstrap != null && !bootstrap.isBefore()) {
                bootstrap.initBefore();
                bootstrap.setBefored();
            }
            if ((rc = component.getConfig()) != null) {
                for (ZConfig c : rc.getConfigList()) {
                    if (this.initConfig(c)) continue;
                    return false;
                }
                if (!this.initConfig(rc)) {
                    return false;
                }
            }
            this.context.addComponentResource(resourceIndex++, "classpath", component.getPath());
            if (engine != null) {
                engine.addComponentZmlLoader(ZmlContext.class, component.getPath());
                engine.addConfigZml("/conf/config.zml", component.getPath());
            }
            if (bootstrap == null || bootstrap.isAfter()) continue;
            bootstrap.initAfter();
            bootstrap.setAftered();
        }
        for (ZConfig c : this.rootConfig.getConfigList()) {
            if (this.initConfig(c)) continue;
            return false;
        }
        if (!this.initConfig(this.rootConfig)) {
            return false;
        }
        ZmlBootstrap bootstrap = this.getBootstrap();
        if (!bootstrap.isBefore()) {
            bootstrap.initBefore();
            bootstrap.setBefored();
        }
        if (engine != null) {
            engine.addConfigZml("/conf/config.zml");
        }
        if (!bootstrap.isAfter()) {
            bootstrap.initAfter();
            bootstrap.setAftered();
        }
        return true;
    }

    public void destroy() {
        if (this.bootstrap != null) {
            this.bootstrap.close();
        }
        for (ZComponentWapper component : this.componentMap.values()) {
            ZmlBootstrap bootstrap = component.getBootstrap();
            if (bootstrap == null) continue;
            bootstrap.close();
        }
        this.componentMap.clear();
    }

    public boolean has(String key) {
        if (this.context.hasTopAttribute(key)) {
            return true;
        }
        if (this.context.getZmlEngine() != null) {
            this.context.getZmlEngine().chkCurConfigModified();
        }
        for (HashMapSO vMap : this.variableMap.values()) {
            if (!vMap.containsKey(key)) continue;
            return true;
        }
        return this.attributeMap.containsKey(key);
    }

    public Object get(String key) {
        if (this.context.hasTopAttribute(key)) {
            return this.context.getTopAttribute(key);
        }
        if (this.context.getZmlEngine() != null) {
            this.context.getZmlEngine().chkCurConfigModified();
        }
        for (HashMapSO vMap : this.variableMap.values()) {
            Object value = vMap.get(key);
            if (value == null) continue;
            return value;
        }
        return this.attributeMap.get(key);
    }

    public HttpWebsocket getWebsocket(String protocol) {
        String wss;
        if (Validates.isEmptyBlank((String)protocol)) {
            return null;
        }
        String cls = Global.getClassName((String)protocol);
        if (cls.equals(wss = this.rootConfig.getWebsocketClass())) {
            if (this.websocket != null) {
                return this.websocket;
            }
            Object instance = Classes.newInstance((String)cls);
            Asserts.as(instance instanceof HttpWebsocket ? null : "\u7ec4\u4ef6[" + this.context.getContextName() + "]\u914d\u7f6e\u7684[websocket]\u4e0d\u662fHttpWebsocket\u5b9e\u73b0\u7c7b");
            this.websocket = (HttpWebsocket)instance;
            return this.websocket;
        }
        int i = this.componentMap.size() - 1;
        while (i >= 0) {
            ZComponentWapper component = (ZComponentWapper)this.componentMap.get(i);
            HttpWebsocket websocket = component.getWebsocket();
            if (websocket != null && cls.equals(websocket.getClass().getName())) {
                return websocket;
            }
            --i;
        }
        return null;
    }

    public ZmlBootstrap getBootstrap() {
        if (this.bootstrap != null) {
            return this.bootstrap;
        }
        String bootstrapClass = this.rootConfig.getBootstrapClass();
        if (Validates.isNotEmptyBlank((String)bootstrapClass)) {
            Object instance = Classes.newInstance((String)bootstrapClass);
            Asserts.as(instance instanceof ZmlBootstrap ? null : "\u7ec4\u4ef6[" + this.context.getContextName() + "]\u914d\u7f6e\u7684[bootstrap]\u6216\u4e0d\u662fZmlBootstrap\u6216\u5176\u5b50\u7c7b");
            this.bootstrap = (ZmlBootstrap)instance;
            this.bootstrap.setContext(this.context);
            return this.bootstrap;
        }
        int i = this.componentMap.size() - 1;
        while (i >= 0) {
            ZComponentWapper component = (ZComponentWapper)this.componentMap.get(i);
            this.bootstrap = component.getBootstrap();
            if (this.bootstrap != null) {
                return this.bootstrap;
            }
            --i;
        }
        this.bootstrap = new ZmlBootstrap();
        this.bootstrap.setContext(this.context);
        return this.bootstrap;
    }

    public void doUpdateVariable(Zml zml, String configPath, String componentPath, LinkedMapSV<_Var> varMap) {
        HashMapSO vMap = null;
        if (Validates.isNotEmpty((String)componentPath)) {
            vMap = this.attributeMap;
        } else {
            vMap = (HashMapSO)this.variableMap.get(configPath);
            if (vMap == null) {
                vMap = new HashMapSO();
                this.variableMap.put(configPath, (Object)vMap);
            } else {
                vMap.clear();
            }
        }
        HashMapSO localMap = new HashMapSO();
        localMap.put("context", (Object)this.context);
        ZmlEngine engine = zml.getEngine();
        ZmlVariable variable = new ZmlVariable();
        variable.setZml(zml);
        variable.setVariableMap((MapSO)vMap);
        variable.setContextMap(new MapS[]{this});
        variable.addLocalVariable((MapSO)localMap);
        for (Map.Entry entry : varMap.entrySet()) {
            String name = (String)entry.getKey();
            Expression expression = ((_Var)entry.getValue()).getExpression();
            try {
                int val;
                Object value = expression.build(variable);
                vMap.put(name, value);
                if (engine == null) continue;
                if ("zml.maxKeepTime".equals(name) && !this.context.hasTopAttribute(name)) {
                    val = Ints.toInt((Object)value, (int)86400);
                    engine.setMaxKeepTime(val);
                    continue;
                }
                if (!"zml.maxIdleTime".equals(name) || this.context.hasTopAttribute(name)) continue;
                val = Ints.toInt((Object)value, (int)3600);
                engine.setMaxIdleTime(val);
            }
            catch (ExpressionException expressionException) {}
        }
    }

    public ZAction getAction(String path) {
        if (path == null) {
            return null;
        }
        return this.pathExactPrior ? this.getExactPriorAction(path) : this.getInTurnAction(path);
    }

    private ZAction getInTurnAction(String path) {
        ZAction action;
        if (this.rootConfig != null && (action = this.rootConfig.getInTurnAction(path)) != null) {
            return action;
        }
        if (this.actionPackage != null && (action = this.actionPackage.getInTurnAction(path)) != null) {
            return action;
        }
        int i = this.componentMap.size() - 1;
        while (i >= 0) {
            ZComponentWapper component = (ZComponentWapper)this.componentMap.get(i);
            ZAction action2 = component.getActionInTurn(path);
            if (action2 != null) {
                return action2;
            }
            --i;
        }
        return null;
    }

    private ZAction getExactPriorAction(String path) {
        ZAction action;
        ZComponentWapper component;
        ZAction action2;
        if (this.rootConfig != null && (action2 = this.rootConfig.getExactAction(path)) != null) {
            return action2;
        }
        if (this.actionPackage != null && (action2 = this.actionPackage.getExactAction(path)) != null) {
            return action2;
        }
        int i = this.componentMap.size() - 1;
        while (i >= 0) {
            component = (ZComponentWapper)this.componentMap.get(i);
            action = component.getExactAction(path);
            if (action != null) {
                return action;
            }
            --i;
        }
        if (this.rootConfig != null && (action = this.rootConfig.getFuzzyAction(path)) != null) {
            return action;
        }
        if (this.actionPackage != null && (action = this.actionPackage.getFuzzyAction(path)) != null) {
            return action;
        }
        i = this.componentMap.size() - 1;
        while (i >= 0) {
            component = (ZComponentWapper)this.componentMap.get(i);
            action = component.getFuzzyAction(path);
            if (action != null) {
                return action;
            }
            --i;
        }
        return null;
    }

    public void setActionOnPath(String path, Action action) {
        this.actionMap.put(path, (Object)action);
    }

    public Action getAction(ZAction zAction) {
        Action action = (Action)this.actionMap.get(zAction.getPath());
        if (action != null) {
            return action;
        }
        String className = zAction.getClassName();
        action = this.getActionByRuntimeClass(className);
        if (action != null) {
            return action;
        }
        Object obj = Classes.newInstance((String)className);
        Asserts.as((String)(obj != null && obj instanceof Action ? null : "Action[%s]\u66ff\u6362\u901a\u914d\u7b26\u540e\u7684\u7c7b[%s]\u4e0d\u5b58\u5728\u6216\u4e0d\u662fAction\u7c7b"), (Object[])new Object[]{zAction.getPath(), className});
        action = (Action)obj;
        this.setActionOnRuntimeClass(className, action);
        return action;
    }

    public Action getActionInstance(String clazz) {
        if (clazz == null) {
            return null;
        }
        Action action = this.getActionByRuntimeClass(clazz = Global.getClassName((String)clazz));
        if (action != null) {
            return action;
        }
        return this.pathExactPrior ? this.getExactPriorActionByClass(clazz) : this.getInTurnActionByClass(clazz);
    }

    private Action getInTurnActionByClass(String clazz) {
        ZAction action;
        if (this.rootConfig != null && (action = this.rootConfig.getInTurnActionByClass(clazz)) != null) {
            return this.getAction(action);
        }
        if (this.actionPackage != null && (action = this.actionPackage.getInTurnActionByClass(clazz)) != null) {
            return this.getAction(action);
        }
        int i = this.componentMap.size() - 1;
        while (i >= 0) {
            ZComponentWapper component = (ZComponentWapper)this.componentMap.get(i);
            ZAction action2 = component.getInTurnActionByClass(clazz);
            if (action2 != null) {
                return this.getAction(action2);
            }
            --i;
        }
        return null;
    }

    private Action getExactPriorActionByClass(String clazz) {
        ZAction action;
        ZComponentWapper component;
        ZAction action2;
        if (this.rootConfig != null && (action2 = this.rootConfig.getExactActionByClass(clazz)) != null) {
            return this.getAction(action2);
        }
        if (this.actionPackage != null && (action2 = this.actionPackage.getExactActionByClass(clazz)) != null) {
            return this.getAction(action2);
        }
        int i = this.componentMap.size() - 1;
        while (i >= 0) {
            component = (ZComponentWapper)this.componentMap.get(i);
            action = component.getExactActionByClass(clazz);
            if (action != null) {
                return this.getAction(action);
            }
            --i;
        }
        if (this.rootConfig != null && (action = this.rootConfig.getFuzzyActionByClass(clazz)) != null) {
            return this.getAction(action);
        }
        if (this.actionPackage != null && (action = this.actionPackage.getFuzzyActionByClass(clazz)) != null) {
            return this.getAction(action);
        }
        i = this.componentMap.size() - 1;
        while (i >= 0) {
            component = (ZComponentWapper)this.componentMap.get(i);
            action = component.getFuzzyActionByClass(clazz);
            if (action != null) {
                return this.getAction(action);
            }
            --i;
        }
        return null;
    }

    public boolean hasInterceptor(String interceptor) {
        if (this.interceptorMap.containsKey(interceptor)) {
            return true;
        }
        Class clazz = Global.getClass((String)interceptor);
        return clazz != null && Classes.isImplement((Class)clazz, Interceptor.class);
    }

    public void setInterceptor(String alias, Interceptor interceptor) {
        this.interceptorMap.put(alias, (Object)interceptor);
    }

    public Interceptor getInterceptor(String interceptor) {
        Interceptor ic = (Interceptor)this.interceptorMap.get(interceptor);
        if (ic != null) {
            return ic;
        }
        Class cls = Global.getClass((String)interceptor);
        if (cls == null || !Classes.isImplement((Class)cls, Interceptor.class)) {
            return null;
        }
        return (Interceptor)Global.getWithoutNew((Class)cls);
    }

    private boolean initConfig(ZConfig config) throws Exception {
        for (ZAttribute attribute : config.getAttributeList()) {
            this.attributeMap.put(attribute.getKey(), (Object)attribute.getValue());
            log.info((Object)attribute);
        }
        for (ZInterceptor interceptor : config.getInterceptorList()) {
            String clazz = interceptor.getClazz();
            Object obj = Classes.newInstance((String)clazz);
            if (obj == null) {
                log.error((Object)"interceptor\u914d\u7f6e[%s]\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u7c7b\u540d\u6216\u7c7b\u5305\u540d\u662f\u5426\u6b63\u786e", new Object[]{clazz});
                return false;
            }
            if (!(obj instanceof Interceptor)) {
                log.error((Object)"interceptor\u914d\u7f6e\u672a\u5b9e\u73b0Interceptor\u63a5\u53e3[%s]", new Object[]{clazz});
                return false;
            }
            this.setInterceptor(interceptor.getKey(), (Interceptor)obj);
            log.info((Object)interceptor);
        }
        config.chkActionVariable();
        for (ZAction action : config.getExactActionList()) {
            if (!this.chkInterceptor(action)) {
                return false;
            }
            if (!this.chkClass(action)) {
                return false;
            }
            log.info((Object)action);
        }
        for (ZAction action : config.getFuzzyActionList()) {
            if (!this.chkInterceptor(action)) {
                return false;
            }
            if (!this.chkClass(action)) {
                return false;
            }
            log.info((Object)action);
        }
        return true;
    }

    private boolean chkInterceptor(ZAction action) {
        String[] interceptorArr;
        String interceptors = action.getInterceptor();
        if (Validates.isEmptyBlank((String)interceptors)) {
            return true;
        }
        String path = action.getPath();
        String[] stringArray = interceptorArr = interceptors.split(",");
        int n = interceptorArr.length;
        int n2 = 0;
        while (n2 < n) {
            String interceptor = stringArray[n2];
            if (!this.hasInterceptor(interceptor)) {
                log.error((Object)"action\u914d\u7f6e\u672a\u627e\u5230\u62e6\u622a\u5668[%s]][%s]", new Object[]{interceptor, path});
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean chkClass(ZAction action) throws Exception {
        String path = action.getPath();
        String clazz = action.getClazz();
        if (Validates.isEmptyBlank((String)clazz)) {
            this.actionMap.put(path, (Object)empty);
        } else if (path.indexOf("*") == -1 || clazz.indexOf("{") == -1 || clazz.indexOf("}") == -1) {
            Object obj = Classes.newInstance((String)clazz);
            if (obj == null) {
                log.error((Object)"action\u914d\u7f6e[%s]\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u7c7b\u540d\u6216\u7c7b\u5305\u540d\u662f\u5426\u6b63\u786e", new Object[]{clazz});
                return false;
            }
            if (!(obj instanceof Action)) {
                log.error((Object)"action\u914d\u7f6e[%s]\u672a\u5b9e\u73b0Action\u63a5\u53e3", new Object[]{clazz});
                return false;
            }
            this.actionMap.put(path, (Object)((Action)obj));
        }
        return true;
    }

    private Action getActionByRuntimeClass(String className) {
        return (Action)this.actionMap.get("_match_" + className);
    }

    private void setActionOnRuntimeClass(String className, Action action) {
        this.actionMap.put("_match_" + className, (Object)action);
    }
}

