/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd.bio;

import java.net.SocketTimeoutException;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpWebsocketConnection;
import org.zhiqim.httpd.HttpWebsocketConnectionAbs;
import org.zhiqim.httpd.HttpWebsocketMessage;
import org.zhiqim.httpd.bio.HttpBioConnection;
import org.zhiqim.kernel.util.Threads;
import org.zhiqim.kernel.util.seqs.Sequence;

public class HttpBioWebsocketConnection
extends HttpWebsocketConnectionAbs
implements Runnable {
    private static final Sequence sequence = new Sequence();
    private HttpBioConnection conn;
    private Thread thread;

    public HttpBioWebsocketConnection(HttpBioConnection conn, HttpContext context, String protocol, String sessionId) {
        super(context, protocol, sessionId);
        this.conn = conn;
    }

    @Override
    public HttpBioConnection getConnection() {
        return this.conn;
    }

    @Override
    public synchronized void open() {
        this.thread = Threads.newThread((Runnable)this, (String)"Http.Websocket", (Sequence)sequence);
        this.thread.start();
        while (!this.isRunning) {
            Threads.sleepIgnoreException((int)3);
        }
    }

    @Override
    public synchronized void close() {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        if (this.thread != null) {
            if (!this.thread.isInterrupted()) {
                this.thread.interrupt();
            }
            this.thread = null;
        }
        super.close();
    }

    @Override
    public synchronized void exception(Throwable e) {
        if (!this.isRunning) {
            return;
        }
        this.isRunning = false;
        if (this.thread != null) {
            if (!this.thread.isInterrupted()) {
                this.thread.interrupt();
            }
            this.thread = null;
        }
        if (this.conn != null) {
            this.conn.close();
            this.conn = null;
        }
        super.exception(e);
    }

    @Override
    public void run() {
        this.isRunning = true;
        while (this.isRunning) {
            try {
                HttpWebsocketMessage data = new HttpWebsocketMessage().parse(this.conn.getInputStream());
                if (data.isPong()) continue;
                if (data.isPing()) {
                    HttpWebsocketMessage message = new HttpWebsocketMessage().buildPong();
                    this.send(message.toBytes());
                    continue;
                }
                if (data.isClose()) {
                    this.close();
                    return;
                }
                if (!data.isText()) continue;
                this.context.getSessionManager().updateLastAccessed(this.sessionId);
                if (this.websocket == null) continue;
                this.websocket.onMessage((HttpWebsocketConnection)this, data.getText());
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (Throwable e) {
                this.exception(e);
            }
        }
    }
}

