/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd;

import java.io.IOException;
import org.zhiqim.httpd.HttpConnection;
import org.zhiqim.httpd.HttpContext;
import org.zhiqim.httpd.HttpSession;
import org.zhiqim.httpd.HttpSessionManager;
import org.zhiqim.httpd.HttpWebsocket;
import org.zhiqim.httpd.HttpWebsocketConnection;
import org.zhiqim.httpd.HttpWebsocketManager;
import org.zhiqim.httpd.HttpWebsocketMessage;

public abstract class HttpWebsocketConnectionAbs
implements HttpWebsocketConnection {
    protected HttpContext context;
    protected HttpWebsocketManager manager;
    protected String protocol;
    protected String sessionId;
    protected HttpWebsocket websocket;
    protected volatile boolean isRunning;

    public HttpWebsocketConnectionAbs(HttpContext context, String protocol, String sessionId) {
        this.context = context;
        this.manager = context.getWebsocketManager();
        this.protocol = protocol;
        this.sessionId = sessionId;
        this.websocket = this.manager.getWebsocket(protocol);
        if (this.websocket != null) {
            this.websocket.onOpen(this);
        }
    }

    public abstract HttpConnection getConnection();

    @Override
    public abstract void open();

    @Override
    public void close() {
        try {
            if (this.websocket != null) {
                this.websocket.onClose(this);
            }
        }
        finally {
            this.websocket = null;
            this.getWebsocketManager().remove(this);
        }
    }

    @Override
    public void exception(Throwable e) {
        try {
            if (this.websocket != null) {
                this.websocket.onException(this, e);
            }
        }
        finally {
            this.websocket = null;
            this.getWebsocketManager().remove(this);
        }
    }

    @Override
    public boolean send(String text) {
        HttpConnection conn = this.getConnection();
        if (conn == null || conn.isClosed()) {
            return false;
        }
        HttpWebsocketMessage message = new HttpWebsocketMessage().build(text);
        return this.send(message.toBytes());
    }

    @Override
    public boolean sendPing() {
        HttpConnection conn = this.getConnection();
        if (conn == null || conn.isClosed()) {
            return false;
        }
        HttpWebsocketMessage message = new HttpWebsocketMessage().buildPing();
        return this.send(message.toBytes());
    }

    @Override
    public boolean send(byte[] data) {
        HttpConnection conn = this.getConnection();
        if (conn == null || conn.isClosed()) {
            return false;
        }
        try {
            conn.write(data, 0, data.length);
            return true;
        }
        catch (IOException e) {
            this.exception(e);
            return false;
        }
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public HttpSessionManager getSessionManager() {
        return this.context.getSessionManager();
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public HttpSession getSession() {
        return this.getSessionManager().getSession(this.sessionId);
    }

    @Override
    public HttpWebsocket getWebsocket() {
        return this.websocket;
    }

    @Override
    public HttpWebsocketManager getWebsocketManager() {
        return this.context.getWebsocketManager();
    }
}

