/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.zhiqim.httpd.HttpConnection;
import org.zhiqim.httpd.HttpOutputStreamWrap;
import org.zhiqim.httpd.HttpSenderImpl;
import org.zhiqim.httpd.HttpdConstants;
import org.zhiqim.kernel.util.Ints;
import org.zhiqim.kernel.util.Zips;

public class HttpOutputStream
extends OutputStream
implements HttpdConstants {
    private final HttpOutputStreamWrap output;
    private int chunkSize = 0x100000;
    private HttpSenderImpl sender;
    private ByteArrayOutputStream content;
    private boolean chunked;
    private boolean headed;

    public HttpOutputStream(HttpConnection conn) {
        this.output = new HttpOutputStreamWrap(conn);
        this.content = new ByteArrayOutputStream();
    }

    public void setSender(HttpSenderImpl sender) {
        this.sender = sender;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize < 4096 ? 4096 : (chunkSize > 0x100000 ? 0x100000 : chunkSize);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.sender.isCommitted()) {
            return;
        }
        if (this.content.size() >= this.chunkSize) {
            this.flush();
        }
        this.content.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.sender.isCommitted()) {
            return;
        }
        if (this.content.size() >= this.chunkSize) {
            this.flush();
        }
        if (this.content.size() + len <= this.chunkSize) {
            this.content.write(b, off, len);
            return;
        }
        int page = (this.content.size() + len - 1) / this.chunkSize + 1;
        int firstLen = this.chunkSize - this.content.size();
        this.content.write(b, off, firstLen);
        this.flush();
        int length = firstLen;
        int i = 1;
        while (i < page) {
            int count = i < page - 1 ? this.chunkSize : len - length;
            this.content.write(b, off + length, count);
            length += count;
            if (count >= this.chunkSize) {
                this.flush();
            }
            ++i;
        }
    }

    @Override
    public void flush() throws IOException {
        if (!this.headed) {
            this.output.write(this.sender.buildChunkedHeader(true));
            this.headed = true;
        }
        this.writeChunked();
    }

    public void reset() {
        this.content.reset();
    }

    public void commit() throws IOException {
        if (!this.chunked) {
            this.output.write(this.sender.buildChunkedHeader(false));
            this.content.writeTo(this.output);
            this.output.flush();
        } else {
            if (this.content.size() > 0) {
                this.writeChunked();
            }
            this.writeChunkedEnd();
        }
    }

    public void finished() throws IOException {
        if (this.content != null) {
            this.content.close();
            this.content = null;
        }
        this.output.close();
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public boolean processGZipCompress() {
        try {
            this.content = Zips.gzip((ByteArrayOutputStream)this.content);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public long getOutputLength() {
        return this.output.length();
    }

    public int getContentLength() {
        return this.content.size();
    }

    private void writeChunked() throws IOException {
        this.output.write(Ints.toBytesHex((int)this.content.size()));
        this.output.write(_CRLF_);
        this.content.writeTo(this.output);
        this.output.write(_CRLF_);
        this.output.flush();
        this.content.reset();
        this.chunked = true;
    }

    private void writeChunkedEnd() throws IOException {
        this.output.write(48);
        this.output.write(_CRLF_);
        this.output.write(_CRLF_);
        this.output.flush();
    }
}

