/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd;

import java.util.ArrayList;
import java.util.List;
import org.zhiqim.httpd.HttpConnection;
import org.zhiqim.httpd.HttpHeader;
import org.zhiqim.httpd.HttpResponseImpl;
import org.zhiqim.httpd.HttpSender;
import org.zhiqim.httpd.HttpSenderImpl;
import org.zhiqim.httpd.HttpServer;
import org.zhiqim.httpd.HttpdConstants;
import org.zhiqim.httpd.bio.HttpBioConnection;
import org.zhiqim.httpd.nio.HttpNioConnection;
import org.zhiqim.kernel.config.Group;
import org.zhiqim.kernel.control.Queue;
import org.zhiqim.kernel.control.ThreaderController;
import org.zhiqim.kernel.control.Threadx;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.schedule.Interval;
import org.zhiqim.kernel.schedule.Task;
import org.zhiqim.kernel.util.Asserts;

public abstract class HttpListener
extends Threadx
implements Task,
HttpdConstants {
    protected static final Log log = LogFactory.getLog(HttpListener.class);
    private final HttpServer server;
    private final List<HttpConnection> connList;
    protected Group listenerGroup;
    protected String listenerName;
    protected int listenerPort;
    protected String listenerIp;
    protected int soTimeoutMs;
    protected int soLingerS;
    protected int soRecvBuf;
    protected int soSendBuf;
    protected int soIdleTimeMs;
    protected int poMinSize;
    protected int poMaxSize;
    protected int poIdleTime;
    protected int poQueueSize;
    protected ThreaderController controller;
    protected Log logger;
    private Interval interval;

    public HttpListener(HttpServer server) {
        this.server = server;
        this.connList = new ArrayList<HttpConnection>();
    }

    public void setGroup(Group group) {
        this.listenerGroup = group;
    }

    protected String getThreadName() {
        return this.listenerName;
    }

    protected boolean openBefore() {
        this.listenerName = this.listenerGroup.getId();
        this.listenerIp = this.listenerGroup.getString("ipAddress");
        this.listenerPort = this.listenerGroup.getInt("port");
        Asserts.as((String)(this.listenerPort >= 1 && this.listenerPort <= 65535 ? null : "\u672a\u914d\u7f6e[%s]\u7684port\u914d\u7f6e\u9879\uff0c\u6216\u914d\u7f6e\u7684\u503c\u4e0d\u662f\u7aef\u53e3\u503c[1-65535]"));
        this.soTimeoutMs = this.listenerGroup.getInt("soTimeout", 60) * 1000;
        this.soLingerS = this.listenerGroup.getInt("soLinger", -1);
        this.soRecvBuf = this.listenerGroup.getInt("soRecvBuf", 1024);
        this.soSendBuf = this.listenerGroup.getInt("soSendBuf", 131072);
        this.soIdleTimeMs = this.listenerGroup.getInt("soIdleTime", 53) * 1000;
        this.poMinSize = this.listenerGroup.getInt("poMinSize", 20);
        this.poMaxSize = this.listenerGroup.getInt("poMaxSize", 200);
        this.poIdleTime = this.listenerGroup.getInt("poIdleTime", 600);
        this.poQueueSize = this.listenerGroup.getInt("poQueueSize", this.poMaxSize * 3);
        if (this.listenerGroup.isTrue("accessLog")) {
            this.logger = LogFactory.getLog((String)this.listenerName);
        }
        if (this.soIdleTimeMs > 0) {
            this.interval = Interval.shedule((Task)this, (int)this.soIdleTimeMs);
        }
        this.controller = new ThreaderController();
        this.controller.set(this.poMinSize, this.poMaxSize, this.poIdleTime, this.poQueueSize);
        this.controller.setThreadName(this.listenerName);
        this.controller.create();
        return true;
    }

    protected void closeAfter() {
        if (this.interval != null) {
            this.interval.close();
            this.interval = null;
        }
        if (this.controller != null) {
            this.controller.close();
            this.controller = null;
        }
        this.connList.clear();
        log.info((Object)(String.valueOf(this.toString()) + "\u9000\u51fa"));
    }

    public HttpServer getServer() {
        return this.server;
    }

    public String getScheme() {
        return "http";
    }

    public int getPort() {
        return this.listenerPort;
    }

    public String getName() {
        return this.listenerName;
    }

    public String getIpAddress() {
        return this.listenerIp;
    }

    public int getSoTimeoutMs() {
        return this.soTimeoutMs;
    }

    public int getSoRecvBuf() {
        return this.soRecvBuf;
    }

    public int getSoSendBuf() {
        return this.soSendBuf;
    }

    public int getSoIdleTimeMs() {
        return this.soIdleTimeMs;
    }

    public int getPoMaxSize() {
        return this.poMaxSize;
    }

    public int getPoMinSize() {
        return this.poMinSize;
    }

    public int getPoQueueSize() {
        return this.poQueueSize;
    }

    public int getPoIdleTime() {
        return this.poIdleTime;
    }

    public ThreaderController getController() {
        return this.controller;
    }

    public int getThreaderActiveSize() {
        return this.controller.getThreaderActiveSize();
    }

    public int getThreaderSize() {
        return this.controller.getThreaderSize();
    }

    public long getCompletedCount() {
        return this.controller.getCompletedCount();
    }

    public Queue<Runnable> getQueue() {
        return this.controller.getQueue();
    }

    public int getQueueSize() {
        return this.controller.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(HttpConnection conn) {
        List<HttpConnection> list = this.connList;
        synchronized (list) {
            this.connList.remove(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpNioConnection add(HttpNioConnection conn) {
        List<HttpConnection> list = this.connList;
        synchronized (list) {
            this.connList.add(conn);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpBioConnection add(HttpBioConnection conn) {
        List<HttpConnection> list = this.connList;
        synchronized (list) {
            this.connList.add(conn);
        }
        return conn;
    }

    public void finished(HttpHeader header) {
        if (this.logger == null) {
            return;
        }
        HttpSender sender = header.getSender();
        String remoteAddr = header.getRemoteAddr();
        String headerLine = header.getHeaderLine();
        int listenerPort = header.getListenerPort();
        int status = sender.getStatus();
        long length = 0L;
        if (sender instanceof HttpSenderImpl) {
            length = ((HttpSenderImpl)sender).getFlushLength();
        } else if (sender instanceof HttpResponseImpl) {
            length = ((HttpResponseImpl)sender).getFlushLength();
        }
        String message = "[" + remoteAddr + "]" + " [" + status + "]" + " [" + listenerPort + "]" + " [" + length + "]" + " [" + headerLine + "]";
        this.logger.info((Object)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        int wsNum = 0;
        int activeNum = 0;
        ArrayList<HttpConnection> list = new ArrayList<HttpConnection>();
        List<HttpConnection> list2 = this.connList;
        synchronized (list2) {
            for (HttpConnection httpConnection : this.connList) {
                list.add(httpConnection);
            }
        }
        for (HttpConnection httpConnection : list) {
            if (httpConnection.isWebsocket()) {
                ++wsNum;
                continue;
            }
            if (httpConnection.isActive()) {
                ++activeNum;
                continue;
            }
            if (!httpConnection.isOvertime()) continue;
            log.debug((Object)"\u8fde\u63a5[%s]\u7a7a\u95f2\u8fc7\u957f\uff0c\u6b63\u5e38\u5173\u95ed", new Object[]{httpConnection.getId()});
            httpConnection.close();
        }
        int n = list.size();
        int n2 = n - wsNum - activeNum;
        list.clear();
        list = null;
        log.info((Object)"\u5141\u8bb8\u6700\u5927\u8fde\u63a5[%s]\uff0c\u5f53\u524d\u603b\u8fde\u63a5[%s]=WS[%s]+\u6d3b\u52a8[%s]+\u7a7a\u95f2[%s]\uff0c\u5141\u8bb8\u7a7a\u95f2[%s]\u79d2", new Object[]{this.poMaxSize, n, wsNum, activeNum, n2, this.soIdleTimeMs / 1000});
    }

    public String toString() {
        return this.getScheme() + "\u76d1\u542c:[" + "name:" + this.listenerName + ";" + "port:" + this.listenerPort + "]";
    }
}

