/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.httpd;

import java.io.IOException;
import org.zhiqim.httpd.constants.HttpStatus;

public class HttpException
extends IOException {
    private static final long serialVersionUID = 1L;
    private int code;

    public int getCode() {
        return this.code;
    }

    public HttpException() {
        this.code = 400;
    }

    public HttpException(String message) {
        super(message);
        this.code = 503;
    }

    public HttpException(int code) {
        this.code = code;
    }

    public HttpException(int code, String message) {
        super(message);
        this.code = code;
    }

    public String getReason() {
        return HttpStatus.getStatusMsg(this.code);
    }

    @Override
    public String toString() {
        String message = this.getMessage();
        String reason = this.getReason();
        return "HttpException(" + this.code + "," + reason + "," + message + ")";
    }
}

