/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util.codes;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;

public class SSL {
    public static int deduceKeyLength(String cipherSuite) {
        if (cipherSuite == null) {
            return 0;
        }
        if (cipherSuite.indexOf("WITH_RC4_128_") >= 0) {
            return 128;
        }
        if (cipherSuite.indexOf("WITH_AES_128_") >= 0) {
            return 128;
        }
        if (cipherSuite.indexOf("WITH_RC4_40_") >= 0) {
            return 40;
        }
        if (cipherSuite.indexOf("WITH_3DES_EDE_CBC_") >= 0) {
            return 168;
        }
        if (cipherSuite.indexOf("WITH_IDEA_CBC_") >= 0) {
            return 128;
        }
        if (cipherSuite.indexOf("WITH_RC2_CBC_40_") >= 0) {
            return 40;
        }
        if (cipherSuite.indexOf("WITH_DES40_CBC_") >= 0) {
            return 40;
        }
        if (cipherSuite.indexOf("WITH_DES_CBC_") >= 0) {
            return 56;
        }
        return 0;
    }

    public static X509Certificate[] getCertChain(SSLSession sslSession) {
        javax.security.cert.X509Certificate[] javaxCerts;
        block5: {
            javaxCerts = sslSession.getPeerCertificateChain();
            if (javaxCerts != null && javaxCerts.length != 0) break block5;
            return null;
        }
        try {
            int length = javaxCerts.length;
            X509Certificate[] javaCerts = new X509Certificate[length];
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            int i = 0;
            while (i < length) {
                byte[] bytes = javaxCerts[i].getEncoded();
                ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
                javaCerts[i] = (X509Certificate)cf.generateCertificate(stream);
                ++i;
            }
            return javaCerts;
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static KeyStore getKeyStore(String storePath, String storeType, String storeProvider, String storePassword) throws Exception {
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileInputStream is = new FileInputStream(storePath);){
            return SSL.getKeyStore(is, storeType, storeProvider, storePassword);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static KeyStore getKeyStore(InputStream is, String storeType, String storeProvider, String storePassword) throws Exception {
        KeyStore keystore = null;
        keystore = storeProvider != null ? KeyStore.getInstance(storeType, storeProvider) : KeyStore.getInstance(storeType);
        keystore.load(is, storePassword == null ? null : storePassword.toCharArray());
        return keystore;
    }

    public static Collection<? extends CRL> loadCRL(String crlPath) throws Exception {
        if (crlPath == null) {
            return null;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream is = new FileInputStream(crlPath);){
            return CertificateFactory.getInstance("X.509").generateCRLs(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static class DefaultHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    public static class DefaultTrustManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

