/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.control.Filter;
import org.zhiqim.kernel.control.FilterEndsWith;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Files;
import org.zhiqim.kernel.util.Streams;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"Jars"})
public class Jars {
    public static String getClassName(JarEntry jarEntry) {
        String className = jarEntry.getName();
        className = Strings.trimRight(className, ".class");
        className = Strings.replaceAll(className, "/", ".");
        return className;
    }

    public static List<JarEntry> queryEndsWithList(JarFile file, Filter filter) {
        ArrayList<JarEntry> list = new ArrayList<JarEntry>();
        Enumeration<JarEntry> enumeration = file.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry entry = enumeration.nextElement();
            String name = entry.getName();
            if (!filter.access(name)) continue;
            list.add(entry);
        }
        return list;
    }

    public static List<JarEntry> queryEndsWithList(JarFile file, String endsWith) {
        ArrayList<JarEntry> list = new ArrayList<JarEntry>();
        Enumeration<JarEntry> enumeration = file.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry entry = enumeration.nextElement();
            String name = entry.getName();
            if (!Validates.isEmpty(endsWith) && !name.endsWith(endsWith)) continue;
            list.add(entry);
        }
        return list;
    }

    public static void queryFilterList(List<JarEntry> entryList, JarFile file, Filter filter) {
        ArrayList<JarEntry> list = new ArrayList<JarEntry>();
        Enumeration<JarEntry> enumeration = file.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry entry = enumeration.nextElement();
            String name = entry.getName();
            if (!filter.access(name)) continue;
            list.add(entry);
        }
    }

    public static void queryEndsWithList(List<JarEntry> entryList, JarFile file, String endsWith) {
        Filter filter = new FilterEndsWith().param(endsWith);
        Jars.queryEndsWithList(file, filter);
    }

    public static void jar(String fileDirPath, String jarExportPath) throws Exception {
        Asserts.notEmpty(fileDirPath, "\u6587\u4ef6\u76ee\u5f55\u8def\u5f84");
        Asserts.notEmpty(jarExportPath, "JAR\u5bfc\u51fa\u8def\u5f84");
        File fileDir = new File(fileDirPath);
        Asserts.as(fileDir.exists() ? null : "\u6587\u4ef6\u76ee\u5f55\u8def\u5f84\u4e0d\u5b58\u5728");
        String fileDirCanonicalPath = Files.toLinuxPath(fileDir.getCanonicalPath());
        FileOutputStream fos = new FileOutputStream(jarExportPath);
        JarOutputStream jos = new JarOutputStream(fos);
        jos.setLevel(9);
        ArrayList<File> fileList = new ArrayList<File>();
        Files.queryFileList(fileList, fileDir, 0);
        for (File file : fileList) {
            String name = Files.toLinuxPath(file.getCanonicalPath());
            name = file.isDirectory() ? String.valueOf(name.substring(fileDirCanonicalPath.length() + 1)) + "/" : name.substring(fileDirCanonicalPath.length() + 1);
            JarEntry ze = new JarEntry(name);
            ze.setSize(file.length());
            ze.setTime(file.lastModified());
            jos.putNextEntry(ze);
            if (ze.isDirectory()) {
                jos.closeEntry();
                continue;
            }
            Throwable throwable = null;
            Object var12_13 = null;
            try (FileInputStream is = new FileInputStream(file);){
                Streams.putBytes(is, jos);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            jos.closeEntry();
        }
        jos.close();
    }
}

