/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.transaction;

import java.util.ArrayList;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.extend.HashMapSV;
import org.zhiqim.kernel.transaction.Transaction;
import org.zhiqim.kernel.transaction.TransactionLister;
import org.zhiqim.kernel.transaction.TransactionService;
import org.zhiqim.kernel.util.Arrays;
import org.zhiqim.kernel.util.Asserts;

public class TransactionManager {
    private static final HashMapSV<TransactionService> serviceMap = new HashMapSV();
    private static final ThreadLocal<HashMapSO> variableMap = new ThreadLocal();

    public static boolean hasTransactionService(String id) {
        return serviceMap.containsKey(id);
    }

    public static void addTransactionService(TransactionService service) {
        serviceMap.put(service.getId(), service);
    }

    public static void removeTransactionService(String id) {
        serviceMap.remove(id);
    }

    public static void removeTransactionService(TransactionService service) {
        serviceMap.remove(service.getId());
    }

    public static Transaction beginTransaction(String id) throws Exception {
        Object instance;
        Asserts.notEmptyBlank(id, "\u4e8b\u52a1\u670d\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u767d");
        TransactionService service = (TransactionService)serviceMap.get(id);
        Asserts.as(service != null ? null : "\u6839\u636e[%s]\u672a\u627e\u5230\u4e8b\u52a1\u670d\u52a1", id);
        HashMapSO instanceMap = variableMap.get();
        if (instanceMap == null) {
            instanceMap = new HashMapSO();
            variableMap.set(instanceMap);
        }
        if ((instance = instanceMap.get(id)) == null) {
            instance = service.getTransactionInstance();
            instanceMap.put(id, instance);
        }
        return service.beginTransaction(instance);
    }

    public static Transaction beginTransactions(String ids) throws Exception {
        String[] idArr = Arrays.toStringArray(ids);
        return TransactionManager.beginTransaction(idArr);
    }

    public static Transaction beginTransaction(String ... ids) throws Exception {
        if (ids == null || ids.length == 0) {
            ids = serviceMap.keySet().toArray(new String[0]);
        }
        ArrayList<Transaction> txList = new ArrayList<Transaction>();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            txList.add(TransactionManager.beginTransaction(id));
            ++n2;
        }
        return new TransactionLister(ids, txList);
    }

    public static Object getInstance(String id) {
        HashMapSO instanceMap = variableMap.get();
        if (instanceMap == null) {
            return null;
        }
        return instanceMap.get(id);
    }

    public static void closeTransaction(String ... ids) {
        if (ids == null || ids.length == 0) {
            variableMap.set(null);
            return;
        }
        HashMapSO instanceMap = variableMap.get();
        if (instanceMap == null) {
            return;
        }
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            instanceMap.remove(id);
            ++n2;
        }
        if (instanceMap.isEmpty()) {
            variableMap.set(null);
        }
    }
}

