/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.schedule;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.schedule.Task;
import org.zhiqim.kernel.schedule.TaskThreader;
import org.zhiqim.kernel.util.DateTimes;

@AnAlias(value={"Month"})
public final class Month
extends TaskThreader {
    private int taskDay = 1;
    private int taskHour = 0;
    private int taskMinute = 0;
    private int taskSecond = 0;

    public Month() {
    }

    public Month(Task task, int day, int hour, int minute, int second) {
        this.schedule(task, new int[]{day, hour, minute, second});
    }

    @Override
    public String getName() {
        return "Month";
    }

    @Override
    public String getTime() {
        return this.taskDay + "/" + this.taskHour + "/" + this.taskMinute + "/" + this.taskSecond;
    }

    @Override
    protected TaskThreader schedule(Task task, int[] time) {
        if (task == null || time == null || time.length != 4) {
            throw new RuntimeException("Month\u4f20\u5165\u7684\u53c2\u6570\u4e3a\u7a7a\u6216\u6570\u7ec4\u957f\u5ea6\u4e0d\u5bf9");
        }
        if (time[0] < 0 || time[0] > 28 || time[1] < 0 || time[1] > 23 || time[2] < 0 || time[2] > 59 || time[3] < 0 || time[3] > 59) {
            throw new RuntimeException("Month\u4f20\u65f6\u7684\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        this.task = task;
        this.taskDay = time[0];
        this.taskHour = time[1];
        this.taskMinute = time[2];
        this.taskSecond = time[3];
        return this;
    }

    @Override
    protected long calcLastTime(int curYearMonth, int curMonthMaxDay, int curDay, int curHour, int curMinute, int curSecond, int curWeek) {
        return curYearMonth;
    }

    @Override
    protected long calcLastTimeNextTime() {
        return DateTimes.getNextYearMonth((int)this.lastTime);
    }

    @Override
    protected boolean isArrive(int curYearMonth, int curMonthMaxDay, int curDay, int curHour, int curMinute, int curSecond, int curWeek) {
        int taskHDay;
        int n = taskHDay = this.taskDay == 0 ? curMonthMaxDay : this.taskDay;
        if (curDay < taskHDay) {
            return false;
        }
        if (curDay > taskHDay) {
            return true;
        }
        if (curHour < this.taskHour) {
            return false;
        }
        if (curHour > this.taskHour) {
            return true;
        }
        if (curMinute < this.taskMinute) {
            return false;
        }
        if (curMinute > this.taskMinute) {
            return true;
        }
        return curSecond >= this.taskSecond;
    }

    public int getTaskDay() {
        return this.taskDay;
    }

    public int getTaskHour() {
        return this.taskHour;
    }

    public int getTaskMinute() {
        return this.taskMinute;
    }

    public int getTaskSecond() {
        return this.taskSecond;
    }

    public boolean isMonthLastDay() {
        return this.taskDay == 0;
    }

    @Override
    public String toString() {
        return "{type:Month, " + "time:" + this.taskDay + "/" + this.taskHour + "/" + this.taskMinute + "/" + this.taskSecond + ", " + "first:" + this.isFirstExecute + "}";
    }
}

