/*
 * Decompiled with CFR 0.152.
 */
package org.zhiqim.kernel.schedule;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.schedule.Task;
import org.zhiqim.kernel.schedule.TaskThreader;
import org.zhiqim.kernel.util.DateTimes;

@AnAlias(value={"Hour6"})
public final class Hour6
extends TaskThreader {
    private int taskHour = 0;
    private int taskMinute = 0;
    private int taskSecond = 0;

    public Hour6() {
    }

    public Hour6(Task task, int hour, int minute, int second) {
        this.schedule(task, new int[]{hour, minute, second});
    }

    @Override
    public String getName() {
        return "Hour6";
    }

    @Override
    public String getTime() {
        return this.taskHour + "/" + this.taskMinute + "/" + this.taskSecond;
    }

    @Override
    protected TaskThreader schedule(Task task, int[] time) {
        if (task == null || time == null || time.length != 3) {
            throw new RuntimeException("Hour6\u4f20\u5165\u7684\u53c2\u6570\u4e3a\u7a7a\u6216\u6570\u7ec4\u957f\u5ea6\u4e0d\u5bf9");
        }
        if (time[0] < 0 || time[0] > 5 || time[1] < 0 || time[1] > 59 || time[2] < 0 || time[2] > 59) {
            throw new RuntimeException("Hour6\u4f20\u65f6\u7684\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        this.task = task;
        this.taskHour = time[0];
        this.taskMinute = time[1];
        this.taskSecond = time[2];
        return this;
    }

    @Override
    protected long calcLastTime(int curYearMonth, int curMonthMaxDay, int curDay, int curHour, int curMinute, int curSecond, int curWeek) {
        return (long)curYearMonth * 1000L + (long)(curDay * 10) + (long)(curHour / 6);
    }

    @Override
    protected long calcLastTimeNextTime() {
        long yearMonthDay = this.lastTime / 10L;
        long curHourMod = this.lastTime % 10L;
        if (curHourMod < 3L) {
            ++curHourMod;
        } else {
            curHourMod = 0L;
            yearMonthDay = DateTimes.getNextDateInt((int)yearMonthDay);
        }
        return yearMonthDay * 10L + curHourMod;
    }

    @Override
    protected final boolean isArrive(int curYearMonth, int curMonthMaxDay, int curDay, int curHour, int curMinute, int curSecond, int curWeek) {
        int curHourMod = curHour % 6;
        if (curHourMod < this.taskHour) {
            return false;
        }
        if (curHourMod > this.taskHour) {
            return true;
        }
        if (curMinute < this.taskMinute) {
            return false;
        }
        if (curMinute > this.taskMinute) {
            return true;
        }
        return curSecond >= this.taskSecond;
    }

    public int getTaskHour() {
        return this.taskHour;
    }

    public int getTaskMinute() {
        return this.taskMinute;
    }

    public int getTaskSecond() {
        return this.taskSecond;
    }
}

