;(function(Z, $)
{
//BEGIN
var TopBase = window.TopBase = {};

/********************************************************/
//初始化皮肤和缩放容器大小
/********************************************************/
Z.onload(function()
{//注册初始化时初始化皮肤和缩放容器事件
    TopBase.doResizeContainer();
    if (typeof(workbench) != 'undefined'){
        QN.initTheme();
    }else{
        $(".sui-navbar").css("backgroundColor", "#50a8e7");
    }
});

$(window).resize(function()
{//注册窗口缩放时缩放容器事件
    TopBase.doResizeContainer();
});

/********************************************************/
//全局使用相关
/********************************************************/
TopBase.doResizeContainer = function()
{
    var $container = $(".container");
    $container.height($(window).height() - $(".sui-navbar").height());
};

TopBase.openChat = function(userNick)
{//打开客服聊天框
    QN.application.invoke({
        cmd : 'openChat',
        param : {nick:'cntaobao'+userNick}
    });
};

TopBase.openHelpService = function(serviceUrl)
{//打开帮助
    QN.application.invoke({
        cmd : 'browserUrl',
        param : {url:serviceUrl}
    });
};

TopBase.openOrderService = function(orderUrl)
{//打开订购服务
    TopBase.doRefreshUserOrder();
    
    QN.application.invoke({
        cmd : 'fwConfirmOrder',
        param : {orderString:orderUrl}
    });
};

TopBase.doRefreshUserOrder = function()
{//刷新用户订购信息
    var ajax = new Z.Ajax();
    ajax.setClassName("GlobalPresenter");
    ajax.setMethodName("doRefreshUserOrder");
    ajax.execute();
};

TopBase.openPermission = function(appUrl)
{//弹出版本权限检查对话框
    $.alert({
        title: '升级提示',
        body: '正在加载...',
        backdrop: 'static',
        remote: '/pcPermission.htm?&appUrl='+encodeURIComponent(appUrl),
        width: '580px',
        height: '200px',
        hasfoot: false
    });
};

TopBase.openWeb = function(webUrl)
{//打开网页版
    var ajax = new Z.Ajax();
    ajax.setClassName("GlobalPresenter");
    ajax.setMethodName("setFrom");
    ajax.addParam(0);//0表示WEB版
    ajax.setFailure(function(responseText)
    {
        $.alert(responseText);
    });
    ajax.setSuccess(function(responseText)
    {
        window.location.href = webUrl;
    });
    
    ajax.execute();
};

TopBase.doCloseTopNotice = function()
{//关闭消息通知栏
    var ajax = new Z.Ajax();
    ajax.setSync();
    ajax.setClassName("GlobalPresenter");
    ajax.setMethodName("doCloseTopNotice");
    ajax.execute();
    
    Z("#topNotice").hide();
};

TopBase.openFwPlanDetail = function(planCode)
{//打开套餐订购详情页
    QN.application.invoke( {
        cmd : 'fwPlanDetail',
        param : {planCode : planCode}
    });
};

TopBase.isAuthW2 = function()
{//判断是否有短授权
    var ajax = new Z.Ajax();
    ajax.setSync();
    ajax.setClassName("GlobalPresenter");
    ajax.setMethodName("isAuthW2");
    ajax.execute();
    
    return (ajax.responseStatus == 0)
};

TopBase.openAuthW2 = function()
{//弹出短授权对话框
    QN.application.invoke({
        cmd : 'openAttachWindow',
        param : {
            event : 'w2close_qianniupc',
            width : 790,
            height : 500,
            title : '重授权'
        },
        error: function(){TopBase.getAuthW2();}
    });
};

TopBase.getAuthW2 = function()
{//获取短授权时钟
    var ajax = new Z.Ajax();
    ajax.setClassName("GlobalPresenter");
    ajax.setMethodName("getAuthW2");
    ajax.execute();
};

TopBase.clockAuthW2 = function()
{//短授权时钟
    var $clock = Z("#clock");
    if ($clock.length == 0)
        return;
        
    var ct = new Date().getTime();
    if (ct > st)
        $clock.text('0分0秒');
    else
    {
        var count = Math.floor((st-ct)/1000);
        $clock.text(Math.floor(count / 60)+'分'+(count%60)+'秒');
    }
};

//END
})(zhiqim, jQuery);