/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.service.dao;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.redxyz.top.dbo.sys.SysHoliday;
import org.zhiqim.kernel.util.consts.Int;

public class HolidayDao {
    private static final List<Int> holidayCatList = new ArrayList<Int>();
    private static LinkedHashMap<Integer, List<SysHoliday>> holidayInfoMap;

    static {
        holidayCatList.add(new Int(1, "\u5143\u65e6"));
        holidayCatList.add(new Int(2, "\u6625\u8282"));
        holidayCatList.add(new Int(3, "\u6e05\u660e\u8282"));
        holidayCatList.add(new Int(4, "\u52b3\u52a8\u8282"));
        holidayCatList.add(new Int(5, "\u7aef\u5348\u8282"));
        holidayCatList.add(new Int(6, "\u6297\u80dc\u65e5"));
        holidayCatList.add(new Int(7, "\u4e2d\u79cb\u8282"));
        holidayCatList.add(new Int(8, "\u56fd\u5e86\u8282"));
        holidayInfoMap = new LinkedHashMap();
    }

    public static List<Int> getHolidayCat() {
        return holidayCatList;
    }

    public static String getHolidayCatName(int id) {
        for (Int cat : holidayCatList) {
            if (id != cat.value()) continue;
            return cat.desc();
        }
        return "\u672a\u77e5\u8282\u65e5";
    }

    public static List<Int> getHolidayCatNoAdd() {
        ArrayList<Int> catList = new ArrayList<Int>();
        for (Int cat : holidayCatList) {
            if (holidayInfoMap.containsKey(cat.value())) continue;
            catList.add(cat);
        }
        return catList;
    }

    public static List<Int> getHolidayCatAdded() {
        ArrayList<Int> catList = new ArrayList<Int>();
        for (Int cat : holidayCatList) {
            if (holidayInfoMap.containsKey(cat.value())) continue;
            catList.add(cat);
        }
        return catList;
    }

    public static List<SysHoliday> getHolidayList(int id) {
        return holidayInfoMap.get(id);
    }

    public static SysHoliday getHoliday(String date) {
        if (date == null) {
            return null;
        }
        for (List<SysHoliday> list : holidayInfoMap.values()) {
            for (SysHoliday holiday : list) {
                if (!date.equals(holiday.getDate())) continue;
                return holiday;
            }
        }
        return null;
    }

    public static int getHolidayType(String date) {
        if (date == null) {
            return -1;
        }
        for (List<SysHoliday> list : holidayInfoMap.values()) {
            for (SysHoliday holiday : list) {
                if (!date.equals(holiday.getDate())) continue;
                return holiday.getType();
            }
        }
        return -1;
    }
}

