/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.service.dao;

import java.util.List;
import net.redxyz.top.dbo.sys.SysArticle;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.annotation.AnGlobal;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;

@AnAlias(value={"ArticleDao"})
@AnGlobal
public class ArticleDao {
    public static List<SysArticle> list() throws Exception {
        return ArticleDao.getActicleList();
    }

    public static SysArticle item(int versionNo) throws Exception {
        List<SysArticle> articleList = ArticleDao.getActicleList();
        for (SysArticle article : articleList) {
            if (article.getVersionNo() != versionNo) continue;
            return article;
        }
        return null;
    }

    public static SysArticle item(String itemCode) throws Exception {
        List<SysArticle> articleList = ArticleDao.getActicleList();
        for (SysArticle article : articleList) {
            if (!article.getItemCode().equals(itemCode)) continue;
            return article;
        }
        return null;
    }

    public static String getItemName(int versionNo) throws Exception {
        SysArticle article = ArticleDao.item(versionNo);
        if (article == null) {
            return "\u4e34\u65f6\u7248";
        }
        return article.getItemName();
    }

    public static int getVersionNo(String itemCode) throws Exception {
        SysArticle article = ArticleDao.item(itemCode);
        if (article == null) {
            return 0;
        }
        return article.getVersionNo();
    }

    private static List<SysArticle> getActicleList() throws Exception {
        List articleList = ((ZTable)Global.get(ZTable.class)).list(SysArticle.class, new Selector().addOrderbyAsc("versionNo"));
        return articleList;
    }
}

