/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.service;

import java.util.ArrayList;
import net.redxyz.top.TaobaoService;
import net.redxyz.top.data.vas.ArticleBizOrder;
import net.redxyz.top.data.vas.ArticleUserSubscribe;
import net.redxyz.top.message.vas.AppstoreSubscribeGetRequest;
import net.redxyz.top.message.vas.AppstoreSubscribeGetResponse;
import net.redxyz.top.message.vas.FuwuSaleLinkGenRequest10124_2164;
import net.redxyz.top.message.vas.FuwuSaleLinkGenResponse10124_2164;
import net.redxyz.top.message.vas.VasOrderSearchRequest10124_10587;
import net.redxyz.top.message.vas.VasOrderSearchResponse10124_10587;
import net.redxyz.top.message.vas.VasSubscribeGetRequest10124_10586;
import net.redxyz.top.message.vas.VasSubscribeGetResponse10124_10586;

public class TaobaoVasService {
    public AppstoreSubscribeGetResponse getSubscribe(String nick, String sessionId) {
        AppstoreSubscribeGetRequest req = new AppstoreSubscribeGetRequest();
        req.setSession(sessionId);
        req.setNick(nick);
        return TaobaoService.invokeTaobaoService(req);
    }

    public ArticleUserSubscribe getSubscribeVas(String articleCode, String nick) {
        VasSubscribeGetRequest10124_10586 req = new VasSubscribeGetRequest10124_10586();
        req.setNick(nick);
        req.setArticleCode(articleCode);
        VasSubscribeGetResponse10124_10586 resp = TaobaoService.invokeTaobaoService(req);
        if (resp.isTaobaoFail()) {
            resp = TaobaoService.invokeTaobaoService(req);
        }
        ArticleUserSubscribe subscribe = new ArticleUserSubscribe();
        if (resp.isUserFail()) {
            return subscribe.setExpired();
        }
        if (!resp.isSuccess()) {
            return subscribe.setUnknown();
        }
        ArticleUserSubscribe subs = resp.getOrder();
        if (subs == null) {
            return subscribe.setExpired();
        }
        subscribe.setDeadline(subs.getDeadline());
        subscribe.setItemCode(subs.getItemCode());
        return subscribe;
    }

    public ArrayList<ArticleBizOrder> getOrderList(String articleCode, String nick) throws Exception {
        ArrayList<ArticleBizOrder> itemList = new ArrayList<ArticleBizOrder>();
        VasOrderSearchResponse10124_10587 resp = this.getOrderList(articleCode, nick, 1, 200);
        int total = resp.getTotalItem();
        itemList.addAll(resp.getOrderList());
        int i = 2;
        while (i <= (total - 1) / 200 + 1) {
            Thread.sleep(10000L);
            VasOrderSearchResponse10124_10587 tempResp = this.getOrderList(articleCode, nick, i, 200);
            itemList.addAll(tempResp.getOrderList());
            ++i;
        }
        return itemList;
    }

    public VasOrderSearchResponse10124_10587 getOrderList(String articleCode, String nick, int pageNo, int pageSize) throws Exception {
        VasOrderSearchRequest10124_10587 req = new VasOrderSearchRequest10124_10587();
        req.setArticleCode(articleCode);
        req.setNick(nick);
        req.setPageNo(pageNo);
        req.setPageSize(pageSize);
        VasOrderSearchResponse10124_10587 resp = TaobaoService.invokeTaobaoService(req);
        if (!resp.isSuccess()) {
            throw new Exception("\u67e5\u8be2\u8ba2\u8d2d\u5173\u7cfb\u8bb0\u5f55\u5f02\u5e38:" + resp.toString());
        }
        return resp;
    }

    public ArrayList<ArticleBizOrder> getOrderList(String articleCode, String beginTime, String endTime) throws Exception {
        ArrayList<ArticleBizOrder> itemList = new ArrayList<ArticleBizOrder>();
        VasOrderSearchResponse10124_10587 resp = this.getOrderList(articleCode, beginTime, endTime, 1, 200);
        int total = resp.getTotalItem();
        itemList.addAll(resp.getOrderList());
        int i = 2;
        while (i <= (total - 1) / 200 + 1) {
            Thread.sleep(10000L);
            VasOrderSearchResponse10124_10587 tempResp = this.getOrderList(articleCode, beginTime, endTime, i, 200);
            itemList.addAll(tempResp.getOrderList());
            ++i;
        }
        return itemList;
    }

    public VasOrderSearchResponse10124_10587 getOrderList(String articleCode, String beginTime, String endTime, int pageNo, int pageSize) throws Exception {
        VasOrderSearchRequest10124_10587 req = new VasOrderSearchRequest10124_10587();
        req.setArticleCode(articleCode);
        req.setStartCreated(beginTime);
        req.setEndCreated(endTime);
        req.setPageNo(pageNo);
        req.setPageSize(pageSize);
        VasOrderSearchResponse10124_10587 resp = TaobaoService.invokeTaobaoService(req);
        if (!resp.isSuccess()) {
            throw new Exception("\u67e5\u8be2\u8ba2\u8d2d\u5173\u7cfb\u8bb0\u5f55\u5f02\u5e38:" + resp.toString());
        }
        return resp;
    }

    public FuwuSaleLinkGenResponse10124_2164 getFuwuSaleLinkGenUrl(String nick, String param_str) {
        FuwuSaleLinkGenRequest10124_2164 req = new FuwuSaleLinkGenRequest10124_2164();
        req.setNick(nick);
        req.setParamStr(param_str);
        return TaobaoService.invokeTaobaoService(req);
    }
}

