/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.service;

import java.util.ArrayList;
import net.redxyz.top.TaobaoService;
import net.redxyz.top.data.trade.Trade;
import net.redxyz.top.message.trade.TradeFullinfoGetRequest5_54;
import net.redxyz.top.message.trade.TradeFullinfoGetRequest5_54_Rate;
import net.redxyz.top.message.trade.TradeFullinfoGetResponse5_54;
import net.redxyz.top.message.trade.TradeFullinfoGetResponse5_54_Rate;
import net.redxyz.top.message.trade.TradeGetRequest5_47;
import net.redxyz.top.message.trade.TradeGetResponse5_47;
import net.redxyz.top.message.trade.TradesSoldIncrementGetRequest5_128;
import net.redxyz.top.message.trade.TradesSoldIncrementGetResponse5_128;
import net.redxyz.top.zfnshop.Trade_Zfnshop;
import net.redxyz.top.zfnshop.TradesSoldGetRequest5_46_Zfnshop;
import net.redxyz.top.zfnshop.TradesSoldGetResponse5_46_Zfnshop;
import org.zhiqim.kernel.util.DateTimes;

public class TaobaoTradeService {
    public TradeGetResponse5_47 getTradeSimpleInfo(String nick, String sessionId, long tid) {
        TradeGetRequest5_47 req = new TradeGetRequest5_47();
        req.setNick(nick);
        req.setSession(sessionId);
        req.setTid(tid);
        return TaobaoService.invokeTaobaoService(req);
    }

    public TradeFullinfoGetResponse5_54_Rate getTradeFullinfoRate(String nick, String sessionId, long tid) {
        TradeFullinfoGetRequest5_54_Rate req = new TradeFullinfoGetRequest5_54_Rate();
        req.setNick(nick);
        req.setSession(sessionId);
        req.setTid(tid);
        return TaobaoService.invokeTaobaoService(req);
    }

    public TradeFullinfoGetResponse5_54 getTradeFullinfo(String nick, String sessionId, long tid) {
        TradeFullinfoGetRequest5_54 req = new TradeFullinfoGetRequest5_54();
        req.setNick(nick);
        req.setSession(sessionId);
        req.setTid(tid);
        return TaobaoService.invokeTaobaoService(req);
    }

    public ArrayList<Trade> getTradeIncrementAllList(String nick, String sessionId, String startTime, String endTime) throws Exception {
        return this.getTradeIncrementAllList(nick, sessionId, startTime, endTime, null);
    }

    public ArrayList<Trade> getTradeIncrementAllList(String nick, String sessionId, String startTime, String endTime, String status) throws Exception {
        TradesSoldIncrementGetResponse5_128 resp = this.getTradeIncrement(nick, sessionId, startTime, endTime, status, 1);
        if (!resp.isSuccess()) {
            throw new Exception("\u540c\u6b65\u589e\u91cf\u8ba2\u5355\u65f6\u5f02\u5e38\uff1a" + resp.getErrorMsg());
        }
        ArrayList<Trade> tradeList = new ArrayList<Trade>();
        tradeList.addAll(resp.getTradeList());
        int pageNo = 2;
        while (resp.hasNext()) {
            resp = this.getTradeIncrement(nick, sessionId, startTime, endTime, status, pageNo);
            if (!resp.isSuccess()) {
                if (resp.isConnectionReset()) {
                    resp = this.getTradeIncrement(nick, sessionId, startTime, endTime, status, pageNo);
                } else {
                    throw new Exception("\u540c\u6b65\u589e\u91cf\u8ba2\u5355\u65f6\u5f02\u5e38\uff1a" + resp.getErrorMsg());
                }
            }
            if (!resp.isSuccess()) {
                throw new Exception("\u540c\u6b65\u589e\u91cf\u8ba2\u5355\u65f6\u5f02\u5e38\uff1a" + resp.getErrorMsg());
            }
            tradeList.addAll(resp.getTradeList());
            ++pageNo;
        }
        return tradeList;
    }

    private TradesSoldIncrementGetResponse5_128 getTradeIncrement(String nick, String sessionId, String startTime, String endTime, String status, int pageNo) {
        TradesSoldIncrementGetRequest5_128 req = new TradesSoldIncrementGetRequest5_128();
        req.setNick(nick);
        req.setSession(sessionId);
        req.setStartModified(startTime);
        req.setEndModified(endTime);
        req.setStatus(status);
        req.setPageNo(pageNo);
        req.setUseHasNext(true);
        return TaobaoService.invokeTaobaoService(req);
    }

    public ArrayList<Trade_Zfnshop> getTradeListNoRateAll(String nick, String sessionId, String startTime, boolean isSellerRate) throws Exception {
        String dateTime = DateTimes.getDateTimeString();
        ArrayList<Trade_Zfnshop> tradeList = new ArrayList<Trade_Zfnshop>();
        TradesSoldGetResponse5_46_Zfnshop resp = this.getTradeListRatePage(nick, sessionId, 1, 100, startTime, isSellerRate);
        for (Trade_Zfnshop trade : resp.getTradeList()) {
            if (DateTimes.compareSecond((String)dateTime, (String)trade.getEndTime()) > 1296000) continue;
            tradeList.add(trade);
        }
        int total = resp.getTotalResults();
        int i = 2;
        while (i <= (total - 1) / 200 + 1) {
            TradesSoldGetResponse5_46_Zfnshop tempResp = this.getTradeListRatePage(nick, sessionId, i, 100, startTime, isSellerRate);
            for (Trade_Zfnshop trade : tempResp.getTradeList()) {
                if (DateTimes.compareSecond((String)dateTime, (String)trade.getEndTime()) > 1296000) continue;
                tradeList.add(trade);
            }
            ++i;
        }
        return tradeList;
    }

    public TradesSoldGetResponse5_46_Zfnshop getTradeListRatePage(String nick, String sessionId, int pageNo, int pageSzie, String startTime, boolean isSellerRate) throws Exception {
        TradesSoldGetRequest5_46_Zfnshop req = new TradesSoldGetRequest5_46_Zfnshop();
        req.setSession(sessionId);
        req.setNick(nick);
        req.setPageNo(pageNo);
        req.setPageSize(pageSzie);
        if (isSellerRate) {
            req.setRateStatus("RATE_BUYER_SELLER");
        } else {
            req.setRateStatus("RATE_BUYER_UNSELLER");
        }
        String preDate30 = DateTimes.getPreviousDateTimeString((int)30);
        if (startTime.compareTo(preDate30) < 0) {
            startTime = preDate30;
        }
        req.setStartCreated(startTime);
        TradesSoldGetResponse5_46_Zfnshop resp = TaobaoService.invokeTaobaoService(req);
        if (!resp.isSuccess()) {
            throw new Exception("\u67e5\u8be2\u5b9d\u8d1d\u4ea4\u6613\u6570\u636e\u5217\u8868\u65f6\u5f02\u5e38:" + resp);
        }
        return resp;
    }
}

