/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.security;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.redxyz.top.security.Base64;
import net.redxyz.top.security.SecretException;

public abstract class SecretUtil {
    private static final byte[] IV_BYTES = "0102030405060708".getBytes();
    private static final String AES = "AES";
    private static final String MAC_HMAC_MD5 = "HmacMD5";
    private static final String CHARSET_UTF8 = "UTF-8";

    private SecretUtil() {
    }

    public static String aesEncrypt(String content, byte[] encryptKey) throws SecretException {
        try {
            return SecretUtil.aesEncrypt(content.getBytes(CHARSET_UTF8), encryptKey);
        }
        catch (Exception e) {
            throw new SecretException(e);
        }
    }

    public static String aesDecrypt(String content, byte[] decryptKey) throws SecretException {
        try {
            return new String(SecretUtil.aesDecrypt(content.getBytes(CHARSET_UTF8), decryptKey), CHARSET_UTF8);
        }
        catch (Exception e) {
            throw new SecretException(e);
        }
    }

    public static byte[] aesDecrypt(byte[] encryptBytes, byte[] decryptKey) throws SecretException {
        IvParameterSpec iv = new IvParameterSpec(IV_BYTES);
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(2, (Key)new SecretKeySpec(decryptKey, AES), iv);
            return cipher.doFinal(Base64.decode(encryptBytes));
        }
        catch (Exception e) {
            throw new SecretException(e);
        }
    }

    public static String aesEncrypt(byte[] content, byte[] encryptKey) throws SecretException {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(AES);
            kgen.init(new SecureRandom(encryptKey));
            IvParameterSpec iv = new IvParameterSpec(IV_BYTES);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)new SecretKeySpec(encryptKey, AES), iv);
            return SecretUtil.base64Encode(cipher.doFinal(content));
        }
        catch (Exception e) {
            throw new SecretException(e);
        }
    }

    public static String base64Encode(byte[] src) {
        try {
            return SecretUtil.base64Encode(src, CHARSET_UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String base64Encode(byte[] src, String charsetName) throws UnsupportedEncodingException {
        byte[] res = Base64.encodeToByte(src, false);
        return src != null ? new String(res, charsetName) : null;
    }

    public static String hmacMD5EncryptToBase64(String encryptText, byte[] encryptKey, int compressLen) throws SecretException {
        try {
            return SecretUtil.base64Encode(SecretUtil.compress(SecretUtil.hmacMD5Encrypt(encryptText, encryptKey), compressLen));
        }
        catch (Exception e) {
            throw new SecretException(e);
        }
    }

    public static String hmacMD5EncryptToBase64(String encryptText, byte[] encryptKey) throws SecretException {
        try {
            return SecretUtil.base64Encode(SecretUtil.hmacMD5Encrypt(encryptText, encryptKey));
        }
        catch (Exception e) {
            throw new SecretException(e);
        }
    }

    public static byte[] hmacMD5Encrypt(String encryptText, byte[] encryptKey) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(encryptKey, MAC_HMAC_MD5);
        Mac mac = Mac.getInstance(MAC_HMAC_MD5);
        mac.init(secretKey);
        byte[] text = encryptText.getBytes(CHARSET_UTF8);
        return mac.doFinal(text);
    }

    public static List<String> getSlideWindows(String input, int slideSize) {
        ArrayList<String> windows = new ArrayList<String>();
        int startIndex = 0;
        int endIndex = 0;
        int currentWindowSize = 0;
        String currentWindow = null;
        while (endIndex < input.length() || currentWindowSize > slideSize) {
            boolean startsWithLetterOrDigit = currentWindow == null ? false : SecretUtil.isLetterOrDigit(currentWindow.charAt(0));
            if (endIndex == input.length() && !startsWithLetterOrDigit) break;
            if (currentWindowSize == slideSize && !startsWithLetterOrDigit && SecretUtil.isLetterOrDigit(input.charAt(endIndex))) {
                currentWindow = input.substring(startIndex, ++endIndex);
                currentWindowSize = 5;
            } else {
                if (endIndex != 0) {
                    currentWindowSize = startsWithLetterOrDigit ? --currentWindowSize : (currentWindowSize -= 2);
                    ++startIndex;
                }
                while (currentWindowSize < slideSize && endIndex < input.length()) {
                    char currentChar = input.charAt(endIndex);
                    currentWindowSize = SecretUtil.isLetterOrDigit(currentChar) ? ++currentWindowSize : (currentWindowSize += 2);
                    ++endIndex;
                }
                currentWindow = input.substring(startIndex, endIndex);
            }
            windows.add(currentWindow);
        }
        return windows;
    }

    private static boolean isLetterOrDigit(char x) {
        return x >= '\u0000' && x <= '\u007f';
    }

    private static byte[] compress(byte[] input, int toLength) {
        if (toLength < 0) {
            return null;
        }
        byte[] output = new byte[toLength];
        int i = 0;
        while (i < output.length) {
            output[i] = 0;
            ++i;
        }
        i = 0;
        while (i < input.length) {
            int index_output;
            int n = index_output = i % toLength;
            output[n] = (byte)(output[n] ^ input[i]);
            ++i;
        }
        return output;
    }

    public static boolean isNumeric(Object obj) {
        if (obj == null) {
            return false;
        }
        char[] chars = obj.toString().toCharArray();
        int length = chars.length;
        if (length < 1) {
            return false;
        }
        int i = 0;
        if (length > 1 && chars[0] == '-') {
            i = 1;
        }
        while (i < length) {
            if (!Character.isDigit(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String[] split(String str, char separatorChar) {
        return SecretUtil.splitWorker(str, separatorChar, false);
    }

    private static String[] splitWorker(String str, char separatorChar, boolean preserveAllTokens) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match || preserveAllTokens) {
                    list.add(str.substring(start, i));
                    match = false;
                    lastMatch = true;
                }
                start = ++i;
                continue;
            }
            lastMatch = false;
            match = true;
            ++i;
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }
}

