/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.security;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class LruHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private int maxCapacity;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final Lock lock = new ReentrantLock();

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(int maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public LruHashMap(int maxCapacity) {
        super(maxCapacity, 0.75f, true);
        this.maxCapacity = maxCapacity;
    }

    public LruHashMap(int initialCapacity, int maxCapacity) {
        super(initialCapacity, 0.75f, true);
        this.maxCapacity = maxCapacity;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxCapacity;
    }

    @Override
    public V get(Object key) {
        try {
            this.lock.lock();
            Object v = super.get(key);
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public V put(K key, V value) {
        try {
            this.lock.lock();
            V v = super.put(key, value);
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public V remove(Object key) {
        try {
            this.lock.lock();
            Object v = super.remove(key);
            return v;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        try {
            this.lock.lock();
            super.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public Map<K, V> cloneEntry() {
        HashMap targetMap = new HashMap();
        try {
            this.lock.lock();
            for (Map.Entry entry : super.entrySet()) {
                targetMap.put(entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.lock.unlock();
        }
        return targetMap;
    }
}

