/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.portal.model;

import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.Urls;
import org.zhiqim.kernel.util.Validates;

public class SessionToken {
    private String token;
    private String userId;
    private String nick;
    private String sessionId;
    private int expiresIn;
    private int expiresInR1;
    private int expiresInR2;
    private int expiresInW1;
    private int expiresInW2;
    private String refreshToken;
    private int reExpiresIn;
    private String subNick;

    public static SessionToken parseSessionToken(String token) {
        token = Urls.decodeUTF8((String)token);
        token = Jsons.removeBlankSpace((String)token);
        SessionToken sessionToken = new SessionToken();
        sessionToken.token = token;
        sessionToken.userId = Jsons.getString((String)token, (String)"taobao_user_id");
        sessionToken.nick = Jsons.getString((String)token, (String)"taobao_user_nick");
        sessionToken.sessionId = Jsons.getString((String)token, (String)"access_token");
        sessionToken.expiresIn = Jsons.getInt((String)token, (String)"expires_in");
        sessionToken.expiresInR1 = Jsons.getInt((String)token, (String)"r1_expires_in");
        sessionToken.expiresInR2 = Jsons.getInt((String)token, (String)"r2_expires_in");
        sessionToken.expiresInW1 = Jsons.getInt((String)token, (String)"w1_expires_in");
        sessionToken.expiresInW2 = Jsons.getInt((String)token, (String)"w2_expires_in");
        sessionToken.refreshToken = Jsons.getString((String)token, (String)"refresh_token");
        sessionToken.reExpiresIn = Jsons.getInt((String)token, (String)"re_expires_in");
        sessionToken.subNick = Jsons.getString((String)token, (String)"sub_taobao_user_nick");
        return sessionToken;
    }

    public String toString() {
        return this.token;
    }

    public boolean isInValid() {
        return Validates.isEmpty((String)this.userId) || Validates.isEmpty((String)this.nick);
    }

    public boolean isInValidParam() {
        return Validates.isEmpty((String)this.sessionId) || Validates.isEmpty((String)this.refreshToken) || this.expiresIn == -1 || this.expiresInR1 == -1 || this.expiresInW1 == -1 || this.reExpiresIn == -1;
    }

    public boolean hasSubNick() {
        return Validates.isNotEmpty((String)this.subNick);
    }

    public String getNickLogined() {
        return this.hasSubNick() ? this.subNick : this.nick;
    }

    public String getToken() {
        return this.token;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getNick() {
        return this.nick;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int getExpiresIn() {
        return this.expiresIn;
    }

    public int getExpiresInR1() {
        return this.expiresInR1;
    }

    public int getExpiresInR2() {
        return this.expiresInR2;
    }

    public int getExpiresInW1() {
        return this.expiresInW1;
    }

    public int getExpiresInW2() {
        return this.expiresInW2;
    }

    public void setExpiresInW2(int expiresInW2) {
        this.expiresInW2 = expiresInW2;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public int getReExpiresIn() {
        return this.reExpiresIn;
    }

    public String getSubNick() {
        return this.subNick;
    }
}

