/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.portal.model;

import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.paging.PageResult;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"QnPage"})
public class QnPage {
    public static String toQnHtmlLink5(PageResult<?> result, String link) {
        return QnPage.toQnHtmlLink(result, link, 5);
    }

    public static String toQnHtmlLink(PageResult<?> result, String link, int segmentSize) {
        String absLink = String.valueOf(link) + result.getConditionUrl();
        absLink = Validates.isNotEmpty((String)result.getConditionUrl()) ? String.valueOf(absLink) + "&" : String.valueOf(absLink) + "?";
        int lBound = result.getLSegmentNo(segmentSize);
        int rBound = result.getRSegmentNo(segmentSize);
        StringBuffer strb = new StringBuffer();
        strb.append("<div class=\"sui-pagination pagination-large  pagination-right\" style=\"float:right;margin-top:2px;margin-bottom:2px;\" >");
        strb.append("<ul>");
        if (result.hasLSegment(segmentSize)) {
            strb.append("<li class=\"prev\"><a href=\"" + absLink + "page=" + (lBound - 1) + "\">\u00ab</a></li>");
        }
        int i = lBound;
        while (i < rBound) {
            if (result.pageNo() != i) {
                strb.append("<li><a  href=\"" + absLink + "page=" + i + "\">" + i + "</a></li>");
            } else {
                strb.append("<li  class=\"active\"><a  href=\"#\">" + i + "</a></li>");
            }
            ++i;
        }
        if (result.hasRSegment(segmentSize)) {
            strb.append(" <li class=\"next\"><a href=\"" + absLink + "page=" + rBound + "\">\u00bb</a></li>");
        }
        strb.append("</ul></div>");
        return strb.toString();
    }

    public static String toQnClick5(PageResult<?> result, String jsMethod) {
        return QnPage.toQnClick(result, jsMethod, 5);
    }

    public static String toQnClick(PageResult<?> result, String jsMethod, int segmentSize) {
        int lBound = result.getLSegmentNo(segmentSize);
        int rBound = result.getRSegmentNo(segmentSize);
        StringBuffer strb = new StringBuffer();
        strb.append("<div class=\"sui-pagination pagination-large pagination-right \" style=\"margin-top:2px;margin-bottom:2px;\" >");
        strb.append("<ul>");
        if (result.hasLSegment(segmentSize)) {
            strb.append("<li class=\"prev\"><a  href=\"javascript:void(0);\" onclick=\"" + jsMethod + "('" + (lBound - 1) + "'); \">\u00ab</a></li>");
        }
        int i = lBound;
        while (i < rBound) {
            if (result.pageNo() != i) {
                strb.append("<li><a   href=\"javascript:void(0);\" onclick=\"" + jsMethod + "('" + i + "'); \">" + i + "</a></li>");
            } else {
                strb.append("<li  class=\"active\"><a  href=\"javascript:void(0);\">" + i + "</a></li>");
            }
            ++i;
        }
        if (result.hasRSegment(segmentSize)) {
            strb.append(" <li class=\"next\"><a href=\"javascript:void(0);\" onclick=\"" + jsMethod + "('" + rBound + "'); \">\u00bb</a></li>");
        }
        strb.append("</ul></div>");
        return strb.toString();
    }
}

