/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.portal.actionpc.item;

import java.util.ArrayList;
import java.util.List;
import net.redxyz.top.TaobaoService;
import net.redxyz.top.data.item.Sku;
import net.redxyz.top.message.item.ItemSellerGetResponse4_24625_Sku;
import net.redxyz.top.portal.SessionUser;
import net.redxyz.top.service.SkuUtil;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.context.annotation.AnIntercept;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.util.Validates;

public class PcItemNumModifyAction
implements Action {
    public void execute(HttpRequest request) throws Exception {
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String sessionId = sessionUser.getSessionId();
        String nick = sessionUser.getNick();
        long numIid = request.getParameterLong("numIid");
        request.setAttribute("numIid", (Object)numIid);
        ItemSellerGetResponse4_24625_Sku resp = TaobaoService.getItemService().getItemSku(nick, sessionId, numIid);
        if (!resp.isSuccess()) {
            request.returnCloseDialog(resp.getErrorMsg());
            return;
        }
        int num = resp.getNum();
        String title = resp.getTitle();
        String picUrl = resp.getPicUrl();
        List<Sku> skuList = null;
        boolean isSku = false;
        if (Validates.isNotEmpty((String)resp.getSkus())) {
            skuList = resp.getSkuList();
            sessionUser.setValue("skuList", skuList);
            isSku = true;
        }
        if (skuList == null) {
            skuList = new ArrayList<Sku>();
        }
        request.setAttribute("skuList", skuList);
        request.setAttribute("curNum", (Object)num);
        request.setAttribute("curTitle", (Object)title);
        request.setAttribute("picUrl", (Object)picUrl);
        request.setAttribute("isSku", (Object)isSku);
    }

    @AnIntercept(value={"chkAjax"})
    public void updateSku(HttpRequest request, long skuId, int quantity) {
        if (quantity <= 0) {
            request.setResponseError("\u5e93\u5b58\u6570\u5fc5\u987b\u5927\u4e8e0");
            return;
        }
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        List skuList = (List)sessionUser.getValue("skuList");
        Sku sku = SkuUtil.getSku(skuList, skuId);
        if (sku == null) {
            request.setResponseError("\u8be5SKU\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539");
            return;
        }
        sku.setQuantity(quantity);
    }
}

