/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.portal.action.select;

import net.redxyz.top.TaobaoService;
import net.redxyz.top.message.picture.PictureUploadResponse;
import net.redxyz.top.portal.SessionUser;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpUploader;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.util.Validates;

public class UploadPictureExecAction
implements Action {
    public void execute(HttpRequest request) throws Exception {
        SessionUser sessionUser = (SessionUser)request.getSessionUser(SessionUser.class);
        String nick = sessionUser.getNick();
        String sessionId = sessionUser.getSessionId();
        try (HttpUploader upload = new HttpUploader();){
            int maxSize = 0x100000;
            upload.parseHttpRequest(request, maxSize);
            long pictureCategoryId = Long.parseLong(upload.getParameter("pictureCategoryId"));
            String imgName = upload.getFileName();
            String fileExt = upload.getFileExt();
            byte[] bytes = upload.getBytes();
            if (Validates.isEmpty((String)fileExt) || fileExt.lastIndexOf("png") == -1 && fileExt.lastIndexOf("jpg") == -1 && fileExt.lastIndexOf("jpeg") == -1) {
                request.setAttribute("json", (Object)this.getError("\u8bf7\u91cd\u65b0\u9009\u62e9\u6b63\u786e\u7684\u56fe\u7247\u4e0a\u4f20"));
                return;
            }
            PictureUploadResponse uploadResp = TaobaoService.getPictureService().uploadPicture(nick, sessionId, pictureCategoryId, fileExt, imgName, bytes, 0);
            if (!uploadResp.isSuccess()) {
                request.setAttribute("json", (Object)this.getError(uploadResp.getErrorMsg()));
                return;
            }
            try {
                String imgUrl = uploadResp.getPicturePath();
                String str = "{\"error\":0,\"url\":\"" + imgUrl + "\"}";
                request.setAttribute("json", (Object)str);
            }
            catch (Exception e) {
                request.setResponseError("\u4e0a\u4f20\u5f02\u5e38:" + e.getMessage());
            }
        }
    }

    private String getError(String message) {
        return "{\"error\":1,\"message\":\"" + message + "\"}";
    }
}

