/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top.portal.action;

import java.io.IOException;
import net.redxyz.top.TaobaoService;
import net.redxyz.top.dbo.user.UserGift;
import net.redxyz.top.portal.SessionUser;
import org.zhiqim.httpd.HttpRequest;
import org.zhiqim.httpd.HttpResponse;
import org.zhiqim.httpd.HttpdConstants;
import org.zhiqim.httpd.context.core.Action;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Strings;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.orm.ZTable;
import org.zhiqim.orm.dbo.Selector;

public class LoginAction
implements Action,
HttpdConstants {
    protected static final Log log = LogFactory.getLog(LoginAction.class);
    protected String fuwuUrl = TaobaoService.getFuwuUrl(Global.getString((String)"taobao", (String)"articleCode"));

    public void execute(HttpRequest request) throws Exception {
        HttpResponse response = request.getResponse();
        if (this.hasError(request, response)) {
            return;
        }
        if (this.isTaobaoChk(request, response)) {
            return;
        }
        if (Global.isTrue((String)"project", (String)"upgrade")) {
            response.sendRedirect("/upgrade.htm");
            return;
        }
        String from = request.getParameter("from", null);
        if ("qianniupc".equals(from)) {
            String instance = request.getParameter("instance");
            if (!Strings.contains((String)instance, (CharSequence)"_attach_")) {
                request.forwardTo("/loginPc.htm");
            } else {
                String event = request.getParameter("event");
                request.forwardTo("/openAttachWindow.htm?event=" + event);
            }
        } else if ("qianniuAndroid".equals(from) || "qianniuIphone".equals(from)) {
            request.forwardTo("/loginMobile.htm");
        } else {
            request.forwardTo("/loginWeb.htm");
        }
    }

    protected boolean hasError(HttpRequest request, HttpResponse response) throws IOException {
        String error = request.getParameter("error", null);
        String error_description = request.getParameter("error_description", null);
        if (Validates.isNotEmpty((String)error) || Validates.isNotEmpty((String)error_description)) {
            log.error((Object)("\u8bfb\u53d6OAuth\u65f6\u5931\u8d25:error=" + error));
            response.sendRedirect(this.fuwuUrl);
            return true;
        }
        return false;
    }

    protected boolean isTaobaoChk(HttpRequest request, HttpResponse response) throws IOException {
        String code = request.getParameter("code", null);
        String state = request.getParameterNoFilter("state", "");
        String userAgent = request.getHeader("User-Agent");
        if (Validates.isEmpty((String)state) && (Validates.isEmpty((String)userAgent) || userAgent.indexOf("(X11; Linux i686)") != -1)) {
            log.info((Object)("\u6dd8\u5b9d\u6d4b\u8bd5\uff0ccode=" + code + ";state=" + state + ";userAgent=" + userAgent));
            response.sendRedirect(this.fuwuUrl);
            return true;
        }
        return false;
    }

    public static void chkGift(SessionUser sessionUser, String nick, int versionNo) throws Exception {
        Selector selector = new Selector();
        selector.addMust("nick", (Object)nick);
        selector.addMaybe("status", (Object)1);
        selector.addMaybeThenGE("versionNo", (Object)versionNo);
        selector.addMaybeThenG("endDate", (Object)DateTimes.getDateString());
        selector.addOrderbyDesc("endDate");
        UserGift userGift = (UserGift)((ZTable)Global.get(ZTable.class)).item(UserGift.class, selector);
        if (userGift != null) {
            sessionUser.setGift(true);
            sessionUser.setGiftVersionNo(userGift.getVersionNo());
            sessionUser.setGiftStartDate(userGift.getBeginDate());
            sessionUser.setGiftEndDate(userGift.getEndDate());
        }
    }
}

