/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.top;

import java.util.HashMap;
import java.util.TreeMap;
import net.redxyz.top.TaobaoErrHandler;
import net.redxyz.top.TaobaoInterface;
import net.redxyz.top.TaobaoServer;
import net.redxyz.top.message.TaobaoRequest;
import net.redxyz.top.message.TaobaoResponse;
import net.redxyz.top.service.BenefitService;
import net.redxyz.top.service.CoinService;
import net.redxyz.top.service.FlowService;
import net.redxyz.top.service.QnTaskService;
import net.redxyz.top.service.QnTradeService;
import net.redxyz.top.service.TaobaoCouponService;
import net.redxyz.top.service.TaobaoFenxiaoService;
import net.redxyz.top.service.TaobaoFuwuService;
import net.redxyz.top.service.TaobaoItemService;
import net.redxyz.top.service.TaobaoItemcatService;
import net.redxyz.top.service.TaobaoJushitaService;
import net.redxyz.top.service.TaobaoPictureService;
import net.redxyz.top.service.TaobaoQimenService;
import net.redxyz.top.service.TaobaoRefundService;
import net.redxyz.top.service.TaobaoRoleService;
import net.redxyz.top.service.TaobaoShopService;
import net.redxyz.top.service.TaobaoTmallService;
import net.redxyz.top.service.TaobaoTmcService;
import net.redxyz.top.service.TaobaoTongxueService;
import net.redxyz.top.service.TaobaoToolService;
import net.redxyz.top.service.TaobaoTradeService;
import net.redxyz.top.service.TaobaoTraderateService;
import net.redxyz.top.service.TaobaoUserService;
import net.redxyz.top.service.TaobaoVasService;
import net.redxyz.top.service.TaobaoXiamiMusicService;
import net.redxyz.top.service.UmpBuilder;
import net.redxyz.top.service.WirelessService;
import org.zhiqim.kernel.Global;
import org.zhiqim.kernel.annotation.AnAlias;
import org.zhiqim.kernel.extend.HashMapSO;
import org.zhiqim.kernel.httpclient.HttpResult;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.Asserts;
import org.zhiqim.kernel.util.Urls;
import org.zhiqim.kernel.util.Validates;

@AnAlias(value={"TaobaoService"})
public class TaobaoService {
    private static final String EXCEPTION = "\u672a\u6ce8\u518c\u6dd8\u5b9d\u63a5\u53e3\u670d\u52a1\u4e0d\u5141\u8bb8\u8c03\u7528";
    private static TaobaoServer server;

    public static void register(TaobaoServer parameter) {
        TaobaoService.register(parameter, null);
    }

    public static void register(TaobaoServer tbServer, TaobaoErrHandler handler) {
        server = tbServer;
    }

    public static TaobaoServer getServer() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return server;
    }

    public static boolean isValid() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return ((TaobaoInterface)Global.get(TaobaoInterface.class)).isValid();
    }

    public static String getFuwuUrl(String articleCode) {
        return "http://fuwu.taobao.com/ser/detail.htm?service_code=" + articleCode;
    }

    public static String getAccreditUrl() {
        return TaobaoService.getAccreditUrl("normal");
    }

    public static String getAccreditUrl(String state) {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("response_type", "code");
        paramMap.put("client_id", server.getAppKey());
        paramMap.put("redirect_uri", server.getAppRedirectUrl());
        paramMap.put("state", state);
        paramMap.put("view", "web");
        if (!Validates.isEmpty((String)server.getAppScope())) {
            paramMap.put("scope", server.getAppScope());
        }
        String queryString = Urls.toSignString(paramMap);
        return server.getAppAuthorizeUrl() + "?" + queryString;
    }

    public static String getAccreditPcUrl() {
        return TaobaoService.getAccreditPcUrl("normal");
    }

    public static String getAccreditPcUrl(String state) {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("response_type", "code");
        paramMap.put("client_id", server.getAppKey());
        paramMap.put("redirect_uri", server.getPcRedirectUrl());
        paramMap.put("state", state);
        paramMap.put("view", "web");
        if (!Validates.isEmpty((String)server.getAppScope())) {
            paramMap.put("scope", server.getAppScope());
        }
        String queryString = Urls.toSignString(paramMap);
        return server.getAppAuthorizeUrl() + "?" + queryString;
    }

    public static String getAccreditWapUrl() {
        return TaobaoService.getAccreditWapUrl("normal");
    }

    public static String getAccreditWapUrl(String state) {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("response_type", "code");
        paramMap.put("client_id", server.getAppKey());
        paramMap.put("redirect_uri", server.getMobileRedirectUrl());
        paramMap.put("state", state);
        paramMap.put("view", "wap");
        if (!Validates.isEmpty((String)server.getAppScope())) {
            paramMap.put("scope", server.getAppScope());
        }
        String queryString = Urls.toSignString(paramMap);
        return server.getAppAuthorizeUrl() + "?" + queryString;
    }

    public static HttpResult authorizationCode(String code, String state) {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("client_id", server.getAppKey());
        paramMap.put("client_secret", server.getAppSecret());
        paramMap.put("grant_type", "authorization_code");
        paramMap.put("code", code);
        paramMap.put("redirect_uri", server.getAppRedirectUrl());
        paramMap.put("state", state);
        paramMap.put("view", "web");
        if (!Validates.isEmpty((String)server.getAppScope())) {
            paramMap.put("scope", server.getAppScope());
        }
        String queryString = Urls.toSignString(paramMap);
        return ((TaobaoInterface)Global.get(TaobaoInterface.class)).invokeToken(queryString);
    }

    public static HttpResult refreshToken(String refreshToken) {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        TreeMap<String, String> paramMap = new TreeMap<String, String>();
        paramMap.put("client_id", server.getAppKey());
        paramMap.put("client_secret", server.getAppSecret());
        paramMap.put("grant_type", "refresh_token");
        paramMap.put("refresh_token", refreshToken);
        paramMap.put("view", "web");
        if (!Validates.isEmpty((String)server.getAppScope())) {
            paramMap.put("scope", server.getAppScope());
        }
        String queryString = Urls.toSignString(paramMap);
        return ((TaobaoInterface)Global.get(TaobaoInterface.class)).invokeToken(queryString);
    }

    public static HttpResult invokeToken(String queryString) {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return ((TaobaoInterface)Global.get(TaobaoInterface.class)).invokeToken(queryString);
    }

    public static <T extends TaobaoResponse> T invokeTaobaoService(TaobaoRequest<T> req) {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return ((TaobaoInterface)Global.get(TaobaoInterface.class)).invokeTaobaoService(req);
    }

    public static <T extends TaobaoResponse> T invokeTaobaoSecretService(TaobaoRequest<T> req) {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return ((TaobaoInterface)Global.get(TaobaoInterface.class)).invokeTaobaoSecretService(req);
    }

    public static String invokeTaobaoService(String queryString) {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return ((TaobaoInterface)Global.get(TaobaoInterface.class)).invokeTaobaoService(queryString);
    }

    public static String invokeTaobaoPageGet(HashMapSO paramMap) {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return ((TaobaoInterface)Global.get(TaobaoInterface.class)).invokeTaobaoPageGet(paramMap);
    }

    public static String invokeTaobaoService(String name, String fileName, String mimeType, byte[] fileContent, String queryString) {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return ((TaobaoInterface)Global.get(TaobaoInterface.class)).invokeTaobaoService(name, fileName, mimeType, fileContent, queryString);
    }

    public static <T extends TaobaoResponse> T invokeSearch(TaobaoRequest<T> req) {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return ((TaobaoInterface)Global.get(TaobaoInterface.class)).invokeSearch(req);
    }

    public static TaobaoToolService getToolService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (TaobaoToolService)Global.get(TaobaoToolService.class);
    }

    public static TaobaoShopService getShopService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (TaobaoShopService)Global.get(TaobaoShopService.class);
    }

    public static TaobaoUserService getUserService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (TaobaoUserService)Global.get(TaobaoUserService.class);
    }

    public static TaobaoVasService getVasService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (TaobaoVasService)Global.get(TaobaoVasService.class);
    }

    public static TaobaoRoleService getRoleService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (TaobaoRoleService)Global.get(TaobaoRoleService.class);
    }

    public static TaobaoItemcatService getItemcatService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (TaobaoItemcatService)Global.get(TaobaoItemcatService.class);
    }

    public static TaobaoItemService getItemService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (TaobaoItemService)Global.get(TaobaoItemService.class);
    }

    public static TaobaoPictureService getPictureService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (TaobaoPictureService)Global.get(TaobaoPictureService.class);
    }

    public static TaobaoFenxiaoService getFenxiaoService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (TaobaoFenxiaoService)Global.get(TaobaoFenxiaoService.class);
    }

    public static TaobaoTmallService getTmallService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (TaobaoTmallService)Global.get(TaobaoTmallService.class);
    }

    public static TaobaoTmcService getTmcService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (TaobaoTmcService)Global.get(TaobaoTmcService.class);
    }

    public static TaobaoTradeService getTradeService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (TaobaoTradeService)Global.get(TaobaoTradeService.class);
    }

    public static TaobaoTraderateService getTraderateService() {
        if (server == null) {
            throw new RuntimeException(EXCEPTION);
        }
        return (TaobaoTraderateService)Global.get(TaobaoTraderateService.class);
    }

    public static TaobaoRefundService getRefundService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (TaobaoRefundService)Global.get(TaobaoRefundService.class);
    }

    public static QnTaskService getQnTaskService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (QnTaskService)Global.get(QnTaskService.class);
    }

    public static QnTradeService getQnTradeService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (QnTradeService)Global.get(QnTradeService.class);
    }

    public static BenefitService getBenefitService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (BenefitService)Global.get(BenefitService.class);
    }

    public static TaobaoCouponService getCouponService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (TaobaoCouponService)Global.get(TaobaoCouponService.class);
    }

    public static TaobaoTongxueService getTongxueService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (TaobaoTongxueService)Global.get(TaobaoTongxueService.class);
    }

    public static TaobaoXiamiMusicService getXiamiMusicService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (TaobaoXiamiMusicService)Global.get(TaobaoXiamiMusicService.class);
    }

    public static UmpBuilder getUmpBuilder() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (UmpBuilder)Global.get(UmpBuilder.class);
    }

    public static WirelessService getWirelessService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (WirelessService)Global.get(WirelessService.class);
    }

    public static CoinService getCoinService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (CoinService)Global.get(CoinService.class);
    }

    public static FlowService getFlowService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (FlowService)Global.get(FlowService.class);
    }

    public static TaobaoJushitaService getJushitaService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (TaobaoJushitaService)Global.get(TaobaoJushitaService.class);
    }

    public static TaobaoFuwuService getTaobaoFuwuService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (TaobaoFuwuService)Global.get(TaobaoFuwuService.class);
    }

    public static TaobaoQimenService getQimenService() {
        Asserts.assertNotNull((Object)((Object)server), (String)EXCEPTION);
        return (TaobaoQimenService)Global.get(TaobaoQimenService.class);
    }

    public static String getItemPromotion(long itemId, String srcPrice) {
        String url = "http://h5api.m.taobao.com/h5/mtop.taobao.detail.getdetail/6.0/?data=";
        HashMap<String, String> urlParamMap = new HashMap<String, String>();
        urlParamMap.put("itemNumId", String.valueOf(itemId));
        String urlParams = Jsons.toString(urlParamMap);
        url = String.valueOf(url) + Urls.encodeUTF8((String)urlParams);
        HashMapSO paramMap = new HashMapSO();
        paramMap.put("url", (Object)url);
        paramMap.put("referer", (Object)"http://www.taobao.com/");
        paramMap.put("host", (Object)"h5api.m.taobao.com");
        String json = TaobaoService.invokeTaobaoPageGet(paramMap);
        if (Validates.isEmpty((String)json)) {
            return null;
        }
        String data = Jsons.getString((String)json, (String)"data");
        if (Validates.isEmpty((String)data)) {
            return null;
        }
        String apiStack = Jsons.getString((String)data, (String)"apiStack");
        if (Validates.isEmpty((String)apiStack)) {
            return null;
        }
        String sku2info = Jsons.getString((String)(apiStack = apiStack.replace("\\", "")), (String)"sku2info");
        if (Validates.isEmpty((String)sku2info)) {
            return srcPrice;
        }
        HashMapSO skuInfoMap = Jsons.toMapSO((String)sku2info);
        String sku0 = skuInfoMap.get("0").toString();
        String price = Jsons.getString((String)sku0, (String)"priceText");
        return price;
    }

    public static void main(String[] args) {
        long itemId = 530843297545L;
        TaobaoService.getItemPromotion(itemId, "1.00");
    }
}

