/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.order.client;

import java.util.Map;
import java.util.TreeMap;
import net.redxyz.order.client.RestClientConstants;
import net.redxyz.order.client.RestClientResponse;
import org.zhiqim.kernel.json.Jsons;
import org.zhiqim.kernel.util.DateTimes;
import org.zhiqim.kernel.util.Urls;
import org.zhiqim.kernel.util.Validates;
import org.zhiqim.kernel.util.codes.MD5;

public abstract class RestClientRequest<T extends RestClientResponse>
implements RestClientConstants {
    private String method;
    private String timestamp;
    private String sign;
    private TreeMap<String, String> paramMap = new TreeMap();

    public RestClientRequest() {
        this.method = this.getMethod();
        this.timestamp = DateTimes.getDateTimeString();
    }

    public abstract String getMethod();

    public abstract T newResponse();

    protected abstract void buildSignBody();

    protected void addParam(String key, int value) {
        if (value == 0) {
            return;
        }
        this.paramMap.put(key, "" + value);
    }

    protected void addParam(String key, long value) {
        if (value == 0L) {
            return;
        }
        this.paramMap.put(key, "" + value);
    }

    protected void addParam(String key, String value) {
        if (Validates.isEmpty((String)value)) {
            return;
        }
        this.paramMap.put(key, value);
    }

    protected void addParam(String key, boolean value) {
        this.paramMap.put(key, "" + value);
    }

    protected void addParam(String key, Object value) {
        if (value == null) {
            return;
        }
        this.paramMap.put(key, Jsons.toString((Object)value));
    }

    public void buildSign(String nick, String nickSecret) {
        this.addParam("method", this.method);
        this.addParam("timestamp", this.timestamp);
        this.addParam("nick", nick);
        this.buildSignBody();
        StringBuffer strb = new StringBuffer(nickSecret);
        for (Map.Entry<String, String> entry : this.paramMap.entrySet()) {
            strb.append(entry.getKey()).append(entry.getValue());
        }
        strb.append(nickSecret);
        this.sign = MD5.encodeUTF8((String)strb.toString());
    }

    public void buildSign(String nick, String appKey, String appSecret) {
        this.addParam("method", this.method);
        this.addParam("timestamp", this.timestamp);
        this.addParam("appKey", appKey);
        this.addParam("nick", nick);
        this.buildSignBody();
        StringBuffer strb = new StringBuffer(appSecret);
        for (Map.Entry<String, String> entry : this.paramMap.entrySet()) {
            strb.append(entry.getKey()).append(entry.getValue());
        }
        strb.append(appSecret);
        this.sign = MD5.encodeUTF8((String)strb.toString());
    }

    public String buildQueryString() {
        StringBuffer strb = new StringBuffer("sign=").append(this.sign);
        for (Map.Entry<String, String> entry : this.paramMap.entrySet()) {
            String value = Urls.encodeUTF8((String)entry.getValue());
            strb.append("&").append(entry.getKey()).append("=").append(value);
        }
        return strb.toString();
    }

    public String toString() {
        return this.buildQueryString();
    }
}

