/*
 * Decompiled with CFR 0.152.
 */
package net.redxyz.order.client;

import net.redxyz.order.client.RestClientParameter;
import net.redxyz.order.client.RestClientRequest;
import net.redxyz.order.client.RestClientResponse;
import net.redxyz.order.client.order.OrderMemoUpdateRequest;
import net.redxyz.order.client.order.OrderMemoUpdateResponse;
import org.zhiqim.kernel.constants.HttpConstants;
import org.zhiqim.kernel.httpclient.HttpPost;
import org.zhiqim.kernel.logging.Log;
import org.zhiqim.kernel.logging.LogFactory;
import org.zhiqim.kernel.util.Validates;

public class RestClient
implements HttpConstants {
    private static final Log log = LogFactory.getLog(RestClient.class);
    private static final RestClientParameter param = new RestClientParameter();

    public static void setParam(RestClientParameter _param) {
        param.setAppKey(_param.getAppKey());
        param.setAppSecret(_param.getAppSecret());
        param.setRestUrl(_param.getRestUrl());
        param.setNick(_param.getNick());
        param.setNickSecret(_param.getNickSecret());
        param.setConnectTimeout(_param.getConnectTime());
        param.setReadTimeout(_param.getReadTimeout());
    }

    public static <T extends RestClientResponse> T execute(RestClientRequest<T> req) {
        if (param == null || !param.isValid()) {
            throw new RuntimeException("\u672a\u914d\u7f6e\u63a5\u53e3\u53c2\u6570\u6216\u53c2\u6570\u4e0d\u6b63\u786e\u4e0d\u5141\u8bb8\u8c03\u7528");
        }
        T resp = req.newResponse();
        if (Validates.isNotEmpty((String)param.getAppKey())) {
            req.buildSign(param.getNick(), param.getAppKey(), param.getAppSecret());
        } else {
            req.buildSign(param.getNick(), param.getNickSecret());
        }
        String queryString = req.buildQueryString();
        HttpPost conn = new HttpPost(param.getRestUrl());
        conn.setQueryString(queryString, "UTF-8");
        conn.setConnectTimeout(param.getConnectTime());
        conn.setReadTimeout(param.getReadTimeout());
        conn.execute();
        int responseStatus = conn.getResponseStatus();
        String responseText = conn.getResponseText();
        if (responseStatus != 200) {
            log.error((Object)("\u8c03\u7528\u63a5\u53e3HTTP\u9519\u8bef,\u9519\u8bef\u7801[" + responseStatus + "],\u8bf7\u6c42:[" + req.toString() + "]"));
            ((RestClientResponse)resp).buildResponseError(2, "HTTP\u54cd\u5e94\u9519\u8bef\u7801\uff1a" + responseStatus);
            return resp;
        }
        ((RestClientResponse)resp).buildResponseText(responseText);
        return resp;
    }

    public static OrderMemoUpdateResponse updateOrderMemo(String tid, int flag, boolean reset, String memo) {
        OrderMemoUpdateRequest req = new OrderMemoUpdateRequest();
        req.setTid(tid);
        req.setFlag(flag);
        req.setReset(reset);
        req.setMemo(memo);
        return RestClient.execute(req);
    }
}

